/*
 * Decompiled with CFR 0.152.
 */
package me.mrxbox98.LightningDeath;

import me.mrxbox98.LightningDeath.LightningDeathPlugin;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.scheduler.BukkitRunnable;

public class LightningDeathTask
extends BukkitRunnable {
    final EntityDeathEvent event;

    public LightningDeathTask(EntityDeathEvent event) {
        this.event = event;
    }

    private void strikeLightningAtEntity() {
        LivingEntity entity = this.event.getEntity();
        Player killer = entity.getKiller();
        World world = entity.getWorld();
        if (killer == null && !LightningDeathPlugin.selfInflicted) {
            if (LightningDeathPlugin.debug) {
                LightningDeathPlugin.instance.getLogger().info(entity.getName() + " died but no lightning was struck as the kill was self inflicted.");
            }
            return;
        }
        if (LightningDeathPlugin.isEntityAllowed(entity.getType())) {
            if (LightningDeathPlugin.selfInflicted || killer.hasPermission("CauseLightning")) {
                for (int i = 0; i < LightningDeathPlugin.strikes; ++i) {
                    world.strikeLightningEffect(entity.getLocation());
                }
            } else if (LightningDeathPlugin.debug) {
                LightningDeathPlugin.instance.getLogger().info(entity.getName() + " was killed but no lightning was struck because " + killer.getName() + " does not have the CauseLightning permission.");
            }
        } else if (LightningDeathPlugin.debug) {
            LightningDeathPlugin.instance.getLogger().info("A " + entity.getType().name() + " but no lightning was struck as this mob is not in the allowed mobs list in the config.yml");
        }
    }

    public void run() {
        this.strikeLightningAtEntity();
    }
}

