/*
 * Decompiled with CFR 0.152.
 */
package fr.vidsskids.pulverizer.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.vidsskids.pulverizer.Pulverizer;
import fr.vidsskids.pulverizer.utils.DiscUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;

public class Persist {
    private final Gson gson = this.buildGson().create();
    private final DiscUtil discUtil = new DiscUtil();

    public String getName(Class<?> clazz) {
        return clazz.getSimpleName().toLowerCase();
    }

    public String getName(Object object) {
        return this.getName(object.getClass());
    }

    public String getName(Type type) {
        return this.getName(type.getClass());
    }

    private GsonBuilder buildGson() {
        return new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().enableComplexMapKeySerialization().excludeFieldsWithModifiers(new int[]{128, 64});
    }

    public File getFile(String name) {
        return new File(Pulverizer.getInstance().getDataFolder(), name + ".json");
    }

    public File getFile(Class<?> clazz) {
        return this.getFile(this.getName(clazz));
    }

    public File getFile(Object obj) {
        return this.getFile(this.getName(obj));
    }

    public File getFile(Type type) {
        return this.getFile(this.getName(type));
    }

    public void save(Object instance) {
        this.save(instance, this.getFile(instance));
    }

    public void save(Object instance, File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.discUtil.writeCatch(file, this.gson.toJson(instance));
    }

    public <T> T load(Class<T> clazz) {
        return this.load(clazz, this.getFile(clazz));
    }

    public <T> T load(Class<T> clazz, File file) {
        String content = this.discUtil.readCatch(file);
        if (content == null) {
            return null;
        }
        try {
            return (T)this.gson.fromJson(content, clazz);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

