/*
 * Decompiled with CFR 0.152.
 */
package fr.vidsskids.pulverizer.utils;

import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DiscUtil {
    private final Map<String, Lock> locks = new HashMap<String, Lock>();

    public byte[] readBytes(File file) {
        int length = (int)file.length();
        byte[] output = new byte[length];
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            for (int offset = 0; offset < length; offset += in.read(output, offset, length - offset)) {
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return output;
    }

    public String read(File file) {
        return this.utf8(this.readBytes(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCatch(File file, String content) {
        Lock lock;
        String name = file.getName();
        if (this.locks.containsKey(name)) {
            lock = this.locks.get(name);
        } else {
            ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
            lock = rwl.writeLock();
            this.locks.put(name, lock);
        }
        lock.lock();
        try {
            file.createNewFile();
            Files.write((CharSequence)content, (File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            lock.unlock();
        }
    }

    public String readCatch(File file) {
        return this.read(file);
    }

    public String utf8(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

