/*
 * Decompiled with CFR 0.152.
 */
package fr.vidsskids.pulverizer.listeners;

import fr.vidsskids.pulverizer.Pulverizer;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public class PlaceListener
implements Listener {
    @EventHandler
    public void onPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        ItemStack item = event.getItemInHand();
        String language = Pulverizer.getInstance().getConfiguration().getLanguage();
        if (block.getType() == Material.FURNACE && (item.getItemMeta().getDisplayName().equals(Pulverizer.getInstance().getPulverizerName()) || item.getItemMeta().getDisplayName().equals(Pulverizer.getInstance().getPulverizerMk2Name()) || item.getItemMeta().getDisplayName().equals(Pulverizer.getInstance().getPulverizerMk3Name()))) {
            int xblock;
            Map<UUID, Map<String, String>> pulverizerLocation = Pulverizer.getInstance().getData().getPulverizerLocation();
            if (pulverizerLocation.containsKey(player.getUniqueId())) {
                event.setCancelled(true);
                xblock = Integer.parseInt(pulverizerLocation.get(player.getUniqueId()).get("x"));
                int yblock = Integer.parseInt(pulverizerLocation.get(player.getUniqueId()).get("y"));
                int zblock = Integer.parseInt(pulverizerLocation.get(player.getUniqueId()).get("z"));
                String world = pulverizerLocation.get(player.getUniqueId()).get("dimension");
                if (world.equalsIgnoreCase("normal")) {
                    world = "OVERWORLD";
                }
                switch (language) {
                    case "en": {
                        player.sendMessage(ChatColor.GREEN + "Your pulverizer is already placed here : " + ChatColor.YELLOW + "x : " + xblock + ", y : " + yblock + ", z : " + zblock + ", in the dimension : " + ChatColor.DARK_PURPLE + world);
                        break;
                    }
                    case "fr": {
                        player.sendMessage(ChatColor.GREEN + "Votre pulverizer est d\u00e9ja plac\u00e9 ici : " + ChatColor.YELLOW + "x : " + xblock + ", y : " + yblock + ", z : " + zblock + ", dans la dimension : " + ChatColor.DARK_PURPLE + world);
                        break;
                    }
                }
            } else {
                xblock = block.getLocation().getBlockX();
                int yblock = block.getLocation().getBlockY();
                int zblock = block.getLocation().getBlockZ();
                String world = player.getWorld().getEnvironment().name();
                if (item.getItemMeta().getDisplayName().equals(Pulverizer.getInstance().getPulverizerName())) {
                    Pulverizer.getInstance().setLocation(player.getUniqueId(), xblock, yblock, zblock, world, "basic");
                }
                if (item.getItemMeta().getDisplayName().equals(Pulverizer.getInstance().getPulverizerMk2Name())) {
                    Pulverizer.getInstance().setLocation(player.getUniqueId(), xblock, yblock, zblock, world, "MK2");
                }
                if (item.getItemMeta().getDisplayName().equals(Pulverizer.getInstance().getPulverizerMk3Name())) {
                    Pulverizer.getInstance().setLocation(player.getUniqueId(), xblock, yblock, zblock, world, "MK3");
                }
                if (world.equalsIgnoreCase("normal")) {
                    world = "OVERWORLD";
                }
                switch (language) {
                    case "en": {
                        player.sendMessage(ChatColor.GREEN + "Your new pulverizer is now placed here : " + ChatColor.YELLOW + "x : " + xblock + ", y : " + yblock + ", z : " + zblock + ", in the dimension : " + ChatColor.DARK_PURPLE + world);
                        break;
                    }
                    case "fr": {
                        player.sendMessage(ChatColor.GREEN + "Votre pulverizer est maintenant plac\u00e9 ici : " + ChatColor.YELLOW + "x : " + xblock + ", y : " + yblock + ", z : " + zblock + ", dans la dimension : " + ChatColor.DARK_PURPLE + world);
                        break;
                    }
                }
            }
        }
        if (item.getItemMeta().hasLore() && item.getItemMeta().getLore().equals(Pulverizer.getInstance().pulverizedItemLoreCreator())) {
            event.setCancelled(true);
            switch (language) {
                case "en": {
                    player.sendMessage(ChatColor.RED + "You cannot place this item.");
                    break;
                }
                case "fr": {
                    player.sendMessage(ChatColor.RED + "Vous ne pouvez pas placer cette item.");
                    break;
                }
            }
        }
    }
}

