/*
 * Decompiled with CFR 0.152.
 */
package fr.vidsskids.pulverizer.listeners;

import fr.vidsskids.pulverizer.Pulverizer;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;

public class BreakListener
implements Listener {
    @EventHandler
    public void onBreak(BlockBreakEvent event) {
        Map<UUID, Map<String, String>> pulverizerLocation;
        Player player = event.getPlayer();
        Block block = event.getBlock();
        String language = Pulverizer.getInstance().getConfiguration().getLanguage();
        if (block.getType() == Material.FURNACE && !(pulverizerLocation = Pulverizer.getInstance().getData().getPulverizerLocation()).isEmpty()) {
            int xblockSaved = Integer.parseInt(pulverizerLocation.get(player.getUniqueId()).get("x"));
            int yblockSaved = Integer.parseInt(pulverizerLocation.get(player.getUniqueId()).get("y"));
            int zblockSaved = Integer.parseInt(pulverizerLocation.get(player.getUniqueId()).get("z"));
            int xblockEvent = block.getLocation().getBlockX();
            int yblockEvent = block.getLocation().getBlockY();
            int zblockEvent = block.getLocation().getBlockZ();
            String worldSaved = pulverizerLocation.get(player.getUniqueId()).get("dimension");
            String worldEvent = player.getWorld().getEnvironment().name();
            String tier = pulverizerLocation.get(player.getUniqueId()).get("tier");
            if (xblockEvent == xblockSaved && yblockEvent == yblockSaved && zblockEvent == zblockSaved && worldEvent.equalsIgnoreCase(worldSaved)) {
                switch (language) {
                    case "en": {
                        player.sendMessage(ChatColor.GREEN + "You successfully removed you pulverizer");
                        break;
                    }
                    case "fr": {
                        player.sendMessage(ChatColor.GREEN + "Vous avez retir\u00e9 votre pulverizer.");
                        break;
                    }
                }
                if (player.getGameMode().name().equalsIgnoreCase("survival")) {
                    event.setDropItems(false);
                    switch (tier) {
                        case "basic": {
                            Pulverizer.getInstance().dropPulverizerProcess(event, Pulverizer.getInstance().getPulverizerName());
                            break;
                        }
                        case "MK2": {
                            Pulverizer.getInstance().dropPulverizerProcess(event, Pulverizer.getInstance().getPulverizerMk2Name());
                            break;
                        }
                        case "MK3": {
                            Pulverizer.getInstance().dropPulverizerProcess(event, Pulverizer.getInstance().getPulverizerMk3Name());
                            break;
                        }
                    }
                }
                Pulverizer.getInstance().removeLocation(player.getUniqueId(), pulverizerLocation);
            }
        }
    }
}

