/*
 * Decompiled with CFR 0.152.
 */
package fr.vidsskids.pulverizer.commands;

import fr.vidsskids.pulverizer.Pulverizer;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class ReloadCommandExecutor
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command cmd, String message, String[] args) {
        String language = Pulverizer.getInstance().getConfiguration().getLanguage();
        Player player = (Player)sender;
        if (sender instanceof Player) {
            if (args.length != 1) {
                switch (language) {
                    case "en": {
                        player.sendMessage(ChatColor.RED + "Bad usage." + ChatColor.GREEN + " The proper usage is /pulverizer <argument>.");
                        return false;
                    }
                    case "fr": {
                        player.sendMessage(ChatColor.RED + "Mauvaise utilisation." + ChatColor.GREEN + " L'usage correcte est /pulverizer <argument>.");
                        return false;
                    }
                }
                return false;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                Pulverizer.getInstance().loadConfig();
                Pulverizer.getInstance().reloadLanguageAndCraftConfig();
                switch (language) {
                    case "en": {
                        Bukkit.getLogger().info(ChatColor.GREEN + "[PULVERIZER] Successfully reload the config file.");
                        player.sendMessage(ChatColor.GREEN + "The configuration was succefully reload.");
                        break;
                    }
                    case "fr": {
                        Bukkit.getLogger().info(ChatColor.GREEN + "[PULVERIZER] Le fichier de configuration a \u00e9t\u00e9 recharg\u00e9 avec succ\u00e8s.");
                        player.sendMessage(ChatColor.GREEN + "Configuration recharg\u00e9e avec succ\u00e8s.");
                        break;
                    }
                }
                return false;
            }
            if (args[0].equalsIgnoreCase("configuration")) {
                player.openInventory(Pulverizer.getInstance().configurationGuiCreator(player));
            } else {
                switch (language) {
                    case "en": {
                        player.sendMessage(ChatColor.RED + "Bad argument. Try /pulverizer <argument>.");
                        break;
                    }
                    case "fr": {
                        player.sendMessage(ChatColor.RED + "Mauvais argument. Essayez /voteparty reload.");
                        break;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> newList = new ArrayList<String>();
        if (args.length <= 1 && sender instanceof Player) {
            newList.add("reload");
            newList.add("configuration");
            return newList;
        }
        return newList;
    }
}

