/*
 * Decompiled with CFR 0.152.
 */
package fr.vidsskids.pulverizer;

import fr.vidsskids.pulverizer.commands.ReloadCommandExecutor;
import fr.vidsskids.pulverizer.listeners.BreakListener;
import fr.vidsskids.pulverizer.listeners.InteractListener;
import fr.vidsskids.pulverizer.listeners.InventoryListener;
import fr.vidsskids.pulverizer.listeners.PlaceListener;
import fr.vidsskids.pulverizer.utils.Configuration;
import fr.vidsskids.pulverizer.utils.Data;
import fr.vidsskids.pulverizer.utils.Persist;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public final class Pulverizer
extends JavaPlugin {
    private static Pulverizer instance;
    private Persist persist;
    private Data data;
    private Configuration configuration;
    String language;

    public void onEnable() {
        Bukkit.getLogger().info("-------------------------------------------------------------------------");
        Bukkit.getLogger().info("Plugin initialized Pulverizer succesfully");
        Bukkit.getLogger().info("Created by Vids");
        Bukkit.getLogger().info("-------------------------------------------------------------------------");
        this.getDataFolder().mkdirs();
        instance = this;
        this.persist = new Persist();
        this.loadData();
        this.loadConfig();
        this.language = this.getConfiguration().getLanguage();
        this.recipeSetter();
        this.getCommand("pulverizer").setExecutor((CommandExecutor)new ReloadCommandExecutor());
        this.getServer().getPluginManager().registerEvents((Listener)new PlaceListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BreakListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InteractListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryListener(), (Plugin)this);
        this.customRecipePulverizer(this.getPulverizerName(), "basic", this.getConfiguration().getPulverizerRicipe());
        this.customRecipePulverizer(this.getPulverizerMk2Name(), "MK2", this.getConfiguration().getPulverizerMk2Ricipe());
        this.customRecipePulverizer(this.getPulverizerMk3Name(), "MK3", this.getConfiguration().getPulverizerMk3Ricipe());
    }

    public void onDisable() {
    }

    public static Pulverizer getInstance() {
        return instance;
    }

    public void loadData() {
        if (this.persist.getFile(Data.class).exists()) {
            this.data = this.persist.load(Data.class);
        } else {
            this.data = new Data();
            this.persist.save(this.data);
        }
    }

    public Data getData() {
        return this.data;
    }

    public void loadConfig() {
        if (this.persist.getFile(Configuration.class).exists()) {
            this.configuration = this.persist.load(Configuration.class);
        } else {
            this.configuration = new Configuration();
            this.persist.save(this.configuration);
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Persist getPersist() {
        return this.persist;
    }

    public void reloadLanguageAndCraftConfig() {
        Map<Integer, String> recipeMap;
        ItemStack itemInMap;
        int i;
        this.language = this.getConfiguration().getLanguage();
        this.recipeChangerInConfig(this.getConfiguration().getPulverizerRicipe(), "basic");
        this.customRecipePulverizerReplacer(this.getPulverizerName(), "basic", this.getConfiguration().getPulverizerRicipe());
        for (i = 1; i < 10; ++i) {
            itemInMap = this.decodeItem(this.getConfiguration().getPulverizerMk2Ricipe().get(i));
            if (itemInMap == null || itemInMap.getType() != Material.FURNACE || !itemInMap.getItemMeta().getDisplayName().equals(this.getPulverizerName())) continue;
            recipeMap = this.getConfiguration().getPulverizerMk2Ricipe();
            recipeMap.put(i, this.encodeItem(this.createPulverizer(this.getPulverizerName())));
            this.getConfiguration().setPulverizerMk2Ricipe(recipeMap);
            this.recipeChangerInConfig(recipeMap, "MK2");
            this.customRecipePulverizerReplacer(this.getPulverizerMk2Name(), "MK2", this.getConfiguration().getPulverizerMk2Ricipe());
        }
        for (i = 1; i < 10; ++i) {
            itemInMap = this.decodeItem(this.getConfiguration().getPulverizerMk3Ricipe().get(i));
            if (itemInMap == null || itemInMap.getType() != Material.FURNACE || !itemInMap.getItemMeta().getDisplayName().equals(this.getPulverizerMk2Name())) continue;
            recipeMap = this.getConfiguration().getPulverizerMk3Ricipe();
            recipeMap.put(i, this.encodeItem(this.createPulverizer(this.getPulverizerMk2Name())));
            this.getConfiguration().setPulverizerMk3Ricipe(recipeMap);
            this.recipeChangerInConfig(recipeMap, "MK3");
            this.customRecipePulverizerReplacer(this.getPulverizerMk3Name(), "MK3", this.getConfiguration().getPulverizerMk2Ricipe());
        }
        this.persist.save(this.configuration);
    }

    public void defaultRecipe() {
        HashMap<Integer, String> defaultPulverizerRecipe = new HashMap<Integer, String>();
        defaultPulverizerRecipe.put(1, this.encodeItem(new ItemStack(Material.FLINT)));
        defaultPulverizerRecipe.put(2, this.encodeItem(new ItemStack(Material.DIAMOND)));
        defaultPulverizerRecipe.put(3, this.encodeItem(new ItemStack(Material.FLINT)));
        defaultPulverizerRecipe.put(4, this.encodeItem(new ItemStack(Material.IRON_PICKAXE)));
        defaultPulverizerRecipe.put(5, this.encodeItem(new ItemStack(Material.IRON_BLOCK)));
        defaultPulverizerRecipe.put(6, this.encodeItem(new ItemStack(Material.IRON_PICKAXE)));
        defaultPulverizerRecipe.put(7, this.encodeItem(new ItemStack(Material.FLINT)));
        defaultPulverizerRecipe.put(8, this.encodeItem(new ItemStack(Material.DIAMOND)));
        defaultPulverizerRecipe.put(9, this.encodeItem(new ItemStack(Material.FLINT)));
        this.getConfiguration().setPulverizerRicipe(defaultPulverizerRecipe);
    }

    public void defaultRecipeMk2() {
        HashMap<Integer, String> defaultPulverizerMk2Recipe = new HashMap<Integer, String>();
        defaultPulverizerMk2Recipe.put(1, this.encodeItem(new ItemStack(Material.IRON_BLOCK)));
        defaultPulverizerMk2Recipe.put(2, this.encodeItem(new ItemStack(Material.DIAMOND_BLOCK)));
        defaultPulverizerMk2Recipe.put(3, this.encodeItem(new ItemStack(Material.IRON_BLOCK)));
        defaultPulverizerMk2Recipe.put(4, this.encodeItem(new ItemStack(Material.DIAMOND_BLOCK)));
        defaultPulverizerMk2Recipe.put(5, this.encodeItem(this.createPulverizer(this.getPulverizerName())));
        defaultPulverizerMk2Recipe.put(6, this.encodeItem(new ItemStack(Material.DIAMOND_BLOCK)));
        defaultPulverizerMk2Recipe.put(7, this.encodeItem(new ItemStack(Material.IRON_BLOCK)));
        defaultPulverizerMk2Recipe.put(8, this.encodeItem(new ItemStack(Material.DIAMOND_BLOCK)));
        defaultPulverizerMk2Recipe.put(9, this.encodeItem(new ItemStack(Material.IRON_BLOCK)));
        this.getConfiguration().setPulverizerMk2Ricipe(defaultPulverizerMk2Recipe);
    }

    public void defaultRecipeMk3() {
        HashMap<Integer, String> defaultPulverizerMk3Recipe = new HashMap<Integer, String>();
        defaultPulverizerMk3Recipe.put(1, this.encodeItem(new ItemStack(Material.DIAMOND_BLOCK)));
        defaultPulverizerMk3Recipe.put(2, this.encodeItem(new ItemStack(Material.EMERALD_BLOCK)));
        defaultPulverizerMk3Recipe.put(3, this.encodeItem(new ItemStack(Material.DIAMOND_BLOCK)));
        defaultPulverizerMk3Recipe.put(4, this.encodeItem(new ItemStack(Material.EMERALD_BLOCK)));
        defaultPulverizerMk3Recipe.put(5, this.encodeItem(this.createPulverizer(this.getPulverizerMk2Name())));
        defaultPulverizerMk3Recipe.put(6, this.encodeItem(new ItemStack(Material.EMERALD_BLOCK)));
        defaultPulverizerMk3Recipe.put(7, this.encodeItem(new ItemStack(Material.DIAMOND_BLOCK)));
        defaultPulverizerMk3Recipe.put(8, this.encodeItem(new ItemStack(Material.EMERALD_BLOCK)));
        defaultPulverizerMk3Recipe.put(9, this.encodeItem(new ItemStack(Material.DIAMOND_BLOCK)));
        this.getConfiguration().setPulverizerMk3Ricipe(defaultPulverizerMk3Recipe);
    }

    public void recipeSetter() {
        if (this.getConfiguration().getPulverizerRicipe().isEmpty() && this.getConfiguration().getPulverizerMk2Ricipe().isEmpty() && this.getConfiguration().getPulverizerMk3Ricipe().isEmpty()) {
            this.defaultRecipe();
            this.defaultRecipeMk2();
            this.defaultRecipeMk3();
            this.persist.save(this.configuration);
        }
    }

    public void defaultRecipeSetter(String key) {
        switch (key) {
            case "basic": {
                this.defaultRecipe();
                this.customRecipePulverizerReplacer(this.getPulverizerName(), "basic", this.getConfiguration().getPulverizerRicipe());
                break;
            }
            case "MK2": {
                this.defaultRecipeMk2();
                this.customRecipePulverizerReplacer(this.getPulverizerMk2Name(), "MK2", this.getConfiguration().getPulverizerMk2Ricipe());
                break;
            }
            case "MK3": {
                this.defaultRecipeMk3();
                this.customRecipePulverizerReplacer(this.getPulverizerMk3Name(), "MK3", this.getConfiguration().getPulverizerMk3Ricipe());
                break;
            }
        }
        this.persist.save(this.configuration);
    }

    public void setLocation(UUID playerId, int xblock, int yblock, int zblock, String dimension, String tier) {
        Map<UUID, Map<String, String>> pulverizerLocations = this.getData().getPulverizerLocation();
        HashMap<String, String> blockLocation = new HashMap<String, String>();
        blockLocation.put("tier", tier);
        blockLocation.put("x", String.valueOf(xblock));
        blockLocation.put("y", String.valueOf(yblock));
        blockLocation.put("z", String.valueOf(zblock));
        blockLocation.put("dimension", dimension);
        pulverizerLocations.put(playerId, blockLocation);
        this.getData().setPulverizerLocation(pulverizerLocations);
        this.persist.save(this.data);
    }

    public void setItemStackInData(UUID playerId, ItemStack item) {
        Map<UUID, Map<Material, Integer>> pulverizedItemStack = this.getData().getPulverizedItemStack();
        HashMap<Material, Integer> itemMap = new HashMap<Material, Integer>();
        itemMap.put(item.getType(), item.getAmount());
        pulverizedItemStack.put(playerId, itemMap);
        this.getData().setPulverizedItemStack(pulverizedItemStack);
        this.persist.save(this.data);
    }

    public void removeLocation(UUID playerId, Map<UUID, Map<String, String>> map) {
        map.remove(playerId);
        this.persist.save(this.data);
    }

    public void customRecipePulverizer(String pulverizerName, String keyName, Map<Integer, String> recipeMap) {
        ItemStack pulverizer = this.createPulverizer(pulverizerName);
        NamespacedKey key = new NamespacedKey((Plugin)instance, instance.getDescription().getName() + keyName);
        ShapedRecipe pulverizerRecipe = new ShapedRecipe(key, pulverizer);
        Map<Integer, String> defaultPulverizerRecipe = recipeMap;
        pulverizerRecipe.shape(new String[]{"abc", "def", "ghi"});
        if (this.decodeItem(defaultPulverizerRecipe.get(1)) != null) {
            pulverizerRecipe.setIngredient('a', this.decodeItem(defaultPulverizerRecipe.get(1)));
        }
        if (this.decodeItem(defaultPulverizerRecipe.get(2)) != null) {
            pulverizerRecipe.setIngredient('b', this.decodeItem(defaultPulverizerRecipe.get(2)));
        }
        if (this.decodeItem(defaultPulverizerRecipe.get(3)) != null) {
            pulverizerRecipe.setIngredient('c', this.decodeItem(defaultPulverizerRecipe.get(3)));
        }
        if (this.decodeItem(defaultPulverizerRecipe.get(4)) != null) {
            pulverizerRecipe.setIngredient('d', this.decodeItem(defaultPulverizerRecipe.get(4)));
        }
        if (this.decodeItem(defaultPulverizerRecipe.get(5)) != null) {
            pulverizerRecipe.setIngredient('e', this.decodeItem(defaultPulverizerRecipe.get(5)));
        }
        if (this.decodeItem(defaultPulverizerRecipe.get(6)) != null) {
            pulverizerRecipe.setIngredient('f', this.decodeItem(defaultPulverizerRecipe.get(6)));
        }
        if (this.decodeItem(defaultPulverizerRecipe.get(7)) != null) {
            pulverizerRecipe.setIngredient('g', this.decodeItem(defaultPulverizerRecipe.get(7)));
        }
        if (this.decodeItem(defaultPulverizerRecipe.get(8)) != null) {
            pulverizerRecipe.setIngredient('h', this.decodeItem(defaultPulverizerRecipe.get(8)));
        }
        if (this.decodeItem(defaultPulverizerRecipe.get(9)) != null) {
            pulverizerRecipe.setIngredient('i', this.decodeItem(defaultPulverizerRecipe.get(9)));
        }
        this.getServer().addRecipe((Recipe)pulverizerRecipe);
    }

    public void customRecipePulverizerReplacer(String pulverizerName, String key, Map<Integer, String> recipeMap) {
        NamespacedKey recipeKey = new NamespacedKey((Plugin)instance, instance.getDescription().getName() + key);
        this.getServer().removeRecipe(recipeKey);
        ItemStack pulverizer = this.createPulverizer(pulverizerName);
        ShapedRecipe pulverizerRecipe = new ShapedRecipe(recipeKey, pulverizer);
        Map<Integer, String> recipeMapPulverizer = recipeMap;
        pulverizerRecipe.shape(new String[]{"abc", "def", "ghi"});
        if (this.decodeItem(recipeMapPulverizer.get(1)) != null) {
            pulverizerRecipe.setIngredient('a', this.decodeItem(recipeMapPulverizer.get(1)));
        }
        if (this.decodeItem(recipeMapPulverizer.get(2)) != null) {
            pulverizerRecipe.setIngredient('b', this.decodeItem(recipeMapPulverizer.get(2)));
        }
        if (this.decodeItem(recipeMapPulverizer.get(3)) != null) {
            pulverizerRecipe.setIngredient('c', this.decodeItem(recipeMapPulverizer.get(3)));
        }
        if (this.decodeItem(recipeMapPulverizer.get(4)) != null) {
            pulverizerRecipe.setIngredient('d', this.decodeItem(recipeMapPulverizer.get(4)));
        }
        if (this.decodeItem(recipeMapPulverizer.get(5)) != null) {
            pulverizerRecipe.setIngredient('e', this.decodeItem(recipeMapPulverizer.get(5)));
        }
        if (this.decodeItem(recipeMapPulverizer.get(6)) != null) {
            pulverizerRecipe.setIngredient('f', this.decodeItem(recipeMapPulverizer.get(6)));
        }
        if (this.decodeItem(recipeMapPulverizer.get(7)) != null) {
            pulverizerRecipe.setIngredient('g', this.decodeItem(recipeMapPulverizer.get(7)));
        }
        if (this.decodeItem(recipeMapPulverizer.get(8)) != null) {
            pulverizerRecipe.setIngredient('h', this.decodeItem(recipeMapPulverizer.get(8)));
        }
        if (this.decodeItem(recipeMapPulverizer.get(9)) != null) {
            pulverizerRecipe.setIngredient('i', this.decodeItem(recipeMapPulverizer.get(9)));
        }
        this.getServer().addRecipe((Recipe)pulverizerRecipe);
    }

    public void recipeChangerInConfig(Map<Integer, String> recipeMap, String key) {
        switch (key) {
            case "basic": {
                this.getConfiguration().setPulverizerRicipe(recipeMap);
                break;
            }
            case "MK2": {
                this.getConfiguration().setPulverizerMk2Ricipe(recipeMap);
                break;
            }
            case "MK3": {
                this.getConfiguration().setPulverizerMk3Ricipe(recipeMap);
                break;
            }
        }
        this.persist.save(this.configuration);
    }

    public String encodeItem(ItemStack item) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream bukkitObjectOutputStream = new BukkitObjectOutputStream((OutputStream)outputStream);
            bukkitObjectOutputStream.writeObject((Object)item);
            bukkitObjectOutputStream.flush();
            String encodedItem = Base64.getEncoder().encodeToString(outputStream.toByteArray());
            return encodedItem;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ItemStack decodeItem(String encodedItem) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(encodedItem));
            BukkitObjectInputStream bukkitObjectInputStream = new BukkitObjectInputStream((InputStream)inputStream);
            ItemStack decodedItem = (ItemStack)bukkitObjectInputStream.readObject();
            return decodedItem;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getPulverizerName() {
        return ChatColor.RED + "PULVERIZER";
    }

    public String getPulverizerMk2Name() {
        return ChatColor.RED + "PULVERIZER MK2";
    }

    public String getPulverizerMk3Name() {
        return ChatColor.RED + "PULVERIZER MK3";
    }

    public String getResetRedGlassDescription() {
        switch (this.language) {
            case "en": {
                return "to reset to default the pulverier's recipe";
            }
            case "fr": {
                return "pour r\u00e9initialis\u00e9 le craft du pulverizer par d\u00e9fauts";
            }
        }
        return null;
    }

    public String getResetRedGlassName() {
        switch (this.language) {
            case "en": {
                return ChatColor.RED + "Reset Recipe";
            }
            case "fr": {
                return ChatColor.RED + "R\u00e9initialis\u00e9 la recette par d\u00e9faut";
            }
        }
        return null;
    }

    public String getSetGreenGlassName() {
        switch (this.language) {
            case "en": {
                return ChatColor.GREEN + "Set Recipe";
            }
            case "fr": {
                return ChatColor.GREEN + "Sauvegard\u00e9 la recette";
            }
        }
        return null;
    }

    public String getPulverizerGuiName() {
        return ChatColor.GOLD + "Pulverizer";
    }

    public String getPulverizerGuiNameMk2() {
        return ChatColor.GOLD + "Pulverizer MK2";
    }

    public String getPulverizerGuiNameMk3() {
        return ChatColor.GOLD + "Pulverizer MK3";
    }

    public String getConfigurationGuiName() {
        switch (this.language) {
            case "en": {
                return ChatColor.DARK_PURPLE + "Configuration interface";
            }
            case "fr": {
                return ChatColor.DARK_PURPLE + "Interface de configuration";
            }
        }
        return null;
    }

    public String getConfigurationLanguageGuiName() {
        switch (this.language) {
            case "en": {
                return ChatColor.DARK_PURPLE + "Language selector";
            }
            case "fr": {
                return ChatColor.DARK_PURPLE + "Selection du language";
            }
        }
        return null;
    }

    public String getConfigurationCraftingGuiName(String tier) {
        switch (tier) {
            case "basic": {
                switch (this.language) {
                    case "en": {
                        return ChatColor.DARK_PURPLE + "Crafting editor for basic Pulverizer";
                    }
                    case "fr": {
                        return ChatColor.DARK_PURPLE + "Editeur de craft pour le Pulverizer basique";
                    }
                }
                return null;
            }
            case "MK2": {
                switch (this.language) {
                    case "en": {
                        return ChatColor.DARK_PURPLE + "Crafting editor for MK2 Pulverizer";
                    }
                    case "fr": {
                        return ChatColor.DARK_PURPLE + "Editeur de craft pour le Pulverizer MK2";
                    }
                }
                return null;
            }
            case "MK3": {
                switch (this.language) {
                    case "en": {
                        return ChatColor.DARK_PURPLE + "Crafting editor for MK3 Pulverizer";
                    }
                    case "fr": {
                        return ChatColor.DARK_PURPLE + "Editeur de craft pour le Pulverizer MK3";
                    }
                }
                return null;
            }
        }
        return null;
    }

    public String getCraftingTableDisplayNameOldGuiName() {
        switch (this.language) {
            case "en": {
                return ChatColor.RED + "Old Recipe";
            }
            case "fr": {
                return ChatColor.RED + "Ancienne recette";
            }
        }
        return null;
    }

    public String getCraftingTableDisplayNameNewGuiName() {
        switch (this.language) {
            case "en": {
                return ChatColor.GREEN + "New Recipe";
            }
            case "fr": {
                return ChatColor.GREEN + "Nouvelle recette";
            }
        }
        return null;
    }

    public String getCraftingConfigurationGuiName() {
        switch (this.language) {
            case "en": {
                return ChatColor.DARK_PURPLE + "Crafting configuration interface";
            }
            case "fr": {
                return ChatColor.DARK_PURPLE + "Interface de configuration de craft";
            }
        }
        return null;
    }

    public ArrayList<String> redGlassLoreCreator(String description) {
        ArrayList<String> lore = new ArrayList<String>();
        if (description != null) {
            lore.add("");
            switch (this.language) {
                case "en": {
                    lore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.GREEN + "Click " + ChatColor.WHITE + description);
                    break;
                }
                case "fr": {
                    lore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.GREEN + "Cliquez " + ChatColor.WHITE + description);
                    break;
                }
            }
        }
        return lore;
    }

    public ArrayList<String> greenGlassLoreCreator(boolean ifLore) {
        ArrayList<String> lore = new ArrayList<String>();
        if (ifLore) {
            lore.add("");
            switch (this.language) {
                case "en": {
                    lore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.GREEN + "Click " + ChatColor.WHITE + "to begin the process of the pulverizer.");
                    break;
                }
                case "fr": {
                    lore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.GREEN + "Cliquez " + ChatColor.WHITE + "pour commencer le processus du pulverizer.");
                    break;
                }
            }
        }
        return lore;
    }

    public ArrayList<String> pulverizerLoreCreator() {
        ArrayList<String> pulverizerLore = new ArrayList<String>();
        switch (this.language) {
            case "fr": {
                pulverizerLore.add("");
                pulverizerLore.add(ChatColor.WHITE + "Cette item est utiliser pour dupliquer les minerais.");
                pulverizerLore.add("");
                pulverizerLore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.GREEN + "Clique Droit " + ChatColor.WHITE + "pour le placer.");
                break;
            }
            case "en": {
                pulverizerLore.add("");
                pulverizerLore.add(ChatColor.WHITE + "This item is used to grind and duplicate minecraft ore.");
                pulverizerLore.add("");
                pulverizerLore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.GREEN + "Right click " + ChatColor.WHITE + "to place it.");
                break;
            }
        }
        return pulverizerLore;
    }

    public ArrayList<String> pulverizedOutputLoreCreator(int quantity) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        switch (this.language) {
            case "en": {
                lore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.GREEN + "You will gain " + ChatColor.YELLOW + quantity + ChatColor.GREEN + " items.");
                break;
            }
            case "fr": {
                lore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.GREEN + "Vous allez obternir " + ChatColor.YELLOW + quantity + ChatColor.GREEN + " items.");
                break;
            }
        }
        return lore;
    }

    public ArrayList<String> pulverizedItemLoreCreator() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        switch (this.language) {
            case "en": {
                lore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.GREEN + "Put it " + ChatColor.WHITE + "in a furnace to turn it into vanillia items.");
                break;
            }
            case "fr": {
                lore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.GREEN + "Mettez y " + ChatColor.WHITE + "dans un four pour les transform\u00e9 en minerais basiques.");
                break;
            }
        }
        return lore;
    }

    public ItemStack addGlowingEffect(ItemStack item) {
        item.addUnsafeEnchantment(Enchantment.DAMAGE_ALL, 1);
        item.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        return item;
    }

    public ItemStack createPulverizer(String displayName) {
        ItemStack pulverizer = new ItemStack(Material.FURNACE);
        ItemMeta pulverizerMeta = pulverizer.getItemMeta();
        pulverizerMeta.setDisplayName(displayName);
        pulverizerMeta.setLore(this.pulverizerLoreCreator());
        pulverizer.setItemMeta(pulverizerMeta);
        this.addGlowingEffect(pulverizer);
        return pulverizer;
    }

    public ItemStack blackGlassCreator() {
        ItemStack blackGlass = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta blackGlassMeta = blackGlass.getItemMeta();
        blackGlassMeta.setDisplayName(" ");
        blackGlass.setItemMeta(blackGlassMeta);
        return blackGlass;
    }

    public ItemStack redGlassCreator(String name, String description) {
        ItemStack redGlass = new ItemStack(Material.RED_STAINED_GLASS_PANE);
        ItemMeta redGlassMeta = redGlass.getItemMeta();
        redGlassMeta.setDisplayName(ChatColor.RED + name);
        redGlassMeta.setLore(this.redGlassLoreCreator(description));
        redGlass.setItemMeta(redGlassMeta);
        return redGlass;
    }

    public ItemStack greenGlassCreator(String name, boolean ifLore) {
        ItemStack greenGlass = new ItemStack(Material.GREEN_STAINED_GLASS_PANE);
        ItemMeta greenGlassMeta = greenGlass.getItemMeta();
        greenGlassMeta.setDisplayName(ChatColor.GREEN + name);
        greenGlassMeta.setLore(this.greenGlassLoreCreator(ifLore));
        greenGlass.setItemMeta(greenGlassMeta);
        return greenGlass;
    }

    public ItemStack greenGlassCraftingGuiCreator(String name) {
        ItemStack greenGlass = new ItemStack(Material.GREEN_STAINED_GLASS_PANE);
        ItemMeta greenGlassMeta = greenGlass.getItemMeta();
        greenGlassMeta.setDisplayName(ChatColor.GREEN + name);
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("");
        switch (this.language) {
            case "en": {
                lore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.GREEN + "Click " + ChatColor.WHITE + "to set the pulverizer's recipe.");
                break;
            }
            case "fr": {
                lore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.GREEN + "Cliquez " + ChatColor.WHITE + "pour sauvegarder la recette du pulverizer.");
                break;
            }
        }
        greenGlassMeta.setLore(lore);
        greenGlass.setItemMeta(greenGlassMeta);
        return greenGlass;
    }

    public ItemStack yellowGlassCreator(String name) {
        ItemStack yellowGlass = new ItemStack(Material.YELLOW_STAINED_GLASS_PANE);
        ItemMeta yellowGlassMeta = yellowGlass.getItemMeta();
        yellowGlassMeta.setDisplayName(ChatColor.YELLOW + name);
        yellowGlass.setItemMeta(yellowGlassMeta);
        return yellowGlass;
    }

    public ItemStack craftingTableInConfigurationGuiCreator() {
        ItemStack table = new ItemStack(Material.CRAFTING_TABLE);
        ItemMeta tableMeta = table.getItemMeta();
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("");
        switch (this.language) {
            case "en": {
                tableMeta.setDisplayName(ChatColor.YELLOW + "Crafting Editor");
                lore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.GREEN + "Click " + ChatColor.WHITE + "to edit the craft of the pulverizer.");
                break;
            }
            case "fr": {
                tableMeta.setDisplayName(ChatColor.YELLOW + "Editeur de Craft");
                lore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.GREEN + "Cliquez " + ChatColor.WHITE + "pour modifier le craft du pulverizer.");
                break;
            }
        }
        tableMeta.setLore(lore);
        table.setItemMeta(tableMeta);
        return table;
    }

    public ItemStack craftingTableInCraftingGuiCreator(String displayName) {
        ItemStack table = new ItemStack(Material.CRAFTING_TABLE);
        ItemMeta tableMeta = table.getItemMeta();
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("");
        tableMeta.setDisplayName(ChatColor.YELLOW + displayName);
        if (displayName.equals(this.getCraftingTableDisplayNameOldGuiName())) {
            switch (this.language) {
                case "en": {
                    lore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.RED + "Here " + ChatColor.WHITE + "is the recipe save in config file");
                    break;
                }
                case "fr": {
                    lore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.RED + "Ici " + ChatColor.WHITE + "se trouve la recette sauvegarder dans le fichier config.");
                    break;
                }
            }
        }
        if (displayName.equals(this.getCraftingTableDisplayNameNewGuiName())) {
            switch (this.language) {
                case "en": {
                    lore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.GREEN + "Here " + ChatColor.WHITE + "you can set your own custom recipe.");
                    break;
                }
                case "fr": {
                    lore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.GREEN + "Ici " + ChatColor.WHITE + "vous pouvez mettre votre propre recette.");
                    break;
                }
            }
        }
        tableMeta.setLore(lore);
        table.setItemMeta(tableMeta);
        return table;
    }

    public ItemStack paperInConfigurationGuiCreator() {
        ItemStack paper = new ItemStack(Material.PAPER);
        ItemMeta paperMeta = paper.getItemMeta();
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("");
        switch (this.language) {
            case "en": {
                paperMeta.setDisplayName(ChatColor.YELLOW + "Language Selector");
                lore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.GREEN + "Click " + ChatColor.WHITE + "to change the language.");
                lore.add(ChatColor.RED + "The actual language is : " + ChatColor.DARK_PURPLE + "English.");
                break;
            }
            case "fr": {
                paperMeta.setDisplayName(ChatColor.YELLOW + "Editeur de Craft");
                lore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.GREEN + "Cliquez " + ChatColor.WHITE + "pour changer la langue.");
                lore.add(ChatColor.RED + "Le language actuelle est : " + ChatColor.DARK_PURPLE + "Fran\u00e7ais.");
                break;
            }
        }
        paperMeta.setLore(lore);
        paper.setItemMeta(paperMeta);
        return paper;
    }

    public ItemStack paperInLanguageSelectorCreator(String displayName) {
        ItemStack paper = new ItemStack(Material.PAPER);
        ItemMeta paperMeta = paper.getItemMeta();
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("");
        paperMeta.setDisplayName(ChatColor.YELLOW + displayName);
        switch (this.language) {
            case "en": {
                lore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.GREEN + "Click " + ChatColor.WHITE + "to set the language.");
                if (!displayName.equals(ChatColor.YELLOW + "ENGLISH")) break;
                lore.add(ChatColor.RED + "Language actually set.");
                break;
            }
            case "fr": {
                lore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.GREEN + "Cliquez " + ChatColor.WHITE + "pour param\u00e9trer la langue.");
                if (!displayName.equals(ChatColor.YELLOW + "FRANCAIS")) break;
                lore.add(ChatColor.RED + "Langue actuellement s\u00e9l\u00e9ctionn\u00e9.");
                break;
            }
        }
        paperMeta.setLore(lore);
        paper.setItemMeta(paperMeta);
        return paper;
    }

    public ItemStack backCreator() {
        ItemStack compass = new ItemStack(Material.COMPASS);
        ItemMeta compassMeta = compass.getItemMeta();
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("");
        switch (this.language) {
            case "en": {
                compassMeta.setDisplayName(ChatColor.RED + "BACK");
                lore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.GREEN + "Click " + ChatColor.WHITE + "to back to the main menu.");
                break;
            }
            case "fr": {
                compassMeta.setDisplayName(ChatColor.RED + "RETOUR");
                lore.add(ChatColor.YELLOW + "\u00bb " + ChatColor.GREEN + "Clique " + ChatColor.WHITE + "pour retourner au menu principale.");
                break;
            }
        }
        compassMeta.setLore(lore);
        compass.setItemMeta(compassMeta);
        return compass;
    }

    public ItemStack pulverizedItemOutputCreator(Material type, String name, Inventory inv, int multiplicator) {
        ItemStack item = new ItemStack(type);
        ItemMeta itemMeta = item.getItemMeta();
        int quantity = inv.getItem(19).getAmount();
        switch (this.language) {
            case "en": {
                itemMeta.setDisplayName(ChatColor.BLUE + "Pulverized " + name);
                break;
            }
            case "fr": {
                itemMeta.setDisplayName(ChatColor.BLUE + "Poudre de " + name);
                break;
            }
        }
        itemMeta.setLore(this.pulverizedOutputLoreCreator(multiplicator * quantity));
        item.setItemMeta(itemMeta);
        this.addGlowingEffect(item);
        return item;
    }

    public ItemStack pulverizedItemCreator(ItemStack item, String name) {
        ItemMeta itemMeta = item.getItemMeta();
        switch (this.language) {
            case "en": {
                itemMeta.setDisplayName(ChatColor.BLUE + "Pulverized " + name);
                break;
            }
            case "fr": {
                itemMeta.setDisplayName(ChatColor.BLUE + "Poudre de " + name);
                break;
            }
        }
        itemMeta.setLore(this.pulverizedItemLoreCreator());
        item.setItemMeta(itemMeta);
        this.addGlowingEffect(item);
        return item;
    }

    public Inventory pulverizerGuiCreator(Player player, String name) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)45, (String)name);
        ItemStack blackGlass = this.blackGlassCreator();
        for (int i = 0; i < 45; ++i) {
            inv.setItem(i, blackGlass);
        }
        inv.setItem(19, null);
        switch (this.language) {
            case "en": {
                inv.setItem(25, this.redGlassCreator("Output", null));
                inv.setItem(28, this.redGlassCreator("Confirm Input", "to confirm the input of the pulverizer."));
                break;
            }
            case "fr": {
                inv.setItem(25, this.redGlassCreator("Sortie", null));
                inv.setItem(28, this.redGlassCreator("Confirmez l'entr\u00e9e", "pour confirmer l'entr\u00e9e du pulverizer."));
                break;
            }
        }
        return inv;
    }

    public Inventory configurationGuiCreator(Player player) {
        int i;
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)27, (String)this.getConfigurationGuiName());
        ItemStack blackGlass = this.blackGlassCreator();
        for (i = 0; i < 10; ++i) {
            inv.setItem(i, blackGlass);
        }
        for (i = 17; i < 27; ++i) {
            inv.setItem(i, blackGlass);
        }
        inv.setItem(12, this.craftingTableInConfigurationGuiCreator());
        inv.setItem(14, this.paperInConfigurationGuiCreator());
        return inv;
    }

    public Inventory configurationCraftingGuiCreator(Player player) {
        int i;
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)27, (String)this.getCraftingConfigurationGuiName());
        ItemStack blackGlass = this.blackGlassCreator();
        for (i = 0; i < 10; ++i) {
            inv.setItem(i, blackGlass);
        }
        for (i = 17; i < 27; ++i) {
            inv.setItem(i, blackGlass);
        }
        inv.setItem(12, this.createPulverizer(this.getPulverizerName()));
        inv.setItem(13, this.createPulverizer(this.getPulverizerMk2Name()));
        inv.setItem(14, this.createPulverizer(this.getPulverizerMk3Name()));
        inv.setItem(16, this.backCreator());
        return inv;
    }

    public Inventory configurationLanguageGuiCreator(Player player) {
        int i;
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)27, (String)this.getConfigurationLanguageGuiName());
        ItemStack blackGlass = this.blackGlassCreator();
        for (i = 0; i < 10; ++i) {
            inv.setItem(i, blackGlass);
        }
        for (i = 17; i < 27; ++i) {
            inv.setItem(i, blackGlass);
        }
        inv.setItem(13, this.backCreator());
        switch (this.language) {
            case "en": {
                ItemStack paperEnglish = this.paperInLanguageSelectorCreator(ChatColor.YELLOW + "ENGLISH");
                ItemStack paperFrench = this.paperInLanguageSelectorCreator(ChatColor.YELLOW + "FRENCH");
                paperEnglish = this.addGlowingEffect(paperEnglish);
                inv.setItem(11, paperEnglish);
                inv.setItem(15, paperFrench);
                break;
            }
            case "fr": {
                ItemStack paperEnglish = this.paperInLanguageSelectorCreator(ChatColor.YELLOW + "ANGLAIS");
                ItemStack paperFrench = this.paperInLanguageSelectorCreator(ChatColor.YELLOW + "FRANCAIS");
                paperFrench = this.addGlowingEffect(paperFrench);
                inv.setItem(11, paperEnglish);
                inv.setItem(15, paperFrench);
                break;
            }
        }
        return inv;
    }

    public Inventory configurationCraftingPulverizerGuiCreator(Player player, String name) {
        int i;
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)45, (String)name);
        ItemStack blackGlass = this.blackGlassCreator();
        for (i = 0; i < 10; ++i) {
            inv.setItem(i, blackGlass);
        }
        inv.setItem(9, blackGlass);
        inv.setItem(13, blackGlass);
        inv.setItem(17, blackGlass);
        inv.setItem(27, blackGlass);
        inv.setItem(31, blackGlass);
        for (i = 35; i < 45; ++i) {
            inv.setItem(i, blackGlass);
        }
        inv.setItem(2, this.craftingTableInCraftingGuiCreator(this.getCraftingTableDisplayNameOldGuiName()));
        inv.setItem(6, this.craftingTableInCraftingGuiCreator(this.getCraftingTableDisplayNameNewGuiName()));
        inv.setItem(18, this.redGlassCreator(this.getResetRedGlassName(), this.getResetRedGlassDescription()));
        inv.setItem(26, this.greenGlassCraftingGuiCreator(this.getSetGreenGlassName()));
        inv.setItem(44, this.backCreator());
        if (name.equals(this.getConfigurationCraftingGuiName("basic"))) {
            Map<Integer, String> recipePulverizerBasicMap = this.getConfiguration().getPulverizerRicipe();
            inv.setItem(10, this.decodeItem(recipePulverizerBasicMap.get(1)));
            inv.setItem(11, this.decodeItem(recipePulverizerBasicMap.get(2)));
            inv.setItem(12, this.decodeItem(recipePulverizerBasicMap.get(3)));
            inv.setItem(19, this.decodeItem(recipePulverizerBasicMap.get(4)));
            inv.setItem(20, this.decodeItem(recipePulverizerBasicMap.get(5)));
            inv.setItem(21, this.decodeItem(recipePulverizerBasicMap.get(6)));
            inv.setItem(22, this.createPulverizer(this.getPulverizerName()));
            inv.setItem(28, this.decodeItem(recipePulverizerBasicMap.get(7)));
            inv.setItem(29, this.decodeItem(recipePulverizerBasicMap.get(8)));
            inv.setItem(30, this.decodeItem(recipePulverizerBasicMap.get(9)));
        }
        if (name.equals(this.getConfigurationCraftingGuiName("MK2"))) {
            Map<Integer, String> recipePulverizerMk2Map = this.getConfiguration().getPulverizerMk2Ricipe();
            inv.setItem(10, this.decodeItem(recipePulverizerMk2Map.get(1)));
            inv.setItem(11, this.decodeItem(recipePulverizerMk2Map.get(2)));
            inv.setItem(12, this.decodeItem(recipePulverizerMk2Map.get(3)));
            inv.setItem(19, this.decodeItem(recipePulverizerMk2Map.get(4)));
            inv.setItem(20, this.decodeItem(recipePulverizerMk2Map.get(5)));
            inv.setItem(21, this.decodeItem(recipePulverizerMk2Map.get(6)));
            inv.setItem(22, this.createPulverizer(this.getPulverizerMk2Name()));
            inv.setItem(28, this.decodeItem(recipePulverizerMk2Map.get(7)));
            inv.setItem(29, this.decodeItem(recipePulverizerMk2Map.get(8)));
            inv.setItem(30, this.decodeItem(recipePulverizerMk2Map.get(9)));
        }
        if (name.equals(this.getConfigurationCraftingGuiName("MK3"))) {
            Map<Integer, String> recipePulverizerMk3Map = this.getConfiguration().getPulverizerMk3Ricipe();
            inv.setItem(10, this.decodeItem(recipePulverizerMk3Map.get(1)));
            inv.setItem(11, this.decodeItem(recipePulverizerMk3Map.get(2)));
            inv.setItem(12, this.decodeItem(recipePulverizerMk3Map.get(3)));
            inv.setItem(19, this.decodeItem(recipePulverizerMk3Map.get(4)));
            inv.setItem(20, this.decodeItem(recipePulverizerMk3Map.get(5)));
            inv.setItem(21, this.decodeItem(recipePulverizerMk3Map.get(6)));
            inv.setItem(22, this.createPulverizer(this.getPulverizerMk3Name()));
            inv.setItem(28, this.decodeItem(recipePulverizerMk3Map.get(7)));
            inv.setItem(29, this.decodeItem(recipePulverizerMk3Map.get(8)));
            inv.setItem(30, this.decodeItem(recipePulverizerMk3Map.get(9)));
        }
        return inv;
    }

    public Inventory addOutputPulverizerGui(Inventory inv, int multiplicator) {
        if (!inv.getItem(19).getItemMeta().hasLore()) {
            block0 : switch (inv.getItem(19).getType()) {
                case COAL_ORE: {
                    switch (this.language) {
                        case "en": {
                            inv.setItem(25, this.pulverizedItemOutputCreator(Material.COAL_ORE, "Coal", inv, multiplicator));
                            inv.setItem(28, this.greenGlassCreator("CONFIRM", true));
                            inv.setItem(37, this.redGlassCreator("CANCEL", "to cancel."));
                            break block0;
                        }
                        case "fr": {
                            inv.setItem(25, this.pulverizedItemOutputCreator(Material.COAL_ORE, "Charbon", inv, multiplicator));
                            inv.setItem(28, this.greenGlassCreator("CONFIRMEZ", true));
                            inv.setItem(37, this.redGlassCreator("ANNULEZ", "pour annulez."));
                            break block0;
                        }
                    }
                    break;
                }
                case IRON_ORE: {
                    switch (this.language) {
                        case "en": {
                            inv.setItem(25, this.pulverizedItemOutputCreator(Material.IRON_ORE, "Iron", inv, multiplicator));
                            inv.setItem(28, this.greenGlassCreator("CONFIRM", true));
                            inv.setItem(37, this.redGlassCreator("CANCEL", "to cancel."));
                            break block0;
                        }
                        case "fr": {
                            inv.setItem(25, this.pulverizedItemOutputCreator(Material.IRON_ORE, "Fer", inv, multiplicator));
                            inv.setItem(28, this.greenGlassCreator("CONFIRMEZ", true));
                            inv.setItem(37, this.redGlassCreator("ANNULEZ", "pour annuler."));
                            break block0;
                        }
                    }
                    break;
                }
                case GOLD_ORE: {
                    switch (this.language) {
                        case "en": {
                            inv.setItem(25, this.pulverizedItemOutputCreator(Material.GOLD_ORE, "Gold", inv, multiplicator));
                            inv.setItem(28, this.greenGlassCreator("CONFIRM", true));
                            inv.setItem(37, this.redGlassCreator("CANCEL", "to cancel."));
                            break block0;
                        }
                        case "fr": {
                            inv.setItem(25, this.pulverizedItemOutputCreator(Material.GOLD_ORE, "Or", inv, multiplicator));
                            inv.setItem(28, this.greenGlassCreator("CONFIRMEZ", true));
                            inv.setItem(37, this.redGlassCreator("ANNULEZ", "pour annuler."));
                            break block0;
                        }
                    }
                    break;
                }
                case DIAMOND_ORE: {
                    switch (this.language) {
                        case "en": {
                            inv.setItem(25, this.pulverizedItemOutputCreator(Material.DIAMOND_ORE, "Diamond", inv, multiplicator));
                            inv.setItem(28, this.greenGlassCreator("CONFIRM", true));
                            inv.setItem(37, this.redGlassCreator("CANCEL", "to cancel."));
                            break block0;
                        }
                        case "fr": {
                            inv.setItem(25, this.pulverizedItemOutputCreator(Material.DIAMOND_ORE, "Diamant", inv, multiplicator));
                            inv.setItem(28, this.greenGlassCreator("CONFIRMEZ", true));
                            inv.setItem(37, this.redGlassCreator("ANNULEZ", "pour annuler."));
                            break block0;
                        }
                    }
                    break;
                }
                case REDSTONE_ORE: {
                    switch (this.language) {
                        case "en": {
                            inv.setItem(25, this.pulverizedItemOutputCreator(Material.REDSTONE_ORE, "Redstone", inv, multiplicator));
                            inv.setItem(28, this.greenGlassCreator("CONFIRM", true));
                            inv.setItem(37, this.redGlassCreator("CANCEL", "to cancel."));
                            break block0;
                        }
                        case "fr": {
                            inv.setItem(25, this.pulverizedItemOutputCreator(Material.REDSTONE_ORE, "Redstone", inv, multiplicator));
                            inv.setItem(28, this.greenGlassCreator("CONFIRMEZ", true));
                            inv.setItem(37, this.redGlassCreator("ANNULEZ", "pour annuler."));
                            break block0;
                        }
                    }
                    break;
                }
                case LAPIS_ORE: {
                    switch (this.language) {
                        case "en": {
                            inv.setItem(25, this.pulverizedItemOutputCreator(Material.LAPIS_ORE, "Lapis", inv, multiplicator));
                            inv.setItem(28, this.greenGlassCreator("CONFIRM", true));
                            inv.setItem(37, this.redGlassCreator("CANCEL", "to cancel."));
                            break block0;
                        }
                        case "fr": {
                            inv.setItem(25, this.pulverizedItemOutputCreator(Material.LAPIS_ORE, "Lapis", inv, multiplicator));
                            inv.setItem(28, this.greenGlassCreator("CONFIRMEZ", true));
                            inv.setItem(37, this.redGlassCreator("ANULLEZ", "pour annuler."));
                            break block0;
                        }
                    }
                    break;
                }
            }
            return inv;
        }
        return inv;
    }

    public void processPulverizer(final Inventory inv, final Player player, long timerModifier, final int multiplier) {
        switch (this.language) {
            case "en": {
                inv.setItem(19, this.yellowGlassCreator("The process is Starting."));
                break;
            }
            case "fr": {
                inv.setItem(19, this.yellowGlassCreator("Le processus est sur le point de commencer."));
                break;
            }
        }
        inv.setItem(28, this.blackGlassCreator());
        inv.setItem(37, this.blackGlassCreator());
        final HashMap<UUID, Inventory> pulverizerInventory = new HashMap<UUID, Inventory>();
        pulverizerInventory.put(player.getUniqueId(), inv);
        this.getData().setPulverizerInventory(pulverizerInventory);
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                inv.setItem(20, Pulverizer.this.yellowGlassCreator("20%"));
                inv.setItem(19, Pulverizer.this.blackGlassCreator());
                pulverizerInventory.put(player.getUniqueId(), inv);
                Pulverizer.this.getData().setPulverizerInventory(pulverizerInventory);
            }
        }, 100L / timerModifier);
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                switch (Pulverizer.this.language) {
                    case "en": {
                        inv.setItem(20, Pulverizer.this.greenGlassCreator("FINISHED", false));
                        break;
                    }
                    case "fr": {
                        inv.setItem(20, Pulverizer.this.greenGlassCreator("FINI", false));
                        break;
                    }
                }
                inv.setItem(21, Pulverizer.this.yellowGlassCreator("40%"));
                pulverizerInventory.put(player.getUniqueId(), inv);
                Pulverizer.this.getData().setPulverizerInventory(pulverizerInventory);
            }
        }, 200L / timerModifier);
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                switch (Pulverizer.this.language) {
                    case "en": {
                        inv.setItem(21, Pulverizer.this.greenGlassCreator("FINISHED", false));
                        break;
                    }
                    case "fr": {
                        inv.setItem(21, Pulverizer.this.greenGlassCreator("FINI", false));
                        break;
                    }
                }
                inv.setItem(22, Pulverizer.this.yellowGlassCreator("60%"));
                inv.setItem(4, Pulverizer.this.yellowGlassCreator("60%"));
                inv.setItem(40, Pulverizer.this.yellowGlassCreator("60%"));
                pulverizerInventory.put(player.getUniqueId(), inv);
                Pulverizer.this.getData().setPulverizerInventory(pulverizerInventory);
            }
        }, 300L / timerModifier);
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                switch (Pulverizer.this.language) {
                    case "en": {
                        inv.setItem(22, Pulverizer.this.greenGlassCreator("FINISHED", false));
                        inv.setItem(4, Pulverizer.this.greenGlassCreator("FINISHED", false));
                        inv.setItem(40, Pulverizer.this.greenGlassCreator("FINISHED", false));
                        break;
                    }
                    case "fr": {
                        inv.setItem(22, Pulverizer.this.greenGlassCreator("FINI", false));
                        inv.setItem(4, Pulverizer.this.greenGlassCreator("FINI", false));
                        inv.setItem(40, Pulverizer.this.greenGlassCreator("FINI", false));
                        break;
                    }
                }
                inv.setItem(23, Pulverizer.this.yellowGlassCreator("80%"));
                inv.setItem(14, Pulverizer.this.yellowGlassCreator("80%"));
                inv.setItem(32, Pulverizer.this.yellowGlassCreator("80%"));
                pulverizerInventory.put(player.getUniqueId(), inv);
                Pulverizer.this.getData().setPulverizerInventory(pulverizerInventory);
            }
        }, 400L / timerModifier);
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                switch (Pulverizer.this.language) {
                    case "en": {
                        inv.setItem(23, Pulverizer.this.greenGlassCreator("FINISHED", false));
                        inv.setItem(14, Pulverizer.this.greenGlassCreator("FINISHED", false));
                        inv.setItem(32, Pulverizer.this.greenGlassCreator("FINISHED", false));
                        break;
                    }
                    case "fr": {
                        inv.setItem(23, Pulverizer.this.greenGlassCreator("FINI", false));
                        inv.setItem(14, Pulverizer.this.greenGlassCreator("FINI", false));
                        inv.setItem(32, Pulverizer.this.greenGlassCreator("FINI", false));
                        break;
                    }
                }
                inv.setItem(24, Pulverizer.this.greenGlassCreator("99%", false));
                pulverizerInventory.put(player.getUniqueId(), inv);
                Pulverizer.this.getData().setPulverizerInventory(pulverizerInventory);
            }
        }, 500L / timerModifier);
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                ItemStack item;
                switch (Pulverizer.this.language) {
                    case "en": {
                        inv.setItem(24, Pulverizer.this.greenGlassCreator("FINISHED", false));
                        break;
                    }
                    case "fr": {
                        inv.setItem(24, Pulverizer.this.greenGlassCreator("FINI", false));
                        break;
                    }
                }
                Set<Material> keySet = Pulverizer.this.getData().getPulverizedItemStack().get(player.getUniqueId()).keySet();
                Material[] materialArray = keySet.toArray(new Material[0]);
                int amount = Pulverizer.this.getData().getPulverizedItemStack().get(player.getUniqueId()).get(materialArray[0]) * multiplier;
                Set<Material> itemStackName = Pulverizer.this.data.getPulverizedItemStack().get(player.getUniqueId()).keySet();
                String materialName = String.valueOf(itemStackName);
                materialName = materialName.replace("[", "");
                materialName = materialName.replace("_", " ");
                materialName = materialName.replace("]", "");
                block12 : switch (Pulverizer.this.language) {
                    case "en": {
                        switch (materialName) {
                            case "DIAMOND ORE": {
                                materialName = "Diamond";
                                break block12;
                            }
                            case "IRON ORE": {
                                materialName = "Iron";
                                break block12;
                            }
                            case "COAL ORE": {
                                materialName = "Coal";
                                break block12;
                            }
                            case "LAPIS ORE": {
                                materialName = "Lapis";
                                break block12;
                            }
                            case "REDSTONE ORE": {
                                materialName = "Redstone";
                                break block12;
                            }
                            case "GOLD ORE": {
                                materialName = "Gold";
                                break block12;
                            }
                        }
                        break;
                    }
                    case "fr": {
                        switch (materialName) {
                            case "DIAMOND ORE": {
                                materialName = "Diamand";
                                break block12;
                            }
                            case "IRON ORE": {
                                materialName = "Fer";
                                break block12;
                            }
                            case "COAL ORE": {
                                materialName = "Charbon";
                                break block12;
                            }
                            case "LAPIS ORE": {
                                materialName = "Lapis";
                                break block12;
                            }
                            case "REDSTONE ORE": {
                                materialName = "Redstone";
                                break block12;
                            }
                            case "GOLD ORE": {
                                materialName = "Or";
                                break block12;
                            }
                        }
                        break;
                    }
                }
                while (amount > 64) {
                    item = new ItemStack(materialArray[0], 64);
                    player.getInventory().addItem(new ItemStack[]{Pulverizer.this.pulverizedItemCreator(item, materialName)});
                    amount -= 64;
                }
                item = new ItemStack(materialArray[0], amount);
                player.getInventory().addItem(new ItemStack[]{Pulverizer.this.pulverizedItemCreator(item, materialName)});
                Pulverizer.this.getData().setPulverizerInventory(pulverizerInventory);
            }
        }, 600L / timerModifier);
    }

    public void dropPulverizerProcess(BlockBreakEvent event, String name) {
        ItemStack pulverizerDropBuilder = this.createPulverizer(name);
        event.getBlock().getDrops(pulverizerDropBuilder).clear();
        event.getPlayer().getWorld().dropItemNaturally(event.getBlock().getLocation(), pulverizerDropBuilder);
    }

    public void craftingGuiProcess(InventoryClickEvent event, String pulverizerName, String key) {
        ItemStack item = event.getCurrentItem();
        Inventory inv = event.getInventory();
        Player player = (Player)event.getWhoClicked();
        String titleEvent = event.getView().getTitle();
        String language = Pulverizer.getInstance().getConfiguration().getLanguage();
        if (!(event.getSlot() != 10 && event.getSlot() != 11 && event.getSlot() != 12 && event.getSlot() != 19 && event.getSlot() != 20 && event.getSlot() != 21 && event.getSlot() != 22 && event.getSlot() != 28 && event.getSlot() != 29 && event.getSlot() != 30 || event.getClickedInventory().getType().name().equals("PLAYER"))) {
            event.setCancelled(true);
        }
        block0 : switch (item.getType()) {
            case BLACK_STAINED_GLASS_PANE: 
            case CRAFTING_TABLE: {
                event.setCancelled(true);
                break;
            }
            case RED_STAINED_GLASS_PANE: {
                this.defaultRecipeSetter(key);
                switch (language) {
                    case "en": {
                        player.sendMessage(ChatColor.GREEN + "Recipe reset to default");
                        break;
                    }
                    case "fr": {
                        player.sendMessage(ChatColor.GREEN + "Recette r\u00e9initialis\u00e9 par d\u00e9faut avec succ\u00e8s");
                        break;
                    }
                }
                player.openInventory(this.configurationCraftingPulverizerGuiCreator(player, titleEvent));
                break;
            }
            case GREEN_STAINED_GLASS_PANE: {
                event.setCancelled(true);
                if (inv.getItem(14) == null && inv.getItem(15) == null && inv.getItem(16) == null && inv.getItem(23) == null && inv.getItem(24) == null && inv.getItem(25) == null && inv.getItem(32) == null && inv.getItem(33) == null && inv.getItem(34) == null) {
                    switch (language) {
                        case "en": {
                            player.sendMessage(ChatColor.RED + "Cannot set empty recipe.");
                            break block0;
                        }
                        case "fr": {
                            player.sendMessage(ChatColor.RED + "Impossible de sauvegarder une recette vide.");
                            break block0;
                        }
                    }
                    break;
                }
                switch (language) {
                    case "en": {
                        player.sendMessage(ChatColor.GREEN + "Recipe set succefully.");
                        break;
                    }
                    case "fr": {
                        player.sendMessage(ChatColor.GREEN + "Recette sauvegard\u00e9 avec succ\u00e8s.");
                        break;
                    }
                }
                HashMap<Integer, String> recipeMap = new HashMap<Integer, String>();
                recipeMap.put(1, this.encodeItem(inv.getItem(14)));
                recipeMap.put(2, this.encodeItem(inv.getItem(15)));
                recipeMap.put(3, this.encodeItem(inv.getItem(16)));
                recipeMap.put(4, this.encodeItem(inv.getItem(23)));
                recipeMap.put(5, this.encodeItem(inv.getItem(24)));
                recipeMap.put(6, this.encodeItem(inv.getItem(25)));
                recipeMap.put(7, this.encodeItem(inv.getItem(32)));
                recipeMap.put(8, this.encodeItem(inv.getItem(33)));
                recipeMap.put(9, this.encodeItem(inv.getItem(34)));
                this.recipeChangerInConfig(recipeMap, key);
                this.customRecipePulverizerReplacer(pulverizerName, key, recipeMap);
                player.openInventory(this.configurationCraftingPulverizerGuiCreator(player, titleEvent));
                break;
            }
            case COMPASS: {
                player.openInventory(Pulverizer.getInstance().configurationCraftingGuiCreator(player));
                break;
            }
        }
    }
}

