/*
 * Decompiled with CFR 0.152.
 */
package org.mineskin;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.mineskin.SkinOptions;
import org.mineskin.data.MineskinException;
import org.mineskin.data.Skin;
import org.mineskin.data.SkinCallback;

public class MineskinClient {
    private static final String API_BASE = "https://api.mineskin.org";
    private static final String GENERATE_BASE = "https://api.mineskin.org/generate";
    private static final String GET_BASE = "https://api.mineskin.org/get";
    private static final String ID_FORMAT = "https://api.mineskin.org/get/id/%s";
    private static final String URL_FORMAT = "https://api.mineskin.org/generate/url?url=%s&%s";
    private static final String UPLOAD_FORMAT = "https://api.mineskin.org/generate/upload?%s";
    private static final String USER_FORMAT = "https://api.mineskin.org/generate/user/%s?%s";
    private final Executor requestExecutor;
    private final String userAgent;
    private final String apiKey;
    private final JsonParser jsonParser = new JsonParser();
    private final Gson gson = new Gson();
    private long nextRequest = 0L;

    @Deprecated
    public MineskinClient() {
        this.requestExecutor = Executors.newSingleThreadExecutor();
        this.userAgent = "MineSkin-JavaClient";
        this.apiKey = null;
    }

    @Deprecated
    public MineskinClient(Executor requestExecutor) {
        this.requestExecutor = (Executor)Preconditions.checkNotNull((Object)requestExecutor);
        this.userAgent = "MineSkin-JavaClient";
        this.apiKey = null;
    }

    public MineskinClient(String userAgent) {
        this.requestExecutor = Executors.newSingleThreadExecutor();
        this.userAgent = (String)Preconditions.checkNotNull((Object)userAgent);
        this.apiKey = null;
    }

    public MineskinClient(String userAgent, String apiKey) {
        this.requestExecutor = Executors.newSingleThreadExecutor();
        this.userAgent = (String)Preconditions.checkNotNull((Object)userAgent);
        this.apiKey = apiKey;
    }

    public MineskinClient(Executor requestExecutor, String userAgent, String apiKey) {
        this.requestExecutor = (Executor)Preconditions.checkNotNull((Object)requestExecutor);
        this.userAgent = (String)Preconditions.checkNotNull((Object)userAgent);
        this.apiKey = apiKey;
    }

    public MineskinClient(Executor requestExecutor, String userAgent) {
        this.requestExecutor = (Executor)Preconditions.checkNotNull((Object)requestExecutor);
        this.userAgent = (String)Preconditions.checkNotNull((Object)userAgent);
        this.apiKey = null;
    }

    public long getNextRequest() {
        return this.nextRequest;
    }

    private Connection generateRequest(String endpoint) {
        Connection connection = Jsoup.connect(GENERATE_BASE + endpoint).method(Connection.Method.POST).userAgent(this.userAgent).ignoreContentType(true).ignoreHttpErrors(true).timeout(30000);
        if (this.apiKey != null) {
            connection.header("Authorization", "Bearer " + this.apiKey);
        }
        return connection;
    }

    private Connection getRequest(String endpoint) {
        return Jsoup.connect(GET_BASE + endpoint).method(Connection.Method.GET).userAgent(this.userAgent).ignoreContentType(true).ignoreHttpErrors(true).timeout(5000);
    }

    public CompletableFuture<Skin> getId(long id) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Connection connection = this.getRequest("/id/" + id);
                return this.handleResponse(connection.execute().body());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, this.requestExecutor);
    }

    public CompletableFuture<Skin> getUuid(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Connection connection = this.getRequest("/uuid/" + uuid);
                return this.handleResponse(connection.execute().body());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, this.requestExecutor);
    }

    public CompletableFuture<Skin> generateUrl(String url) {
        return this.generateUrl(url, SkinOptions.none());
    }

    public CompletableFuture<Skin> generateUrl(String url, SkinOptions options) {
        Preconditions.checkNotNull((Object)url);
        Preconditions.checkNotNull((Object)options);
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (System.currentTimeMillis() < this.nextRequest) {
                    long delay = this.nextRequest - System.currentTimeMillis();
                    Thread.sleep(delay + 1000L);
                }
                JsonObject body = options.toJson();
                body.addProperty("url", url);
                Connection connection = this.generateRequest("/url").header("Content-Type", "application/json").requestBody(body.toString());
                return this.handleResponse(connection.execute().body());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, this.requestExecutor);
    }

    public CompletableFuture<Skin> generateUpload(InputStream is) {
        return this.generateUpload(is, SkinOptions.none(), null);
    }

    public CompletableFuture<Skin> generateUpload(InputStream is, SkinOptions options) {
        return this.generateUpload(is, options, options.getName() + ".png");
    }

    public CompletableFuture<Skin> generateUpload(InputStream is, String name) {
        return this.generateUpload(is, SkinOptions.none(), name);
    }

    public CompletableFuture<Skin> generateUpload(InputStream is, SkinOptions options, String name) {
        Preconditions.checkNotNull((Object)is);
        Preconditions.checkNotNull((Object)options);
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (System.currentTimeMillis() < this.nextRequest) {
                    long delay = this.nextRequest - System.currentTimeMillis();
                    Thread.sleep(delay + 1000L);
                }
                Connection connection = this.generateRequest("/upload").data("file", name, is);
                options.addAsData(connection);
                return this.handleResponse(connection.execute().body());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, this.requestExecutor);
    }

    public CompletableFuture<Skin> generateUpload(File file) throws FileNotFoundException {
        return this.generateUpload(file, SkinOptions.none());
    }

    public CompletableFuture<Skin> generateUpload(File file, SkinOptions options) throws FileNotFoundException {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)options);
        return this.generateUpload(new FileInputStream(file), options, file.getName());
    }

    public CompletableFuture<Skin> generateUpload(RenderedImage image) throws IOException {
        return this.generateUpload(image, SkinOptions.none());
    }

    public CompletableFuture<Skin> generateUpload(RenderedImage image, SkinOptions options) throws IOException {
        Preconditions.checkNotNull((Object)image);
        Preconditions.checkNotNull((Object)options);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write(image, "png", baos);
        return this.generateUpload((InputStream)new ByteArrayInputStream(baos.toByteArray()), options);
    }

    public CompletableFuture<Skin> generateUser(UUID uuid) {
        return this.generateUser(uuid, SkinOptions.none());
    }

    public CompletableFuture<Skin> generateUser(UUID uuid, SkinOptions options) {
        Preconditions.checkNotNull((Object)uuid);
        Preconditions.checkNotNull((Object)options);
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (System.currentTimeMillis() < this.nextRequest) {
                    long delay = this.nextRequest - System.currentTimeMillis();
                    Thread.sleep(delay + 1000L);
                }
                JsonObject body = options.toJson();
                body.addProperty("user", uuid.toString());
                Connection connection = this.generateRequest("/user").header("Content-Type", "application/json").requestBody(body.toString());
                return this.handleResponse(connection.execute().body());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, this.requestExecutor);
    }

    Skin handleResponse(String body) throws MineskinException, JsonParseException {
        JsonObject jsonObject = (JsonObject)this.gson.fromJson(body, JsonObject.class);
        if (jsonObject.has("error")) {
            throw new MineskinException(jsonObject.get("error").getAsString());
        }
        Skin skin = (Skin)this.gson.fromJson((JsonElement)jsonObject, Skin.class);
        this.nextRequest = System.currentTimeMillis() + (long)((skin.nextRequest + 10.0) * 1000.0);
        return skin;
    }

    @Deprecated
    public void getSkin(int id, SkinCallback callback) {
        Preconditions.checkNotNull((Object)callback);
        this.requestExecutor.execute(() -> {
            try {
                Connection connection = Jsoup.connect(String.format(ID_FORMAT, id)).userAgent(this.userAgent).method(Connection.Method.GET).ignoreContentType(true).ignoreHttpErrors(true).timeout(10000);
                String body = connection.execute().body();
                this.handleResponse(body, callback);
            }
            catch (Exception e) {
                callback.exception(e);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        });
    }

    @Deprecated
    public void generateUrl(String url, SkinCallback callback) {
        this.generateUrl(url, SkinOptions.none(), callback);
    }

    @Deprecated
    public void generateUrl(String url, SkinOptions options, SkinCallback callback) {
        Preconditions.checkNotNull((Object)url);
        Preconditions.checkNotNull((Object)options);
        Preconditions.checkNotNull((Object)callback);
        this.requestExecutor.execute(() -> {
            try {
                if (System.currentTimeMillis() < this.nextRequest) {
                    long delay = this.nextRequest - System.currentTimeMillis();
                    callback.waiting(delay);
                    Thread.sleep(delay + 1000L);
                }
                callback.uploading();
                Connection connection = Jsoup.connect(String.format(URL_FORMAT, url, options.toUrlParam())).userAgent(this.userAgent).method(Connection.Method.POST).ignoreContentType(true).ignoreHttpErrors(true).timeout(40000);
                if (this.apiKey != null) {
                    connection.header("Authorization", "Bearer " + this.apiKey);
                }
                String body = connection.execute().body();
                this.handleResponse(body, callback);
            }
            catch (Exception e) {
                callback.exception(e);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        });
    }

    @Deprecated
    public void generateUpload(File file, SkinCallback callback) {
        this.generateUpload(file, SkinOptions.none(), callback);
    }

    @Deprecated
    public void generateUpload(File file, SkinOptions options, SkinCallback callback) {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)options);
        Preconditions.checkNotNull((Object)callback);
        this.requestExecutor.execute(() -> {
            try {
                if (System.currentTimeMillis() < this.nextRequest) {
                    long delay = this.nextRequest - System.currentTimeMillis();
                    callback.waiting(delay);
                    Thread.sleep(delay + 1000L);
                }
                callback.uploading();
                Connection connection = Jsoup.connect(String.format(UPLOAD_FORMAT, options.toUrlParam())).userAgent(this.userAgent).method(Connection.Method.POST).data("file", file.getName(), new FileInputStream(file)).ignoreContentType(true).ignoreHttpErrors(true).timeout(40000);
                if (this.apiKey != null) {
                    connection.header("Authorization", "Bearer " + this.apiKey);
                }
                String body = connection.execute().body();
                this.handleResponse(body, callback);
            }
            catch (Exception e) {
                callback.exception(e);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        });
    }

    @Deprecated
    public void generateUser(UUID uuid, SkinCallback callback) {
        this.generateUser(uuid, SkinOptions.none(), callback);
    }

    @Deprecated
    public void generateUser(UUID uuid, SkinOptions options, SkinCallback callback) {
        Preconditions.checkNotNull((Object)uuid);
        Preconditions.checkNotNull((Object)options);
        Preconditions.checkNotNull((Object)callback);
        this.requestExecutor.execute(() -> {
            try {
                if (System.currentTimeMillis() < this.nextRequest) {
                    long delay = this.nextRequest - System.currentTimeMillis();
                    callback.waiting(delay);
                    Thread.sleep(delay + 1000L);
                }
                callback.uploading();
                Connection connection = Jsoup.connect(String.format(USER_FORMAT, uuid.toString(), options.toUrlParam())).userAgent(this.userAgent).method(Connection.Method.GET).ignoreContentType(true).ignoreHttpErrors(true).timeout(40000);
                if (this.apiKey != null) {
                    connection.header("Authorization", "Bearer " + this.apiKey);
                }
                String body = connection.execute().body();
                this.handleResponse(body, callback);
            }
            catch (Exception e) {
                callback.exception(e);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        });
    }

    @Deprecated
    void handleResponse(String body, SkinCallback callback) {
        try {
            JsonObject jsonObject = this.jsonParser.parse(body).getAsJsonObject();
            if (jsonObject.has("error")) {
                callback.error(jsonObject.get("error").getAsString());
                return;
            }
            Skin skin = (Skin)this.gson.fromJson((JsonElement)jsonObject, Skin.class);
            this.nextRequest = System.currentTimeMillis() + (long)((skin.nextRequest + 10.0) * 1000.0);
            callback.done(skin);
        }
        catch (JsonParseException e) {
            callback.parseException((Exception)((Object)e), body);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

