/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.spigot.server;

import dev.sergiferry.spigot.SpigotPlugin;
import java.util.Arrays;

public enum ServerVersion {
    VERSION_1_8("1.8-R0.1-SNAPSHOT", 47),
    VERSION_1_8_1("1.8.1-R0.1-SNAPSHOT", 47),
    VERSION_1_8_2("1.8.2-R0.1-SNAPSHOT", 47),
    VERSION_1_8_3("1.8.3-R0.1-SNAPSHOT", 47),
    VERSION_1_8_4("1.8.4-R0.1-SNAPSHOT", 47),
    VERSION_1_8_5("1.8.5-R0.1-SNAPSHOT", 47),
    VERSION_1_8_6("1.8.6-R0.1-SNAPSHOT", 47),
    VERSION_1_8_7("1.8.7-R0.1-SNAPSHOT", 47),
    VERSION_1_8_8("1.8.8-R0.1-SNAPSHOT", 47),
    VERSION_1_8_9("1.8.9-R0.1-SNAPSHOT", 47),
    VERSION_1_9("1.9-R0.1-SNAPSHOT", 107),
    VERSION_1_9_1("1.9.1-R0.1-SNAPSHOT", 108),
    VERSION_1_9_2("1.9.2-R0.1-SNAPSHOT", 109),
    VERSION_1_9_3("1.9.3-R0.1-SNAPSHOT", 110),
    VERSION_1_9_4("1.9.4-R0.1-SNAPSHOT", 110),
    VERSION_1_10("1.10-R0.1-SNAPSHOT", 210),
    VERSION_1_10_1("1.10.1-R0.1-SNAPSHOT", 210),
    VERSION_1_10_2("1.10.2-R0.1-SNAPSHOT", 210),
    VERSION_1_11("1.11-R0.1-SNAPSHOT", 315),
    VERSION_1_11_1("1.11.1-R0.1-SNAPSHOT", 316),
    VERSION_1_11_2("1.11.2-R0.1-SNAPSHOT", 316),
    VERSION_1_12("1.12-R0.1-SNAPSHOT", 335),
    VERSION_1_12_1("1.12.1-R0.1-SNAPSHOT", 338),
    VERSION_1_12_2("1.12.2-R0.1-SNAPSHOT", 340),
    VERSION_1_13("1.13-R0.1-SNAPSHOT", 393),
    VERSION_1_13_1("1.13.1-R0.1-SNAPSHOT", 401),
    VERSION_1_13_2("1.13.2-R0.1-SNAPSHOT", 404),
    VERSION_1_14("1.14-R0.1-SNAPSHOT", 477),
    VERSION_1_14_1("1.14.1-R0.1-SNAPSHOT", 480),
    VERSION_1_14_2("1.14.2-R0.1-SNAPSHOT", 485),
    VERSION_1_14_3("1.14.3-R0.1-SNAPSHOT", 490),
    VERSION_1_14_4("1.14.4-R0.1-SNAPSHOT", 498),
    VERSION_1_15("1.15-R0.1-SNAPSHOT", 573),
    VERSION_1_15_1("1.15.1-R0.1-SNAPSHOT", 575),
    VERSION_1_15_2("1.15.2-R0.1-SNAPSHOT", 578),
    VERSION_1_16("1.16-R0.1-SNAPSHOT", 735),
    VERSION_1_16_1("1.16.1-R0.1-SNAPSHOT", 736),
    VERSION_1_16_2("1.16.2-R0.1-SNAPSHOT", 751),
    VERSION_1_16_3("1.16.3-R0.1-SNAPSHOT", 753),
    VERSION_1_16_4("1.16.4-R0.1-SNAPSHOT", 754),
    VERSION_1_16_5("1.16.5-R0.1-SNAPSHOT", 754),
    VERSION_1_17("1.17-R0.1-SNAPSHOT", 755),
    VERSION_1_17_1("1.17.1-R0.1-SNAPSHOT", 756),
    VERSION_1_18("1.18-R0.1-SNAPSHOT", 757),
    VERSION_1_18_1("1.18.1-R0.1-SNAPSHOT", 757),
    VERSION_1_18_2("1.18.2-R0.1-SNAPSHOT", 758),
    VERSION_1_19("1.19-R0.1-SNAPSHOT", 759),
    VERSION_1_19_1("1.19.1-R0.1-SNAPSHOT", 760),
    VERSION_1_19_2("1.19.2-R0.1-SNAPSHOT", 760),
    VERSION_1_19_3("1.19.3-R0.1-SNAPSHOT", 761),
    VERSION_1_19_4("1.19.4-R0.1-SNAPSHOT", 762),
    VERSION_1_20("1.20-R0.1-SNAPSHOT", 763),
    VERSION_1_20_1("1.20.1-R0.1-SNAPSHOT", 763);

    private String bukkitVersion;
    private int protocolVersion;

    private ServerVersion(String bukkitVersion, Integer protocolVersion) {
        this.bukkitVersion = bukkitVersion;
        this.protocolVersion = protocolVersion;
    }

    public String toString() {
        return this.getBukkitVersion();
    }

    public String getBukkitVersion() {
        return this.bukkitVersion;
    }

    public boolean isNewerThan(ServerVersion version) {
        return this.ordinal() > version.ordinal();
    }

    public boolean isNewerThanOrEqual(ServerVersion version) {
        return this.ordinal() >= version.ordinal();
    }

    public boolean isOlderThanOrEqual(ServerVersion version) {
        return this.ordinal() <= version.ordinal();
    }

    public boolean isOlderThan(ServerVersion version) {
        return this.ordinal() < version.ordinal();
    }

    public Integer getProtocolVersion() {
        return this.protocolVersion;
    }

    public Integer getOrder() {
        return this.ordinal();
    }

    public String getMinecraftVersion() {
        return this.bukkitVersion.split("-")[0];
    }

    public static ServerVersion getVersion(String version) {
        return Arrays.stream(ServerVersion.values()).filter(x -> x.getBukkitVersion().equals(version)).findAny().orElse(null);
    }

    public static ServerVersion getServerVersion() {
        return SpigotPlugin.getServerVersion();
    }

    public static ServerVersion getProtocolVersion(Integer protocolVersion) {
        return Arrays.stream(ServerVersion.values()).filter(x -> x.getProtocolVersion().equals(protocolVersion)).findFirst().orElse(null);
    }
}

