/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.spigot.nms;

import dev.sergiferry.spigot.nms.NMSUtils;
import java.util.Arrays;

public enum NMSVersion {
    VERSION_1_17_R1("v1_17_R1"),
    VERSION_1_18_R1("v1_18_R1"),
    VERSION_1_18_R2("v1_18_R2"),
    VERSION_1_19_R1("v1_19_R1"),
    VERSION_1_19_R2("v1_19_R2"),
    VERSION_1_19_R3("v1_19_R3"),
    VERSION_1_20_R1("v1_20_R1");

    private String bukkitVersion;

    private NMSVersion(String bukkitVersion) {
        this.bukkitVersion = bukkitVersion;
    }

    public String toString() {
        return this.getPackageName();
    }

    public String getPackageName() {
        return this.bukkitVersion;
    }

    public boolean isNewerThan(NMSVersion version) {
        return this.ordinal() > version.ordinal();
    }

    public boolean isNewerThanOrEqual(NMSVersion version) {
        return this.ordinal() >= version.ordinal();
    }

    public boolean isOlderThanOrEqual(NMSVersion version) {
        return this.ordinal() <= version.ordinal();
    }

    public boolean isOlderThan(NMSVersion version) {
        return this.ordinal() < version.ordinal();
    }

    public int getOrder() {
        return this.ordinal();
    }

    public static NMSVersion getVersion(String version) {
        return Arrays.stream(NMSVersion.values()).filter(x -> x.getPackageName().equals(version)).findAny().orElseThrow();
    }

    public static NMSVersion getNMSVersion() {
        return NMSUtils.getNMSVersion();
    }
}

