/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.spigot.nms;

import dev.sergiferry.spigot.SpigotPlugin;
import dev.sergiferry.spigot.nms.NMSVersion;
import dev.sergiferry.spigot.nms.craftbukkit.NMSCraftChatMessage;
import dev.sergiferry.spigot.nms.craftbukkit.NMSCraftPlayer;
import dev.sergiferry.spigot.nms.craftbukkit.NMSCraftServer;
import dev.sergiferry.spigot.nms.craftbukkit.NMSCraftWorld;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.NoSuchElementException;
import org.bukkit.Bukkit;

public class NMSUtils {
    private static NMSVersion version;

    public static void load(SpigotPlugin spigotPlugin) {
        String packageName = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
        try {
            version = NMSVersion.getVersion(packageName);
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("This NMS version (" + packageName + ") is not supported.");
        }
        Bukkit.getConsoleSender().sendMessage(spigotPlugin.getPrefix() + "Detected NMS version: \u00a7e" + version);
        NMSUtils.loadNMS(NMSCraftPlayer.class);
        NMSUtils.loadNMS(NMSCraftWorld.class);
        NMSUtils.loadNMS(NMSCraftServer.class);
        NMSUtils.loadNMS(NMSCraftChatMessage.class);
    }

    public static Class<?> getCraftBukkitClass(String nmsClassString) throws ClassNotFoundException {
        return NMSUtils.getNMSClass("org.bukkit.craftbukkit", nmsClassString);
    }

    public static Class<?> getMinecraftClass(String nmsClassString) throws ClassNotFoundException {
        return Class.forName("net.minecraft." + nmsClassString);
    }

    public static Class<?> getClass(String nmsClassString) throws ClassNotFoundException {
        return Class.forName(nmsClassString);
    }

    public static Class<?> getNMSClass(String prefix, String nmsClassString) throws ClassNotFoundException {
        String name = prefix + "." + version + "." + nmsClassString;
        return Class.forName(name);
    }

    public static void loadNMS(Class<?> c) {
        try {
            Method method = c.getDeclaredMethod("load", null);
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Error loading NMS " + c.getName());
        }
    }

    public static NMSVersion getNMSVersion() {
        return version;
    }

    public static Object getValue(Object instance, String name) {
        return NMSUtils.getValue(instance, name, false);
    }

    public static Object getValue(Object instance, String name, boolean printError) {
        Object result;
        block2: {
            result = null;
            try {
                Field field = instance.getClass().getDeclaredField(name);
                field.setAccessible(true);
                result = field.get(instance);
                field.setAccessible(false);
            }
            catch (Exception e) {
                if (!printError) break block2;
                e.printStackTrace();
            }
        }
        return result;
    }

    public static void setValue(Object instance, String name, Object value) {
        NMSUtils.setValue(instance, name, value, false);
    }

    public static void setValue(Object obj, String name, Object value, boolean printError) {
        block2: {
            try {
                Field field = obj.getClass().getDeclaredField(name);
                field.setAccessible(true);
                field.set(obj, value);
            }
            catch (Exception e) {
                if (!printError) break block2;
                e.printStackTrace();
            }
        }
    }
}

