/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;

public class StringUtils {
    private static final Pattern hexPattern = Pattern.compile("&#[a-fA-F0-9]{6}");

    public static String getFirstCharUpperCase(String s, boolean force_low) {
        if (force_low) {
            s = s.toLowerCase();
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static boolean containsIgnoreCase(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        int length = searchStr.length();
        if (length == 0) {
            return true;
        }
        for (int i = str.length() - length; i >= 0; --i) {
            if (!str.regionMatches(true, i, searchStr, 0, length)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIgnoreCase(List<String> strings, String searchStr) {
        for (String string : strings) {
            if (!StringUtils.containsIgnoreCase(string, searchStr)) continue;
            return true;
        }
        return false;
    }

    public static String formatUUID(String uuid) {
        return uuid.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5");
    }

    public static String getStringFromList(List<String> lines) {
        StringBuilder builder = new StringBuilder();
        for (String s : lines) {
            if (!builder.isEmpty()) {
                builder.append("\\n");
            }
            builder.append(s.replaceAll("\u00a7", "&"));
        }
        return builder.toString();
    }

    public static String formatHexColor(String msg) {
        if (msg == null) {
            return null;
        }
        Matcher match = hexPattern.matcher(msg);
        while (match.find()) {
            String color = msg.substring(match.start() + 1, match.end());
            msg = msg.replace(match.group(), "" + ChatColor.of((String)color));
            match = hexPattern.matcher(msg);
        }
        return msg;
    }

    public static String getStringFromList(List<String> list, StringListSeparator stringListSeparator) {
        Object string = "";
        boolean first = true;
        for (String a : list) {
            string = (String)string + (!first || !stringListSeparator.isFirstDifferent() ? stringListSeparator.getFormat() : "") + a;
            first = false;
        }
        return string;
    }

    public static List<String> replaceAll(List<String> list, String regex, String replacement) {
        ArrayList<String> finalList = new ArrayList<String>();
        for (String s : list) {
            finalList.add(s.replaceAll(regex, replacement));
        }
        return finalList;
    }

    public static String getNumberSymbol(int i) {
        if (i == 0) {
            return "\u24ea";
        }
        if (i == 1) {
            return "\u2460";
        }
        if (i == 2) {
            return "\u2461";
        }
        if (i == 3) {
            return "\u2462";
        }
        if (i == 4) {
            return "\u2463";
        }
        if (i == 5) {
            return "\u2464";
        }
        if (i == 6) {
            return "\u2465";
        }
        if (i == 7) {
            return "\u2466";
        }
        if (i == 8) {
            return "\u2467";
        }
        if (i == 9) {
            return "\u2468";
        }
        if (i == 10) {
            return "\u2469";
        }
        if (i == 11) {
            return "\u246a";
        }
        if (i == 12) {
            return "\u246b";
        }
        if (i == 13) {
            return "\u246c";
        }
        if (i == 14) {
            return "\u246d";
        }
        if (i == 15) {
            return "\u246e";
        }
        if (i == 16) {
            return "\u246f";
        }
        if (i == 17) {
            return "\u2470";
        }
        if (i == 18) {
            return "\u2471";
        }
        if (i == 19) {
            return "\u2472";
        }
        if (i == 20) {
            return "\u2473";
        }
        return "(" + i + ")";
    }

    public static enum StringListSeparator {
        NEW_LINE("\n"),
        COMMA(", "),
        NEW_LINE_TEXT("\\n"),
        LISTED("\n\u00a7r- ", false);

        private boolean firstDifferent;
        private String format;

        private StringListSeparator(String format, boolean firstDifferent) {
            this.format = format;
            this.firstDifferent = firstDifferent;
        }

        private StringListSeparator(String format) {
            this(format, true);
        }

        public boolean isFirstDifferent() {
            return this.firstDifferent;
        }

        public String getFormat() {
            return this.format;
        }
    }
}

