/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.utils;

import dev.sergiferry.playernpc.utils.StringUtils;
import java.lang.annotation.Annotation;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EnumUtils {
    @Nullable
    public static <E extends Enum<E>> E getEnumConstant(Class<E> enumClass, String name) {
        try {
            return Enum.valueOf(enumClass, name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <E extends Enum<E>> boolean isDeprecated(E en) {
        return EnumUtils.isAnnotationPresent(en, Deprecated.class);
    }

    public static <E extends Enum<E>> boolean isAnnotationPresent(E en, Class<? extends Annotation> clazz) {
        try {
            return en.getClass().getField(en.name()).isAnnotationPresent(clazz);
        }
        catch (NoSuchFieldException | SecurityException e) {
            return false;
        }
    }

    public static <E extends Enum<E>, A extends Annotation> A getAnnotation(E en, Class<A> clazz) {
        try {
            return en.getClass().getField(en.name()).getAnnotation(clazz);
        }
        catch (NoSuchFieldException | SecurityException e) {
            return null;
        }
    }

    public static interface GetName {
        @Nonnull
        default public String getName(NameFormat nameFormat) {
            return nameFormat.format((Enum)((Object)this));
        }

        @Nonnull
        default public String getName() {
            return this.getName(NameFormat.FIRST_UPPER_CASE_WITH_SPACES);
        }
    }

    public static enum NameFormat {
        LOWER_CASE(c -> c.toLowerCase()),
        LOWER_CASE_WITH_SPACES(c -> c.toLowerCase().replaceAll("_", " ")),
        UPPER_CASE(c -> c.toUpperCase()),
        UPPER_CASE_WITH_SPACES(c -> c.toUpperCase().replaceAll("_", " ")),
        FIRST_UPPER_CASE(c -> StringUtils.getFirstCharUpperCase(c, true)),
        FIRST_UPPER_CASE_WITH_SPACES(c -> StringUtils.getFirstCharUpperCase(c, true).replaceAll("_", " "));

        private Function<String, String> format;

        private NameFormat(Function<String, String> format) {
            this.format = format;
        }

        public <E extends Enum> String format(E en) {
            return this.format.apply(en.name());
        }

        public String format(String name) {
            return this.format.apply(name);
        }
    }
}

