/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.nms.spigot;

import dev.sergiferry.playernpc.api.NPCLib;
import dev.sergiferry.spigot.SpigotPlugin;
import dev.sergiferry.spigot.server.ServerVersion;
import java.lang.reflect.Method;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.FileConfigurationOptions;

public class NMSFileConfiguration {
    private static Method setComments;
    private static Method setHeader;

    public static void load() throws ClassNotFoundException, NoSuchMethodException {
        ServerVersion serverVersion = SpigotPlugin.getServerVersion();
        if (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_18_1)) {
            setComments = null;
            setHeader = FileConfigurationOptions.class.getMethod("header", String.class);
        } else {
            setComments = FileConfiguration.class.getMethod("setComments", String.class, List.class);
            setHeader = FileConfigurationOptions.class.getMethod("setHeader", List.class);
        }
    }

    public static void setComments(FileConfiguration fileConfiguration, String key, List<String> strings) {
        if (setComments == null) {
            return;
        }
        try {
            setComments.invoke((Object)fileConfiguration, key, strings);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
    }

    public static void setHeader(FileConfiguration fileConfiguration, List<String> strings) {
        if (setHeader.getParameterTypes().equals(List.class)) {
            try {
                setHeader.invoke((Object)fileConfiguration.options(), strings);
            }
            catch (Exception e) {
                NPCLib.DebugManager.printError(e);
            }
        } else if (setHeader.getParameterTypes().equals(String.class)) {
            Object string = "";
            for (String s : strings) {
                string = (String)string + "\n" + s;
            }
            string = ((String)string).replaceFirst("\\\\n", "");
            try {
                setHeader.invoke((Object)fileConfiguration.options(), string);
            }
            catch (Exception e) {
                NPCLib.DebugManager.printError(e);
            }
        }
    }
}

