/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.nms.minecraft;

import dev.sergiferry.spigot.nms.NMSUtils;
import dev.sergiferry.spigot.server.ServerVersion;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.World;
import net.minecraft.world.level.dimension.DimensionManager;

public class NMSWorld {
    private static Class<?> holderClass;
    private static Method getResourceKeyDimensionManager;
    private static Method getResourceKeyWorld;

    public static void load() throws ClassNotFoundException, NoSuchMethodException {
        if (ServerVersion.getServerVersion().isOlderThanOrEqual(ServerVersion.VERSION_1_17_1)) {
            getResourceKeyDimensionManager = World.class.getMethod("getDimensionManager", new Class[0]);
            getResourceKeyWorld = World.class.getMethod("getDimensionKey", new Class[0]);
        } else if (ServerVersion.getServerVersion().isOlderThanOrEqual(ServerVersion.VERSION_1_18_1)) {
            getResourceKeyDimensionManager = World.class.getMethod("q_", new Class[0]);
            getResourceKeyWorld = World.class.getMethod("aa", new Class[0]);
        } else if (ServerVersion.getServerVersion().isOlderThanOrEqual(ServerVersion.VERSION_1_18_2)) {
            holderClass = NMSUtils.getMinecraftClass("core.Holder");
            getResourceKeyDimensionManager = World.class.getMethod("Z", new Class[0]);
            getResourceKeyWorld = World.class.getMethod("aa", new Class[0]);
        } else if (ServerVersion.getServerVersion().isOlderThanOrEqual(ServerVersion.VERSION_1_19)) {
            getResourceKeyDimensionManager = World.class.getMethod("Z", new Class[0]);
            getResourceKeyWorld = World.class.getMethod("ab", new Class[0]);
        } else if (ServerVersion.getServerVersion().isOlderThanOrEqual(ServerVersion.VERSION_1_19_2)) {
            getResourceKeyDimensionManager = World.class.getMethod("Z", new Class[0]);
            getResourceKeyWorld = World.class.getMethod("ab", new Class[0]);
        } else if (ServerVersion.getServerVersion().isOlderThanOrEqual(ServerVersion.VERSION_1_19_3)) {
            getResourceKeyDimensionManager = World.class.getMethod("aa", new Class[0]);
            getResourceKeyWorld = World.class.getMethod("ac", new Class[0]);
        } else if (ServerVersion.getServerVersion().isOlderThanOrEqual(ServerVersion.VERSION_1_19_4)) {
            getResourceKeyDimensionManager = World.class.getMethod("Z", new Class[0]);
            getResourceKeyWorld = World.class.getMethod("ab", new Class[0]);
        } else {
            getResourceKeyDimensionManager = World.class.getMethod("aa", new Class[0]);
            getResourceKeyWorld = World.class.getMethod("ac", new Class[0]);
        }
    }

    public static Class<?> getHolderClass() {
        return holderClass;
    }

    public static ResourceKey<World> getResourceKeyWorld(World world) throws InvocationTargetException, IllegalAccessException {
        return (ResourceKey)getResourceKeyWorld.invoke((Object)world, new Object[0]);
    }

    public static Object getResourceKeyDimesion(World world) throws InvocationTargetException, IllegalAccessException {
        if (ServerVersion.getServerVersion().isOlderThanOrEqual(ServerVersion.VERSION_1_18_1)) {
            return DimensionManager.class.cast(getResourceKeyDimensionManager.invoke((Object)world, new Object[0]));
        }
        if (ServerVersion.getServerVersion().isOlderThanOrEqual(ServerVersion.VERSION_1_18_2)) {
            return holderClass.cast(getResourceKeyDimensionManager.invoke((Object)world, new Object[0]));
        }
        return ResourceKey.class.cast(getResourceKeyDimensionManager.invoke((Object)world, new Object[0]));
    }
}

