/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.nms.minecraft;

import dev.sergiferry.playernpc.api.NPCLib;
import dev.sergiferry.playernpc.nms.craftbukkit.NMSCraftScoreboard;
import dev.sergiferry.spigot.SpigotPlugin;
import dev.sergiferry.spigot.server.ServerVersion;
import java.lang.reflect.Method;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.entity.Player;

public class NMSScoreboard {
    private static Method setPrefix;
    private static Method setSuffix;
    private static Method setPlayerTeam;
    private static Method setTeamPush;
    private static Method setTeamColor;
    private static Method getTeam;
    private static Method setNameTagVisibility;
    public static ScoreboardTeamBase.EnumNameTagVisibility nameTagVisibility_ALWAYS;
    public static ScoreboardTeamBase.EnumNameTagVisibility nameTagVisibility_NEVER;
    public static ScoreboardTeamBase.EnumTeamPush teamPush_ALWAYS;
    public static ScoreboardTeamBase.EnumTeamPush teamPush_NEVER;

    public static void load() throws ClassNotFoundException, NoSuchMethodException {
        ServerVersion serverVersion = SpigotPlugin.getServerVersion();
        if (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_17_1)) {
            getTeam = Scoreboard.class.getMethod("getTeam", String.class);
            setNameTagVisibility = ScoreboardTeam.class.getMethod("setNameTagVisibility", ScoreboardTeamBase.EnumNameTagVisibility.class);
            setTeamColor = ScoreboardTeam.class.getMethod("setColor", EnumChatFormat.class);
            setPlayerTeam = Scoreboard.class.getMethod("addPlayerToTeam", String.class, ScoreboardTeam.class);
            setTeamPush = ScoreboardTeam.class.getMethod("setCollisionRule", ScoreboardTeamBase.EnumTeamPush.class);
            setPrefix = ScoreboardTeam.class.getMethod("setPrefix", IChatBaseComponent.class);
            setSuffix = ScoreboardTeam.class.getMethod("setSuffix", IChatBaseComponent.class);
        } else {
            getTeam = Scoreboard.class.getMethod("f", String.class);
            setNameTagVisibility = ScoreboardTeam.class.getMethod("a", ScoreboardTeamBase.EnumNameTagVisibility.class);
            setTeamColor = ScoreboardTeam.class.getMethod("a", EnumChatFormat.class);
            setPlayerTeam = Scoreboard.class.getMethod("a", String.class, ScoreboardTeam.class);
            setTeamPush = ScoreboardTeam.class.getMethod("a", ScoreboardTeamBase.EnumTeamPush.class);
            setPrefix = ScoreboardTeam.class.getMethod("b", IChatBaseComponent.class);
            setSuffix = ScoreboardTeam.class.getMethod("c", IChatBaseComponent.class);
        }
        nameTagVisibility_ALWAYS = ScoreboardTeamBase.EnumNameTagVisibility.a;
        nameTagVisibility_NEVER = ScoreboardTeamBase.EnumNameTagVisibility.b;
        teamPush_ALWAYS = ScoreboardTeamBase.EnumTeamPush.a;
        teamPush_NEVER = ScoreboardTeamBase.EnumTeamPush.b;
    }

    public static Scoreboard getScoreboard(Player player) {
        return NMSCraftScoreboard.getScoreboard(player);
    }

    public static ScoreboardTeam getTeam(Scoreboard scoreboard, String s) {
        try {
            return (ScoreboardTeam)getTeam.invoke((Object)scoreboard, s);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
            return null;
        }
    }

    public static void setNameTagVisibility(ScoreboardTeam team, ScoreboardTeamBase.EnumNameTagVisibility visibility) {
        try {
            setNameTagVisibility.invoke((Object)team, visibility);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
    }

    public static void setTeamColor(ScoreboardTeam team, EnumChatFormat enumChatFormat) {
        try {
            setTeamColor.invoke((Object)team, enumChatFormat);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
    }

    public static void setTeamPush(ScoreboardTeam team, ScoreboardTeamBase.EnumTeamPush enumTeamPush) {
        try {
            setTeamPush.invoke((Object)team, enumTeamPush);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
    }

    public static void setPlayerTeam(Scoreboard scoreboard, String name, ScoreboardTeam team) {
        try {
            setPlayerTeam.invoke((Object)scoreboard, name, team);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
    }

    public static void setPrefix(ScoreboardTeam team, String prefix) {
        NMSScoreboard.setPrefix(team, IChatBaseComponent.a((String)prefix));
    }

    public static void setPrefix(ScoreboardTeam team, IChatBaseComponent chatBaseComponent) {
        try {
            setPrefix.invoke((Object)team, chatBaseComponent);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
    }

    public static void setSuffix(ScoreboardTeam team, String suffix) {
        NMSScoreboard.setSuffix(team, IChatBaseComponent.a((String)suffix));
    }

    public static void setSuffix(ScoreboardTeam team, IChatBaseComponent chatBaseComponent) {
        try {
            setSuffix.invoke((Object)team, chatBaseComponent);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
    }
}

