/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.nms.minecraft;

import dev.sergiferry.playernpc.api.NPCLib;
import dev.sergiferry.spigot.SpigotPlugin;
import dev.sergiferry.spigot.nms.NMSUtils;
import dev.sergiferry.spigot.nms.craftbukkit.NMSCraftPlayer;
import dev.sergiferry.spigot.server.ServerVersion;
import java.lang.reflect.Constructor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import org.bukkit.entity.Player;

public class NMSPacketPlayOutSpawnEntity {
    private static Class<?> packetPlayOutSpawnEntityLivingClass;
    private static Class<?> packetPlayOutSpawnEntityClass;
    private static Constructor entityLivingConstructor;
    private static Constructor constructor;

    public static void load() throws ClassNotFoundException, NoSuchMethodException {
        ServerVersion serverVersion = SpigotPlugin.getServerVersion();
        if (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_18_2)) {
            packetPlayOutSpawnEntityLivingClass = NMSUtils.getMinecraftClass("network.protocol.game.PacketPlayOutSpawnEntityLiving");
            entityLivingConstructor = packetPlayOutSpawnEntityLivingClass.getConstructor(EntityLiving.class);
        }
        packetPlayOutSpawnEntityClass = NMSUtils.getMinecraftClass("network.protocol.game.PacketPlayOutSpawnEntity");
        constructor = packetPlayOutSpawnEntityClass.getConstructor(Entity.class);
    }

    public static void sendPacketEntityLiving(Player player, EntityLiving entityLiving) {
        try {
            NMSCraftPlayer.sendPacket(player, (Packet)(entityLivingConstructor != null ? entityLivingConstructor.newInstance(entityLiving) : constructor.newInstance(entityLiving)));
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
    }

    public static void sendPacketEntity(Player player, Entity entity) {
        try {
            NMSCraftPlayer.sendPacket(player, (Packet)constructor.newInstance(entity));
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
    }
}

