/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.nms.minecraft;

import dev.sergiferry.playernpc.api.NPCLib;
import dev.sergiferry.playernpc.nms.minecraft.NMSEntity;
import dev.sergiferry.spigot.SpigotPlugin;
import dev.sergiferry.spigot.nms.NMSUtils;
import dev.sergiferry.spigot.nms.craftbukkit.NMSCraftPlayer;
import dev.sergiferry.spigot.server.ServerVersion;
import java.lang.reflect.Constructor;
import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import org.bukkit.entity.Player;

public class NMSPacketPlayOutPlayerInfo {
    private static Class<?> packetClientboundPlayerInfoUpdateClass;
    private static Class<?> packetClientboundPlayerInfoRemoveClass;
    private static Constructor updateConstructor;
    private static Class<? extends Enum> enumUpdateAction;
    private static Constructor removeConstructor;

    public static void load() throws ClassNotFoundException, NoSuchMethodException {
        ServerVersion serverVersion = SpigotPlugin.getServerVersion();
        Object path = "network.protocol.game.";
        if (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_19_2)) {
            path = (String)path + "PacketPlayOutPlayerInfo";
            packetClientboundPlayerInfoUpdateClass = NMSUtils.getMinecraftClass((String)path);
            enumUpdateAction = NMSUtils.getMinecraftClass((String)path + "$EnumPlayerInfoAction");
            updateConstructor = packetClientboundPlayerInfoUpdateClass.getConstructor(enumUpdateAction, EntityPlayer[].class);
        } else {
            packetClientboundPlayerInfoRemoveClass = NMSUtils.getMinecraftClass((String)path + "ClientboundPlayerInfoRemovePacket");
            removeConstructor = packetClientboundPlayerInfoRemoveClass.getConstructor(List.class);
            path = (String)path + "ClientboundPlayerInfoUpdatePacket";
            packetClientboundPlayerInfoUpdateClass = NMSUtils.getMinecraftClass((String)path);
            enumUpdateAction = NMSUtils.getMinecraftClass((String)path + "$a");
            updateConstructor = packetClientboundPlayerInfoUpdateClass.getConstructor(enumUpdateAction, EntityPlayer.class);
        }
    }

    public static void addPlayer(Player player, EntityPlayer entityPlayer, boolean showOnTablist) {
        Packet packet = null;
        try {
            EntityPlayer[] entityPlayerArray;
            Object[] objectArray = new Object[2];
            objectArray[0] = Enum.valueOf(enumUpdateAction, "ADD_PLAYER");
            if (ServerVersion.getServerVersion().isOlderThanOrEqual(ServerVersion.VERSION_1_19_2)) {
                EntityPlayer[] entityPlayerArray2 = new EntityPlayer[1];
                entityPlayerArray = entityPlayerArray2;
                entityPlayerArray2[0] = entityPlayer;
            } else {
                entityPlayerArray = entityPlayer;
            }
            objectArray[1] = entityPlayerArray;
            packet = (Packet)updateConstructor.newInstance(objectArray);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
        if (packet == null) {
            return;
        }
        NMSCraftPlayer.sendPacket(player, packet);
        if (showOnTablist) {
            NMSPacketPlayOutPlayerInfo.addPlayerTabList(player, (EntityPlayer)entityPlayer);
        }
    }

    public static void addPlayerTabList(Player player, EntityPlayer entityPlayer) {
        if (ServerVersion.getServerVersion().isOlderThanOrEqual(ServerVersion.VERSION_1_19_2)) {
            return;
        }
        Packet packet = null;
        try {
            packet = (Packet)updateConstructor.newInstance(Enum.valueOf(enumUpdateAction, "UPDATE_LISTED"), entityPlayer);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
        NMSCraftPlayer.sendPacket(player, packet);
    }

    public static void refreshPlayerTabList(Player player, EntityPlayer entityPlayer) {
        Packet packet = null;
        try {
            EntityPlayer[] entityPlayerArray;
            Object[] objectArray = new Object[2];
            objectArray[0] = Enum.valueOf(enumUpdateAction, "UPDATE_DISPLAY_NAME");
            if (ServerVersion.getServerVersion().isOlderThanOrEqual(ServerVersion.VERSION_1_19_2)) {
                EntityPlayer[] entityPlayerArray2 = new EntityPlayer[1];
                entityPlayerArray = entityPlayerArray2;
                entityPlayerArray2[0] = entityPlayer;
            } else {
                entityPlayerArray = entityPlayer;
            }
            objectArray[1] = entityPlayerArray;
            packet = (Packet)updateConstructor.newInstance(objectArray);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
        NMSCraftPlayer.sendPacket(player, packet);
    }

    public static void removePlayer(Player player, EntityPlayer entityPlayer) {
        Packet packet = null;
        try {
            packet = ServerVersion.getServerVersion().isOlderThanOrEqual(ServerVersion.VERSION_1_19_2) ? (Packet)updateConstructor.newInstance(Enum.valueOf(enumUpdateAction, "REMOVE_PLAYER"), new EntityPlayer[]{entityPlayer}) : (Packet)removeConstructor.newInstance(List.of(NMSEntity.getEntityUUID((Entity)entityPlayer)));
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
        if (packet == null) {
            return;
        }
        NMSCraftPlayer.sendPacket(player, packet);
    }
}

