/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.nms.minecraft;

import dev.sergiferry.playernpc.api.NPCLib;
import dev.sergiferry.playernpc.nms.minecraft.NMSDataWatcher;
import dev.sergiferry.playernpc.nms.minecraft.NMSEntity;
import dev.sergiferry.spigot.server.ServerVersion;
import java.lang.reflect.Constructor;
import java.util.List;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;

public class NMSPacketPlayOutEntityMetadata {
    private static Class<?> packetPlayOutEntityMetadataClass;
    private static Constructor constructor;

    public static void load() throws ClassNotFoundException, NoSuchMethodException {
        ServerVersion serverVersion = ServerVersion.getServerVersion();
        packetPlayOutEntityMetadataClass = PacketPlayOutEntityMetadata.class;
        constructor = serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_19_2) ? packetPlayOutEntityMetadataClass.getConstructor(Integer.TYPE, DataWatcher.class, Boolean.TYPE) : packetPlayOutEntityMetadataClass.getConstructor(Integer.TYPE, List.class);
    }

    public static PacketPlayOutEntityMetadata getPacket(Entity entity, DataWatcher dataWatcher) {
        try {
            if (ServerVersion.getServerVersion().isOlderThanOrEqual(ServerVersion.VERSION_1_19_2)) {
                return (PacketPlayOutEntityMetadata)constructor.newInstance(NMSEntity.getEntityID(entity), dataWatcher, true);
            }
            return (PacketPlayOutEntityMetadata)constructor.newInstance(NMSEntity.getEntityID(entity), NMSDataWatcher.getMetadataList(dataWatcher));
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
            return null;
        }
    }

    public static PacketPlayOutEntityMetadata getPacket(EntityLiving entityLiving) {
        return NMSPacketPlayOutEntityMetadata.getPacket((Entity)entityLiving, NMSEntity.getDataWatcher((Entity)entityLiving));
    }
}

