/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.nms.minecraft;

import dev.sergiferry.playernpc.api.NPCLib;
import dev.sergiferry.playernpc.nms.minecraft.NMSEntity;
import dev.sergiferry.spigot.nms.NMSUtils;
import dev.sergiferry.spigot.nms.craftbukkit.NMSCraftPlayer;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.world.entity.Entity;
import org.bukkit.entity.Player;

public class NMSPacketPlayOutEntityDestroy {
    private static Class<?> packetPlayOutEntityDestroyClass;
    private static boolean singleConstructor;
    private static Constructor constructor;

    public static void load() throws ClassNotFoundException, NoSuchMethodException {
        packetPlayOutEntityDestroyClass = NMSUtils.getMinecraftClass("network.protocol.game.PacketPlayOutEntityDestroy");
        try {
            constructor = packetPlayOutEntityDestroyClass.getConstructor(int[].class);
            singleConstructor = false;
        }
        catch (Exception e) {
            constructor = packetPlayOutEntityDestroyClass.getConstructor(Integer.TYPE);
            singleConstructor = true;
        }
    }

    public static PacketPlayOutEntityDestroy createPacket(int id) {
        try {
            Object object;
            Object[] objectArray = new Object[1];
            if (NMSPacketPlayOutEntityDestroy.isSingleConstructor()) {
                object = id;
            } else {
                int[] nArray = new int[1];
                object = nArray;
                nArray[0] = id;
            }
            objectArray[0] = object;
            return (PacketPlayOutEntityDestroy)constructor.newInstance(objectArray);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
            return null;
        }
    }

    public static void destroyEntity(Player player, Entity entity) {
        NMSCraftPlayer.sendPacket(player, (Packet)NMSPacketPlayOutEntityDestroy.createPacket(NMSEntity.getEntityID(entity)));
    }

    public static void destroyEntities(Player player, Collection<? extends Entity> entities) {
        if (singleConstructor) {
            for (Entity entity : entities) {
                NMSPacketPlayOutEntityDestroy.destroyEntity(player, entity);
            }
        } else {
            int[] ids = new int[entities.size()];
            AtomicInteger atomicInteger = new AtomicInteger(0);
            for (Entity entity : entities) {
                ids[atomicInteger.getAndIncrement()] = NMSEntity.getEntityID(entity);
            }
            try {
                NMSCraftPlayer.sendPacket(player, (Packet)((PacketPlayOutEntityDestroy)constructor.newInstance(new Object[]{ids})));
            }
            catch (Exception e) {
                NPCLib.DebugManager.printError(e);
            }
        }
    }

    public static boolean isSingleConstructor() {
        return singleConstructor;
    }
}

