/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.nms.minecraft;

import dev.sergiferry.playernpc.api.NPCLib;
import dev.sergiferry.spigot.nms.NMSUtils;
import dev.sergiferry.spigot.server.ServerVersion;
import java.lang.reflect.Constructor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.EntityLiving;

public class NMSPacketPlayOutAnimation {
    private static Class<?> clientboundHurtAnimationPacket;
    private static Constructor constructorHurtAnimation;

    public static void load() throws ClassNotFoundException, NoSuchMethodException {
        ServerVersion serverVersion = ServerVersion.getServerVersion();
        if (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_19_3)) {
            return;
        }
        clientboundHurtAnimationPacket = NMSUtils.getMinecraftClass("network.protocol.game.ClientboundHurtAnimationPacket");
        constructorHurtAnimation = clientboundHurtAnimationPacket.getConstructor(EntityLiving.class);
    }

    public static Packet getHurtAnimationPacket(EntityLiving entity) {
        if (constructorHurtAnimation == null) {
            return null;
        }
        try {
            return (Packet)constructorHurtAnimation.newInstance(entity);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
            return null;
        }
    }
}

