/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.nms.minecraft;

import dev.sergiferry.playernpc.api.NPCLib;
import dev.sergiferry.spigot.SpigotPlugin;
import dev.sergiferry.spigot.nms.NMSUtils;
import dev.sergiferry.spigot.nms.craftbukkit.NMSCraftPlayer;
import dev.sergiferry.spigot.server.ServerVersion;
import io.netty.channel.Channel;
import java.lang.reflect.Field;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.network.PlayerConnection;
import org.bukkit.entity.Player;

public class NMSNetworkManager {
    private static Class networkManagerClass;
    private static Field channel;
    private static Field networkManagerField;

    public static void load() throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
        ServerVersion serverVersion = SpigotPlugin.getServerVersion();
        networkManagerClass = NMSUtils.getMinecraftClass("network.NetworkManager");
        channel = serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_18_1) ? networkManagerClass.getField("k") : networkManagerClass.getField("m");
        channel.setAccessible(true);
        networkManagerField = serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_18_2) ? PlayerConnection.class.getField("a") : (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_19_3) ? PlayerConnection.class.getField("b") : PlayerConnection.class.getDeclaredField("h"));
    }

    public static NetworkManager getNetworkManager(Player player) {
        PlayerConnection playerConnection = NMSCraftPlayer.getPlayerConnection(player);
        try {
            networkManagerField.setAccessible(true);
            return (NetworkManager)networkManagerField.get(playerConnection);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
            return null;
        }
    }

    public static Channel getChannel(NetworkManager networkManager) {
        try {
            return (Channel)channel.get(networkManager);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

