/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.nms.minecraft;

import com.mojang.authlib.GameProfile;
import dev.sergiferry.playernpc.PlayerNPCPlugin;
import dev.sergiferry.playernpc.api.NPCLib;
import dev.sergiferry.spigot.SpigotPlugin;
import dev.sergiferry.spigot.nms.NMSUtils;
import dev.sergiferry.spigot.server.ServerVersion;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.WorldServer;

public class NMSEntityPlayer {
    private static Class entityPlayerClass;
    private static Class entityHumanClass;
    private static Constructor entityPlayerConstructor;
    private static Method getGameProfile;
    private static Field playerInteractManager;

    public static void load() throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
        ServerVersion serverVersion = SpigotPlugin.getServerVersion();
        entityPlayerClass = NMSUtils.getMinecraftClass("server.level.EntityPlayer");
        entityHumanClass = NMSUtils.getMinecraftClass("world.entity.player.EntityHuman");
        getGameProfile = serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_17_1) ? entityPlayerClass.getMethod("getProfile", new Class[0]) : (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_18_1) ? entityPlayerClass.getMethod("fp", new Class[0]) : (serverVersion.equals((Object)ServerVersion.VERSION_1_18_2) ? entityHumanClass.getMethod("fq", new Class[0]) : (serverVersion.equals((Object)ServerVersion.VERSION_1_19) ? entityHumanClass.getMethod("fz", new Class[0]) : (serverVersion.equals((Object)ServerVersion.VERSION_1_19_1) || serverVersion.equals((Object)ServerVersion.VERSION_1_19_2) ? entityHumanClass.getMethod("fy", new Class[0]) : (serverVersion.equals((Object)ServerVersion.VERSION_1_19_3) ? entityHumanClass.getMethod("fD", new Class[0]) : (serverVersion.equals((Object)ServerVersion.VERSION_1_19_4) ? entityHumanClass.getMethod("fI", new Class[0]) : entityHumanClass.getMethod("fM", new Class[0])))))));
        entityPlayerConstructor = serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_18_2) || serverVersion.isNewerThanOrEqual(ServerVersion.VERSION_1_19_3) ? entityPlayerClass.getConstructor(MinecraftServer.class, WorldServer.class, GameProfile.class) : entityPlayerClass.getConstructor(MinecraftServer.class, WorldServer.class, GameProfile.class, NMSUtils.getMinecraftClass("world.entity.player.ProfilePublicKey"));
        playerInteractManager = serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_19_4) ? entityPlayerClass.getField("d") : entityPlayerClass.getField("e");
    }

    public static EntityPlayer newEntityPlayer(MinecraftServer minecraftServer, WorldServer worldServer, GameProfile gameProfile) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        boolean longConstructor;
        boolean bl = longConstructor = entityPlayerConstructor.getParameterTypes().length > 3;
        if (longConstructor) {
            return (EntityPlayer)entityPlayerConstructor.newInstance(minecraftServer, worldServer, gameProfile, null);
        }
        return (EntityPlayer)entityPlayerConstructor.newInstance(minecraftServer, worldServer, gameProfile);
    }

    public static GameProfile getGameProfile(EntityPlayer player) {
        PlayerNPCPlugin.getInstance();
        ServerVersion serverVersion = PlayerNPCPlugin.getServerVersion();
        try {
            if (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_18_1)) {
                return (GameProfile)getGameProfile.invoke((Object)player, new Object[0]);
            }
            return (GameProfile)getGameProfile.invoke(entityHumanClass.cast(player), new Object[0]);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
            return null;
        }
    }

    public static PlayerInteractManager getPlayerInteractManager(EntityPlayer entityPlayer) {
        try {
            return (PlayerInteractManager)playerInteractManager.get(entityPlayer);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
            return null;
        }
    }
}

