/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.nms.minecraft;

import dev.sergiferry.playernpc.api.NPCLib;
import dev.sergiferry.spigot.SpigotPlugin;
import dev.sergiferry.spigot.nms.NMSUtils;
import dev.sergiferry.spigot.server.ServerVersion;
import java.lang.reflect.Method;
import net.minecraft.world.entity.decoration.EntityArmorStand;

public class NMSEntityArmorStand {
    private static Class entityArmorStandClass;
    private static Method setInvisible;
    private static Method setMarker;

    public static void load() throws ClassNotFoundException, NoSuchMethodException {
        ServerVersion serverVersion = SpigotPlugin.getServerVersion();
        entityArmorStandClass = NMSUtils.getMinecraftClass("world.entity.decoration.EntityArmorStand");
        if (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_17_1)) {
            setInvisible = entityArmorStandClass.getMethod("setInvisible", Boolean.TYPE);
            setMarker = entityArmorStandClass.getMethod("setMarker", Boolean.TYPE);
        } else {
            setInvisible = entityArmorStandClass.getMethod("j", Boolean.TYPE);
            setMarker = serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_19_3) ? entityArmorStandClass.getMethod("t", Boolean.TYPE) : entityArmorStandClass.getMethod("u", Boolean.TYPE);
        }
    }

    public static void setInvisible(EntityArmorStand entityArmorStand, boolean b) {
        try {
            setInvisible.invoke((Object)entityArmorStand, b);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
    }

    public static void setMarker(EntityArmorStand entityArmorStand, boolean b) {
        try {
            setMarker.invoke((Object)entityArmorStand, b);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
    }
}

