/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.nms.minecraft;

import dev.sergiferry.playernpc.api.NPCLib;
import dev.sergiferry.spigot.SpigotPlugin;
import dev.sergiferry.spigot.nms.NMSUtils;
import dev.sergiferry.spigot.server.ServerVersion;
import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.level.World;

public class NMSEntity {
    private static Class entityClass;
    private static Method setLocation;
    private static Method setYRot;
    private static Method setXRot;
    private static Method getUUID;
    private static Method getID;
    private static Method getCustomName;
    private static Method setCustomName;
    private static Method setCustomNameVisible;
    private static Method setNoGravity;
    private static Method getDataWatcher;
    private static Method setPose;
    private static Method setGlowingTag;
    private static Method getWorld;
    private static Method move;
    private static Method getX;
    private static Method getY;
    private static Method getZ;

    public static void load() throws ClassNotFoundException, NoSuchMethodException {
        ServerVersion serverVersion = SpigotPlugin.getServerVersion();
        entityClass = NMSUtils.getMinecraftClass("world.entity.Entity");
        if (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_17_1)) {
            setLocation = entityClass.getMethod("setLocation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            setYRot = entityClass.getMethod("setYRot", Float.TYPE);
            setXRot = entityClass.getMethod("setXRot", Float.TYPE);
            getID = entityClass.getMethod("getId", new Class[0]);
            getUUID = entityClass.getMethod("getUniqueID", new Class[0]);
            getCustomName = entityClass.getMethod("getCustomName", new Class[0]);
            setCustomName = entityClass.getMethod("setCustomName", IChatBaseComponent.class);
            setCustomNameVisible = entityClass.getMethod("setCustomNameVisible", Boolean.TYPE);
            setNoGravity = entityClass.getMethod("setNoGravity", Boolean.TYPE);
            getDataWatcher = entityClass.getMethod("getDataWatcher", new Class[0]);
            setPose = entityClass.getMethod("setPose", EntityPose.class);
            setGlowingTag = entityClass.getMethod("setGlowingTag", Boolean.TYPE);
            getWorld = entityClass.getMethod("getWorld", new Class[0]);
            move = entityClass.getMethod("g", Double.TYPE, Double.TYPE, Double.TYPE);
            getX = entityClass.getMethod("locX", new Class[0]);
            getY = entityClass.getMethod("locY", new Class[0]);
            getZ = entityClass.getMethod("locZ", new Class[0]);
        } else {
            setLocation = entityClass.getMethod("a", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            setYRot = entityClass.getMethod("o", Float.TYPE);
            setXRot = entityClass.getMethod("p", Float.TYPE);
            getID = serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_19_2) ? entityClass.getMethod("ae", new Class[0]) : (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_19_3) ? entityClass.getMethod("ah", new Class[0]) : entityClass.getMethod("af", new Class[0]));
            getUUID = serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_18_2) ? entityClass.getMethod("cm", new Class[0]) : (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_19) ? entityClass.getMethod("cp", new Class[0]) : (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_19_2) ? entityClass.getMethod("co", new Class[0]) : (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_19_4) ? entityClass.getMethod("cs", new Class[0]) : entityClass.getMethod("ct", new Class[0]))));
            getCustomName = entityClass.getMethod("Z", new Class[0]);
            setCustomName = serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_18_2) ? entityClass.getMethod("a", IChatBaseComponent.class) : entityClass.getMethod("b", IChatBaseComponent.class);
            setCustomNameVisible = entityClass.getMethod("n", Boolean.TYPE);
            setNoGravity = entityClass.getMethod("e", Boolean.TYPE);
            getDataWatcher = serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_19_2) ? entityClass.getMethod("ai", new Class[0]) : (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_19_3) ? entityClass.getMethod("al", new Class[0]) : entityClass.getMethod("aj", new Class[0]));
            setPose = entityClass.getMethod("b", EntityPose.class);
            setGlowingTag = entityClass.getMethod("i", Boolean.TYPE);
            getWorld = serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_18_2) ? entityClass.getMethod("cA", new Class[0]) : (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_19) ? entityClass.getMethod("cD", new Class[0]) : (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_19_2) ? entityClass.getMethod("cC", new Class[0]) : (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_19_3) ? entityClass.getMethod("cH", new Class[0]) : (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_19_4) ? entityClass.getMethod("cG", new Class[0]) : entityClass.getMethod("dI", new Class[0])))));
            move = serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_18_2) ? entityClass.getMethod("g", Double.TYPE, Double.TYPE, Double.TYPE) : entityClass.getMethod("h", Double.TYPE, Double.TYPE, Double.TYPE);
            if (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_18_2)) {
                getX = entityClass.getMethod("dc", new Class[0]);
                getY = entityClass.getMethod("de", new Class[0]);
                getZ = entityClass.getMethod("di", new Class[0]);
            } else if (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_19)) {
                getX = entityClass.getMethod("dg", new Class[0]);
                getY = entityClass.getMethod("di", new Class[0]);
                getZ = entityClass.getMethod("dm", new Class[0]);
            } else if (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_19_2)) {
                getX = entityClass.getMethod("df", new Class[0]);
                getY = entityClass.getMethod("dh", new Class[0]);
                getZ = entityClass.getMethod("dl", new Class[0]);
            } else if (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_19_3)) {
                getX = entityClass.getMethod("dk", new Class[0]);
                getY = entityClass.getMethod("dm", new Class[0]);
                getZ = entityClass.getMethod("dq", new Class[0]);
            } else {
                getX = entityClass.getMethod("dl", new Class[0]);
                getY = entityClass.getMethod("dn", new Class[0]);
                getZ = entityClass.getMethod("dr", new Class[0]);
            }
        }
    }

    public static void setLocation(Entity entity, double x, double y, double z, float yaw, float pitch) {
        try {
            setLocation.invoke((Object)entity, x, y, z, Float.valueOf(yaw), Float.valueOf(pitch));
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
    }

    public static void setYRot(Entity entity, float y) {
        try {
            setYRot.invoke((Object)entity, Float.valueOf(y));
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
    }

    public static void setXRot(Entity entity, float x) {
        try {
            setXRot.invoke((Object)entity, Float.valueOf(x));
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
    }

    public static void setPose(Entity entity, EntityPose pose) {
        try {
            setPose.invoke((Object)entity, pose);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
    }

    public static Integer getEntityID(Entity entity) {
        try {
            return (int)((Integer)getID.invoke((Object)entity, new Object[0]));
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
            return null;
        }
    }

    public static UUID getEntityUUID(Entity entity) {
        try {
            return (UUID)getUUID.invoke((Object)entity, new Object[0]);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
            return null;
        }
    }

    public static DataWatcher getDataWatcher(Entity entity) {
        try {
            return (DataWatcher)getDataWatcher.invoke((Object)entity, new Object[0]);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
            return null;
        }
    }

    public static void setCustomName(Entity entity, String name) {
        try {
            setCustomName.invoke((Object)entity, IChatBaseComponent.a((String)name));
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
    }

    public static void setCustomName(Entity entity, IChatBaseComponent chatBaseComponent) {
        try {
            setCustomName.invoke((Object)entity, chatBaseComponent);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
    }

    public static void setCustomNameVisible(Entity entity, boolean b) {
        try {
            setCustomNameVisible.invoke((Object)entity, b);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
    }

    public static void setNoGravity(Entity entity, boolean b) {
        try {
            setNoGravity.invoke((Object)entity, b);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
    }

    public static void setGlowingTag(Entity entity, boolean b) {
        try {
            setGlowingTag.invoke((Object)entity, b);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
    }

    public static IChatBaseComponent getCustomName(Entity entity) {
        try {
            return (IChatBaseComponent)getCustomName.invoke((Object)entity, new Object[0]);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
            return null;
        }
    }

    public static World getWorld(Entity entity) {
        try {
            return (World)getWorld.invoke((Object)entity, new Object[0]);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
            return null;
        }
    }

    public static void move(Entity entity, double x, double y, double z) {
        try {
            move.invoke((Object)entity, x, y, z);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
    }

    public static Double getX(Entity entity) {
        try {
            return (double)((Double)getX.invoke((Object)entity, new Object[0]));
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
            return null;
        }
    }

    public static Double getY(Entity entity) {
        try {
            return (double)((Double)getY.invoke((Object)entity, new Object[0]));
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
            return null;
        }
    }

    public static Double getZ(Entity entity) {
        try {
            return (double)((Double)getZ.invoke((Object)entity, new Object[0]));
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
            return null;
        }
    }
}

