/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.nms.minecraft;

import dev.sergiferry.playernpc.api.NPCLib;
import dev.sergiferry.spigot.SpigotPlugin;
import dev.sergiferry.spigot.server.ServerVersion;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityPose;

public class NMSDataWatcher {
    private static Method set;
    private static Method getMetadataList;
    private static Field mapInteger2DataWatcherItems;
    private static Field dataWatcherSerializer_Integer;
    private static Field dataWatcherSerializer_Boolean;
    private static Field dataWatcherSerializer_Byte;
    private static Field dataWatcherSerializer_EntityPose;

    public static void load() throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
        ServerVersion serverVersion = SpigotPlugin.getServerVersion();
        if (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_17_1)) {
            set = DataWatcher.class.getMethod("set", DataWatcherObject.class, Object.class);
            getMetadataList = DataWatcher.class.getMethod("getAll", new Class[0]);
        } else {
            set = DataWatcher.class.getMethod("b", DataWatcherObject.class, Object.class);
            getMetadataList = DataWatcher.class.getMethod("c", new Class[0]);
        }
        mapInteger2DataWatcherItems = ServerVersion.getServerVersion().isOlderThanOrEqual(ServerVersion.VERSION_1_19_2) ? DataWatcher.class.getDeclaredField("f") : DataWatcher.class.getDeclaredField("e");
        mapInteger2DataWatcherItems.setAccessible(true);
        dataWatcherSerializer_Byte = DataWatcherRegistry.class.getDeclaredField("a");
        dataWatcherSerializer_Integer = DataWatcherRegistry.class.getDeclaredField("b");
        if (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_18_2)) {
            dataWatcherSerializer_Boolean = DataWatcherRegistry.class.getDeclaredField("i");
            dataWatcherSerializer_EntityPose = DataWatcherRegistry.class.getDeclaredField("s");
        } else if (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_19_2)) {
            dataWatcherSerializer_Boolean = DataWatcherRegistry.class.getDeclaredField("j");
            dataWatcherSerializer_EntityPose = DataWatcherRegistry.class.getDeclaredField("u");
        } else if (serverVersion.isOlderThanOrEqual(ServerVersion.VERSION_1_19_3)) {
            dataWatcherSerializer_Boolean = DataWatcherRegistry.class.getDeclaredField("i");
            dataWatcherSerializer_EntityPose = DataWatcherRegistry.class.getDeclaredField("t");
        } else {
            dataWatcherSerializer_Boolean = DataWatcherRegistry.class.getDeclaredField("k");
            dataWatcherSerializer_EntityPose = DataWatcherRegistry.class.getDeclaredField("v");
        }
    }

    public static <T> void set(DataWatcher dataWatcher, DataWatcherObject<T> dataWatcherObject, T o) {
        try {
            set.invoke((Object)dataWatcher, dataWatcherObject, o);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
        }
    }

    public static List getMetadataList(DataWatcher dataWatcher) {
        try {
            return (List)getMetadataList.invoke((Object)dataWatcher, new Object[0]);
        }
        catch (Exception e) {
            NPCLib.DebugManager.printError(e);
            return null;
        }
    }

    public static DataWatcherSerializer<Byte> getDataWatcherSerializerByte() {
        try {
            return (DataWatcherSerializer)dataWatcherSerializer_Byte.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static DataWatcherSerializer<Integer> getDataWatcherSerializerInteger() {
        try {
            return (DataWatcherSerializer)dataWatcherSerializer_Integer.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static DataWatcherSerializer<Boolean> getDataWatcherSerializerBoolean() {
        try {
            return (DataWatcherSerializer)dataWatcherSerializer_Boolean.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static DataWatcherSerializer<EntityPose> getDataWatcherSerializerEntityPose() {
        try {
            return (DataWatcherSerializer)dataWatcherSerializer_EntityPose.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<Integer, DataWatcher.Item<?>> getMapOfDataWatcherItems(DataWatcher dataWatcher) {
        try {
            return (Map)mapInteger2DataWatcherItems.get(dataWatcher);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }
}

