/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.integration.integrations;

import dev.sergiferry.playernpc.integration.Integration;
import dev.sergiferry.playernpc.integration.IntegrationsManager;
import dev.sergiferry.playernpc.integration.PluginIntegration;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import net.milkbowl.vault.permission.Permission;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class Vault
extends PluginIntegration {
    private Economy economy;
    private Permission permission;
    private Chat chat;
    private EconomyManager economyManager;

    public Vault(Plugin vaultPlugin) {
        super(Integration.Type.VAULT, vaultPlugin);
    }

    @Override
    public void load() {
        RegisteredServiceProvider permission;
        RegisteredServiceProvider chat;
        RegisteredServiceProvider economy = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (economy != null) {
            this.economy = (Economy)economy.getProvider();
        }
        if ((chat = Bukkit.getServicesManager().getRegistration(Chat.class)) != null) {
            this.chat = (Chat)chat.getProvider();
        }
        if ((permission = Bukkit.getServicesManager().getRegistration(Permission.class)) != null) {
            this.permission = (Permission)permission.getProvider();
        }
        Bukkit.getConsoleSender().sendMessage(IntegrationsManager.getPlugin().getPrefix() + "\u00a77Vault hooked integrations:");
        Bukkit.getConsoleSender().sendMessage("\u00a78- " + (economy != null ? "\u00a7a" : "\u00a7c") + "Economy \u00a77(" + (String)(economy != null ? economy.getPlugin().getName() + " v" + economy.getPlugin().getDescription().getVersion() : "No hooked integration") + ")");
        Bukkit.getConsoleSender().sendMessage("\u00a78- " + (chat != null ? "\u00a7a" : "\u00a7c") + "Chat \u00a77(" + (String)(chat != null ? chat.getPlugin().getName() + " v" + chat.getPlugin().getDescription().getVersion() : "No hooked integration") + ")");
        Bukkit.getConsoleSender().sendMessage("\u00a78- " + (permission != null ? "\u00a7a" : "\u00a7c") + "Permission \u00a77(" + (String)(permission != null ? permission.getPlugin().getName() + " v" + permission.getPlugin().getDescription().getVersion() : "No hooked integration") + ")");
        if (economy == null && chat == null && permission == null) {
            Bukkit.getConsoleSender().sendMessage(IntegrationsManager.getPlugin().getPrefix() + "\u00a7cNo plugin is using Vault API. Removing integration...");
            this.removeIntegration();
            return;
        }
        this.economyManager = new EconomyManager(this);
    }

    @Override
    public void unload() {
        this.economy = null;
        this.permission = null;
        this.chat = null;
        this.economyManager = null;
    }

    public Economy getEconomy() {
        Validate.notNull((Object)this.economy, (String)"No Economy plugin is using Vault API");
        return this.economy;
    }

    public Chat getChat() {
        Validate.notNull((Object)this.economy, (String)"No Chat plugin is using Vault API");
        return this.chat;
    }

    public Permission getPermission() {
        Validate.notNull((Object)this.economy, (String)"No Permission plugin is using Vault API");
        return this.permission;
    }

    public boolean isUsingEconomy() {
        return this.economy != null;
    }

    public boolean isUsingChat() {
        return this.chat != null;
    }

    public boolean isUsingPermission() {
        return this.permission != null;
    }

    public EconomyManager getEconomyManager() {
        return this.economyManager;
    }

    public static class EconomyManager {
        private Vault vault;

        public EconomyManager(Vault vault) {
            this.vault = vault;
        }

        public String getBalanceFormat(Player player) {
            return this.getFormat(this.getBalance(player));
        }

        public String getFormat(double balance) {
            return this.vault.getEconomy().format(balance);
        }

        public Double getBalance(Player player) {
            return this.vault.getEconomy().getBalance((OfflinePlayer)player);
        }

        public boolean hasBalance(Player player, double balance) {
            return this.getBalance(player) >= balance;
        }

        public EconomyResponse addBalance(Player player, double balance) {
            return this.vault.getEconomy().depositPlayer((OfflinePlayer)player, balance);
        }

        public EconomyResponse withdrawBalance(Player player, double balance) {
            return this.vault.getEconomy().withdrawPlayer((OfflinePlayer)player, balance);
        }
    }
}

