/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.integration.integrations;

import dev.sergiferry.playernpc.api.NPC;
import dev.sergiferry.playernpc.api.NPCLib;
import dev.sergiferry.playernpc.integration.Integration;
import dev.sergiferry.playernpc.integration.IntegrationsManager;
import dev.sergiferry.playernpc.integration.PluginIntegration;
import java.util.List;
import java.util.Optional;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.expansion.Relational;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlaceholderAPI
extends PluginIntegration {
    private Extension extension = new Extension((Plugin)IntegrationsManager.getPlugin());

    public PlaceholderAPI(Plugin plugin) {
        super(Integration.Type.PLACEHOLDER_API, plugin);
    }

    @Override
    public void load() {
        this.extension.register();
    }

    @Override
    public void unload() {
        this.extension.unregister();
    }

    public String replace(Player player, String text) {
        return me.clip.placeholderapi.PlaceholderAPI.setPlaceholders((Player)player, (String)text);
    }

    public List<String> replace(Player player, List<String> text) {
        return me.clip.placeholderapi.PlaceholderAPI.setPlaceholders((Player)player, text);
    }

    public String replace(OfflinePlayer player, String text) {
        return me.clip.placeholderapi.PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)text);
    }

    public List<String> replace(OfflinePlayer player, List<String> text) {
        return me.clip.placeholderapi.PlaceholderAPI.setPlaceholders((OfflinePlayer)player, text);
    }

    public static class Extension
    extends PlaceholderExpansion
    implements Relational {
        private Plugin plugin;

        public Extension(Plugin plugin) {
            this.plugin = plugin;
        }

        public String getIdentifier() {
            return this.plugin.getName().toLowerCase();
        }

        public String getAuthor() {
            return (String)this.plugin.getDescription().getAuthors().get(0);
        }

        public String getVersion() {
            return this.plugin.getDescription().getVersion();
        }

        public boolean persist() {
            return true;
        }

        public boolean canRegister() {
            return true;
        }

        public String onPlaceholderRequest(Player player, String identifier) {
            if ((identifier = identifier.toLowerCase()).equals("author")) {
                return this.getAuthor();
            }
            if (identifier.equals("version")) {
                return this.getVersion();
            }
            if (identifier.startsWith("global_") || identifier.startsWith("personal_")) {
                String id = identifier.substring(identifier.indexOf("(") + 1, identifier.indexOf(")"));
                Optional<NPC> optionalNPC = null;
                NPCLib npcLib = NPCLib.getInstance();
                if (identifier.startsWith("global_")) {
                    optionalNPC = npcLib.grabGlobalNPC(id);
                } else if (identifier.startsWith("personal_")) {
                    optionalNPC = npcLib.grabPersonalNPC(player, id);
                }
                if (optionalNPC.isEmpty()) {
                    return null;
                }
                NPC npc = optionalNPC.get();
                if (identifier.endsWith("_id") || identifier.endsWith("_fullid")) {
                    return npc.getFullID();
                }
                if (identifier.endsWith("_simpleid")) {
                    return npc.getSimpleID();
                }
                if (identifier.endsWith("_tablist-name")) {
                    return npc.getTabListName();
                }
                if (identifier.endsWith("_nametag")) {
                    return npc.getNameTag().toString();
                }
                if (identifier.endsWith("_world")) {
                    return npc.getWorld().getName();
                }
            }
            return null;
        }

        public String onPlaceholderRequest(Player playerOne, Player playerTwo, String identifier) {
            return this.onPlaceholderRequest(playerOne, identifier);
        }
    }
}

