/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.integration.integrations;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import dev.sergiferry.playernpc.PlayerNPCPlugin;
import dev.sergiferry.playernpc.api.NPC;
import dev.sergiferry.playernpc.integration.Integration;
import dev.sergiferry.playernpc.integration.IntegrationsManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.function.TriFunction;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class BungeeCord
extends Integration
implements PluginMessageListener {
    private static final String CHANNEL = "BungeeCord";
    private static final Long TIME_OUT_LONG = 10L;
    private static final TimeUnit TIME_OUT_UNIT = TimeUnit.SECONDS;
    private Integer task;
    @Nullable
    private Boolean detectedBungee;

    public BungeeCord() {
        super(Integration.Type.BUNGEECORD);
        IntegrationsManager.getIntegrations().add(this);
        this.detectedBungee = null;
    }

    @Override
    protected void load() {
        if (!Bukkit.getServer().getMessenger().isIncomingChannelRegistered(BungeeCord.getPlugin(), CHANNEL)) {
            Bukkit.getServer().getMessenger().registerIncomingPluginChannel(BungeeCord.getPlugin(), CHANNEL, (PluginMessageListener)this);
        }
        if (!Bukkit.getServer().getMessenger().isOutgoingChannelRegistered(BungeeCord.getPlugin(), CHANNEL)) {
            Bukkit.getServer().getMessenger().registerOutgoingPluginChannel(BungeeCord.getPlugin(), CHANNEL);
        }
        new SubChannel.Connect();
        new SubChannel.ConnectOther();
        new SubChannel.IP();
        new SubChannel.IPOther();
        new SubChannel.PlayerCount();
        new SubChannel.PlayerList();
        new SubChannel.GetServers();
        new SubChannel.Message();
        new SubChannel.MessageRaw();
        new SubChannel.GetServer();
        new SubChannel.UUID();
        new SubChannel.UUIDOther();
        new SubChannel.ServerIP();
        new SubChannel.KickPlayer();
    }

    @Override
    protected void unload() {
        if (Bukkit.getServer().getMessenger().isOutgoingChannelRegistered(BungeeCord.getPlugin(), CHANNEL)) {
            Bukkit.getServer().getMessenger().unregisterOutgoingPluginChannel(BungeeCord.getPlugin(), CHANNEL);
        }
        if (Bukkit.getServer().getMessenger().isIncomingChannelRegistered(BungeeCord.getPlugin(), CHANNEL)) {
            Bukkit.getServer().getMessenger().unregisterIncomingPluginChannel(BungeeCord.getPlugin(), CHANNEL);
        }
        SubChannel.MAP.clear();
        if (this.task != null) {
            Bukkit.getScheduler().cancelTask(this.task.intValue());
        }
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        if (!channel.equals(CHANNEL)) {
            return;
        }
        this.detectedBungee = true;
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
        String sub = in.readUTF();
        SubChannel.Name.from(sub).ifPresent(subChannel -> ((SubChannel.ResultListener)((Object)SubChannel.MAP.get(subChannel))).listen(player, in));
    }

    public void update() {
        if (this.detectedBungee == null) {
            this.check();
            return;
        }
        if (!this.detectedBungee.booleanValue()) {
            return;
        }
        this.subChannelGetServers().askServers().thenAccept(x -> x.ifPresentOrElse(y -> {
            for (String s : y.list) {
                this.subChannelPlayerCount().askPlayerCount(s);
            }
        }, () -> {
            if (!Bukkit.getOnlinePlayers().isEmpty()) {
                BungeeCord.getPlugin().getLogger().warning("Failed to update BungeeCord info");
            }
        }));
    }

    public void check() {
        if (this.detectedBungee != null) {
            return;
        }
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask(BungeeCord.getPlugin(), () -> {
            this.subChannelGetServers().askServers();
            this.subChannelGetServer().askServerName().thenAccept(x -> x.ifPresentOrElse(a -> this.setState(true), () -> this.setState(false)));
        });
    }

    public State getState() {
        return this.detectedBungee != null ? (this.detectedBungee.booleanValue() ? State.CONNECTED : State.DISCONNECTED) : State.NOT_CHECKED;
    }

    public boolean isConnected() {
        return this.getState().equals((Object)State.CONNECTED);
    }

    public boolean isDisconnected() {
        return this.getState().equals((Object)State.DISCONNECTED);
    }

    private void setState(boolean detectedBungee) {
        this.detectedBungee = detectedBungee;
        if (detectedBungee) {
            Bukkit.getConsoleSender().sendMessage(PlayerNPCPlugin.getInstance().getPrefix() + "\u00a77Hooked into \u00a7aBungeeCord \u00a77as " + this.subChannelGetServer().grabServerName().get().server() + " server");
            NPC.Placeholders.addSimplePlaceholder("bungeeServerName", (npc, player) -> this.subChannelGetServer().grabServerName().map(x -> x.server()).orElse(null), null);
            NPC.Placeholders.addSimplePlaceholder("bungeeOnlinePlayers", (npc, player) -> this.subChannelPlayerCount().getTotalCount().toString(), null);
            NPC.Placeholders.addAdvancedPlaceholder("bungeeOnlinePlayers", "server", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, player, server) -> this.isConnected() ? (String)this.subChannelPlayerCount().grabPlayerCount((String)server).map(x -> "" + x.count()).orElse(null) : null), null, (npc, player) -> {
                Optional<SubChannel.GetServers.Result> serverList = this.subChannelGetServers().grabServers();
                Optional<SubChannel.GetServer.Result> currentServer = this.subChannelGetServer().grabServerName();
                if (serverList.isEmpty()) {
                    return null;
                }
                return Arrays.stream(serverList.get().list()).filter(x -> !currentServer.isPresent() || !x.equals(this.subChannelGetServer().grabServerName().get().server())).collect(Collectors.toList());
            });
            this.update();
            this.task = Bukkit.getScheduler().scheduleSyncRepeatingTask(BungeeCord.getPlugin(), () -> this.update(), 600L, 600L);
        }
    }

    public SubChannel.Connect subChannelConnect() {
        return (SubChannel.Connect)SubChannel.MAP.get((Object)SubChannel.Name.CONNECT);
    }

    public SubChannel.ConnectOther subChannelConnectOther() {
        return (SubChannel.ConnectOther)SubChannel.MAP.get((Object)SubChannel.Name.CONNECT_OTHER);
    }

    public SubChannel.IP subChannelIP() {
        return (SubChannel.IP)SubChannel.MAP.get((Object)SubChannel.Name.IP);
    }

    public SubChannel.IPOther subChannelIPOther() {
        return (SubChannel.IPOther)SubChannel.MAP.get((Object)SubChannel.Name.IP_OTHER);
    }

    public SubChannel.PlayerCount subChannelPlayerCount() {
        return (SubChannel.PlayerCount)SubChannel.MAP.get((Object)SubChannel.Name.PLAYER_COUNT);
    }

    public SubChannel.PlayerList subChannelPlayerList() {
        return (SubChannel.PlayerList)SubChannel.MAP.get((Object)SubChannel.Name.PLAYER_LIST);
    }

    public SubChannel.GetServer subChannelGetServer() {
        return (SubChannel.GetServer)SubChannel.MAP.get((Object)SubChannel.Name.GET_SERVER);
    }

    public SubChannel.GetServers subChannelGetServers() {
        return (SubChannel.GetServers)SubChannel.MAP.get((Object)SubChannel.Name.GET_SERVERS);
    }

    public SubChannel.Message subChannelMessage() {
        return (SubChannel.Message)SubChannel.MAP.get((Object)SubChannel.Name.MESSAGE);
    }

    public SubChannel.MessageRaw subChannelMessageRaw() {
        return (SubChannel.MessageRaw)SubChannel.MAP.get((Object)SubChannel.Name.MESSAGE_RAW);
    }

    public SubChannel.UUID subChannelUUID() {
        return (SubChannel.UUID)SubChannel.MAP.get((Object)SubChannel.Name.UUID);
    }

    public SubChannel.UUIDOther subChannelUUIDOther() {
        return (SubChannel.UUIDOther)SubChannel.MAP.get((Object)SubChannel.Name.UUID_OTHER);
    }

    public SubChannel.ServerIP subChannelServerIP() {
        return (SubChannel.ServerIP)SubChannel.MAP.get((Object)SubChannel.Name.SERVER_IP);
    }

    public SubChannel.KickPlayer subChannelKickPlayer() {
        return (SubChannel.KickPlayer)SubChannel.MAP.get((Object)SubChannel.Name.KICK_PLAYER);
    }

    public static Plugin getPlugin() {
        return PlayerNPCPlugin.getInstance();
    }

    public static abstract class SubChannel {
        private static final Map<Name, SubChannel> MAP = new HashMap<Name, SubChannel>();
        private Name name;

        protected SubChannel(Name name) {
            this.name = name;
            MAP.put(name, this);
        }

        protected ByteArrayDataOutput createOutput() {
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF(this.name.toString());
            return out;
        }

        protected static Optional<Player> getRandomPlayer() {
            return Bukkit.getOnlinePlayers().stream().map(x -> x).findFirst();
        }

        protected void sendPluginMessage(Player player, byte[] message) {
            player.sendPluginMessage(BungeeCord.getPlugin(), BungeeCord.CHANNEL, message);
        }

        protected void sendPluginMessage(byte[] message) {
            SubChannel.getRandomPlayer().ifPresent(player -> this.sendPluginMessage((Player)player, message));
        }

        public static enum Name {
            CONNECT("Connect", Connect.class),
            CONNECT_OTHER("ConnectOther", ConnectOther.class),
            IP("IP", IP.class),
            IP_OTHER("IPOther", IPOther.class),
            PLAYER_COUNT("PlayerCount", PlayerCount.class),
            PLAYER_LIST("PlayerList", PlayerList.class),
            GET_SERVERS("GetServers", GetServers.class),
            MESSAGE("Message", Message.class),
            MESSAGE_RAW("MessageRaw", MessageRaw.class),
            GET_SERVER("GetServer", GetServer.class),
            FORWARD("Forward", null),
            FORWARD_TO_PLAYER("ForwardToPlayer", null),
            UUID("UUID", UUID.class),
            UUID_OTHER("UUIDOther", UUIDOther.class),
            SERVER_IP("ServerIP", ServerIP.class),
            KICK_PLAYER("KickPlayer", KickPlayer.class);

            private Class<? extends SubChannel> clazz;
            private String name;

            private Name(String name, Class<? extends SubChannel> clazz) {
                this.name = name;
                this.clazz = clazz;
            }

            public String toString() {
                return this.name;
            }

            public Class<? extends SubChannel> getClazz() {
                return this.clazz;
            }

            public static Optional<Name> from(String sub) {
                return Arrays.stream(Name.values()).filter(x -> x.name.equals(sub)).findFirst();
            }
        }

        public static class KickPlayer
        extends SubChannel {
            protected KickPlayer() {
                super(Name.KICK_PLAYER);
            }

            public void kick(String playerName, String reason) {
                Optional<Player> player = KickPlayer.getRandomPlayer();
                if (player.isEmpty()) {
                    return;
                }
                ByteArrayDataOutput out = this.createOutput();
                out.writeUTF(playerName);
                out.writeUTF(reason);
                this.sendPluginMessage(player.get(), out.toByteArray());
            }
        }

        public static class ServerIP
        extends SubChannel
        implements ResultListener {
            private CompletableFuture<Optional<Result>> pending;

            protected ServerIP() {
                super(Name.SERVER_IP);
            }

            public CompletableFuture<Optional<Result>> getServerIP(String serverName) {
                Optional<Player> player = ServerIP.getRandomPlayer();
                if (player.isEmpty()) {
                    return CompletableFuture.completedFuture(Optional.empty());
                }
                ByteArrayDataOutput out = this.createOutput();
                out.writeUTF(serverName);
                this.sendPluginMessage(player.get(), out.toByteArray());
                this.pending = new CompletableFuture().completeOnTimeout(Optional.empty(), TIME_OUT_LONG, TIME_OUT_UNIT);
                return this.pending;
            }

            @Override
            public void listen(Player player, ByteArrayDataInput input) {
                if (this.pending == null) {
                    return;
                }
                this.pending.complete(Optional.of(new Result(input.readUTF(), input.readUTF(), input.readInt())));
                this.pending = null;
            }

            public record Result(String serverName, String ip, int port) {
            }
        }

        public static class UUIDOther
        extends SubChannel
        implements ResultListener {
            private Map<String, CompletableFuture<Optional<Result>>> pending = new HashMap<String, CompletableFuture<Optional<Result>>>();
            private Map<String, Result> results = new HashMap<String, Result>();

            protected UUIDOther() {
                super(Name.UUID_OTHER);
            }

            public CompletableFuture<Optional<Result>> getUUID(String playerName) {
                Optional<Player> player = UUIDOther.getRandomPlayer();
                if (player.isEmpty()) {
                    return CompletableFuture.completedFuture(Optional.empty());
                }
                ByteArrayDataOutput out = this.createOutput();
                out.writeUTF(playerName);
                this.sendPluginMessage(player.get(), out.toByteArray());
                this.pending.put(playerName, new CompletableFuture().completeOnTimeout(Optional.empty(), TIME_OUT_LONG, TIME_OUT_UNIT));
                return this.pending.get(playerName);
            }

            @Override
            public void listen(Player player, ByteArrayDataInput input) {
                String playerName = input.readUTF();
                this.results.put(playerName, new Result(playerName, input.readUTF()));
                if (!this.pending.containsKey(playerName)) {
                    return;
                }
                this.pending.get(playerName).complete(Optional.of(this.results.get(playerName)));
                this.pending.put(playerName, null);
            }

            public record Result(String playerName, String uuid) {
            }
        }

        public static class UUID
        extends SubChannel
        implements ResultListener {
            private CompletableFuture<Optional<Result>> pending;

            protected UUID() {
                super(Name.UUID);
            }

            public CompletableFuture<Optional<Result>> getUUID(Player player) {
                this.sendPluginMessage(player, this.createOutput().toByteArray());
                this.pending = new CompletableFuture().completeOnTimeout(Optional.empty(), TIME_OUT_LONG, TIME_OUT_UNIT);
                return this.pending;
            }

            @Override
            public void listen(Player player, ByteArrayDataInput input) {
                if (this.pending == null) {
                    return;
                }
                this.pending.complete(Optional.of(new Result(player, input.readUTF())));
                this.pending = null;
            }

            public record Result(Player player, String uuid) {
            }
        }

        public static class GetServer
        extends SubChannel
        implements ResultListener {
            private CompletableFuture<Optional<Result>> pending;
            private Result lastResult;

            protected GetServer() {
                super(Name.GET_SERVER);
            }

            public CompletableFuture<Optional<Result>> askServerName() {
                Optional<Player> player = GetServer.getRandomPlayer();
                if (player.isEmpty()) {
                    return CompletableFuture.completedFuture(Optional.empty());
                }
                this.sendPluginMessage(player.get(), this.createOutput().toByteArray());
                this.pending = new CompletableFuture().completeOnTimeout(Optional.empty(), TIME_OUT_LONG, TIME_OUT_UNIT);
                return this.pending;
            }

            public Optional<Result> grabServerName() {
                return Optional.ofNullable(this.lastResult);
            }

            @Override
            public void listen(Player player, ByteArrayDataInput input) {
                this.lastResult = new Result(input.readUTF());
                if (this.pending == null) {
                    return;
                }
                this.pending.complete(Optional.of(this.lastResult));
                this.pending = null;
            }

            public record Result(String server) {
            }
        }

        public static class MessageRaw
        extends SubChannel {
            protected MessageRaw() {
                super(Name.MESSAGE_RAW);
            }

            public void sendRawMessage(String playerName, String rawMessage) {
                Optional<Player> player = MessageRaw.getRandomPlayer();
                if (player.isEmpty()) {
                    return;
                }
                ByteArrayDataOutput out = this.createOutput();
                out.writeUTF(playerName);
                out.writeUTF(rawMessage);
                this.sendPluginMessage(player.get(), out.toByteArray());
            }
        }

        public static class Message
        extends SubChannel {
            protected Message() {
                super(Name.MESSAGE);
            }

            public void sendMessage(String playerName, String message) {
                Optional<Player> player = Message.getRandomPlayer();
                if (player.isEmpty()) {
                    return;
                }
                ByteArrayDataOutput out = this.createOutput();
                out.writeUTF(playerName);
                out.writeUTF(message);
                this.sendPluginMessage(player.get(), out.toByteArray());
            }
        }

        public static class GetServers
        extends SubChannel
        implements ResultListener {
            private CompletableFuture<Optional<Result>> pending;
            private Result lastResult;

            protected GetServers() {
                super(Name.GET_SERVERS);
            }

            public CompletableFuture<Optional<Result>> askServers() {
                Optional<Player> player = GetServers.getRandomPlayer();
                if (player.isEmpty()) {
                    return CompletableFuture.completedFuture(Optional.empty());
                }
                this.sendPluginMessage(player.get(), this.createOutput().toByteArray());
                this.pending = new CompletableFuture().completeOnTimeout(Optional.empty(), TIME_OUT_LONG, TIME_OUT_UNIT);
                return this.pending;
            }

            public Optional<Result> grabServers() {
                return Optional.ofNullable(this.lastResult);
            }

            @Override
            public void listen(Player player, ByteArrayDataInput input) {
                this.lastResult = new Result(input.readUTF().split(", "));
                if (this.pending == null) {
                    return;
                }
                this.pending.complete(Optional.of(this.lastResult));
                this.pending = null;
            }

            public record Result(String[] list) {
            }
        }

        public static class PlayerList
        extends SubChannel
        implements ResultListener {
            private Map<String, CompletableFuture<Optional<Result>>> pending;
            private Map<String, Result> results = new HashMap<String, Result>();

            protected PlayerList() {
                super(Name.PLAYER_LIST);
                this.pending = new HashMap<String, CompletableFuture<Optional<Result>>>();
            }

            public CompletableFuture<Optional<Result>> askPlayerList(String server) {
                Optional<Player> player = PlayerList.getRandomPlayer();
                if (player.isEmpty()) {
                    return CompletableFuture.completedFuture(Optional.empty());
                }
                ByteArrayDataOutput out = this.createOutput();
                out.writeUTF(server);
                this.sendPluginMessage(player.get(), out.toByteArray());
                this.pending.put(server, new CompletableFuture().completeOnTimeout(Optional.empty(), TIME_OUT_LONG, TIME_OUT_UNIT));
                return this.pending.get(server);
            }

            public Optional<Result> grabPlayerList(String server) {
                return Optional.ofNullable(this.results.getOrDefault(server, null));
            }

            @Override
            public void listen(Player player, ByteArrayDataInput input) {
                String server = input.readUTF();
                this.results.put(server, new Result(server, input.readUTF().split(", ")));
                if (!this.pending.containsKey(server)) {
                    return;
                }
                this.pending.get(server).complete(Optional.of(this.results.get(server)));
                this.pending.put(server, null);
            }

            public record Result(String server, String[] list) {
            }
        }

        public static class PlayerCount
        extends SubChannel
        implements ResultListener {
            private Map<String, CompletableFuture<Optional<Result>>> pending;
            private Map<String, Result> results = new HashMap<String, Result>();

            public PlayerCount() {
                super(Name.PLAYER_COUNT);
                this.pending = new HashMap<String, CompletableFuture<Optional<Result>>>();
            }

            public CompletableFuture<Optional<Result>> askPlayerCount(String server) {
                Optional<Player> player = PlayerCount.getRandomPlayer();
                if (player.isEmpty()) {
                    return CompletableFuture.completedFuture(Optional.empty());
                }
                ByteArrayDataOutput out = this.createOutput();
                out.writeUTF(server);
                this.sendPluginMessage(player.get(), out.toByteArray());
                this.pending.put(server, new CompletableFuture().completeOnTimeout(Optional.empty(), TIME_OUT_LONG, TIME_OUT_UNIT));
                return this.pending.get(server);
            }

            public Optional<Result> grabPlayerCount(String server) {
                return Optional.ofNullable(this.results.getOrDefault(server, null));
            }

            public Integer getTotalCount() {
                AtomicInteger total = new AtomicInteger(0);
                Arrays.stream(IntegrationsManager.getBungeeCord().subChannelGetServers().grabServers().get().list).forEach(x -> total.addAndGet(this.grabPlayerCount((String)x).map(y -> y.count()).orElse(0)));
                return total.get();
            }

            @Override
            public void listen(Player player, ByteArrayDataInput input) {
                String server = input.readUTF();
                this.results.put(server, new Result(server, input.readInt()));
                if (!this.pending.containsKey(server)) {
                    return;
                }
                this.pending.get(server).complete(Optional.of(this.results.get(server)));
                this.pending.put(server, null);
            }

            public record Result(String server, int count) {
            }
        }

        public static class IPOther
        extends SubChannel
        implements ResultListener {
            private CompletableFuture<Optional<Result>> pending;

            protected IPOther() {
                super(Name.IP_OTHER);
            }

            public CompletableFuture<Optional<Result>> askIP(String playerName) {
                Optional<Player> player = IPOther.getRandomPlayer();
                if (player.isEmpty()) {
                    return CompletableFuture.completedFuture(Optional.empty());
                }
                ByteArrayDataOutput out = this.createOutput();
                out.writeUTF(playerName);
                this.sendPluginMessage(player.get(), out.toByteArray());
                this.pending = new CompletableFuture().completeOnTimeout(Optional.empty(), TIME_OUT_LONG, TIME_OUT_UNIT);
                return this.pending;
            }

            @Override
            public void listen(Player player, ByteArrayDataInput input) {
                if (this.pending == null) {
                    return;
                }
                this.pending.complete(Optional.of(new Result(input.readUTF(), input.readUTF(), input.readInt())));
                this.pending = null;
            }

            public record Result(String playerName, String server, int count) {
            }
        }

        public static class IP
        extends SubChannel
        implements ResultListener {
            private CompletableFuture<Optional<Result>> pending;

            protected IP() {
                super(Name.IP);
            }

            public CompletableFuture<Optional<Result>> askIP(@Nonnull Player player) {
                this.sendPluginMessage(player, this.createOutput().toByteArray());
                this.pending = new CompletableFuture().completeOnTimeout(Optional.empty(), TIME_OUT_LONG, TIME_OUT_UNIT);
                return this.pending;
            }

            @Override
            public void listen(Player player, ByteArrayDataInput input) {
                if (this.pending == null) {
                    return;
                }
                this.pending.complete(Optional.of(new Result(input.readUTF(), input.readInt())));
                this.pending = null;
            }

            public record Result(String ip, int port) {
            }
        }

        public static class ConnectOther
        extends SubChannel {
            protected ConnectOther() {
                super(Name.CONNECT_OTHER);
            }

            public void connect(String playerName, String server) {
                Optional<Player> player = ConnectOther.getRandomPlayer();
                if (player.isEmpty()) {
                    return;
                }
                ByteArrayDataOutput out = this.createOutput();
                out.writeUTF(playerName);
                out.writeUTF(server);
                this.sendPluginMessage(player.get(), out.toByteArray());
            }
        }

        public static class Connect
        extends SubChannel {
            protected Connect() {
                super(Name.CONNECT);
            }

            public void connect(@Nonnull Player player, String server) {
                ByteArrayDataOutput out = this.createOutput();
                out.writeUTF(server);
                this.sendPluginMessage(player, out.toByteArray());
            }
        }

        public static interface ResultListener {
            public void listen(Player var1, ByteArrayDataInput var2);
        }
    }

    public static enum State {
        NOT_CHECKED,
        CONNECTED,
        DISCONNECTED;

    }
}

