/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.integration;

import dev.sergiferry.playernpc.PlayerNPCPlugin;
import dev.sergiferry.playernpc.integration.Integration;
import dev.sergiferry.playernpc.integration.PluginIntegration;
import dev.sergiferry.playernpc.integration.integrations.BungeeCord;
import dev.sergiferry.playernpc.integration.integrations.PlaceholderAPI;
import dev.sergiferry.playernpc.integration.integrations.Vault;
import dev.sergiferry.playernpc.integration.integrations.ViaVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.plugin.Plugin;

public class IntegrationsManager {
    private static List<Integration> integrations;
    private static BungeeCord bungeeCord;
    private static PlaceholderAPI placeholderAPI;
    private static Vault vault;
    private static ViaVersion viaVersion;

    public static void onEnable() {
        IntegrationsManager.check();
        IntegrationsManager.load();
    }

    public static void onDisable() {
        IntegrationsManager.unload();
    }

    private static void check() {
        integrations = new ArrayList<Integration>();
        IntegrationsManager.getPlugin().getServer().getConsoleSender().sendMessage(IntegrationsManager.getPlugin().getPrefix() + "\u00a77Looking for soft dependencies...");
        bungeeCord = new BungeeCord();
        IntegrationsManager.checkViaVersion();
        IntegrationsManager.checkVault();
        IntegrationsManager.checkPlaceHolderAPI();
        if (IntegrationsManager.getHookedPlugins().isEmpty()) {
            IntegrationsManager.getPlugin().getServer().getConsoleSender().sendMessage(IntegrationsManager.getPlugin().getPrefix() + "\u00a77No soft dependencies were found.");
        }
    }

    private static void load() {
        integrations.forEach(x -> x.load());
    }

    private static void unload() {
        integrations.forEach(x -> x.unload());
    }

    private static void checkViaVersion() {
        Plugin viaVersionPlugin = IntegrationsManager.getPlugin().getServer().getPluginManager().getPlugin("ViaVersion");
        if (viaVersionPlugin == null || !viaVersionPlugin.isEnabled()) {
            return;
        }
        viaVersion = new ViaVersion(viaVersionPlugin);
    }

    private static void checkVault() {
        Plugin vaultPlugin = IntegrationsManager.getPlugin().getServer().getPluginManager().getPlugin("Vault");
        if (vaultPlugin == null || !vaultPlugin.isEnabled()) {
            return;
        }
        vault = new Vault(vaultPlugin);
    }

    private static void checkPlaceHolderAPI() {
        Plugin placeholderAPIPlugin = IntegrationsManager.getPlugin().getServer().getPluginManager().getPlugin("PlaceholderAPI");
        if (placeholderAPIPlugin == null || !placeholderAPIPlugin.isEnabled()) {
            return;
        }
        placeholderAPI = new PlaceholderAPI(placeholderAPIPlugin);
    }

    public static PlaceholderAPI getPlaceholderAPI() {
        return placeholderAPI;
    }

    public static Vault getVault() {
        return vault;
    }

    public static ViaVersion getViaVersion() {
        return viaVersion;
    }

    public static BungeeCord getBungeeCord() {
        return bungeeCord;
    }

    public static boolean isUsingVault() {
        return vault != null;
    }

    public static boolean isUsingPlaceholderAPI() {
        return placeholderAPI != null;
    }

    public static boolean isUsingViaVersion() {
        return viaVersion != null;
    }

    public static PlayerNPCPlugin getPlugin() {
        return PlayerNPCPlugin.getInstance();
    }

    protected static void addHookedPlugin(PluginIntegration pluginIntegration) {
        integrations.add(pluginIntegration);
        IntegrationsManager.getPlugin().getServer().getConsoleSender().sendMessage(IntegrationsManager.getPlugin().getPrefix() + "\u00a77Hooked into \u00a7a" + pluginIntegration.getPlugin().getName() + " \u00a77v" + pluginIntegration.getPlugin().getDescription().getVersion() + ".");
    }

    protected static void removeHookedPlugin(PluginIntegration pluginIntegration) {
        if (!integrations.contains(pluginIntegration)) {
            return;
        }
        integrations.remove(pluginIntegration);
        IntegrationsManager.getPlugin().getServer().getConsoleSender().sendMessage(IntegrationsManager.getPlugin().getPrefix() + "\u00a77Removed integration from \u00a7c" + pluginIntegration.getPlugin().getName());
    }

    public static List<Integration> getIntegrations() {
        return integrations;
    }

    public static List<PluginIntegration> getHookedPlugins() {
        return integrations.stream().filter(x -> x instanceof PluginIntegration).map(x -> (PluginIntegration)x).collect(Collectors.toList());
    }
}

