/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.command.global;

import dev.sergiferry.playernpc.PlayerNPCPlugin;
import dev.sergiferry.playernpc.api.NPC;
import dev.sergiferry.playernpc.api.NPCLib;
import dev.sergiferry.playernpc.command.CommandUtils;
import dev.sergiferry.playernpc.command.global.ActionCommand;
import dev.sergiferry.playernpc.command.global.GenerateCommand;
import dev.sergiferry.playernpc.command.global.InfoCommand;
import dev.sergiferry.playernpc.nms.spigot.NMSPlayer;
import dev.sergiferry.playernpc.utils.ClickableText;
import dev.sergiferry.playernpc.utils.ColorUtils;
import dev.sergiferry.playernpc.utils.EnumUtils;
import dev.sergiferry.playernpc.utils.MathUtils;
import dev.sergiferry.playernpc.utils.StringUtils;
import dev.sergiferry.spigot.SpigotPlugin;
import dev.sergiferry.spigot.commands.CommandInstance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import org.mineskin.Variant;

public class NPCGlobalCommand
extends CommandInstance
implements TabCompleter {
    protected static final String COMMAND_LABEL = "npcglobal";
    private static final List<Command> commands;
    protected static final Command GENERATE;
    protected static final Command SETPERSISTENT;
    protected static final Command SETVISIBILITY;
    protected static final Command SETVISIBILITYREQUIREMENT;
    protected static final Command ADDPLAYER;
    protected static final Command REMOVEPLAYER;
    protected static final Command SETAUTOCREATE;
    protected static final Command SETAUTOSHOW;
    protected static final Command SETTEXT;
    protected static final Command SETSKIN;
    protected static final Command SETVISIBLELAYER;
    protected static final Command SETOWNPLAYERSKIN;
    protected static final Command SETITEM;
    protected static final Command SETCOLLIDABLE;
    protected static final Command SETGLOWCOLOR;
    protected static final Command SETTABLISTVISIBILITY;
    protected static final Command SETTAGVISIBILITY;
    protected static final Command SETNAMETAG;
    protected static final Command SETTABLISTNAME;
    protected static final Command SETLINESPACING;
    protected static final Command SETTEXTALIGNMENT;
    protected static final Command SETTEXTOPACITY;
    protected static final Command SETLINEOPACITY;
    protected static Command SETTEXTUPDATETICKS;
    protected static final Command SETGAZETRACKINGTYPE;
    protected static final Command SETGLOWING;
    protected static final Command SETARROWSINBODY;
    protected static final Command SETBEESTINGERSINBODY;
    protected static final Command SETONFIRE;
    protected static final Command SETINVISIBLE;
    protected static final Command SETSHAKING;
    protected static final Command SETPOSE;
    protected static final Command PLAYANIMATION;
    protected static final Command CUSTOMDATA;
    protected static final Command ACTION;
    protected static final Command TELEPORT;
    protected static final Command LOOKAT;
    protected static final Command SHOW;
    protected static final Command HIDE;
    protected static final Command SETHIDETEXT;
    protected static final Command REMOVE;
    protected static final Command SIMPLEUPDATE;
    protected static final Command FORCEUPDATE;
    protected static final Command SIMPLEUPDATETEXT;
    protected static final Command FORCEUPDATETEXT;
    protected static final Command LOADPERSISTENT;
    protected static final Command SAVEPERSISTENT;
    protected static final Command DISABLEPERSISTENTSAVE;
    protected static final Command GOTO;
    protected static final Command INFO;

    public NPCGlobalCommand(SpigotPlugin plugin) {
        super(plugin, COMMAND_LABEL);
    }

    @Override
    public void onExecute(CommandSender sender, org.bukkit.command.Command command, String label, String[] args) {
        Player playerSender;
        Player player = playerSender = sender instanceof Player ? (Player)sender : null;
        if (playerSender != null && !this.getPlugin().hasPermission(playerSender, "command")) {
            sender.sendMessage(NPCGlobalCommand.getPrefix() + "You don't have permission to do this.");
            return;
        }
        NPCLib npcLib = NPCLib.getInstance();
        if (args.length == 0) {
            if (playerSender != null) {
                NPCGlobalCommand.sendHelpList(playerSender, 1);
            } else {
                CommandUtils.error(sender);
            }
            return;
        }
        if (args[0].equalsIgnoreCase("help")) {
            int asd = 1;
            if (args.length == 2 && MathUtils.isInteger(args[1])) {
                asd = Integer.valueOf(args[1]);
            }
            if (playerSender != null) {
                NPCGlobalCommand.sendHelpList(playerSender, asd);
            } else {
                CommandUtils.error(sender);
            }
            return;
        }
        if (args.length < 2) {
            Command commands = NPCGlobalCommand.getCommand(args[0]);
            if (commands != null) {
                new ClickableText("\u00a7c\u00a7lError \u00a78| \u00a77Use \u00a7e" + commands.getCommand(), CommandUtils.c(), ClickEvent.Action.SUGGEST_COMMAND, commands.getCommand()).send(sender);
            } else {
                CommandUtils.errorSuggestCommand(sender, "Incorrect command. Use \u00a7e/npcglobal help", "/npcglobal help");
            }
            return;
        }
        String id = args[1];
        Command commands = NPCGlobalCommand.getCommand(args[0]);
        if (commands == null) {
            new ClickableText("\u00a7c\u00a7lError \u00a78| \u00a77This command do not exist. Use \u00a7e/npcglobal help", CommandUtils.c(), ClickEvent.Action.SUGGEST_COMMAND, "/npcglobal help").send(sender);
            return;
        }
        if (!commands.isEnabled()) {
            CommandUtils.error(sender, "This command is not enabled.");
            return;
        }
        CommandData data = new CommandData(sender, args, npcLib);
        if (commands.getArgument().equals(GENERATE.getArgument())) {
            GENERATE.getExecute().accept(GENERATE, data);
            return;
        }
        if (!NPCLib.Registry.ID.isFullValid(id)) {
            CommandUtils.error(data.getCommandSender(), "Not valid ID '" + id + "'");
            return;
        }
        npcLib.grabGlobalNPC(id).ifPresentOrElse(global -> {
            data.setGlobal((NPC.Global)global);
            commands.getExecute().accept(commands, data);
        }, () -> CommandUtils.errorSuggestCommand(sender, "\u00a77This NPC doesn't exist. To generate the NPC use \u00a7e" + GENERATE.getCommand(), GENERATE.getCommand()));
    }

    public List<String> onTabComplete(CommandSender sender, org.bukkit.command.Command cmd, String label, String[] args) {
        Player playerSender;
        if (!this.isCommand(label)) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>();
        Player player = playerSender = sender instanceof Player ? (Player)sender : null;
        if (playerSender != null && !this.getPlugin().hasPermission(playerSender, "command")) {
            return strings;
        }
        NPCLib npcLib = NPCLib.getInstance();
        if (args.length == 1) {
            commands.stream().filter(x -> x.getArgument().contains(args[0]) && x.isEnabled()).forEach(x -> strings.add(x.getArgument()));
            if ("help".startsWith(args[0])) {
                strings.add("help");
            }
            if (strings.isEmpty()) {
                strings.add("help");
                strings.add("\u00a7c\u00a7nUnrecognized command:\u00a77 '" + args[0] + "'");
            }
            return strings;
        }
        Command command = NPCGlobalCommand.getCommand(args[0]);
        if (command == null || !command.isEnabled()) {
            return strings;
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("help")) {
                int maxpag = (commands.size() - 1) / 4 + 1;
                for (int i = 1; i <= maxpag; ++i) {
                    strings.add("" + i);
                }
                return strings;
            }
            if (args[0].equalsIgnoreCase(GENERATE.getArgument())) {
                return GENERATE.getTabComplete().apply(command, new CommandData(sender, args, npcLib));
            }
            boolean onlyPersistent = args[0].equalsIgnoreCase(SAVEPERSISTENT.getArgument()) || args[0].equalsIgnoreCase(LOADPERSISTENT.getArgument()) || args[0].equalsIgnoreCase(DISABLEPERSISTENTSAVE.getArgument());
            boolean onlyCanBePersistent = args[0].equalsIgnoreCase(SETPERSISTENT.getArgument());
            Stream<NPC.Global> npcs = NPCLib.getInstance().getAllGlobalNPCs().stream().filter(x -> x.getID().getSimpleID().toLowerCase().startsWith(args[1].toLowerCase()) || x.getID().getFullID().toLowerCase().startsWith(args[1].toLowerCase()));
            if (onlyPersistent) {
                npcs = npcs.filter(x -> x.isPersistent());
            }
            if (onlyCanBePersistent) {
                npcs = npcs.filter(x -> x.canBePersistent());
            }
            Set<NPC.Global> suggested = npcs.collect(Collectors.toSet());
            suggested.forEach(x -> strings.add(x.getID().getFullID()));
            if (args[1].length() == 0 && suggested.isEmpty()) {
                strings.add("\u00a7c\u00a7nThere's no NPC generated yet.\u00a77 Use " + GENERATE.getCommand());
            } else if (suggested.size() > 1) {
                strings.add("\u00a76\u00a7nWhich NPC you want to select?");
            } else if (suggested.isEmpty()) {
                strings.add("\u00a7c\u00a7nNo NPC with that ID was found");
            }
            return strings;
        }
        if (args.length >= 3) {
            CommandData data = new CommandData(sender, args, npcLib);
            if (command.equals(GENERATE)) {
                return GENERATE.getTabComplete().apply(command, data);
            }
            if (!NPCLib.Registry.ID.isFullValid(data.getID())) {
                return strings;
            }
            Optional<NPC.Global> npc = npcLib.grabGlobalNPC(data.getID());
            if (npc.isEmpty()) {
                return Arrays.asList("\u00a7cNo NPC found with that ID");
            }
            data.setGlobal(npc.get());
            List<String> suggested = command.getTabComplete().apply(command, data);
            if (suggested != null) {
                strings.addAll(suggested);
            }
            return strings;
        }
        return strings;
    }

    public static String getCommandColor(Command command) {
        return NPCGlobalCommand.getCommandColor(command, false);
    }

    public static String getCommandColor(Command command, boolean ignoreBold) {
        if (!command.isEnabled()) {
            return "\u00a78" + (command.isImportant() && !ignoreBold ? "\u00a7l" : "");
        }
        NPCLib.Command.Color color = command.getColor();
        if (command.isImportant()) {
            return color.getImportantSimple() + (!ignoreBold ? "\u00a7l" : "");
        }
        return "" + color.getNormal();
    }

    private static void sendHelpList(Player player, Integer pag) {
        int total = commands.size();
        int perpag = 4;
        int maxpag = (total - 1) / perpag + 1;
        if (pag > maxpag) {
            return;
        }
        for (int i = 0; i < 100; ++i) {
            player.sendMessage("");
        }
        NMSPlayer.sendMessage(player, " \u00a7e\u00a7lPERSISTENT NPCs ARE NOW AVAILABLE!", "", " \u00a77All changes made through the command will be saved if the NPC is persistent.", "", "", "", "");
        NMSPlayer.sendMessage(player, "  \u00a7c\u00a7lGlobal NPC commands \u00a77(Page " + pag + "/" + maxpag + ")", "");
        int aas = 0;
        for (int i = 0; i < perpag && total > i + (pag - 1) * perpag; ++i) {
            int id = i + (pag - 1) * perpag;
            Command npcCommands = commands.get(id);
            new ClickableText("  \u00a78\u2022 ").add(NPCGlobalCommand.getCommandColor(npcCommands) + npcCommands.getTitle() + (String)(npcCommands.isCustom() ? " \u00a77(" + npcCommands.getPlugin().getName() + ")" : ""), npcCommands.isEnabled() ? NPCGlobalCommand.getCommandColor(npcCommands, true) + npcCommands.getCommand() + "\n\u00a78Command managed by " + npcCommands.getPluginName() + " plugin\n\n\u00a77" + npcCommands.getHover() + "\n\n" + CommandUtils.c() : null, npcCommands.isEnabled() ? new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, npcCommands.getCommand()) : null).send(player);
            ++aas;
        }
        int ass = perpag - aas;
        for (int i = 0; i < ass; ++i) {
            player.sendMessage("");
        }
        player.sendMessage("");
        boolean next = total > pag * perpag;
        boolean previous = pag > 1;
        new ClickableText("  ").add((previous ? "\u00a7c\u00a7l" : "\u00a78\u00a7l") + "[PREVIOUS]", previous ? "\u00a7eClick to go to the previous page." : null, previous ? new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/npcglobal help " + (pag - 1)) : null).add("    ").add((next ? "\u00a7a\u00a7l" : "\u00a78\u00a7l") + "[NEXT]", next ? "\u00a7eClick to go to the next page." : null, next ? new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/npcglobal help " + (pag + 1)) : null).send(player);
        player.sendMessage("");
    }

    public static Command getCommand(String argument) {
        return commands.stream().filter(x -> x.getArgument().equalsIgnoreCase(argument)).findAny().orElse(null);
    }

    public static Set<Command> getCommands(Plugin plugin) {
        HashSet<Command> commands = new HashSet<Command>();
        commands.stream().filter(x -> x.getPlugin().equals(plugin)).forEach(x -> commands.add((Command)x));
        return commands;
    }

    public static void addCommand(Plugin plugin, String argument, String arguments, boolean enabled, boolean important, String description, String hover, BiConsumer<Command, CommandData> execute, BiFunction<Command, CommandData, List<String>> tabComplete, NPCLib.Command.Color color) {
        if (plugin.equals((Object)PlayerNPCPlugin.getInstance())) {
            throw new IllegalArgumentException("Plugin must be yours.");
        }
        new Command(plugin, argument, arguments, enabled, important, description, hover, execute, tabComplete, color);
    }

    public static String getPrefix() {
        return PlayerNPCPlugin.getInstance().getPrefix();
    }

    static {
        SETAUTOCREATE = null;
        SETAUTOSHOW = null;
        SETHIDETEXT = null;
        commands = new ArrayList<Command>();
        GENERATE = new GenerateCommand();
        SETPERSISTENT = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setpersistent", "(id) (boolean)", true, true, "Set NPC persistent", "\u00a77This sets if the NPC will be persistent or not.\n\u00a77That means that if the NPC is persistent, after a server restart it will appear, otherwise not.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(boolean) \u00a77Value that can be true or false", (command, data) -> {
            if (data.getCommandArgs().length < 1) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            if (!data.getGlobal().canBePersistent()) {
                CommandUtils.error(data.getCommandSender(), "This NPC cannot be Persistent because it's not managed by PlayerNPC plugin.");
                return;
            }
            if (!data.getCommandArgs()[0].equalsIgnoreCase("true") && !data.getCommandArgs()[0].equalsIgnoreCase("false")) {
                CommandUtils.error(data.getCommandSender(), "Boolean can only be true or false.");
                return;
            }
            boolean bo = Boolean.valueOf(data.getCommandArgs()[0]);
            if (data.getGlobal().isPersistent() == bo) {
                CommandUtils.error(data.getCommandSender(), "Persistent attribute was \u00a7e" + bo + "\u00a77 yet");
                return;
            }
            data.getGlobal().setPersistent(bo);
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " has been set as " + (bo ? "\u00a7a" : "\u00a7cnot ") + "persistent");
        }, (command, data) -> {
            if (data.getCommandArgs().length != 1) {
                return null;
            }
            ArrayList<Object> strings = new ArrayList<Object>();
            if (!data.getGlobal().canBePersistent()) {
                strings.add("\u00a7c\u00a7nThis NPC cannot be persistent.");
                return strings;
            }
            if (data.getCommandArgs()[0].length() == 0) {
                strings.add("\u00a7eCurrently \u00a76" + data.getGlobal().getID().getFullID() + " \u00a7eis" + (!data.getGlobal().isPersistent() ? " \u00a7cnot" : "\u00a7a") + " persistent");
                strings.add("\u00a76\u00a7nShould the NPC be Persistent?");
            }
            List<String> values = Arrays.asList("true", "false", "toggle");
            values.stream().filter(x -> x.startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x));
            if (strings.isEmpty()) {
                strings.addAll(values);
                strings.add("\u00a7c\u00a7nUnrecognized value:\u00a77 '" + data.getCommandArgs()[0].toLowerCase() + "'");
            }
            return strings;
        });
        SETVISIBILITY = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setvisibility", "(id) (visibility)", true, false, "Set NPC visibility", "\u00a77With this command you can set if the NPC will be visible for everyone, or for selected players.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(visibility) \u00a77Who can see the Global NPC.\n\u00a78Visibility: \u00a77everyone, selected_players", (command, data) -> {
            if (data.getCommandArgs().length < 1) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            String vis = data.getCommandArgs()[0].toLowerCase();
            NPC.Global.Visibility visibility = Arrays.stream(NPC.Global.Visibility.values()).filter(x -> x.name().toLowerCase().equals(vis)).findFirst().orElse(null);
            if (visibility == null) {
                CommandUtils.error(data.getCommandSender(), "This visibility option ('" + vis + "') do not exist.");
                return;
            }
            data.getGlobal().setVisibility(visibility);
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77visibility has been set to \u00a7e" + vis.replaceAll("_", " ") + "\u00a77.");
        }, (command, data) -> {
            if (data.getCommandArgs().length != 1) {
                return null;
            }
            List<String> strings = Arrays.stream(NPC.Global.Visibility.values()).map(x -> x.name().toLowerCase()).filter(x -> x.startsWith(data.getCommandArgs()[0].toLowerCase())).toList();
            return strings;
        });
        SETVISIBILITYREQUIREMENT = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setvisibilityrequirement", "(id) (permission/clear)", true, false, "Set NPC visibility requirement", "\u00a77With this command you can establish a permission requirement to be able to see the NPC.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(permission/clear) \u00a77Only players with this permission can see the NPC. You must set visibility to everyone, in order to show this NPC to all players with an specific permission.", (command, data) -> {
            if (data.getCommandArgs().length < 1) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            String vis = data.getCommandArgs()[0];
            NPCLib.Registry.ID visibilityKey = NPCLib.Registry.ID.of(command.getPlugin(), "visibilityrequirementpermission");
            if (vis.equalsIgnoreCase("clear")) {
                if (data.getGlobal().getVisibilityRequirement() == null) {
                    CommandUtils.error(data.getCommandSender(), "This Global NPC doesn't have any visibility requirement yet.");
                    return;
                }
                data.getGlobal().setVisibilityRequirement(null);
                data.getGlobal().setCustomData(visibilityKey, null);
                data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77visibility requirement permission has been cleared.");
                return;
            }
            data.getGlobal().setVisibilityRequirement(player -> player.hasPermission(vis));
            data.getGlobal().setCustomData(visibilityKey, vis.toLowerCase());
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77visibility requirement permission has been set to \u00a7e" + vis.toLowerCase() + "\u00a77.");
        }, (command, data) -> {
            if (data.getCommandArgs().length != 1) {
                return null;
            }
            ArrayList strings = new ArrayList();
            NPCLib.Registry.ID visibilityKey = NPCLib.Registry.ID.of(command.getPlugin(), "visibilityrequirementpermission");
            boolean b = data.getGlobal().grabCustomData(visibilityKey).isPresent();
            Arrays.asList(b ? "clear" : "", b ? data.getGlobal().grabCustomData(visibilityKey).get() : "").stream().filter(x -> x.startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x));
            return strings;
        });
        ADDPLAYER = new Command((Plugin)PlayerNPCPlugin.getInstance(), "addplayer", "(id) (player) [ignoreVisibilityRequirement]", true, false, "Add player to see an NPC", "\u00a77This adds a player to the selected players to see a Global NPC. If the Global NPC already has visibility for everyone, this is not useful.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(player) \u00a77Player's name that will see the NPC.\n\u00a78\u2022 \u00a7a[ignoreVisibilityRequirement] \u00a77Value can be true or false.", (command, data) -> {
            if (data.getCommandArgs().length < 1) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            String playerName = data.getCommandArgs()[0];
            Player player = Bukkit.getPlayerExact((String)playerName);
            if (player == null) {
                Player suggested = Bukkit.getPlayer((String)playerName);
                if (suggested != null) {
                    CommandUtils.errorSuggestCommand(data.getCommandSender(), "This player cannot be found. Maybe you're meaning \u00a7e" + suggested.getName(), command.getCommand(data.getGlobal(), suggested.getName()));
                } else {
                    CommandUtils.error(data.getCommandSender(), "This player cannot be found.");
                }
                return;
            }
            if (data.getGlobal().hasPlayer(player)) {
                CommandUtils.error(data.getCommandSender(), "This player is already added to this Global NPC.");
                return;
            }
            boolean ignoreRequirement = false;
            if (data.getCommandArgs().length > 1) {
                if (!data.getCommandArgs()[1].equalsIgnoreCase("true") && !data.getCommandArgs()[1].equalsIgnoreCase("false")) {
                    CommandUtils.error(data.getCommandSender(), "Boolean can only be true or false.");
                    return;
                }
                ignoreRequirement = Boolean.valueOf(data.getCommandArgs()[1]);
            }
            if (!ignoreRequirement && !data.getGlobal().meetsVisibilityRequirement(player)) {
                CommandUtils.errorSuggestCommand(data.getCommandSender(), "This player do not meet visibility requirement. Instead use ignoreVisibilityRequirement as true", command.getCommand(data.getGlobal(), player.getName() + " true"));
                return;
            }
            data.getGlobal().addPlayer(player, ignoreRequirement);
            CommandUtils.sendMessage(data.getCommandSender(), "\u00a7e" + player.getName() + " \u00a77has been added to Global NPC \u00a7a" + data.getID());
        }, (command, data) -> {
            if (data.getCommandArgs().length > 2) {
                return null;
            }
            ArrayList<Object> strings = new ArrayList<Object>();
            if (data.getCommandArgs().length == 1) {
                Bukkit.getOnlinePlayers().stream().filter(x -> x.getName().toLowerCase().startsWith(data.getCommandArgs()[0].toLowerCase()) && !data.getGlobal().hasPlayer((Player)x)).forEach(x -> strings.add(x.getName()));
                if (data.getCommandArgs()[0].length() == 0) {
                    if (strings.isEmpty()) {
                        strings.add("\u00a7c\u00a7nThere are no more players to add to the NPC");
                    } else {
                        strings.add("\u00a76\u00a7nWhich player do you want to add to the NPC?");
                    }
                } else if (strings.isEmpty()) {
                    strings.add("\u00a7c\u00a7nNo player with that name, or already added.");
                }
            }
            if (data.getCommandArgs().length == 2) {
                if (data.getCommandArgs()[0].length() == 0) {
                    return strings;
                }
                List<String> values = Arrays.asList("true", "false");
                values.stream().filter(x -> x.startsWith(data.getCommandArgs()[1].toLowerCase())).forEach(x -> strings.add(x));
                if (data.getCommandArgs()[1].length() == 0) {
                    strings.add("\u00a76\u00a7nShould the player ignore the visibility requirement of the NPC?");
                } else if (strings.isEmpty()) {
                    strings.addAll(values);
                    strings.add("\u00a7c\u00a7nUnrecognized value:\u00a77 '" + data.getCommandArgs()[1] + "'");
                }
            }
            return strings;
        });
        REMOVEPLAYER = new Command((Plugin)PlayerNPCPlugin.getInstance(), "removeplayer", "(id) (player)", true, false, "Remove player from seeing an NPC", "\u00a77This removes a player from the selected players to see a Global NPC.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(player) \u00a77Player's name that will stop seeing the NPC.", (command, data) -> {
            if (data.getCommandArgs().length < 1) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            String playerName = data.getCommandArgs()[0];
            Player player = Bukkit.getPlayerExact((String)playerName);
            if (player == null) {
                Player suggested = Bukkit.getPlayer((String)playerName);
                if (!data.getGlobal().hasPlayer(suggested)) {
                    suggested = null;
                }
                if (suggested != null) {
                    CommandUtils.errorSuggestCommand(data.getCommandSender(), "This player cannot be found. Maybe you're meaning \u00a7e" + suggested.getName(), command.getCommand(data.getGlobal(), suggested.getName()));
                } else {
                    CommandUtils.error(data.getCommandSender(), "This player cannot be found.");
                }
                return;
            }
            if (!data.getGlobal().hasPlayer(player)) {
                CommandUtils.error(data.getCommandSender(), "This player is not added to this Global NPC yet.");
                return;
            }
            CommandUtils.sendMessage(data.getCommandSender(), "\u00a7e" + player.getName() + " \u00a77has been removed from Global NPC \u00a7a" + data.getID());
            data.getGlobal().removePlayer(player);
        }, (command, data) -> {
            if (data.getCommandArgs().length > 1) {
                return null;
            }
            ArrayList<String> strings = new ArrayList<String>();
            if (data.getCommandArgs().length == 1) {
                Bukkit.getOnlinePlayers().stream().filter(x -> x.getName().toLowerCase().startsWith(data.getCommandArgs()[0].toLowerCase()) && data.getGlobal().hasPlayer((Player)x)).forEach(x -> strings.add(x.getName()));
                boolean emptyPlayers = data.getGlobal().getPlayers().isEmpty();
                if (data.getCommandArgs()[0].length() == 0) {
                    if (emptyPlayers) {
                        strings.add("\u00a7c\u00a7nThis NPC has no player added yet.");
                    } else {
                        strings.add("\u00a76\u00a7nWhich player do you want to remove from the NPC?");
                    }
                } else if (strings.isEmpty()) {
                    strings.add("\u00a7c\u00a7nNo player with that name was found.");
                }
            }
            return strings;
        });
        SETTEXT = new Command((Plugin)PlayerNPCPlugin.getInstance(), "settext", "(id) (text)...", true, false, "Set the text above an NPC", "\u00a77This sets the text above an NPC. No need to set it.\n\u00a77Use \" \" for the spaces and \"\\n\" for a new line.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(text)... \u00a77The text will see above the NPC.", (command, data) -> {
            if (data.getCommandArgs().length < 1) {
                CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal()));
                return;
            }
            if (data.getCommandArgs()[0].equals("clear")) {
                data.getGlobal().clearText().update();
                data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77text has been \u00a7ccleared\u00a77.");
                return;
            }
            Object msg = "";
            for (int i = 0; i < data.getCommandArgs().length; ++i) {
                msg = (String)msg + " " + data.getCommandArgs()[i];
            }
            msg = ((String)msg).replaceFirst(" ", "");
            data.getGlobal().setText((String)msg).update();
            StringBuilder textBuilder = new StringBuilder("");
            data.getGlobal().getText().forEach(x -> textBuilder.append("\n " + ChatColor.RESET + x));
            textBuilder.replace(0, 1, "");
            new ClickableText(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77text has been set to \u00a7e" + data.getGlobal().getText().size() + "\u00a77 lines. ").add("\u00a7e(Hover to see it)", TextComponent.fromLegacyText((String)ColorUtils.formatColor(textBuilder.toString()))).send(data.getCommandSender());
            if (NPC.Placeholders.containsPlaceholder((String)msg) && data.getGlobal().getTextUpdateTicks().equals(0)) {
                new ClickableText("\u00a77You need to do \u00a7e" + SETTEXTUPDATETICKS.getCommand(data.getGlobal(), "(ticks)") + " \u00a77to update placeholders every certain time.", "\u00a7eClick to write command.", ClickEvent.Action.SUGGEST_COMMAND, SETTEXTUPDATETICKS.getCommand(data.getGlobal(), "")).send(data.getCommandSender());
            }
        }, (command, data) -> {
            ArrayList<String> strings = new ArrayList<String>();
            String lastArgument = data.getCommandArgs()[data.getCommandArgs().length - 1];
            if (lastArgument.contains("{")) {
                return NPC.Placeholders.getTabCompleter(data.global, data.getPlayerSender(), lastArgument);
            }
            if (data.getCommandArgs().length > 1) {
                return strings;
            }
            if ("clear".startsWith(data.getCommandArgs()[0]) && !data.getGlobal().getText().isEmpty()) {
                strings.add("clear");
            }
            if (data.getCommandArgs()[0].length() == 0) {
                if (!data.getGlobal().getText().isEmpty()) {
                    String line = StringUtils.getStringFromList(data.getGlobal().getText());
                    strings.add(line);
                } else {
                    strings.add("\u00a78Example: &6Welcome &e{playerName}\\n&6to the server.");
                }
                strings.add("(text)...");
                strings.add("\u00a76\u00a7nWhich text should the NPC display above?\u00a77 (Use \\n for a new line)");
            }
            return strings;
        });
        SETSKIN = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setskin", "(id) (type) (skin)", true, false, "Set the skin of an NPC", "\u00a77This sets the NPC skin. \u00a78By default is Steve skin.\n\u00a77You can set any skin of a Minecraft user, or from MineSkin.org, or any custom skin through the internet with an image url.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(type) \u00a77Can be minecraft, mineskin or custom.\n\u00a78\u2022 \u00a7a(skin) \u00a77The name of the skin", (command, data) -> {
            if (data.getArgs().length < 4) {
                CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal()));
                return;
            }
            BukkitTask actionTask = null;
            if (data.getCommandArgs()[0].equalsIgnoreCase("minecraft")) {
                data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Trying to fetch player skin of " + data.getCommandArgs()[1]);
                if (data.getPlayerSender() != null) {
                    actionTask = Bukkit.getScheduler().runTaskTimer(command.getPlugin(), () -> data.getPlayerSender().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7eFetching skin information from Minecraft...")), 3L, 3L);
                }
                BukkitTask finalActionTask = actionTask;
                NPC.Skin.Minecraft.fetchSkinAsync(data.getGlobal().getPlugin(), data.getCommandArgs()[1]).thenAccept(fetchResult -> {
                    if (finalActionTask != null && !finalActionTask.isCancelled()) {
                        finalActionTask.cancel();
                        data.getPlayerSender().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(""));
                    }
                    if (fetchResult.hasError()) {
                        CommandUtils.error(data.getCommandSender(), ((NPC.Skin.Minecraft.FetchResult.Error)fetchResult.grabError().get()).getMessage());
                        return;
                    }
                    data.getGlobal().setSkin((NPC.Skin)fetchResult.grabSkin().get()).update();
                    data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + "\u00a77 skin has been set to " + ((NPC.Skin.Minecraft)fetchResult.grabSkin().get()).getName());
                });
            } else if (data.getCommandArgs()[0].equalsIgnoreCase("custom")) {
                data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Trying to fetch skin from Custom...");
                if (data.getPlayerSender() != null) {
                    actionTask = Bukkit.getScheduler().runTaskTimer(command.getPlugin(), () -> data.getPlayerSender().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7eFetching skin information from Custom...")), 3L, 3L);
                }
                BukkitTask finalActionTask = actionTask;
                NPC.Skin.Custom.fetchCustomSkinAsync(data.getCommandArgs()[1].toLowerCase()).thenAccept(fetchResult -> {
                    if (finalActionTask != null && !finalActionTask.isCancelled()) {
                        finalActionTask.cancel();
                        data.getPlayerSender().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(""));
                    }
                    if (fetchResult.hasError()) {
                        CommandUtils.error(data.getCommandSender(), ((NPC.Skin.Custom.FetchResult.Error)fetchResult.grabError().get()).getMessage());
                        return;
                    }
                    data.getGlobal().setSkin((NPC.Skin)fetchResult.grabSkin().get()).update();
                    data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + "\u00a77 skin has been set to " + ((NPC.Skin.Custom)fetchResult.grabSkin().get()).getID().getFullID());
                });
            } else if (data.getCommandArgs()[0].equalsIgnoreCase("mineskin")) {
                data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Trying to fetch skin from MineSkin...");
                if (data.getPlayerSender() != null) {
                    actionTask = Bukkit.getScheduler().runTaskTimer(command.getPlugin(), () -> data.getPlayerSender().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7eFetching skin information from MineSkin...")), 3L, 3L);
                }
                BukkitTask finalActionTask = actionTask;
                NPC.Skin.MineSkin.fetchSkinAsync(data.getGlobal().getPlugin(), data.getCommandArgs()[1], false).thenAccept(fetchResult -> {
                    if (finalActionTask != null && !finalActionTask.isCancelled()) {
                        finalActionTask.cancel();
                        data.getPlayerSender().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(""));
                    }
                    if (fetchResult.hasError()) {
                        CommandUtils.error(data.getCommandSender(), fetchResult.getErrorMessage());
                        return;
                    }
                    data.getGlobal().setSkin((NPC.Skin)fetchResult.grabSkin().get()).update();
                    data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + "\u00a77 skin has been set to MineSkin #" + ((NPC.Skin.MineSkin)fetchResult.grabSkin().get()).getId());
                });
            } else if (data.getCommandArgs()[0].equals("npc")) {
                if (!NPCLib.Registry.ID.isFullValid(data.getCommandArgs()[1])) {
                    CommandUtils.errorNotValidID(data.getCommandSender(), data.getCommandArgs()[1]);
                    return;
                }
                Optional<NPC.Global> other = data.getNPCLib().grabGlobalNPC(data.getCommandArgs()[1]);
                if (other.isEmpty()) {
                    CommandUtils.error(data.commandSender, "This Global NPC does not exists.");
                    return;
                }
                data.getGlobal().setSkin(other.get().getSkin()).update();
                data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + "\u00a77 skin has been set to the skin of Global NPC \u00a7e" + other.get().getFullID());
            } else if (data.getCommandArgs()[0].equalsIgnoreCase("url")) {
                data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Trying to download skin from \u00a7e" + data.getCommandArgs()[1]);
                if (data.getPlayerSender() != null) {
                    actionTask = Bukkit.getScheduler().runTaskTimer(command.getPlugin(), () -> data.getPlayerSender().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7eGenerating skin information...")), 3L, 3L);
                }
                BukkitTask finalActionTask = actionTask;
                Variant variant = Variant.AUTO;
                if (data.getCommandArgs().length > 2) {
                    if (data.getCommandArgs()[2].equalsIgnoreCase("slim")) {
                        variant = Variant.SLIM;
                    } else if (data.getCommandArgs()[2].equalsIgnoreCase("classic")) {
                        variant = Variant.CLASSIC;
                    }
                }
                NPC.Skin.MineSkin.generateSkinFromURLAsync(data.getCommandArgs()[1], variant).thenAccept(fetchResult -> {
                    if (finalActionTask != null && !finalActionTask.isCancelled()) {
                        finalActionTask.cancel();
                        data.getPlayerSender().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(""));
                    }
                    if (fetchResult.hasError()) {
                        CommandUtils.error(data.getCommandSender(), fetchResult.getErrorMessage());
                        return;
                    }
                    data.getGlobal().setSkin((NPC.Skin)fetchResult.grabSkin().get()).update();
                    data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + "\u00a77 skin has been set to MineSkin #" + ((NPC.Skin.MineSkin)fetchResult.grabSkin().get()).getId());
                });
            } else if (data.getCommandArgs()[0].equalsIgnoreCase("default")) {
                data.getGlobal().setSkin(NPC.Attributes.getDefaultSkin()).update();
                data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + "\u00a77 skin has been set to default.");
            } else {
                CommandUtils.error(data.commandSender, "Type of skin can only be Minecraft, MineSkin or Custom.");
            }
        }, (command, data) -> {
            if (data.getCommandArgs().length > 3) {
                return null;
            }
            ArrayList<Object> strings = new ArrayList<Object>();
            if (data.getCommandArgs().length == 1) {
                List<String> values = Arrays.asList("minecraft", "custom", "mineskin", "url", "npc");
                values.stream().filter(x -> x.startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x));
                if (strings.isEmpty()) {
                    strings.addAll(values);
                    strings.add("\u00a7c\u00a7nUnrecognized skin type:\u00a77 '" + data.getCommandArgs()[0] + "'");
                } else if (data.getCommandArgs()[0].length() == 0) {
                    strings.add("\u00a76\u00a7nWhich skin type?");
                }
            } else if (data.getCommandArgs().length == 2) {
                String type = data.getCommandArgs()[0].toLowerCase();
                if (type.isEmpty()) {
                    return strings;
                }
                String argLowerCase = data.getCommandArgs()[1].toLowerCase();
                if (type.equals("minecraft")) {
                    NPC.Skin.Minecraft.getSuggestedSkinNames().stream().filter(x -> x.startsWith(argLowerCase)).forEach(x -> strings.add(x));
                    if (argLowerCase.isEmpty()) {
                        strings.add("(playerName)");
                        strings.add("(playerUUID)");
                        strings.add("\u00a76\u00a7nEnter the Player name, or UUID.");
                    }
                } else if (type.equals("custom")) {
                    NPC.Skin.Custom.getSuggestedSkinNames().stream().filter(x -> x.startsWith(argLowerCase)).forEach(x -> strings.add(x));
                    if (argLowerCase.isEmpty()) {
                        strings.add("(id)");
                        strings.add("\u00a76\u00a7nEnter the custom skin ID.");
                    } else if (strings.isEmpty()) {
                        strings.add("\u00a7c\u00a7nUnrecognized custom skin:\u00a77 '" + argLowerCase + "'");
                    }
                } else if (type.equals("mineskin")) {
                    NPC.Skin.MineSkin.getSuggestedSkinNames().stream().filter(x -> x.startsWith(argLowerCase)).forEach(x -> strings.add(x));
                    if (argLowerCase.isEmpty()) {
                        strings.add("(id)");
                        strings.add("(uuid)");
                        strings.add("(link)");
                        strings.add("\u00a76\u00a7nEnter the ID, UUID, or direct link.");
                        strings.add("\u00a78You can find skins at: https://mineskin.org/gallery");
                    }
                } else if (type.equals("npc")) {
                    NPCLib.getInstance().getAllGlobalNPCs().stream().filter(x -> x.getID().getFullID().startsWith(argLowerCase) && !x.getID().getFullID().equalsIgnoreCase(data.getGlobal().getID().getFullID())).forEach(x -> strings.add(x.getID().getFullID()));
                    if (argLowerCase.isEmpty()) {
                        strings.add("(id)");
                        strings.add("\u00a76\u00a7nEnter the NPC ID.");
                    } else if (strings.isEmpty()) {
                        strings.add("\u00a7c\u00a7nThere's no NPC with that ID");
                    }
                } else if (type.equals("url")) {
                    NPC.Skin.getSuggestedSkinWebsites().stream().filter(x -> x.startsWith(argLowerCase)).forEach(x -> strings.add(x));
                    if (argLowerCase.isEmpty()) {
                        strings.add("(url)");
                        strings.add("\u00a76\u00a7nEnter the URL of an skin image.");
                        strings.add("\u00a78The image must be 64x64 pixels.");
                    }
                }
            } else if (data.getCommandArgs().length == 3 && data.getCommandArgs()[0].equalsIgnoreCase("url")) {
                List<String> values = Arrays.asList("auto", "slim", "classic");
                values.stream().filter(x -> x.startsWith(data.getCommandArgs()[2].toLowerCase())).forEach(x -> strings.add(x));
                if (data.getCommandArgs()[2].isEmpty()) {
                    strings.addAll(values);
                    strings.add("\u00a7c\u00a7nUnrecognzied skin model:\u00a77 '" + data.getCommandArgs()[2] + "'");
                } else if (strings.isEmpty()) {
                    strings.add("\u00a76\u00a7nWhich skin model is?");
                    Arrays.stream(NPC.Skin.Model.values()).forEach(x -> strings.add("\u00a78" + x.getName() + " is " + x.getPixels() + " pixel arms"));
                }
            }
            return strings;
        });
        SETVISIBLELAYER = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setvisiblelayer", "(id) (layer) (boolean)", true, false, "Set the skin's visible layers of an NPC", "\u00a77With this command you can manage which layers of the NPC's skin will be visible and which will not.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(layer) \u00a77Type of NPC.Skin.Layer\n\u00a78\u2022 \u00a7a(boolean) \u00a77Value that can be true or false.\n\u00a78NPC.Skin.Layer: \u00a77cape, jacket, left_sleeve, right_sleeve, left_pants, right_pants, hat", (command, data) -> {
            if (data.getArgs().length < 4) {
                CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal()));
                return;
            }
            NPC.Skin.Layer layer = Arrays.stream(NPC.Skin.Layer.values()).filter(x -> x.name().equals(data.getCommandArgs()[0].toUpperCase())).findFirst().orElse(null);
            if (layer == null) {
                CommandUtils.error(data.getCommandSender(), "\u00a77Skin layer was not found with that name.");
                return;
            }
            String layerName = layer.name().toLowerCase().replaceAll("_", " ");
            Boolean isActualVisible = data.getGlobal().getSkinVisibleLayers().isVisible(layer);
            Boolean bool = null;
            if (data.getCommandArgs()[1].equalsIgnoreCase("true")) {
                bool = true;
            } else if (data.getCommandArgs()[1].equalsIgnoreCase("false")) {
                bool = false;
            } else if (data.getCommandArgs()[1].equalsIgnoreCase("toggle")) {
                bool = isActualVisible == false;
            } else if (data.getCommandArgs()[1].equalsIgnoreCase("get")) {
                data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "The visibility for \u00a7e" + layerName + " \u00a77layer is " + CommandUtils.b(isActualVisible));
                return;
            }
            if (bool == null) {
                CommandUtils.error(data.getCommandSender(), "The visibility value of '" + data.getCommandArgs()[1].toLowerCase() + "' is invalid.");
                return;
            }
            if (data.getGlobal().getSkinVisibleLayers().isVisible(layer) == bool.booleanValue()) {
                CommandUtils.error(data.getCommandSender(), "The visibility for \u00a7e" + layerName + " \u00a77layer was already " + CommandUtils.b(bool));
                return;
            }
            data.getGlobal().setSkinLayerVisibility(layer, bool).update();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + "\u00a77 skin layer \u00a7a" + layerName + " \u00a77has been set it's visibility as " + CommandUtils.b(bool));
        }, (command, data) -> {
            ArrayList<Object> strings = new ArrayList<Object>();
            if (data.getArgs().length == 3) {
                List allParts = Arrays.stream(NPC.Skin.Layer.values()).map(x -> x.name().toLowerCase()).collect(Collectors.toList());
                allParts.stream().filter(x -> x.startsWith(data.getArgs()[2].toLowerCase())).forEach(x -> strings.add(x));
                if (strings.isEmpty()) {
                    strings.addAll(allParts);
                    strings.add("\u00a7c\u00a7nUnrecognized layer:\u00a77 '" + data.getArgs()[2] + "'");
                }
            } else if (data.getArgs().length == 4) {
                NPC.Skin.Layer layer = Arrays.stream(NPC.Skin.Layer.values()).filter(x -> x.name().equals(data.getCommandArgs()[0].toUpperCase())).findFirst().orElse(null);
                if (layer == null) {
                    return strings;
                }
                if (data.getArgs()[3].length() == 0) {
                    Boolean isActualVisible = data.getGlobal().getSkinVisibleLayers().isVisible(layer);
                    String layerName = layer.name().toLowerCase().replaceAll("_", " ");
                    strings.add("\u00a7eCurrently \u00a76" + layerName + " \u00a7eis" + (isActualVisible == false ? " \u00a7cnot" : "\u00a7a") + " visible");
                    strings.add("\u00a76\u00a7nShould the " + layerName + " be visible?");
                }
                List<String> values = Arrays.asList("true", "false", "toggle");
                values.stream().filter(x -> x.startsWith(data.getArgs()[3].toLowerCase())).forEach(x -> strings.add(x));
                if (strings.isEmpty()) {
                    strings.addAll(values);
                    strings.add("\u00a7c\u00a7nUnrecognized value:\u00a77 '" + data.getArgs()[3].toLowerCase() + "'");
                }
            }
            return strings;
        });
        SETOWNPLAYERSKIN = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setownplayerskin", "(id) (boolean)", true, false, "Set own player skin to an NPC", "\u00a77This sets if the NPC skin will be as the own player skin who looks at.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(boolean) \u00a77Value that can be true or false", (command, data) -> {
            if (data.getCommandArgs().length < 1) {
                CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal()));
                return;
            }
            if (!data.getCommandArgs()[0].equalsIgnoreCase("true") && !data.getCommandArgs()[0].equalsIgnoreCase("false")) {
                CommandUtils.error(data.getCommandSender(), "Boolean can only be true or false.");
                return;
            }
            boolean b = Boolean.valueOf(data.getCommandArgs()[0]);
            if (data.getGlobal().isOwnPlayerSkin() == b) {
                CommandUtils.error(data.getCommandSender(), "Own Player skin variable was already \u00a7e" + b);
                return;
            }
            data.getGlobal().setOwnPlayerSkin(b).update();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + "\u00a77 own player skin has been set to " + CommandUtils.b(b));
        }, (command, data) -> {
            if (data.getCommandArgs().length != 1) {
                return null;
            }
            ArrayList<Object> strings = new ArrayList<Object>();
            List<String> values = Arrays.asList("true", "false", "toggle");
            values.stream().filter(x -> x.startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x));
            if (strings.size() > 1) {
                strings.add("\u00a7eCurrently \u00a76" + data.getGlobal().getID().getFullID() + " \u00a7eis" + (!data.getGlobal().isOwnPlayerSkin() ? " \u00a7cnot" : "\u00a7a") + " own player skin");
                strings.add("\u00a76\u00a7nShould the NPC be own player skin?");
            } else if (strings.isEmpty()) {
                if (values.isEmpty()) {
                    strings.add("\u00a7c\u00a7nNo value available");
                } else if (data.getCommandArgs()[0].length() > 0) {
                    strings.add("\u00a7c\u00a7nUnrecognized value:\u00a77 '" + data.getCommandArgs()[0].toLowerCase() + "'");
                }
            }
            return strings;
        });
        SETITEM = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setitem", "(id) (slot) [material]", true, false, "Set the equipment of an NPC", "\u00a77This sets the equipment of an NPC. \u00a77No need to set it.\n\u00a7cThis will use the item on your main hand or the variable [material] in case you set it.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(slot) \u00a77The slot of the NPC will have the item.\n\u00a78Slots: \u00a77helmet, chestplate, leggings, boots, mainhand, offhand\n\u00a78\u2022 \u00a7a[material] \u00a77The material of the item (if not, will use your hand).", (command, data) -> {
            if (data.getCommandArgs().length < 1) {
                CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal()));
                return;
            }
            NPC.Slot.fromName(data.getCommandArgs()[0]).ifPresentOrElse(slot -> {
                ItemStack itemStack = null;
                if (data.getPlayerSender() != null) {
                    itemStack = data.getPlayerSender().getInventory().getItemInMainHand();
                }
                if (data.getCommandArgs().length > 1) {
                    Material material = null;
                    try {
                        material = Material.valueOf((String)data.getCommandArgs()[1].toUpperCase());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (material == null) {
                        CommandUtils.error(data.getCommandSender(), "This material is not recognized.");
                        return;
                    }
                    itemStack = new ItemStack(material);
                }
                data.getGlobal().setItem((NPC.Slot)slot, itemStack).update();
                data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77item on slot \u00a7e" + slot.getName(EnumUtils.NameFormat.LOWER_CASE_WITH_SPACES) + " \u00a77has been set as \u00a7c" + itemStack.getType().name().toLowerCase().replaceAll("_", " "));
            }, () -> CommandUtils.error(data.getCommandSender(), "Incorrect slot. Use one of the suggested."));
        }, (command, data) -> {
            if (data.getCommandArgs().length > 2) {
                return null;
            }
            ArrayList<Object> strings = new ArrayList<Object>();
            if (data.getCommandArgs().length == 1) {
                List values = Arrays.stream(NPC.Slot.values()).map(x -> x.name().toLowerCase()).collect(Collectors.toList());
                values.stream().filter(x -> x.startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x));
                if (data.getCommandArgs()[0].length() == 0) {
                    strings.add("\u00a76\u00a7nWhich NPC slot you want to select?");
                } else if (strings.isEmpty()) {
                    strings.addAll(values);
                    strings.add("\u00a7c\u00a7nUnrecognized slot:\u00a77 '" + data.getCommandArgs()[0] + "'");
                }
            }
            if (data.getCommandArgs().length == 2) {
                if (data.getCommandArgs()[0].length() == 0) {
                    return strings;
                }
                if (data.getCommandArgs()[1].length() == 0) {
                    strings.add("[item]");
                    if (data.getPlayerSender() != null) {
                        strings.add("\u00a78If empty, it would select the item in your hand (" + data.getPlayerSender().getInventory().getItemInMainHand().getType().name().toLowerCase() + ")");
                    }
                    strings.add("\u00a76\u00a7nWhich item you want to put on NPC's " + data.getCommandArgs()[0] + "?");
                }
                if (data.getCommandArgs()[1].length() > 0) {
                    Arrays.stream(Material.values()).filter(x -> x.name().toLowerCase().startsWith(data.getCommandArgs()[1].toLowerCase())).forEach(x -> strings.add(x.name().toLowerCase()));
                    if (strings.isEmpty()) {
                        strings.add("\u00a7c\u00a7nUnrecognized item:\u00a77 '" + data.getCommandArgs()[1] + "'");
                    }
                }
            }
            return strings;
        });
        SETCOLLIDABLE = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setcollidable", "(id) (boolean)", true, false, "Set the collision of an NPC", "\u00a77This sets if the NPC will be collidable or not.\n\u00a77No need to set it. By default will not have collission.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(boolean) \u00a77Value that can be true or false", (command, data) -> {
            if (data.getArgs().length < 3) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            String value = data.getCommandArgs()[0].toLowerCase();
            Boolean bo = null;
            if (value.equals("true")) {
                bo = true;
            } else if (value.equals("false")) {
                bo = false;
            } else if (value.equals("toggle")) {
                bo = !data.getGlobal().isCollidable();
            } else {
                CommandUtils.error(data.getCommandSender(), "Boolean can only be true, false, or toggle.");
                return;
            }
            if (data.getGlobal().isCollidable() == bo.booleanValue()) {
                CommandUtils.error(data.getCommandSender(), "The collidable attribute was \u00a7e" + bo + "\u00a77 yet");
                return;
            }
            data.getGlobal().setCollidable(bo).update();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77collidable has been set as " + CommandUtils.b(bo));
        }, (command, data) -> {
            if (data.getCommandArgs().length != 1) {
                return null;
            }
            ArrayList<Object> strings = new ArrayList<Object>();
            List<String> values = Arrays.asList("true", "false", "toggle");
            values.stream().filter(x -> x.startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x));
            if (strings.size() > 1) {
                strings.add("\u00a7eCurrently \u00a76" + data.getGlobal().getID().getFullID() + " \u00a7eis" + (!data.getGlobal().isCollidable() ? " \u00a7cnot" : "\u00a7a") + " collidable");
                strings.add("\u00a76\u00a7nShould the NPC be collidable?");
            } else if (strings.isEmpty()) {
                if (data.getCommandArgs()[0].length() > 0) {
                    strings.add("\u00a7c\u00a7nUnrecognized value:\u00a77 '" + data.getCommandArgs()[0].toLowerCase() + "'");
                } else {
                    strings.add("\u00a7c\u00a7nNo value available");
                }
            }
            return strings;
        });
        SETGLOWCOLOR = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setglowcolor", "(id) (color)", true, false, "Set the glow color of an NPC", "\u00a77This sets the glow color of an NPC.\n\u00a77No need to set it. By default will be white.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(color) \u00a77The name of the color.", (command, data) -> {
            if (data.getCommandArgs().length < 1) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            NPC.Color.fromName(data.getCommandArgs()[0]).ifPresentOrElse(color -> {
                data.getGlobal().setGlowingColor((NPC.Color)color).update();
                CommandUtils.sendMessage(data.getCommandSender(), "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77glow color has been set as \u00a7f" + color.getName(EnumUtils.NameFormat.LOWER_CASE_WITH_SPACES, true));
            }, () -> CommandUtils.error(data.getCommandSender(), "This color '" + data.getCommandArgs()[0] + "' is not valid."));
        }, (command, data) -> {
            if (data.getCommandArgs().length != 1) {
                return null;
            }
            ArrayList<Object> strings = new ArrayList<Object>();
            List values = Arrays.stream(NPC.Color.values()).map(x -> x.getName(EnumUtils.NameFormat.LOWER_CASE)).collect(Collectors.toList());
            values.stream().filter(x -> x.startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x));
            if (strings.size() > 1) {
                strings.add("\u00a76\u00a7nWhich color glow do you want for the NPC?");
                strings.add("\u00a7eCurrent \u00a76glowing color \u00a7eis " + data.getGlobal().getGlowingColor().getName(EnumUtils.NameFormat.LOWER_CASE_WITH_SPACES, true));
            } else if (strings.isEmpty() && data.getCommandArgs()[0].length() > 0) {
                strings.add("\u00a7c\u00a7nUnrecognized color:\u00a77 '" + data.getCommandArgs()[0] + "'");
            }
            return strings;
        });
        SETTABLISTVISIBILITY = new Command((Plugin)PlayerNPCPlugin.getInstance(), "settablistvisibility", "(id) (tabListVisibility)", true, false, "Set tab list visibility of an NPC", "\u00a77This sets if the NPC will be shown on tab list.\n\u00a77No need to set it. By default will not be visible.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(tabListVisibility) \u00a77Value that can be true or false\n\u00a78TabListVisibility: \u00a77always, never, same_world, near", (command, data) -> {
            if (data.getCommandArgs().length < 1) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            NPC.TabListVisibility.fromName(data.getCommandArgs()[0]).ifPresentOrElse(tabListVisibility -> {
                if (data.getGlobal().getTabListVisibility().equals(tabListVisibility)) {
                    CommandUtils.error(data.getCommandSender(), "Tab list visibility attribute was \u00a7e" + tabListVisibility.getName(EnumUtils.NameFormat.LOWER_CASE_WITH_SPACES) + "\u00a77 yet");
                    return;
                }
                data.getGlobal().setTabListVisibility((NPC.TabListVisibility)tabListVisibility).update();
                data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77tab list visibility has been set as \u00a7e" + tabListVisibility.getName(EnumUtils.NameFormat.LOWER_CASE_WITH_SPACES));
            }, () -> CommandUtils.error(data.getCommandSender(), "This tab list visibility '" + data.getCommandArgs()[0] + "' is invalid."));
        }, (command, data) -> {
            if (data.getCommandArgs().length != 1) {
                return null;
            }
            ArrayList<Object> strings = new ArrayList<Object>();
            Arrays.stream(NPC.TabListVisibility.values()).map(x -> x.getName(EnumUtils.NameFormat.LOWER_CASE)).filter(x -> x.startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x));
            if (strings.size() > 1) {
                strings.add("\u00a76\u00a7nWhich tab list visibility option?");
                strings.add("\u00a7eCurrent \u00a76tab list visibility \u00a7eis \u00a7a" + data.getGlobal().getTabListVisibility().getName(EnumUtils.NameFormat.LOWER_CASE_WITH_SPACES));
            } else if (strings.isEmpty() && data.getCommandArgs()[0].length() > 0) {
                strings.add("\u00a7c\u00a7nUnrecognized value:\u00a77 '" + data.getCommandArgs()[0] + "'");
            }
            return strings;
        });
        SETTAGVISIBILITY = new Command((Plugin)PlayerNPCPlugin.getInstance(), "settagvisibility", "(id) (boolean)", true, false, "Set the nametag visibility of an NPC", "\u00a77This sets if the nametag of the NPC will be visible or not.\n\u00a77No need to set it. By default will be false.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(boolean) \u00a77Value that can be true or false", (command, data) -> {
            if (data.getArgs().length < 3) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            String value = data.getCommandArgs()[0].toLowerCase();
            Boolean bo = null;
            if (value.equals("true")) {
                bo = true;
            } else if (value.equals("false")) {
                bo = false;
            } else if (value.equals("toggle")) {
                bo = !data.getGlobal().isShowNameTag();
            } else {
                CommandUtils.error(data.getCommandSender(), "Boolean can only be true, false, or toggle.");
                return;
            }
            if (data.getGlobal().isShowNameTag() == bo.booleanValue()) {
                CommandUtils.error(data.getCommandSender(), "The visibility of nametag attribute was \u00a7e" + bo + "\u00a77 yet");
                return;
            }
            data.getGlobal().setShowNameTag(bo).update();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77visibility nametag has been set as " + CommandUtils.b(bo));
        }, (command, data) -> {
            if (data.getArgs().length != 3) {
                return null;
            }
            ArrayList<Object> strings = new ArrayList<Object>();
            if (data.getArgs()[2].length() == 0) {
                strings.add("\u00a7eCurrently \u00a76" + data.getGlobal().getID().getFullID() + " \u00a7eis" + (!data.getGlobal().isShowNameTag() ? " \u00a7cnot" : "\u00a7a") + " visible");
                strings.add("\u00a76\u00a7nShould the NPC NameTag be shown?");
            }
            List<String> values = Arrays.asList("true", "false", "toggle");
            values.stream().filter(x -> x.startsWith(data.getArgs()[2].toLowerCase())).forEach(x -> strings.add(x));
            if (strings.isEmpty()) {
                strings.addAll(values);
                strings.add("\u00a7c\u00a7nUnrecognized value:\u00a77 '" + data.getArgs()[2].toLowerCase() + "'");
            }
            return strings;
        });
        SETNAMETAG = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setnametag", "(id) (name) [prefix] [suffix]", true, false, "Set name tag of an NPC", "\u00a77This sets the name tag of an NPC.\n\u00a77No need to set it. By default will be {id}\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(name) \u00a77Name that will have the entity.\n\u00a78\u2022 \u00a7a[prefix] \u00a77Prefix that goes behind name.\n\u00a78\u2022 \u00a7a[suffix] \u00a77Suffix that goes after name.", (command, data) -> {
            if (data.getCommandArgs().length < 1) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            String prefix = null;
            String suffix = null;
            String name = data.getCommandArgs()[0].replaceAll("_", " ");
            if (data.getCommandArgs().length > 1) {
                prefix = data.getCommandArgs()[1].replaceAll("_", " ");
            }
            if (data.getCommandArgs().length > 2) {
                suffix = data.getCommandArgs()[2].replaceAll("_", " ");
            }
            data.getGlobal().setNameTag(prefix, name, suffix).update();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77name tag has been set to \u00a7e" + ColorUtils.formatColor(data.getGlobal().getNameTag().toString()));
        }, (command, data) -> {
            if (data.getCommandArgs().length > 3) {
                return null;
            }
            ArrayList<String> strings = new ArrayList<String>();
            if (data.getCommandArgs().length == 1) {
                String name = data.getGlobal().getNameTag().getName().replaceAll(" ", "_").replaceAll("\u00a7", "&");
                if (name.startsWith(data.getCommandArgs()[0])) {
                    strings.add(name);
                }
            } else if (data.getCommandArgs().length == 2) {
                if (data.getGlobal().getNameTag().grabPrefix().isEmpty()) {
                    return strings;
                }
                String name = data.getGlobal().getNameTag().grabPrefix().get().replaceAll(" ", "_").replaceAll("\u00a7", "&");
                if (name.startsWith(data.getCommandArgs()[1])) {
                    strings.add(name);
                }
            } else if (data.getCommandArgs().length == 3) {
                if (data.getGlobal().getNameTag().grabSuffix().isEmpty()) {
                    return strings;
                }
                String name = data.getGlobal().getNameTag().grabSuffix().get().replaceAll(" ", "_").replaceAll("\u00a7", "&");
                if (name.startsWith(data.getCommandArgs()[2])) {
                    strings.add(name);
                }
            }
            return strings;
        });
        SETTABLISTNAME = new Command((Plugin)PlayerNPCPlugin.getInstance(), "settablistname", "(id) (text)", true, false, "Set tab list name of an NPC", "\u00a77This sets the tab list name of an NPC.\n\u00a77No need to set it. By default will be \u00a78[NPC] {id}\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(text) \u00a77Name that will show on tab list.", (command, data) -> {
            if (data.getArgs().length < 3) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            String name = data.getArgs()[2].replaceAll("_", " ").replaceAll("&", "\u00a7");
            data.getGlobal().setTabListName(name).update();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77custom tab list name has been set to \u00a7e" + ColorUtils.formatColor(data.getGlobal().getTabListName()));
            if (!data.getGlobal().getTabListVisibility().equals(NPC.TabListVisibility.NEVER)) {
                return;
            }
            new ClickableText("\u00a77You need to do \u00a7e" + SETTABLISTVISIBILITY.getCommand(data.getGlobal(), "true") + " \u00a77to show the custom tab list name on the tab list.", "\u00a7eClick to write command.", ClickEvent.Action.SUGGEST_COMMAND, SETTABLISTVISIBILITY.getCommand(data.getGlobal(), "true")).send(data.getCommandSender());
        }, (command, data) -> {
            String name;
            if (data.getCommandArgs().length > 1) {
                return null;
            }
            ArrayList<String> strings = new ArrayList<String>();
            if (data.getCommandArgs().length == 1 && (name = data.getGlobal().getTabListName().replaceAll(" ", "_").replaceAll("\u00a7", "&")).startsWith(data.getCommandArgs()[0])) {
                strings.add(name);
            }
            return strings;
        });
        SETLINESPACING = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setlinespacing", "(id) (double/reset)", true, false, "Set line spacing of an NPC", "\u00a77This sets the line spacing of the Hologram of an NPC.\n\u00a77No need to set it. By default will be 0.27\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(double) \u00a77Value of the line spacing for an NPC", (command, data) -> {
            if (data.getArgs().length < 3) {
                CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal()));
                return;
            }
            Double d = null;
            if (MathUtils.isDouble(data.getArgs()[2])) {
                d = Double.parseDouble(data.getArgs()[2]);
            } else if (data.getArgs()[2].equalsIgnoreCase("reset")) {
                d = NPC.Attributes.getDefaultTextLineSpacing();
            }
            if (d == null) {
                CommandUtils.error(data.getCommandSender(), "This value is not valid.");
                return;
            }
            data.getGlobal().setTextLineSpacing(d).update();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77The NPC \u00a7a" + data.getID() + " \u00a77line spacing has been set as \u00a7e" + data.getGlobal().getTextLineSpacing());
        }, (command, data) -> {
            if (data.getArgs().length != 3) {
                return null;
            }
            ArrayList strings = new ArrayList();
            Arrays.asList("reset", "" + data.getGlobal().getTextLineSpacing()).stream().filter(x -> x.startsWith(data.getArgs()[2].toLowerCase())).forEach(x -> strings.add(x));
            return strings;
        });
        SETTEXTALIGNMENT = new Command((Plugin)PlayerNPCPlugin.getInstance(), "settextalignment", "(id) (vector/reset)", true, false, "Set text alignment of an NPC", "\u00a77This sets the text alignment of the Hologram of an NPC.\n\u00a77No need to set it. By default will be (0.0, 1.75, 0.0)\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(vector) \u00a77The vector added to NPC location.", (command, data) -> {
            if (data.getArgs().length < 3) {
                CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal()));
                return;
            }
            Vector look = null;
            if (MathUtils.isDouble(data.getArgs()[2])) {
                if (data.getArgs().length < 5 || !MathUtils.isDouble(data.getArgs()[3]) || !MathUtils.isDouble(data.getArgs()[4])) {
                    CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal()));
                    return;
                }
                Double x = Double.valueOf(data.getArgs()[2]);
                Double y = Double.valueOf(data.getArgs()[3]);
                Double z = Double.valueOf(data.getArgs()[4]);
                look = new Vector(x.doubleValue(), y.doubleValue(), z.doubleValue());
            } else if (data.getArgs()[2].equalsIgnoreCase("reset")) {
                look = NPC.Attributes.getDefaultTextAlignment();
            }
            if (look == null) {
                CommandUtils.error(data.getCommandSender(), "This value is not valid.");
                return;
            }
            data.getGlobal().setTextAlignment(look).update();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77The NPC \u00a7a" + data.getID() + " \u00a77text alignment has been set as (\u00a7e" + look.getX() + "\u00a77, \u00a7e" + look.getY() + "\u00a77, \u00a7e" + look.getZ() + "\u00a77)");
        }, (command, data) -> {
            if (data.getArgs().length > 5) {
                return null;
            }
            ArrayList<Object> strings = new ArrayList<Object>();
            if (data.getArgs().length == 3) {
                if ("reset".startsWith(data.getArgs()[2])) {
                    strings.add("reset");
                }
                if (Double.valueOf(data.getGlobal().getTextAlignment().getX()).toString().startsWith(data.getArgs()[2])) {
                    strings.add("" + data.getGlobal().getTextAlignment().getX());
                }
                return strings;
            }
            if (data.getArgs().length == 4 && MathUtils.isDouble(data.getArgs()[2]) && Double.valueOf(data.getGlobal().getTextAlignment().getY()).toString().startsWith(data.getArgs()[3])) {
                strings.add("" + data.getGlobal().getTextAlignment().getY());
            }
            if (data.getArgs().length == 5 && MathUtils.isDouble(data.getArgs()[2]) && MathUtils.isDouble(data.getArgs()[3]) && Double.valueOf(data.getGlobal().getTextAlignment().getZ()).toString().startsWith(data.getArgs()[4])) {
                strings.add("" + data.getGlobal().getTextAlignment().getZ());
            }
            return strings;
        });
        SETTEXTOPACITY = new Command((Plugin)PlayerNPCPlugin.getInstance(), "settextopacity", "(id) (textOpacity)", true, false, "Set text opacity of an NPC", "\u00a77This sets the text opacity of the Hologram of an NPC.\n\u00a77No need to set it. By default will be LOWEST\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(textOpacity) \u00a77Value that can be one of the suggested.\n\u00a78TextOpacity: \u00a77lowest, low, medium, hard, harder, full", (command, data) -> {
            if (data.getArgs().length < 3) {
                CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal()));
                return;
            }
            NPC.Hologram.Opacity textOpacity = null;
            try {
                textOpacity = NPC.Hologram.Opacity.valueOf(data.getArgs()[2].toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (textOpacity == null) {
                CommandUtils.error(data.getCommandSender(), "This text opacity type is not valid.");
                return;
            }
            data.getGlobal().setTextOpacity(textOpacity).update();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77text opacity has been set as \u00a7e" + textOpacity.name().toLowerCase());
        }, (command, data) -> {
            if (data.getArgs().length != 3) {
                return null;
            }
            ArrayList strings = new ArrayList();
            Arrays.stream(NPC.Hologram.Opacity.values()).filter(x -> x.name().toLowerCase().startsWith(data.getArgs()[2].toLowerCase())).forEach(x -> strings.add(x.name().toLowerCase()));
            return strings;
        });
        SETLINEOPACITY = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setlineopacity", "(id) (line) (textOpacity)", true, false, "Set line opacity of an NPC", "\u00a77This sets the text opacity of a line at the Hologram of an NPC.\n\u00a77No need to set it. By default will be LOWEST\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(line) \u00a77The line number that will be affected.\n\u00a78\u2022 \u00a7a(textOpacity) \u00a77Value that can be one of the suggested.\n\u00a78TextOpacity: \u00a77lowest, low, medium, hard, harder, full", (command, data) -> {
            if (data.getArgs().length < 4) {
                CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal()));
                return;
            }
            if (!MathUtils.isInteger(data.getArgs()[2])) {
                CommandUtils.error(data.getCommandSender(), "This line is not valid.");
                return;
            }
            Integer line = Integer.parseInt(data.getArgs()[2]);
            if (data.getArgs()[3].equalsIgnoreCase("reset")) {
                data.getGlobal().resetTextLineOpacity(line).update();
                data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77line opacity for line \u00a7e" + line + " \u00a77has been reset.");
                return;
            }
            NPC.Hologram.Opacity textOpacity = null;
            try {
                textOpacity = NPC.Hologram.Opacity.valueOf(data.getArgs()[3].toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (textOpacity == null) {
                CommandUtils.error(data.getCommandSender(), "This text opacity type is not valid.");
                return;
            }
            data.getGlobal().setTextLineOpacity(line, textOpacity).update();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77line opacity for line \u00a7e" + line + " \u00a77has been set as \u00a7e" + textOpacity.name().toLowerCase());
        }, (command, data) -> {
            if (data.getArgs().length > 4) {
                return null;
            }
            ArrayList<String> strings = new ArrayList<String>();
            if (data.getArgs().length == 3) {
                ArrayList<Integer> lines = new ArrayList<Integer>();
                for (int i = 1; i <= data.getGlobal().getText().size(); ++i) {
                    lines.add(i);
                }
                lines.stream().filter(x -> x.toString().startsWith(data.getArgs()[2])).forEach(x -> strings.add(x.toString()));
            }
            if (data.getArgs().length == 4) {
                Arrays.stream(NPC.Hologram.Opacity.values()).filter(x -> x.name().toLowerCase().startsWith(data.getArgs()[3].toLowerCase())).forEach(x -> strings.add(x.name().toLowerCase()));
                if ("reset".startsWith(data.getArgs()[3].toLowerCase())) {
                    strings.add("reset");
                }
            }
            return strings;
        });
        SETTEXTUPDATETICKS = new Command((Plugin)PlayerNPCPlugin.getInstance(), "settextupdateticks", "(id) (ticks/clear)", true, false, "Set text update ticks of an NPC", "\u00a77This will update text at certain ticks.\n\u00a77No need to set it. By default will be 0.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(ticks/clear) \u00a77Value that can be a number or clear.", (command, data) -> {
            Integer value;
            if (data.getCommandArgs().length < 1) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            if (data.getCommandArgs()[0].equalsIgnoreCase("clear")) {
                value = 0;
            } else {
                try {
                    value = Integer.valueOf(data.getCommandArgs()[0]);
                }
                catch (Exception e) {
                    CommandUtils.error(data.commandSender, "This number '" + data.getCommandArgs()[0] + "' is invalid.");
                    return;
                }
            }
            if (data.getGlobal().getTextUpdateTicks() == value) {
                CommandUtils.error(data.getCommandSender(), "The text update ticks was \u00a7e" + value + "\u00a77 yet");
                return;
            }
            data.getGlobal().setTextUpdateTicks(value);
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77The \u00a7etext update ticks \u00a77attribute of Global NPC \u00a7a" + data.getID() + " \u00a77has been set as \u00a7e" + data.getGlobal().getTextUpdateTicks());
        }, (command, data) -> {
            if (data.getCommandArgs().length != 1) {
                return null;
            }
            ArrayList<Object> strings = new ArrayList<Object>();
            Arrays.asList("clear").stream().filter(x -> x.startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x));
            if (data.getCommandArgs()[0].length() == 0) {
                strings.add("(number)");
                strings.add("\u00a76\u00a7nHow many text update ticks of the NPC?");
                strings.add("\u00a7eCurrent text update ticks: \u00a7" + (data.getGlobal().getTextUpdateTicks() > 0 ? "a" : "c") + data.getGlobal().getTextUpdateTicks());
            }
            return strings;
        });
        SETGAZETRACKINGTYPE = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setgazetrackingtype", "(id) (gazetrackingtype)", true, false, "Set gaze tracking type of an NPC", "\u00a77This sets the NPC gaze tracking type.\n\u00a77No need to set it. By default will be NONE.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(gazetrackingtype) \u00a77Value that can be one of the suggested\n\u00a78GazeTrackingType: \u00a77none, player, nearest_player, nearest_entity", (command, data) -> {
            if (data.getCommandArgs().length < 1) {
                CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal()));
                return;
            }
            NPC.GazeTrackingType.fromName(data.getCommandArgs()[0]).ifPresentOrElse(gazeTrackingType -> {
                data.getGlobal().setGazeTrackingType((NPC.GazeTrackingType)gazeTrackingType);
                data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77gaze tracking type has been set as \u00a7e" + gazeTrackingType.getName(EnumUtils.NameFormat.LOWER_CASE_WITH_SPACES));
            }, () -> CommandUtils.error(data.getCommandSender(), "This gaze tracking type is not valid."));
        }, (command, data) -> {
            if (data.getCommandArgs().length != 1) {
                return null;
            }
            ArrayList<Object> strings = new ArrayList<Object>();
            Arrays.stream(NPC.GazeTrackingType.values()).filter(x -> x.name().toLowerCase().startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x.name().toLowerCase()));
            if (strings.size() > 1) {
                strings.add("\u00a7eCurrently \u00a76" + data.getGlobal().getFullID() + " \u00a7eis \u00a7a" + data.getGlobal().getGazeTrackingType().getName(EnumUtils.NameFormat.LOWER_CASE_WITH_SPACES));
                strings.add("\u00a76\u00a7nWhich gaze tracking type?");
            } else if (strings.isEmpty() && data.getCommandArgs()[0].length() > 0) {
                strings.add("\u00a7c\u00a7nUnrecognized value:\u00a77 '" + data.getCommandArgs()[0].toLowerCase() + "'");
            }
            return strings;
        });
        SETGLOWING = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setglowing", "(id) (boolean)", true, false, "Set glowing of an NPC", "\u00a77This sets whether if the NPC will be glowing or not.\n\u00a77No need to set it. By default will be false.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(boolean) \u00a77Value that can be true or false.", (command, data) -> {
            if (data.getCommandArgs().length < 1) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            String value = data.getCommandArgs()[0].toLowerCase();
            Boolean bo = null;
            if (value.equals("true")) {
                bo = true;
            } else if (value.equals("false")) {
                bo = false;
            } else if (value.equals("toggle")) {
                bo = !data.getGlobal().isInvisible();
            } else {
                CommandUtils.error(data.getCommandSender(), "Boolean can only be true, false, or toggle.");
                return;
            }
            if (data.getGlobal().isGlowing() == bo.booleanValue()) {
                CommandUtils.error(data.getCommandSender(), "The glowing attribute was \u00a7e" + bo + "\u00a77 yet");
                return;
            }
            data.getGlobal().setGlowing(bo).update();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77The \u00a7eglowing \u00a77attribute of Global NPC \u00a7a" + data.getID() + " \u00a77has been set as " + (bo != false ? "\u00a7atrue" : "\u00a7cfalse"));
        }, (command, data) -> {
            if (data.getCommandArgs().length != 1) {
                return null;
            }
            ArrayList<Object> strings = new ArrayList<Object>();
            List<String> values = Arrays.asList("true", "false", "toggle");
            values.stream().filter(x -> x.startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x));
            if (strings.size() > 1) {
                strings.add("\u00a7eCurrently \u00a76" + data.getGlobal().getFullID() + " \u00a7eis" + (!data.getGlobal().isGlowing() ? " \u00a7cnot" : "\u00a7a") + " glowing");
                strings.add("\u00a76\u00a7nShould the NPC be glowing?");
            } else if (strings.isEmpty()) {
                if (values.isEmpty()) {
                    strings.add("\u00a7c\u00a7nNo value available");
                } else if (data.getCommandArgs()[0].length() > 0) {
                    strings.add("\u00a7c\u00a7nUnrecognized value:\u00a77 '" + data.getCommandArgs()[0].toLowerCase() + "'");
                }
            }
            return strings;
        });
        SETARROWSINBODY = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setarrowsinbody", "(id) (number/clear)", true, false, "Set arrows in body of an NPC", "\u00a77This sets how many arrows will be stuck in the body.\n\u00a77No need to set it. By default will be 0.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(number/clear) \u00a77Value that can be a number or clear.", (command, data) -> {
            Integer value;
            if (data.getCommandArgs().length < 1) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            if (data.getCommandArgs()[0].equalsIgnoreCase("clear")) {
                value = 0;
            } else {
                try {
                    value = Integer.valueOf(data.getCommandArgs()[0]);
                }
                catch (Exception e) {
                    CommandUtils.error(data.commandSender, "This number '" + data.getCommandArgs()[0] + "' is invalid.");
                    return;
                }
            }
            if (data.getGlobal().getArrowsInBody() == value) {
                CommandUtils.error(data.getCommandSender(), "The arrows in body was \u00a7e" + value + "\u00a77 yet");
                return;
            }
            data.getGlobal().setArrowsInBody(value).update();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77The \u00a7earrows in body \u00a77attribute of Global NPC \u00a7a" + data.getID() + " \u00a77has been set as \u00a7e" + data.getGlobal().getArrowsInBody());
        }, (command, data) -> {
            if (data.getCommandArgs().length != 1) {
                return null;
            }
            ArrayList<Object> strings = new ArrayList<Object>();
            Arrays.asList("clear").stream().filter(x -> x.startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x));
            if (data.getCommandArgs()[0].length() == 0) {
                strings.add("(number)");
                strings.add("\u00a76\u00a7nHow many arrows in the body of the NPC?");
                strings.add("\u00a7eCurrent arrows in body: \u00a7" + (data.getGlobal().getArrowsInBody() > 0 ? "a" : "c") + data.getGlobal().getArrowsInBody());
            }
            return strings;
        });
        SETBEESTINGERSINBODY = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setbeestingersinbody", "(id) (number/clear)", true, false, "Set bee stingers in body of an NPC", "\u00a77This sets how many bee stingers will be stuck in the body.\n\u00a77No need to set it. By default will be 0.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(number/clear) \u00a77Value that can be a number or clear.", (command, data) -> {
            Integer value;
            if (data.getCommandArgs().length < 1) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            if (data.getCommandArgs()[0].equalsIgnoreCase("clear")) {
                value = 0;
            } else {
                try {
                    value = Integer.valueOf(data.getCommandArgs()[0]);
                }
                catch (Exception e) {
                    CommandUtils.error(data.commandSender, "This number '" + data.getCommandArgs()[0] + "' is invalid.");
                    return;
                }
            }
            if (data.getGlobal().getBeeStingersInBody() == value) {
                CommandUtils.error(data.getCommandSender(), "The bee stingers in body was \u00a7e" + value + "\u00a77 yet");
                return;
            }
            data.getGlobal().setBeeStingersInBody(value).update();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77The \u00a7ebee stingers in body \u00a77attribute of Global NPC \u00a7a" + data.getID() + " \u00a77has been set as \u00a7e" + data.getGlobal().getBeeStingersInBody());
        }, (command, data) -> {
            if (data.getCommandArgs().length != 1) {
                return null;
            }
            ArrayList<Object> strings = new ArrayList<Object>();
            Arrays.asList("clear").stream().filter(x -> x.startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x));
            if (data.getCommandArgs()[0].length() == 0) {
                strings.add("(number)");
                strings.add("\u00a76\u00a7nHow many bee stingers in the body of the NPC?");
                strings.add("\u00a7eCurrent bee stingers in body: \u00a7" + (data.getGlobal().getBeeStingersInBody() > 0 ? "a" : "c") + data.getGlobal().getBeeStingersInBody());
            }
            return strings;
        });
        SETONFIRE = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setonfire", "(id) (boolean)", true, false, "Set on fire an NPC", "\u00a77This sets whether if the NPC will be on fire or not.\n\u00a77No need to set it. By default will be false.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(boolean) \u00a77Value that can be true or false.", (command, data) -> {
            if (data.getCommandArgs().length < 1) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            String value = data.getCommandArgs()[0].toLowerCase();
            Boolean bo = null;
            if (value.equals("true")) {
                bo = true;
            } else if (value.equals("false")) {
                bo = false;
            } else if (value.equals("toggle")) {
                bo = !data.getGlobal().isInvisible();
            } else {
                CommandUtils.error(data.getCommandSender(), "Boolean can only be true, false, or toggle.");
                return;
            }
            if (data.getGlobal().isOnFire() == bo.booleanValue()) {
                CommandUtils.error(data.getCommandSender(), "The on fire attribute was \u00a7e" + bo + "\u00a77 yet");
                return;
            }
            data.getGlobal().setOnFire(bo).update();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77on fire has been set as \u00a7e" + bo.toString());
        }, (command, data) -> {
            if (data.getCommandArgs().length != 1) {
                return null;
            }
            ArrayList<Object> strings = new ArrayList<Object>();
            List<String> values = Arrays.asList("true", "false", "toggle");
            values.stream().filter(x -> x.startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x));
            if (strings.size() > 1) {
                strings.add("\u00a7eCurrently \u00a76" + data.getGlobal().getID().getFullID() + " \u00a7eis" + (!data.getGlobal().isOnFire() ? " \u00a7cnot" : "\u00a7a") + " on fire");
                strings.add("\u00a76\u00a7nShould the NPC be on fire?");
            } else if (strings.isEmpty()) {
                if (values.isEmpty()) {
                    strings.add("\u00a7c\u00a7nNo value available");
                } else if (data.getCommandArgs()[0].length() > 0) {
                    strings.add("\u00a7c\u00a7nUnrecognized value:\u00a77 '" + data.getCommandArgs()[0].toLowerCase() + "'");
                }
            }
            return strings;
        });
        SETINVISIBLE = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setinvisible", "(id) (boolean)", true, false, "Set invisible an NPC", "\u00a77This sets whether if the NPC will be invisible or not.\n\u00a77No need to set it. By default will be false.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(boolean) \u00a77Value that can be true or false.", (command, data) -> {
            if (data.getCommandArgs().length < 1) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            String value = data.getCommandArgs()[0].toLowerCase();
            Boolean bo = null;
            if (value.equals("true")) {
                bo = true;
            } else if (value.equals("false")) {
                bo = false;
            } else if (value.equals("toggle")) {
                bo = !data.getGlobal().isInvisible();
            } else {
                CommandUtils.error(data.getCommandSender(), "Boolean can only be true, false, or toggle.");
                return;
            }
            if (data.getGlobal().isInvisible() == bo.booleanValue()) {
                CommandUtils.error(data.getCommandSender(), "The invisible attribute was \u00a7e" + bo + "\u00a77 yet");
                return;
            }
            data.getGlobal().setInvisible(bo).update();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77invisible has been set as " + CommandUtils.b(bo));
        }, (command, data) -> {
            if (data.getCommandArgs().length != 1) {
                return null;
            }
            ArrayList<Object> strings = new ArrayList<Object>();
            List<String> values = Arrays.asList("true", "false", "toggle");
            values.stream().filter(x -> x.startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x));
            if (strings.size() > 1) {
                strings.add("\u00a7eCurrently \u00a76" + data.getGlobal().getID().getFullID() + " \u00a7eis " + (!data.getGlobal().isInvisible() ? "\u00a7cvisible" : "\u00a7ainvisible"));
                strings.add("\u00a76\u00a7nShould the NPC be invisible?");
            } else if (strings.isEmpty()) {
                if (values.isEmpty()) {
                    strings.add("\u00a7c\u00a7nNo value available");
                } else if (data.getCommandArgs()[0].length() > 0) {
                    strings.add("\u00a7c\u00a7nUnrecognized value:\u00a77 '" + data.getCommandArgs()[0].toLowerCase() + "'");
                }
            }
            return strings;
        });
        SETSHAKING = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setshaking", "(id) (boolean)", true, false, "Set shaking an NPC", "\u00a77This sets whether if the NPC will be shaking or not.\n\u00a77No need to set it. By default will be false.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(boolean) \u00a77Value that can be true or false.", (command, data) -> {
            if (data.getCommandArgs().length < 1) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            String value = data.getCommandArgs()[0].toLowerCase();
            Boolean bo = null;
            if (value.equals("true")) {
                bo = true;
            } else if (value.equals("false")) {
                bo = false;
            } else if (value.equals("toggle")) {
                bo = data.getGlobal().isShaking() == false;
            } else {
                CommandUtils.error(data.getCommandSender(), "Boolean can only be true, false, or toggle.");
                return;
            }
            if (data.getGlobal().isShaking().equals(bo)) {
                CommandUtils.error(data.getCommandSender(), "The shaking attribute was \u00a7e" + bo + "\u00a77 yet");
                return;
            }
            data.getGlobal().setShaking(bo).update();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77shaking has been set as \u00a7e" + bo.toString());
        }, (command, data) -> {
            if (data.getCommandArgs().length != 1) {
                return null;
            }
            ArrayList<Object> strings = new ArrayList<Object>();
            List<String> values = Arrays.asList("true", "false", "toggle");
            values.stream().filter(x -> x.startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x));
            if (strings.size() > 1) {
                strings.add("\u00a7eCurrently \u00a76" + data.getGlobal().getID().getFullID() + " \u00a7eis" + (data.getGlobal().isShaking() == false ? " \u00a7cnot" : "\u00a7a") + " shaking");
                strings.add("\u00a76\u00a7nShould the NPC be shaking?");
            } else if (strings.isEmpty()) {
                if (values.isEmpty()) {
                    strings.add("\u00a7c\u00a7nNo value available");
                } else if (data.getCommandArgs()[0].length() > 0) {
                    strings.add("\u00a7c\u00a7nUnrecognized value:\u00a77 '" + data.getCommandArgs()[0].toLowerCase() + "'");
                }
            }
            return strings;
        });
        SETPOSE = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setpose", "(id) (npcpose)", true, false, "Set pose of an NPC", "\u00a77This sets the pose of an NPC\n\u00a77No need to set it. By default will be STANDING.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(npcpose) \u00a77The pose of the NPC.\n\u00a78NPC.Pose: \u00a77standing, gliding, sleeping, swimming, crouching, spin_attack", (command, data) -> {
            if (data.getArgs().length < 3) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            NPC.Pose.fromName(data.getCommandArgs()[0]).ifPresentOrElse(pose -> {
                if (data.getGlobal().getPose().equals(pose)) {
                    CommandUtils.error(data.getCommandSender(), "The pose was \u00a7e" + pose.getName(EnumUtils.NameFormat.LOWER_CASE_WITH_SPACES) + "\u00a77 yet");
                    return;
                }
                if (pose.isDeprecated() && !NPCLib.getInstance().isDebug()) {
                    CommandUtils.error(data.getCommandSender(), "This pose is deprecated, only for developers.");
                    return;
                }
                data.getGlobal().setPose((NPC.Pose)pose).update();
                data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77The \u00a7epose \u00a77attribute of Global NPC \u00a7a" + data.getID() + " \u00a77has been set to \u00a7e" + pose.getName(EnumUtils.NameFormat.LOWER_CASE_WITH_SPACES));
            }, () -> CommandUtils.error(data.getCommandSender(), "This pose ('" + data.getCommandArgs()[0] + "') is not valid"));
        }, (command, data) -> {
            if (data.getArgs().length != 3) {
                return null;
            }
            ArrayList strings = new ArrayList();
            Arrays.stream(NPC.Pose.values()).filter(x -> !x.isDeprecated() && x.name().toLowerCase().startsWith(data.getArgs()[2].toLowerCase())).forEach(x -> strings.add(x.name().toLowerCase()));
            return strings;
        });
        PLAYANIMATION = new Command((Plugin)PlayerNPCPlugin.getInstance(), "playanimation", "(id) (animation)", true, false, "Play animation to an NPC", "\u00a77Plays an animation to the NPC\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(animation) \u00a77Animation that will be played.\n\u00a78NPC.Animation: \u00a77take_damage, swing_main_arm, swing_off_hand, critical_effect, magical_critical_effect", (command, data) -> {
            if (data.getArgs().length < 3) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            NPC.Animation.fromName(data.getCommandArgs()[0]).ifPresentOrElse(animation -> {
                if (animation.isDeprecated() && !data.getNPCLib().isDebug()) {
                    CommandUtils.error(data.getCommandSender(), "This animation is deprecated, only for developers.");
                    return;
                }
                data.getGlobal().playAnimation((NPC.Animation)animation);
                data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + "\u00a77 played animation \u00a7e" + animation.getName(EnumUtils.NameFormat.LOWER_CASE_WITH_SPACES));
            }, () -> CommandUtils.error(data.getCommandSender(), "This animation ('" + data.getCommandArgs()[0].toLowerCase() + "') is not valid"));
        }, (command, data) -> {
            if (data.getCommandArgs().length != 1) {
                return null;
            }
            ArrayList<Object> strings = new ArrayList<Object>();
            List values = Arrays.stream(NPC.Animation.values()).filter(x -> !x.isDeprecated()).map(x -> x.name().toLowerCase()).collect(Collectors.toList());
            values.stream().filter(x -> x.startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x));
            if (strings.size() > 1) {
                strings.add("\u00a76\u00a7nWhich animation you want to play the NPC?");
            } else if (strings.isEmpty()) {
                strings.add("\u00a7c\u00a7nUnrecognized animation:\u00a77 '" + data.getCommandArgs()[0] + "'");
            }
            return strings;
        });
        CUSTOMDATA = new Command((Plugin)PlayerNPCPlugin.getInstance(), "customdata", "(id) (get/set/clear) (key) [value]", true, false, "Manage custom data of an NPC", "\u00a77Manage the custom data of an NPC. Custom data is a map of a value assigned to a key.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(get/set/clear) \u00a77Action will be performed.\n\u00a78\u2022 \u00a7a(key) \u00a77Key to find the value.\n\u00a78\u2022 \u00a7a[value] \u00a77Value assigned to the key.", (command, data) -> {
            if (data.getArgs().length < 4) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            String action = data.getCommandArgs()[0].toLowerCase();
            String fullKey = data.getCommandArgs()[1].toLowerCase();
            NPCLib.Registry.ID key = null;
            if (NPCLib.Registry.ID.isFullValid(fullKey)) {
                String[] keySplit = fullKey.split("\\.", 2);
                if (Arrays.stream(Bukkit.getPluginManager().getPlugins()).map(x -> x.getName().toLowerCase()).filter(x -> x.equals(keySplit[0])).findFirst().orElse(null) == null) {
                    CommandUtils.error(data.getCommandSender(), "\u00a77There's no plugin with name '" + keySplit[0] + "'");
                    return;
                }
                key = NPCLib.Registry.ID.of(keySplit[0], keySplit[1]);
            } else if (NPCLib.Registry.ID.isSimpleValid(fullKey)) {
                key = NPCLib.Registry.ID.of(command.getPlugin(), fullKey);
            } else {
                CommandUtils.error(data.getCommandSender(), "Key ID '" + fullKey + "' is not valid.");
                return;
            }
            if (action.equals("set")) {
                if (data.getCommandArgs().length < 3) {
                    CommandUtils.notEnoughArguments(command, data);
                }
                if (data.getGlobal().hasCustomData(key) && data.getGlobal().grabCustomData(key).get().equalsIgnoreCase(data.getCommandArgs()[2])) {
                    CommandUtils.error(data.getCommandSender(), "Value for key " + key + " was already " + data.getGlobal().grabCustomData(key).get());
                    return;
                }
                data.getGlobal().setCustomData(key, data.getCommandArgs()[2]);
                CommandUtils.sendMessage(data.commandSender, "\u00a77Global NPC \u00a7a" + data.global.getID().getFullID() + " \u00a77custom data value for key \u00a7a" + key + " \u00a77has been set to: \u00a7e" + data.global.grabCustomData(key).get());
                return;
            }
            if (!data.getGlobal().hasCustomData(key)) {
                CommandUtils.error(data.getCommandSender(), "Custom data do not contain this key.");
                return;
            }
            if (action.equals("get")) {
                CommandUtils.sendMessage(data.commandSender, "\u00a77Global NPC \u00a7a" + data.global.getID().getFullID() + " \u00a77custom data value for key \u00a7a" + key + " \u00a77is: \u00a7e" + data.global.grabCustomData(key).get());
            } else if (action.equals("clear")) {
                data.getGlobal().setCustomData(key, null);
                CommandUtils.sendMessage(data.commandSender, "\u00a77Global NPC \u00a7a" + data.global.getID().getFullID() + " \u00a77custom data value for key \u00a7a" + key + " \u00a77has been cleared.");
            } else {
                CommandUtils.error(data.commandSender, "This action '" + action + "' is not recognized. Use get, set or clear.");
            }
        }, (command, data) -> {
            ArrayList<Object> strings = new ArrayList<Object>();
            if (data.getCommandArgs().length == 1) {
                List<String> values = Arrays.asList("get", "set", "clear");
                values.stream().filter(x -> x.startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x));
                if (strings.size() > 1) {
                    strings.add("\u00a76\u00a7nAction to perform?");
                } else if (strings.isEmpty()) {
                    strings.add("\u00a7c\u00a7nUnrecognized action:\u00a77 '" + data.getCommandArgs()[0] + "'");
                    strings.addAll(values);
                }
                return strings;
            }
            if (data.getCommandArgs()[0].isEmpty()) {
                return strings;
            }
            String actionString = data.getCommandArgs()[0].toLowerCase();
            boolean actionSet = actionString.equals("set");
            boolean actionGet = actionString.equals("get");
            boolean actionClear = actionString.equals("clear");
            if (!(actionGet || actionSet || actionClear)) {
                return strings;
            }
            if (data.getCommandArgs().length == 2) {
                Set<String> values = data.getGlobal().getCustomDataKeys();
                values.stream().filter(x -> x.contains(data.getCommandArgs()[1].toLowerCase())).forEach(x -> strings.add(x));
                if (values.isEmpty() && !actionSet) {
                    strings.add("\u00a7cCustom data does not contain any key");
                } else {
                    if (data.getCommandArgs()[1].length() == 0 && actionSet) {
                        strings.add("(simpleKey)");
                        strings.add("(fullKey)");
                    }
                    if (strings.size() > 1) {
                        strings.add("\u00a76\u00a7nKey of custom data you want to " + actionString + "?");
                    } else if (strings.isEmpty() && !actionSet) {
                        strings.add("\u00a7c\u00a7nUnrecognized key:\u00a77 '" + data.getCommandArgs()[1] + "'");
                    }
                }
            } else if (data.getCommandArgs().length == 3 && actionSet) {
                if (data.getCommandArgs()[1].isEmpty()) {
                    return strings;
                }
                if (data.getGlobal().hasCustomData(data.getCommandArgs()[1]) && data.getGlobal().grabCustomData(data.getCommandArgs()[1]).get().startsWith(data.getCommandArgs()[2])) {
                    strings.add(data.getGlobal().grabCustomData(data.getCommandArgs()[1]).get());
                }
                if (data.getCommandArgs()[2].length() == 0) {
                    strings.add("(value)");
                    strings.add("\u00a76\u00a7nValue you want to set for key " + data.getCommandArgs()[1] + "?");
                }
            }
            return strings;
        });
        ACTION = new ActionCommand();
        TELEPORT = new Command((Plugin)PlayerNPCPlugin.getInstance(), "teleport", "(id) (player/location)", true, false, "Teleport an NPC", "\u00a77This will teleport the NPC to your location.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(player/location) \u00a77The name of the player or location (world, x, y, z)", (command, data) -> {
            if (data.getCommandArgs().length < 1) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            Location look = null;
            Player lookPlayer = null;
            if (data.getCommandArgs().length > 1) {
                World lookWorld = Bukkit.getWorld((String)data.getCommandArgs()[0]);
                if (lookWorld == null) {
                    CommandUtils.error(data.getCommandSender(), "That world do not exist.");
                    return;
                }
                if (!(data.getCommandArgs().length >= 4 && MathUtils.isDouble(data.getCommandArgs()[1]) && MathUtils.isDouble(data.getCommandArgs()[2]) && MathUtils.isDouble(data.getCommandArgs()[3]))) {
                    CommandUtils.notEnoughArguments(command, data);
                    return;
                }
                Double x = Double.valueOf(data.getCommandArgs()[1]);
                Double y = Double.valueOf(data.getCommandArgs()[2]);
                Double z = Double.valueOf(data.getCommandArgs()[3]);
                look = new Location(data.getGlobal().getWorld(), x.doubleValue(), y.doubleValue(), z.doubleValue());
            } else {
                lookPlayer = Bukkit.getPlayerExact((String)data.getCommandArgs()[0]);
                if (lookPlayer == null || !lookPlayer.isOnline()) {
                    CommandUtils.error(data.getCommandSender(), "That player is not online.");
                    return;
                }
                look = lookPlayer.getLocation();
            }
            if (look == null) {
                CommandUtils.error(data.getCommandSender(), "We can't find that location.");
                return;
            }
            data.getGlobal().teleport(look);
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77has been teleported to \u00a7f" + (String)(lookPlayer != null ? lookPlayer.getName() : look.getWorld().getName() + ", " + look.getX() + ", " + look.getY() + ", " + look.getZ()));
        }, (command, data) -> {
            String x2;
            ArrayList<String> strings = new ArrayList<String>();
            if (data.getCommandArgs().length == 1) {
                Bukkit.getOnlinePlayers().stream().filter(x -> x.getName().toLowerCase().startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x.getName()));
                Bukkit.getWorlds().stream().filter(x -> x.getName().toLowerCase().startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x.getName()));
                return strings;
            }
            if (data.getCommandArgs().length == 2 && Bukkit.getWorld((String)data.getCommandArgs()[0]) != null) {
                String string = x2 = data.getPlayerSender() != null ? MathUtils.getSimpleFormat(data.getPlayerSender().getLocation().getX(), 1) : "0.0";
                if (x2.startsWith(data.getCommandArgs()[1])) {
                    strings.add(x2);
                }
            }
            if (data.getCommandArgs().length == 3 && MathUtils.isDouble(data.getCommandArgs()[1])) {
                String string = x2 = data.getPlayerSender() != null ? MathUtils.getSimpleFormat(data.getPlayerSender().getLocation().getY(), 1) : "0.0";
                if (x2.startsWith(data.getCommandArgs()[2])) {
                    strings.add(x2);
                }
            }
            if (data.getCommandArgs().length == 4 && MathUtils.isDouble(data.getCommandArgs()[1]) && MathUtils.isDouble(data.getCommandArgs()[2])) {
                String string = x2 = data.getPlayerSender() != null ? MathUtils.getSimpleFormat(data.getPlayerSender().getLocation().getZ(), 1) : "0.0";
                if (x2.startsWith(data.getCommandArgs()[3])) {
                    strings.add(x2);
                }
            }
            return strings;
        });
        LOOKAT = new Command((Plugin)PlayerNPCPlugin.getInstance(), "lookat", "(id) (player/location)", true, false, "Set look direction of an NPC", "\u00a77This will change the NPC look direction.\n\u00a7cBefore doing this you must create the NPC.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(player/location) \u00a77The name of the player or location (x y z)", (command, data) -> {
            if (data.getArgs().length < 3) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            Location look = null;
            if (MathUtils.isInteger(data.getArgs()[2])) {
                if (data.getArgs().length < 5 || !MathUtils.isInteger(data.getArgs()[3]) || !MathUtils.isInteger(data.getArgs()[4])) {
                    CommandUtils.notEnoughArguments(command, data);
                    return;
                }
                Integer x = Integer.valueOf(data.getArgs()[2]);
                Integer y = Integer.valueOf(data.getArgs()[3]);
                Integer z = Integer.valueOf(data.getArgs()[4]);
                look = new Location(data.getGlobal().getWorld(), (double)x.intValue(), (double)y.intValue(), (double)z.intValue());
            } else {
                Player lookPlayer = Bukkit.getPlayerExact((String)data.getArgs()[2]);
                if (lookPlayer == null || !lookPlayer.isOnline()) {
                    CommandUtils.error(data.getCommandSender(), "That player is not online.");
                    return;
                }
                if (!lookPlayer.getWorld().getName().equals(data.getGlobal().getWorld().getName())) {
                    CommandUtils.error(data.getCommandSender(), "That player is not in the same world as NPC.");
                    return;
                }
                look = lookPlayer.getLocation();
            }
            if (look == null) {
                CommandUtils.error(data.getCommandSender(), "We can't find that location.");
                return;
            }
            data.getGlobal().lookAt(look).update();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + "\u00a77 look direction has been set.");
        }, (command, data) -> {
            String x2;
            ArrayList<String> strings = new ArrayList<String>();
            if (data.getArgs().length == 3) {
                String x3;
                data.getGlobal().getWorld().getPlayers().stream().filter(x -> x.getWorld().getName().equals(data.getGlobal().getWorld().getName()) && x.getName().toLowerCase().startsWith(data.getArgs()[2].toLowerCase())).forEach(x -> strings.add(x.getName()));
                String string = x3 = data.getPlayerSender() != null ? "" + data.getPlayerSender().getLocation().getBlockX() : "0";
                if (x3.startsWith(data.getArgs()[2])) {
                    strings.add(x3);
                }
                return strings;
            }
            if (data.getArgs().length == 4 && MathUtils.isInteger(data.getArgs()[2])) {
                String string = x2 = data.getPlayerSender() != null ? "" + data.getPlayerSender().getLocation().getBlockY() : "0";
                if (x2.startsWith(data.getArgs()[3])) {
                    strings.add(x2);
                }
            }
            if (data.getArgs().length == 5 && MathUtils.isInteger(data.getArgs()[2]) && MathUtils.isInteger(data.getArgs()[3])) {
                String string = x2 = data.getPlayerSender() != null ? "" + data.getPlayerSender().getLocation().getBlockZ() : "0";
                if (x2.startsWith(data.getArgs()[4])) {
                    strings.add(x2);
                }
            }
            return strings;
        });
        SHOW = new Command((Plugin)PlayerNPCPlugin.getInstance(), "show", "(id)", true, true, "Show an NPC", "\u00a77This will show the EntityPlayer to the Player.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.", (command, data) -> {
            data.getGlobal().show();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77has been shown.");
        }, (command, data) -> null);
        HIDE = new Command((Plugin)PlayerNPCPlugin.getInstance(), "hide", "(id)", true, true, "Hide an NPC", "\"\u00a77This will hide the EntityPlayer from the Player.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.", (command, data) -> {
            data.getGlobal().hide();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77has been hidden.");
        }, (command, data) -> null);
        REMOVE = new Command((Plugin)PlayerNPCPlugin.getInstance(), "remove", "(id)", true, true, "Remove an NPC", "\u00a77This will destroy the NPC object.\n\u00a7cAll the NPC info will be removed.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.", (command, data) -> {
            if (data.getGlobal().isPersistent()) {
                data.getGlobal().setPersistent(false);
            }
            NPCLib.getInstance().removeGlobalNPC(data.getGlobal());
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77has been removed.");
        }, (command, data) -> null);
        SIMPLEUPDATE = new Command((Plugin)PlayerNPCPlugin.getInstance(), "simpleupdate", "(id)", true, true, "Update an NPC", "\u00a77This will update the client of the player.\n\u00a7cSome changes will need this to be visible.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.", (command, data) -> {
            data.getGlobal().simpleUpdate();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + "\u00a77 has been simple updated.");
        }, (command, data) -> null);
        FORCEUPDATE = new Command((Plugin)PlayerNPCPlugin.getInstance(), "forceupdate", "(id)", true, true, "Force update an NPC", "\u00a77This will update the client of the player.\n\u00a7cSome changes will need this to be visible.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.", (command, data) -> {
            data.getGlobal().forceUpdate();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + "\u00a77 has been force updated.");
        }, (command, data) -> null);
        SIMPLEUPDATETEXT = new Command((Plugin)PlayerNPCPlugin.getInstance(), "simpleupdatetext", "(id)", true, true, "Update the NPC Text", "\u00a77This will update the text above the NPC.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.", (command, data) -> {
            data.getGlobal().simpleUpdateText();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + "\u00a77 text has been updated.");
        }, (command, data) -> null);
        FORCEUPDATETEXT = new Command((Plugin)PlayerNPCPlugin.getInstance(), "forceupdatetext", "(id)", true, true, "Force update the NPC Text", "\u00a77This will update the text above the NPC.\n\u00a7cIf the text have different amount of lines you must do this.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.", (command, data) -> {
            data.getGlobal().forceUpdateText();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + "\u00a77 text has been force updated.");
        }, (command, data) -> null);
        LOADPERSISTENT = new Command((Plugin)PlayerNPCPlugin.getInstance(), "loadpersistent", "(id)", true, false, "Load persistent data of an NPC", "\u00a77This will load the persistent data of an NPC.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.", (command, data) -> {
            if (!data.getGlobal().isPersistent()) {
                CommandUtils.error(data.getCommandSender(), "This NPC is not persistent.");
                return;
            }
            data.getGlobal().getPersistentManager().load();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + "\u00a77 persistent data has been loaded.");
        }, (command, data) -> null);
        SAVEPERSISTENT = new Command((Plugin)PlayerNPCPlugin.getInstance(), "savepersistent", "(id)", true, false, "Save persistent data of an NPC", "\u00a77This will save the persistent data of an NPC.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.", (command, data) -> {
            if (!data.getGlobal().isPersistent()) {
                CommandUtils.error(data.getCommandSender(), "This NPC is not persistent.");
                return;
            }
            data.getGlobal().getPersistentManager().save();
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + "\u00a77 persistent data has been saved.");
        }, (command, data) -> null);
        DISABLEPERSISTENTSAVE = new Command((Plugin)PlayerNPCPlugin.getInstance(), "disablepersistentsave", "(id) (boolean)", true, false, "Disable persistent data save of an NPC", "\u00a77This sets whether if the NPC Persistent will save or not it's data on the future. Useful if you want to stay the NPC exactly how it's right now.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(boolean) \u00a77Value that can be true or false.", (command, data) -> {
            if (data.getCommandArgs().length < 1) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            if (!data.getGlobal().isPersistent()) {
                CommandUtils.error(data.getCommandSender(), "This NPC is not persistent.");
                return;
            }
            Boolean bo = Boolean.valueOf(data.getCommandArgs()[0]);
            if (data.getGlobal().getPersistentManager().isDisableSaving() == bo.booleanValue()) {
                CommandUtils.error(data.getCommandSender(), "Disable saving was \u00a7e" + bo + "\u00a77 yet");
                return;
            }
            data.getGlobal().getPersistentManager().setDisableSaving(bo);
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77disable saving has been set as " + CommandUtils.b(bo));
        }, (command, data) -> {
            if (data.getCommandArgs().length != 1) {
                return null;
            }
            ArrayList strings = new ArrayList();
            Arrays.asList("true", "false").stream().filter(x -> x.startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x));
            return strings;
        });
        GOTO = new Command((Plugin)PlayerNPCPlugin.getInstance(), "goto", "(id)", true, false, "Teleport you to an NPC", "\u00a77This will teleport you to the NPC location.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.", (command, data) -> {
            if (data.getPlayerSender() == null) {
                CommandUtils.error(data.getCommandSender(), "You cannot do this command through console.");
                return;
            }
            data.getPlayerSender().teleport(data.getGlobal().getLocation());
            CommandUtils.sendMessage((CommandSender)data.getPlayerSender(), "\u00a77You've been teleported to \u00a7a" + data.getID() + " \u00a77Global NPC.");
        }, (command, data) -> null);
        INFO = new InfoCommand();
    }

    public static class Command {
        private String argument;
        private String arguments;
        private boolean important;
        private boolean enabled;
        private String title;
        private String hover;
        private BiConsumer<Command, CommandData> execute;
        private BiFunction<Command, CommandData, List<String>> tabComplete;
        private Plugin plugin;
        private NPCLib.Command.Color color;

        protected Command(Plugin plugin, String argument, String arguments, boolean enabled, boolean important, String title, String hover, BiConsumer<Command, CommandData> execute, BiFunction<Command, CommandData, List<String>> tabComplete, NPCLib.Command.Color color) {
            if (NPCGlobalCommand.getCommand(argument) != null) {
                throw new IllegalArgumentException("Argument is already used.");
            }
            this.plugin = plugin;
            this.argument = argument;
            this.arguments = arguments;
            this.enabled = enabled;
            this.important = important;
            this.title = title;
            this.hover = hover;
            this.execute = execute;
            this.tabComplete = tabComplete;
            this.color = color;
            commands.add(this);
        }

        protected Command(Plugin plugin, String argument, String arguments, boolean enabled, boolean important, String title, String hover, BiConsumer<Command, CommandData> execute, BiFunction<Command, CommandData, List<String>> tabComplete) {
            this(plugin, argument, arguments, enabled, important, title, hover, execute, tabComplete, null);
        }

        public String getArgument() {
            return this.argument;
        }

        public String getArguments() {
            return this.arguments;
        }

        public boolean isImportant() {
            return this.important;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isCustom() {
            return !(this.plugin instanceof PlayerNPCPlugin);
        }

        public Plugin getPlugin() {
            return this.plugin;
        }

        public String getPluginName() {
            return this.getPlugin().getName();
        }

        public String getTitle() {
            return this.title;
        }

        public String getHover() {
            return this.hover;
        }

        public BiConsumer<Command, CommandData> getExecute() {
            return this.execute;
        }

        public BiFunction<Command, CommandData, List<String>> getTabComplete() {
            return this.tabComplete;
        }

        public NPCLib.PluginManager getPluginManager() {
            return NPCLib.getInstance().getPluginManager(this.plugin);
        }

        public NPCLib.Command.Color getColor() {
            return this.color == null ? this.getPluginManager().getCommandColor() : this.color;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getCommand() {
            return "/npcglobal " + this.argument + " " + this.arguments;
        }

        public String getCommand(NPC.Global npc) {
            if (npc == null) {
                return this.getCommand();
            }
            String args = this.arguments;
            args = args.replaceAll("\\(id\\)", npc.getID().getFullID());
            return "/npcglobal " + this.argument + " " + args;
        }

        public String getCommand(NPC.Global npc, String arguments) {
            return "/npcglobal " + this.argument + " " + npc.getID().getFullID() + " " + arguments;
        }
    }

    public class CommandData {
        protected final CommandSender commandSender;
        protected final String[] args;
        protected final String[] cmdArgs;
        protected final NPCLib npcLib;
        protected NPC.Global global;

        public CommandData(CommandSender commandSender, String[] args, NPCLib npcLib) {
            this.commandSender = commandSender;
            this.args = args;
            this.npcLib = npcLib;
            this.cmdArgs = new String[args.length - 2];
            for (int i = 2; i < args.length; ++i) {
                this.cmdArgs[i - 2] = args[i];
            }
        }

        public String getCommand() {
            if (this.args.length < 1) {
                return null;
            }
            return this.args[0];
        }

        public String getID() {
            if (this.args.length < 2) {
                return null;
            }
            return this.args[1];
        }

        public NPCLib getNPCLib() {
            return this.npcLib;
        }

        public void setGlobal(NPC.Global global) {
            this.global = global;
        }

        public Player getPlayerSender() {
            if (this.commandSender instanceof Player) {
                return (Player)this.commandSender;
            }
            return null;
        }

        public CommandSender getCommandSender() {
            return this.commandSender;
        }

        public NPC.Global getGlobal() {
            return this.global;
        }

        public String[] getArgs() {
            return this.args;
        }

        public String[] getCommandArgs() {
            return this.cmdArgs;
        }
    }
}

