/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.command.global;

import dev.sergiferry.playernpc.PlayerNPCPlugin;
import dev.sergiferry.playernpc.api.NPC;
import dev.sergiferry.playernpc.api.NPCLib;
import dev.sergiferry.playernpc.command.CommandUtils;
import dev.sergiferry.playernpc.command.NPCLibCommand;
import dev.sergiferry.playernpc.command.global.NPCGlobalCommand;
import dev.sergiferry.playernpc.nms.spigot.NMSPlayer;
import dev.sergiferry.playernpc.utils.ClickableText;
import dev.sergiferry.playernpc.utils.ColorUtils;
import dev.sergiferry.playernpc.utils.MathUtils;
import dev.sergiferry.playernpc.utils.StringUtils;
import dev.sergiferry.playernpc.utils.TimerUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.util.Vector;

public class InfoCommand
extends NPCGlobalCommand.Command {
    protected InfoCommand() {
        super((Plugin)PlayerNPCPlugin.getInstance(), "info", "(id)", true, true, "Get info of an NPC", "\u00a77This will give you all the information about an NPC.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.", (command, data) -> {
            Player player = data.getPlayerSender();
            if (player == null) {
                CommandUtils.error(data.getCommandSender(), "This command cannot be executed from console.");
            }
            NPC.Global global = data.getGlobal();
            Integer page = 1;
            Integer maxPage = 4;
            if (data.getCommandArgs().length >= 1 && MathUtils.isInteger(data.getCommandArgs()[0])) {
                page = Integer.valueOf(data.getCommandArgs()[0]);
            }
            for (int i = 0; i < 100; ++i) {
                player.sendMessage("");
            }
            NMSPlayer.sendMessage(player, "  \u00a7c\u00a7lInformation about the NPC \u00a77(Page " + page + "/" + maxPage + ")", "");
            if (page == 1) {
                InfoCommand.printPage1(command, data);
            } else if (page == 2) {
                InfoCommand.printPage2(command, data);
            } else if (page == 3) {
                InfoCommand.printPage3(command, data);
            } else if (page == 4) {
                InfoCommand.printPage4(command, data);
            }
            player.sendMessage("");
            boolean next = page < maxPage;
            boolean previous = page > 1;
            ClickableText clickableText = new ClickableText("  ");
            if (previous) {
                clickableText.add("\u00a7c\u00a7l[PREVIOUS]", "\u00a7eClick to go to the previous page.", ClickEvent.Action.RUN_COMMAND, "/npcglobal info " + global.getID().getFullID() + " " + (page - 1));
            } else {
                clickableText.add("\u00a78\u00a7l[PREVIOUS]");
            }
            clickableText.add("    ");
            if (next) {
                clickableText.add("\u00a7a\u00a7l[NEXT]", "\u00a7eClick to go to the next page.", ClickEvent.Action.RUN_COMMAND, "/npcglobal info " + global.getID().getFullID() + " " + (page + 1));
            } else {
                clickableText.add("\u00a78\u00a7l[NEXT]");
            }
            clickableText.add("    ");
            clickableText.add("\u00a7c\u00a7l[CLOSE INFO]", "\u00a7eClick to close information.", ClickEvent.Action.RUN_COMMAND, "/npcglobal help");
            clickableText.send(player);
            player.sendMessage("");
        }, (command, data) -> null);
    }

    private static ClickableText newLine(String title) {
        return new ClickableText("  \u00a78\u2022 \u00a76\u00a7l" + title + ": \u00a77");
    }

    private static void printPage1(NPCGlobalCommand.Command command, NPCGlobalCommand.CommandData data) {
        NPC.Global global = data.getGlobal();
        Player player = data.getPlayerSender();
        Set<NPC.Global> pluginNPCs = data.getNPCLib().getAllGlobalNPCs(global.getPlugin());
        int pluginNPCsSize = pluginNPCs.size();
        StringBuilder pluginNPCsBuilder = new StringBuilder("\u00a7e\u00a7lGlobal NPCs managed by " + global.getPlugin().getName() + ": \n");
        pluginNPCs.forEach(x -> pluginNPCsBuilder.append(", \u00a77" + x.getID().getFullID()));
        String pluginNPCsHover = pluginNPCsBuilder.toString().replaceFirst(", ", "");
        PluginDescriptionFile pluginDescriptionFile = global.getPlugin().getDescription();
        StringBuilder pluginDescriptionHover = new StringBuilder("\u00a7e\u00a7l" + global.getPlugin().getName());
        pluginDescriptionHover.append("\n\u00a7eMain: \u00a77" + pluginDescriptionFile.getMain());
        List authors = pluginDescriptionFile.getAuthors();
        pluginDescriptionHover.append("\n\u00a7eAuthor: \u00a77" + (authors.size() > 0 ? (String)authors.get(0) : "\u00a7cUnknown"));
        pluginDescriptionHover.append("\n\u00a7eVersion: \u00a77" + pluginDescriptionFile.getVersion());
        String persistentHover = "\u00a7c\u00a7lThis Global NPC is not persistent\n\u00a77This means that when you restart your server, the PlayerNPC plugin will not save the NPC data, and it won't appear, unless your plugin creates it again.\n\n" + (String)(global.canBePersistent() ? "\u00a77In order to make it persistent use:\n\u00a7e" + NPCGlobalCommand.SETPERSISTENT.getCommand(global, "true") : "\u00a7cYou cannot make it persistent because this NPC is not created by \u00a7lPlayerNPC \u00a7cplugin.");
        if (global.isPersistent()) {
            String persistentLastUpdate = TimerUtils.getCRCounterSimple(TimerUtils.getBetweenDatesString(global.getPersistentManager().getLastUpdate().getTime(), TimerUtils.getCurrentDate(), TimerUtils.DATE_FORMAT_LARGE, TimeUnit.SECONDS), true);
            String action = "";
            if (global.getPersistentManager().getLastUpdate().getType().equals((Object)NPC.Global.PersistentManager.LastUpdate.Type.SAVE)) {
                action = "Saved";
            }
            if (global.getPersistentManager().getLastUpdate().getType().equals((Object)NPC.Global.PersistentManager.LastUpdate.Type.LOAD)) {
                action = "Loaded";
            }
            persistentHover = "\u00a7a\u00a7lThis Global NPC is persistent\n\u00a77This means that the PlayerNPC plugin will store all the NPC data when the server restarts, and will be re-generated.\n\n\u00a77\u00a7o" + action + " " + persistentLastUpdate + " ago." + (global.getPersistentManager().isDisableSaving() ? "\n\u00a7cThis NPC has persistent data saving disabled." : "") + "\n\n\u00a77In order to make it not persistent use:\n\u00a7e" + NPCGlobalCommand.SETPERSISTENT.getCommand(global, "false");
        }
        InfoCommand.newLine("ID").add("\u00a77" + global.getID().getFullID(), "\u00a7e\u00a7lNPC Identification\n\u00a7eID: \u00a77" + global.getID().getFullID() + "\n\u00a7eSimple ID: \u00a77" + global.getID().getSimpleID()).add(" ").add("\u00a7e\u00a7l\u24d8", "\u00a7e\u00a7l\u24d8 Information about NPC ID\n\u00a77The Full ID is used to execute commands to a specific NPC, while the Simple ID is used by plugins to find the instance of the NPC object.").send(player);
        InfoCommand.newLine("Type").add("\u00a77NPC.Global").add(" ").add(global.isPersistent() ? "\u00a7a(Persistent)" : "\u00a7c(Not Persistent)", persistentHover, ClickEvent.Action.SUGGEST_COMMAND, global.canBePersistent() ? NPCGlobalCommand.SETPERSISTENT.getCommand(global, "" + !global.isPersistent()) : "").add(" ").add("\u00a7e\u00a7l\u24d8", "\u00a7e\u00a7l\u24d8 Information about NPC Type\n\u00a77This means that this NPC is visible for every player selected, or for everyone, depending on it's visibility. The Global NPC object is not like an NPC itself, but it's like a manager of Personal NPCs of every player.").send(player);
        InfoCommand.newLine("Plugin").add("\u00a77" + global.getPlugin().getName(), pluginDescriptionHover.toString(), ClickEvent.Action.RUN_COMMAND, NPCLibCommand.INFO.getCommand(global.getPlugin().getName())).add(" ").add("\u00a7e(" + pluginNPCsSize + " Global NPCs)", pluginNPCsHover).add(" ").add("\u00a7e\u00a7l\u24d8", "\u00a7e\u00a7l\u24d8 Information about NPC Plugin\n\u00a77This plugin is the manager for this NPC, that means that in their code, it has been created this NPC, and it's managed also.").send(player);
        InfoCommand.newLine("Location").add("\u00a77" + global.getWorld().getName() + ", " + MathUtils.getFormat(global.getX(), 1) + ", " + MathUtils.getFormat(global.getY(), 1) + ", " + MathUtils.getFormat(global.getZ(), 1) + ", " + MathUtils.getFormat(global.getYaw().floatValue(), 1) + ", " + MathUtils.getFormat(global.getPitch().floatValue(), 1), "\u00a7eClick to teleport", ClickEvent.Action.RUN_COMMAND, "/npcglobal goto " + global.getID().getFullID()).send(player);
    }

    private static void printPage2(NPCGlobalCommand.Command command, NPCGlobalCommand.CommandData data) {
        NPC.Global global = data.getGlobal();
        Player player = data.getPlayerSender();
        StringBuilder playersHoverBuilder = new StringBuilder("\u00a7eCurrent players (\u00a7a\u00a7lSHOWN\u00a7e/\u00a7c\u00a7lHIDDEN\u00a7e): \n");
        Set<Player> players = global.getPlayers();
        int playersSize = players.size();
        players.forEach(x -> playersHoverBuilder.append("\u00a77, " + (global.getPersonal((Player)x).isShown() ? "\u00a7a" : "\u00a7c") + x.getName()));
        String playersHover = playersHoverBuilder.toString().replaceFirst("\u00a77, ", "");
        String skinName = "None";
        String skinCommand = NPCLibCommand.GETSKININFO.getCommand("npc " + global.getID().getFullID());
        if (global.isOwnPlayerSkin()) {
            skinName = "Own Player Skin";
        }
        Object hoverSkin = "";
        if (global.isOwnPlayerSkin()) {
            hoverSkin = "\u00a7e\u00a7lOwn Player Skin\n\u00a77This means that each player will see their own skin on the NPC.";
        } else if (global.getSkin().getType().equals(NPC.Skin.Type.CUSTOM)) {
            NPC.Skin.Custom customSkin = (NPC.Skin.Custom)global.getSkin();
            skinName = "Custom skin";
            hoverSkin = customSkin.getInformation() + "\n\n\u00a7eClick to see more information.";
        } else if (global.getSkin().getType().equals(NPC.Skin.Type.MINECRAFT)) {
            NPC.Skin.Minecraft playerSkin = (NPC.Skin.Minecraft)global.getSkin();
            skinName = playerSkin.getName();
            hoverSkin = playerSkin.getInformation() + "\n\n\u00a7eClick to see more information.";
        } else if (global.getSkin().getType().equals(NPC.Skin.Type.MINESKIN)) {
            NPC.Skin.MineSkin skin = (NPC.Skin.MineSkin)global.getSkin();
            skinName = "MineSkin";
            hoverSkin = skin.getInformation() + "\n\n\u00a7eClick to see more information.";
        }
        StringBuilder hoverPartsBuilder = new StringBuilder("\u00a7e\u00a7lSkin layers");
        Arrays.stream(NPC.Skin.Layer.values()).forEach(x -> hoverPartsBuilder.append("\n\u00a77" + StringUtils.getFirstCharUpperCase(x.name().replaceAll("_", " "), true) + ": " + CommandUtils.i(global.getSkinVisibleLayers().isVisible((NPC.Skin.Layer)x))));
        StringBuilder hoverCustomDataBuilder = new StringBuilder("\u00a7e\u00a7lCustom data");
        global.getCustomDataKeysID().forEach(x -> hoverCustomDataBuilder.append("\n\u00a7eKey: \u00a77" + x + "\n \u00a7e\u27a5 \u00a7eValue: \u00a77" + global.grabCustomData((NPCLib.Registry.ID)x).get()));
        NPCLib.Registry.ID visibilityRequirementID = NPCLib.Registry.ID.of(command.getPlugin(), "visibilityRequirementPermission");
        InfoCommand.newLine("Visibility").add("\u00a77" + StringUtils.getFirstCharUpperCase(global.getVisibility().name().replaceAll("_", " "), true) + " ").add("\u00a7e(" + playersSize + " player" + (playersSize != 1 ? "s" : "") + ")", playersSize > 0 ? playersHover : "").add(" ").add("\u00a7e\u00a7l\u24d8", "\u00a7e\u00a7l\u24d8 Information about visibility\n\u00a77The visibility can be for all or for selected players, this means that if it is for all, any person (that meets the visibility requirements) will be able to see the NPC, and if it is for selected players, only those players who have been previously selected will be able to see it.").send(player);
        InfoCommand.newLine("Visibility requirement").add("\u00a77" + (String)(global.hasVisibilityRequirement() ? (global.hasCustomData(visibilityRequirementID) ? "\u00a7e" + global.grabCustomData(visibilityRequirementID).get() + " \u00a77permission" : "Custom visibility requirement") : "\u00a7cNone"), (String)(global.hasVisibilityRequirement() && !global.hasCustomData(visibilityRequirementID) ? "\u00a7eCustom visibility requirement: \u00a77" + global.getVisibilityRequirement().toString().split("/")[0] : "")).add(" ").add("\u00a7e\u00a7l\u24d8", "\u00a7e\u00a7l\u24d8 Information about visibility requirement\n\u00a77This requirement will be validated in order to add the player to the NPC's visibility. In case the requirement is not met, the player will not be added and therefore will not be able to see the NPC.").send(player);
        InfoCommand.newLine("Skin").add("\u00a77" + skinName, (String)hoverSkin, skinCommand != null, ClickEvent.Action.RUN_COMMAND, skinCommand).add(" ").add("\u00a7e(Hover to see skin layers)", hoverPartsBuilder.toString()).add(" ").add("\u00a7e\u00a7l\u24d8", "\u00a7e\u00a7l\u24d8 Information about skin\n\u00a77The skin is the image that is displayed on the body of the NPC. This can be from a specific player, and will be downloaded directly from the Mojang servers, or from the GameProfile if the player is connected, but it can also be a custom texture that does not correspond to any player.").send(player);
        ClickableText customData = InfoCommand.newLine("Custom data").add((String)(global.getCustomDataKeys().size() > 0 ? "\u00a77" + global.getCustomDataKeys().size() + " data" : "\u00a7cEmpty"));
        if (global.getCustomDataKeys().size() > 0) {
            customData.add(" ").add("\u00a7e(Hover to see data)", hoverCustomDataBuilder.toString());
        }
        customData.add(" ").add("\u00a7e\u00a7l\u24d8", "\u00a7e\u00a7l\u24d8 Information about custom data\n\u00a77Custom data is a map of a String to a String, this means that plugins will be able to attribute a value to a key, and that it will be stored inside the NPC object.").send(player);
    }

    private static void printPage3(NPCGlobalCommand.Command command, NPCGlobalCommand.CommandData data) {
        NPC.Global global = data.getGlobal();
        Player player = data.getPlayerSender();
        InfoCommand.newLine("Auto-create").add("\u00a77" + CommandUtils.b(global.isAutoCreate())).add(" ").send(player);
        InfoCommand.newLine("Auto-show").add("\u00a77" + CommandUtils.b(global.isAutoShow())).add(" ").send(player);
        HashMap<NPC.Interact.ClickAction, Integer> actionsIDs = new HashMap<NPC.Interact.ClickAction, Integer>();
        for (int i = 0; i < global.getClickActionsSize(); ++i) {
            actionsIDs.put(global.getClickActions().get(i), i + 1);
        }
        List<NPC.Interact.ClickAction> left = global.getClickActions(NPC.Interact.ClickType.LEFT_CLICK);
        List<NPC.Interact.ClickAction> right = global.getClickActions(NPC.Interact.ClickType.RIGHT_CLICK);
        List<NPC.Interact.ClickAction> either = global.getClickActions(NPC.Interact.ClickType.EITHER);
        StringBuilder leftClickActionsBuilder = new StringBuilder("\u00a7e\u00a7lLeft click actions");
        left.forEach(x -> leftClickActionsBuilder.append("\n\u00a78\u2022 \u00a77" + x.getActionType().getName() + " #" + actionsIDs.get(x) + (!x.isEnabled() ? " \u00a7c(Disabled)" : "")));
        Integer firstLeftID = !left.isEmpty() ? (Integer)actionsIDs.get(left.get(0)) : null;
        StringBuilder rightClickActionsBuilder = new StringBuilder("\u00a7e\u00a7lRight click actions");
        right.forEach(x -> rightClickActionsBuilder.append("\n\u00a78\u2022 \u00a77" + x.getActionType().getName() + " #" + actionsIDs.get(x) + (!x.isEnabled() ? " \u00a7c(Disabled)" : "")));
        Integer firstRightID = !right.isEmpty() ? (Integer)actionsIDs.get(right.get(0)) : null;
        StringBuilder eitherClickActionsBuilder = new StringBuilder("\u00a7e\u00a7lEither click actions");
        either.forEach(x -> eitherClickActionsBuilder.append("\n\u00a78\u2022 \u00a77" + x.getActionType().getName() + " #" + actionsIDs.get(x) + (!x.isEnabled() ? " \u00a7c(Disabled)" : "")));
        Integer firstEitherID = !either.isEmpty() ? (Integer)actionsIDs.get(either.get(0)) : null;
        InfoCommand.newLine("Click actions").add((left.size() > 0 ? "\u00a7e" : "\u00a7c") + "(Left)", left.size() > 0 ? leftClickActionsBuilder.toString() : "\u00a7c\u00a7lLeft click actions\n\u00a77No action found for this type of click.", firstLeftID != null, ClickEvent.Action.RUN_COMMAND, NPCGlobalCommand.ACTION.getCommand(data.getGlobal(), "modify " + firstLeftID)).add(" ").add((either.size() > 0 ? "\u00a7e" : "\u00a7c") + "(Either)", either.size() > 0 ? eitherClickActionsBuilder.toString() : "\u00a7c\u00a7lEither click actions\n\u00a77No action found for this type of click.", firstEitherID != null, ClickEvent.Action.RUN_COMMAND, NPCGlobalCommand.ACTION.getCommand(data.getGlobal(), "modify " + firstEitherID)).add(" ").add((right.size() > 0 ? "\u00a7e" : "\u00a7c") + "(Right)", right.size() > 0 ? rightClickActionsBuilder.toString() : "\u00a7c\u00a7lRight click actions\n\u00a77No action found for this type of click.", firstRightID != null, ClickEvent.Action.RUN_COMMAND, NPCGlobalCommand.ACTION.getCommand(data.getGlobal(), "modify " + firstRightID)).add(" ").send(player);
        InfoCommand.newLine("Interact cooldown").add("\u00a77" + global.getInteractCooldown() + " milliseconds", CommandUtils.getTimeConversionMillisecondsToSeconds(global.getInteractCooldown())).send(player);
    }

    private static void printPage4(NPCGlobalCommand.Command command, NPCGlobalCommand.CommandData data) {
        NPC.Global global = data.getGlobal();
        Player player = data.getPlayerSender();
        StringBuilder textBuilder = new StringBuilder("");
        global.getText().forEach(x -> textBuilder.append("\n " + ChatColor.RESET + x));
        textBuilder.replace(0, 1, "");
        InfoCommand.newLine("Text").add((String)(global.getText().size() == 0 ? "\u00a7cNone" : "\u00a77" + global.getText().size() + " lines ")).add(global.getText().size() > 0 ? "\u00a7e(Hover to see the text)" : "", global.getText().size() > 0 ? TextComponent.fromLegacyText((String)ColorUtils.formatColor(textBuilder.toString())) : TextComponent.fromLegacyText((String)"")).send(player);
        InfoCommand.newLine("Text opacity").add("\u00a77" + StringUtils.getFirstCharUpperCase(global.getTextOpacity().name(), true)).add(" ").add("\u00a7e(Hover to see line opacity)").send(player);
        Vector textAlignment = global.getTextAlignment();
        InfoCommand.newLine("Text alignment").add("\u00a77x: " + textAlignment.getX() + ", y: " + textAlignment.getY() + ", z: " + textAlignment.getZ()).send(player);
        InfoCommand.newLine("Line spacing").add("\u00a77" + global.getTextLineSpacing()).send(player);
    }
}

