/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.command.global;

import dev.sergiferry.playernpc.PlayerNPCPlugin;
import dev.sergiferry.playernpc.api.NPC;
import dev.sergiferry.playernpc.api.NPCLib;
import dev.sergiferry.playernpc.command.CommandUtils;
import dev.sergiferry.playernpc.command.global.NPCGlobalCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class GenerateCommand
extends NPCGlobalCommand.Command {
    protected GenerateCommand() {
        super((Plugin)PlayerNPCPlugin.getInstance(), "generate", "(id) [persistent]", true, true, "Generate an NPC", "\u00a77It generates the Global NPC object with the id. You can also set if the NPC will be persistent, or not (You can change this after generation).\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID is a custom string you decide.\n\u00a78\u2022 \u00a7a[persistent] \u00a77Value that can be true or false", (command, data) -> {
            if (!NPCLib.Registry.ID.isSimpleValid(data.getID())) {
                CommandUtils.errorNotValidID(data.getCommandSender(), data.getID());
                return;
            }
            if (data.getNPCLib().grabGlobalNPC((Plugin)PlayerNPCPlugin.getInstance(), data.getID()).isPresent()) {
                CommandUtils.error(data.getCommandSender(), "The NPC with id \u00a7e" + data.getID() + " \u00a77is already generated.");
                return;
            }
            Boolean bo = null;
            if (data.getCommandArgs().length > 0) {
                if (!data.getCommandArgs()[0].equalsIgnoreCase("true") && !data.getCommandArgs()[0].equalsIgnoreCase("false")) {
                    CommandUtils.error(data.getCommandSender(), "Boolean can only be true or false.");
                    return;
                }
                bo = Boolean.valueOf(data.getCommandArgs()[0]);
            }
            NPC.Global npc = data.getNPCLib().generateGlobalNPC((Plugin)PlayerNPCPlugin.getInstance(), data.getID(), NPC.Global.Visibility.EVERYONE, null, data.getPlayerSender() != null ? data.getPlayerSender().getLocation() : new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0));
            npc.setPersistent(bo != null ? bo : true);
            data.getCommandSender().sendMessage(NPCGlobalCommand.getPrefix() + "\u00a77Global NPC " + (bo != null && bo != false ? "(Persistent) " : "") + "with ID: \u00a7a" + npc.getID().getFullID() + "\u00a77 has been generated.");
            npc.setSkin(data.getID()).thenAccept(x -> x.update());
        }, (command, data) -> {
            ArrayList<Object> strings = new ArrayList<Object>();
            if (data.getArgs().length == 2) {
                if (data.getArgs()[1].length() == 0) {
                    strings.add("(simpleID)");
                } else if (!NPCLib.Registry.ID.isSimpleValid(data.getArgs()[1])) {
                    strings.add("\u00a7c\u00a7nThis ID contains invalid characters");
                } else if (data.getNPCLib().hasGlobalNPC(command.getPlugin(), data.getArgs()[1])) {
                    strings.add("\u00a7c\u00a7nThere is already an NPC with that ID");
                }
            }
            if (data.getCommandArgs().length == 1) {
                List<String> values = Arrays.asList("true", "false");
                values.stream().filter(x -> x.startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x));
                if (data.getCommandArgs()[0].length() == 0) {
                    strings.add("\u00a76\u00a7nNPC should be persistent?");
                    strings.add("\u00a78Persistent NPCs will be saved on a file when the server restarts.");
                } else if (strings.isEmpty()) {
                    strings.add("\u00a7c\u00a7nUnrecognized value:\u00a77 '" + data.getCommandArgs()[0] + "'");
                    strings.addAll(values);
                }
            }
            return strings;
        });
    }
}

