/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.command.global;

import dev.sergiferry.playernpc.PlayerNPCPlugin;
import dev.sergiferry.playernpc.api.NPC;
import dev.sergiferry.playernpc.api.NPCLib;
import dev.sergiferry.playernpc.command.CommandUtils;
import dev.sergiferry.playernpc.command.global.NPCGlobalCommand;
import dev.sergiferry.playernpc.integration.IntegrationsManager;
import dev.sergiferry.playernpc.integration.integrations.BungeeCord;
import dev.sergiferry.playernpc.nms.craftbukkit.NMSCraftItemStack;
import dev.sergiferry.playernpc.utils.ClickableText;
import dev.sergiferry.playernpc.utils.ColorUtils;
import dev.sergiferry.playernpc.utils.EnumUtils;
import dev.sergiferry.playernpc.utils.MathUtils;
import dev.sergiferry.playernpc.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ActionCommand
extends NPCGlobalCommand.Command {
    protected ActionCommand() {
        super((Plugin)PlayerNPCPlugin.getInstance(), "action", "(id) (add/clear/modify) [right/left/both] [type] [value]", true, false, "Manage NPC actions", "\u00a77This sets the NPC actions will be executed when player interacts at it.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(id) \u00a77The ID of the NPC you decided on generation.\n\u00a78\u2022 \u00a7a(add/clear/modify) \u00a77Add, clear, or modify actions\n\u00a78\u2022 \u00a7a[right/left/both] \u00a77Type of player's click\n\u00a78\u2022 \u00a7a[type] \u00a77Type of NPC.Actions\n\u00a78\u2022 \u00a7a[value] \u00a77Value of the action\n\u00a78NPC.Actions: \u00a77console_command, player_command, actionbar_message, title_message, chat_message, teleport_player, connect_server", ActionCommand::lambda$new$0, (command, data) -> {
            String question;
            ArrayList<Object> strings = new ArrayList<Object>();
            if (data.getCommandArgs().length == 1) {
                List<String> values = Arrays.asList("add", "clear", "modify");
                values.stream().filter(x -> x.startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x));
                if (strings.isEmpty()) {
                    strings.addAll(values);
                    strings.add("\u00a7c\u00a7nUnrecognized action:\u00a77 '" + data.getCommandArgs()[0] + "'");
                } else if (data.getCommandArgs()[0].length() == 0) {
                    strings.add("\u00a76\u00a7nWhat do you want to do?");
                }
                return strings;
            }
            boolean add = data.getCommandArgs()[0].equalsIgnoreCase("add");
            boolean clear = data.getCommandArgs()[0].equalsIgnoreCase("clear");
            boolean modify = data.getCommandArgs()[0].equalsIgnoreCase("modify");
            if (data.getCommandArgs().length == 2) {
                ArrayList<Object> values = new ArrayList<Object>();
                if ((modify || clear) && data.getGlobal().getClickActions().isEmpty()) {
                    strings.add("\u00a7c\u00a7nThere are no click actions yet.");
                    return strings;
                }
                if (add || clear) {
                    values.addAll(Arrays.asList("right", "left", "both"));
                }
                if (modify || clear) {
                    Integer id = 1;
                    while (id <= data.getGlobal().getClickActionsSize()) {
                        values.add("" + id);
                        Integer n = id;
                        id = id + 1;
                    }
                }
                values.stream().filter(x -> x.startsWith(data.getCommandArgs()[1].toLowerCase())).forEach(x -> strings.add(x));
                question = "";
                String unrecognized = "";
                if (add) {
                    question = "In which Click to the NPC the action should be executed?";
                    unrecognized = "click type";
                } else if (clear) {
                    question = "Which action id or click type you want to clear?";
                    unrecognized = "click or id";
                } else if (modify) {
                    question = "Which action you want to modify?";
                    unrecognized = "action id";
                }
                if (strings.isEmpty()) {
                    strings.addAll(values);
                    strings.add("\u00a7c\u00a7nUnrecognized " + unrecognized + ":\u00a77 '" + data.getCommandArgs()[1] + "'");
                } else if (data.getCommandArgs()[1].length() == 0) {
                    strings.add("\u00a76\u00a7n" + question);
                }
            }
            if (data.getCommandArgs().length == 3) {
                if (clear) {
                    return strings;
                }
                if (add) {
                    ArrayList actions = new ArrayList();
                    Arrays.stream(NPC.Interact.Actions.Type.values()).filter(x -> !x.equals(NPC.Interact.Actions.Type.CUSTOM_ACTION)).forEach(x -> actions.add(x));
                    actions.stream().filter(x -> !x.isDeprecated() && x.name().toLowerCase().startsWith(data.getCommandArgs()[2].toLowerCase())).forEach(x -> strings.add(x.name().toLowerCase()));
                }
                if (modify) {
                    // empty if block
                }
            }
            if (data.getCommandArgs().length > 4 && modify && data.getCommandArgs()[2].equalsIgnoreCase("condition")) {
                String placeholder;
                String lastArgument;
                if (data.getCommandArgs().length == 5 && data.getCommandArgs()[3].equalsIgnoreCase("add")) {
                    Arrays.stream(NPC.Conditions.Type.values()).filter(x -> !x.isDeprecated() && x.name().toLowerCase().startsWith(data.getCommandArgs()[4].toLowerCase())).filter(x -> !x.equals(NPC.Conditions.Type.PLAYER_HAS_BALANCE) || IntegrationsManager.isUsingVault() && IntegrationsManager.getVault().isUsingEconomy()).forEach(x -> strings.add(x.name().toLowerCase()));
                }
                if (data.getCommandArgs().length == 7 && data.getCommandArgs()[3].equalsIgnoreCase("modify")) {
                    if (data.getCommandArgs()[5].equalsIgnoreCase("sound")) {
                        Arrays.stream(Sound.values()).filter(x -> x.name().toLowerCase().startsWith(data.getCommandArgs()[6].toLowerCase())).forEach(x -> strings.add(x.name().toLowerCase()));
                    }
                    if (data.getCommandArgs()[5].equalsIgnoreCase("sentencelogic")) {
                        Arrays.stream(NPC.Conditions.Comparator.Sentence.Logic.values()).filter(x -> x.name().toLowerCase().startsWith(data.getCommandArgs()[6].toLowerCase())).forEach(x -> strings.add(x.name().toLowerCase()));
                    }
                }
                if (data.getCommandArgs().length >= 7 && (data.getCommandArgs()[5].equalsIgnoreCase("firstsentence") || data.getCommandArgs()[5].equalsIgnoreCase("secondsentence")) && (lastArgument = data.getCommandArgs()[data.getCommandArgs().length - 1]).contains("{") && !(placeholder = lastArgument.substring(lastArgument.lastIndexOf(123))).contains("}")) {
                    strings.addAll(NPC.Placeholders.getSuggestedPlaceholders().stream().map(x -> NPC.Placeholders.formatBrackets(x)).filter(x -> x.startsWith(placeholder)).collect(Collectors.toList()));
                }
            }
            if (data.getCommandArgs().length >= 4 && add) {
                if (data.getArgs()[4].contains("_message") || data.getArgs()[4].contains("_command")) {
                    NPC.Placeholders.getSuggestedPlaceholders().stream().filter(x -> ("{" + x + "}").startsWith(data.getArgs()[data.getArgs().length - 1].toLowerCase())).forEach(x -> strings.add("{" + x + "}"));
                } else if (data.getArgs()[4].equalsIgnoreCase(NPC.Interact.Actions.Type.PLAYER_CONNECT_BUNGEE_SERVER.name())) {
                    if (data.getArgs().length == 6) {
                        if (IntegrationsManager.getBungeeCord().isDisconnected()) {
                            strings.add("\u00a7c\u00a7nThis server is not connected to a BungeeCord");
                            return strings;
                        }
                        Optional<BungeeCord.SubChannel.GetServers.Result> result = IntegrationsManager.getBungeeCord().subChannelGetServers().grabServers();
                        question = "\u00a76\u00a7nWhich server should the player connect to?";
                        if (data.getArgs()[5].length() == 0) {
                            strings.add("(server)");
                        }
                        if (result.isPresent()) {
                            List values = Arrays.stream(result.get().list()).filter(x -> !x.equals(IntegrationsManager.getBungeeCord().subChannelGetServer().grabServerName().get().server()) && x.toLowerCase().startsWith(data.getArgs()[5])).collect(Collectors.toList());
                            strings.addAll(values);
                            if (strings.size() > 1 || values.size() == 0 && data.getArgs()[5].length() == 0) {
                                strings.add(question);
                                IntegrationsManager.getBungeeCord().subChannelGetServer().grabServerName().ifPresent(x -> strings.add("\u00a78You are currently at " + x.server() + " server"));
                            }
                        } else if (data.getArgs()[5].length() == 0) {
                            strings.add(question);
                        }
                    }
                } else if (data.getArgs()[4].equalsIgnoreCase(NPC.Interact.Actions.Type.NPC_PLAY_ANIMATION.name())) {
                    if (data.getArgs().length == 6) {
                        Arrays.stream(NPC.Animation.values()).filter(x -> x.name().toLowerCase().startsWith(data.getArgs()[5])).forEach(x -> strings.add(x.name().toLowerCase()));
                    }
                } else if (data.getArgs()[4].equalsIgnoreCase(NPC.Interact.Actions.Type.PLAYER_PLAY_SOUND.name())) {
                    if (data.getArgs().length == 6) {
                        Arrays.stream(Sound.values()).filter(x -> x.name().toLowerCase().startsWith(data.getArgs()[5].toLowerCase())).forEach(x -> strings.add(x.name().toLowerCase()));
                    }
                } else if (data.getArgs()[4].equalsIgnoreCase(NPC.Interact.Actions.Type.NPC_SET_CUSTOM_DATA.name())) {
                    if (data.getArgs().length == 6) {
                        data.getGlobal().getCustomDataKeys().stream().filter(x -> x.startsWith(data.getArgs()[5])).forEach(x -> strings.add(x));
                    }
                    if (data.getArgs().length == 7 && data.getGlobal().hasCustomData(data.getArgs()[5]) && data.getGlobal().grabCustomData(data.getArgs()[5]).get().startsWith(data.getArgs()[6])) {
                        strings.add(data.getGlobal().grabCustomData(data.getArgs()[5]).get());
                    }
                    if (data.getArgs().length == 6 || data.getArgs().length == 7) {
                        NPC.Placeholders.getSuggestedPlaceholders().stream().filter(x -> ("{" + x + "}").startsWith(data.getArgs()[data.getArgs().length - 1].toLowerCase())).forEach(x -> strings.add("{" + x + "}"));
                    }
                } else if (data.getArgs()[4].equalsIgnoreCase(NPC.Interact.Actions.Type.PLAYER_TELEPORT_TO_LOCATION.name())) {
                    if (data.getArgs().length == 6) {
                        Bukkit.getWorlds().stream().filter(x -> x.getName().toLowerCase().startsWith(data.getArgs()[5].toLowerCase())).forEach(x -> strings.add(x.getName().toLowerCase()));
                        if (data.getPlayerSender() != null && "here".startsWith(data.getArgs()[5].toLowerCase())) {
                            strings.add("here");
                        }
                    }
                    if (data.getArgs().length > 6 && data.getArgs()[5].equalsIgnoreCase("here")) {
                        return strings;
                    }
                    if (data.getArgs().length == 7) {
                        Arrays.asList("" + (Serializable)(data.getPlayerSender() != null ? Integer.valueOf(data.getPlayerSender().getLocation().getBlockX()) : "0")).stream().filter(x -> x.toLowerCase().startsWith(data.getArgs()[6].toLowerCase())).forEach(x -> strings.add(x.toLowerCase()));
                    }
                    if (data.getArgs().length == 8) {
                        Arrays.asList("" + (Serializable)(data.getPlayerSender() != null ? Integer.valueOf(data.getPlayerSender().getLocation().getBlockY()) : "0")).stream().filter(x -> x.toLowerCase().startsWith(data.getArgs()[7].toLowerCase())).forEach(x -> strings.add(x.toLowerCase()));
                    }
                    if (data.getArgs().length == 9) {
                        Arrays.asList("" + (Serializable)(data.getPlayerSender() != null ? Integer.valueOf(data.getPlayerSender().getLocation().getBlockZ()) : "0")).stream().filter(x -> x.toLowerCase().startsWith(data.getArgs()[8].toLowerCase())).forEach(x -> strings.add(x.toLowerCase()));
                    }
                }
            }
            return strings;
        });
    }

    private static void printActionPage(NPCGlobalCommand.Command command, NPCGlobalCommand.CommandData data, NPC.Interact.ClickAction selectedAction, Integer actionID) {
        if (data.getPlayerSender() == null) {
            CommandUtils.error(data.commandSender, "You can only see the action information if you are a player.");
            return;
        }
        Player player = data.getPlayerSender();
        NPC.Interact.Actions.Type actionType = selectedAction.getActionType();
        String ce = "\u00a7e\u270e";
        String cs = "\u00a7eClick to suggest command";
        boolean left = selectedAction.getClickType().equals((Object)NPC.Interact.ClickType.LEFT_CLICK);
        boolean either = selectedAction.getClickType().equals((Object)NPC.Interact.ClickType.EITHER);
        boolean right = selectedAction.getClickType().equals((Object)NPC.Interact.ClickType.RIGHT_CLICK);
        for (int i = 0; i < 100; ++i) {
            data.getCommandSender().sendMessage("");
        }
        String clickActionHover = "\u00a76\u00a7lGlobal NPC " + data.getGlobal().getFullID() + " Click Actions";
        for (int i = 1; i <= data.getGlobal().getClickActionsSize(); ++i) {
            NPC.Interact.ClickAction iAction = data.getGlobal().getClickActions().get(i - 1);
            boolean selected = iAction.equals(selectedAction);
            clickActionHover = clickActionHover + "\n" + (selected ? "\u00a7a" : "\u00a78") + StringUtils.getNumberSymbol(i) + " " + (selected ? "\u00a7e" : "\u00a78") + StringUtils.getFirstCharUpperCase(iAction.getActionType().name().replaceAll("_", " "), true) + " " + (iAction.isEnabled() ? (selected ? "\u00a7a" : "\u00a78") + "(" + StringUtils.getFirstCharUpperCase(iAction.getClickType().name().split("_", 2)[0], true) + ")" + (String)(iAction.getDelayTicks() > 0L ? " " + (selected ? "\u00a77" : "\u00a78") + "(" + iAction.getDelayTicks() + " ticks delay)" : "") : (selected ? "\u00a7c" : "\u00a78") + "(Disabled)");
        }
        ClickableText commandTitle = new ClickableText(" ");
        commandTitle.add(actionID > 1 ? " \u00a7e\u25c0" : "\u00a78", actionID > 1 ? "\u00a7eClick to go to previous action." : "", actionID > 1, ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + (actionID - 1)));
        commandTitle.add(" ");
        commandTitle.add("\u00a76\u00a7l\u00a7nInformation about ClickAction #" + actionID, clickActionHover);
        commandTitle.add("\u00a7r ");
        commandTitle.add(data.getGlobal().getClickActions().size() > actionID ? "\u00a7e\u25b6" : "\u00a78", data.getGlobal().getClickActions().size() > actionID ? "\u00a7eClick to go to next action." : "", data.getGlobal().getClickActions().size() > actionID, ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + (actionID + 1)));
        commandTitle.send(player);
        data.getCommandSender().sendMessage("");
        Object hoverType = "\u00a7e\u00a7lClick action type";
        for (NPC.Interact.Actions.Type type : NPC.Interact.Actions.Type.values()) {
            if (type.isDeprecated() && !NPCLib.getInstance().isDebug()) continue;
            Optional<String> requiredDependency = type.getRequiredDependency();
            hoverType = (String)hoverType + "\n" + (actionType.equals(type) ? "\u00a7a\u25cf \u00a77" : "\u00a78  ") + (requiredDependency.isPresent() || type.isDeprecated() || type.equals(NPC.Interact.Actions.Type.CUSTOM_ACTION) && !actionType.equals(type) ? "\u00a7m" : "") + type.getName() + (type.equals(NPC.Interact.Actions.Type.CUSTOM_ACTION) ? "\u00a78 (Only through PlayerNPC API)" : "") + (String)(requiredDependency.isPresent() ? "\u00a78 (Requires " + requiredDependency.get() + ")" : "") + (type.isDeprecated() ? "\u00a78 (Not available)" : "");
        }
        ActionCommand.newButton("NPC").add("\u00a77" + selectedAction.getNPC().getID().getFullID(), "\u00a7e\u00a7lNPC Identification\n\u00a7eID: \u00a77" + selectedAction.getNPC().getID().getFullID() + "\n\u00a7eSimple ID: \u00a77" + selectedAction.getNPC().getID().getSimpleID() + "\n\n\u00a7eClick to teleport to the NPC.", ClickEvent.Action.RUN_COMMAND, "/npcglobal goto " + data.global.getID().getFullID()).send(player);
        ActionCommand.newButton("Type").add("\u00a77" + selectedAction.getActionType().getName(), (String)hoverType).send(player);
        ActionCommand.newButton("Click type").add((left ? "\u00a7a" : "\u00a78") + "(Left)", !left ? "\u00a7eClick to set click type as left." : "", !left, ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " clicktype left -modifyMenu")).add(" ").add((either ? "\u00a7a" : "\u00a78") + "(Either)", !either ? "\u00a7eClick to set click type as either." : "", !either, ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " clicktype either -modifyMenu")).add(" ").add((right ? "\u00a7a" : "\u00a78") + "(Right)", !right ? "\u00a7eClick to set click type as right." : "", !right, ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " clicktype right -modifyMenu")).send(player);
        ActionCommand.newButton("Enabled").add(selectedAction.isEnabled() ? "\u00a7a\u2611" : "\u00a77\u2610", "\u00a7eClick to " + (selectedAction.isEnabled() ? "disable" : "enable") + ".", ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " enabled " + !selectedAction.isEnabled() + " -modifyMenu")).send(player);
        ActionCommand.newButton("Delay").add("\u00a77" + selectedAction.getDelayTicks() + " ticks", CommandUtils.getTimeConversionTicksToSeconds(selectedAction.getDelayTicks())).add(" ").add(ce, cs, ClickEvent.Action.SUGGEST_COMMAND, command.getCommand(data.global, "modify " + actionID + " delay ")).send(player);
        ActionCommand.newButton("Cooldown").add("\u00a77" + MathUtils.getFormat(selectedAction.getCooldownMilliseconds().longValue()) + " ms", CommandUtils.getTimeConversionMillisecondsToSeconds(selectedAction.getCooldownMilliseconds())).add(" ").add(ce, cs, ClickEvent.Action.SUGGEST_COMMAND, command.getCommand(data.global, "modify " + actionID + " cooldown ")).send(player);
        switch (actionType) {
            case PLAYER_SEND_ACTIONBAR_MESSAGE: {
                NPC.Interact.ClickAction castedAction = (NPC.Interact.Actions.Player.SendActionBarMessage)selectedAction;
                ActionCommand.newButton("Message").add(!((NPC.Interact.Actions.Player.SendActionBarMessage)castedAction).getMessage().equals("") ? "\u00a7aHover to see" : "\u00a7cNone", TextComponent.fromLegacyText((String)(!((NPC.Interact.Actions.Player.SendActionBarMessage)castedAction).getMessage().equals("") ? ColorUtils.formatColor(((NPC.Interact.Actions.Player.SendActionBarMessage)castedAction).getMessage()) : ""))).send(player);
                break;
            }
            case PLAYER_SEND_CHAT_MESSAGE: {
                NPC.Interact.ClickAction castedAction = (NPC.Interact.Actions.Player.SendChatMessage)selectedAction;
                if (((NPC.Interact.Actions.Player.SendChatMessage)castedAction).getMessages().length == 1) {
                    ActionCommand.newButton("Message").add(!((NPC.Interact.Actions.Player.SendChatMessage)castedAction).getMessages()[0].equals("") ? "\u00a7aHover to see" : "\u00a7cNone", TextComponent.fromLegacyText((String)(!((NPC.Interact.Actions.Player.SendChatMessage)castedAction).getMessages()[0].equals("") ? ColorUtils.formatColor(((NPC.Interact.Actions.Player.SendChatMessage)castedAction).getMessages()[0]) : ""))).send(player);
                }
                if (((NPC.Interact.Actions.Player.SendChatMessage)castedAction).getMessages().length <= 1) break;
                for (int i = 0; i < ((NPC.Interact.Actions.Player.SendChatMessage)castedAction).getMessages().length; ++i) {
                    ActionCommand.newButton("Message " + (i + 1)).add(!((NPC.Interact.Actions.Player.SendChatMessage)castedAction).getMessages()[i].equals("") ? "\u00a7aHover to see" : "\u00a7cNone", TextComponent.fromLegacyText((String)(!((NPC.Interact.Actions.Player.SendChatMessage)castedAction).getMessages()[i].equals("") ? ColorUtils.formatColor(((NPC.Interact.Actions.Player.SendChatMessage)castedAction).getMessages()[i]) : ""))).send(player);
                }
                break;
            }
            case PLAYER_TELEPORT_TO_LOCATION: {
                NPC.Interact.ClickAction castedAction = (NPC.Interact.Actions.Player.TeleportToLocation)selectedAction;
                ActionCommand.newButton("Location").add("\u00a77" + ((NPC.Interact.Actions.Player.TeleportToLocation)castedAction).getLocation().getWorld().getName() + ", " + MathUtils.getFormat(((NPC.Interact.Actions.Player.TeleportToLocation)castedAction).getLocation().getX(), 1) + ", " + MathUtils.getFormat(((NPC.Interact.Actions.Player.TeleportToLocation)castedAction).getLocation().getY(), 1) + ", " + MathUtils.getFormat(((NPC.Interact.Actions.Player.TeleportToLocation)castedAction).getLocation().getZ(), 1) + ", " + MathUtils.getFormat(((NPC.Interact.Actions.Player.TeleportToLocation)castedAction).getLocation().getYaw(), 1) + ", " + MathUtils.getFormat(((NPC.Interact.Actions.Player.TeleportToLocation)castedAction).getLocation().getPitch(), 1), "\u00a7eClick to teleport to the location", ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " teleport")).send(player);
                break;
            }
            case PLAYER_SEND_TITLE_MESSAGE: {
                NPC.Interact.ClickAction castedAction = (NPC.Interact.Actions.Player.SendTitleMessage)selectedAction;
                ActionCommand.newButton("Title").add(!((NPC.Interact.Actions.Player.SendTitleMessage)castedAction).getTitle().equals("") ? "\u00a7aHover to see" : "\u00a7cNone", TextComponent.fromLegacyText((String)(!((NPC.Interact.Actions.Player.SendTitleMessage)castedAction).getTitle().equals("") ? ColorUtils.formatColor(((NPC.Interact.Actions.Player.SendTitleMessage)castedAction).getTitle()) : ""))).add(" ").add(ce, cs, ClickEvent.Action.SUGGEST_COMMAND, command.getCommand(data.global, "modify " + actionID + " title ")).send(player);
                ActionCommand.newButton("Subtitle").add(!((NPC.Interact.Actions.Player.SendTitleMessage)castedAction).getSubtitle().equals("") ? "\u00a7aHover to see" : "\u00a7cNone", TextComponent.fromLegacyText((String)(!((NPC.Interact.Actions.Player.SendTitleMessage)castedAction).getSubtitle().equals("") ? ColorUtils.formatColor(((NPC.Interact.Actions.Player.SendTitleMessage)castedAction).getSubtitle()) : ""))).add(" ").add(ce, cs, ClickEvent.Action.SUGGEST_COMMAND, command.getCommand(data.global, "modify " + actionID + " subtitle ")).send(player);
                ActionCommand.newButton("Fade in").add("\u00a77" + ((NPC.Interact.Actions.Player.SendTitleMessage)castedAction).getFadeIn() + " ticks", CommandUtils.getTimeConversionTicksToSeconds(((NPC.Interact.Actions.Player.SendTitleMessage)castedAction).getFadeIn().intValue())).add(" ").add(ce, cs, ClickEvent.Action.SUGGEST_COMMAND, command.getCommand(data.global, "modify " + actionID + " fadeIn ")).send(player);
                ActionCommand.newButton("Stay").add("\u00a77" + ((NPC.Interact.Actions.Player.SendTitleMessage)castedAction).getStay() + " ticks", CommandUtils.getTimeConversionTicksToSeconds(((NPC.Interact.Actions.Player.SendTitleMessage)castedAction).getStay().intValue())).add(" ").add(ce, cs, ClickEvent.Action.SUGGEST_COMMAND, command.getCommand(data.global, "modify " + actionID + " stay ")).send(player);
                ActionCommand.newButton("Fade out").add("\u00a77" + ((NPC.Interact.Actions.Player.SendTitleMessage)castedAction).getFadeOut() + " ticks", CommandUtils.getTimeConversionTicksToSeconds(((NPC.Interact.Actions.Player.SendTitleMessage)castedAction).getFadeOut().intValue())).add(" ").add(ce, cs, ClickEvent.Action.SUGGEST_COMMAND, command.getCommand(data.global, "modify " + actionID + " fadeOut ")).send(player);
                break;
            }
            case PLAYER_OPEN_BOOK: {
                ActionCommand.newButton("Book").add((selectedAction.isEnabled() ? "\u00a7a" : "\u00a78") + "(Click to see)", "", selectedAction.isEnabled(), ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " -test")).send(player);
                break;
            }
            case PLAYER_CONNECT_BUNGEE_SERVER: {
                NPC.Interact.ClickAction castedAction = (NPC.Interact.Actions.Player.ConnectBungeeServer)selectedAction;
                Object hover = null;
                if (IntegrationsManager.getBungeeCord().isConnected()) {
                    hover = "\u00a7e\u00a7lServers";
                    for (String servers : IntegrationsManager.getBungeeCord().subChannelGetServers().grabServers().get().list()) {
                        hover = (String)hover + "\n" + (((NPC.Interact.Actions.Player.ConnectBungeeServer)castedAction).getServer().equalsIgnoreCase(servers) ? "\u00a7a\u25cf \u00a77" : "\u00a78  ") + servers + (IntegrationsManager.getBungeeCord().subChannelGetServer().grabServerName().get().server().equalsIgnoreCase(servers) ? " \u00a78(You are here)" : "");
                    }
                }
                ActionCommand.newButton("Server").add("\u00a77" + ((NPC.Interact.Actions.Player.ConnectBungeeServer)castedAction).getServer(), (String)hover).send(player);
                break;
            }
            case NPC_SET_CUSTOM_DATA: {
                NPC.Interact.ClickAction castedAction = (NPC.Interact.Actions.SetCustomData)selectedAction;
                ActionCommand.newButton("Key").add("\u00a7f" + NPCLib.Registry.ID.of(((NPC.Interact.Actions.SetCustomData)castedAction).getPluginKey(), ((NPC.Interact.Actions.SetCustomData)castedAction).getSimpleKey())).send(player);
                ActionCommand.newButton("Value").add("\u00a7f" + ((NPC.Interact.Actions.SetCustomData)castedAction).getValue()).send(player);
                break;
            }
            case NPC_PLAY_ANIMATION: {
                NPC.Interact.ClickAction castedAction = (NPC.Interact.Actions.PlayAnimation)selectedAction;
                Object hoverAnimation = "\u00a7e\u00a7lAnimation";
                for (NPC.Animation type : NPC.Animation.values()) {
                    if (type.isDeprecated()) continue;
                    hoverAnimation = (String)hoverAnimation + "\n" + (((NPC.Interact.Actions.PlayAnimation)castedAction).getAnimation().equals(type) ? "\u00a7a\u25cf \u00a77" : "\u00a78  ") + type.getName();
                }
                ActionCommand.newButton("Animation").add("\u00a77" + ((NPC.Interact.Actions.PlayAnimation)castedAction).getAnimation().getName(), (String)hoverAnimation).send(player);
                break;
            }
            case PLAYER_GIVE_MONEY: 
            case PLAYER_WITHDRAW_MONEY: {
                NPC.Interact.ClickAction castedAction = (NPC.Interact.Actions.Money)selectedAction;
                ActionCommand.newButton("Balance").add("\u00a77" + ((NPC.Interact.Actions.Money)castedAction).getBalance()).send(player);
                break;
            }
            case CONSOLE_PERFORM_COMMAND: 
            case PLAYER_PERFORM_COMMAND: {
                NPC.Interact.ClickAction castedAction = (NPC.Interact.Actions.Command)selectedAction;
                ActionCommand.newButton("Command").add(!((NPC.Interact.Actions.Command)castedAction).getCommand().equals("") ? "\u00a7aHover to see" : "\u00a7cNone", !((NPC.Interact.Actions.Command)castedAction).getCommand().equals("") ? ((NPC.Interact.Actions.Command)castedAction).getCommand() : "").send(player);
                break;
            }
            case PLAYER_GIVE_ITEM: {
                NPC.Interact.ClickAction castedAction = (NPC.Interact.Actions.Player.GiveItem)selectedAction;
                ClickableText clickableText = ActionCommand.newButton("Item");
                if (((NPC.Interact.Actions.Player.GiveItem)castedAction).getItemStack() != null && !((NPC.Interact.Actions.Player.GiveItem)castedAction).getItemStack().getType().isAir()) {
                    HoverEvent he = new HoverEvent(HoverEvent.Action.SHOW_ITEM, new BaseComponent[]{new TextComponent(NMSCraftItemStack.asNMSCopy(((NPC.Interact.Actions.Player.GiveItem)castedAction).getItemStack()).toString())});
                    clickableText.add(ClickableText.get("\u00a77" + EnumUtils.NameFormat.FIRST_UPPER_CASE_WITH_SPACES.format(((NPC.Interact.Actions.Player.GiveItem)castedAction).getItemStack().getType()) + " \u00a78x" + ((NPC.Interact.Actions.Player.GiveItem)castedAction).getItemStack().getAmount(), he, null));
                } else {
                    clickableText.add("\u00a7cNone");
                }
                clickableText.send(player);
                break;
            }
        }
        ActionCommand.newButton("Conditions").add("\u00a77" + selectedAction.getConditions().size() + " ").add("\u00a7a(Add condition)", cs, ClickEvent.Action.SUGGEST_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition add ")).send(player);
        int conditionID = 0;
        for (NPC.Conditions.Condition condition : selectedAction.getConditions()) {
            ++conditionID;
            Object titleHover = "";
            switch (condition.getType()) {
                case PLAYER_HAS_PERMISSION: {
                    NPC.Conditions.Player.Permission castedCondition = (NPC.Conditions.Player.Permission)condition;
                    titleHover = (castedCondition.isLogicNegative() != false ? "\u00a7cDoes not have " : "") + "\u00a7ePermission: \u00a77" + castedCondition.getPermission();
                    break;
                }
                case PLAYER_HAS_BALANCE: {
                    NPC.Conditions.Player.Balance castedCondition = (NPC.Conditions.Player.Balance)condition;
                    titleHover = (castedCondition.isLogicNegative() != false ? "\u00a7cDoes not have " : "") + "\u00a7eBalance: \u00a77" + castedCondition.getBalance();
                    break;
                }
                case COMPARATOR_SENTENCE: {
                    NPC.Conditions.Comparator.Sentence castedCondition = (NPC.Conditions.Comparator.Sentence)condition;
                    titleHover = (String)(!castedCondition.getFirst().equals("") ? "\u00a77" + castedCondition.getFirst() : "\u00a7cNone") + " " + (castedCondition.isLogicNegative() != false ? "\u00a7cnot " : "") + "\u00a7e" + castedCondition.getLogic().name().toLowerCase().replaceAll("_", " ") + " " + (String)(!castedCondition.getSecond().equals("") ? "\u00a77" + castedCondition.getSecond() : "\u00a7cNone");
                }
            }
            String requiredDependency = condition.getType().getRequiredDependency();
            TextComponent IDenabledButton = ClickableText.get((condition.isEnabled() != false && requiredDependency == null ? "\u00a7a" : "\u00a77") + StringUtils.getNumberSymbol(conditionID), new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(requiredDependency != null ? "\u00a7cThis condition requires " + requiredDependency : "\u00a7eClick to " + (condition.isEnabled() != false ? "disable" : "enable") + " condition")}), requiredDependency != null ? null : new ClickEvent(ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + conditionID + " enabled " + (condition.isEnabled() == false) + " -modifyActionMenu")));
            TextComponent ModifyButton = ClickableText.get("\u00a76(Modify)", new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("\u00a7eClick to modify condition.")}), new ClickEvent(ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + conditionID)));
            TextComponent RemoveButton = ClickableText.get("\u00a7c(Remove)", new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("\u00a7eClick to remove condition.")}), new ClickEvent(ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition remove " + conditionID + " -modifyActionMenu")));
            TextComponent TitleButton = ClickableText.get("\u00a7e" + StringUtils.getFirstCharUpperCase(condition.getType().name().replaceAll("_", " "), true), new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text((String)titleHover)}), null);
            new ClickableText("    ").add(IDenabledButton).add(" ").add(TitleButton).add(" ").add(ModifyButton).add(" ").add(RemoveButton).send(player);
        }
        data.getCommandSender().sendMessage("");
        new ClickableText("  ").add("\u00a7a\u00a7l[ADD ACTION]", "\u00a7a\u00a7lAdd action\n\u00a77This will add a new click action to the NPC.\n\n\u00a7eClick to suggest command.", ClickEvent.Action.SUGGEST_COMMAND, command.getCommand(data.global, "add ")).add("  ").add((selectedAction.isEnabled() ? "\u00a76" : "\u00a78") + "\u00a7l[TEST ACTION]", selectedAction.isEnabled() ? "\u00a76\u00a7lTest action\n\u00a77This will execute the action for you, and you will be able to test the action.\n\n\u00a7eClick to execute the action." : "\u00a7cAction must be enabled in order to test it.", command.isEnabled(), ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " -test")).add("  ").add("\u00a7c\u00a7l[REMOVE ACTION]", "\u00a7c\u00a7lRemove action\n\u00a77This will remove the specific click action from the NPC.\nBe careful, this action cannot be undone.\n\n\u00a7eClick to remove action.", ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "clear " + actionID)).send(player);
        data.getCommandSender().sendMessage("");
    }

    private static ClickableText newButton(String title) {
        return new ClickableText("  \u00a78\u2022 \u00a7e\u00a7l" + title + ": ");
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$new$0(NPCGlobalCommand.Command command, NPCGlobalCommand.CommandData data) {
        block171: {
            block172: {
                v0 = commandAction = data.getCommandArgs().length < 1 ? "modify" : data.getCommandArgs()[0].toLowerCase();
                if (!(commandAction.equals("add") || commandAction.equals("clear") || commandAction.equals("modify"))) {
                    CommandUtils.error(data.getCommandSender(), "Incorrect argument \"" + data.getCommandArgs()[0] + "\". Need to specify if add, clear or modify actions.");
                    return;
                }
                actionID = null;
                clickType = null;
                if (data.getCommandArgs().length > 1) {
                    if (MathUtils.isInteger(data.getCommandArgs()[1])) {
                        actionID = Integer.valueOf(data.getCommandArgs()[1]);
                    }
                    if (data.getCommandArgs()[1].equalsIgnoreCase("right")) {
                        clickType = NPC.Interact.ClickType.RIGHT_CLICK;
                    }
                    if (data.getCommandArgs()[1].equalsIgnoreCase("left")) {
                        clickType = NPC.Interact.ClickType.LEFT_CLICK;
                    }
                    if (data.getCommandArgs()[1].equalsIgnoreCase("both")) {
                        clickType = NPC.Interact.ClickType.EITHER;
                    }
                    if (clickType == null && (commandAction.equals("add") || commandAction.equals("clear") && actionID == null)) {
                        CommandUtils.error(data.getCommandSender(), "Incorrect argument \"" + data.getCommandArgs()[1] + "\". Click type can only be right, left or both.");
                        return;
                    }
                } else {
                    if (commandAction.equals("add")) {
                        CommandUtils.error(data.getCommandSender(), "Incorrect arguments, you need to specify right, left or both click.");
                        return;
                    }
                    if (commandAction.equals("modify")) {
                        actionID = 1;
                    } else if (commandAction.equals("clear")) {
                        data.getGlobal().resetClickActions();
                        data.getCommandSender().sendMessage(CommandUtils.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77click actions have been cleaned.");
                        return;
                    }
                }
                selectedAction = null;
                if (actionID != null) {
                    if (actionID <= 0) {
                        CommandUtils.error(data.getCommandSender(), "Specified click action id cannot be zero or negative.");
                        return;
                    }
                    actions = data.getGlobal().getClickActions();
                    if (data.getGlobal().getClickActions().size() < actionID || actions.get(actionID - 1) == null) {
                        CommandUtils.error(data.getCommandSender(), "There is no action with that id.");
                        return;
                    }
                    selectedAction = actions.get(actionID - 1);
                }
                if (commandAction.equals("modify")) {
                    actionType = selectedAction.getActionType();
                    if (data.getCommandArgs().length <= 2) {
                        ActionCommand.printActionPage(command, data, selectedAction, actionID);
                        return;
                    }
                    if (data.getCommandArgs()[2].equalsIgnoreCase("condition")) {
                        if (data.getCommandArgs()[3].equalsIgnoreCase("add")) {
                            type = NPC.Conditions.Type.valueOf(data.getCommandArgs()[4].toUpperCase());
                            if (type == null) {
                                CommandUtils.error(data.commandSender, "This condition type doesn't exists.");
                                return;
                            }
                            if (type.isDeprecated() && !NPCLib.getInstance().isDebug()) {
                                CommandUtils.error(data.commandSender, "This condition type is not available.");
                                return;
                            }
                            switch (1.$SwitchMap$dev$sergiferry$playernpc$api$NPC$Conditions$Type[type.ordinal()]) {
                                case 1: {
                                    if (data.getCommandArgs().length < 6) {
                                        CommandUtils.error(data.commandSender, "You must specify the permission.");
                                        return;
                                    }
                                    permission = new NPC.Conditions.Player.Permission(data.getCommandArgs()[5]);
                                    selectedAction.addCondition(permission);
                                    break;
                                }
                                case 2: {
                                    if (data.getCommandArgs().length < 6) {
                                        CommandUtils.error(data.commandSender, "You must specify the balance.");
                                        return;
                                    }
                                    balance = new NPC.Conditions.Player.Balance(Double.valueOf(data.getCommandArgs()[5]));
                                    selectedAction.addCondition(balance);
                                    break;
                                }
                                case 3: {
                                    sentence = new NPC.Conditions.Comparator.Sentence();
                                    selectedAction.addCondition(sentence);
                                }
                            }
                            Bukkit.dispatchCommand((CommandSender)data.commandSender, (String)command.getCommand(data.global, "modify " + actionID + " condition modify " + selectedAction.getConditions().size()).replaceFirst("/", ""));
                        }
                        if (data.getCommandArgs()[3].equalsIgnoreCase("remove")) {
                            id = Integer.valueOf(data.getCommandArgs()[4]);
                            selectedAction.getConditions().remove(id - 1);
                            if (data.getCommandArgs().length > 5 && data.getCommandArgs()[5].equalsIgnoreCase("-modifyActionMenu")) {
                                Bukkit.dispatchCommand((CommandSender)data.commandSender, (String)command.getCommand(data.global, "modify " + actionID).replaceFirst("/", ""));
                                return;
                            }
                            return;
                        }
                        if (data.getCommandArgs()[3].equalsIgnoreCase("modify")) {
                            conditionID = Integer.valueOf(data.getCommandArgs()[4]);
                            condition = selectedAction.getConditions().get(conditionID - 1);
                            if (data.getCommandArgs().length == 5) {
                                if (data.getPlayerSender() == null) {
                                    CommandUtils.error(data.commandSender, "You can only see the action information if you are a player.");
                                    return;
                                }
                                player = data.getPlayerSender();
                                ce = "\u00a7e\u270e";
                                cs = "\u00a7eClick to suggest command";
                                chatMessageTypeChat = condition.getErrorResponse().getChatMessageType().equals((Object)ChatMessageType.CHAT);
                                chatMessageTypeActionbar = condition.getErrorResponse().getChatMessageType().equals((Object)ChatMessageType.ACTION_BAR);
                                playSoundButton = new TextComponent("");
                                if (condition.getErrorResponse().getSound() != null) {
                                    playSoundButton.addExtra((BaseComponent)ClickableText.get("\u00a7a\u266b", new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("\u00a7eClick to play sound\n\n\u00a77Be aware that the sound will be played at the NPC location, if you are far from it, you won't hear it.")}), new ClickEvent(ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + conditionID + " playsound"))));
                                    playSoundButton.addExtra(" ");
                                }
                                hoverType = "\u00a7e\u00a7lCondition type";
                                for (NPC.Conditions.Comparator.Sentence.Logic[] type : NPC.Conditions.Type.values()) {
                                    if (type.isDeprecated() && !NPCLib.getInstance().isDebug()) continue;
                                    requiredDependency = type.getRequiredDependency();
                                    hoverType = (String)hoverType + "\n" + (condition.getType().equals(type) != false ? "\u00a7a\u25cf \u00a77" : "\u00a78  ") + (requiredDependency != null || type.isDeprecated() != false ? "\u00a7m" : "") + StringUtils.getFirstCharUpperCase(type.name().replaceAll("_", " "), true) + (String)(requiredDependency != null ? "\u00a78 (Requires " + requiredDependency + ")" : "") + (type.isDeprecated() != false ? "\u00a78 (Not available)" : "");
                                }
                                for (i = 0; i < 100; ++i) {
                                    data.getCommandSender().sendMessage("");
                                }
                                commandTitle = new ClickableText(" ");
                                commandTitle.add(conditionID > 1 ? " \u00a7e\u25c0" : "\u00a78", conditionID > 1 ? "\u00a7eClick to go to previous condition." : "", conditionID > 1, ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + (conditionID - 1)));
                                commandTitle.add(" ");
                                commandTitle.add("\u00a76\u00a7l\u00a7nInformation about Condition #" + conditionID);
                                commandTitle.add("\u00a7r ");
                                commandTitle.add(selectedAction.getConditions().size() > conditionID ? "\u00a7e\u25b6" : "\u00a78", selectedAction.getConditions().size() > conditionID ? "\u00a7eClick to go to next condition." : "", selectedAction.getConditions().size() > conditionID, ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + (conditionID + 1)));
                                commandTitle.send(player);
                                data.getCommandSender().sendMessage("");
                                new ClickableText("  \u00a78\u2022 \u00a7e\u00a7lType: \u00a77" + condition.getType().getName(), (String)hoverType).send(player);
                                if (!condition.getType().equals(NPC.Conditions.Type.COMPARATOR_SENTENCE)) {
                                    new ClickableText("  \u00a78\u2022 \u00a7e\u00a7lNegative logic: ").add(condition.isLogicNegative() != false ? "\u00a7a\u2611" : "\u00a77\u2610", "\u00a7eClick to " + (condition.isLogicNegative() != false ? "disable" : "enable") + ".", ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + conditionID + " logicnegative " + (condition.isLogicNegative() == false) + " -modifyMenu")).send(player);
                                }
                                switch (1.$SwitchMap$dev$sergiferry$playernpc$api$NPC$Conditions$Type[condition.getType().ordinal()]) {
                                    case 1: {
                                        castedCondition = (NPC.Conditions.Player.Permission)condition;
                                        new ClickableText("  \u00a78\u2022 \u00a7e\u00a7lPermission: \u00a77" + castedCondition.getPermission()).add(" ").add(ce, cs, ClickEvent.Action.SUGGEST_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + conditionID + " permission ")).send(player);
                                        break;
                                    }
                                    case 2: {
                                        castedCondition = (NPC.Conditions.Player.Balance)condition;
                                        new ClickableText("  \u00a78\u2022 \u00a7e\u00a7lBalance: \u00a77" + castedCondition.getBalance()).add(" ").add(ce, cs, ClickEvent.Action.SUGGEST_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + conditionID + " balance ")).send(player);
                                        break;
                                    }
                                    case 3: {
                                        castedCondition = (NPC.Conditions.Comparator.Sentence)condition;
                                        hoverLogic = "\u00a7e\u00a7lLogic type";
                                        for (NPC.Conditions.Comparator.Sentence.Logic type : NPC.Conditions.Comparator.Sentence.Logic.values()) {
                                            hoverLogic = (String)hoverLogic + "\n" + (castedCondition.getLogic().equals((Object)type) != false ? "\u00a7a\u25cf \u00a77" : "\u00a78  ") + StringUtils.getFirstCharUpperCase(type.name().replaceAll("_", " "), true);
                                        }
                                        logicButtonPositive = ClickableText.get((castedCondition.isLogicNegative() == false ? "\u00a7a" : "\u00a78") + "(Positive)", new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(castedCondition.isLogicNegative() != false ? "\u00a7eClick to set as positive" : "")}), castedCondition.isLogicNegative() != false ? new ClickEvent(ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + conditionID + " logicnegative false -modifyMenu")) : null);
                                        logicButtonNegative = ClickableText.get((castedCondition.isLogicNegative() != false ? "\u00a7c" : "\u00a78") + "(Negative)", new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(castedCondition.isLogicNegative() == false ? "\u00a7eClick to set as negative" : "")}), castedCondition.isLogicNegative() == false ? new ClickEvent(ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + conditionID + " logicnegative true -modifyMenu")) : null);
                                        new ClickableText("  \u00a78\u2022 \u00a7e\u00a7lFirst: ").add(castedCondition.getFirst().equals("") == false ? "\u00a7aHover to see" : "\u00a7cNone", (String)(castedCondition.getFirst().equals("") == false ? "\u00a7f" + castedCondition.getFirst() : "")).add(" ").add(ce, cs, ClickEvent.Action.SUGGEST_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + conditionID + " firstsentence ")).send(player);
                                        new ClickableText("  \u00a78\u2022 \u00a7e\u00a7lLogic: ").add("\u00a77" + StringUtils.getFirstCharUpperCase(castedCondition.getLogic().name().replaceAll("_", " "), true), (String)hoverLogic).add(" ").add(ce, cs, ClickEvent.Action.SUGGEST_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + conditionID + " sentencelogic ")).add(" ").add(logicButtonPositive).add(" ").add(logicButtonNegative).send(player);
                                        new ClickableText("  \u00a78\u2022 \u00a7e\u00a7lSecond: ").add(castedCondition.getSecond().equals("") == false ? "\u00a7aHover to see" : "\u00a7cNone", (String)(castedCondition.getSecond().equals("") == false ? "\u00a7f" + castedCondition.getSecond() : "")).add(" ").add(ce, cs, ClickEvent.Action.SUGGEST_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + conditionID + " secondsentence ")).send(player);
                                    }
                                }
                                requiredDependency = condition.getType().getRequiredDependency();
                                new ClickableText("  \u00a78\u2022 \u00a7e\u00a7lEnabled: ").add(condition.isEnabled() != false && requiredDependency == null ? "\u00a7a\u2611" : "\u00a77\u2610", (String)(requiredDependency != null ? "" : "\u00a7eClick to " + (condition.isEnabled() != false ? "disable" : "enable") + "."), requiredDependency == null, ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + conditionID + " enabled " + (condition.isEnabled() == false) + " -modifyMenu")).add((String)(requiredDependency != null ? " \u00a7c(Requires " + requiredDependency + ")" : "")).send(player);
                                data.getCommandSender().sendMessage("");
                                data.getCommandSender().sendMessage("  \u00a7c\u00a7lError Response");
                                new ClickableText("  \u00a78\u2022 \u00a7e\u00a7lMessage: ").add(condition.getErrorResponse().getErrorMessage() != null ? "\u00a7aHover to see" : "\u00a7cNone", condition.getErrorResponse().getErrorMessage() != null ? condition.getErrorResponse().getErrorMessage() : "").add(" ").add(ce, cs, ClickEvent.Action.SUGGEST_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + conditionID + " errormessage ")).send(player);
                                new ClickableText("  \u00a78\u2022 \u00a7e\u00a7lMessage type: ").add((chatMessageTypeChat != false ? "\u00a7a" : "\u00a78") + "(Chat)", chatMessageTypeChat == false ? "\u00a7eClick to set as chat" : "", chatMessageTypeChat == false, ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + conditionID + " chatmessagetype chat -modifyMenu")).add(" ").add((chatMessageTypeActionbar != false ? "\u00a7a" : "\u00a78") + "(ActionBar)", chatMessageTypeActionbar == false ? "\u00a7eClick to set as action bar" : "", chatMessageTypeActionbar == false, ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + conditionID + " chatmessagetype action_bar -modifyMenu")).send(player);
                                new ClickableText("  \u00a78\u2022 \u00a7e\u00a7lSound: ").add((String)(condition.getErrorResponse().getSound() != null ? "\u00a7a" + StringUtils.getFirstCharUpperCase(condition.getErrorResponse().getSound().name().replaceAll("_", " "), true) : "\u00a7cNone")).add(" ").add(playSoundButton).add(ce, cs, ClickEvent.Action.SUGGEST_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + conditionID + " sound ")).add(" ").add((condition.getErrorResponse().getSound() != null ? "\u00a7c" : "\u00a78") + "\u00a7l\u2718", condition.getErrorResponse().getSound() != null ? "\u00a7eClick to remove sound" : "", condition.getErrorResponse().getSound() != null, ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + conditionID + " removesound")).send(player);
                                new ClickableText("  \u00a78\u2022 \u00a7e\u00a7lSound volume: ").add((condition.getErrorResponse().getSoundVolume().floatValue() <= 0.1f ? "\u00a78" : "\u00a76") + "-", condition.getErrorResponse().getSoundVolume().floatValue() > 0.1f ? "\u00a7eClick to decrease volume" : "", ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + conditionID + " soundVolume decrease -modifyMenu")).add(" ").add("\u00a7a" + condition.getErrorResponse().getSoundVolume()).add(" ").add(((double)condition.getErrorResponse().getSoundVolume().floatValue() >= 1.0 ? "\u00a78" : "\u00a76") + "+", (double)condition.getErrorResponse().getSoundVolume().floatValue() < 1.0 ? "\u00a7eClick to increase volume" : "", ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + conditionID + " soundVolume increase -modifyMenu")).send(player);
                                new ClickableText("  \u00a78\u2022 \u00a7e\u00a7lSound pitch: ").add((condition.getErrorResponse().getSoundPitch().floatValue() <= 0.5f ? "\u00a78" : "\u00a76") + "-", condition.getErrorResponse().getSoundPitch().floatValue() > 0.5f ? "\u00a7eClick to decrease pitch" : "", ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + conditionID + " soundPitch decrease -modifyMenu")).add(" ").add("\u00a7a" + condition.getErrorResponse().getSoundPitch()).add(" ").add(((double)condition.getErrorResponse().getSoundPitch().floatValue() >= 2.0 ? "\u00a78" : "\u00a76") + "+", (double)condition.getErrorResponse().getSoundPitch().floatValue() < 2.0 ? "\u00a7eClick to increase pitch" : "", ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + conditionID + " soundPitch increase -modifyMenu")).send(player);
                                new ClickableText("  \u00a78\u2022 \u00a7e\u00a7lRed animation: ").add(condition.getErrorResponse().getPlayRedAnimation() != false ? "\u00a7a\u2611" : "\u00a77\u2610", "\u00a7eClick to " + (condition.getErrorResponse().getPlayRedAnimation() != false ? "disable" : "enable") + ".", ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition modify " + conditionID + " redanimation " + (condition.getErrorResponse().getPlayRedAnimation() == false) + " -modifyMenu")).send(player);
                                data.getCommandSender().sendMessage("");
                                new ClickableText("  ").add("\u00a76\u00a7l[\u25c0 BACK TO CLICK ACTION]", "\u00a7eClick to return to the click action menu.", ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID)).add("  ").add("\u00a7c\u00a7l[REMOVE CONDITION]", "\u00a7c\u00a7lRemove condition\n\u00a77This will remove the specific condition from the click action.\nBe careful, this action cannot be undone.\n\n\u00a7eClick to remove condition.", ClickEvent.Action.RUN_COMMAND, command.getCommand(data.global, "modify " + actionID + " condition remove " + conditionID + " -modifyActionMenu")).send(player);
                                data.getCommandSender().sendMessage("");
                                return;
                            }
                            openModifyConditionMenu = false;
                            openModifyActionMenu = false;
                            if (data.getCommandArgs()[5].equalsIgnoreCase("chatmessagetype")) {
                                chatMessageType = ChatMessageType.valueOf((String)data.getCommandArgs()[6].toUpperCase());
                                condition.getErrorResponse().setChatMessageType(chatMessageType);
                            }
                            if (data.getCommandArgs()[5].equalsIgnoreCase("soundVolume")) {
                                var = Float.valueOf(0.0f);
                                if (data.getCommandArgs()[6].equals("decrease")) {
                                    var = Float.valueOf(-0.1f);
                                }
                                if (data.getCommandArgs()[6].equals("increase")) {
                                    var = Float.valueOf(0.1f);
                                }
                                condition.getErrorResponse().setSoundVolume(Float.valueOf(condition.getErrorResponse().getSoundVolume().floatValue() + var.floatValue()));
                            }
                            if (data.getCommandArgs()[5].equalsIgnoreCase("soundPitch")) {
                                var = Float.valueOf(0.0f);
                                if (data.getCommandArgs()[6].equals("decrease")) {
                                    var = Float.valueOf(-0.1f);
                                }
                                if (data.getCommandArgs()[6].equals("increase")) {
                                    var = Float.valueOf(0.1f);
                                }
                                condition.getErrorResponse().setSoundPitch(Float.valueOf(condition.getErrorResponse().getSoundPitch().floatValue() + var.floatValue()));
                            }
                            if (data.getCommandArgs()[5].equalsIgnoreCase("sentencelogic")) {
                                logic = null;
                                try {
                                    logic = NPC.Conditions.Comparator.Sentence.Logic.valueOf(data.getCommandArgs()[6].toUpperCase());
                                }
                                catch (Exception chatMessageTypeChat) {
                                    // empty catch block
                                }
                                if (logic == null) {
                                    CommandUtils.error(data.commandSender, "This logic doesn't exists");
                                    return;
                                }
                                ((NPC.Conditions.Comparator.Sentence)condition).setLogic(logic);
                                openModifyConditionMenu = true;
                            }
                            if (data.getCommandArgs()[5].equalsIgnoreCase("firstsentence") || data.getCommandArgs()[5].equalsIgnoreCase("secondsentence")) {
                                castedCondition = (NPC.Conditions.Comparator.Sentence)condition;
                                msg = "";
                                for (i = 6; i < data.getCommandArgs().length; ++i) {
                                    msg = (String)msg + " " + data.getCommandArgs()[i];
                                }
                                msg = msg.replaceFirst(" ", "");
                                if (data.getCommandArgs()[5].equalsIgnoreCase("firstsentence")) {
                                    castedCondition.setFirst((String)msg);
                                }
                                if (data.getCommandArgs()[5].equalsIgnoreCase("secondsentence")) {
                                    castedCondition.setSecond((String)msg);
                                }
                                openModifyConditionMenu = true;
                            }
                            if (data.getCommandArgs()[5].equalsIgnoreCase("logicnegative")) {
                                b = Boolean.valueOf(data.getCommandArgs()[6]);
                                condition.setLogicNegative(b);
                            }
                            if (data.getCommandArgs()[5].equalsIgnoreCase("sound")) {
                                sound = null;
                                try {
                                    sound = Sound.valueOf((String)data.getCommandArgs()[6].toUpperCase());
                                }
                                catch (Exception msg) {
                                    // empty catch block
                                }
                                if (sound == null) {
                                    CommandUtils.error(data.commandSender, "This sound doesn't exists");
                                    return;
                                }
                                condition.getErrorResponse().setSound(sound);
                                openModifyConditionMenu = true;
                            }
                            if (data.getCommandArgs()[5].equalsIgnoreCase("balance")) {
                                balance = null;
                                try {
                                    balance = Double.valueOf(data.getCommandArgs()[6].toUpperCase());
                                }
                                catch (Exception msg) {
                                    // empty catch block
                                }
                                if (balance == null) {
                                    CommandUtils.error(data.commandSender, "This balance is not valid");
                                    return;
                                }
                                ((NPC.Conditions.Player.Balance)condition).setBalance(balance);
                                openModifyConditionMenu = true;
                            }
                            if (data.getCommandArgs()[5].equalsIgnoreCase("playsound")) {
                                data.getPlayerSender().playSound(data.global.getLocation(), condition.getErrorResponse().getSound(), condition.getErrorResponse().getSoundVolume().floatValue(), condition.getErrorResponse().getSoundPitch().floatValue());
                            }
                            if (data.getCommandArgs()[5].equalsIgnoreCase("removesound")) {
                                condition.getErrorResponse().setSound(null);
                                openModifyConditionMenu = true;
                            }
                            if (data.getCommandArgs()[5].equalsIgnoreCase("errormessage")) {
                                msg = "";
                                for (i = 6; i < data.getCommandArgs().length; ++i) {
                                    msg = (String)msg + " " + data.getCommandArgs()[i];
                                }
                                msg = msg.replaceFirst(" ", "");
                                msg = ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
                                condition.getErrorResponse().setMessage((String)msg);
                                openModifyConditionMenu = true;
                            }
                            if (data.getCommandArgs()[5].equalsIgnoreCase("permission")) {
                                permission = data.getCommandArgs()[6];
                                ((NPC.Conditions.Player.Permission)condition).setPermission(permission);
                                openModifyConditionMenu = true;
                            }
                            if (data.getCommandArgs()[5].equalsIgnoreCase("redanimation")) {
                                b = Boolean.valueOf(data.getCommandArgs()[6]);
                                condition.getErrorResponse().setPlayRedAnimation(b);
                            }
                            if (data.getCommandArgs()[5].equalsIgnoreCase("enabled")) {
                                b = Boolean.valueOf(data.getCommandArgs()[6]);
                                condition.setEnabled(b);
                            }
                            if ((lastArgument = data.getCommandArgs()[data.getCommandArgs().length - 1]).equals("-modifyActionMenu")) {
                                openModifyActionMenu = true;
                            }
                            if (lastArgument.equals("-modifyMenu")) {
                                openModifyConditionMenu = true;
                            }
                            if (openModifyActionMenu) {
                                Bukkit.dispatchCommand((CommandSender)data.commandSender, (String)command.getCommand(data.global, "modify " + actionID).replaceFirst("/", ""));
                            }
                            if (openModifyConditionMenu) {
                                Bukkit.dispatchCommand((CommandSender)data.commandSender, (String)command.getCommand(data.global, "modify " + actionID + " condition modify " + conditionID).replaceFirst("/", ""));
                            }
                        }
                    }
                    if (data.getCommandArgs()[2].equalsIgnoreCase("-test")) {
                        if (data.getPlayerSender() == null) {
                            CommandUtils.error(data.commandSender, "You can only execute the action if you are a player.");
                            return;
                        }
                        try {
                            executeMethod = NPC.Interact.class.getDeclaredMethod("test", new Class[]{NPC.Interact.ClickAction.class, Player.class});
                            executeMethod.setAccessible(true);
                            executeMethod.invoke(null, new Object[]{selectedAction, data.getPlayerSender()});
                            executeMethod.setAccessible(false);
                        }
                        catch (Exception e) {
                            CommandUtils.error(data.commandSender, "Error " + e.getMessage());
                            e.printStackTrace();
                        }
                        return;
                    }
                    if (data.getCommandArgs()[2].equalsIgnoreCase("enabled")) {
                        if (data.getCommandArgs().length < 4) {
                            CommandUtils.error(data.commandSender, "You need to specify if it's true or false");
                            return;
                        }
                        bo = Boolean.valueOf(data.getCommandArgs()[3]);
                        selectedAction.setEnabled(bo);
                        if (data.getCommandArgs().length > 4 && data.getCommandArgs()[4].equals("-modifyMenu")) {
                            Bukkit.dispatchCommand((CommandSender)data.commandSender, (String)command.getCommand(data.global, "modify " + actionID).replaceFirst("/", ""));
                        } else {
                            CommandUtils.sendMessage(data.commandSender, "Click action with id \u00a7e" + actionID + " \u00a77for Global NPC \u00a7a" + data.global.getID().getFullID() + " \u00a77has been " + (selectedAction.isEnabled() != false ? "\u00a7aenabled" : "\u00a7cdisabled"));
                        }
                    }
                    if (data.getCommandArgs()[2].equalsIgnoreCase("clicktype")) {
                        type = null;
                        if (data.getCommandArgs().length >= 4) {
                            if (data.getCommandArgs()[3].equalsIgnoreCase("left")) {
                                type = NPC.Interact.ClickType.LEFT_CLICK;
                            }
                            if (data.getCommandArgs()[3].equalsIgnoreCase("either")) {
                                type = NPC.Interact.ClickType.EITHER;
                            }
                            if (data.getCommandArgs()[3].equalsIgnoreCase("right")) {
                                type = NPC.Interact.ClickType.RIGHT_CLICK;
                            }
                        }
                        if (type == null) {
                            CommandUtils.error(data.commandSender, "You need to specify left, either or right");
                            return;
                        }
                        selectedAction.setClickType((NPC.Interact.ClickType)type);
                        if (data.getCommandArgs().length > 4 && data.getCommandArgs()[4].equals("-modifyMenu")) {
                            Bukkit.dispatchCommand((CommandSender)data.commandSender, (String)command.getCommand(data.global, "modify " + actionID).replaceFirst("/", ""));
                        } else {
                            CommandUtils.sendMessage(data.commandSender, "Click action with id \u00a7e" + actionID + " \u00a77for Global NPC \u00a7a" + data.global.getID().getFullID() + " \u00a77has been set click type as \u00a7e" + StringUtils.getFirstCharUpperCase(clickType.name().replaceAll("_", " "), true));
                        }
                    }
                    cooldown = data.getCommandArgs()[2].equalsIgnoreCase("cooldown");
                    delay = data.getCommandArgs()[2].equalsIgnoreCase("delay");
                    if (cooldown || delay) {
                        if (data.getCommandArgs().length < 4 || !MathUtils.isInteger(data.getCommandArgs()[3])) {
                            CommandUtils.error(data.commandSender, "No amount of " + (cooldown != false ? "milliseconds" : "ticks") + " specified.");
                            return;
                        }
                        ticks = Integer.valueOf(data.getCommandArgs()[3]).longValue();
                        if (ticks < 0L) {
                            ticks = 0L;
                        }
                        if (cooldown && ticks < data.global.getInteractCooldown()) {
                            ticks = data.global.getInteractCooldown();
                        }
                        if (cooldown) {
                            selectedAction.setCooldownMilliseconds(ticks);
                        }
                        if (delay) {
                            selectedAction.setDelayTicks(ticks);
                        }
                        CommandUtils.sendMessage(data.commandSender, "Click action with id \u00a7e" + actionID + " \u00a77for Global NPC \u00a7a" + data.global.getID().getFullID() + " \u00a77value for \u00a7e" + data.getCommandArgs()[2] + " \u00a77has been set to \u00a7a" + ticks + " " + (cooldown != false ? "milliseconds" : "ticks"));
                    }
                    if (actionType.equals(NPC.Interact.Actions.Type.PLAYER_TELEPORT_TO_LOCATION)) {
                        castedAction = (NPC.Interact.Actions.Player.TeleportToLocation)selectedAction;
                        if (data.getCommandArgs()[2].equalsIgnoreCase("teleport")) {
                            if (data.getPlayerSender() == null) {
                                CommandUtils.error(data.getCommandSender(), "\u00a77You must be a player to teleport to the location.");
                                return;
                            }
                            data.getPlayerSender().teleport(castedAction.getLocation());
                        }
                    }
                    if (actionType.equals(NPC.Interact.Actions.Type.PLAYER_SEND_TITLE_MESSAGE)) {
                        castedAction = (NPC.Interact.Actions.Player.SendTitleMessage)selectedAction;
                        if (data.getCommandArgs()[2].equalsIgnoreCase("title") || data.getCommandArgs()[2].equalsIgnoreCase("subtitle")) {
                            if (data.getCommandArgs().length < 4) {
                                CommandUtils.error(data.commandSender, "No " + data.getCommandArgs()[2].toLowerCase() + " specified.");
                                return;
                            }
                            msg = "";
                            for (i = 3; i < data.getCommandArgs().length; ++i) {
                                msg = (String)msg + " " + data.getCommandArgs()[i];
                            }
                            msg = msg.replaceFirst(" ", "");
                            if (data.getCommandArgs()[2].equals("title")) {
                                castedAction.setTitle((String)msg);
                            }
                            if (data.getCommandArgs()[2].equals("subtitle")) {
                                castedAction.setSubtitle((String)msg);
                            }
                            CommandUtils.sendMessage(data.commandSender, "Click action with id \u00a7e" + actionID + " \u00a77for Global NPC \u00a7a" + data.global.getID().getFullID() + " \u00a77value for \u00a7e" + data.getCommandArgs()[2] + " \u00a77has been set to \u00a7r" + ColorUtils.formatColor((String)msg));
                        }
                        if (data.getCommandArgs()[2].equalsIgnoreCase("fadeIn") || data.getCommandArgs()[2].equalsIgnoreCase("stay") || data.getCommandArgs()[2].equalsIgnoreCase("fadeOut")) {
                            if (data.getCommandArgs().length < 4 || !MathUtils.isInteger(data.getCommandArgs()[3])) {
                                CommandUtils.error(data.commandSender, "No amount of ticks specified.");
                                return;
                            }
                            ticks = Integer.valueOf(data.getCommandArgs()[3]);
                            if (ticks < 0) {
                                ticks = 0;
                            }
                            if (data.getCommandArgs()[2].equalsIgnoreCase("fadeIn")) {
                                castedAction.setFadeIn(ticks);
                            }
                            if (data.getCommandArgs()[2].equalsIgnoreCase("stay")) {
                                castedAction.setStay(ticks);
                            }
                            if (data.getCommandArgs()[2].equalsIgnoreCase("fadeOut")) {
                                castedAction.setFadeOut(ticks);
                            }
                            CommandUtils.sendMessage(data.commandSender, "Click action with id \u00a7e" + actionID + " \u00a77for Global NPC \u00a7a" + data.global.getID().getFullID() + " \u00a77value for \u00a7e" + data.getCommandArgs()[2] + " \u00a77has been set to \u00a7a" + ticks + " ticks");
                        }
                    }
                }
                if (commandAction.equals("clear")) {
                    if (clickType != null) {
                        data.getGlobal().resetClickActions(clickType);
                        data.getCommandSender().sendMessage(CommandUtils.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77click actions for \u00a7e" + data.getArgs()[2] + " click \u00a77have been cleaned.");
                    } else if (selectedAction != null) {
                        data.getGlobal().removeClickAction(selectedAction);
                        data.getCommandSender().sendMessage(CommandUtils.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77click action with id \u00a7e" + actionID + " (" + selectedAction.getActionType().name().toLowerCase().replaceAll("_", " ") + ") \u00a77have been cleared.");
                    }
                    return;
                }
                if (!commandAction.equals("add")) break block171;
                if (data.getArgs().length < 5) {
                    CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal()));
                    return;
                }
                type = null;
                try {
                    type = NPC.Interact.Actions.Type.valueOf(data.getCommandArgs()[2].toUpperCase());
                }
                catch (Exception cooldown) {
                    // empty catch block
                }
                if (type.equals(NPC.Interact.Actions.Type.CUSTOM_ACTION)) {
                    type = null;
                }
                if (type == null) {
                    CommandUtils.error(data.getCommandSender(), "Incorrect argument \"" + data.getArgs()[4] + "\". Need to specify a valid action");
                    return;
                }
                msg = "";
                for (i = 5; i < data.getArgs().length; ++i) {
                    msg = (String)msg + " " + data.getArgs()[i];
                }
                msg = msg.replaceFirst(" ", "");
                if (type.equals(NPC.Interact.Actions.Type.CONSOLE_PERFORM_COMMAND)) {
                    if (data.getArgs().length < 6) {
                        CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal(), data.getArgs()[2] + " " + data.getArgs()[3] + " " + type.name().toLowerCase() + " (command)"));
                        return;
                    }
                    data.getGlobal().addRunConsoleCommandClickAction(clickType, (String)msg);
                }
                if (type.equals(NPC.Interact.Actions.Type.PLAYER_PERFORM_COMMAND)) {
                    if (data.getArgs().length < 6) {
                        CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal(), data.getArgs()[2] + " " + data.getArgs()[3] + " " + type.name().toLowerCase() + " (command)"));
                        return;
                    }
                    data.getGlobal().addRunPlayerCommandClickAction(clickType, (String)msg);
                }
                if (type.equals(NPC.Interact.Actions.Type.PLAYER_SEND_ACTIONBAR_MESSAGE)) {
                    if (data.getArgs().length < 6) {
                        CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal(), data.getArgs()[2] + " " + data.getArgs()[3] + " " + type.name().toLowerCase() + " (message)"));
                        return;
                    }
                    data.getGlobal().addActionBarMessageClickAction(clickType, (String)msg);
                }
                if (type.equals(NPC.Interact.Actions.Type.PLAYER_SEND_CHAT_MESSAGE)) {
                    if (data.getArgs().length < 6) {
                        CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal(), data.getArgs()[2] + " " + data.getArgs()[3] + " " + type.name().toLowerCase() + " (message)"));
                        return;
                    }
                    data.getGlobal().addMessageClickAction(clickType, new String[]{msg});
                }
                if (type.equals(NPC.Interact.Actions.Type.PLAYER_CONNECT_BUNGEE_SERVER)) {
                    if (data.getArgs().length < 6) {
                        CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal(), data.getArgs()[2] + " " + data.getArgs()[3] + " " + type.name().toLowerCase() + " (server)"));
                        return;
                    }
                    data.getGlobal().addConnectBungeeServerClickAction(clickType, data.getArgs()[5]);
                }
                if (type.equals(NPC.Interact.Actions.Type.PLAYER_GIVE_ITEM)) {
                    if (data.getPlayerSender() == null) {
                        CommandUtils.error(data.getCommandSender(), "You cannot use this in console.");
                        return;
                    }
                    itemStack = data.getPlayerSender().getInventory().getItemInMainHand();
                    if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
                        CommandUtils.error(data.getCommandSender(), "Item cannot be air.");
                        return;
                    }
                    msg = (String)(itemStack.hasItemMeta() != false && itemStack.getItemMeta().hasDisplayName() != false ? itemStack.getItemMeta().getDisplayName() : StringUtils.getFirstCharUpperCase(itemStack.getType().name().replaceAll("_", " "), true) + " \u00a77x" + itemStack.getAmount());
                    data.getGlobal().addGivePlayerItemClickAction(clickType, itemStack);
                }
                if (type.equals(NPC.Interact.Actions.Type.PLAYER_OPEN_BOOK)) {
                    if (data.getPlayerSender() == null) {
                        CommandUtils.error(data.getCommandSender(), "You cannot use this in console.");
                        return;
                    }
                    itemStack = data.getPlayerSender().getInventory().getItemInMainHand();
                    if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
                        CommandUtils.error(data.getCommandSender(), "Item cannot be air.");
                        return;
                    }
                    if (!itemStack.getType().equals((Object)Material.WRITTEN_BOOK)) {
                        CommandUtils.error(data.getCommandSender(), "Item must be a book.");
                        return;
                    }
                    data.getGlobal().addOpenBookClickAction(clickType, itemStack);
                }
                if (type.equals(NPC.Interact.Actions.Type.PLAYER_OPEN_ENCHANTING)) {
                    data.getGlobal().addOpenEnchantingClickAction(clickType);
                }
                if (type.equals(NPC.Interact.Actions.Type.PLAYER_OPEN_WORKBENCH)) {
                    data.getGlobal().addOpenWorkbenchClickAction(clickType);
                }
                if (type.equals(NPC.Interact.Actions.Type.PLAYER_PLAY_SOUND)) {
                    if (data.getArgs().length < 6) {
                        CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal(), data.getArgs()[2] + " " + data.getArgs()[3] + " " + type.name().toLowerCase() + " (sound)"));
                        return;
                    }
                    sound = null;
                    try {
                        sound = Sound.valueOf((String)data.getArgs()[5].toUpperCase());
                    }
                    catch (Exception castedAction) {
                        // empty catch block
                    }
                    if (sound == null) {
                        CommandUtils.error(data.commandSender, "This sound doesn't exists");
                        return;
                    }
                    data.getGlobal().addPlayerPlaySoundClickAction(clickType, sound);
                }
                if (type.name().contains("_MONEY")) {
                    if (data.getArgs().length < 6) {
                        CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal(), data.getArgs()[2] + " " + data.getArgs()[3] + " " + type.name().toLowerCase() + " (balance)"));
                        return;
                    }
                    balance = null;
                    try {
                        balance = Double.valueOf(data.getArgs()[5]);
                    }
                    catch (Exception castedAction) {
                        // empty catch block
                    }
                    if (balance == null) {
                        CommandUtils.error(data.commandSender, "This balance is not valid");
                        return;
                    }
                    if (type.equals(NPC.Interact.Actions.Type.PLAYER_WITHDRAW_MONEY)) {
                        data.getGlobal().addPlayerWithdrawMoneyClickAction(clickType, balance);
                    }
                    if (type.equals(NPC.Interact.Actions.Type.PLAYER_GIVE_MONEY)) {
                        data.getGlobal().addPlayerGiveMoneyClickAction(clickType, balance);
                    }
                }
                if (type.equals(NPC.Interact.Actions.Type.NPC_SET_CUSTOM_DATA)) {
                    if (data.getArgs().length < 7) {
                        CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal(), data.getArgs()[2] + " " + data.getArgs()[3] + " " + type.name().toLowerCase() + " (key) (value)"));
                        return;
                    }
                    data.getGlobal().addSetCustomDataClickAction(clickType, (Plugin)PlayerNPCPlugin.getInstance(), data.getArgs()[5], data.getArgs()[6]);
                }
                if (type.equals(NPC.Interact.Actions.Type.NPC_PLAY_ANIMATION)) {
                    if (data.getArgs().length < 6) {
                        CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal(), data.getArgs()[2] + " " + data.getArgs()[3] + " " + type.name().toLowerCase() + " (animation)"));
                        return;
                    }
                    animation = null;
                    try {
                        animation = NPC.Animation.valueOf(data.getArgs()[5].toUpperCase());
                    }
                    catch (Exception castedAction) {
                        // empty catch block
                    }
                    if (animation == null) {
                        CommandUtils.error(data.getCommandSender(), "This animation doesn't exists.");
                        return;
                    }
                    data.getGlobal().addPlayAnimationClickAction(clickType, animation);
                }
                if (type.equals(NPC.Interact.Actions.Type.PLAYER_SEND_TITLE_MESSAGE)) {
                    if (data.getArgs().length < 6) {
                        CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal(), data.getArgs()[2] + " " + data.getArgs()[3] + " " + type.name().toLowerCase() + " (title)\\n(subtitle)"));
                        return;
                    }
                    lines = new String[2];
                    if (msg.contains("\\n")) {
                        lines = msg.split("\\\\n", 2);
                    } else {
                        lines[0] = msg;
                        lines[1] = "";
                    }
                    data.getGlobal().addTitleMessageClickAction(clickType, lines[0], lines[1], 10, 30, 10);
                }
                if (!type.equals(NPC.Interact.Actions.Type.PLAYER_TELEPORT_TO_LOCATION)) break block172;
                if (data.getArgs().length < 6) {
                    CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal(), data.getArgs()[2] + " " + data.getArgs()[3] + " " + type.name().toLowerCase() + " (location/here)"));
                    return;
                }
                tp = null;
                if (!data.getArgs()[5].equalsIgnoreCase("here")) ** GOTO lbl543
                if (data.getPlayerSender() != null) {
                    tp = data.getPlayerSender().getLocation();
                } else {
                    CommandUtils.error(data.getCommandSender(), "You cannot use 'here' value in console.");
                    return;
lbl543:
                    // 1 sources

                    world = Bukkit.getWorld((String)data.getArgs()[5]);
                    x = Double.valueOf(data.getArgs()[6]);
                    y = Double.valueOf(data.getArgs()[7]);
                    z = Double.valueOf(data.getArgs()[8]);
                    tp = new Location(world, x.doubleValue(), y.doubleValue(), z.doubleValue());
                }
                if (tp == null) {
                    CommandUtils.error(data.getCommandSender(), "We can't find that location.");
                    return;
                }
                msg = tp.getWorld().getName() + ", " + MathUtils.getFormat(tp.getX(), 1) + ", " + MathUtils.getFormat(tp.getY(), 1) + ", " + MathUtils.getFormat(tp.getZ(), 1);
                data.getGlobal().addTeleportToLocationClickAction(clickType, tp);
            }
            data.getCommandSender().sendMessage(CommandUtils.getPrefix() + "\u00a77Global NPC \u00a7a" + data.getID() + " \u00a77click action for \u00a7e" + data.getArgs()[3] + " click \u00a77have been added for \u00a7e" + type.name().toLowerCase().replaceAll("_", " ") + (String)(msg != null && msg.equals("") == false ? " \u00a77as: \u00a7r" + ColorUtils.formatColor((String)msg) : ""));
        }
    }
}

