/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.command;

import com.mojang.authlib.GameProfile;
import dev.sergiferry.playernpc.PlayerNPCPlugin;
import dev.sergiferry.playernpc.api.NPC;
import dev.sergiferry.playernpc.api.NPCLib;
import dev.sergiferry.playernpc.command.CommandUtils;
import dev.sergiferry.playernpc.nms.spigot.NMSPlayer;
import dev.sergiferry.playernpc.utils.ClickableText;
import dev.sergiferry.playernpc.utils.ColorUtils;
import dev.sergiferry.playernpc.utils.MathUtils;
import dev.sergiferry.spigot.SpigotPlugin;
import dev.sergiferry.spigot.commands.CommandInstance;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.mineskin.Variant;

public class NPCLibCommand
extends CommandInstance
implements TabCompleter {
    protected static final String COMMAND_LABEL = "npclib";
    private static final List<Command> commands = new ArrayList<Command>();
    public static final Command INFO = new Command((Plugin)PlayerNPCPlugin.getInstance(), "info", "(plugin)", true, true, "Get info of NPCLib", "\u00a77This will give you all the information about the NPCLib.", (command, data) -> {
        Player player = data.getPlayerSender();
        if (player == null) {
            CommandUtils.error(data.commandSender);
        }
        NPCLib npcLib = data.getNPCLib();
        PlayerNPCPlugin plugin = PlayerNPCPlugin.getInstance();
        if (data.getCommandArgs().length > 0) {
            plugin = Bukkit.getServer().getPluginManager().getPlugin(data.getCommandArgs()[0]);
            if (plugin == null) {
                CommandUtils.error(data.getCommandSender(), "This plugin doesn't exists.");
                return;
            }
            if (!NPCLib.getInstance().isRegistered((Plugin)plugin)) {
                CommandUtils.error(data.getCommandSender(), "This plugin is not registered into the NPCLib.");
                return;
            }
        }
        Integer page = 1;
        Integer maxPage = 1;
        if (data.getCommandArgs().length > 1 && MathUtils.isInteger(data.getCommandArgs()[1])) {
            page = Integer.valueOf(data.getCommandArgs()[1]);
        }
        for (int i = 0; i < 100; ++i) {
            player.sendMessage("");
        }
        NMSPlayer.sendMessage(player, "  \u00a7c\u00a7lInformation about NPCLib \u00a77(Page " + page + "/" + maxPage + ")", "");
        if (page == 1) {
            String author = plugin.getDescription().getAuthors().stream().findFirst().orElse(null);
            new ClickableText("  \u00a78\u2022 \u00a76\u00a7lPlugin: ").add("\u00a77" + plugin.getName()).send(player);
            new ClickableText("  \u00a78\u2022 \u00a76\u00a7lAuthor: ").add("\u00a77" + plugin.getDescription().getAuthors().stream().findFirst().orElse("\u00a7cUnknown")).send(player);
            new ClickableText("  \u00a78\u2022 \u00a76\u00a7lPlugin version: ").add("\u00a77" + plugin.getDescription().getVersion()).send(player);
            new ClickableText("  \u00a78\u2022 \u00a76\u00a7lServer version: ").add("\u00a77" + SpigotPlugin.getServerVersion().getMinecraftVersion()).send(player);
        }
        player.sendMessage("");
        boolean next = page < maxPage;
        boolean previous = page > 1;
        ClickableText clickableText = new ClickableText("  ");
        if (previous) {
            clickableText.add("\u00a7c\u00a7l[PREVIOUS]", "\u00a7eClick to go to the previous page.", ClickEvent.Action.RUN_COMMAND, "/npclib info " + plugin.getName() + " " + (page - 1));
        } else {
            clickableText.add("\u00a78\u00a7l[PREVIOUS]");
        }
        clickableText.add("    ");
        if (next) {
            clickableText.add("\u00a7a\u00a7l[NEXT]", "\u00a7eClick to go to the next page.", ClickEvent.Action.RUN_COMMAND, "/npclib info " + plugin.getName() + " " + (page + 1));
        } else {
            clickableText.add("\u00a78\u00a7l[NEXT]");
        }
        clickableText.add("    ");
        clickableText.add("\u00a7c\u00a7l[CLOSE INFO]", "\u00a7eClick to close information.", ClickEvent.Action.RUN_COMMAND, "/npclib help");
        clickableText.send(player);
        player.sendMessage("");
    }, (command, data) -> {
        ArrayList strings = new ArrayList();
        if (data.getCommandArgs().length == 1) {
            NPCLib.getInstance().getRegisteredPlugins().stream().filter(x -> x.getName().toLowerCase().startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x.getName()));
        }
        return strings;
    });
    public static final Command RELOADCONFIG = new Command((Plugin)PlayerNPCPlugin.getInstance(), "reloadconfig", "", true, true, "Reload config", "\u00a77This will reload the configuration file.", (command, data) -> {
        data.getNPCLib().loadConfig();
        data.getCommandSender().sendMessage(NPCLibCommand.getPrefix() + "\u00a77Configuration has been reloaded.");
    }, (command, data) -> null);
    public static final Command GETSKININFO = new Command((Plugin)PlayerNPCPlugin.getInstance(), "getskininfo", "(type) (name)", true, false, "Get skin information", "\u00a77With this command you can request the Mojang API to return the information of a player's skin.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(type) \u00a77Can be minecraft, custom or mineskin.\n\u00a78\u2022 \u00a7a(name) \u00a77Name of the player.", (command, data) -> {
        boolean delete;
        if (data.getPlayerSender() == null) {
            CommandUtils.error(data.getCommandSender(), "This command cannot be executed from console.");
            return;
        }
        if (data.getCommandArgs().length < 2) {
            CommandUtils.notEnoughArguments(command, data);
            return;
        }
        String type = data.getCommandArgs()[0].toLowerCase();
        boolean sendMessage = true;
        boolean clearChat = false;
        boolean forceDownload = data.getCommandArgs().length > 2 && data.getCommandArgs()[2].equals("-forceDownload");
        boolean forceMojang = data.getCommandArgs().length > 2 && data.getCommandArgs()[2].equals("-forceMojang");
        boolean giveHead = data.getCommandArgs().length > 2 && data.getCommandArgs()[2].equals("-giveHead");
        boolean bl = delete = data.getCommandArgs().length > 2 && data.getCommandArgs()[2].equals("-delete");
        if (giveHead || delete) {
            sendMessage = false;
        }
        if (forceDownload) {
            clearChat = true;
        }
        if (clearChat) {
            for (int i = 0; i < 100; ++i) {
                data.getPlayerSender().sendMessage("");
            }
        }
        BukkitTask actionTask = null;
        if (type.equals("minecraft")) {
            if (sendMessage) {
                data.getCommandSender().sendMessage(NPCLibCommand.getPrefix() + "\u00a77Trying to fetch skin of " + data.getCommandArgs()[1]);
                actionTask = Bukkit.getScheduler().runTaskTimer(command.getPlugin(), () -> data.getPlayerSender().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7eFetching skin information from Minecraft...")), 3L, 3L);
            }
            BukkitTask finalActionTask = actionTask;
            if (forceMojang) {
                NPC.Skin.Minecraft.fetchSkinMojangAsync(data.getCommandArgs()[1]).thenAccept(fetchResult -> {
                    if (finalActionTask != null && !finalActionTask.isCancelled()) {
                        finalActionTask.cancel();
                    }
                    data.getPlayerSender().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(""));
                    if (fetchResult.hasError()) {
                        CommandUtils.error(data.getCommandSender(), ((NPC.Skin.Minecraft.FetchResult.Error)fetchResult.grabError().get()).getMessage());
                        return;
                    }
                    NPCLibCommand.renderSkinInfo(command, data, (NPC.Skin)fetchResult.grabSkin().get());
                });
                return;
            }
            NPC.Skin.Minecraft.fetchSkinAsync(command.getPlugin(), data.getCommandArgs()[1], forceDownload).thenAccept(fetchResult -> {
                if (finalActionTask != null && !finalActionTask.isCancelled()) {
                    finalActionTask.cancel();
                }
                data.getPlayerSender().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(""));
                if (fetchResult.hasError()) {
                    CommandUtils.error(data.getCommandSender(), ((NPC.Skin.Minecraft.FetchResult.Error)fetchResult.grabError().get()).getMessage());
                    return;
                }
                if (giveHead) {
                    NPCLibCommand.giveHead(command, data, (NPC.Skin)fetchResult.grabSkin().get());
                }
                if (delete) {
                    if (!((NPC.Skin.Minecraft)fetchResult.grabSkin().get()).canBeDeleted()) {
                        CommandUtils.error(data.getCommandSender(), "This skin cannot be deleted");
                        return;
                    }
                    ((NPC.Skin.Minecraft)fetchResult.grabSkin().get()).delete();
                    for (int i = 0; i < 100; ++i) {
                        data.getPlayerSender().sendMessage("");
                    }
                    CommandUtils.sendMessage(data.getCommandSender(), "\u00a77Skin \u00a7c" + ((NPC.Skin.Minecraft)fetchResult.grabSkin().get()).getName() + " \u00a77has been removed successfully.");
                    return;
                }
                NPCLibCommand.renderSkinInfo(command, data, (NPC.Skin)fetchResult.grabSkin().get());
            });
        } else if (data.getCommandArgs()[0].equalsIgnoreCase("custom")) {
            if (!NPCLib.Registry.ID.isFullValid(data.getCommandArgs()[1])) {
                CommandUtils.errorNotValidID(data.getCommandSender(), data.getCommandArgs()[1]);
                return;
            }
            if (sendMessage) {
                data.getCommandSender().sendMessage(NPCLibCommand.getPrefix() + "\u00a77Trying to fetch custom skin " + data.getCommandArgs()[1].toLowerCase() + "...");
                actionTask = Bukkit.getScheduler().runTaskTimer(command.getPlugin(), () -> data.getPlayerSender().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7eFetching skin information from database...")), 3L, 3L);
            }
            BukkitTask finalActionTask = actionTask;
            NPC.Skin.Custom.fetchCustomSkinAsync(data.getCommandArgs()[1].toLowerCase()).thenAccept(fetchResult -> {
                if (finalActionTask != null && !finalActionTask.isCancelled()) {
                    finalActionTask.cancel();
                }
                data.getPlayerSender().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(""));
                if (fetchResult.hasError()) {
                    CommandUtils.error(data.getCommandSender(), ((NPC.Skin.Custom.FetchResult.Error)fetchResult.grabError().get()).getMessage());
                    return;
                }
                if (giveHead) {
                    NPCLibCommand.giveHead(command, data, (NPC.Skin)fetchResult.grabSkin().get());
                }
                if (delete) {
                    ((NPC.Skin.Custom)fetchResult.grabSkin().get()).delete();
                    for (int i = 0; i < 100; ++i) {
                        data.getPlayerSender().sendMessage("");
                    }
                    CommandUtils.sendMessage(data.getCommandSender(), "\u00a77Skin \u00a7c" + ((NPC.Skin.Custom)fetchResult.grabSkin().get()).getID().getFullID() + " \u00a77has been removed successfully.");
                    return;
                }
                NPCLibCommand.renderSkinInfo(command, data, (NPC.Skin)fetchResult.grabSkin().get());
            });
        } else if (data.getCommandArgs()[0].equalsIgnoreCase("mineskin")) {
            if (sendMessage) {
                data.getCommandSender().sendMessage(NPCLibCommand.getPrefix() + "\u00a77Trying to fetch skin from MineSkin...");
                actionTask = Bukkit.getScheduler().runTaskTimer(command.getPlugin(), () -> data.getPlayerSender().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7eFetching skin information from MineSkin...")), 3L, 3L);
            }
            BukkitTask finalActionTask = actionTask;
            NPC.Skin.MineSkin.fetchSkinAsync(command.getPlugin(), data.getCommandArgs()[1], forceDownload).thenAccept(fetchResult -> {
                if (finalActionTask != null && !finalActionTask.isCancelled()) {
                    finalActionTask.cancel();
                }
                data.getPlayerSender().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(""));
                if (fetchResult.hasError()) {
                    CommandUtils.error(data.getCommandSender(), fetchResult.getErrorMessage());
                    return;
                }
                if (giveHead) {
                    NPCLibCommand.giveHead(command, data, (NPC.Skin)fetchResult.grabSkin().get());
                }
                if (delete) {
                    ((NPC.Skin.MineSkin)fetchResult.grabSkin().get()).delete();
                    for (int i = 0; i < 100; ++i) {
                        data.getPlayerSender().sendMessage("");
                    }
                    CommandUtils.sendMessage(data.getCommandSender(), "\u00a77Skin \u00a7c" + ((NPC.Skin.MineSkin)fetchResult.grabSkin().get()).getId() + " \u00a77has been removed successfully.");
                    return;
                }
                NPCLibCommand.renderSkinInfo(command, data, (NPC.Skin)fetchResult.grabSkin().get());
            });
        } else if (type.equals("url")) {
            if (sendMessage) {
                data.getCommandSender().sendMessage(NPCLibCommand.getPrefix() + "\u00a77Trying to download skin from \u00a7e" + data.getCommandArgs()[1]);
                actionTask = Bukkit.getScheduler().runTaskTimer(command.getPlugin(), () -> data.getPlayerSender().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7eGenerating skin information...")), 3L, 3L);
            }
            BukkitTask finalActionTask = actionTask;
            Variant variant = Variant.AUTO;
            if (data.getCommandArgs().length > 2) {
                if (data.getCommandArgs()[2].equalsIgnoreCase("slim")) {
                    variant = Variant.SLIM;
                } else if (data.getCommandArgs()[2].equalsIgnoreCase("classic")) {
                    variant = Variant.CLASSIC;
                }
            }
            NPC.Skin.MineSkin.generateSkinFromURLAsync(data.getCommandArgs()[1], variant).thenAccept(fetchResult -> {
                if (finalActionTask != null && !finalActionTask.isCancelled()) {
                    finalActionTask.cancel();
                }
                data.getPlayerSender().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(""));
                if (fetchResult.hasError()) {
                    CommandUtils.error(data.getCommandSender(), fetchResult.getErrorMessage());
                    return;
                }
                NPCLibCommand.renderSkinInfo(command, data, (NPC.Skin)fetchResult.grabSkin().get());
            });
        } else if (type.equals("npc")) {
            if (!NPCLib.Registry.ID.isFullValid(data.getCommandArgs()[1])) {
                CommandUtils.errorNotValidID(data.getCommandSender(), data.getCommandArgs()[1]);
                return;
            }
            Optional<NPC.Global> other = data.getNPCLib().grabGlobalNPC(data.getCommandArgs()[1]);
            if (other.isEmpty()) {
                CommandUtils.error(data.commandSender, "This Global NPC does not exists.");
                return;
            }
            NPCLibCommand.renderSkinInfo(command, data, other.get().getSkin());
        } else {
            CommandUtils.error(data.commandSender, "Type of skin can only be Minecraft, Custom or MineSkin.");
        }
    }, (command, data) -> {
        if (data.getCommandArgs().length > 3) {
            return null;
        }
        ArrayList strings = new ArrayList();
        if (data.getCommandArgs().length == 1) {
            Arrays.asList("minecraft", "custom", "mineskin", "npc", "url").stream().filter(x -> x.startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x));
        }
        if (data.getCommandArgs().length == 2) {
            String argLowerCase = data.getCommandArgs()[1].toLowerCase();
            if (data.getCommandArgs()[0].equalsIgnoreCase("minecraft")) {
                NPC.Skin.Minecraft.getSuggestedSkinNames().stream().filter(x -> x.startsWith(argLowerCase)).forEach(x -> strings.add(x));
            }
            if (data.getCommandArgs()[0].equalsIgnoreCase("custom")) {
                NPC.Skin.Custom.getSuggestedSkinNames().stream().filter(x -> x.startsWith(argLowerCase)).forEach(x -> strings.add(x));
            }
            if (data.getCommandArgs()[0].equalsIgnoreCase("mineskin")) {
                NPC.Skin.MineSkin.getSuggestedSkinNames().stream().filter(x -> x.startsWith(argLowerCase)).forEach(x -> strings.add(x));
            }
            if (data.getCommandArgs()[0].equalsIgnoreCase("npc")) {
                NPCLib.getInstance().getAllGlobalNPCs().stream().filter(x -> x.getID().getFullID().startsWith(argLowerCase) || x.getID().getSimpleID().startsWith(argLowerCase)).forEach(x -> strings.add(x.getID().getFullID()));
            }
            if (data.getCommandArgs()[0].equalsIgnoreCase("url")) {
                NPC.Skin.getSuggestedSkinWebsites().stream().filter(x -> x.startsWith(argLowerCase)).forEach(x -> strings.add(x));
            }
        }
        if (data.getCommandArgs().length == 3 && data.getCommandArgs()[0].equalsIgnoreCase("url")) {
            Arrays.asList("auto", "slim", "classic").stream().filter(x -> x.startsWith(data.getCommandArgs()[2].toLowerCase())).forEach(x -> strings.add(x));
        }
        return strings;
    });
    public static final Command SETUPDATEGAZETICKS;
    public static final Command SETUPDATEGAZETYPE;
    public static final Command SETTICKSUNTILTABLISTHIDE;
    public static final Command SETSKINUPDATEFREQUENCY;
    public static final Command SETDEBUG;
    public static final NamespacedKey skinKey;

    public NPCLibCommand(SpigotPlugin plugin) {
        super(plugin, COMMAND_LABEL);
    }

    private static void giveHead(Command command, CommandData data, NPC.Skin skin) {
        ItemStack is = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta im = (SkullMeta)is.getItemMeta();
        Object name = "";
        Object codeName = "";
        String playerProfile = null;
        if (skin.getType().equals(NPC.Skin.Type.MINECRAFT)) {
            NPC.Skin.Minecraft minecraft = (NPC.Skin.Minecraft)skin;
            name = minecraft.getName();
            codeName = minecraft.getName();
            playerProfile = minecraft.getName();
        } else if (skin.getType().equals(NPC.Skin.Type.MINESKIN)) {
            NPC.Skin.MineSkin mineSkin = (NPC.Skin.MineSkin)skin;
            name = "MineSkin";
            codeName = "" + mineSkin.getId();
            playerProfile = "MineSkin";
        } else if (skin.getType().equals(NPC.Skin.Type.CUSTOM)) {
            NPC.Skin.Custom custom = (NPC.Skin.Custom)skin;
            name = custom.getPluginInfo().getName() + " " + (custom.getName() != null ? custom.getName() : "Custom Skin");
            codeName = custom.getID().getFullID();
            playerProfile = "Custom Skin";
        }
        im.setDisplayName((skin.getMostCommonColor() != null ? skin.getMostCommonColor() : ChatColor.YELLOW) + "\u00a7l" + (String)name);
        GameProfile profile = new GameProfile(UUID.randomUUID(), playerProfile);
        profile.getProperties().put((Object)"textures", (Object)skin.generateTexturesProperty(false));
        Field profileField = null;
        try {
            profileField = im.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(im, profile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (codeName != null) {
            im.getPersistentDataContainer().set(skinKey, PersistentDataType.STRING, (Object)(skin.getType().name() + ":" + (String)codeName));
        }
        is.setItemMeta((ItemMeta)im);
        data.getPlayerSender().getInventory().addItem(new ItemStack[]{is});
    }

    private static void renderSkinInfo(Command command, CommandData data, NPC.Skin skin) {
        int i;
        boolean giveHeadDisabled;
        ArrayList<ClickableText> lines = new ArrayList<ClickableText>();
        boolean unknownAvatar = false;
        boolean noIdentifier = false;
        NPC.Skin.Avatar avatar = skin.getAvatar().join();
        if (avatar == null) {
            avatar = NPC.Skin.Avatar.getUnknownAvatar();
            unknownAvatar = true;
        }
        for (int y = 0; y < 8; ++y) {
            lines.add(new ClickableText(" "));
            for (int x = 0; x < 8; ++x) {
                ChatColor color = avatar.getPixel(x, y);
                if (unknownAvatar && color.getColor().getRed() == 255) {
                    color = ChatColor.of((Color)ColorUtils.getColorFromRGB(new int[]{40, 40, 40}));
                }
                ((ClickableText)lines.get(y)).add("\u2588", color, data.getNPCLib().isDebug() ? "\u00a7e\u00a7lPixel (" + x + "," + y + ")\n\u00a7c\u00a7lR: \u00a77" + color.getColor().getRed() + "\n\u00a7a\u00a7lG: \u00a77" + color.getColor().getGreen() + "\n\u00a79\u00a7lB: \u00a77" + color.getColor().getBlue() : null);
            }
        }
        ChatColor mostCommonColor = skin.getMostCommonColor();
        if (unknownAvatar) {
            mostCommonColor = NPC.Skin.Avatar.getUnknownAvatar().getMostCommonColor();
        }
        if (mostCommonColor == null) {
            mostCommonColor = ChatColor.YELLOW;
        }
        int lastUpdateSeconds = skin.getTimeFromLastUpdate(TimeUnit.SECONDS);
        NPC.Skin.Type type = skin.getType();
        Object skinName = "";
        Object skinCommand = "";
        Object skinInfoHover = "";
        ClickEvent.Action skinInfoAction = ClickEvent.Action.COPY_TO_CLIPBOARD;
        String skinInfoActionValue = "";
        boolean updateButtonActivated = lastUpdateSeconds > 5;
        boolean applyGlobalButtonActivated = true;
        boolean applyPersonalButtonActivated = true;
        boolean removeButtonActivated = true;
        boolean giveHeadButtonActivated = true;
        Object updateHover = "";
        TextComponent verified = null;
        TextComponent caution = null;
        String skinNameTitle = "Skin name";
        if (type.equals(NPC.Skin.Type.MINECRAFT)) {
            NPC.Skin.Minecraft minecraft = (NPC.Skin.Minecraft)skin;
            skinName = minecraft.getName();
            skinNameTitle = "Player name";
            skinCommand = minecraft.getName().toLowerCase();
            Player player = Bukkit.getServer().getPlayerExact(minecraft.getName());
            NPC.Skin.Minecraft.ObtainedFrom obtainedFrom = player != null && NPC.Skin.Minecraft.hasSkinGameProfile(player) ? NPC.Skin.Minecraft.ObtainedFrom.GAME_PROFILE : NPC.Skin.Minecraft.ObtainedFrom.MOJANG_API;
            updateHover = "\u00a7b\u00a7lForce to update skin\n\u00a77This will update the skin, and depending on whether the player is online or not, the skin will be downloaded from the player's Game Profile, or else from the Mojang API.\n\n\u00a77Now the skin would be obtained from: \u00a7a" + obtainedFrom.getTitle() + "\n\n\u00a7eClick to update the skin";
            updateButtonActivated = lastUpdateSeconds > 5 && minecraft.canBeUpdated();
            removeButtonActivated = minecraft.canBeDeleted();
            skinInfoHover = minecraft.getInformation() + "\n\n\u00a7eClick to copy UUID to clipboard";
            skinInfoActionValue = minecraft.getSimplifiedUUID();
            Integer spigotPageID = null;
            if (((String)skinName).equals("SergiFerry")) {
                spigotPageID = 58422;
            }
            if (spigotPageID != null) {
                verified = new ClickableText("\u00a7b\u2726", "\u00a7b\u00a7l\u2726 This account is verified\n\u00a77This means that this player has a linked\n\u00a77SpigotMC.org profile page.\n\n\u00a7eClick to visit his profile page.", ClickEvent.Action.OPEN_URL, "https://www.spigotmc.org/resources/authors/" + ((String)skinName).toLowerCase() + "." + spigotPageID + "/").getTextComponent();
            }
            if (minecraft.isModifiedByThirdParty()) {
                caution = new ClickableText("\u00a76\u26a0", "\u00a76\u00a7l\u26a0 This skin has been modified by a third party\n\u00a77This means that some plugin has modified the texture of the GameProfile, and now it shows the skin of another player on his body.\n\n\u00a77Showing a skin uploaded by: \u00a7e" + minecraft.getTextureData().getProfileName() + "\n\n\u00a7eClick to update directly from Mojang API.", ClickEvent.Action.RUN_COMMAND, command.getCommand(type.name().toLowerCase() + " " + (String)skinCommand + " -forceMojang")).getTextComponent();
            }
        } else if (type.equals(NPC.Skin.Type.CUSTOM)) {
            NPC.Skin.Custom custom = (NPC.Skin.Custom)skin;
            noIdentifier = !custom.hasID();
            skinName = custom.getName();
            if (noIdentifier) {
                skinName = "Custom skin";
                giveHeadButtonActivated = false;
                applyGlobalButtonActivated = false;
                removeButtonActivated = false;
            }
            applyPersonalButtonActivated = false;
            skinCommand = custom.hasID() ? custom.getID().getFullID() : "";
            skinInfoActionValue = custom.hasID() ? custom.getID().getFullID() : "";
            updateButtonActivated = false;
            skinInfoHover = custom.getInformation() + (!noIdentifier ? "\n\n\u00a7eClick to copy ID to clipboard" : "");
        } else if (type.equals(NPC.Skin.Type.MINESKIN)) {
            NPC.Skin.MineSkin mineSkin = (NPC.Skin.MineSkin)skin;
            skinName = "MineSkin \u00a7e#" + mineSkin.getId();
            skinCommand = "" + mineSkin.getId();
            skinInfoAction = ClickEvent.Action.OPEN_URL;
            skinInfoActionValue = mineSkin.getMineSkinURL();
            updateHover = "\u00a7b\u00a7lForce to update skin\n\u00a77This will update the skin, and will be downloaded from MineSkin.\n\n\u00a7eClick to update the skin";
            skinInfoHover = mineSkin.getInformation() + "\n\n\u00a7eClick to open MineSkin website.";
            applyPersonalButtonActivated = false;
        }
        if (((String)skinName).length() > 25) {
            skinName = ((String)skinName).substring(0, 25) + "...";
        }
        boolean bl = giveHeadDisabled = !giveHeadButtonActivated || data.getCommandArgs().length > 2 && data.getCommandArgs()[2].equals("-giveHead");
        TextComponent giveHeadButton = ClickableText.get((String)(!noIdentifier ? (giveHeadDisabled ? "\u00a78" : "\u00a76") + "\u00a7l[\u2620]" : ""), new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(giveHeadDisabled ? null : "\u00a76\u00a7l" + ((String)skinName).replaceAll("\u00a7e", "\u00a76") + "\u00a7l's head\n\u00a77This will give you the player's head with it's texture.\n\n\u00a7aShift + Right click on a block \u00a77with this item on the main hand to preview the skin on an abstract NPC for 15 seconds.\n\n\u00a7aShift + Right click on air \u00a77with this item on the main hand to set this as your skin.\n\n\u00a7eClick to receive player's head.")}), giveHeadDisabled ? null : new ClickEvent(ClickEvent.Action.RUN_COMMAND, command.getCommand(type.name().toLowerCase() + " " + (String)skinCommand + " -giveHead")));
        for (i = 0; i <= 7; ++i) {
            ((ClickableText)lines.get(i)).add("  ");
        }
        ((ClickableText)lines.get(0)).add("\u00a7l\u00a7nSkin information", mostCommonColor, data.getNPCLib().isDebug() ? "\u00a7e\u00a7lMost common color\n\u00a7c\u00a7lR: \u00a77" + mostCommonColor.getColor().getRed() + "\n\u00a7a\u00a7lG: \u00a77" + mostCommonColor.getColor().getGreen() + "\n\u00a79\u00a7lB: \u00a77" + mostCommonColor.getColor().getBlue() : null);
        ((ClickableText)lines.get(2)).add("\u00a77" + skinNameTitle + ": ").add("\u00a7e\u00a7l" + (String)skinName, (String)skinInfoHover, skinInfoAction, skinInfoActionValue);
        ((ClickableText)lines.get(3)).add("\u00a77Texture value: ").add("\u00a7a\u00a7l[COPY TO CLIPBOARD]", "\u00a7a\u00a7lTexture value\n\u00a77This value is encrypted in Base64, and contains all the information related to the textures of the skin.\n\n\u00a77\u00a7oThis texture value is " + skin.getTexture().length() + " characters length.\n\n\u00a7eClick to copy texture value to clipboard", ClickEvent.Action.COPY_TO_CLIPBOARD, skin.getTexture()).add(" ").add(giveHeadButton);
        ((ClickableText)lines.get(4)).add("\u00a77Texture signature: ").add("\u00a7a\u00a7l[COPY TO CLIPBOARD]", "\u00a7a\u00a7lTexture signature\n\u00a77This signature is encrypted by the Mojang server itself, and is used to verify that the value of the textures has not been modified. Only Mojang can generate this signature, when the skin is uploaded to their servers.\n\n\u00a77\u00a7oThis texture signature is " + skin.getSignature().length() + " characters length.\n\n\u00a7eClick to copy texture signature to clipboard", ClickEvent.Action.COPY_TO_CLIPBOARD, skin.getSignature());
        if (!noIdentifier) {
            ((ClickableText)lines.get(6)).add("\u00a77Manage: ").add((updateButtonActivated ? "\u00a7b\u00a7l" : "\u00a78\u00a7l") + "[UPDATE SKIN]", (String)(updateButtonActivated ? updateHover : ""), updateButtonActivated, ClickEvent.Action.RUN_COMMAND, command.getCommand(type.name().toLowerCase() + " " + (String)skinCommand + " -forceDownload")).add(" ").add((removeButtonActivated ? "\u00a74" : "\u00a78") + "\u00a7l[REMOVE SKIN]", removeButtonActivated ? "\u00a74\u00a7lRemove skin from database\n\u00a77This will permanently remove the skin from the server, and it will not appear again until it is downloaded again.\n\n\u00a7eClick to remove skin from database" : null, removeButtonActivated, ClickEvent.Action.RUN_COMMAND, command.getCommand(type.name().toLowerCase() + " " + (String)skinCommand + " -delete"));
            ((ClickableText)lines.get(7)).add("\u00a77Apply to: ").add("\u00a7" + (applyGlobalButtonActivated ? "6" : "8") + "\u00a7l[GLOBAL NPC]", !applyGlobalButtonActivated ? null : "\u00a76\u00a7lApply to Global NPC\n\u00a77This will apply the skin to the selected Global NPC.\n\n\u00a77Click to suggest the command\n\u00a7e/npcglobal setskin (id) " + type.name().toLowerCase() + " " + (String)skinCommand, (ClickEvent.Action)(applyGlobalButtonActivated ? ClickEvent.Action.SUGGEST_COMMAND : null), "/npcglobal setskin (id) " + type.name().toLowerCase() + " " + (String)skinCommand).add(" ").add("\u00a7" + (applyPersonalButtonActivated ? "c" : "8") + "\u00a7l[PERSONAL NPC]", !applyPersonalButtonActivated ? null : "\u00a7c\u00a7lApply to Personal NPC\n\u00a77This will apply the skin to the selected Personal NPC.\n\n\u00a77Click to suggest the command\n\u00a7e/npcpersonal setskin (player) (id) " + (String)skinCommand, (ClickEvent.Action)(applyPersonalButtonActivated ? ClickEvent.Action.SUGGEST_COMMAND : null), "/npcpersonal setskin (player) (id) " + (String)skinCommand);
        } else {
            ((ClickableText)lines.get(6)).add("\u00a77This Custom Skin does not have an identifier,");
            ((ClickableText)lines.get(7)).add("\u00a77this means that it cannot be managed.");
        }
        if (caution != null) {
            ((ClickableText)lines.get(2)).add(" ").add(caution);
        }
        if (verified != null) {
            ((ClickableText)lines.get(2)).add(" ").add(verified);
        }
        for (i = 0; i < 100; ++i) {
            data.getPlayerSender().sendMessage("");
        }
        for (ClickableText line : lines) {
            line.send(data.getPlayerSender());
        }
        data.getPlayerSender().sendMessage("");
    }

    @Override
    public void onExecute(CommandSender sender, org.bukkit.command.Command command, String label, String[] args) {
        Player playerSender;
        Player player = playerSender = sender instanceof Player ? (Player)sender : null;
        if (playerSender != null && !this.getPlugin().hasPermission(playerSender, "command")) {
            sender.sendMessage(NPCLibCommand.getPrefix() + "You don't have permission to do this.");
            return;
        }
        NPCLib npcLib = NPCLib.getInstance();
        if (args.length == 0) {
            if (playerSender != null) {
                NPCLibCommand.sendHelpList(playerSender, 1);
            } else {
                CommandUtils.error(sender);
            }
            return;
        }
        if (args[0].equalsIgnoreCase("help")) {
            int asd = 1;
            if (args.length == 2 && MathUtils.isInteger(args[1])) {
                asd = Integer.valueOf(args[1]);
            }
            if (playerSender != null) {
                NPCLibCommand.sendHelpList(playerSender, asd);
            } else {
                CommandUtils.error(sender);
            }
            return;
        }
        Command commands = NPCLibCommand.getCommand(args[0]);
        if (commands == null) {
            new ClickableText("\u00a7c\u00a7lError \u00a78| \u00a77This command do not exist. Use \u00a7e/npclib help", CommandUtils.c(), ClickEvent.Action.SUGGEST_COMMAND, "/npclib help").send(sender);
            return;
        }
        if (!commands.isEnabled()) {
            CommandUtils.error(sender, "This command is not enabled.");
            return;
        }
        CommandData data = new CommandData(sender, args, npcLib);
        commands.getExecute().accept(commands, data);
    }

    public List<String> onTabComplete(CommandSender sender, org.bukkit.command.Command cmd, String label, String[] args) {
        Player playerSender;
        if (!this.isCommand(label)) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>();
        Player player = playerSender = sender instanceof Player ? (Player)sender : null;
        if (playerSender != null && !this.getPlugin().hasPermission(playerSender, "command")) {
            return strings;
        }
        NPCLib npcLib = NPCLib.getInstance();
        if (args.length == 1) {
            commands.stream().filter(x -> x.getArgument().startsWith(args[0]) && x.isEnabled()).forEach(x -> strings.add(x.getArgument()));
            if ("help".startsWith(args[0]) || strings.isEmpty()) {
                strings.add("help");
            }
            return strings;
        }
        Command command = NPCLibCommand.getCommand(args[0]);
        if (command == null || !command.isEnabled()) {
            return strings;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("help")) {
            int maxpag = (commands.size() - 1) / 4 + 1;
            for (int i = 1; i <= maxpag; ++i) {
                strings.add("" + i);
            }
            return strings;
        }
        if (args.length >= 2) {
            CommandData data = new CommandData(sender, args, npcLib);
            List<String> suggested = command.getTabComplete().apply(command, data);
            if (suggested != null) {
                strings.addAll(suggested);
            }
            return strings;
        }
        return strings;
    }

    public static String getCommandColor(Command command) {
        return NPCLibCommand.getCommandColor(command, false);
    }

    public static String getCommandColor(Command command, boolean ignoreBold) {
        if (!command.isEnabled()) {
            return "\u00a78" + (command.isImportant() && !ignoreBold ? "\u00a7l" : "");
        }
        NPCLib.Command.Color color = command.getColor();
        if (command.isImportant()) {
            return color.getImportantSimple() + (!ignoreBold ? "\u00a7l" : "");
        }
        return "" + color.getNormal();
    }

    private static void sendHelpList(Player player, Integer pag) {
        int total = commands.size();
        int perpag = 4;
        int maxpag = (total - 1) / perpag + 1;
        if (pag > maxpag) {
            return;
        }
        for (int i = 0; i < 100; ++i) {
            player.sendMessage("");
        }
        NMSPlayer.sendMessage(player, "  \u00a7c\u00a7lNPCLib commands \u00a77(Page " + pag + "/" + maxpag + ")", "");
        int aas = 0;
        for (int i = 0; i < perpag && total > i + (pag - 1) * perpag; ++i) {
            int id = i + (pag - 1) * perpag;
            Command npcCommands = commands.get(id);
            new ClickableText("  \u00a78\u2022 ").add(NPCLibCommand.getCommandColor(npcCommands) + npcCommands.getTitle() + (String)(npcCommands.isCustom() ? " \u00a77(" + npcCommands.getPlugin().getName() + ")" : ""), npcCommands.isEnabled() ? NPCLibCommand.getCommandColor(npcCommands, true) + npcCommands.getCommand() + "\n\u00a78Command managed by " + npcCommands.getPluginName() + " plugin\n\n\u00a77" + npcCommands.getHover() + "\n\n" + CommandUtils.c() : null, npcCommands.isEnabled() ? new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, npcCommands.getCommand()) : null).send(player);
            ++aas;
        }
        int ass = perpag - aas;
        for (int i = 0; i < ass; ++i) {
            player.sendMessage("");
        }
        player.sendMessage("");
        boolean next = total > pag * perpag;
        boolean previous = pag > 1;
        new ClickableText("  ").add((previous ? "\u00a7c\u00a7l" : "\u00a78\u00a7l") + "[PREVIOUS]", previous ? "\u00a7eClick to go to the previous page." : null, previous ? new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/npclib help " + (pag - 1)) : null).add("    ").add((next ? "\u00a7a\u00a7l" : "\u00a78\u00a7l") + "[NEXT]", next ? "\u00a7eClick to go to the next page." : null, next ? new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/npclib help " + (pag + 1)) : null).send(player);
        player.sendMessage("");
    }

    public static Command getCommand(String argument) {
        return commands.stream().filter(x -> x.getArgument().equalsIgnoreCase(argument)).findAny().orElse(null);
    }

    public static Set<Command> getCommands(Plugin plugin) {
        HashSet<Command> commands = new HashSet<Command>();
        commands.stream().filter(x -> x.getPlugin().equals(plugin)).forEach(x -> commands.add((Command)x));
        return commands;
    }

    public static void addCommand(Plugin plugin, String argument, String arguments, boolean enabled, boolean important, String description, String hover, BiConsumer<Command, CommandData> execute, BiFunction<Command, CommandData, List<String>> tabComplete, NPCLib.Command.Color color) {
        if (plugin.equals((Object)PlayerNPCPlugin.getInstance())) {
            throw new IllegalArgumentException("Plugin must be yours.");
        }
        new Command(plugin, argument, arguments, enabled, important, description, hover, execute, tabComplete, color);
    }

    public static String getPrefix() {
        return PlayerNPCPlugin.getInstance().getPrefix();
    }

    static {
        SETSKINUPDATEFREQUENCY = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setskinupdatefrequency", "(number) (timeUnit) [plugin]", true, false, "Set skin update frequency", "\u00a77With this command you can set the amount of time that the server will save the skin locally, and when it exceeds it, it will request it again from the Mojang API.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(number) \u00a77Amount of time it will take to update.\n\u00a78\u2022 \u00a7a(timeUnit) \u00a77Unit of time it will take to update.\n\u00a78\u2022 \u00a7a[plugin] \u00a77Name of the registered plugin.\n\u00a78TimeUnit: \u00a77seconds, minutes, hours, days", (command, data) -> {
            if (data.getCommandArgs().length < 2) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            if (!MathUtils.isInteger(data.getCommandArgs()[0])) {
                CommandUtils.error(data.getCommandSender(), "No valid number entered");
                return;
            }
            Integer number = Integer.valueOf(data.getCommandArgs()[0]);
            TimeUnit timeUnit = null;
            try {
                timeUnit = TimeUnit.valueOf(data.getCommandArgs()[1].toUpperCase());
            }
            catch (Exception e) {
                CommandUtils.error(data.getCommandSender(), "No valid time unit entered");
            }
            Plugin plugin = command.getPlugin();
            if (data.getCommandArgs().length > 1) {
                plugin = Bukkit.getPluginManager().getPlugin(data.getCommandArgs()[1]);
                if (plugin == null) {
                    CommandUtils.error(data.getCommandSender(), "This plugin is not running on this server.");
                    return;
                }
                if (!NPCLib.getInstance().isRegistered(plugin)) {
                    CommandUtils.error(data.getCommandSender(), "This plugin is not registered on the NPCLib.");
                    return;
                }
            }
            NPCLib.PluginManager pluginManager = NPCLib.getInstance().getPluginManager(plugin);
            pluginManager.setSkinUpdateFrequency(new NPCLib.SkinUpdateFrequency(number, timeUnit));
            CommandUtils.sendMessage(data.getCommandSender(), "Skin update frequency has been set as \u00a7a" + number + " " + timeUnit.name().toLowerCase() + (String)(!plugin.equals(command.getPlugin()) ? " \u00a77for the plugin \u00a7a" + plugin.getName() : "") + "\u00a77.");
        }, (command, data) -> {
            if (data.getCommandArgs().length > 3) {
                return null;
            }
            ArrayList strings = new ArrayList();
            if (data.getCommandArgs().length == 2) {
                Arrays.asList("seconds", "minutes", "hours", "days").stream().filter(x -> x.startsWith(data.getCommandArgs()[1].toLowerCase())).forEach(x -> strings.add(x.toLowerCase()));
            }
            if (data.getCommandArgs().length == 3) {
                NPCLib.getInstance().getRegisteredPlugins().stream().filter(x -> x.getName().toLowerCase().startsWith(data.getCommandArgs()[2].toLowerCase())).forEach(x -> strings.add(x.getName()));
            }
            return strings;
        });
        SETUPDATEGAZETICKS = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setupdategazeticks", "(ticks) [plugin]", true, false, "Set update gaze ticks", "\u00a77With this command you can set the ticks that the server will take to update the gaze of the NPCs.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(ticks) \u00a77Number of ticks it will take to update.\n\u00a78\u2022 \u00a7a[plugin] \u00a77Name of the registered plugin.", (command, data) -> {
            if (data.getCommandArgs().length < 1) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            if (!MathUtils.isInteger(data.getCommandArgs()[0])) {
                CommandUtils.error(data.getCommandSender(), "No valid number entered");
                return;
            }
            Integer ticks = Integer.valueOf(data.getCommandArgs()[0]);
            Plugin plugin = command.getPlugin();
            if (data.getCommandArgs().length > 1) {
                plugin = Bukkit.getPluginManager().getPlugin(data.getCommandArgs()[1]);
                if (plugin == null) {
                    CommandUtils.error(data.getCommandSender(), "This plugin is not running on this server.");
                    return;
                }
                if (!NPCLib.getInstance().isRegistered(plugin)) {
                    CommandUtils.error(data.getCommandSender(), "This plugin is not registered on the NPCLib.");
                    return;
                }
            }
            NPCLib.PluginManager pluginManager = NPCLib.getInstance().getPluginManager(plugin);
            pluginManager.setUpdateGazeTicks(ticks);
            CommandUtils.sendMessage(data.getCommandSender(), "Update gaze ticks has been set to \u00a7a" + pluginManager.getUpdateGazeTicks() + " ticks" + (String)(!plugin.equals(command.getPlugin()) ? " \u00a77for the plugin \u00a7a" + plugin.getName() : "") + "\u00a77.");
        }, (command, data) -> {
            if (data.getCommandArgs().length != 2) {
                return null;
            }
            ArrayList strings = new ArrayList();
            NPCLib.getInstance().getRegisteredPlugins().stream().filter(x -> x.getName().toLowerCase().startsWith(data.getCommandArgs()[1].toLowerCase())).forEach(x -> strings.add(x.getName()));
            return strings;
        });
        SETUPDATEGAZETYPE = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setupdategazetype", "(type) [plugin]", true, false, "Set update gaze type", "\u00a77With this command you can set the type of gaze update of the NPC's.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(type) \u00a77Gaze Update Type.\n\u00a78\u2022 \u00a7a[plugin] \u00a77Name of the registered plugin.\n\u00a78GazeUpdateType: \u00a77move_event, ticks", (command, data) -> {
            if (data.getCommandArgs().length < 1) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            NPCLib.UpdateGazeType type = null;
            try {
                type = NPCLib.UpdateGazeType.valueOf(data.getCommandArgs()[0].toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (type == null) {
                CommandUtils.error(data.getCommandSender(), "No valid update gaze type entered");
                return;
            }
            Plugin plugin = command.getPlugin();
            if (data.getCommandArgs().length > 1) {
                plugin = Bukkit.getPluginManager().getPlugin(data.getCommandArgs()[1]);
                if (plugin == null) {
                    CommandUtils.error(data.getCommandSender(), "This plugin is not running on this server.");
                    return;
                }
                if (!NPCLib.getInstance().isRegistered(plugin)) {
                    CommandUtils.error(data.getCommandSender(), "This plugin is not registered on the NPCLib.");
                    return;
                }
            }
            NPCLib.PluginManager pluginManager = NPCLib.getInstance().getPluginManager(plugin);
            pluginManager.setUpdateGazeType(type);
            CommandUtils.sendMessage(data.getCommandSender(), "Update gaze type has been set to \u00a7a" + type.toString().toLowerCase().replaceAll("_", " ") + (String)(!plugin.equals(command.getPlugin()) ? " \u00a77for the plugin \u00a7a" + plugin.getName() : "") + "\u00a77.");
        }, (command, data) -> {
            if (data.getCommandArgs().length > 2) {
                return null;
            }
            ArrayList strings = new ArrayList();
            if (data.getCommandArgs().length == 1) {
                Arrays.stream(NPCLib.UpdateGazeType.values()).toList().stream().filter(x -> x.name().toLowerCase().startsWith(data.getCommandArgs()[0].toLowerCase())).forEach(x -> strings.add(x.name().toLowerCase()));
            }
            if (data.getCommandArgs().length == 2) {
                NPCLib.getInstance().getRegisteredPlugins().stream().filter(x -> x.getName().toLowerCase().startsWith(data.getCommandArgs()[1].toLowerCase())).forEach(x -> strings.add(x.getName()));
            }
            return strings;
        });
        SETTICKSUNTILTABLISTHIDE = new Command((Plugin)PlayerNPCPlugin.getInstance(), "settitcksuntiltablisthide", "(ticks) [plugin]", true, false, "Set ticks until tablist hide", "\u00a77With this command you can set the ticks that it will take for the NPCs to disappear from the tablist.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(ticks) \u00a77Number of ticks it will take to hide.\n\u00a78\u2022 \u00a7a[plugin] \u00a77Name of the registered plugin.", (command, data) -> {
            if (data.getCommandArgs().length < 1) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            if (!MathUtils.isInteger(data.getCommandArgs()[0])) {
                CommandUtils.error(data.getCommandSender(), "No valid number entered");
                return;
            }
            Integer ticks = Integer.valueOf(data.getCommandArgs()[0]);
            Plugin plugin = command.getPlugin();
            if (data.getCommandArgs().length > 1) {
                plugin = Bukkit.getPluginManager().getPlugin(data.getCommandArgs()[1]);
                if (plugin == null) {
                    CommandUtils.error(data.getCommandSender(), "This plugin is not running on this server.");
                    return;
                }
                if (!NPCLib.getInstance().isRegistered(plugin)) {
                    CommandUtils.error(data.getCommandSender(), "This plugin is not registered on the NPCLib.");
                    return;
                }
            }
            NPCLib.PluginManager pluginManager = NPCLib.getInstance().getPluginManager(plugin);
            pluginManager.setTicksUntilTabListHide(ticks);
            CommandUtils.sendMessage(data.getCommandSender(), "Ticks until tablist hide has been set to \u00a7a" + pluginManager.getTicksUntilTabListHide() + " ticks" + (String)(!plugin.equals(command.getPlugin()) ? " \u00a77for the plugin \u00a7a" + plugin.getName() : "") + "\u00a77.");
        }, (command, data) -> {
            if (data.getCommandArgs().length != 2) {
                return null;
            }
            ArrayList strings = new ArrayList();
            NPCLib.getInstance().getRegisteredPlugins().stream().filter(x -> x.getName().toLowerCase().startsWith(data.getCommandArgs()[1].toLowerCase())).forEach(x -> strings.add(x.getName()));
            return strings;
        });
        SETDEBUG = new Command((Plugin)PlayerNPCPlugin.getInstance(), "setdebug", "(boolean)", true, false, "Set debug mode", "\u00a77With this command you can enable or disable debug mode.\n\u00a7cThis is only for developers.\n\n\u00a77Variables:\n\u00a78\u2022 \u00a7a(boolean) \u00a77Value that can be true or false.", (command, data) -> {
            if (data.getCommandArgs().length < 1) {
                CommandUtils.notEnoughArguments(command, data);
                return;
            }
            Boolean debug = Boolean.parseBoolean(data.getCommandArgs()[0]);
            if (data.getNPCLib().isDebug() == debug.booleanValue()) {
                CommandUtils.error(data.getCommandSender(), "Debug mode was " + debug + " yet.");
                return;
            }
            data.getNPCLib().setDebug(debug);
            CommandUtils.sendMessage(data.getCommandSender(), "Debug mode has been set to " + CommandUtils.b(debug) + "\u00a77.");
        }, (command, data) -> {
            if (data.getArgs().length != 2) {
                return null;
            }
            ArrayList strings = new ArrayList();
            Arrays.asList("true", "false").stream().filter(x -> x.startsWith(data.getArgs()[1].toLowerCase())).forEach(x -> strings.add(x));
            return strings;
        });
        skinKey = new NamespacedKey((Plugin)PlayerNPCPlugin.getInstance(), "skinKey");
    }

    public class CommandData {
        private final CommandSender commandSender;
        private final String[] args;
        private final String[] cmdArgs;
        private final NPCLib npcLib;

        public CommandData(CommandSender commandSender, String[] args, NPCLib npcLib) {
            this.commandSender = commandSender;
            this.args = args;
            this.npcLib = npcLib;
            this.cmdArgs = new String[args.length - 1];
            for (int i = 1; i < args.length; ++i) {
                this.cmdArgs[i - 1] = args[i];
            }
        }

        public String getCommand() {
            if (this.args.length < 1) {
                return null;
            }
            return this.args[0];
        }

        public NPCLib getNPCLib() {
            return this.npcLib;
        }

        public Player getPlayerSender() {
            if (this.commandSender instanceof Player) {
                return (Player)this.commandSender;
            }
            return null;
        }

        public CommandSender getCommandSender() {
            return this.commandSender;
        }

        public String[] getArgs() {
            return this.args;
        }

        public String[] getCommandArgs() {
            return this.cmdArgs;
        }
    }

    public static class Command {
        private String argument;
        private String arguments;
        private boolean important;
        private boolean enabled;
        private String title;
        private String hover;
        private BiConsumer<Command, CommandData> execute;
        private BiFunction<Command, CommandData, List<String>> tabComplete;
        private Plugin plugin;
        private NPCLib.Command.Color color;

        protected Command(Plugin plugin, String argument, String arguments, boolean enabled, boolean important, String title, String hover, BiConsumer<Command, CommandData> execute, BiFunction<Command, CommandData, List<String>> tabComplete, NPCLib.Command.Color color) {
            if (NPCLibCommand.getCommand(argument) != null) {
                throw new IllegalArgumentException("Argument is already used.");
            }
            this.plugin = plugin;
            this.argument = argument;
            this.arguments = arguments;
            this.enabled = enabled;
            this.important = important;
            this.title = title;
            this.hover = hover;
            this.execute = execute;
            this.tabComplete = tabComplete;
            this.color = color;
            commands.add(this);
        }

        protected Command(Plugin plugin, String argument, String arguments, boolean enabled, boolean important, String title, String hover, BiConsumer<Command, CommandData> execute, BiFunction<Command, CommandData, List<String>> tabComplete) {
            this(plugin, argument, arguments, enabled, important, title, hover, execute, tabComplete, null);
        }

        public String getArgument() {
            return this.argument;
        }

        public String getArguments() {
            return this.arguments;
        }

        public boolean isImportant() {
            return this.important;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isCustom() {
            return !(this.plugin instanceof PlayerNPCPlugin);
        }

        public Plugin getPlugin() {
            return this.plugin;
        }

        public String getPluginName() {
            return this.getPlugin().getName();
        }

        public NPCLib.PluginManager getPluginManager() {
            return NPCLib.getInstance().getPluginManager(this.plugin);
        }

        public String getTitle() {
            return this.title;
        }

        public String getHover() {
            return this.hover;
        }

        public BiConsumer<Command, CommandData> getExecute() {
            return this.execute;
        }

        public BiFunction<Command, CommandData, List<String>> getTabComplete() {
            return this.tabComplete;
        }

        public NPCLib.Command.Color getColor() {
            return this.color == null ? this.getPluginManager().getCommandColor() : this.color;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getCommand() {
            return "/npclib " + this.argument + (String)(this.arguments != null ? " " + this.arguments : "");
        }

        public String getCommand(String arguments) {
            return "/npclib " + this.argument + (String)(arguments != null ? " " + arguments : "");
        }
    }
}

