/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.command;

import dev.sergiferry.playernpc.PlayerNPCPlugin;
import dev.sergiferry.playernpc.command.NPCLibCommand;
import dev.sergiferry.playernpc.command.global.NPCGlobalCommand;
import dev.sergiferry.playernpc.utils.ClickableText;
import dev.sergiferry.playernpc.utils.TimerUtils;
import java.util.List;
import net.md_5.bungee.api.chat.ClickEvent;
import org.bukkit.command.CommandSender;

public class CommandUtils {
    public static final String errorPrefix = "\u00a7c\u00a7lError \u00a78| \u00a77";

    public static String getPrefix() {
        return PlayerNPCPlugin.getInstance().getPrefix();
    }

    public static void error(CommandSender sender) {
        CommandUtils.error(sender, "Invalid command.");
    }

    public static void error(CommandSender sender, String text) {
        sender.sendMessage(errorPrefix + text);
    }

    public static void errorNotValidID(CommandSender sender, String id) {
        CommandUtils.error(sender, "The ID \u00a7e" + id.toLowerCase() + " \u00a77is not valid. Make sure to not use symbols.");
    }

    public static void sendMessage(CommandSender sender, String text) {
        sender.sendMessage(CommandUtils.getPrefix() + text);
    }

    public static void error(CommandSender sender, String text, String hover, ClickEvent.Action action, String value) {
        new ClickableText(errorPrefix + text, hover, action, value).send(sender);
    }

    public static void errorSuggestCommand(CommandSender sender, String text, String suggestedCommand) {
        CommandUtils.error(sender, text, CommandUtils.c(), ClickEvent.Action.SUGGEST_COMMAND, suggestedCommand);
    }

    public static void notEnoughArguments(NPCGlobalCommand.Command command, NPCGlobalCommand.CommandData data) {
        CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand(data.getGlobal()));
    }

    public static void notEnoughArguments(NPCLibCommand.Command command, NPCLibCommand.CommandData data) {
        CommandUtils.error(data.getCommandSender(), "Use " + command.getCommand());
    }

    public static String getTimeConversionMillisecondsToSeconds(long ms) {
        return CommandUtils.getTimeConversionToSeconds(ms + " ms", TimerUtils.getSecondsFromMilliseconds(ms));
    }

    public static String getTimeConversionTicksToSeconds(long ticks) {
        return CommandUtils.getTimeConversionToSeconds(ticks + " ticks", TimerUtils.getSecondsFromTicks(ticks));
    }

    public static String getTimeConversionToSeconds(String from, Double seconds) {
        return CommandUtils.getTimeConversion(from, seconds + " seconds");
    }

    public static String getTimeConversion(String from, String to) {
        return "\u00a7e\u00a7lTime conversion\n\u00a7e\u00a77" + from + " \u00a7e\u25b6 \u00a77" + to;
    }

    public static String t() {
        return "\u00a7a\u2714 \u00a77";
    }

    public static String f() {
        return "\u00a7c\u2718 \u00a77";
    }

    public static String n() {
        return "\u00a7e\u2666 \u00a77";
    }

    public static String w() {
        return "\u00a7e\u26a0 \u00a7c";
    }

    public static String i(boolean b) {
        return b ? CommandUtils.t() : CommandUtils.f();
    }

    public static String b(boolean b) {
        return b ? "\u00a7atrue" : "\u00a7cfalse";
    }

    public static String ba(boolean b) {
        return b ? "\u00a7aOn" : "\u00a7cOff";
    }

    public static String c() {
        return "\u00a7eClick to write this command.";
    }

    public static String cN() {
        return "\u00a7cThis command is currently not enabled.";
    }

    public static String ts(List<String> lines) {
        Object s = "";
        for (String a : lines) {
            s = (String)s + "\u00a77, " + a;
        }
        s = ((String)s).replaceFirst("\u00a77, ", "");
        return s;
    }
}

