/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.api;

import dev.sergiferry.playernpc.PlayerNPCPlugin;
import dev.sergiferry.playernpc.api.NPC;
import dev.sergiferry.playernpc.command.NPCLibCommand;
import dev.sergiferry.playernpc.command.global.NPCGlobalCommand;
import dev.sergiferry.playernpc.integration.IntegrationsManager;
import dev.sergiferry.playernpc.nms.minecraft.NMSEntity;
import dev.sergiferry.playernpc.nms.minecraft.NMSNetworkManager;
import dev.sergiferry.playernpc.nms.spigot.NMSFileConfiguration;
import dev.sergiferry.playernpc.utils.EnumUtils;
import dev.sergiferry.spigot.nms.NMSUtils;
import dev.sergiferry.spigot.server.ServerVersion;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.world.EnumHand;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class NPCLib
implements Listener {
    private static NPCLib instance;
    private final PlayerNPCPlugin plugin;
    protected final Registry<NPC.Global> globalNPCs;
    private final HashMap<Player, PlayerManager> playerManager;
    private final HashMap<Plugin, PluginManager> pluginManager;
    private FileConfiguration config;
    private boolean usePacketScoreboards;
    private boolean debug;

    private NPCLib(@Nonnull PlayerNPCPlugin plugin) {
        instance = this;
        this.plugin = plugin;
        this.playerManager = new HashMap();
        this.globalNPCs = new Registry(Registry.ID.playerNPC("globalNPCs"));
        this.pluginManager = new HashMap();
        this.debug = false;
        this.usePacketScoreboards = false;
        this.registerPlugin((Plugin)plugin);
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public PluginManager registerPlugin(@Nonnull Plugin plugin) {
        Validate.notNull((Object)plugin, (String)"Cannot register plugin manager from a null plugin.");
        Validate.isTrue((!this.pluginManager.containsKey(plugin) ? 1 : 0) != 0, (String)"This plugin is already registered.");
        PluginManager pluginManager = new PluginManager(plugin, this);
        this.pluginManager.put(plugin, pluginManager);
        Bukkit.getConsoleSender().sendMessage(this.plugin.getPrefix() + "\u00a77Registered \u00a7e" + plugin.getName() + " \u00a77plugin into the NPCLib");
        if (plugin != PlayerNPCPlugin.getInstance()) {
            if (this.config == null) {
                return pluginManager;
            }
            if (plugin.getDescription().getAuthors().isEmpty()) {
                return pluginManager;
            }
            if (!((String)plugin.getDescription().getAuthors().get(0)).equals(PlayerNPCPlugin.getInstance().getDescription().getAuthors().get(0))) {
                PlayerNPCPlugin.getInstance().cancelAutomaticDownload();
            }
        }
        return pluginManager;
    }

    public void unregisterPlugin(@Nonnull Plugin plugin) {
        Validate.notNull((Object)plugin, (String)"Cannot register plugin manager from a null plugin.");
        Validate.isTrue((boolean)this.pluginManager.containsKey(plugin), (String)"This plugin is not registered.");
        this.getPluginManager(plugin).onUnregister();
        this.pluginManager.remove(plugin);
        Bukkit.getConsoleSender().sendMessage(this.plugin.getPrefix() + "\u00a77Unregistered \u00a76" + plugin.getName() + " \u00a77plugin from the NPCLib");
    }

    public boolean isRegistered(@Nonnull Plugin plugin) {
        Validate.notNull((Object)plugin, (String)"Cannot verify plugin manager from a null plugin.");
        return this.pluginManager.containsKey(plugin);
    }

    public PluginManager getPluginManager(@Nonnull Plugin plugin) {
        Validate.notNull((Object)plugin, (String)"Cannot get plugin manager from a null plugin.");
        Validate.isTrue((boolean)this.pluginManager.containsKey(plugin), (String)"This plugin is not registered.");
        return this.pluginManager.get(plugin);
    }

    public List<Plugin> getRegisteredPlugins() {
        return this.pluginManager.keySet().stream().toList();
    }

    public NPC.Personal generatePersonalNPC(@Nonnull Player player, @Nonnull Plugin plugin, @Nonnull String simpleID, @Nonnull Location location) {
        Validate.notNull((Object)player, (String)"You cannot create an NPC with a null Player");
        Validate.notNull((Object)plugin, (String)"You cannot create an NPC with a null Plugin");
        Validate.isTrue((boolean)this.isRegistered(plugin), (String)"This plugin is not registered on NPCLib");
        Validate.notNull((Object)simpleID, (String)"You cannot create an NPC with a null simpleID");
        Validate.notNull((Object)location, (String)"You cannot create an NPC with a null Location");
        Validate.notNull((Object)location.getWorld(), (String)"You cannot create NPC with a null world");
        Validate.isTrue((!simpleID.toLowerCase().startsWith("global_") ? 1 : 0) != 0, (String)"You cannot create NPC with global tag");
        return this.getPluginManager(plugin).generatePlayerPersonalNPC(player, Registry.ID.of(plugin, simpleID), location);
    }

    public NPC.Global generateGlobalNPC(@Nonnull Plugin plugin, @Nonnull String simpleID, @Nonnull NPC.Global.Visibility visibility, @Nonnull Location location) {
        return this.generateGlobalNPC(plugin, simpleID, visibility, null, location);
    }

    public NPC.Global generateGlobalNPC(@Nonnull Plugin plugin, @Nonnull String simpleID, @Nullable Predicate<Player> visibilityRequirement, @Nonnull Location location) {
        return this.generateGlobalNPC(plugin, simpleID, NPC.Global.Visibility.EVERYONE, visibilityRequirement, location);
    }

    public NPC.Global generateGlobalNPC(@Nonnull Plugin plugin, @Nonnull String simpleID, @Nonnull Location location) {
        return this.generateGlobalNPC(plugin, simpleID, NPC.Global.Visibility.EVERYONE, null, location);
    }

    public NPC.Global generateGlobalNPC(@Nonnull Plugin plugin, @Nonnull String simpleID, @Nonnull NPC.Global.Visibility visibility, @Nullable Predicate<Player> visibilityRequirement, @Nonnull Location location) {
        Validate.notNull((Object)plugin, (String)"You cannot create an NPC with a null Plugin");
        Validate.notNull((Object)simpleID, (String)"You cannot create an NPC with a null simple ID");
        Validate.notNull((Object)((Object)visibility), (String)"You cannot create an NPC with a null visibility");
        Validate.notNull((Object)location, (String)"You cannot create an NPC with a null Location");
        Validate.notNull((Object)location.getWorld(), (String)"You cannot create NPC with a null world");
        Validate.isTrue((boolean)this.isRegistered(plugin), (String)"This plugin is not registered on NPCLib");
        return this.getPluginManager(plugin).generatePlayerGlobalNPC(Registry.ID.of(plugin, simpleID), visibility, visibilityRequirement, location);
    }

    @Deprecated
    public Optional<NPC.Personal> grabPersonalNPC(@Nonnull Player player, @Nonnull String fullID) {
        return this.grabPersonalNPC(player, Registry.ID.of(fullID));
    }

    public Optional<NPC.Personal> grabPersonalNPC(@Nonnull Player player, @Nonnull Plugin plugin, @Nonnull String simpleID) {
        return this.grabPersonalNPC(player, Registry.ID.of(plugin, simpleID));
    }

    public Optional<NPC.Personal> grabPersonalNPC(@Nonnull Player player, @Nonnull Registry.ID id) {
        return this.getNPCPlayerManager(player).grabNPC(id);
    }

    @Deprecated
    @Nullable
    public NPC.Personal getPersonalNPC(@Nonnull Player player, @Nonnull Plugin plugin, @Nonnull String simpleID) {
        return this.getPersonalNPC(player, Registry.ID.of(plugin, simpleID));
    }

    @Deprecated
    @Nullable
    public NPC.Personal getPersonalNPC(@Nonnull Player player, @Nonnull String fullID) {
        return this.getPersonalNPC(player, Registry.ID.of(fullID));
    }

    @Deprecated
    @Nullable
    public NPC.Personal getPersonalNPC(@Nonnull Player player, @Nonnull Registry.ID id) {
        return this.grabPersonalNPC(player, id).orElse(null);
    }

    @Nonnull
    public Set<NPC.Personal> getPersonalNPCs(@Nonnull Player player, @Nonnull Plugin plugin) {
        Validate.notNull((Object)player, (String)"Player must not be null");
        Validate.notNull((Object)plugin, (String)"Plugin must not be null");
        return this.getNPCPlayerManager(player).getNPCs(plugin);
    }

    @Nonnull
    public Set<NPC.Personal> getPersonalNPCs(@Nonnull Plugin plugin) {
        Validate.notNull((Object)plugin, (String)"Plugin must not be null");
        HashSet<NPC.Personal> set = new HashSet<NPC.Personal>();
        Bukkit.getOnlinePlayers().forEach(x -> set.addAll(this.getPersonalNPCs((Player)x, plugin)));
        return set;
    }

    @Nonnull
    public Set<NPC.Personal> getPersonalNPCs(@Nonnull Player player, @Nonnull World world) {
        Validate.notNull((Object)player, (String)"Player must not be null");
        Validate.notNull((Object)world, (String)"World must not be null");
        return this.getNPCPlayerManager(player).getNPCs(world);
    }

    @Nonnull
    public Set<NPC.Personal> getAllPersonalNPCs(@Nonnull Player player) {
        return this.getNPCPlayerManager(player).getNPCs();
    }

    public boolean hasPersonalNPC(@Nonnull Player player, @Nonnull Plugin plugin, @Nonnull String simpleID) {
        Validate.notNull((Object)plugin, (String)"Plugin must not be null");
        Validate.notNull((Object)simpleID, (String)"NPC simpleID must not be null");
        return this.hasPersonalNPC(player, Registry.ID.of(plugin, simpleID));
    }

    @Deprecated
    public boolean hasPersonalNPC(@Nonnull Player player, @Nonnull String fullID) {
        return this.hasPersonalNPC(player, Registry.ID.of(fullID));
    }

    public boolean hasPersonalNPC(@Nonnull Player player, @Nonnull Registry.ID id) {
        Validate.notNull((Object)player, (String)"Player must not be null");
        Validate.notNull((Object)id, (String)"NPC id must not be null");
        return this.getNPCPlayerManager((Player)player).personalNPCs.contains(id);
    }

    public void removePersonalNPC(@Nonnull Player player, @Nonnull Plugin plugin, @Nonnull String id) {
        Validate.notNull((Object)player, (String)"Player must not be null");
        Validate.notNull((Object)player, (String)"Plugin must not be null");
        Validate.notNull((Object)id, (String)"NPC id must not be null");
        this.removePersonalNPC(this.getPersonalNPC(player, plugin, id));
    }

    public void removePersonalNPC(@Nonnull NPC.Personal npc) {
        Validate.notNull((Object)npc, (String)"NPC was not found");
        if (npc.hasGlobal() && npc.getGlobal().hasPlayer(npc.getPlayer())) {
            npc.getGlobal().removePlayer(npc.getPlayer());
            return;
        }
        npc.destroy();
        this.getNPCPlayerManager(npc.getPlayer()).removeNPC(npc.getID());
    }

    @Deprecated
    @Nullable
    public NPC.Global getGlobalNPC(@Nonnull Plugin plugin, @Nonnull String id) {
        return this.grabGlobalNPC(plugin, id).orElse(null);
    }

    @Deprecated
    @Nullable
    public NPC.Global getGlobalNPC(@Nonnull Registry.ID id) {
        return this.grabGlobalNPC(id).orElse(null);
    }

    @Deprecated
    @Nullable
    public NPC.Global getGlobalNPC(@Nonnull String fullID) {
        return this.grabGlobalNPC(fullID).orElse(null);
    }

    public Optional<NPC.Global> grabGlobalNPC(@Nonnull Plugin plugin, @Nonnull String id) {
        return this.grabGlobalNPC(Registry.ID.of(plugin, id));
    }

    public Optional<NPC.Global> grabGlobalNPC(@Nonnull Registry.ID id) {
        return this.globalNPCs.grab(id);
    }

    @Deprecated
    public Optional<NPC.Global> grabGlobalNPC(@Nonnull String fullID) {
        return this.grabGlobalNPC(Registry.ID.of(fullID));
    }

    public boolean hasGlobalNPC(@Nonnull Plugin plugin, @Nonnull String simpleID) {
        return this.hasGlobalNPC(Registry.ID.of(plugin, simpleID));
    }

    public boolean hasGlobalNPC(@Nonnull Registry.ID id) {
        return this.globalNPCs.contains(id);
    }

    @Deprecated
    public boolean hasGlobalNPC(@Nonnull String fullID) {
        return this.hasGlobalNPC(Registry.ID.of(fullID));
    }

    public Set<NPC.Global> getAllGlobalNPCs() {
        return Set.copyOf(this.globalNPCs.getValues());
    }

    public Set<NPC.Global> getAllGlobalNPCs(@Nonnull Plugin plugin) {
        Validate.notNull((Object)plugin, (String)"Plugin must not be null");
        HashSet<NPC.Global> npcs = new HashSet<NPC.Global>();
        this.globalNPCs.getValues().stream().filter(x -> x.getPlugin().equals(plugin)).forEach(x -> npcs.add((NPC.Global)x));
        return npcs;
    }

    public void addGlobalCommand(Plugin plugin, String argument, String arguments, boolean enabled, boolean important, String description, String hover, BiConsumer<NPCGlobalCommand.Command, NPCGlobalCommand.CommandData> execute, BiFunction<NPCGlobalCommand.Command, NPCGlobalCommand.CommandData, List<String>> tabComplete, Command.Color color) {
        if (plugin.equals((Object)this.plugin)) {
            throw new IllegalArgumentException("Plugin must be yours.");
        }
        NPCGlobalCommand.addCommand(plugin, argument, arguments, enabled, important, description, hover, execute, tabComplete, color);
    }

    public boolean hasGlobalCommand(String argument) {
        return this.getGlobalCommand(argument) != null;
    }

    public NPCGlobalCommand.Command getGlobalCommand(String argument) {
        return NPCGlobalCommand.getCommand(argument);
    }

    public Set<NPCGlobalCommand.Command> getGlobalCommands(Plugin plugin) {
        return NPCGlobalCommand.getCommands(plugin);
    }

    public void removeGlobalNPC(@Nonnull NPC.Global npc) {
        Validate.notNull((Object)npc, (String)"NPC was not found");
        npc.destroy();
        this.globalNPCs.remove(npc.getID());
    }

    public void removeNPC(@Nonnull NPC npc) {
        Validate.notNull((Object)npc, (String)"NPC was not found");
        if (npc instanceof NPC.Personal) {
            this.removePersonalNPC((NPC.Personal)npc);
        } else if (npc instanceof NPC.Global) {
            this.removeGlobalNPC((NPC.Global)npc);
        }
    }

    public void setDebug(boolean debug) {
        if (this.debug == debug) {
            return;
        }
        this.debug = debug;
        this.saveConfig();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isUsingPacketScoreboards() {
        return this.usePacketScoreboards;
    }

    public void setUsePacketScoreboards(boolean usePacketScoreboards) {
        if (this.usePacketScoreboards == usePacketScoreboards) {
            return;
        }
        this.usePacketScoreboards = usePacketScoreboards;
        this.saveConfig();
    }

    @Deprecated
    public Double getDefaultHideDistance() {
        return NPC.Attributes.getDefaultHideDistance();
    }

    @Deprecated
    public void setDefaultHideDistance(Double hideDistance) {
        NPC.Attributes.setDefaultHideDistance(hideDistance);
    }

    public NPC.Attributes getDefaults() {
        return NPC.Attributes.getDefault();
    }

    protected Plugin getPlugin() {
        return this.plugin;
    }

    private File checkFileExists() {
        File file = new File("plugins/PlayerNPC/config.yml");
        boolean exist = file.exists();
        if (!exist) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                DebugManager.printError(e);
            }
        }
        return file;
    }

    public void loadConfig() {
        File file = this.checkFileExists();
        this.config = YamlConfiguration.loadConfiguration((File)file);
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put("debug", this.debug);
        defaults.put("usePacketScoreboards", this.usePacketScoreboards);
        defaults.put("gazeUpdate.ticks", this.getPluginManager((Plugin)this.plugin).updateGazeTicks);
        defaults.put("gazeUpdate.type", this.getPluginManager((Plugin)this.plugin).updateGazeType.name());
        defaults.put("tabListHide.ticks", this.getPluginManager((Plugin)this.plugin).ticksUntilTabListHide);
        defaults.put("skinUpdate.frequency", this.getPluginManager((Plugin)this.plugin).skinUpdateFrequency);
        boolean m = false;
        for (String s : defaults.keySet()) {
            if (this.config.contains(s)) continue;
            this.config.set(s, defaults.get(s));
            m = true;
        }
        NMSFileConfiguration.setComments(this.config, "gazeUpdate.type", Arrays.asList("GazeUpdateType: MOVE_EVENT, TICKS"));
        NMSFileConfiguration.setComments(this.config, "skinUpdate.frequency", Arrays.asList("TimeUnit: SECONDS, MINUTES, HOURS, DAYS"));
        NMSFileConfiguration.setComments(this.config, "usePacketScoreboards", Arrays.asList("This option should only be enabled in case there is incompatibility with another plugin, in the scoreboard system."));
        if (this.config.contains("useBukkitScoreboards")) {
            this.config.set("useBukkitScoreboards", null);
        }
        if (m) {
            try {
                this.config.save(file);
            }
            catch (IOException e) {
                DebugManager.printError(e);
            }
        }
        this.debug = this.config.getBoolean("debug");
        this.usePacketScoreboards = this.config.getBoolean("usePacketScoreboards");
        this.getPluginManager((Plugin)this.plugin).ticksUntilTabListHide = this.config.getInt("tabListHide.ticks");
        this.getPluginManager((Plugin)this.plugin).skinUpdateFrequency = (SkinUpdateFrequency)this.config.getObject("skinUpdate.frequency", SkinUpdateFrequency.class);
        this.getPluginManager((Plugin)this.plugin).updateGazeTicks = this.config.getInt("gazeUpdate.ticks");
        this.getPluginManager((Plugin)this.plugin).updateGazeType = UpdateGazeType.valueOf(this.config.getString("gazeUpdate.type"));
        this.getPluginManager((Plugin)this.plugin).runGazeUpdate();
    }

    public void saveConfig() {
        if (this.config == null) {
            return;
        }
        File file = this.checkFileExists();
        this.config.set("debug", (Object)this.debug);
        this.config.set("usePacketScoreboards", (Object)this.usePacketScoreboards);
        this.config.set("gazeUpdate.ticks", (Object)this.getPluginManager((Plugin)this.plugin).updateGazeTicks);
        this.config.set("gazeUpdate.type", (Object)this.getPluginManager((Plugin)this.plugin).updateGazeType.name());
        this.config.set("tabListHide.ticks", (Object)this.getPluginManager((Plugin)this.plugin).ticksUntilTabListHide);
        this.config.set("skinUpdate.frequency", (Object)this.getPluginManager((Plugin)this.plugin).skinUpdateFrequency);
        try {
            this.config.save(file);
        }
        catch (IOException e) {
            DebugManager.printError(e);
        }
    }

    private void onEnable(PlayerNPCPlugin playerNPCPlugin) {
        this.getPluginManager((Plugin)playerNPCPlugin).onEnable();
        Bukkit.getScheduler().runTaskLater(this.getPlugin(), () -> playerNPCPlugin.getServer().getOnlinePlayers().forEach(x -> {
            this.join((Player)x);
            for (NPC.Global global : this.getAllGlobalNPCs()) {
                if (!global.isActive((Player)x)) continue;
                global.forceUpdate();
            }
        }), 1L);
    }

    private void onDisable(PlayerNPCPlugin playerNPCPlugin) {
        playerNPCPlugin.getServer().getOnlinePlayers().forEach(x -> this.quit((Player)x, true));
    }

    private PlayerNPCPlugin getPlayerNPCPlugin() {
        return this.plugin;
    }

    protected PlayerManager getNPCPlayerManager(@Nonnull Player player) {
        Validate.notNull((Object)player, (String)"Cannot get PlayerManager from a null Player");
        if (this.playerManager.containsKey(player)) {
            return this.playerManager.get(player);
        }
        PlayerManager npcPlayerManager = new PlayerManager(this, player);
        this.playerManager.put(player, npcPlayerManager);
        return npcPlayerManager;
    }

    private void join(Player player) {
        PlayerManager npcPlayerManager = this.getNPCPlayerManager(player);
        PlayerManager.PacketReader reader = npcPlayerManager.getPacketReader();
        reader.inject();
        for (NPC.Global global : this.getAllGlobalNPCs()) {
            if (global.getVisibility().equals((Object)NPC.Global.Visibility.SELECTED_PLAYERS) && !global.getSelectedPlayers().contains(player.getName())) continue;
            global.addPlayer(player);
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask(this.getPlugin(), () -> {
            for (NPC.Global global : this.getAllGlobalNPCs()) {
                if (!global.hasPlayer(player)) continue;
                global.forceUpdate(player);
            }
            for (NPC.Personal personal : npcPlayerManager.getPersonalNPCs().getValues().stream().filter(x -> !x.hasGlobal()).collect(Collectors.toSet())) {
                if (!personal.isCreated() || !personal.isShown()) continue;
                personal.forceUpdate();
            }
        }, 40L);
        IntegrationsManager.getBungeeCord().check();
    }

    private void quit(Player player) {
        this.quit(player, false);
    }

    private void quit(Player player, boolean restart) {
        for (NPC.Global global : this.getAllGlobalNPCs()) {
            if (!global.hasPlayer(player)) continue;
            global.players.remove(player);
        }
        PlayerManager npcPlayerManager = this.getNPCPlayerManager(player);
        npcPlayerManager.destroyAll();
        npcPlayerManager.getPacketReader().unInject();
        if (restart && !npcPlayerManager.getClientVersion().equals((Object)ServerVersion.getServerVersion())) {
            player.kickPlayer("Restarting server...");
        }
    }

    @EventHandler
    private void onJoin(PlayerJoinEvent event) {
        this.join(event.getPlayer());
    }

    @EventHandler
    private void onQuit(PlayerQuitEvent event) {
        this.quit(event.getPlayer());
    }

    @EventHandler
    private void onTeleport(PlayerTeleportEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.getNPCPlayerManager(event.getPlayer()).updateMove();
    }

    @EventHandler
    private void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        World from = event.getFrom();
        PlayerManager npcPlayerManager = this.getNPCPlayerManager(player);
        npcPlayerManager.destroyWorld(from);
        npcPlayerManager.showWorld(event.getPlayer().getWorld());
    }

    @EventHandler
    private void onPluginDisable(PluginDisableEvent event) {
        Plugin plugin = event.getPlugin();
        if (!this.isRegistered(plugin)) {
            return;
        }
        this.unregisterPlugin(event.getPlugin());
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && !event.getAction().equals((Object)Action.RIGHT_CLICK_AIR)) {
            return;
        }
        if (!player.isSneaking()) {
            return;
        }
        if (!player.isOp()) {
            return;
        }
        if (event.getItem() == null) {
            return;
        }
        if (!event.getItem().hasItemMeta()) {
            return;
        }
        if (!event.getItem().getItemMeta().getPersistentDataContainer().has(NPCLibCommand.skinKey, PersistentDataType.STRING)) {
            return;
        }
        String skinKey = (String)event.getItem().getItemMeta().getPersistentDataContainer().get(NPCLibCommand.skinKey, PersistentDataType.STRING);
        if (event.getAction().equals((Object)Action.RIGHT_CLICK_AIR)) {
            if (!ServerVersion.getServerVersion().isNewerThan(ServerVersion.VERSION_1_18_2)) {
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7cPlayer skin change only available on 1.18.2+"));
                return;
            }
            if (skinKey.startsWith(NPC.Skin.Type.MINECRAFT.name() + ":")) {
                String skinName = skinKey.replaceFirst(NPC.Skin.Type.MINECRAFT.name() + ":", "");
                NPC.Skin.Minecraft.fetchSkinAsync((Plugin)PlayerNPCPlugin.getInstance(), skinName).thenAccept(fetchResult -> {
                    if (fetchResult.hasError()) {
                        return;
                    }
                    NPC.Skin.Minecraft skin = (NPC.Skin.Minecraft)fetchResult.grabSkin().get();
                    if (!skin.isModifiedByThirdParty()) {
                        skin.applyToPlayer(player, p -> p.sendTitle("\u00a7a", "\u00a7aYour skin has been changed to " + skin.getName(), 5, 20, 5));
                    } else {
                        NPC.Skin.Minecraft.fetchSkinMojangAsync(player.getName()).thenAccept(mojangFetchResult -> {
                            if (!mojangFetchResult.hasFound()) {
                                return;
                            }
                            NPC.Skin.Minecraft mojangSkin = (NPC.Skin.Minecraft)mojangFetchResult.grabSkin().get();
                            mojangSkin.applyToPlayer(player, p -> p.sendTitle("\u00a7a", "\u00a7aYour skin has been changed to " + mojangSkin.getName(), 5, 20, 5));
                        });
                    }
                });
            } else if (skinKey.startsWith(NPC.Skin.Type.MINESKIN.name() + ":")) {
                String skinName = skinKey.replaceFirst(NPC.Skin.Type.MINESKIN.name() + ":", "");
                NPC.Skin.MineSkin.fetchSkinAsync((Plugin)PlayerNPCPlugin.getInstance(), skinName).thenAccept(result -> {
                    if (result.hasFound()) {
                        ((NPC.Skin.MineSkin)result.grabSkin().get()).applyToPlayer(player, p -> p.sendTitle("\u00a7a", "\u00a7aYour skin has been changed to MineSkin", 5, 20, 5));
                    }
                });
            } else if (skinKey.startsWith(NPC.Skin.Type.CUSTOM.name() + ":")) {
                String skinName = skinKey.replaceFirst(NPC.Skin.Type.CUSTOM.name() + ":", "");
                NPC.Skin.Custom.fetchCustomSkinAsync(skinName).thenAccept(result -> {
                    if (result.hasFound()) {
                        ((NPC.Skin.Custom)result.grabSkin().get()).applyToPlayer(player, p -> p.sendTitle("\u00a7a", "\u00a7aYour skin has been changed to " + ((NPC.Skin.Custom)result.grabSkin().get()).getName(), 5, 20, 5));
                    }
                });
            }
            return;
        }
        if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            String simpleID = "preview_" + skinKey.replaceAll("\\.", "_");
            if (this.hasPersonalNPC(player, Registry.ID.of((Plugin)this.plugin, simpleID))) {
                return;
            }
            event.setCancelled(true);
            Registry.ID previewSeconds = Registry.ID.playerNPC("previewSecondsDisappear");
            NPC.Placeholders.addSimplePlaceholder(previewSeconds.getSimpleID(), (n, p) -> {
                Integer a = Integer.valueOf(n.grabCustomData(previewSeconds).orElse("0"));
                String color = "\u00a7a";
                if (a < 10) {
                    color = "\u00a7e";
                }
                if (a < 5) {
                    color = "\u00a7c";
                }
                return color + a;
            }, null);
            NPC.Personal preview = this.generatePersonalNPC(player, (Plugin)this.plugin, simpleID, event.getClickedBlock().getRelative(event.getBlockFace()).getLocation().add(0.5, 0.0, 0.5));
            preview.addCustomClickAction(NPC.Interact.ClickType.LEFT_CLICK, (npc, player1) -> npc.playAnimation(NPC.Animation.TAKE_DAMAGE));
            NPC.Interact.Actions.CustomAction customAction = preview.addCustomClickAction(NPC.Interact.ClickType.LEFT_CLICK, (npc, player1) -> this.cancelPreview(preview));
            customAction.setDelayTicks(3L);
            preview.setTextLineOpacity(1, NPC.Hologram.Opacity.LOW);
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7aPreviewing skin..."));
            if (skinKey.startsWith(NPC.Skin.Type.MINECRAFT.name() + ":")) {
                String skinName = skinKey.replaceFirst(NPC.Skin.Type.MINECRAFT.name() + ":", "");
                preview.setSkin(skinName, fetchResult -> {
                    if (fetchResult.hasError()) {
                        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7cThere was an error fetching that skin."));
                        this.removePersonalNPC(preview);
                        return;
                    }
                    preview.setText("\u00a77Disappears in {" + previewSeconds.getSimpleID() + "} seconds...", "", "\u00a76\u00a7lMinecraft Skin Preview", "\u00a7e" + ((NPC.Skin.Minecraft)fetchResult.grabSkin().get()).getName());
                    preview.addRunPlayerCommandClickAction(NPC.Interact.ClickType.RIGHT_CLICK, "npclib getskininfo minecraft " + ((NPC.Skin.Minecraft)fetchResult.grabSkin().get()).getName());
                    this.showPreview(preview);
                });
            } else if (skinKey.startsWith(NPC.Skin.Type.MINESKIN.name() + ":")) {
                String skinName = skinKey.replaceFirst(NPC.Skin.Type.MINESKIN.name() + ":", "");
                preview.setMineSkin(skinName, fetchResult -> {
                    if (fetchResult.hasError()) {
                        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7cThere was an error fetching that skin."));
                        this.removePersonalNPC(preview);
                        return;
                    }
                    preview.setText("\u00a77Disappears in {" + previewSeconds.getSimpleID() + "} seconds...", "", "\u00a76\u00a7lMineSkin Preview", "\u00a7e" + ((NPC.Skin.MineSkin)fetchResult.grabSkin().get()).getId());
                    preview.addRunPlayerCommandClickAction(NPC.Interact.ClickType.RIGHT_CLICK, "npclib getskininfo mineskin " + ((NPC.Skin.MineSkin)fetchResult.grabSkin().get()).getId());
                    this.showPreview(preview);
                });
            } else if (skinKey.startsWith(NPC.Skin.Type.CUSTOM.name() + ":")) {
                String skinName = skinKey.replaceFirst(NPC.Skin.Type.CUSTOM.name() + ":", "");
                NPC.Skin.Custom.fetchCustomSkinAsync(skinName).thenAccept(fetchResult -> {
                    if (fetchResult.hasError()) {
                        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7cThere was an error fetching that skin."));
                        this.removePersonalNPC(preview);
                        return;
                    }
                    preview.setSkin((NPC.Skin)fetchResult.grabSkin().get());
                    preview.setText("\u00a77Disappears in {" + previewSeconds.getSimpleID() + "} seconds...", "", "\u00a76\u00a7lCustom Skin Preview", "\u00a7e" + ((NPC.Skin.Custom)fetchResult.grabSkin().get()).getID().getFullID());
                    preview.addRunPlayerCommandClickAction(NPC.Interact.ClickType.RIGHT_CLICK, "npclib getskininfo custom " + ((NPC.Skin.Custom)fetchResult.grabSkin().get()).getID().getFullID());
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.showPreview(preview));
                });
            }
            preview.setCustomData(previewSeconds, "15");
            preview.setCustomData(Registry.ID.playerNPC("bukkitTaskID"), "" + Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
                Integer seconds;
                if (!this.hasPersonalNPC(player, (Plugin)this.plugin, simpleID)) {
                    this.cancelPreview(preview);
                    return;
                }
                Integer n = seconds = Integer.valueOf(preview.grabCustomData(previewSeconds).get());
                seconds = seconds - 1;
                preview.setCustomData(previewSeconds, seconds.toString());
                preview.simpleUpdateText();
                if (seconds == 0) {
                    this.cancelPreview(preview);
                }
            }, 20L, 20L));
        }
    }

    private void showPreview(NPC.Personal preview) {
        preview.create();
        preview.lookAt((Entity)preview.getPlayer());
        preview.show();
    }

    private void cancelPreview(NPC.Personal preview) {
        preview.getPlayer().spawnParticle(Particle.CLOUD, preview.getLocation(), 3, 0.2, 0.5, 0.2, 0.1);
        Bukkit.getScheduler().cancelTask(Integer.valueOf(preview.grabCustomData(Registry.ID.playerNPC("bukkitTaskID")).get()).intValue());
        this.removePersonalNPC(preview);
    }

    public static NPCLib getInstance() {
        Validate.notNull((Object)instance, (String)"NPCLib has not been started yet, make sure to have PlayerNPC.jar on your plugins folder, and to add dependency or softdependency to PlayerNPC on your plugin.yml");
        return instance;
    }

    public static class Registry<V> {
        private static final Map<String, Registry<?>> REGISTRY_MAP = new HashMap();
        private ID registryID;
        private HashMap<String, V> registry;

        public static Optional<Registry<?>> grabRegistry(ID id) {
            return Optional.ofNullable(REGISTRY_MAP.getOrDefault(id.getFullID(), null));
        }

        protected Registry(@Nonnull ID id) {
            Validate.notNull((Object)id, (String)"ID cannot be null");
            this.registryID = id;
            this.registry = new HashMap();
            REGISTRY_MAP.put(id.getFullID(), this);
        }

        public ID getRegistryID() {
            return this.registryID;
        }

        public Optional<V> grab(@Nonnull ID id) {
            Validate.notNull((Object)id, (String)"Cannot grab from Registry with a null ID");
            return Optional.ofNullable(this.registry.getOrDefault(id.getFullID(), null));
        }

        @Deprecated
        @Nullable
        public V get(@Nonnull ID id) {
            return this.grab(id).orElse(null);
        }

        public void set(@Nonnull ID id, @Nullable V value) {
            Validate.notNull((Object)id, (String)"Cannot set on Registry with a null ID");
            if (value == null) {
                this.remove(id);
            } else {
                this.registry.put(id.getFullID(), value);
            }
        }

        public void add(@Nonnull ID id, V value) throws IllegalArgumentException {
            Validate.notNull((Object)id, (String)"Cannot add on Registry with a null ID");
            Validate.isTrue((!this.contains(id) ? 1 : 0) != 0, (String)"There's a value for that ID already");
            this.registry.putIfAbsent(id.getFullID(), value);
        }

        public void remove(@Nonnull ID id) {
            Validate.notNull((Object)id, (String)"Cannot remove from a Registry with a null ID");
            this.registry.remove(id.getFullID());
        }

        public void clear() {
            this.registry.clear();
        }

        public Collection<V> getValues() {
            return this.registry.values();
        }

        public Set<String> getKeys() {
            return this.registry.keySet();
        }

        public Set<ID> getKeysID() {
            return this.getKeys().stream().map(x -> ID.of(x)).collect(Collectors.toSet());
        }

        public boolean contains(@Nonnull String fullID) {
            return this.registry.containsKey(fullID);
        }

        public boolean contains(@Nonnull ID id) {
            return this.contains(id.getFullID());
        }

        public boolean isEmpty() {
            return this.registry.isEmpty();
        }

        public Integer size() {
            return this.registry.size();
        }

        public Set<Map.Entry<String, V>> entrySet() {
            return this.registry.entrySet();
        }

        protected void remove() {
            this.registry = null;
            REGISTRY_MAP.remove(this.registryID);
        }

        public static class ID {
            private static final Pattern VALID_KEY = Pattern.compile("[a-z0-9/:_-]+");
            private static final Integer MAX_LENGTH = 128;
            private final String pluginName;
            private final String simpleID;
            private final String fullID;

            public static ID of(@Nonnull Plugin plugin, @Nonnull String simpleID) {
                Validate.notNull((Object)plugin, (String)"Cannot create ID from a null plugin");
                Validate.notNull((Object)simpleID, (String)"Cannot create ID from a null simple id");
                return new ID(plugin, simpleID);
            }

            public static ID of(@Nonnull Plugin plugin, @Nonnull Integer simpleID) {
                Validate.notNull((Object)plugin, (String)"Cannot create ID from a null plugin");
                Validate.notNull((Object)simpleID, (String)"Cannot create ID from a null simple id");
                return new ID(plugin, simpleID.toString());
            }

            public static ID of(@Nonnull Plugin plugin, @Nonnull UUID simpleID) {
                Validate.notNull((Object)plugin, (String)"Cannot create ID from a null plugin");
                Validate.notNull((Object)simpleID, (String)"Cannot create ID from a null simple id");
                return new ID(plugin, simpleID.toString());
            }

            public static ID of(String pluginName, String simpleID) {
                return new ID(pluginName.toLowerCase(), simpleID.toLowerCase());
            }

            protected static ID of(@Nonnull String fullID) {
                Validate.notNull((Object)fullID, (String)"Cannot parse Full ID from a null String.");
                Validate.isTrue((boolean)fullID.contains("."), (String)"This full ID is incorrect.");
                String[] split = fullID.split("\\.", 2);
                return new ID(split[0], split[1]);
            }

            protected static ID playerNPC(@Nonnull String simpleID) {
                return new ID((Plugin)PlayerNPCPlugin.getInstance(), simpleID);
            }

            public static boolean isValid(Plugin plugin, String simpleID) {
                return ID.isFullValid(plugin.getName().toLowerCase() + "." + simpleID);
            }

            public static boolean isSimpleValid(String simpleID) {
                return VALID_KEY.matcher(simpleID.toLowerCase()).matches();
            }

            public static boolean isFullValid(String fullID) {
                if (!(fullID = fullID.toLowerCase()).contains(".")) {
                    return false;
                }
                String[] split = fullID.split("\\.", 2);
                if (!ID.isSimpleValid(split[0])) {
                    return false;
                }
                return ID.isSimpleValid(split[1]);
            }

            private ID(@Nonnull Plugin plugin, @Nonnull String simpleID) {
                this(plugin.getName().toLowerCase(), simpleID.toLowerCase());
            }

            private ID(@Nonnull String pluginName, @Nonnull String simpleID) {
                Validate.notNull((Object)pluginName, (String)"Cannot generate an ID. Plugin must not be null");
                Validate.notNull((Object)simpleID, (String)"Cannot generate an ID. Simple ID must not be null");
                Validate.isTrue((boolean)VALID_KEY.matcher(pluginName).matches(), (String)("Invalid Plugin name '" + simpleID + "'. Allowed characters: ('a-z','0-9',':','_','-')"));
                Validate.isTrue((boolean)VALID_KEY.matcher(simpleID).matches(), (String)("Invalid Simple ID '" + simpleID + "'. Allowed characters: ('a-z','0-9',':','_','-')"));
                this.pluginName = pluginName;
                this.simpleID = simpleID;
                this.fullID = pluginName + "." + simpleID;
                Validate.isTrue((this.fullID.length() <= MAX_LENGTH ? 1 : 0) != 0, (String)("Full ID length cannot be more than " + MAX_LENGTH + " characters"));
            }

            public String getPluginName() {
                return this.pluginName;
            }

            public String getSimpleID() {
                return this.simpleID;
            }

            public String getFullID() {
                return this.fullID;
            }

            public boolean equals(String fullID) {
                return this.fullID.equals(fullID);
            }

            public boolean equals(ID id) {
                return this.equals(id.getFullID());
            }

            public boolean equals(Plugin plugin, String simpleID) {
                return this.equals(ID.of(plugin, simpleID).getFullID());
            }

            public boolean equals(String pluginName, String simpleID) {
                return this.equals(ID.of(pluginName, simpleID).getFullID());
            }

            public boolean equals(Plugin plugin, UUID simpleID) {
                return this.equals(ID.of(plugin, simpleID).getFullID());
            }

            protected boolean isPlayerNPC() {
                return this.pluginName.equalsIgnoreCase(PlayerNPCPlugin.getInstance().getName());
            }

            public String toString() {
                return this.getFullID();
            }
        }

        public static interface Identified {
            public ID getID();

            default public String getSimpleID() {
                return this.getID().getSimpleID();
            }

            default public String getFullID() {
                return this.getID().getFullID();
            }
        }
    }

    public static class PluginManager
    implements Listener {
        private final Plugin plugin;
        private final NPCLib npcLib;
        protected Command.Color commandColor;
        protected UpdateGazeType updateGazeType;
        protected Integer updateGazeTicks;
        protected Integer ticksUntilTabListHide;
        protected Integer taskID;
        protected SkinUpdateFrequency skinUpdateFrequency;

        protected PluginManager(Plugin plugin, NPCLib npcLib) {
            this.plugin = plugin;
            this.npcLib = npcLib;
            this.updateGazeTicks = 5;
            this.ticksUntilTabListHide = 10;
            this.skinUpdateFrequency = new SkinUpdateFrequency(1, TimeUnit.DAYS);
            this.updateGazeType = UpdateGazeType.MOVE_EVENT;
            this.commandColor = Command.Color.YELLOW;
            plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
        }

        protected void onEnable() {
            if (this.plugin.equals(this.npcLib.getPlugin())) {
                this.npcLib.loadConfig();
            }
            this.loadPersistentNPCs();
        }

        protected void onUnregister() {
            Set<NPC.Personal> npc;
            this.savePersistentNPCs();
            Set<NPC.Global> globals = this.npcLib.getAllGlobalNPCs(this.plugin);
            if (!globals.isEmpty()) {
                globals.forEach(x -> this.npcLib.removeGlobalNPC((NPC.Global)x));
            }
            if (!(npc = this.npcLib.getPersonalNPCs(this.plugin)).isEmpty()) {
                npc.forEach(x -> this.npcLib.removePersonalNPC((NPC.Personal)x));
            }
            NPC.Skin.Custom.onUnregisterPlugin(this.plugin);
        }

        public Optional<NPC.Global> grabGlobalNPC(String simpleCode) {
            return this.npcLib.grabGlobalNPC(this.plugin, simpleCode);
        }

        public Optional<NPC.Personal> grabPersonalNPC(Player player, String simpleCode) {
            return this.npcLib.grabPersonalNPC(player, this.plugin, simpleCode);
        }

        @Deprecated
        public NPC.Personal getPersonalNPC(Player player, String simpleCode) {
            return this.npcLib.getPersonalNPC(player, this.plugin, simpleCode);
        }

        private void loadPersistentNPCs() {
            if (!this.plugin.equals(this.npcLib.getPlugin())) {
                return;
            }
            File folder = new File("plugins/PlayerNPC/persistent/global/" + this.plugin.getName().toLowerCase() + "/");
            if (!folder.exists()) {
                folder.mkdirs();
            }
            if (folder.listFiles().length == 0) {
                return;
            }
            Bukkit.getConsoleSender().sendMessage(PlayerNPCPlugin.getInstance().getPrefix() + "\u00a77Loading Persistent Global NPCs for plugin \u00a7e" + this.plugin.getName());
            for (File f : folder.listFiles()) {
                if (!f.isDirectory()) continue;
                try {
                    NPC.Global.PersistentManager persistent = new NPC.Global.PersistentManager(this.plugin, f.getName());
                    persistent.load();
                }
                catch (Exception e) {
                    Bukkit.getConsoleSender().sendMessage(PlayerNPCPlugin.getInstance().getPrefix() + "\u00a77Error loading Persistent Global NPC \u00a7c" + f.getName());
                    DebugManager.printError(e);
                }
            }
        }

        private void savePersistentNPCs() {
            NPC.Global.PersistentManager.forEachPersistentManager(this.plugin, x -> x.save());
        }

        public Plugin getPlugin() {
            return this.plugin;
        }

        public NPCLib getNPCLib() {
            return this.npcLib;
        }

        public UpdateGazeType getUpdateGazeType() {
            return this.updateGazeType;
        }

        public Integer getUpdateGazeTicks() {
            return this.updateGazeTicks;
        }

        public Integer getTicksUntilTabListHide() {
            return this.ticksUntilTabListHide;
        }

        public Integer getTaskID() {
            return this.taskID;
        }

        public Registry.ID formatID(String simpleID) {
            return Registry.ID.of(this.plugin, simpleID);
        }

        public SkinUpdateFrequency getSkinUpdateFrequency() {
            return this.skinUpdateFrequency;
        }

        public void setCommandColor(Command.Color color) {
            if (this.plugin.equals((Object)PlayerNPCPlugin.getInstance())) {
                return;
            }
            this.commandColor = color;
        }

        public Command.Color getCommandColor() {
            if (this.commandColor == null) {
                return Command.Color.YELLOW;
            }
            return this.commandColor;
        }

        public void setUpdateGazeType(@Nonnull UpdateGazeType updateGazeType) {
            Validate.notNull((Object)updateGazeType, (String)"Update gaze type must be not null");
            if (this.updateGazeType.equals(updateGazeType)) {
                return;
            }
            this.updateGazeType = updateGazeType;
            if (this.plugin.equals(this.npcLib.getPlugin())) {
                this.npcLib.saveConfig();
            }
            this.runGazeUpdate();
        }

        public void setUpdateGazeTicks(Integer ticks) {
            if (ticks < 1) {
                ticks = 1;
            }
            if (ticks.equals(this.updateGazeTicks)) {
                return;
            }
            this.updateGazeTicks = ticks;
            if (this.plugin.equals(this.npcLib.getPlugin())) {
                this.npcLib.saveConfig();
            }
            if (this.updateGazeType.equals(UpdateGazeType.TICKS)) {
                this.runGazeUpdate();
            }
        }

        private void runGazeUpdate() {
            if (this.taskID != null) {
                this.plugin.getServer().getScheduler().cancelTask(this.taskID.intValue());
            }
            if (this.updateGazeType.equals(UpdateGazeType.TICKS)) {
                this.taskID = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously(this.plugin, () -> Bukkit.getOnlinePlayers().forEach(x -> this.npcLib.getNPCPlayerManager((Player)x).updateMove(this.plugin)), (long)this.updateGazeTicks.intValue(), (long)this.updateGazeTicks.intValue()).getTaskId();
            }
        }

        public void setSkinUpdateFrequency(SkinUpdateFrequency skinUpdateFrequency) {
            this.skinUpdateFrequency = skinUpdateFrequency;
            if (this.plugin.equals(this.npcLib.getPlugin())) {
                this.npcLib.saveConfig();
            }
        }

        public void setTicksUntilTabListHide(Integer ticksUntilTabListHide) {
            if (ticksUntilTabListHide < 0) {
                ticksUntilTabListHide = 0;
            }
            if (ticksUntilTabListHide.equals(this.ticksUntilTabListHide)) {
                return;
            }
            this.ticksUntilTabListHide = ticksUntilTabListHide;
            if (this.plugin.equals(this.npcLib.getPlugin())) {
                this.npcLib.saveConfig();
            }
        }

        protected NPC.Personal generatePlayerPersonalNPC(Player player, Registry.ID id, Location location) {
            Validate.isTrue((!this.npcLib.hasPersonalNPC(player, id) ? 1 : 0) != 0, (String)("Personal NPC with ID " + id.getFullID() + " for player " + player.getName() + " already exists."));
            return new NPC.Personal(this, id, player, location);
        }

        protected NPC.Global generatePlayerGlobalNPC(Registry.ID id, NPC.Global.Visibility visibility, Predicate<Player> visibilityRequirement, Location location) {
            Validate.isTrue((!this.npcLib.hasGlobalNPC(id.getFullID()) ? 1 : 0) != 0, (String)("Global NPC with ID " + id.getFullID() + " already exists."));
            return new NPC.Global(this, id, visibility, visibilityRequirement, location);
        }

        @EventHandler
        private void onMove(PlayerMoveEvent event) {
            if (!this.getUpdateGazeType().equals(UpdateGazeType.MOVE_EVENT)) {
                return;
            }
            if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockY() == event.getTo().getBlockY() && event.getFrom().getBlockZ() == event.getTo().getBlockZ()) {
                return;
            }
            Player player = event.getPlayer();
            this.npcLib.getNPCPlayerManager(player).updateMove(this.plugin);
        }
    }

    protected class PlayerManager {
        private final NPCLib npcLib;
        private final Player player;
        private final Registry<NPC.Personal> personalNPCs;
        private final PacketReader packetReader;
        private final Map<World, Set<NPC.Personal>> hidden;
        private final Long lastEnter;
        private ServerVersion clientVersion;

        protected PlayerManager(NPCLib npcLib, Player player) {
            Integer protocolVersion;
            this.npcLib = npcLib;
            this.player = player;
            if (IntegrationsManager.isUsingViaVersion() && (protocolVersion = IntegrationsManager.getViaVersion().getProtocolVersion(player)) != null && protocolVersion > 0 && !ServerVersion.getServerVersion().getProtocolVersion().equals(protocolVersion)) {
                this.clientVersion = ServerVersion.getProtocolVersion(protocolVersion);
                if (NPCLib.this.debug) {
                    Bukkit.getConsoleSender().sendMessage(player.getName() + " is using client version \u00a7a" + this.clientVersion.getMinecraftVersion() + "\u00a77 (" + this.clientVersion.getProtocolVersion() + ") vs server version \u00a7e" + ServerVersion.getServerVersion().getMinecraftVersion() + " \u00a77(" + ServerVersion.getServerVersion().getProtocolVersion() + ")");
                }
            }
            if (this.clientVersion == null) {
                this.clientVersion = ServerVersion.getServerVersion();
            }
            this.personalNPCs = new Registry(Registry.ID.playerNPC("personalNPCs"));
            this.packetReader = new PacketReader(this);
            this.hidden = new HashMap<World, Set<NPC.Personal>>();
            this.lastEnter = System.currentTimeMillis();
        }

        public ServerVersion getClientVersion() {
            return this.clientVersion;
        }

        protected Registry<NPC.Personal> getPersonalNPCs() {
            return this.personalNPCs;
        }

        protected Optional<NPC.Personal> grabNPC(Integer entityID) {
            return this.personalNPCs.getValues().stream().filter(x -> x.isCreated() && NMSEntity.getEntityID((net.minecraft.world.entity.Entity)x.getEntity()).equals(entityID)).findAny();
        }

        protected void removeNPC(Registry.ID id) {
            this.personalNPCs.remove(id);
        }

        protected void updateMove(Plugin plugin) {
            this.getNPCs(this.getPlayer().getWorld()).stream().filter(x -> x.getPlugin().equals(plugin)).forEach(x -> x.updateMove());
        }

        protected void updateMove() {
            this.getNPCs(this.getPlayer().getWorld()).stream().forEach(x -> x.updateMove());
        }

        protected void destroyWorld(World world) {
            HashSet r = new HashSet();
            this.personalNPCs.getValues().stream().filter(x -> x.getWorld().getName().equals(world.getName())).forEach(x -> {
                if (x.getTabListVisibility().equals(NPC.TabListVisibility.SAME_WORLD)) {
                    x.removeTabList();
                }
                if (x.isShownOnClient()) {
                    x.hideToClient();
                    r.add(x);
                }
            });
            this.hidden.put(world, r);
        }

        protected void showWorld(World world) {
            if (!this.hidden.containsKey(world)) {
                return;
            }
            this.hidden.get(world).stream().filter(x -> x.isCreated()).forEach(x -> x.showToClient());
            this.hidden.remove(world);
            this.getNPCs(world).stream().filter(x -> x.getTabListVisibility().equals(NPC.TabListVisibility.SAME_WORLD) && !x.isShownOnClientTabList()).forEach(x -> x.addTabList(true));
        }

        protected void changeWorld(NPC.Personal npc, World from, World to) {
            if (!this.hidden.containsKey(from)) {
                return;
            }
            if (!this.hidden.get(from).contains(npc)) {
                return;
            }
            this.hidden.get(from).remove(npc);
            npc.show();
        }

        protected void destroyAll() {
            HashSet<NPC.Personal> destroy = new HashSet<NPC.Personal>();
            destroy.addAll(this.personalNPCs.getValues());
            destroy.stream().filter(x -> x.isCreated()).forEach(x -> x.destroy());
            this.personalNPCs.clear();
        }

        protected Set<NPC.Personal> getNPCs(World world) {
            Validate.notNull((Object)world, (String)"World must be not null");
            return this.personalNPCs.getValues().stream().filter(x -> x.getWorld().equals(world)).collect(Collectors.toSet());
        }

        protected Set<NPC.Personal> getNPCs(Plugin plugin) {
            Validate.notNull((Object)plugin, (String)"Plugin must be not null");
            return this.personalNPCs.getValues().stream().filter(x -> x.getPlugin().equals(plugin)).collect(Collectors.toSet());
        }

        protected Set<NPC.Personal> getNPCs() {
            return this.personalNPCs.getValues().stream().collect(Collectors.toSet());
        }

        protected Optional<NPC.Personal> grabNPC(Registry.ID id) {
            return this.personalNPCs.grab(id);
        }

        protected NPCLib getNPCLib() {
            return this.npcLib;
        }

        protected Player getPlayer() {
            return this.player;
        }

        protected PacketReader getPacketReader() {
            return this.packetReader;
        }

        protected Long getLastEnter() {
            return this.lastEnter;
        }

        protected Long ticksToAppear() {
            if (System.currentTimeMillis() - this.lastEnter < 500L) {
                return 10L;
            }
            if (System.currentTimeMillis() - this.lastEnter < 750L) {
                return 15L;
            }
            if (System.currentTimeMillis() - this.lastEnter < 1000L) {
                return 20L;
            }
            return 0L;
        }

        protected static class PacketReader {
            private HashMap<NPC, Long> lastClick;
            private PlayerManager npcPlayerManager;
            private Channel channel;

            protected PacketReader(PlayerManager npcPlayerManager) {
                this.npcPlayerManager = npcPlayerManager;
                this.lastClick = new HashMap();
            }

            protected void inject() {
                if (this.channel != null) {
                    return;
                }
                this.channel = NMSNetworkManager.getChannel(NMSNetworkManager.getNetworkManager(this.npcPlayerManager.getPlayer()));
                if (this.channel.pipeline() == null) {
                    return;
                }
                if (this.channel.pipeline().get("PacketInjector") != null) {
                    return;
                }
                this.channel.pipeline().addAfter("decoder", "PacketInjector", (ChannelHandler)new MessageToMessageDecoder<PacketPlayInUseEntity>(){

                    protected void decode(ChannelHandlerContext channel, PacketPlayInUseEntity packet, List<Object> arg) throws Exception {
                        arg.add(packet);
                        this.readPacket((Packet<?>)packet);
                    }
                });
            }

            protected void unInject() {
                if (this.channel == null) {
                    return;
                }
                if (this.channel.pipeline() == null) {
                    return;
                }
                if (this.channel.pipeline().get("PacketInjector") == null) {
                    return;
                }
                this.channel.pipeline().remove("PacketInjector");
                this.channel = null;
            }

            private void readPacket(Packet<?> packet) {
                NPC.Interact.ClickType clickType;
                if (packet == null) {
                    return;
                }
                if (!packet.getClass().getSimpleName().equalsIgnoreCase("PacketPlayInUseEntity")) {
                    return;
                }
                int id = (Integer)NMSUtils.getValue(packet, "a");
                try {
                    Object action = NMSUtils.getValue(packet, "b");
                    EnumHand hand = (EnumHand)NMSUtils.getValue(action, "a");
                    clickType = hand != null ? NPC.Interact.ClickType.RIGHT_CLICK : NPC.Interact.ClickType.LEFT_CLICK;
                }
                catch (Exception e) {
                    clickType = NPC.Interact.ClickType.LEFT_CLICK;
                }
                this.interact(this.getPlayerManager().grabNPC(id).orElse(null), clickType);
            }

            private void interact(NPC.Personal npc, NPC.Interact.ClickType clickType) {
                if (npc == null) {
                    return;
                }
                if (this.lastClick.containsKey(npc) && System.currentTimeMillis() - this.lastClick.get(npc) < npc.getInteractCooldown()) {
                    return;
                }
                this.lastClick.put(npc, System.currentTimeMillis());
                Bukkit.getScheduler().runTask(this.getNPCLib().getPlugin(), () -> npc.interact(this.npcPlayerManager.getPlayer(), clickType));
            }

            protected PlayerManager getPlayerManager() {
                return this.npcPlayerManager;
            }

            protected NPCLib getNPCLib() {
                return this.npcPlayerManager.getNPCLib();
            }
        }
    }

    public static class Command {
        private Command() {
        }

        public static enum Color {
            YELLOW(ChatColor.YELLOW, ChatColor.GOLD),
            BLUE(ChatColor.AQUA, ChatColor.DARK_AQUA),
            GREEN(ChatColor.GREEN, ChatColor.DARK_GREEN);

            private ChatColor normal;
            private ChatColor important;

            private Color(ChatColor normal, ChatColor important) {
                this.normal = normal;
                this.important = important;
            }

            public ChatColor getNormal() {
                return this.normal;
            }

            public String getImportant() {
                return "" + this.important + ChatColor.BOLD;
            }

            public ChatColor getImportantSimple() {
                return this.important;
            }
        }
    }

    public static class DebugManager {
        public static void printError(Exception e) {
            if (!NPCLib.getInstance().isDebug()) {
                return;
            }
            e.printStackTrace();
        }

        public static void printLine(String line) {
            if (!NPCLib.getInstance().isDebug()) {
                return;
            }
            Bukkit.getConsoleSender().sendMessage("\u00a7c[PlayerNPC-DEBUG] \u00a77" + line);
        }
    }

    public static enum UpdateGazeType implements EnumUtils.GetName
    {
        MOVE_EVENT,
        TICKS;

    }

    public record SkinUpdateFrequency(Integer value, TimeUnit timeUnit) implements ConfigurationSerializable
    {
        public SkinUpdateFrequency {
            Objects.requireNonNull(value);
            Objects.requireNonNull(timeUnit);
            Validate.isTrue((timeUnit.equals((Object)TimeUnit.SECONDS) || timeUnit.equals((Object)TimeUnit.MINUTES) || timeUnit.equals((Object)TimeUnit.HOURS) || timeUnit.equals((Object)TimeUnit.DAYS) ? 1 : 0) != 0, (String)"Time unit must be seconds, minutes, hours or days.");
        }

        public Map<String, Object> serialize() {
            HashMap<String, Object> hash = new HashMap<String, Object>();
            hash.put("value", this.value);
            hash.put("timeUnit", this.timeUnit.name());
            return hash;
        }

        public static SkinUpdateFrequency deserialize(Map<String, Object> map) {
            return new SkinUpdateFrequency((Integer)map.get("value"), TimeUnit.valueOf((String)map.get("timeUnit")));
        }
    }
}

