/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiferry.playernpc.api;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.datafixers.util.Pair;
import dev.sergiferry.playernpc.PlayerNPCPlugin;
import dev.sergiferry.playernpc.api.NPCLib;
import dev.sergiferry.playernpc.integration.Integration;
import dev.sergiferry.playernpc.integration.IntegrationsManager;
import dev.sergiferry.playernpc.nms.craftbukkit.NMSCraftItemStack;
import dev.sergiferry.playernpc.nms.craftbukkit.NMSCraftScoreboard;
import dev.sergiferry.playernpc.nms.minecraft.NMSDataWatcher;
import dev.sergiferry.playernpc.nms.minecraft.NMSEntity;
import dev.sergiferry.playernpc.nms.minecraft.NMSEntityArmorStand;
import dev.sergiferry.playernpc.nms.minecraft.NMSEntityItem;
import dev.sergiferry.playernpc.nms.minecraft.NMSEntityLiving;
import dev.sergiferry.playernpc.nms.minecraft.NMSEntityPlayer;
import dev.sergiferry.playernpc.nms.minecraft.NMSPacketPlayOutAnimation;
import dev.sergiferry.playernpc.nms.minecraft.NMSPacketPlayOutEntityDestroy;
import dev.sergiferry.playernpc.nms.minecraft.NMSPacketPlayOutEntityMetadata;
import dev.sergiferry.playernpc.nms.minecraft.NMSPacketPlayOutPlayerInfo;
import dev.sergiferry.playernpc.nms.minecraft.NMSPacketPlayOutRespawn;
import dev.sergiferry.playernpc.nms.minecraft.NMSPacketPlayOutSpawnEntity;
import dev.sergiferry.playernpc.nms.minecraft.NMSScoreboard;
import dev.sergiferry.playernpc.nms.spigot.NMSFileConfiguration;
import dev.sergiferry.playernpc.nms.spigot.NMSFileUtils;
import dev.sergiferry.playernpc.utils.ColorUtils;
import dev.sergiferry.playernpc.utils.EnumUtils;
import dev.sergiferry.playernpc.utils.MathUtils;
import dev.sergiferry.playernpc.utils.StringUtils;
import dev.sergiferry.playernpc.utils.TimerUtils;
import dev.sergiferry.spigot.nms.craftbukkit.NMSCraftChatMessage;
import dev.sergiferry.spigot.nms.craftbukkit.NMSCraftPlayer;
import dev.sergiferry.spigot.nms.craftbukkit.NMSCraftServer;
import dev.sergiferry.spigot.nms.craftbukkit.NMSCraftWorld;
import dev.sergiferry.spigot.server.ServerVersion;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.function.TriFunction;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Slab;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.mineskin.MineskinClient;
import org.mineskin.SkinOptions;
import org.mineskin.Variant;
import org.mineskin.Visibility;

public abstract class NPC
implements NPCLib.Registry.Identified {
    protected final NPCLib.PluginManager pluginManager;
    private final NPCLib.Registry.ID id;
    private final NPCLib.Registry<String> customData;
    private World world;
    private Double x;
    private Double y;
    private Double z;
    private Float yaw;
    private Float pitch;
    private List<Interact.ClickAction> clickActions;
    private Move.Task moveTask;
    private Move.Behaviour moveBehaviour;
    protected Updatable.PendingUpdates pendingUpdates;
    private Attributes attributes;
    private BukkitTask tick;

    protected NPC(@Nonnull NPCLib.PluginManager pluginManager, @Nonnull NPCLib.Registry.ID id, @Nonnull World world, double x, double y, double z, float yaw, float pitch) {
        Validate.notNull((Object)pluginManager, (String)"Cannot generate NPC instance, PluginManager cannot be null.");
        Validate.notNull((Object)id, (String)"Cannot generate NPC instance, ID cannot be null.");
        Validate.notNull((Object)world, (String)"Cannot generate NPC instance, World cannot be null.");
        Validate.isTrue((boolean)id.getPluginName().equalsIgnoreCase(pluginManager.getPlugin().getName()), (String)("Cannot generate NPC instance, ID Plugin (" + id.getPluginName() + ") do not match with PluginManager (" + pluginManager.getPlugin().getName() + ")"));
        this.pluginManager = pluginManager;
        this.id = id;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = Float.valueOf(yaw);
        this.pitch = Float.valueOf(pitch);
        this.clickActions = new ArrayList<Interact.ClickAction>();
        this.moveTask = null;
        this.moveBehaviour = new Move.Behaviour(this);
        this.customData = new NPCLib.Registry(NPCLib.Registry.ID.of(this.getPlugin(), id.getSimpleID() + "-customData"));
        this.pendingUpdates = new Updatable.PendingUpdates<NPC>(this);
        this.attributes = Attributes.copyOf(Attributes.DEFAULT);
        this.checkTick();
    }

    protected abstract void simpleUpdate();

    protected abstract void forceUpdate();

    protected abstract void simpleUpdateText();

    protected abstract void forceUpdateText();

    protected Updatable needUpdate(Updatable.Type type) {
        return switch (type) {
            case Updatable.Type.NONE -> this.noNeedUpdate();
            case Updatable.Type.SIMPLE_UPDATE -> this.needSimpleUpdate();
            case Updatable.Type.FORCE_UPDATE -> this.needForceUpdate();
            case Updatable.Type.SIMPLE_UPDATE_TEXT -> this.needSimpleUpdateText();
            case Updatable.Type.FORCE_UPDATE_TEXT -> this.needForceUpdateText();
            case Updatable.Type.SYNCHRONIZE_GLOBAL_ATTRIBUTES -> null;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    protected Updatable noNeedUpdate() {
        return new Updatable.InGeneral();
    }

    protected Updatable needSimpleUpdate() {
        return new Updatable.InGeneral<NPC>(this, Updatable.Type.SIMPLE_UPDATE);
    }

    protected Updatable needForceUpdate() {
        return new Updatable.InGeneral<NPC>(this, Updatable.Type.FORCE_UPDATE);
    }

    protected Updatable needSimpleUpdateText() {
        return new Updatable.InGeneral<NPC>(this, Updatable.Type.SIMPLE_UPDATE_TEXT);
    }

    protected Updatable needForceUpdateText() {
        return new Updatable.InGeneral<NPC>(this, Updatable.Type.FORCE_UPDATE_TEXT);
    }

    protected Updatable needUpdateOrForce(boolean forceUpdate) {
        return forceUpdate ? this.needForceUpdate() : this.needSimpleUpdate();
    }

    protected Updatable needUpdateTextOrForce(boolean forceUpdate) {
        return forceUpdate ? this.needForceUpdateText() : this.needSimpleUpdateText();
    }

    public boolean hasPendingUpdates() {
        return this.pendingUpdates.hasPending();
    }

    public boolean hasPendingUpdate(Updatable.Type type) {
        return this.pendingUpdates.containsType(type);
    }

    public void update() {
        this.pendingUpdates.update();
    }

    protected abstract void destroy();

    protected abstract void teleport(World var1, double var2, double var4, double var6, float var8, float var9);

    public void teleport(@Nonnull Entity entity) {
        Validate.notNull((Object)entity, (String)"Entity must be not null.");
        this.teleport(entity.getLocation());
    }

    public void teleport(@Nonnull Location location) {
        Validate.notNull((Object)location, (String)"Location must be not null.");
        this.teleport(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public void teleport(double x, double y, double z) {
        this.teleport(this.world, x, y, z);
    }

    public void teleport(World world, double x, double y, double z) {
        this.teleport(world, x, y, z, this.yaw.floatValue(), this.pitch.floatValue());
    }

    public void teleport(double x, double y, double z, float yaw, float pitch) {
        this.teleport(this.world, x, y, z, yaw, pitch);
    }

    public Updatable setItem(@Nonnull Slot slot, @Nullable org.bukkit.inventory.ItemStack itemStack) {
        Validate.notNull((Object)slot, (String)"Failed to set item, NPC.Slot cannot be null");
        if (itemStack == null) {
            itemStack = new org.bukkit.inventory.ItemStack(Material.AIR);
        }
        return this.needUpdate(this.attributes.setItem(slot, itemStack));
    }

    public Updatable setHelmet(@Nullable org.bukkit.inventory.ItemStack itemStack) {
        return this.setItem(Slot.HEAD, itemStack);
    }

    public Updatable setChestplate(@Nullable org.bukkit.inventory.ItemStack itemStack) {
        return this.setItem(Slot.CHEST, itemStack);
    }

    public Updatable setLeggings(@Nullable org.bukkit.inventory.ItemStack itemStack) {
        return this.setItem(Slot.LEGS, itemStack);
    }

    public Updatable setBoots(@Nullable org.bukkit.inventory.ItemStack itemStack) {
        return this.setItem(Slot.FEET, itemStack);
    }

    public Updatable setItemInMainHand(@Nullable org.bukkit.inventory.ItemStack itemStack) {
        return this.setItem(Slot.MAINHAND, itemStack);
    }

    public Updatable setItemInOffHand(@Nullable org.bukkit.inventory.ItemStack itemStack) {
        return this.setItem(Slot.OFFHAND, itemStack);
    }

    @Deprecated
    public Updatable setItemInRightHand(@Nullable org.bukkit.inventory.ItemStack itemStack) {
        return this.setItemInMainHand(itemStack);
    }

    @Deprecated
    public Updatable setItemInLeftHand(@Nullable org.bukkit.inventory.ItemStack itemStack) {
        return this.setItemInOffHand(itemStack);
    }

    public Updatable clearEquipment(@Nonnull Slot slot) {
        return this.setItem(slot, null);
    }

    public Updatable clearEquipment() {
        Arrays.stream(Slot.values()).forEach(x -> this.clearEquipment((Slot)x));
        return this.needSimpleUpdate();
    }

    public Updatable lookAt(@Nonnull Entity entity) {
        Validate.notNull((Object)entity, (String)"Failed to set look direction. The entity cannot be null");
        return this.lookAt(entity.getLocation());
    }

    public Updatable lookAt(@Nonnull Location location) {
        Validate.notNull((Object)location, (String)"Failed to set look direction. The location cannot be null.");
        Validate.isTrue((boolean)location.getWorld().getName().equals(this.getWorld().getName()), (String)"The location must be in the same world as NPC");
        Location npcLocation = new Location(this.world, this.x.doubleValue(), this.y.doubleValue(), this.z.doubleValue(), this.yaw.floatValue(), this.pitch.floatValue());
        Vector dirBetweenLocations = location.toVector().subtract(npcLocation.toVector());
        npcLocation.setDirection(dirBetweenLocations);
        return this.lookAt(npcLocation.getYaw(), npcLocation.getPitch());
    }

    public abstract Updatable lookAt(float var1, float var2);

    public Updatable setCollidable(boolean collidable) {
        return this.needUpdate(this.attributes.setCollidable(collidable));
    }

    public Updatable setSkin(@Nonnull Skin.SignedTexture signedTexture) {
        return this.setSkin(null, signedTexture.texture, signedTexture.signature);
    }

    public Updatable setSkin(@Nullable String skinName, @Nonnull Skin.SignedTexture signedTexture) {
        return this.setSkin(skinName, signedTexture.texture, signedTexture.signature);
    }

    public Updatable setSkin(@Nonnull String texture, @Nonnull String signature) {
        return this.setSkin(null, texture, signature);
    }

    public Updatable setSkin(@Nullable String skinName, @Nonnull String texture, @Nonnull String signature) {
        if (skinName == null) {
            return this.setSkin(Skin.Custom.createCustomSkin(this.getPlugin(), texture, signature));
        }
        return this.setSkin(Skin.Custom.createCustomSkin(this.getPlugin(), skinName, texture, signature));
    }

    public CompletableFuture<Updatable> setSkin(@Nullable String playerName, @Nullable Consumer<Skin.Minecraft.FetchResult> finishAction) {
        if (playerName == null) {
            return CompletableFuture.completedFuture(this.setSkin(Skin.Minecraft.STEVE));
        }
        CompletableFuture<Updatable> completableFuture = new CompletableFuture<Updatable>();
        Skin.Minecraft.fetchSkinAsync(this.getPlugin(), playerName).thenAccept(fetchResult -> {
            completableFuture.complete(this.setSkin((Skin)fetchResult.grabSkin().orElse(null)));
            if (finishAction != null) {
                this.getPlugin().getServer().getScheduler().runTask(this.getPlugin(), () -> finishAction.accept((Skin.Minecraft.FetchResult)fetchResult));
            }
        });
        return completableFuture;
    }

    public CompletableFuture<Updatable> setMineSkin(@Nonnull String id, boolean forceDownload, Consumer<Skin.MineSkin.FetchResult> finishAction) {
        Validate.notNull((Object)id, (String)"Cannot fetch null identifier of a MineSkin");
        CompletableFuture<Updatable> completableFuture = new CompletableFuture<Updatable>();
        Skin.MineSkin.fetchSkinAsync(this.getPlugin(), id, forceDownload).thenAccept(fetchResult -> {
            completableFuture.complete(this.setSkin((Skin)fetchResult.grabSkin().orElse(null)));
            if (finishAction != null) {
                this.getPlugin().getServer().getScheduler().runTask(this.getPlugin(), () -> finishAction.accept((Skin.MineSkin.FetchResult)fetchResult));
            }
        });
        return completableFuture;
    }

    public CompletableFuture<Updatable> setMineSkin(@Nonnull String id, Consumer<Skin.MineSkin.FetchResult> finishAction) {
        return this.setMineSkin(id, false, finishAction);
    }

    public CompletableFuture<Updatable> setSkin(@Nullable String playerName) {
        return this.setSkin(playerName, (Consumer<Skin.Minecraft.FetchResult>)null);
    }

    public CompletableFuture<Updatable> setSkin(@Nullable Player playerSkin) {
        if (playerSkin == null) {
            return CompletableFuture.completedFuture(this.setSkin(Skin.Minecraft.STEVE));
        }
        Validate.isTrue((boolean)playerSkin.isOnline(), (String)"Failed to set NPC skin. Player must be online.");
        return this.setSkin(playerSkin.getName(), (Consumer<Skin.Minecraft.FetchResult>)null);
    }

    public CompletableFuture<Updatable> setSkin(@Nullable Player playerSkin, Consumer<Skin.Minecraft.FetchResult> finishAction) {
        if (playerSkin == null) {
            return CompletableFuture.completedFuture(this.setSkin(Skin.Minecraft.STEVE));
        }
        Validate.isTrue((boolean)playerSkin.isOnline(), (String)"Failed to set NPC skin. Player must be online.");
        return this.setSkin(playerSkin.getName(), finishAction);
    }

    public Updatable setInGameSkinOf(@Nonnull Player player) {
        return this.setSkin(Skin.Minecraft.grabSkinGameProfile(player).orElse(Skin.Minecraft.getSteveSkin().getSignedTexture()));
    }

    public Updatable setSkin(@Nullable Skin npcSkin) {
        return this.needUpdate(this.attributes.setSkin(npcSkin));
    }

    protected Updatable setSkinVisibleLayers(Skin.VisibleLayers skinVisibleLayers) {
        return this.needUpdate(this.attributes.setSkinVisibleLayers(skinVisibleLayers));
    }

    public Updatable clearSkin() {
        return this.setSkin((Skin)null);
    }

    public Updatable setSkinLayerVisibility(Skin.Layer layer, boolean visible) {
        return this.needUpdate(this.attributes.skinVisibleLayers.setVisibility(layer, visible));
    }

    public Updatable setPose(@Nullable Pose pose) {
        return this.needUpdate(this.attributes.setPose(pose));
    }

    public Updatable setCrouching(boolean b) {
        if (b) {
            return this.setPose(Pose.CROUCHING);
        }
        if (this.getPose().equals(Pose.CROUCHING)) {
            return this.resetPose();
        }
        return this.noNeedUpdate();
    }

    public Updatable setSwimming(boolean b) {
        if (b) {
            return this.setPose(Pose.SWIMMING);
        }
        if (this.getPose().equals(Pose.SWIMMING)) {
            return this.resetPose();
        }
        return this.noNeedUpdate();
    }

    public Updatable setSleeping(boolean b) {
        if (b) {
            return this.setPose(Pose.SLEEPING);
        }
        if (this.getPose().equals(Pose.SLEEPING)) {
            return this.resetPose();
        }
        return this.noNeedUpdate();
    }

    public Updatable resetPose() {
        return this.setPose(Pose.STANDING);
    }

    public Updatable clearText() {
        return this.setText(new ArrayList<String>());
    }

    public Updatable setText(@Nonnull @ColorUtils.Colorable(colored=false) @Placeholders.Replaceable(replaced=false) List<String> text) {
        return this.needUpdate(this.attributes.setText(text));
    }

    public Updatable setText(String ... text) {
        return this.setText(Arrays.asList(text));
    }

    public Updatable setText(@Nonnull @ColorUtils.Colorable(colored=false) @Placeholders.Replaceable(replaced=false) String text) {
        ArrayList<String> list = new ArrayList<String>();
        if (text.contains("\\n")) {
            for (String s : text.split("\\\\n")) {
                list.add(s);
            }
        } else {
            list.add(text);
        }
        return this.setText(list);
    }

    public Updatable resetTextLinesOpacity() {
        this.attributes.resetTextLinesOpacity();
        return this.needForceUpdateText();
    }

    public Updatable resetTextLineOpacity(int line) {
        this.attributes.resetTextLineOpacity(line);
        return this.needForceUpdateText();
    }

    public Updatable setTextLineOpacity(int line, @Nullable Hologram.Opacity textOpacity) {
        return this.needUpdate(this.attributes.setTextLineOpacity(line, textOpacity));
    }

    protected void setTextLinesOpacity(HashMap<Integer, Hologram.Opacity> linesOpacity) {
        this.attributes.setTextLinesOpacity(linesOpacity);
    }

    public Updatable setTextOpacity(@Nullable Hologram.Opacity textOpacity) {
        return this.needUpdate(this.attributes.setTextOpacity(textOpacity));
    }

    public Updatable resetTextOpacity() {
        return this.setTextOpacity(Hologram.Opacity.LOWEST);
    }

    public Updatable setTextItem(@Nullable org.bukkit.inventory.ItemStack item) {
        return this.needUpdate(this.attributes.setTextItem(item));
    }

    public Updatable setTextItemGlowing(boolean glowing) {
        return this.needUpdate(this.attributes.setTextItemGlowing(glowing));
    }

    public Updatable setTextItemGlowingColor(@Nullable Color color) {
        return this.needUpdate(this.attributes.setTextItemGlowingColor(color));
    }

    public Updatable setTextItemGlowingColor(@Nullable org.bukkit.ChatColor chatColor) {
        return this.setTextItemGlowingColor(chatColor != null ? (Color)Color.of(chatColor).orElse(null) : null);
    }

    public void setTextUpdateTicks(int ticks) {
        this.attributes.setTextUpdateTicks(ticks);
        this.checkTick();
    }

    public Updatable setGlowingColor(@Nullable org.bukkit.ChatColor color) {
        return this.setGlowingColor(color != null ? (Color)Color.of(color).orElse(null) : null);
    }

    public Updatable setGlowingColor(@Nullable Color color) {
        return this.needUpdate(this.attributes.setGlowingColor(color));
    }

    public Updatable setGlowing(boolean glowing, @Nullable org.bukkit.ChatColor color) {
        return this.setGlowing(glowing, (Color)Color.of(color).orElse(null));
    }

    public Updatable setGlowing(boolean glowing, @Nullable Color color) {
        this.setGlowing(glowing);
        this.setGlowingColor(color);
        return this.needSimpleUpdate();
    }

    public Updatable setGlowing(boolean glowing) {
        return this.needUpdate(this.attributes.setGlowing(glowing));
    }

    public Updatable setPotionParticlesColor(@Nullable java.awt.Color color) {
        return this.needUpdate(this.attributes.setPotionParticlesColor(color));
    }

    public Updatable setPotionParticlesType(@Nullable PotionParticlesType potionParticlesType) {
        return this.needUpdate(this.attributes.setPotionParticlesType(potionParticlesType));
    }

    public Updatable setInvisible(boolean invisible) {
        return this.needUpdate(this.attributes.setInvisible(invisible));
    }

    public Move.Behaviour follow(NPC npc) {
        Validate.isTrue((!npc.equals(this) ? 1 : 0) != 0, (String)"NPC cannot follow himself.");
        return this.moveBehaviour.setFollowNPC(npc);
    }

    public Move.Behaviour follow(NPC npc, double min, double max) {
        Validate.isTrue((!npc.equals(this) ? 1 : 0) != 0, (String)"NPC cannot follow himself.");
        return this.moveBehaviour.setFollowNPC(npc, min, max);
    }

    public Move.Behaviour follow(Entity entity, double min, double max) {
        return this.moveBehaviour.setFollowEntity(entity, min, max);
    }

    public Move.Behaviour follow(Entity entity, double min) {
        return this.moveBehaviour.setFollowEntity(entity, min);
    }

    public Move.Behaviour follow(Entity entity) {
        return this.moveBehaviour.setFollowEntity(entity);
    }

    public void cancelMoveBehaviour() {
        this.moveBehaviour.cancel();
    }

    public Move.Path setPath(Move.Path.Type type, List<Location> locations) {
        return this.getMoveBehaviour().setPath(locations, type).start();
    }

    public Move.Path setPath(Move.Path.Type type, Location ... locations) {
        return this.setPath(type, Arrays.stream(locations).toList());
    }

    public Move.Path setRepetitivePath(List<Location> locations) {
        return this.setPath(Move.Path.Type.REPETITIVE, locations);
    }

    public Move.Path setRepetitivePath(Location ... locations) {
        return this.setRepetitivePath(Arrays.stream(locations).toList());
    }

    public void setGazeTrackingType(@Nullable GazeTrackingType followLookType) {
        this.attributes.setGazeTrackingType(followLookType);
    }

    public void setHideDistance(double hideDistance) {
        this.attributes.setHideDistance(hideDistance);
    }

    @Deprecated
    public void setTextHideDistance(double textHideDistance) {
        this.attributes.setTextHideDistance(textHideDistance);
    }

    public Updatable setTextLineSpacing(double lineSpacing) {
        return this.needUpdate(this.attributes.setTextLineSpacing(lineSpacing));
    }

    public Updatable resetTextLineSpacing() {
        return this.setTextLineSpacing(Attributes.getDefault().getTextLineSpacing());
    }

    public Updatable setTextAlignment(@Nonnull Vector vector) {
        return this.needUpdate(this.attributes.setTextAlignment(vector));
    }

    public Updatable resetTextAlignment() {
        return this.setTextAlignment(null);
    }

    public void setInteractCooldown(long milliseconds) {
        this.attributes.setInteractCooldown(milliseconds);
    }

    public void resetInteractCooldown() {
        this.setInteractCooldown(Attributes.getDefaultInteractCooldown());
    }

    public Interact.Actions.CustomAction addCustomClickAction(@Nullable Interact.ClickType clickType, @Nonnull BiConsumer<NPC, Player> customAction) {
        return (Interact.Actions.CustomAction)this.addClickAction(new Interact.Actions.CustomAction(this, clickType, customAction));
    }

    public Interact.Actions.CustomAction addCustomClickAction(@Nonnull BiConsumer<NPC, Player> customAction) {
        return this.addCustomClickAction(Interact.ClickType.EITHER, customAction);
    }

    public Interact.Actions.Player.SendChatMessage addMessageClickAction(@Nullable Interact.ClickType clickType, String ... message) {
        return (Interact.Actions.Player.SendChatMessage)this.addClickAction(new Interact.Actions.Player.SendChatMessage(this, clickType, message));
    }

    public Interact.Actions.Player.SendChatMessage addMessageClickAction(String ... message) {
        return this.addMessageClickAction(Interact.ClickType.EITHER, message);
    }

    public Interact.Actions.Player.PerformCommand addRunPlayerCommandClickAction(@Nullable Interact.ClickType clickType, @Nonnull String command) {
        return (Interact.Actions.Player.PerformCommand)this.addClickAction(new Interact.Actions.Player.PerformCommand(this, clickType, command));
    }

    public Interact.Actions.Player.PerformCommand addRunPlayerCommandClickAction(@Nonnull String command) {
        return this.addRunPlayerCommandClickAction(Interact.ClickType.EITHER, command);
    }

    public Interact.Actions.Console.PerformCommand addRunConsoleCommandClickAction(@Nullable Interact.ClickType clickType, @Nonnull String command) {
        return (Interact.Actions.Console.PerformCommand)this.addClickAction(new Interact.Actions.Console.PerformCommand(this, clickType, command));
    }

    public Interact.Actions.Console.PerformCommand addRunConsoleCommandClickAction(@Nonnull String command) {
        return this.addRunConsoleCommandClickAction(Interact.ClickType.EITHER, command);
    }

    public Interact.Actions.Player.ConnectBungeeServer addConnectBungeeServerClickAction(@Nullable Interact.ClickType clickType, @Nonnull String server) {
        return (Interact.Actions.Player.ConnectBungeeServer)this.addClickAction(new Interact.Actions.Player.ConnectBungeeServer(this, clickType, server));
    }

    public Interact.Actions.Player.ConnectBungeeServer addConnectBungeeServerClickAction(@Nonnull String server) {
        return this.addConnectBungeeServerClickAction(Interact.ClickType.EITHER, server);
    }

    public Interact.Actions.Player.SendActionBarMessage addActionBarMessageClickAction(@Nullable Interact.ClickType clickType, @Nonnull String message) {
        return (Interact.Actions.Player.SendActionBarMessage)this.addClickAction(new Interact.Actions.Player.SendActionBarMessage(this, clickType, message));
    }

    public Interact.Actions.Player.SendActionBarMessage addActionBarMessageClickAction(@Nonnull String message) {
        return this.addActionBarMessageClickAction(Interact.ClickType.EITHER, message);
    }

    public Interact.Actions.Player.SendTitleMessage addTitleMessageClickAction(@Nullable Interact.ClickType clickType, @Nonnull String title, @Nonnull String subtitle, int fadeIn, int stay, int fadeOut) {
        return (Interact.Actions.Player.SendTitleMessage)this.addClickAction(new Interact.Actions.Player.SendTitleMessage(this, clickType, title, subtitle, fadeIn, stay, fadeOut));
    }

    public Interact.Actions.Player.SendTitleMessage addTitleMessageClickAction(@Nonnull String title, @Nonnull String subtitle, int fadeIn, int stay, int fadeOut) {
        return this.addTitleMessageClickAction(Interact.ClickType.EITHER, title, subtitle, fadeIn, stay, fadeOut);
    }

    public Interact.Actions.Player.TeleportToLocation addTeleportToLocationClickAction(@Nullable Interact.ClickType clickType, @Nonnull Location location) {
        return (Interact.Actions.Player.TeleportToLocation)this.addClickAction(new Interact.Actions.Player.TeleportToLocation(this, clickType, location));
    }

    public Interact.Actions.Player.TeleportToLocation addTeleportToLocationClickAction(@Nonnull Location location) {
        return this.addTeleportToLocationClickAction(Interact.ClickType.EITHER, location);
    }

    public Interact.Actions.SetCustomData addSetCustomDataClickAction(@Nullable Interact.ClickType clickType, @Nonnull Plugin plugin, @Nonnull String key, @Nullable String value) {
        return (Interact.Actions.SetCustomData)this.addClickAction(new Interact.Actions.SetCustomData(this, clickType, plugin, key, value));
    }

    public Interact.Actions.SetCustomData addSetCustomDataClickAction(@Nonnull Plugin plugin, @Nonnull String key, @Nullable String value) {
        return this.addSetCustomDataClickAction(Interact.ClickType.EITHER, plugin, key, value);
    }

    public Interact.Actions.Player.GiveItem addGivePlayerItemClickAction(@Nullable Interact.ClickType clickType, @Nonnull org.bukkit.inventory.ItemStack itemStack) {
        return (Interact.Actions.Player.GiveItem)this.addClickAction(new Interact.Actions.Player.GiveItem(this, clickType, itemStack));
    }

    public Interact.Actions.Player.GiveItem addGivePlayerItemClickAction(@Nonnull org.bukkit.inventory.ItemStack itemStack) {
        return this.addGivePlayerItemClickAction(Interact.ClickType.EITHER, itemStack);
    }

    public Interact.Actions.Player.OpenWorkbench addOpenWorkbenchClickAction(@Nullable Interact.ClickType clickType) {
        return (Interact.Actions.Player.OpenWorkbench)this.addClickAction(new Interact.Actions.Player.OpenWorkbench(this, clickType));
    }

    public Interact.Actions.Player.OpenWorkbench addOpenWorkbenchClickAction() {
        return this.addOpenWorkbenchClickAction(Interact.ClickType.EITHER);
    }

    @Deprecated
    public Interact.Actions.Player.OpenEnchanting addOpenEnchantingClickAction(@Nullable Interact.ClickType clickType) {
        return (Interact.Actions.Player.OpenEnchanting)this.addClickAction(new Interact.Actions.Player.OpenEnchanting(this, clickType));
    }

    @Deprecated
    public Interact.Actions.Player.OpenEnchanting addOpenEnchantingClickAction() {
        return this.addOpenEnchantingClickAction(Interact.ClickType.EITHER);
    }

    public Interact.Actions.Player.OpenBook addOpenBookClickAction(@Nullable Interact.ClickType clickType, @Nonnull org.bukkit.inventory.ItemStack book) {
        return (Interact.Actions.Player.OpenBook)this.addClickAction(new Interact.Actions.Player.OpenBook(this, clickType, book));
    }

    public Interact.Actions.Player.OpenBook addOpenBookClickAction(@Nonnull org.bukkit.inventory.ItemStack book) {
        return this.addOpenBookClickAction(Interact.ClickType.EITHER, book);
    }

    public Interact.Actions.PlayAnimation addPlayAnimationClickAction(@Nullable Interact.ClickType clickType, @Nonnull Animation animation) {
        return (Interact.Actions.PlayAnimation)this.addClickAction(new Interact.Actions.PlayAnimation(this, clickType, animation));
    }

    public Interact.Actions.PlayAnimation addPlayAnimationClickAction(@Nonnull Animation animation) {
        return this.addPlayAnimationClickAction(Interact.ClickType.EITHER, animation);
    }

    public Interact.Actions.Player.PlaySound addPlayerPlaySoundClickAction(@Nullable Interact.ClickType clickType, @Nonnull Sound sound) {
        return (Interact.Actions.Player.PlaySound)this.addClickAction(new Interact.Actions.Player.PlaySound(this, clickType, sound));
    }

    public Interact.Actions.Player.PlaySound addPlayerPlaySoundClickAction(@Nonnull Sound sound) {
        return this.addPlayerPlaySoundClickAction(Interact.ClickType.EITHER, sound);
    }

    public Interact.Actions.Player.WithdrawMoney addPlayerWithdrawMoneyClickAction(@Nullable Interact.ClickType clickType, @Nonnull Double balance) {
        return (Interact.Actions.Player.WithdrawMoney)this.addClickAction(new Interact.Actions.Player.WithdrawMoney(this, clickType, balance));
    }

    public Interact.Actions.Player.WithdrawMoney addPlayerWithdrawMoneyClickAction(@Nonnull Double balance) {
        return this.addPlayerWithdrawMoneyClickAction(Interact.ClickType.EITHER, balance);
    }

    public Interact.Actions.Player.GiveMoney addPlayerGiveMoneyClickAction(@Nullable Interact.ClickType clickType, @Nonnull Double balance) {
        return (Interact.Actions.Player.GiveMoney)this.addClickAction(new Interact.Actions.Player.GiveMoney(this, clickType, balance));
    }

    public Interact.Actions.Player.GiveMoney addPlayerGiveMoneyClickAction(@Nonnull Double balance) {
        return this.addPlayerGiveMoneyClickAction(Interact.ClickType.EITHER, balance);
    }

    public void resetClickActions(@Nonnull Interact.ClickType clickType) {
        Validate.notNull((Object)((Object)clickType), (String)"Click type cannot be null");
        List remove = this.clickActions.stream().filter(x -> x.getClickType() != null && x.getClickType().equals((Object)clickType) || clickType.equals((Object)Interact.ClickType.EITHER)).collect(Collectors.toList());
        this.clickActions.removeAll(remove);
        if (clickType != Interact.ClickType.EITHER) {
            Interact.ClickType inverse = null;
            if (clickType.equals((Object)Interact.ClickType.RIGHT_CLICK)) {
                inverse = Interact.ClickType.LEFT_CLICK;
            }
            if (clickType.equals((Object)Interact.ClickType.LEFT_CLICK)) {
                inverse = Interact.ClickType.RIGHT_CLICK;
            }
            Interact.ClickType inverseFinal = inverse;
            this.clickActions.stream().filter(x -> x.getClickType().equals((Object)Interact.ClickType.EITHER)).forEach(x -> {
                x.clickType = inverseFinal;
            });
        }
    }

    public void removeClickAction(Interact.ClickAction clickAction) {
        if (this.clickActions.contains(clickAction)) {
            this.clickActions.remove(clickAction);
        }
    }

    public void resetClickActions() {
        this.clickActions = new ArrayList<Interact.ClickAction>();
    }

    public Move.Task goTo(@Nonnull Location end, boolean lookToEnd) {
        Validate.notNull((Object)end, (String)"Cannot move NPC to a null location.");
        Validate.isTrue((boolean)end.getWorld().getName().equals(this.world.getName()), (String)"Cannot move NPC to another world.");
        if (this.moveTask == null) {
            this.moveTask = new Move.Task(this, end, lookToEnd);
            return this.moveTask.start();
        }
        return null;
    }

    public Move.Task goTo(@Nonnull Location end) {
        return this.goTo(end, true);
    }

    public Move.Task goTo(@Nonnull Location end, boolean lookToEnd, @Nullable Move.Speed moveSpeed) {
        this.setMoveSpeed(moveSpeed);
        return this.goTo(end, lookToEnd);
    }

    public Move.Task goTo(@Nonnull Location end, @Nullable Move.Speed moveSpeed) {
        this.setMoveSpeed(moveSpeed);
        return this.goTo(end, true);
    }

    public void cancelMove() {
        if (this.moveTask != null) {
            this.moveTask.cancel(Move.Task.CancelCause.CANCELLED);
        }
        this.clearMoveTask();
    }

    public Updatable setTabListVisibility(TabListVisibility tabListVisibility) {
        return this.needUpdate(this.attributes.setTabListVisibility(tabListVisibility));
    }

    @Deprecated
    public Updatable setShowOnTabList(boolean show) {
        return this.setTabListVisibility(show ? TabListVisibility.ALWAYS : TabListVisibility.NEVER);
    }

    public Updatable setShowNameTag(boolean show) {
        return this.needUpdate(this.attributes.setShowNameTag(show));
    }

    public void setMoveSpeed(@Nullable Move.Speed moveSpeed) {
        moveSpeed = moveSpeed != null ? moveSpeed : Move.Speed.NORMAL;
        this.setMoveSpeed(moveSpeed.doubleValue());
    }

    public void setMoveSpeed(double moveSpeed) {
        this.attributes.setMoveSpeed(moveSpeed);
    }

    public abstract void playAnimation(Animation var1);

    public void playParticle(@Nonnull Particle particle, @Nullable Vector regarding, @Nullable Vector offset, int count, double speed) {
        this.playParticle(particle, regarding, offset, count, speed, null);
    }

    public abstract <T> void playParticle(@Nonnull Particle var1, @Nullable Vector var2, @Nullable Vector var3, int var4, double var5, @Nullable T var7);

    public abstract void hit();

    public Updatable setOnFire(boolean onFire) {
        return this.needUpdate(this.attributes.setOnFire(onFire));
    }

    public Updatable setGroundParticles(boolean groundParticles) {
        return this.needUpdate(this.attributes.setGroundParticles(groundParticles));
    }

    public Updatable setArrowsInBody(int arrowsInBody) {
        return this.needUpdate(this.attributes.setArrowsInBody(arrowsInBody));
    }

    public Updatable setBeeStingersInBody(int beeStingersInBody) {
        return this.needUpdate(this.attributes.setBeeStingersInBody(beeStingersInBody));
    }

    public Updatable setShaking(boolean shaking) {
        return this.needUpdate(this.attributes.setShaking(shaking));
    }

    public void setFireTicks(@Nonnull Integer ticks) {
        this.setOnFire(true).update();
        Bukkit.getScheduler().runTaskLater(this.pluginManager.getPlugin(), () -> {
            if (this.isOnFire()) {
                this.setOnFire(false).update();
            }
        }, ticks.longValue());
    }

    public Updatable setTabListName(@Nullable String tabListName, boolean show) {
        this.setTabListName(tabListName);
        this.setShowOnTabList(show);
        return this.needSimpleUpdate();
    }

    public Updatable resetTabListName() {
        return this.setTabListName(null);
    }

    public Updatable setTabListName(@Nullable String name) {
        return this.needUpdate(this.attributes.setTabListName(name));
    }

    public Updatable resetNameTag() {
        return this.setTabListName(null);
    }

    public Updatable setNameTag(@Nullable @ColorUtils.Colorable(colored=false) String prefix, @Nullable @ColorUtils.Colorable(colored=false) String name, @Nullable @ColorUtils.Colorable(colored=false) String suffix) {
        return this.setNameTag(new NameTag(prefix, name, suffix));
    }

    public Updatable setNameTag(@Nullable NameTag nameTag) {
        return this.needUpdate(this.attributes.setNameTag(nameTag));
    }

    public Updatable setNameTag(@Nullable NameTag nameTag, boolean showNameTag) {
        this.setNameTag(nameTag);
        this.setShowNameTag(showNameTag);
        return this.needForceUpdate();
    }

    public void setCustomData(@Nonnull Plugin plugin, @Nonnull String simpleKey, @Nullable String value) {
        this.setCustomData(NPCLib.Registry.ID.of(plugin, simpleKey), value);
    }

    @Deprecated
    public void setCustomData(@Nonnull String fullKey, @Nonnull String value) {
        this.setCustomData(NPCLib.Registry.ID.of(fullKey), value);
    }

    public void setCustomData(@Nonnull NPCLib.Registry.ID key, @Nullable String value) {
        if (this.customData.contains(key) && value == null) {
            this.customData.remove(key);
            return;
        }
        this.customData.set(key, value);
    }

    public void clearCustomData() {
        this.customData.clear();
    }

    public void clearCustomData(@Nonnull NPCLib.Registry.ID key) {
        this.setCustomData(key, null);
    }

    public void clearCustomData(@Nonnull Plugin plugin, @Nonnull String simpleKey) {
        this.clearCustomData(NPCLib.Registry.ID.of(plugin, simpleKey));
    }

    @Deprecated
    public void clearCustomData(@Nonnull String fullKey) {
        this.clearCustomData(NPCLib.Registry.ID.of(fullKey));
    }

    protected abstract void move(double var1, double var3, double var5);

    protected abstract void updatePlayerRotation();

    protected void setClickActions(@Nonnull List<Interact.ClickAction> clickActions) {
        this.clickActions = clickActions;
    }

    protected void setEquipment(HashMap<Slot, org.bukkit.inventory.ItemStack> slots) {
        this.attributes.setEquipment(slots);
    }

    protected abstract void updateLocation();

    protected abstract void updateMove();

    protected Interact.ClickAction addClickAction(@Nonnull Interact.ClickAction clickAction) {
        this.clickActions.add(clickAction);
        return clickAction;
    }

    protected void clearMoveTask() {
        this.moveTask = null;
    }

    protected boolean needToTick() {
        return this.getTextUpdateTicks() > 0;
    }

    protected BukkitTask checkTick() {
        if (!this.needToTick()) {
            if (this.tick != null && !this.tick.isCancelled()) {
                this.tick.cancel();
            }
            this.tick = null;
            return null;
        }
        if (this.tick != null && !this.tick.isCancelled()) {
            return this.tick;
        }
        AtomicInteger ticks = new AtomicInteger(1);
        this.tick = Bukkit.getScheduler().runTaskTimer(this.getPlugin(), () -> this.tick(ticks.getAndIncrement()), 1L, 1L);
        return this.tick;
    }

    protected void tick(int actualTick) {
        if (!this.needToTick()) {
            this.checkTick();
            return;
        }
        if (actualTick % this.getTextUpdateTicks() == 0) {
            this.simpleUpdateText();
        }
    }

    public Location getLocation() {
        return new Location(this.getWorld(), this.getX().doubleValue(), this.getY().doubleValue(), this.getZ().doubleValue(), this.getYaw().floatValue(), this.getPitch().floatValue());
    }

    public Location getEyeLocation() {
        return this.getLocation().add(0.0, 1.625, 0.0);
    }

    protected HashMap<Slot, org.bukkit.inventory.ItemStack> getEquipment() {
        return this.attributes.equipment;
    }

    public org.bukkit.inventory.ItemStack getEquipment(Slot npcSlot) {
        return this.attributes.equipment.get(npcSlot);
    }

    public double getMoveSpeed() {
        return this.attributes.moveSpeed;
    }

    public Move.Task getMoveTask() {
        return this.moveTask;
    }

    protected Move.Behaviour getMoveBehaviour() {
        return this.moveBehaviour;
    }

    public Move.Behaviour.Type getMoveBehaviourType() {
        return this.moveBehaviour.getType();
    }

    public World getWorld() {
        return this.world;
    }

    public Double getX() {
        return this.x;
    }

    public Double getY() {
        return this.y;
    }

    public Double getZ() {
        return this.z;
    }

    public Float getYaw() {
        return this.yaw;
    }

    public Float getPitch() {
        return this.pitch;
    }

    public NPCLib getNPCLib() {
        return this.pluginManager.getNPCLib();
    }

    @Override
    public NPCLib.Registry.ID getID() {
        return this.id;
    }

    public List<String> getText() {
        return this.attributes.text;
    }

    public org.bukkit.inventory.ItemStack getTextItem() {
        return this.attributes.textItem;
    }

    public boolean isTextItemGlowing() {
        return this.attributes.textItemGlowing;
    }

    public Color getTextItemGlowingColor() {
        return this.attributes.textItemGlowingColor;
    }

    public Integer getTextUpdateTicks() {
        return this.attributes.textUpdateTicks;
    }

    public Skin getSkin() {
        return this.attributes.skin;
    }

    public boolean isCollidable() {
        return this.attributes.collidable;
    }

    public Double getHideDistance() {
        return this.attributes.hideDistance;
    }

    public Double getTextLineSpacing() {
        return this.attributes.textLineSpacing;
    }

    public Vector getTextAlignment() {
        return this.attributes.textAlignment;
    }

    public Long getInteractCooldown() {
        return this.attributes.interactCooldown;
    }

    public Color getGlowingColor() {
        return this.attributes.glowingColor;
    }

    public java.awt.Color getPotionParticlesColor() {
        return this.attributes.potionParticlesColor;
    }

    public PotionParticlesType getPotionParticlesType() {
        return this.attributes.potionParticlesType;
    }

    protected HashMap<Slot, org.bukkit.inventory.ItemStack> getSlots() {
        return this.attributes.equipment;
    }

    public TabListVisibility getTabListVisibility() {
        return this.attributes.tabListVisibility;
    }

    @ColorUtils.Colorable(colored=false)
    @NameTag.Replaceable(replaced=false)
    public String getTabListName() {
        return this.attributes.tabListName;
    }

    public boolean isShowNameTag() {
        return this.attributes.showNameTag;
    }

    public NameTag getNameTag() {
        return this.attributes.nameTag;
    }

    public boolean isGlowing() {
        return this.attributes.glowing;
    }

    public GazeTrackingType getGazeTrackingType() {
        return this.attributes.gazeTrackingType;
    }

    public Pose getPose() {
        return this.attributes.pose;
    }

    public Skin.VisibleLayers getSkinVisibleLayers() {
        return this.attributes.skinVisibleLayers;
    }

    public Hologram.Opacity getLineOpacity(int line) {
        return this.attributes.getTextLineOpacity(line);
    }

    protected HashMap<Integer, Hologram.Opacity> getLinesOpacity() {
        return this.attributes.textLinesOpacity;
    }

    public Hologram.Opacity getTextOpacity() {
        return this.attributes.textOpacity;
    }

    public boolean isOnFire() {
        return this.attributes.onFire;
    }

    public boolean isGroundParticles() {
        return this.attributes.groundParticles;
    }

    public boolean isInvisible() {
        return this.attributes.invisible;
    }

    public Integer getArrowsInBody() {
        return this.attributes.arrowsInBody;
    }

    public Integer getBeeStingersInBody() {
        return this.attributes.beeStingersInBody;
    }

    public Boolean isShaking() {
        return this.attributes.shaking;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public Plugin getPlugin() {
        return this.pluginManager.getPlugin();
    }

    public NPCLib.PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public List<Interact.ClickAction> getClickActions() {
        return this.clickActions.stream().collect(Collectors.toList());
    }

    public Integer getClickActionsSize() {
        return this.clickActions.size();
    }

    public List<Interact.ClickAction> getClickActions(@Nonnull Interact.ClickType clickType) {
        return this.clickActions.stream().filter(x -> x.getClickType() != null && x.getClickType().equals((Object)clickType)).collect(Collectors.toList());
    }

    public Optional<String> grabCustomData(@Nonnull Plugin plugin, @Nonnull String simpleKey) {
        return this.grabCustomData(NPCLib.Registry.ID.of(plugin, simpleKey));
    }

    public Optional<String> grabCustomData(@Nonnull NPCLib.Registry.ID id) {
        return this.customData.grab(id);
    }

    @Deprecated
    public Optional<String> grabCustomData(@Nonnull String fullKey) {
        if (NPCLib.Registry.ID.isFullValid(fullKey)) {
            return this.grabCustomData(NPCLib.Registry.ID.of(fullKey));
        }
        if (NPCLib.Registry.ID.isSimpleValid(fullKey)) {
            return this.grabCustomData(NPCLib.Registry.ID.playerNPC(fullKey));
        }
        return Optional.empty();
    }

    @Deprecated
    @Nullable
    public String getCustomData(@Nonnull Plugin plugin, @Nonnull String simpleKey) {
        return this.grabCustomData(plugin, simpleKey).orElse(null);
    }

    @Deprecated
    @Nullable
    public String getCustomData(@Nonnull NPCLib.Registry.ID id) {
        return this.grabCustomData(id).orElse(null);
    }

    @Deprecated
    @Nullable
    public String getCustomData(@Nonnull String fullKey) {
        return this.grabCustomData(fullKey).orElse(null);
    }

    public Set<String> getCustomDataKeys() {
        return this.customData.getKeys();
    }

    public Set<NPCLib.Registry.ID> getCustomDataKeysID() {
        return this.customData.getKeysID();
    }

    @Deprecated
    public boolean hasCustomData(@Nonnull String fullKey) {
        return this.customData.contains(fullKey.toLowerCase());
    }

    public boolean hasCustomData(@Nonnull NPCLib.Registry.ID key) {
        return this.customData.contains(key);
    }

    public boolean hasCustomData(@Nonnull Plugin plugin, @Nonnull String simpleKey) {
        return this.customData.contains(NPCLib.Registry.ID.of(plugin, simpleKey));
    }

    public static class Move {
        private Move() {
        }

        public static class Task {
            private final NPC npc;
            private Integer taskID;
            private Location start;
            private Location end;
            private boolean pause;
            private boolean lookToEnd;
            private GazeTrackingType lastGazeTrackingType;
            private Pose lastNPCPose;
            private boolean checkSwimming;
            private boolean checkSlabCrouching;
            private boolean checkSlowness;
            private boolean checkLadders;

            private Task(NPC npc, Location end, boolean lookToEnd) {
                this.npc = npc;
                this.end = end;
                this.lookToEnd = lookToEnd;
                this.pause = false;
                this.setPerformanceOptions(PerformanceOptions.ALL);
            }

            protected Task start() {
                this.start = this.npc.getLocation();
                this.lastGazeTrackingType = this.npc.getGazeTrackingType();
                this.lastNPCPose = this.npc.getPose();
                if (this.lookToEnd) {
                    this.npc.setGazeTrackingType(GazeTrackingType.NONE);
                }
                this.taskID = Bukkit.getScheduler().runTaskTimer((Plugin)PlayerNPCPlugin.getInstance(), () -> {
                    if (this.pause) {
                        return;
                    }
                    this.tick();
                }, 1L, 1L).getTaskId();
                Events.StartMove npcStartMoveEvent = new Events.StartMove(this.npc, this.start, this.end, this.taskID);
                if (npcStartMoveEvent.isCancelled()) {
                    this.cancel(CancelCause.CANCELLED);
                    this.npc.teleport(this.start);
                }
                return this;
            }

            private void tick() {
                double moveY;
                if (this.npc instanceof Personal && !((Personal)this.npc).isCreated()) {
                    this.cancel(CancelCause.ERROR);
                    return;
                }
                if (this.npc.getX().equals(this.end.getX()) && this.npc.getZ().equals(this.end.getZ())) {
                    this.cancel(CancelCause.SUCCESS);
                    return;
                }
                double moveX = this.calculateMovement(this.npc.getX(), this.end.getX());
                double moveZ = this.calculateMovement(this.npc.getZ(), this.end.getZ());
                if (moveX != 0.0 && moveZ != 0.0) {
                    if (Math.abs(moveX) > this.npc.getMoveSpeed() / 1.7) {
                        moveX /= 1.7;
                    }
                    if (Math.abs(moveZ) > this.npc.getMoveSpeed() / 1.7) {
                        moveZ /= 1.7;
                    }
                }
                Location from = this.asLocation(this.npc.getX(), this.npc.getY() + 0.1, this.npc.getZ());
                Location to = this.asLocation(this.npc.getX() + moveX, this.npc.getY() + 0.1, this.npc.getZ() + moveZ);
                double locY = this.npc.getY();
                Block blockInLegFrom = from.getBlock();
                Block blockInFootFrom = blockInLegFrom.getRelative(BlockFace.DOWN);
                Block blockInLeg = to.getBlock();
                Block blockInFoot = blockInLeg.getRelative(BlockFace.DOWN);
                boolean uppingLadder = false;
                boolean falling = false;
                boolean jumpingBlock = false;
                if (blockInLeg.getType().isSolid() || this.isStair(blockInLegFrom)) {
                    double jump = 1.0;
                    if (this.isStair(blockInLeg) || this.isSlab(blockInLeg)) {
                        jump = 0.5;
                    } else if (this.checkLadders && this.isLadder(blockInLegFrom)) {
                        uppingLadder = true;
                    } else {
                        jumpingBlock = true;
                    }
                    locY = (double)blockInLeg.getY() + jump;
                } else if (blockInFoot.getType().isSolid()) {
                    locY = this.isSlab(blockInFoot) ? (double)blockInFoot.getY() + 0.5 : (double)blockInLeg.getY();
                } else if (!blockInFootFrom.getType().isSolid()) {
                    locY = (double)blockInFoot.getY() - 0.1;
                    falling = true;
                }
                if (this.checkSwimming) {
                    if (blockInLeg.getType().equals((Object)Material.WATER) && blockInFoot.getType().equals((Object)Material.WATER)) {
                        if (!this.npc.getPose().equals(Pose.SWIMMING)) {
                            this.npc.setPose(Pose.SWIMMING).update();
                        }
                    } else if (this.npc.getPose().equals(Pose.SWIMMING)) {
                        if (this.lastNPCPose.equals(Pose.CROUCHING)) {
                            this.npc.setPose(Pose.CROUCHING).update();
                        } else {
                            this.npc.setPose(Pose.STANDING).update();
                        }
                    }
                }
                if (this.checkSlabCrouching) {
                    if (!blockInLeg.getType().isSolid() && this.isSlab(blockInLeg.getRelative(BlockFace.UP), Slab.Type.TOP) || this.isSlab(blockInLeg) && this.isSlab(blockInLeg.getRelative(BlockFace.UP).getRelative(BlockFace.UP), Slab.Type.BOTTOM)) {
                        if (!this.npc.getPose().equals(Pose.CROUCHING)) {
                            this.npc.setPose(Pose.CROUCHING).update();
                        }
                    } else if (this.npc.getPose().equals(Pose.CROUCHING) && this.lastNPCPose != Pose.CROUCHING) {
                        this.npc.setPose(Pose.STANDING).update();
                    }
                }
                if (this.checkSlowness) {
                    if (blockInLeg.getType().equals((Object)Material.COBWEB) || blockInLeg.getRelative(BlockFace.UP).getType().equals((Object)Material.COBWEB)) {
                        moveX /= 4.0;
                        moveZ /= 4.0;
                    }
                    if (blockInFoot.getType().equals((Object)Material.SOUL_SAND)) {
                        moveX /= 2.0;
                        moveZ /= 2.0;
                    }
                }
                if (this.npc.getPose().equals(Pose.SWIMMING)) {
                    moveX *= 3.0;
                    moveZ *= 3.0;
                    locY = (double)blockInLeg.getY() + 0.5;
                }
                if (this.npc.getPose().equals(Pose.CROUCHING)) {
                    moveX /= 3.0;
                    moveZ /= 3.0;
                }
                if ((moveY = locY - this.npc.getY()) > 1.0) {
                    moveY = 1.0;
                }
                if (moveY < -1.0) {
                    moveY = -1.0;
                }
                if (uppingLadder) {
                    moveX = 0.0;
                    moveZ = 0.0;
                    if (moveY > 0.01) {
                        moveY = 0.05;
                    } else if (moveY < -0.01) {
                        moveY = -0.05;
                    }
                }
                if (jumpingBlock) {
                    moveX /= 2.0;
                    moveZ /= 2.0;
                    if (moveY > 0.2) {
                        moveY = 0.2;
                    }
                }
                if (falling) {
                    moveX /= 4.0;
                    moveZ /= 4.0;
                    if (moveY < -0.4) {
                        moveY = -0.4;
                    }
                }
                if (this.lookToEnd && this.npc.getLocation().getWorld().equals(this.end.getWorld())) {
                    this.npc.lookAt(this.end);
                    this.npc.updatePlayerRotation();
                    if (this.npc.hasPendingUpdate(Updatable.Type.FORCE_UPDATE)) {
                        this.npc.update();
                    }
                }
                this.npc.move(moveX, moveY, moveZ);
            }

            private boolean isLadder(Block block) {
                return block.getType().name().equals("LADDER") || block.getType().name().equals("VINE");
            }

            private boolean isStair(Block block) {
                return block.getType().name().contains("_STAIRS");
            }

            private boolean isSlab(Block block) {
                return this.isSlab(block, Slab.Type.BOTTOM);
            }

            private boolean isSlab(Block block, Slab.Type type) {
                return block.getType().name().contains("_SLAB") && ((Slab)block.getBlockData()).getType().equals((Object)type) || block.getType().name().contains("_BED");
            }

            public boolean isCheckSwimming() {
                return this.checkSwimming;
            }

            public Task setCheckSwimming(boolean checkSwimming) {
                this.checkSwimming = checkSwimming;
                return this;
            }

            public boolean isCheckSlabCrouching() {
                return this.checkSlabCrouching;
            }

            public Task setCheckSlabCrouching(boolean checkSlabCrouching) {
                this.checkSlabCrouching = checkSlabCrouching;
                return this;
            }

            public boolean isCheckSlowness() {
                return this.checkSlowness;
            }

            public Task setCheckSlowness(boolean checkSlowness) {
                this.checkSlowness = checkSlowness;
                return this;
            }

            public boolean isCheckLadders() {
                return this.checkLadders;
            }

            public Task setCheckLadders(boolean checkLadders) {
                this.checkLadders = checkLadders;
                return this;
            }

            public Task setPerformanceOptions(PerformanceOptions performanceOptions) {
                if (performanceOptions == null) {
                    performanceOptions = PerformanceOptions.ALL;
                }
                switch (performanceOptions) {
                    case ALL: {
                        this.setCheckLadders(true);
                        this.setCheckSlowness(true);
                        this.setCheckSlabCrouching(true);
                        this.setCheckSwimming(true);
                        break;
                    }
                    case NONE: {
                        this.setCheckLadders(false);
                        this.setCheckSlowness(false);
                        this.setCheckSlabCrouching(false);
                        this.setCheckSwimming(false);
                    }
                }
                return this;
            }

            private double calculateMovement(double startPoint, double endPoint) {
                double move = 0.0;
                if (startPoint == endPoint) {
                    return move;
                }
                double maxMove = this.npc.getMoveSpeed();
                if (endPoint < startPoint) {
                    move = -maxMove;
                    if (endPoint - startPoint < -move) {
                        move = endPoint - startPoint;
                    }
                } else if (endPoint > startPoint && endPoint - startPoint > (move = maxMove)) {
                    move = endPoint - startPoint;
                }
                if (move > maxMove) {
                    move = maxMove;
                } else if (move < -maxMove) {
                    move = -maxMove;
                }
                return move;
            }

            private Location asLocation(double x, double y, double z) {
                return new Location(this.npc.getWorld(), x, y, z);
            }

            public void pause() {
                this.pause = true;
                if (this.lookToEnd) {
                    this.npc.setGazeTrackingType(this.lastGazeTrackingType);
                }
            }

            public void resume() {
                this.pause = false;
                if (this.lookToEnd) {
                    this.npc.setGazeTrackingType(GazeTrackingType.NONE);
                }
            }

            public boolean isPaused() {
                return this.pause;
            }

            public void cancel() {
                this.cancel(CancelCause.CANCELLED);
            }

            protected void cancel(CancelCause cancelCause) {
                if (this.taskID == null) {
                    return;
                }
                Events.FinishMove npcFinishMoveEvent = new Events.FinishMove(this.npc, this.start, this.end, this.taskID, cancelCause);
                if (this.lookToEnd && cancelCause.equals((Object)CancelCause.SUCCESS)) {
                    this.npc.setGazeTrackingType(this.lastGazeTrackingType);
                    this.npc.updateMove();
                }
                Bukkit.getScheduler().cancelTask(this.taskID.intValue());
                this.taskID = null;
                this.npc.updateLocation();
                this.npc.clearMoveTask();
                if (this.npc.getMoveBehaviour().getType().equals((Object)Behaviour.Type.CUSTOM_PATH) && this.npc.getMoveBehaviour().path != null) {
                    this.npc.getMoveBehaviour().path.next();
                }
            }

            public boolean hasStarted() {
                return this.taskID != null && this.start != null;
            }

            public NPC getNPC() {
                return this.npc;
            }

            public static enum PerformanceOptions {
                ALL,
                NONE;

            }

            public static enum CancelCause {
                SUCCESS,
                CANCELLED,
                ERROR;

            }
        }

        public static class Behaviour {
            private NPC npc;
            private Type type;
            private Integer taskID;
            private Double followMinDistance;
            private Double followMaxDistance;
            private Entity followEntity;
            private NPC followNPC;
            private Path path;

            protected Behaviour(NPC npc) {
                this.npc = npc;
                this.type = Type.NONE;
                this.taskID = null;
                this.followMinDistance = 5.0;
                this.followMaxDistance = 50.0;
                this.followEntity = null;
                this.followNPC = null;
                this.path = null;
            }

            protected void tick() {
                if (this.type == null || this.type.equals((Object)Type.NONE) || this.type.equals((Object)Type.CUSTOM_PATH)) {
                    return;
                }
                if (this.type.equals((Object)Type.FOLLOW_ENTITY) || this.type.equals((Object)Type.FOLLOW_PLAYER) || this.type.equals((Object)Type.FOLLOW_NPC)) {
                    if (this.type.equals((Object)Type.FOLLOW_ENTITY) && this.followEntity == null) {
                        return;
                    }
                    if (this.type.equals((Object)Type.FOLLOW_NPC) && this.followNPC == null) {
                        return;
                    }
                    Location target = null;
                    if (this.type.equals((Object)Type.FOLLOW_ENTITY)) {
                        target = this.followEntity.getLocation();
                    }
                    if (this.type.equals((Object)Type.FOLLOW_PLAYER) && this.npc instanceof Personal) {
                        target = ((Personal)this.npc).player.getLocation();
                    }
                    if (this.type.equals((Object)Type.FOLLOW_NPC)) {
                        target = this.followNPC.getLocation();
                    }
                    if (target == null) {
                        return;
                    }
                    if (!target.getWorld().equals(this.npc.getWorld())) {
                        this.npc.teleport(target);
                        return;
                    }
                    if (this.npc.getMoveTask() == null) {
                        this.npc.goTo(target, true);
                        return;
                    }
                    if (target.distance(this.npc.getLocation()) <= this.followMinDistance) {
                        this.npc.getMoveTask().pause();
                        return;
                    }
                    if (target.distance(this.npc.getLocation()) >= this.followMaxDistance) {
                        this.npc.teleport(target);
                        return;
                    }
                    if (this.npc.getMoveTask().isPaused()) {
                        this.npc.getMoveTask().resume();
                    }
                    this.npc.getMoveTask().end = target;
                    return;
                }
                if (this.type.equals((Object)Type.RANDOM_PATH)) {
                    return;
                }
            }

            public Path setPath(List<Location> locations, Path.Type type) {
                this.setType(Type.CUSTOM_PATH);
                this.path = new Path(this.npc, locations, type);
                return this.path;
            }

            public Behaviour setFollowEntity(Entity entity) {
                return this.setFollowEntity(entity, this.followMinDistance, this.followMaxDistance);
            }

            public Behaviour setFollowEntity(Entity entity, double followMinDistance) {
                return this.setFollowEntity(entity, followMinDistance, this.followMaxDistance);
            }

            public Behaviour setFollowEntity(Entity entity, double followMinDistance, double followMaxDistance) {
                this.setType(Type.FOLLOW_ENTITY);
                this.followEntity = entity;
                this.followMinDistance = followMinDistance;
                this.followMaxDistance = followMaxDistance;
                return this;
            }

            public Behaviour setFollowNPC(NPC npc) {
                return this.setFollowNPC(npc, this.followMinDistance, this.followMaxDistance);
            }

            public Behaviour setFollowNPC(NPC npc, double followMinDistance) {
                return this.setFollowNPC(npc, followMinDistance, this.followMaxDistance);
            }

            public Behaviour setFollowNPC(NPC npc, double followMinDistance, double followMaxDistance) {
                if (npc.equals(this.npc)) {
                    return this;
                }
                if (npc instanceof Personal && this.npc instanceof Global) {
                    return this;
                }
                if (npc instanceof Personal && this.npc instanceof Personal && !((Personal)npc).getPlayer().equals(((Personal)this.npc).getPlayer())) {
                    return this;
                }
                this.setType(Type.FOLLOW_NPC);
                this.followNPC = npc;
                this.followMinDistance = followMinDistance;
                this.followMaxDistance = followMaxDistance;
                return this;
            }

            public Behaviour setFollowPlayer() {
                return this.setFollowPlayer(this.followMinDistance, this.followMaxDistance);
            }

            public Behaviour setFollowPlayer(double followMinDistance, double followMaxDistance) {
                this.setType(Type.FOLLOW_PLAYER);
                this.followMinDistance = followMinDistance;
                this.followMaxDistance = followMaxDistance;
                return this;
            }

            public Behaviour cancel() {
                return this.setType(Type.NONE);
            }

            private Behaviour startTimer() {
                if (this.taskID != null) {
                    return this;
                }
                this.taskID = Bukkit.getScheduler().runTaskTimer((Plugin)PlayerNPCPlugin.getInstance(), () -> this.tick(), 20L, 20L).getTaskId();
                return this;
            }

            private Behaviour finishTimer() {
                if (this.taskID == null) {
                    return this;
                }
                Bukkit.getScheduler().cancelTask(this.taskID.intValue());
                return this;
            }

            private Behaviour setType(Type type) {
                this.type = type;
                if (type == Type.NONE) {
                    this.finishTimer();
                } else {
                    this.startTimer();
                }
                return this;
            }

            public Type getType() {
                return this.type;
            }

            public NPC getNPC() {
                return this.npc;
            }

            public static enum Type {
                NONE,
                FOLLOW_PLAYER,
                FOLLOW_ENTITY,
                FOLLOW_NPC,
                CUSTOM_PATH,
                RANDOM_PATH;


                public boolean isDeprecated() {
                    return EnumUtils.isDeprecated(this);
                }
            }
        }

        protected static class Path {
            private NPC npc;
            private Location start;
            private List<Location> locations;
            private int actual;
            private Type type;

            private Path(NPC npc, List<Location> locations, Type type) {
                this.npc = npc;
                this.locations = locations;
                this.type = type;
                this.actual = -1;
            }

            public Path start() {
                this.start = this.npc.getLocation();
                this.next();
                return this;
            }

            private void next() {
                ++this.actual;
                if (this.actual >= this.locations.size()) {
                    if (this.type.isBackToStart() && this.actual == this.locations.size()) {
                        this.go(this.start);
                        return;
                    }
                    this.finish();
                }
                this.go(this.locations.get(this.actual));
            }

            private void finish() {
                if (this.type.isRepetitive()) {
                    this.actual = -1;
                    this.start();
                    return;
                }
                this.npc.getMoveBehaviour().cancel();
            }

            private void go(Location location) {
                if (this.npc.moveTask == null) {
                    this.npc.goTo(location);
                } else {
                    this.npc.moveTask.end = location;
                }
            }

            public static enum Type {
                NORMAL(false, false),
                REPETITIVE(true, false),
                BACK_TO_START(false, true);

                private boolean repetitive;
                private boolean backToStart;

                private Type(boolean repetitive, boolean backToStart) {
                    this.repetitive = repetitive;
                    this.backToStart = backToStart;
                }

                public boolean isRepetitive() {
                    return this.repetitive;
                }

                public boolean isBackToStart() {
                    return this.backToStart;
                }
            }
        }

        public static enum Speed {
            SLOW(0.1),
            NORMAL(0.15),
            SPRINT(0.2);

            private double speed;

            private Speed(double speed) {
                this.speed = speed;
            }

            public double doubleValue() {
                return this.speed;
            }
        }
    }

    public static abstract class Updatable<N extends NPC> {
        private final Type type;
        private final N npc;

        private Updatable(@Nullable N npc, @Nullable Type type) {
            this.npc = npc;
            this.type = type != null ? type : Type.NONE;
        }

        public abstract void update();

        public abstract boolean hasUpdateNeeded();

        @Nonnull
        public Type getUpdateType() {
            return this.type;
        }

        public void delayUpdate(int ticks) {
            Bukkit.getScheduler().scheduleSyncDelayedTask(((NPC)this.npc).getPlugin(), () -> this.update(), (long)ticks);
        }

        public static enum Type {
            NONE(null, null),
            SIMPLE_UPDATE(n -> n.simpleUpdate(), (g, p) -> g.simpleUpdate((Player)p)),
            FORCE_UPDATE(n -> n.forceUpdate(), (g, p) -> g.forceUpdate((Player)p)),
            SIMPLE_UPDATE_TEXT(n -> n.simpleUpdateText(), (g, p) -> g.simpleUpdateText((Player)p)),
            FORCE_UPDATE_TEXT(n -> n.forceUpdateText(), (g, p) -> g.forceUpdateText((Player)p)),
            SYNCHRONIZE_GLOBAL_ATTRIBUTES(null, (g, p) -> g.synchronizeGlobalAttributes((Player)p));

            private Consumer<NPC> generalAction;
            private BiConsumer<Global, Player> playerAction;

            private Type(Consumer<NPC> generalAction, BiConsumer<Global, Player> playerAction) {
                this.generalAction = generalAction;
                this.playerAction = playerAction;
            }

            public void updatePlayer(Global global, Player player) {
                this.playerAction.accept(global, player);
            }

            public void update(NPC npc) {
                this.generalAction.accept(npc);
            }
        }

        protected static class PendingUpdates<N extends NPC> {
            private final N npc;
            private final List<Updatable> pending;

            private PendingUpdates(N npc) {
                this.npc = npc;
                this.pending = new ArrayList<Updatable>();
            }

            private void addPendingUpdate(Updatable updatable) {
                Validate.isTrue((boolean)updatable.npc.equals(this.npc), (String)"Cannot add this update because it's not the same NPC");
                Type type = updatable.getUpdateType();
                if (type == null) {
                    this.pending.add(updatable);
                    return;
                }
                if (this.containsType(type)) {
                    return;
                }
                switch (type) {
                    case SYNCHRONIZE_GLOBAL_ATTRIBUTES: {
                        if (!this.containsType(Type.SIMPLE_UPDATE) && !this.containsType(Type.FORCE_UPDATE) && !this.containsType(Type.SIMPLE_UPDATE_TEXT) && !this.containsType(Type.FORCE_UPDATE_TEXT)) break;
                        return;
                    }
                    case SIMPLE_UPDATE: 
                    case FORCE_UPDATE_TEXT: {
                        if (this.containsType(Type.FORCE_UPDATE)) {
                            return;
                        }
                        this.checkAndRemove(Type.SYNCHRONIZE_GLOBAL_ATTRIBUTES, Type.SIMPLE_UPDATE_TEXT);
                        break;
                    }
                    case SIMPLE_UPDATE_TEXT: {
                        if (this.containsType(Type.FORCE_UPDATE_TEXT) || this.containsType(Type.FORCE_UPDATE)) {
                            return;
                        }
                        this.checkAndRemove(Type.SYNCHRONIZE_GLOBAL_ATTRIBUTES);
                        break;
                    }
                    case FORCE_UPDATE: {
                        this.checkAndRemove(Type.values());
                    }
                }
                this.pending.add(updatable);
            }

            private boolean containsType(Type type) {
                return this.getContainsType(type) != null;
            }

            @Nullable
            private Updatable getContainsType(Type type) {
                return this.pending.stream().filter(x -> x.getUpdateType() != null && x.getUpdateType().equals((Object)type)).findFirst().orElse(null);
            }

            private void checkAndRemove(Type ... types) {
                Arrays.stream(types).forEach(this::checkAndRemove);
            }

            private void checkAndRemove(Type type) {
                if (this.containsType(type)) {
                    this.pending.remove(this.getContainsType(type));
                }
            }

            protected boolean hasPending() {
                return !this.pending.isEmpty();
            }

            private void clear() {
                this.pending.clear();
            }

            protected void update() {
                if (this.pending.isEmpty()) {
                    return;
                }
                this.pending.forEach(x -> x.update());
                this.clear();
            }

            protected void onExecute(Type type) {
                this.checkAndRemove(type);
                if (this.pending.isEmpty()) {
                    return;
                }
                switch (type) {
                    case SIMPLE_UPDATE: 
                    case FORCE_UPDATE_TEXT: {
                        this.checkAndRemove(Type.SYNCHRONIZE_GLOBAL_ATTRIBUTES, Type.SIMPLE_UPDATE_TEXT);
                        break;
                    }
                    case SIMPLE_UPDATE_TEXT: {
                        this.checkAndRemove(Type.SYNCHRONIZE_GLOBAL_ATTRIBUTES);
                        break;
                    }
                    case FORCE_UPDATE: {
                        this.checkAndRemove(Type.values());
                    }
                }
            }
        }

        protected static class PerPlayer
        extends Updatable<Global> {
            private final Player player;
            private final BiConsumer<Global, Player> action;

            private PerPlayer(@Nullable Global global, @Nullable Type type, @Nullable BiConsumer<Global, Player> action, @Nullable Player player) {
                super(global, type);
                this.player = player;
                this.action = action;
                if (global != null && global.hasPlayer(player)) {
                    global.getPersonal((Player)player).globalPendingUpdates.addPendingUpdate(this);
                }
            }

            private PerPlayer(@Nonnull Global global, @Nonnull Type type, @Nonnull Player player) {
                this(global, type, type.playerAction, player);
            }

            private PerPlayer(@Nonnull Global global, @Nonnull BiConsumer<Global, Player> action, @Nonnull Player player) {
                this(global, null, action, player);
            }

            @Deprecated
            private PerPlayer() {
                this(null, null, null, null);
            }

            @Override
            public void update() {
                if (!this.hasUpdateNeeded() || this.npc == null || this.player == null) {
                    return;
                }
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)PlayerNPCPlugin.getInstance(), () -> {
                    if (!this.getUpdateType().equals((Object)Type.SYNCHRONIZE_GLOBAL_ATTRIBUTES) && !((Global)this.npc).isActive(this.player)) {
                        return;
                    }
                    this.action.accept((Global)this.npc, this.player);
                });
            }

            @Override
            public boolean hasUpdateNeeded() {
                return this.action != null;
            }
        }

        protected static class InGeneral<N extends NPC>
        extends Updatable<N> {
            private final Consumer<N> action;

            private InGeneral(@Nullable N npc, @Nullable Type type, @Nullable Consumer<N> action) {
                super(npc, type);
                this.action = action;
                if (npc != null) {
                    ((NPC)npc).pendingUpdates.addPendingUpdate(this);
                }
            }

            @Deprecated
            private InGeneral() {
                this(null, null, null);
            }

            private InGeneral(@Nonnull N npc, @Nonnull Type type) {
                this((NPC)npc, type, type.generalAction);
            }

            private InGeneral(@Nonnull N npc, @Nonnull Consumer<N> action) {
                this(npc, null, action);
            }

            @Override
            public void update() {
                if (!this.hasUpdateNeeded() || this.npc == null) {
                    return;
                }
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)PlayerNPCPlugin.getInstance(), () -> {
                    if (this.npc instanceof Personal && !((Personal)this.npc).isShownOnClient()) {
                        return;
                    }
                    this.action.accept(this.npc);
                });
            }

            @Override
            public boolean hasUpdateNeeded() {
                return this.action != null;
            }
        }
    }

    public static class Attributes {
        protected static final Double VARIABLE_MIN_LINE_SPACING = 0.27;
        protected static final Double VARIABLE_MAX_LINE_SPACING = 1.0;
        protected static final Double VARIABLE_MAX_TEXT_ALIGNMENT_XZ = 2.0;
        protected static final Double VARIABLE_MAX_TEXT_ALIGNMENT_Y = 5.0;
        protected Skin skin;
        protected Skin.VisibleLayers skinVisibleLayers;
        @ColorUtils.Colorable(colored=false)
        @NameTag.Replaceable(replaced=false)
        protected String tabListName;
        protected NameTag nameTag;
        protected TabListVisibility tabListVisibility;
        protected Boolean showNameTag;
        @ColorUtils.Colorable(colored=false)
        @Placeholders.Replaceable(replaced=false)
        protected List<String> text;
        protected Double textHideDistance;
        protected Double textLineSpacing;
        protected Vector textAlignment;
        protected Hologram.Opacity textOpacity;
        protected HashMap<Integer, Hologram.Opacity> textLinesOpacity;
        protected org.bukkit.inventory.ItemStack textItem;
        protected Boolean textItemGlowing;
        protected Color textItemGlowingColor;
        @TimerUtils.Measured(measure=TimerUtils.Measure.TICKS)
        protected Integer textUpdateTicks;
        protected HashMap<Slot, org.bukkit.inventory.ItemStack> equipment;
        protected Boolean collidable;
        protected Double hideDistance;
        protected GazeTrackingType gazeTrackingType;
        protected Boolean glowing;
        protected Color glowingColor;
        protected Pose pose;
        protected Boolean onFire;
        protected Boolean groundParticles;
        protected java.awt.Color potionParticlesColor;
        protected PotionParticlesType potionParticlesType;
        protected Integer arrowsInBody;
        protected Integer beeStingersInBody;
        protected Boolean shaking;
        protected Boolean invisible;
        @TimerUtils.Measured(measure=TimerUtils.Measure.MILLISECONDS)
        protected Long interactCooldown;
        protected Double moveSpeed;
        private static final Attributes DEFAULT = new Attributes(Skin.Minecraft.getSteveSkin(), new Skin.VisibleLayers(), "\u00a78[NPC] {id}", new NameTag("\u00a78[NPC] ", "{id}", null), TabListVisibility.NEVER, false, new ArrayList<String>(), 50.0, 0.27, new Vector(0.0, 1.75, 0.0), Hologram.Opacity.LOWEST, new HashMap<Integer, Hologram.Opacity>(), new org.bukkit.inventory.ItemStack(Material.AIR), false, Color.WHITE, 0, new HashMap<Slot, org.bukkit.inventory.ItemStack>(), false, 50.0, GazeTrackingType.NONE, false, Color.WHITE, Pose.STANDING, false, false, java.awt.Color.WHITE, PotionParticlesType.DISABLED, 0, 0, false, false, 200L, Move.Speed.NORMAL.doubleValue());

        public Attributes(Skin skin, Skin.VisibleLayers skinVisibleLayers, String tabListName, NameTag nameTag, TabListVisibility tabListVisibility, Boolean showNameTag, List<String> text, Double textHideDistance, Double textLineSpacing, Vector textAlignment, Hologram.Opacity textOpacity, HashMap<Integer, Hologram.Opacity> textLinesOpacity, org.bukkit.inventory.ItemStack textItem, Boolean textItemGlowing, Color textItemGlowingColor, Integer textUpdateTicks, HashMap<Slot, org.bukkit.inventory.ItemStack> equipment, Boolean collidable, Double hideDistance, GazeTrackingType gazeTrackingType, Boolean glowing, Color glowingColor, Pose pose, Boolean onFire, Boolean groundParticles, java.awt.Color potionParticlesColor, PotionParticlesType potionParticlesType, Integer arrowsInBody, Integer beeStingersInBody, Boolean shaking, Boolean invisible, Long interactCooldown, Double moveSpeed) {
            this.skin = skin;
            this.skinVisibleLayers = skinVisibleLayers;
            this.tabListName = tabListName;
            this.nameTag = nameTag;
            this.tabListVisibility = tabListVisibility;
            this.showNameTag = showNameTag;
            this.text = text;
            this.textHideDistance = textHideDistance;
            this.textLineSpacing = textLineSpacing;
            this.textAlignment = textAlignment;
            this.textOpacity = textOpacity;
            this.textLinesOpacity = textLinesOpacity;
            this.textItem = textItem;
            this.textItemGlowing = textItemGlowing;
            this.textItemGlowingColor = textItemGlowingColor;
            this.textUpdateTicks = textUpdateTicks;
            this.equipment = equipment;
            this.collidable = collidable;
            this.hideDistance = hideDistance;
            this.gazeTrackingType = gazeTrackingType;
            this.glowing = glowing;
            this.glowingColor = glowingColor;
            this.pose = pose;
            this.onFire = onFire;
            this.groundParticles = groundParticles;
            this.potionParticlesColor = potionParticlesColor;
            this.potionParticlesType = potionParticlesType;
            this.arrowsInBody = arrowsInBody;
            this.beeStingersInBody = beeStingersInBody;
            this.shaking = shaking;
            this.invisible = invisible;
            this.interactCooldown = interactCooldown;
            this.moveSpeed = moveSpeed;
            Arrays.stream(Slot.values()).filter(x -> !equipment.containsKey(x)).forEach(x -> equipment.put((Slot)x, new org.bukkit.inventory.ItemStack(Material.AIR)));
        }

        protected Attributes() {
        }

        protected static Attributes copyOf(Attributes attributes) {
            return new Attributes(attributes.getSkin(), attributes.getSkinVisibleLayers().clone(), attributes.getTabListName(), attributes.getNameTag().clone(), attributes.getTabListVisibility(), attributes.isShowNameTag(), attributes.getText(), attributes.getTextHideDistance(), attributes.getTextLineSpacing(), attributes.getTextAlignment().clone(), attributes.getTextOpacity(), (HashMap)attributes.getTextLinesOpacity().clone(), attributes.getTextItem().clone(), attributes.isTextItemGlowing(), attributes.getTextItemGlowingColor(), attributes.getTextUpdateTicks(), (HashMap)attributes.getEquipment().clone(), attributes.isCollidable(), attributes.getHideDistance(), attributes.getGazeTrackingType(), attributes.isGlowing(), attributes.getGlowingColor(), attributes.getPose(), attributes.isOnFire(), attributes.isGroundParticles(), attributes.getPotionParticlesColor(), attributes.getPotionParticlesType(), attributes.getArrowsInBody(), attributes.getBeeStingersInBody(), attributes.isShaking(), attributes.isInvisible(), attributes.getInteractCooldown(), attributes.getMoveSpeed());
        }

        public void applyNPC(@Nonnull Personal npc, boolean forceUpdate) {
            this.applyNPC(npc);
            if (forceUpdate) {
                npc.forceUpdate();
            }
        }

        public void applyNPC(@Nonnull Personal npc) {
            Validate.notNull((Object)npc, (String)"Cannot apply NPC.Attributes to a null NPC.");
            npc.setSkin(this.skin);
            npc.setSkinVisibleLayers(this.skinVisibleLayers);
            npc.setTabListName(this.tabListName);
            npc.setNameTag(this.nameTag.clone());
            npc.setTabListVisibility(this.tabListVisibility);
            npc.setShowNameTag(this.showNameTag);
            npc.setText(this.text);
            npc.setTextHideDistance(this.textHideDistance);
            npc.setTextLineSpacing(this.textLineSpacing);
            npc.setTextAlignment(this.textAlignment.clone());
            npc.setTextOpacity(this.textOpacity);
            npc.setTextLinesOpacity((HashMap)this.textLinesOpacity.clone());
            npc.setTextItem(this.textItem.clone());
            npc.setTextItemGlowing(this.textItemGlowing);
            npc.setTextItemGlowingColor(this.textItemGlowingColor);
            npc.setTextUpdateTicks(this.textUpdateTicks);
            npc.setEquipment((HashMap)this.equipment.clone());
            npc.setCollidable(this.collidable);
            npc.setHideDistance(this.hideDistance);
            npc.setGazeTrackingType(this.gazeTrackingType);
            npc.setGlowing(this.glowing);
            npc.setGlowingColor(this.glowingColor);
            npc.setPose(this.pose);
            npc.setOnFire(this.onFire);
            npc.setGroundParticles(this.groundParticles);
            npc.setPotionParticlesColor(this.potionParticlesColor);
            npc.setPotionParticlesType(this.potionParticlesType);
            npc.setArrowsInBody(this.arrowsInBody);
            npc.setBeeStingersInBody(this.beeStingersInBody);
            npc.setShaking(this.shaking);
            npc.setInvisible(this.invisible);
            npc.setInteractCooldown(this.interactCooldown);
            npc.setMoveSpeed(this.moveSpeed);
        }

        public void applyNPC(@Nonnull Collection<Personal> npc) {
            this.applyNPC(npc, false);
        }

        public void applyNPC(@Nonnull Collection<Personal> npc, boolean forceUpdate) {
            Validate.notNull(npc, (String)"Cannot apply NPC.Attributes to a null NPC.");
            npc.forEach(x -> this.applyNPC((Personal)x, forceUpdate));
        }

        public static Attributes getDefault() {
            return DEFAULT;
        }

        public static Attributes getNPCAttributes(@Nonnull NPC npc) {
            Validate.notNull((Object)npc, (String)"Cannot get NPC.Attributes from a null NPC");
            return npc.getAttributes();
        }

        public Skin getSkin() {
            return this.skin;
        }

        public static Skin getDefaultSkin() {
            return DEFAULT.getSkin();
        }

        public static void setDefaultSkin(@Nullable Skin npcSkin) {
            DEFAULT.setSkin(npcSkin);
        }

        protected Updatable.Type setSkin(@Nullable Skin skin) {
            Skin previous = this.skin;
            this.skin = skin != null ? skin : Skin.Minecraft.getSteveSkin();
            return previous != null && previous.hasSameSignedTextureAs(skin) ? Updatable.Type.NONE : Updatable.Type.FORCE_UPDATE;
        }

        public Skin.VisibleLayers getSkinVisibleLayers() {
            return this.skinVisibleLayers;
        }

        public Skin.VisibleLayers getDefaultSkinVisibleLayers() {
            return DEFAULT.getSkinVisibleLayers();
        }

        protected Updatable.Type setSkinVisibleLayers(@Nullable Skin.VisibleLayers skinVisibleLayers) {
            this.skinVisibleLayers = skinVisibleLayers != null ? skinVisibleLayers : new Skin.VisibleLayers();
            return Updatable.Type.SIMPLE_UPDATE;
        }

        public static void setDefaultSkinVisibleLayers(@Nullable Skin.VisibleLayers skinVisibleLayers) {
            DEFAULT.setSkinVisibleLayers(skinVisibleLayers);
        }

        public List<String> getText() {
            return this.text;
        }

        public static List<String> getDefaultText() {
            return DEFAULT.getText();
        }

        protected Updatable.Type setText(@Nullable List<String> text) {
            boolean forceUpdate = this.text == null && text != null && !text.isEmpty() || this.text != null && text == null && !this.text.isEmpty() || this.text != null && text != null && this.text.size() != text.size();
            this.text = text != null ? text : new ArrayList();
            return forceUpdate ? Updatable.Type.FORCE_UPDATE_TEXT : Updatable.Type.SIMPLE_UPDATE_TEXT;
        }

        public static void setDefaultText(@Nullable List<String> text) {
            DEFAULT.setText(text);
        }

        public org.bukkit.inventory.ItemStack getTextItem() {
            return this.textItem;
        }

        public static org.bukkit.inventory.ItemStack getDefaultTextItem() {
            return DEFAULT.getTextItem();
        }

        protected Updatable.Type setTextItem(@Nullable org.bukkit.inventory.ItemStack textItem) {
            this.textItem = textItem != null ? textItem : new org.bukkit.inventory.ItemStack(Material.AIR);
            return Updatable.Type.FORCE_UPDATE_TEXT;
        }

        public static void setDefaultTextItem(@Nullable org.bukkit.inventory.ItemStack itemStack) {
            DEFAULT.setTextItem(itemStack);
        }

        public Boolean isTextItemGlowing() {
            return this.textItemGlowing;
        }

        public static Boolean isDefaultTextItemGlowing() {
            return DEFAULT.isTextItemGlowing();
        }

        protected Updatable.Type setTextItemGlowing(boolean textItemGlowing) {
            this.textItemGlowing = textItemGlowing;
            return Updatable.Type.SIMPLE_UPDATE_TEXT;
        }

        public static void setDefaultTextItemGlowing(boolean textItemGlowing) {
            DEFAULT.setTextItemGlowing(textItemGlowing);
        }

        public Color getTextItemGlowingColor() {
            return this.textItemGlowingColor;
        }

        public static Color getDefaultTextItemGlowingColor() {
            return DEFAULT.getTextItemGlowingColor();
        }

        protected Updatable.Type setTextItemGlowingColor(@Nullable Color textItemGlowingColor) {
            this.textItemGlowingColor = textItemGlowingColor != null ? textItemGlowingColor : Color.WHITE;
            return Updatable.Type.SIMPLE_UPDATE_TEXT;
        }

        public static void setDefaultTextItemGlowingColor(@Nullable Color textItemGlowingColor) {
            DEFAULT.setTextItemGlowingColor(textItemGlowingColor);
        }

        public Integer getTextUpdateTicks() {
            return this.textUpdateTicks;
        }

        public static Integer getDefaultTextUpdateTicks() {
            return DEFAULT.getTextUpdateTicks();
        }

        protected void setTextUpdateTicks(int textUpdateTicks) {
            if (textUpdateTicks < 0) {
                textUpdateTicks = 0;
            }
            this.textUpdateTicks = textUpdateTicks;
        }

        public static void setDefaultTextUpdateTicks(int textUpdateTicks) {
            DEFAULT.setTextUpdateTicks(textUpdateTicks);
        }

        protected HashMap<Slot, org.bukkit.inventory.ItemStack> getEquipment() {
            return this.equipment;
        }

        public org.bukkit.inventory.ItemStack getHelmet() {
            return this.getItem(Slot.HEAD);
        }

        public static org.bukkit.inventory.ItemStack getDefaultHelmet() {
            return DEFAULT.getHelmet();
        }

        protected void setHelmet(@Nullable org.bukkit.inventory.ItemStack itemStack) {
            this.setItem(Slot.HEAD, itemStack);
        }

        public static void setDefaultHelmet(@Nullable org.bukkit.inventory.ItemStack itemStack) {
            DEFAULT.setHelmet(itemStack);
        }

        public org.bukkit.inventory.ItemStack getChestplate() {
            return this.getItem(Slot.CHEST);
        }

        public static org.bukkit.inventory.ItemStack getDefaultChestplate() {
            return DEFAULT.getChestplate();
        }

        protected void setChestplate(@Nullable org.bukkit.inventory.ItemStack itemStack) {
            this.setItem(Slot.CHEST, itemStack);
        }

        public static void setDefaultChestplate(@Nullable org.bukkit.inventory.ItemStack itemStack) {
            DEFAULT.setChestplate(itemStack);
        }

        public org.bukkit.inventory.ItemStack getLeggings() {
            return this.getItem(Slot.LEGS);
        }

        public static org.bukkit.inventory.ItemStack getDefaultLeggings() {
            return DEFAULT.getLeggings();
        }

        protected void setLeggings(@Nullable org.bukkit.inventory.ItemStack itemStack) {
            this.setItem(Slot.LEGS, itemStack);
        }

        public static void setDefaultLeggings(@Nullable org.bukkit.inventory.ItemStack itemStack) {
            DEFAULT.setLeggings(itemStack);
        }

        public org.bukkit.inventory.ItemStack getBoots() {
            return this.getItem(Slot.FEET);
        }

        public static org.bukkit.inventory.ItemStack getDefaultBoots() {
            return DEFAULT.getBoots();
        }

        protected void setBoots(@Nullable org.bukkit.inventory.ItemStack itemStack) {
            this.setItem(Slot.FEET, itemStack);
        }

        public static void setDefaultBoots(@Nullable org.bukkit.inventory.ItemStack itemStack) {
            DEFAULT.setBoots(itemStack);
        }

        protected Updatable.Type setItem(@Nonnull Slot slot, @Nullable org.bukkit.inventory.ItemStack itemStack) {
            Validate.notNull((Object)slot, (String)"Failed to set item, NPCSlot cannot be null");
            this.equipment.put(slot, itemStack != null ? itemStack : new org.bukkit.inventory.ItemStack(Material.AIR));
            return Updatable.Type.SIMPLE_UPDATE;
        }

        public static void setDefaultItem(@Nonnull Slot slot, @Nullable org.bukkit.inventory.ItemStack itemStack) {
            DEFAULT.setItem(slot, itemStack);
        }

        public org.bukkit.inventory.ItemStack getItem(@Nonnull Slot slot) {
            Validate.notNull((Object)slot, (String)"Failed to get item, NPCSlot cannot be null");
            return this.equipment.get(slot);
        }

        public static org.bukkit.inventory.ItemStack getDefaultItem(@Nonnull Slot slot) {
            return DEFAULT.getItem(slot);
        }

        protected static HashMap<Slot, org.bukkit.inventory.ItemStack> getDefaultSlots() {
            return DEFAULT.getEquipment();
        }

        protected void setEquipment(@Nonnull HashMap<Slot, org.bukkit.inventory.ItemStack> equipment) {
            this.equipment = equipment;
        }

        protected static void setDefaultSlots(HashMap<Slot, org.bukkit.inventory.ItemStack> slots) {
            DEFAULT.setEquipment(slots);
        }

        public boolean isCollidable() {
            return this.collidable;
        }

        public static boolean isDefaultCollidable() {
            return DEFAULT.isCollidable();
        }

        protected Updatable.Type setCollidable(boolean collidable) {
            if (this.collidable != null && this.collidable.equals(collidable)) {
                return Updatable.Type.NONE;
            }
            this.collidable = collidable;
            return Updatable.Type.SIMPLE_UPDATE;
        }

        public static void setDefaultCollidable(boolean collidable) {
            DEFAULT.setCollidable(collidable);
        }

        public boolean isGroundParticles() {
            return this.groundParticles;
        }

        public static boolean isDefaultGroundParticles() {
            return DEFAULT.isGroundParticles();
        }

        protected Updatable.Type setGroundParticles(boolean groundParticles) {
            if (this.groundParticles != null && this.groundParticles.equals(groundParticles)) {
                return Updatable.Type.NONE;
            }
            this.groundParticles = groundParticles;
            return Updatable.Type.SIMPLE_UPDATE;
        }

        public static void setDefaultGroundParticles(boolean groundParticles) {
            DEFAULT.setGroundParticles(groundParticles);
        }

        public Double getHideDistance() {
            return this.hideDistance;
        }

        public static Double getDefaultHideDistance() {
            return DEFAULT.getHideDistance();
        }

        protected void setHideDistance(double hideDistance) {
            Validate.isTrue((hideDistance > 0.0 ? 1 : 0) != 0, (String)"The hide distance cannot be negative or 0");
            this.hideDistance = hideDistance;
        }

        public static void setDefaultHideDistance(double hideDistance) {
            DEFAULT.setHideDistance(hideDistance);
        }

        public Double getTextHideDistance() {
            return this.textHideDistance;
        }

        public static Double getDefaultTextHideDistance() {
            return DEFAULT.getTextHideDistance();
        }

        protected void setTextHideDistance(double textHideDistance) {
            Validate.isTrue((textHideDistance > 0.0 ? 1 : 0) != 0, (String)"The text hide distance cannot be negative or 0");
            this.textHideDistance = textHideDistance;
        }

        public static void setDefaultTextHideDistance(double textHideDistance) {
            DEFAULT.setTextHideDistance(textHideDistance);
        }

        public boolean isGlowing() {
            return this.glowing;
        }

        public static boolean isDefaultGlowing() {
            return DEFAULT.isGlowing();
        }

        protected Updatable.Type setGlowing(boolean glowing) {
            this.glowing = glowing;
            return Updatable.Type.SIMPLE_UPDATE;
        }

        public static void setDefaultGlowing(boolean glowing) {
            DEFAULT.setGlowing(glowing);
        }

        public Color getGlowingColor() {
            return this.glowingColor;
        }

        public static Color getDefaultGlowingColor() {
            return DEFAULT.getGlowingColor();
        }

        protected Updatable.Type setGlowingColor(@Nullable Color color) {
            if (color == null) {
                color = Color.WHITE;
            }
            this.glowingColor = color;
            return Updatable.Type.SIMPLE_UPDATE;
        }

        public static void setDefaultGlowingColor(@Nullable Color color) {
            DEFAULT.setGlowingColor(color);
        }

        public Boolean isInvisible() {
            return this.invisible;
        }

        protected Updatable.Type setInvisible(boolean invisible) {
            this.invisible = invisible;
            return Updatable.Type.SIMPLE_UPDATE;
        }

        public static Boolean isDefaultInvisible() {
            return DEFAULT.isInvisible();
        }

        public static void setDefaultInvisible(boolean invisible) {
            DEFAULT.setInvisible(invisible);
        }

        public GazeTrackingType getGazeTrackingType() {
            return this.gazeTrackingType;
        }

        public static GazeTrackingType getDefaultGazeTrackingType() {
            return DEFAULT.getGazeTrackingType();
        }

        protected void setGazeTrackingType(@Nullable GazeTrackingType gazeTrackingType) {
            if (gazeTrackingType == null) {
                gazeTrackingType = GazeTrackingType.NONE;
            }
            this.gazeTrackingType = gazeTrackingType;
        }

        public static void setDefaultGazeTrackingType(@Nullable GazeTrackingType followLookType) {
            DEFAULT.setGazeTrackingType(followLookType);
        }

        public NameTag getNameTag() {
            return this.nameTag;
        }

        public static NameTag getDefaultNameTag() {
            return DEFAULT.getNameTag();
        }

        protected Updatable.Type setNameTag(@Nullable NameTag nameTag) {
            this.nameTag = nameTag != null ? nameTag : DEFAULT.getNameTag().clone();
            return Updatable.Type.FORCE_UPDATE;
        }

        public static void setDefaultNameTag(@Nullable String prefix, @Nullable String suffix) {
            DEFAULT.setNameTag(new NameTag(prefix, "{id}", suffix));
        }

        @Nullable
        @ColorUtils.Colorable(colored=false)
        @NameTag.Replaceable(replaced=false)
        public String getTabListName() {
            return this.tabListName;
        }

        protected Updatable.Type setTabListName(@Nullable @ColorUtils.Colorable(colored=false) @NameTag.Replaceable(replaced=false) String tabListName) {
            this.tabListName = tabListName;
            return Updatable.Type.SIMPLE_UPDATE;
        }

        public Boolean isShowNameTag() {
            return this.showNameTag;
        }

        public Updatable.Type setShowNameTag(boolean showNameTag) {
            this.showNameTag = showNameTag;
            return Updatable.Type.SIMPLE_UPDATE;
        }

        public TabListVisibility getTabListVisibility() {
            return this.tabListVisibility;
        }

        public static TabListVisibility getDefaultTabListVisibility() {
            return DEFAULT.getTabListVisibility();
        }

        protected Updatable.Type setTabListVisibility(@Nullable TabListVisibility tabListVisibility) {
            if (tabListVisibility == null) {
                tabListVisibility = DEFAULT.getTabListVisibility();
            }
            this.tabListVisibility = tabListVisibility;
            return Updatable.Type.FORCE_UPDATE;
        }

        public static void setDefaultTabListVisibility(TabListVisibility tabListVisibility) {
            DEFAULT.setTabListVisibility(tabListVisibility);
        }

        public Long getInteractCooldown() {
            return this.interactCooldown;
        }

        public static Long getDefaultInteractCooldown() {
            return DEFAULT.getInteractCooldown();
        }

        protected void setInteractCooldown(long milliseconds) {
            Validate.isTrue((milliseconds >= 0L ? 1 : 0) != 0, (String)"Error setting interact cooldown, cannot be negative.");
            this.interactCooldown = milliseconds;
        }

        public static void setDefaultInteractCooldown(long interactCooldown) {
            DEFAULT.setInteractCooldown(interactCooldown);
        }

        public Double getTextLineSpacing() {
            return this.textLineSpacing;
        }

        public static Double getDefaultTextLineSpacing() {
            return DEFAULT.getTextLineSpacing();
        }

        protected Updatable.Type setTextLineSpacing(double textLineSpacing) {
            if (textLineSpacing < VARIABLE_MIN_LINE_SPACING) {
                textLineSpacing = VARIABLE_MIN_LINE_SPACING;
            } else if (textLineSpacing > VARIABLE_MAX_LINE_SPACING) {
                textLineSpacing = VARIABLE_MAX_LINE_SPACING;
            }
            this.textLineSpacing = textLineSpacing;
            return Updatable.Type.FORCE_UPDATE_TEXT;
        }

        public static void setDefaultTextLineSpacing(double lineSpacing) {
            DEFAULT.setTextLineSpacing(lineSpacing);
        }

        public Vector getTextAlignment() {
            return this.textAlignment;
        }

        public static Vector getDefaultTextAlignment() {
            return DEFAULT.getTextAlignment();
        }

        protected Updatable.Type setTextAlignment(@Nonnull Vector vector) {
            if (vector == null) {
                vector = DEFAULT.getTextAlignment();
            }
            if (vector.getX() > VARIABLE_MAX_TEXT_ALIGNMENT_XZ) {
                vector.setX(VARIABLE_MAX_TEXT_ALIGNMENT_XZ.doubleValue());
            } else if (vector.getX() < -VARIABLE_MAX_TEXT_ALIGNMENT_XZ.doubleValue()) {
                vector.setX(-VARIABLE_MAX_TEXT_ALIGNMENT_XZ.doubleValue());
            }
            if (vector.getY() > VARIABLE_MAX_TEXT_ALIGNMENT_Y) {
                vector.setY(VARIABLE_MAX_TEXT_ALIGNMENT_Y.doubleValue());
            } else if (vector.getY() < -VARIABLE_MAX_TEXT_ALIGNMENT_Y.doubleValue()) {
                vector.setY(-VARIABLE_MAX_TEXT_ALIGNMENT_Y.doubleValue());
            }
            if (vector.getZ() > VARIABLE_MAX_TEXT_ALIGNMENT_XZ) {
                vector.setZ(VARIABLE_MAX_TEXT_ALIGNMENT_XZ.doubleValue());
            } else if (vector.getZ() < -VARIABLE_MAX_TEXT_ALIGNMENT_XZ.doubleValue()) {
                vector.setZ(-VARIABLE_MAX_TEXT_ALIGNMENT_XZ.doubleValue());
            }
            this.textAlignment = vector;
            return Updatable.Type.FORCE_UPDATE_TEXT;
        }

        public static void setDefaultTextAlignment(Vector textAlignment) {
            DEFAULT.setTextAlignment(textAlignment);
        }

        public Pose getPose() {
            return this.pose;
        }

        public static Pose getDefaultPose() {
            return DEFAULT.getPose();
        }

        protected Updatable.Type setPose(@Nullable Pose pose) {
            Pose previous = this.pose;
            Pose pose2 = this.pose = pose != null ? pose : Pose.STANDING;
            if (previous.equals(this.pose)) {
                return Updatable.Type.NONE;
            }
            return previous.equals(Pose.SPIN_ATTACK) || pose.equals(Pose.STANDING) ? Updatable.Type.FORCE_UPDATE : Updatable.Type.SIMPLE_UPDATE;
        }

        public static void setDefaultPose(@Nullable Pose npcPose) {
            DEFAULT.setPose(npcPose);
        }

        public static Hologram.Opacity getDefaultTextOpacity() {
            return DEFAULT.getTextOpacity();
        }

        public Hologram.Opacity getTextOpacity() {
            return this.textOpacity;
        }

        public static void setDefaultTextOpacity(@Nullable Hologram.Opacity textOpacity) {
            DEFAULT.setTextOpacity(textOpacity);
        }

        protected Updatable.Type setTextOpacity(@Nullable Hologram.Opacity textOpacity) {
            if (textOpacity == null) {
                textOpacity = Hologram.Opacity.LOWEST;
            }
            this.textOpacity = textOpacity;
            return Updatable.Type.FORCE_UPDATE_TEXT;
        }

        public boolean isOnFire() {
            return this.onFire;
        }

        public static boolean isDefaultOnFire() {
            return DEFAULT.isOnFire();
        }

        protected Updatable.Type setOnFire(boolean onFire) {
            this.onFire = onFire;
            return Updatable.Type.SIMPLE_UPDATE;
        }

        public static void setDefaultOnFire(boolean onFire) {
            DEFAULT.setOnFire(onFire);
        }

        public double getMoveSpeed() {
            return this.moveSpeed;
        }

        public static Double getDefaultMoveSpeed() {
            return DEFAULT.getMoveSpeed();
        }

        protected void setMoveSpeed(double moveSpeed) {
            if (moveSpeed <= 0.0) {
                moveSpeed = 0.1;
            }
            this.moveSpeed = moveSpeed;
        }

        protected Updatable.Type setTextLineOpacity(int line, Hologram.Opacity opacity) {
            if (this.textOpacity == null) {
                this.textOpacity = Hologram.Opacity.LOWEST;
            }
            this.textLinesOpacity.put(line, opacity);
            return Updatable.Type.FORCE_UPDATE_TEXT;
        }

        public Hologram.Opacity getTextLineOpacity(int line) {
            return this.textLinesOpacity.getOrDefault(line, Hologram.Opacity.LOWEST);
        }

        protected HashMap<Integer, Hologram.Opacity> getTextLinesOpacity() {
            return this.textLinesOpacity;
        }

        protected void setTextLinesOpacity(HashMap<Integer, Hologram.Opacity> textLinesOpacity) {
            this.textLinesOpacity = textLinesOpacity;
        }

        public void resetTextLineOpacity(int line) {
            if (this.textLinesOpacity.containsKey(line)) {
                this.textLinesOpacity.remove(line);
            }
        }

        public Updatable.Type resetTextLinesOpacity() {
            this.textLinesOpacity = new HashMap();
            return Updatable.Type.FORCE_UPDATE_TEXT;
        }

        public java.awt.Color getPotionParticlesColor() {
            return this.potionParticlesColor;
        }

        public static java.awt.Color getDefaultPotionParticlesColor() {
            return DEFAULT.getPotionParticlesColor();
        }

        public Updatable.Type setPotionParticlesColor(@Nullable java.awt.Color potionParticlesColor) {
            this.potionParticlesColor = potionParticlesColor != null ? potionParticlesColor : java.awt.Color.WHITE;
            return Updatable.Type.SIMPLE_UPDATE;
        }

        public static void setDefaultPotionParticlesColor(@Nullable java.awt.Color potionParticlesColor) {
            DEFAULT.setPotionParticlesColor(potionParticlesColor);
        }

        public PotionParticlesType getPotionParticlesType() {
            return this.potionParticlesType;
        }

        public static PotionParticlesType getDefaultPotionParticlesType() {
            return DEFAULT.getPotionParticlesType();
        }

        public Updatable.Type setPotionParticlesType(@Nullable PotionParticlesType potionParticlesType) {
            this.potionParticlesType = potionParticlesType != null ? potionParticlesType : PotionParticlesType.DISABLED;
            return Updatable.Type.SIMPLE_UPDATE;
        }

        public static void setDefaultPotionParticlesType(@Nullable PotionParticlesType potionParticlesType) {
            DEFAULT.setPotionParticlesType(potionParticlesType);
        }

        public Integer getArrowsInBody() {
            return this.arrowsInBody;
        }

        public static Integer getDefaultArrowsInBody() {
            return DEFAULT.getArrowsInBody();
        }

        protected Updatable.Type setArrowsInBody(int arrowsInBody) {
            int previous = this.arrowsInBody;
            this.arrowsInBody = arrowsInBody < 0 ? 0 : arrowsInBody;
            return previous > 0 && arrowsInBody == 0 ? Updatable.Type.FORCE_UPDATE : Updatable.Type.SIMPLE_UPDATE;
        }

        public void setDefaultArrowsInBody(int arrowsInBody) {
            DEFAULT.setArrowsInBody(arrowsInBody);
        }

        public Integer getBeeStingersInBody() {
            return this.beeStingersInBody;
        }

        public static Integer getDefaultBeeStingersInBody() {
            return DEFAULT.getBeeStingersInBody();
        }

        public Updatable.Type setBeeStingersInBody(int beeStingersInBody) {
            int previous = this.beeStingersInBody;
            this.beeStingersInBody = beeStingersInBody < 0 ? 0 : beeStingersInBody;
            return previous > 0 && this.arrowsInBody == 0 ? Updatable.Type.FORCE_UPDATE : Updatable.Type.SIMPLE_UPDATE;
        }

        public void setDefaultBeeStingersInBody(int beeStingersInBody) {
            DEFAULT.setBeeStingersInBody(beeStingersInBody);
        }

        public Boolean isShaking() {
            return this.shaking;
        }

        public static Boolean isDefaultShaking() {
            return DEFAULT.isShaking();
        }

        protected Updatable.Type setShaking(boolean shaking) {
            if (this.shaking != null && this.shaking.equals(shaking)) {
                return Updatable.Type.NONE;
            }
            this.shaking = shaking;
            return shaking ? Updatable.Type.SIMPLE_UPDATE : Updatable.Type.FORCE_UPDATE;
        }

        public static void setDefaultShaking(boolean shaking) {
            DEFAULT.setShaking(shaking);
        }
    }

    public static enum Slot implements EnumUtils.GetName
    {
        MAINHAND("MAINHAND", null, EquipmentSlot.HAND),
        FEET("FEET", "BOOTS", EquipmentSlot.FEET),
        LEGS("LEGS", "LEGGINGS", EquipmentSlot.LEGS),
        CHEST("CHEST", "CHESTPLATE", EquipmentSlot.CHEST),
        HEAD("HEAD", "HELMET", EquipmentSlot.HEAD),
        OFFHAND("OFFHAND", null, EquipmentSlot.OFF_HAND);

        private final String slotName;
        private final String itemCategoryName;
        private final EnumItemSlot minecraftEnumItemSlot;
        private final EquipmentSlot bukkitEquipmentSlot;

        private Slot(String slotName, String itemCategoryName, EquipmentSlot bukkitEquipmentSlot) {
            this.slotName = slotName;
            this.itemCategoryName = itemCategoryName;
            this.bukkitEquipmentSlot = bukkitEquipmentSlot;
            this.minecraftEnumItemSlot = EnumUtils.getEnumConstant(EnumItemSlot.class, this.slotName);
        }

        @Nonnull
        protected EnumItemSlot asMinecraftEnumItemSlot() {
            return EnumUtils.getEnumConstant(EnumItemSlot.class, this.slotName);
        }

        @Nonnull
        public EquipmentSlot asBukkitEquipmentSlot() {
            return this.bukkitEquipmentSlot;
        }

        public boolean isDeprecated() {
            return EnumUtils.isDeprecated(this);
        }

        public static Optional<Slot> fromName(String name) {
            return Arrays.stream(Slot.values()).filter(x -> x.name().equalsIgnoreCase(name) || x.slotName.equalsIgnoreCase(name)).findFirst();
        }

        protected static Optional<Slot> of(EnumItemSlot minecraftEnumItemSlot) {
            return Arrays.stream(Slot.values()).filter(x -> x.minecraftEnumItemSlot.equals((Object)minecraftEnumItemSlot)).findFirst();
        }

        public static Optional<Slot> of(EquipmentSlot bukkitEquipmentSlot) {
            return Arrays.stream(Slot.values()).filter(x -> x.bukkitEquipmentSlot.equals((Object)bukkitEquipmentSlot)).findFirst();
        }

        @Nullable
        public static Slot of(Material material) {
            if (material == null || material.isAir()) {
                return null;
            }
            if (material.equals((Object)Material.SHIELD)) {
                return OFFHAND;
            }
            if (material.equals((Object)Material.ELYTRA)) {
                return CHEST;
            }
            return Arrays.stream(Slot.values()).filter(x -> x.itemCategoryName != null).filter(x -> material.name().endsWith("_" + x.itemCategoryName)).findFirst().orElse(MAINHAND);
        }
    }

    public static abstract class Skin {
        protected static List<String> SUGGESTED_SKIN_WEBSITES = Arrays.asList("https://mineskin.org/", "https://www.minecraftskins.com/", "https://namemc.com/skin/");
        protected final Type type;
        protected Textures textures;
        protected String lastUpdate;
        protected Avatar avatar;

        private Skin(@Nonnull Type type, @Nonnull String texture, @Nonnull String signature) {
            Validate.notNull((Object)type);
            this.type = type;
            this.textures = new Textures(texture, signature);
            this.avatar = null;
            this.resetLastUpdate();
        }

        public abstract String getName();

        protected abstract void save() throws IOException;

        protected abstract void delete();

        protected abstract File getAvatarFile();

        protected abstract File getTextureFile();

        protected abstract File getDataFile();

        protected abstract String getSkinFolderPath();

        protected boolean needsToUpdate(Plugin plugin) {
            return Skin.needsToUpdate(this.lastUpdate, plugin);
        }

        protected String resetLastUpdate() {
            this.lastUpdate = TimerUtils.getCurrentDate();
            return this.lastUpdate;
        }

        public Integer getTimeFromLastUpdate(TimeUnit timeUnit) {
            return Skin.getTimeFromLastUpdate(this.getLastUpdate(), timeUnit);
        }

        protected static Integer getTimeFromLastUpdate(String lastUpdate, TimeUnit timeUnit) {
            return TimerUtils.getBetweenDatesString(lastUpdate, TimerUtils.getCurrentDate(), TimerUtils.DATE_FORMAT_LARGE, timeUnit);
        }

        protected static boolean needsToUpdate(String lastUpdate, Plugin plugin) {
            NPCLib.SkinUpdateFrequency frequency = NPCLib.getInstance().getPluginManager(plugin).getSkinUpdateFrequency();
            return Skin.getTimeFromLastUpdate(lastUpdate, frequency.timeUnit()) > frequency.value();
        }

        public boolean isLoadedAvatar() {
            return this.avatar != null;
        }

        public CompletableFuture<Avatar> getAvatar() {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    BufferedImage bufferedImage;
                    if (this.avatar != null) {
                        return this.avatar;
                    }
                    if (this.getSkinFolderPath() != null) {
                        if (!this.getAvatarFile().exists()) {
                            this.downloadImages().join();
                        }
                        bufferedImage = ImageIO.read(this.getAvatarFile());
                    } else {
                        bufferedImage = this.downloadTextureImage();
                    }
                    if (bufferedImage == null) {
                        return Avatar.UNKNOWN_AVATAR;
                    }
                    this.avatar = new Avatar(bufferedImage);
                    return this.avatar;
                }
                catch (Exception e) {
                    NPCLib.DebugManager.printError(e);
                    return Avatar.UNKNOWN_AVATAR;
                }
            }).completeOnTimeout(Avatar.UNKNOWN_AVATAR, 5L, TimeUnit.SECONDS);
        }

        protected CompletableFuture<BufferedImage[]> downloadImages() {
            return CompletableFuture.supplyAsync(() -> {
                if (this.getSkinFolderPath() == null) {
                    return null;
                }
                if (this.getTextureFile().exists() && this.getAvatarFile().exists()) {
                    return null;
                }
                try {
                    BufferedImage bufferedImage = this.downloadTextureImage();
                    this.getTextureFile().mkdirs();
                    ImageIO.write((RenderedImage)bufferedImage, "png", this.getTextureFile());
                    BufferedImage avatarResult = Avatar.cropHeadTexture(bufferedImage);
                    this.getAvatarFile().mkdirs();
                    ImageIO.write((RenderedImage)avatarResult, "png", this.getAvatarFile());
                    return new BufferedImage[]{bufferedImage, avatarResult};
                }
                catch (Exception e) {
                    NPCLib.DebugManager.printError(e);
                    return null;
                }
            });
        }

        private BufferedImage downloadTextureImage() throws IOException {
            Validate.notNull((Object)this.textures.getSkinUrl(), (String)"Cannot download images because texture url is null");
            return ImageIO.read(new URL(this.textures.getSkinUrl()));
        }

        public void applyNPC(NPC npc) {
            this.applyNPC(npc, false);
        }

        public void applyNPC(NPC npc, boolean forceUpdate) {
            npc.setSkin(this);
            if (forceUpdate) {
                npc.forceUpdate();
            }
        }

        @Nullable
        public ChatColor getMostCommonColor() {
            if (this.avatar == null) {
                return null;
            }
            return this.avatar.getMostCommonColor();
        }

        public void applyNPCs(Collection<NPC> npcs) {
            this.applyNPCs(npcs, false);
        }

        public void applyNPCs(Collection<NPC> npcs, boolean forceUpdate) {
            npcs.forEach(x -> this.applyNPC((NPC)x, forceUpdate));
        }

        public void applyToPlayer(Player player) {
            this.applyToPlayer(player, null);
        }

        public void applyToPlayer(Player player, Consumer<Player> finishAction) {
            EntityPlayer entityPlayer = NMSCraftPlayer.getEntityPlayer(player);
            GameProfile gameProfile = NMSEntityPlayer.getGameProfile(entityPlayer);
            Property textures = gameProfile.getProperties().get((Object)"textures").stream().filter(x -> x.getName().equals("textures")).findFirst().orElse(null);
            if (textures != null && textures.getValue().equals(this.getTexture())) {
                return;
            }
            Bukkit.getOnlinePlayers().forEach(x -> NMSPacketPlayOutPlayerInfo.removePlayer(x, entityPlayer));
            gameProfile.getProperties().get((Object)"textures").clear();
            gameProfile.getProperties().put((Object)"textures", (Object)this.generateTexturesProperty());
            Location actual = player.getLocation();
            actual.setYaw(player.getLocation().getYaw());
            actual.setPitch(player.getLocation().getPitch());
            boolean isFlying = player.isFlying();
            int heldSlot = player.getInventory().getHeldItemSlot();
            long seed = player.getWorld().getSeed();
            net.minecraft.world.level.World world = NMSEntity.getWorld((net.minecraft.world.entity.Entity)entityPlayer);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)PlayerNPCPlugin.getInstance(), () -> {
                NMSPacketPlayOutRespawn.respawn(player);
                if (ServerVersion.getServerVersion().isNewerThanOrEqual(ServerVersion.VERSION_1_19_3)) {
                    NMSCraftPlayer.sendPacket(player, (Packet)NMSPacketPlayOutEntityMetadata.getPacket((EntityLiving)NMSCraftPlayer.getEntityPlayer(player)));
                }
                player.teleport(actual);
                if (isFlying) {
                    player.setFlying(true);
                }
                player.updateInventory();
                player.getInventory().setHeldItemSlot(heldSlot);
                Bukkit.getOnlinePlayers().forEach(x -> NMSPacketPlayOutPlayerInfo.addPlayer(x, entityPlayer, true));
                if (finishAction != null) {
                    finishAction.accept(player);
                }
                Bukkit.getOnlinePlayers().stream().filter(x -> !x.equals(player)).forEach(x -> {
                    if (x.canSee(player)) {
                        x.hidePlayer((Plugin)PlayerNPCPlugin.getInstance(), player);
                        x.showPlayer((Plugin)PlayerNPCPlugin.getInstance(), player);
                    }
                });
            }, 2L);
        }

        public Property generateTexturesProperty() {
            return this.generateTexturesProperty(true);
        }

        public Property generateTexturesProperty(boolean signed) {
            return new Property("textures", this.getTexture(), signed ? this.getSignature() : null);
        }

        public String getTexture() {
            return this.textures.getEncodedTexture();
        }

        public String getSignature() {
            return this.textures.getSignature();
        }

        public String getLastUpdate() {
            return this.lastUpdate;
        }

        @Nullable
        public Cape getCape() {
            return this.textures.getCape();
        }

        public boolean hasCape() {
            return this.textures.getCape() != null;
        }

        public Type getType() {
            return this.type;
        }

        public Model getModel() {
            return this.textures.getModel();
        }

        public abstract String getInformation();

        public boolean hasSameSignedTextureAs(@Nullable Skin skin) {
            return skin == null ? false : this.getSignedTexture().equals(skin.getSignedTexture());
        }

        public boolean hasSameSignedTextureAs(@Nullable SignedTexture signedTexture) {
            return signedTexture == null ? false : this.getTextureData().getSignedTexture().equals(signedTexture);
        }

        public boolean hasSameTextureAs(@Nullable Skin skin) {
            return skin == null ? false : this.textures.getSkinId().equals(skin.textures.getSkinId());
        }

        public boolean hasSameCapeAs(@Nullable Skin skin) {
            return skin == null ? false : this.textures.getCapeId().equals(skin.textures.getCapeId());
        }

        public boolean hasSameTextureAndCapeAs(@Nullable Skin skin) {
            return skin == null ? false : this.hasSameTextureAs(skin) && this.hasSameCapeAs(skin);
        }

        public boolean isSameTypeAs(@Nullable Skin skin) {
            return skin == null ? false : this.type.equals(skin.getType());
        }

        @Nullable
        public Minecraft castMinecraftSkin() {
            return this.type.equals(Type.MINECRAFT) ? (Minecraft)this : null;
        }

        @Nullable
        public Custom castCustomSkin() {
            return this.type.equals(Type.CUSTOM) ? (Custom)this : null;
        }

        @Nullable
        public MineSkin castMineSkin() {
            return this.type.equals(Type.MINESKIN) ? (MineSkin)this : null;
        }

        public Textures getTextureData() {
            return this.textures;
        }

        public SignedTexture getSignedTexture() {
            return this.textures.getSignedTexture();
        }

        private static String getSkinsFolderPath() {
            return "plugins/PlayerNPC/skins/";
        }

        private static String getSkinsFolderPath(Type type) {
            return Skin.getSkinsFolderPath() + type.name().toLowerCase() + "/";
        }

        public static List<String> getSuggestedSkinWebsites() {
            return SUGGESTED_SKIN_WEBSITES;
        }

        public static enum Type implements EnumUtils.GetName
        {
            MINECRAFT,
            CUSTOM,
            MINESKIN;


            @Nullable
            public static Type fromName(String name) {
                return Arrays.stream(Type.values()).filter(x -> x.name().equalsIgnoreCase(name)).findFirst().orElse(null);
            }
        }

        public static class Textures {
            protected SignedTexture signedTexture;
            protected Cape cape;
            protected Model model;
            protected long timestamp;
            protected String profileId;
            protected String profileName;
            protected boolean signatureRequired;
            protected String skinUrl;
            protected String skinMetadataModel;
            protected String capeUrl;

            protected Textures(@Nonnull String encodedTexture, @Nonnull String signature) {
                Validate.notNull((Object)encodedTexture, (String)"Texture value cannot be null.");
                Validate.notNull((Object)signature, (String)"Signature cannot be null.");
                Validate.isTrue((signature.length() == 684 ? 1 : 0) != 0, (String)"This signature is not valid");
                this.signedTexture = new SignedTexture(encodedTexture, signature);
                byte[] decodedBytes = Base64.getDecoder().decode(encodedTexture);
                String decodedTexture = new String(decodedBytes);
                JsonObject textureJSON = new JsonParser().parse(decodedTexture).getAsJsonObject();
                if (textureJSON.has("timestamp")) {
                    this.timestamp = textureJSON.get("timestamp").getAsLong();
                }
                if (textureJSON.has("profileId")) {
                    this.profileId = textureJSON.get("profileId").getAsString();
                }
                if (textureJSON.has("profileName")) {
                    this.profileName = textureJSON.get("profileName").getAsString();
                }
                if (textureJSON.has("signatureRequired")) {
                    this.signatureRequired = textureJSON.get("signatureRequired").getAsBoolean();
                }
                if (textureJSON.has("textures")) {
                    JsonObject capeElement;
                    JsonObject textureElement = textureJSON.get("textures").getAsJsonObject();
                    if (textureElement.has("SKIN")) {
                        JsonObject skinElement = textureElement.getAsJsonObject("SKIN");
                        if (skinElement.has("url")) {
                            this.skinUrl = skinElement.get("url").getAsString();
                        }
                        this.skinMetadataModel = skinElement.has("metadata") && skinElement.get("metadata").getAsJsonObject().has("model") ? skinElement.get("metadata").getAsJsonObject().get("model").getAsString() : "classic";
                    }
                    if (textureElement.has("CAPE") && (capeElement = textureElement.getAsJsonObject("CAPE")).has("url")) {
                        this.capeUrl = capeElement.get("url").getAsString();
                    }
                }
                Validate.notNull((Object)this.skinUrl, (String)"This texture is not valid");
                this.model = Model.valueOf(this.skinMetadataModel.toUpperCase());
                if (this.capeUrl != null) {
                    this.cape = Arrays.stream(Cape.values()).filter(x -> x.getTextureID().equals(this.getCapeId())).findAny().orElse(null);
                }
            }

            public String getEncodedTexture() {
                return this.signedTexture.texture();
            }

            public String getSignature() {
                return this.signedTexture.signature();
            }

            public SignedTexture getSignedTexture() {
                return this.signedTexture;
            }

            public long getTimestamp() {
                return this.timestamp;
            }

            public String getProfileId() {
                return this.profileId;
            }

            public String getProfileName() {
                return this.profileName;
            }

            public boolean isSignatureRequired() {
                return this.signatureRequired;
            }

            public String getSkinUrl() {
                return this.skinUrl;
            }

            public String getSkinId() {
                return this.skinUrl.replaceFirst("http://textures.minecraft.net/texture/", "");
            }

            public String getSkinMetadataModel() {
                return this.skinMetadataModel;
            }

            public String getCapeUrl() {
                return this.capeUrl;
            }

            public String getCapeId() {
                return this.capeUrl.replaceFirst("http://textures.minecraft.net/texture/", "");
            }

            public boolean hasCape() {
                return this.capeUrl != null;
            }

            public Cape getCape() {
                return this.cape;
            }

            public Model getModel() {
                return this.model;
            }
        }

        public static class Avatar {
            private static Avatar UNKNOWN_AVATAR;
            protected BufferedImage image;
            protected final ChatColor[][] pixels;
            protected final ChatColor mostCommonColor;

            public static Avatar getUnknownAvatar() {
                return UNKNOWN_AVATAR;
            }

            public static BufferedImage cropHeadTexture(BufferedImage skinTexture) {
                return Avatar.cropHeadTexture(skinTexture, true);
            }

            public static BufferedImage cropHeadTexture(BufferedImage skinTexture, boolean overlayHead) {
                BufferedImage avatarResult = new BufferedImage(8, 8, 2);
                BufferedImage bufferedImage2 = skinTexture.getSubimage(8, 8, 8, 8);
                avatarResult.getGraphics().drawImage(bufferedImage2, 0, 0, null);
                if (!overlayHead) {
                    return avatarResult;
                }
                BufferedImage bufferedImage3 = skinTexture.getSubimage(40, 8, 8, 8);
                avatarResult.getGraphics().drawImage(bufferedImage3, 0, 0, null);
                return avatarResult;
            }

            protected Avatar(@Nonnull BufferedImage bufferedImage) {
                Validate.notNull((Object)bufferedImage, (String)"Image cannot be null");
                if (bufferedImage.getHeight() == 64 && bufferedImage.getWidth() == 64) {
                    bufferedImage = Avatar.cropHeadTexture(bufferedImage);
                }
                Validate.isTrue((bufferedImage.getHeight() == 8 && bufferedImage.getWidth() == 8 ? 1 : 0) != 0, (String)"This skin avatar is not 8x8 pixels");
                this.image = bufferedImage;
                this.pixels = new ChatColor[8][8];
                HashMap<Integer, Integer> m = new HashMap<Integer, Integer>();
                for (int y = 0; y < 8; ++y) {
                    for (int x = 0; x < 8; ++x) {
                        int color = bufferedImage.getRGB(x, y);
                        int[] rgb = ColorUtils.getRGB(color);
                        this.pixels[y][x] = ChatColor.of((java.awt.Color)ColorUtils.getColorFromRGB(rgb));
                        if (ColorUtils.isGray(rgb)) continue;
                        if (m.containsKey(color)) {
                            m.put(color, (Integer)m.get(color) + 1);
                            continue;
                        }
                        m.put(color, 1);
                    }
                }
                java.awt.Color mostCommon = ColorUtils.getMostCommonColour(m);
                this.mostCommonColor = mostCommon != null ? ChatColor.of((java.awt.Color)mostCommon) : null;
            }

            protected Avatar(URL url) throws IOException {
                this(ImageIO.read(url));
            }

            protected Avatar(File file) throws IOException {
                this(ImageIO.read(file));
            }

            protected Avatar(ChatColor[][] pixels, ChatColor mostCommonColor) {
                this.pixels = pixels;
                this.mostCommonColor = mostCommonColor;
                this.image = null;
            }

            @Nullable
            public BufferedImage getImage() {
                return this.image;
            }

            @Nonnull
            public ChatColor getPixel(int x, int y) {
                return this.pixels[y][x];
            }

            @Nullable
            public ChatColor getMostCommonColor() {
                return this.mostCommonColor;
            }

            static {
                ChatColor r = ChatColor.of((java.awt.Color)ColorUtils.getColorFromRGB(new int[]{217, 13, 13}));
                ChatColor b = ChatColor.of((java.awt.Color)ColorUtils.getColorFromRGB(new int[]{40, 40, 40}));
                ChatColor[][] pixels = new ChatColor[8][8];
                pixels[0] = new ChatColor[]{b, b, b, b, b, b, b, b};
                pixels[1] = new ChatColor[]{b, b, r, r, r, r, b, b};
                pixels[2] = new ChatColor[]{b, r, r, b, b, r, r, b};
                pixels[3] = new ChatColor[]{b, b, b, b, r, r, b, b};
                pixels[4] = new ChatColor[]{b, b, b, r, r, b, b, b};
                pixels[5] = new ChatColor[]{b, b, b, b, b, b, b, b};
                pixels[6] = new ChatColor[]{b, b, b, r, r, b, b, b};
                pixels[7] = new ChatColor[]{b, b, b, b, b, b, b, b};
                UNKNOWN_AVATAR = new Avatar(pixels, r);
            }
        }

        public static enum Cape {
            MIGRATOR("Migrator", "2340c0e03dd24a11b15a8b33c2a7e9e32abb2051b2481d0ba7defd635ca7a933", 0),
            VANILLA("Vanilla", "f9a76537647989f9a0b6d001e320dac591c359e9e61a31f4ce11c88f207f0ad4", 0),
            MINECON_2011("MineCon 2011", "953cac8b779fe41383e675ee2b86071a71658f2180f56fbce8aa315ea70e2ed6", 1),
            MINECON_2012("MineCon 2012", "a2e8d97ec79100e90a75d369d1b3ba81273c4f82bc1b737e934eed4a854be1b6", 1),
            MINECON_2013("MineCon 2013", "153b1a0dfcbae953cdeb6f2c2bf6bf79943239b1372780da44bcbb29273131da", 1),
            MINECON_2015("MineCon 2015", "b0cc08840700447322d953a02b965f1d65a13a603bf64b17c803c21446fe1635", 1),
            MINECON_2016("MineCon 2016", "e7dfea16dc83c97df01a12fabbd1216359c0cd0ea42f9999b6e97c584963e980", 1),
            REALMS_MAPMAKER("Realms Mapmaker", "17912790ff164b93196f08ba71d0e62129304776d0f347334f8a6eae509f8a56", 1),
            MOJANG("Mojang", "5786fe99be377dfb6858859f926c4dbc995751e91cee373468c5fbf4865e7151", 2),
            TRANSLATOR("Translator", "1bf91499701404e21bd46b0191d63239a4ef76ebde88d27e4d430ac211df681e", 2),
            MOJANG_STUDIOS("Mojang Studios", "9e507afc56359978a3eb3e32367042b853cddd0995d17d0da995662913fb00f7", 2),
            MOJIRA_MODERATOR("Mojira Moderator", "ae677f7d98ac70a533713518416df4452fe5700365c09cf45d0d156ea9396551", 2),
            COBALT("Cobalt", "ca35c56efe71ed290385f4ab5346a1826b546a54d519e6a3ff01efa01acce81", 2),
            MOJANG_CLASSIC("Mojang Classic", "8f120319222a9f4a104e2f5cb97b2cda93199a2ee9e1585cb8d09d6f687cb761", 2),
            SCROLLS("Scrolls", "3efadf6510961830f9fcc077f19b4daf286d502b5f5aafbd807c7bbffcaca245", 2),
            TRANSLATOR_CHINESE("Translator (Chinese)", "2262fb1d24912209490586ecae98aca8500df3eff91f2a07da37ee524e7e3cb6", 2),
            TURTLE("Turtle", "5048ea61566353397247d2b7d946034de926b997d5e66c86483dfb1e031aee95", 2),
            TRANSLATOR_JAPANESE("Translator (Japanese)", "ca29f5dd9e94fb1748203b92e36b66fda80750c87ebc18d6eafdb0e28cc1d05f", 2),
            SPADE("Spade", "2e002d5e1758e79ba51d08d92a0f3a95119f2f435ae7704916507b6c565a7da8", 2),
            SNOWMAN("Snowman", "23ec737f18bfe4b547c95935fc297dd767bb84ee55bfd855144d279ac9bfd9fe", 2),
            MILLIONTH_CUSTOMER("Millionth Customer", "70efffaf86fe5bc089608d3cb297d3e276b9eb7a8f9f2fe6659c23a2d8b18edf", 2),
            DB("dB", "bcfbe84c6542a4a5c213c1cacf8979b5e913dcb4ad783a8b80e3c4a7d5c8bdac", 2),
            PRISMARINE("Prismarine", "d8f8d13a1adf9636a16c31d47f3ecc9bb8d8533108aa5ad2a01b13b1a0c55eac", 2),
            VALENTINE("Valentine"),
            BIRTHDAY("Birthday");

            private Integer rartiy;
            private String name;
            private String textureID;

            private Cape(String name, String textureID, Integer rarity) {
                this.rartiy = rarity;
                this.name = name;
                this.textureID = textureID;
            }

            @Deprecated
            private Cape(String name) {
                this(name, null, null);
            }

            public String getName() {
                return "\u00a7" + (this.rartiy >= 2 ? "d" : (this.rartiy >= 1 ? "b" : "a")) + (this.rartiy >= 2 ? "\u272f " : "") + this.name + (this.rartiy >= 1 ? " \u272f" : "");
            }

            public String getTextureID() {
                return this.textureID;
            }

            public String getTextureURL() {
                return "http://textures.minecraft.net/texture/" + this.textureID;
            }
        }

        public static enum Model implements EnumUtils.GetName
        {
            CLASSIC("Classic", 4, Variant.CLASSIC),
            SLIM("Slim", 3, Variant.SLIM);

            private String name;
            private Variant variant;
            private int pixels;

            private Model(String name, int pixels, Variant variant) {
                this.pixels = pixels;
                this.name = name;
                this.variant = variant;
            }

            @Override
            public String getName() {
                return this.name;
            }

            public int getPixels() {
                return this.pixels;
            }

            public Variant toMineSkinVariant() {
                return this.variant;
            }

            @Nullable
            public static Model fromName(String name) {
                return Arrays.stream(Model.values()).filter(x -> x.name().equalsIgnoreCase(name)).findFirst().orElse(null);
            }
        }

        public record SignedTexture(String texture, String signature) {
            public boolean equals(SignedTexture other) {
                return this.texture.equals(other.texture) && this.signature.equals(other.signature);
            }
        }

        public static class Minecraft
        extends Skin {
            protected static final Minecraft STEVE;
            protected static final Minecraft ALEX;
            protected static final HashMap<String, Minecraft> SKIN_CACHE;
            protected static final List<String> LOCAL_SKIN_NAMES;
            protected final String playerName;
            protected final UUID playerUUID;
            protected final ObtainedFrom obtainedFrom;

            protected Minecraft(@Nonnull String playerName, @Nonnull UUID playerUUID, @Nonnull String texture, @Nonnull String signature, @Nullable ObtainedFrom obtainedFrom) {
                super(Type.MINECRAFT, texture, signature);
                Validate.notNull((Object)playerName);
                Validate.notNull((Object)playerUUID);
                if (obtainedFrom == null) {
                    obtainedFrom = ObtainedFrom.NONE;
                }
                this.playerName = playerName;
                this.playerUUID = playerUUID;
                this.obtainedFrom = obtainedFrom;
                SKIN_CACHE.put(playerName.toLowerCase(), this);
            }

            protected Minecraft(@Nonnull String playerName, @Nonnull String playerUUID, @Nonnull String texture, @Nonnull String signature, @Nullable ObtainedFrom obtainedFrom) {
                this(playerName, UUID.fromString(StringUtils.formatUUID(playerUUID)), texture, signature, obtainedFrom);
            }

            protected Minecraft(@Nonnull String playerName, @Nonnull String playerUUID, @Nonnull SignedTexture signedTexture, @Nullable ObtainedFrom obtainedFrom) {
                this(playerName, playerUUID, signedTexture.texture(), signedTexture.signature(), obtainedFrom);
            }

            protected Minecraft(@Nonnull String playerName, @Nonnull UUID playerUUID, @Nonnull SignedTexture signedTexture, @Nullable ObtainedFrom obtainedFrom) {
                this(playerName, playerUUID, signedTexture.texture(), signedTexture.signature(), obtainedFrom);
            }

            protected Minecraft(@Nonnull Player player) {
                this(player, Minecraft.grabSkinGameProfile(player).orElse(Minecraft.getSteveSkin().getSignedTexture()));
            }

            protected Minecraft(@Nonnull Player player, @Nonnull SignedTexture signedTexture) {
                this(player.getName(), player.getUniqueId(), signedTexture, ObtainedFrom.GAME_PROFILE);
            }

            protected Minecraft(PlayerProfileData profileData) {
                this(profileData.name, profileData.id, profileData.texture, profileData.signature, profileData.obtainedFrom);
            }

            protected Minecraft(YamlConfiguration config) {
                this(config.getString("player.name"), config.getString("player.id"), config.getString("texture.value"), config.getString("texture.signature"), ObtainedFrom.valueOf(config.getString("obtainedFrom")));
            }

            @Override
            public String getName() {
                return this.playerName;
            }

            public String getSimplifiedUUID() {
                return this.playerUUID.toString().replaceAll("-", "");
            }

            public OfflinePlayer getPlayer() {
                return Bukkit.getOfflinePlayer((UUID)this.playerUUID);
            }

            public UUID getUUID() {
                return this.playerUUID;
            }

            public ObtainedFrom getObtainedFrom() {
                return this.obtainedFrom;
            }

            public boolean canBeDeleted() {
                return !this.isMinecraftOriginal();
            }

            public boolean canBeUpdated() {
                return !this.isMinecraftOriginal();
            }

            public boolean isMinecraftOriginal() {
                return this.obtainedFrom.equals((Object)ObtainedFrom.MINECRAFT_ORIGINAL);
            }

            public Custom convertToCustomSkin(Plugin plugin, String skinName) {
                return Custom.createCustomSkin(plugin, skinName, this.textures.getEncodedTexture(), this.textures.getSignature());
            }

            @Deprecated
            public Custom convertToCustomSkin(Plugin plugin) {
                return Custom.createCustomSkin(plugin, this.textures.getEncodedTexture(), this.textures.getSignature());
            }

            @Override
            protected File getAvatarFile() {
                return Minecraft.getAvatarFile(this.playerName);
            }

            @Override
            protected File getTextureFile() {
                return Minecraft.getTextureFile(this.playerName);
            }

            @Override
            protected File getDataFile() {
                return Minecraft.getDataFile(this.playerName);
            }

            @Override
            protected String getSkinFolderPath() {
                return Minecraft.getSkinFolderPath(this.playerName);
            }

            @Override
            public String getInformation() {
                Integer lastUpdateSeconds = this.getTimeFromLastUpdate(TimeUnit.SECONDS);
                String lastUpdateString = lastUpdateSeconds > 5 ? TimerUtils.getCRCounterSimple(lastUpdateSeconds, true) : "moments";
                return "\u00a7e\u00a7lInformation about this skin\n\u00a78Minecraft skin\n\n\u00a7eName: " + (String)(this.getName() != null ? "\u00a77" + this.getName() : "\u00a7cUnknown") + "\n\u00a7eUUID: " + (String)(this.getSimplifiedUUID() != null ? "\u00a77" + this.getSimplifiedUUID() : "\u00a7cUnknown") + "\n\n\u00a7eModel: \u00a7a" + this.getModel().getName() + " \u00a77(" + this.getModel().getPixels() + " pixel arms)\n\u00a7eCape: " + (String)(this.getCape() != null ? "\u00a7d" + this.getCape().getName() : "\u00a7cNone") + "\n\n\u00a7eObtained from: \u00a77" + this.getObtainedFrom().getTitle() + "\n\u00a77\u00a7oLast updated " + lastUpdateString + " ago.";
            }

            private static File getAvatarFile(String playerName) {
                return new File(Minecraft.getSkinFolderPath(playerName) + "/avatar.png");
            }

            private static File getTextureFile(String playerName) {
                return new File(Minecraft.getSkinFolderPath(playerName) + "/texture.png");
            }

            private static File getDataFile(String playerName) {
                return new File(Minecraft.getSkinFolderPath(playerName) + "/data.yml");
            }

            private static String getSkinFolderPath(String playerName) {
                return Skin.getSkinsFolderPath(Type.MINECRAFT) + playerName.toLowerCase();
            }

            @Override
            public void delete() {
                File folder;
                if (!this.canBeDeleted()) {
                    throw new IllegalStateException("This skin cannot be deleted.");
                }
                String playerNameLowerCase = this.playerName.toLowerCase();
                if (SKIN_CACHE.containsKey(playerNameLowerCase)) {
                    SKIN_CACHE.remove(playerNameLowerCase);
                }
                if (LOCAL_SKIN_NAMES.contains(playerNameLowerCase)) {
                    LOCAL_SKIN_NAMES.remove(playerNameLowerCase);
                }
                if (!(folder = new File(Minecraft.getSkinFolderPath(playerNameLowerCase) + "/")).exists()) {
                    return;
                }
                try {
                    NMSFileUtils.deleteDirectory(folder);
                }
                catch (Exception e) {
                    NPCLib.DebugManager.printError(e);
                }
            }

            private static YamlConfiguration loadConfig(String playerName) {
                File file = Minecraft.getDataFile(playerName);
                boolean exist = file.exists();
                if (!exist) {
                    try {
                        file.createNewFile();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                return config;
            }

            @Override
            protected void save() throws IOException {
                File file = this.getDataFile();
                boolean exist = file.exists();
                if (!exist) {
                    try {
                        file.createNewFile();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                config.set("player.name", (Object)this.playerName);
                config.set("player.id", (Object)this.getSimplifiedUUID());
                config.set("texture.value", (Object)this.getTexture());
                config.set("texture.signature", (Object)this.getSignature());
                ArrayList<String> comments = new ArrayList<String>();
                comments.add("Minecraft skin texture: " + this.textures.getSkinUrl());
                if (this.hasCape()) {
                    comments.add("Cape texture: " + this.textures.getCapeUrl());
                }
                NMSFileConfiguration.setComments((FileConfiguration)config, "texture", comments);
                config.set("obtainedFrom", (Object)this.obtainedFrom.name());
                config.set("lastUpdate", (Object)this.resetLastUpdate());
                config.save(file);
                this.downloadImages();
            }

            @Deprecated
            public static void fetchSkinAsync(@Nonnull Player player, Consumer<Minecraft> action) {
                Minecraft.fetchSkinAsync(null, player, false, action);
            }

            @Deprecated
            public static void fetchSkinAsync(@Nonnull Player player, boolean forceDownload, Consumer<Minecraft> action) {
                Minecraft.fetchSkinAsync(null, player, forceDownload, action);
            }

            public static void fetchSkinAsync(Plugin plugin, @Nonnull Player player, Consumer<Minecraft> action) {
                Minecraft.fetchSkinAsync(plugin, player.getName(), false, action);
            }

            public static void fetchSkinAsync(Plugin plugin, @Nonnull Player player, boolean forceDownload, Consumer<Minecraft> action) {
                Minecraft.fetchSkinAsync(plugin, player.getName(), forceDownload, action);
            }

            @Deprecated
            public static CompletableFuture<FetchResult> fetchSkinAsync(@Nonnull Player player) {
                return Minecraft.fetchSkinAsync(player, false);
            }

            @Deprecated
            public static CompletableFuture<FetchResult> fetchSkinAsync(@Nonnull Player player, boolean forceDownload) {
                return Minecraft.fetchSkinAsync(null, player, forceDownload);
            }

            public static CompletableFuture<FetchResult> fetchSkinAsync(Plugin plugin, @Nonnull Player player) {
                return Minecraft.fetchSkinAsync(plugin, player, false);
            }

            public static CompletableFuture<FetchResult> fetchSkinAsync(Plugin plugin, @Nonnull Player player, boolean forceDownload) {
                return Minecraft.fetchSkinAsync(plugin, player.getName(), forceDownload);
            }

            @Deprecated
            public static void fetchSkinAsync(@Nonnull UUID playerUUID, Consumer<Minecraft> action) {
                Minecraft.fetchSkinAsync(null, playerUUID, false, action);
            }

            @Deprecated
            public static void fetchSkinAsync(@Nonnull UUID playerUUID, boolean forceDownload, Consumer<Minecraft> action) {
                Minecraft.fetchSkinAsync(null, playerUUID, forceDownload, action);
            }

            public static void fetchSkinAsync(Plugin plugin, @Nonnull UUID playerUUID, Consumer<Minecraft> action) {
                Minecraft.fetchSkinAsync(plugin, playerUUID, false, action);
            }

            public static void fetchSkinAsync(Plugin plugin, @Nonnull UUID playerUUID, boolean forceDownload, Consumer<Minecraft> action) {
                Minecraft.fetchSkinAsync(plugin, playerUUID.toString(), forceDownload, action);
            }

            @Deprecated
            public static CompletableFuture<FetchResult> fetchSkinAsync(@Nonnull UUID playerUUID) {
                return Minecraft.fetchSkinAsync((Plugin)PlayerNPCPlugin.getInstance(), playerUUID, false);
            }

            @Deprecated
            public static CompletableFuture<FetchResult> fetchSkinAsync(@Nonnull UUID playerUUID, boolean forceDownload) {
                return Minecraft.fetchSkinAsync(null, playerUUID, forceDownload);
            }

            public static CompletableFuture<FetchResult> fetchSkinAsync(Plugin plugin, @Nonnull UUID playerUUID) {
                return Minecraft.fetchSkinAsync(plugin, playerUUID, false);
            }

            public static CompletableFuture<FetchResult> fetchSkinAsync(Plugin plugin, @Nonnull UUID playerUUID, boolean forceDownload) {
                return Minecraft.fetchSkinAsync(plugin, playerUUID.toString(), forceDownload);
            }

            @Deprecated
            public static void fetchSkinAsync(@Nonnull String playerName, Consumer<Minecraft> action) {
                Minecraft.fetchSkinAsync(null, playerName, false, action);
            }

            @Deprecated
            public static void fetchSkinAsync(@Nonnull String playerName, boolean forceDownload, Consumer<Minecraft> action) {
                Minecraft.fetchSkinAsync(null, playerName, forceDownload, action);
            }

            public static void fetchSkinAsync(Plugin plugin, @Nonnull String playerName, Consumer<Minecraft> action) {
                Minecraft.fetchSkinAsync(plugin, playerName, false, action);
            }

            public static void fetchSkinAsync(Plugin plugin, @Nonnull String playerName, boolean forceDownload, Consumer<Minecraft> action) {
                Minecraft.fetchSkinAsync(plugin, playerName, forceDownload).thenAccept(result -> action.accept(result.grabSkin().orElse(null)));
            }

            @Deprecated
            public static CompletableFuture<FetchResult> fetchSkinAsync(@Nonnull String playerName) {
                return Minecraft.fetchSkinAsync(null, playerName, false);
            }

            @Deprecated
            public static CompletableFuture<FetchResult> fetchSkinAsync(@Nonnull String playerName, boolean forceDownload) {
                return Minecraft.fetchSkinAsync(null, playerName, forceDownload);
            }

            public static CompletableFuture<FetchResult> fetchSkinAsync(Plugin plugin, @Nonnull String playerName) {
                return Minecraft.fetchSkinAsync(plugin, playerName, false);
            }

            public static CompletableFuture<FetchResult> fetchSkinAsync(Plugin plugin, @Nonnull String playerName, boolean forceDownload) {
                Validate.notNull((Object)playerName, (String)"Player cannot be null");
                long started = System.currentTimeMillis();
                Object finalPlugin = plugin != null ? plugin : PlayerNPCPlugin.getInstance();
                String playerNameLowerCase = playerName.toLowerCase();
                String possibleUUID = playerName.length() >= 32 ? playerName.replaceAll("-", "") : null;
                CompletableFuture<FetchResult> futureAsync = CompletableFuture.supplyAsync(() -> Minecraft.lambda$fetchSkinAsync$2(forceDownload, possibleUUID, playerNameLowerCase, (Plugin)finalPlugin, started, playerName)).completeOnTimeout(new FetchResult(FetchResult.Error.TIME_OUT), 5L, TimeUnit.SECONDS);
                return futureAsync;
            }

            public static CompletableFuture<FetchResult> fetchSkinMojangAsync(String playerName) {
                long started = System.currentTimeMillis();
                String playerNameLowerCase = playerName.toLowerCase();
                String possibleUUID = playerName.length() >= 32 ? playerName.replaceAll("-", "") : null;
                CompletableFuture<FetchResult> futureAsync = CompletableFuture.supplyAsync(() -> {
                    try {
                        PlayerProfileData data;
                        String uuid = possibleUUID;
                        if (uuid == null) {
                            try {
                                uuid = Minecraft.getUUID(playerNameLowerCase);
                            }
                            catch (IOException e) {
                                return new FetchResult(FetchResult.Error.NO_CONNECTION_TO_MOJANG);
                            }
                            catch (IllegalStateException e) {
                                return new FetchResult(FetchResult.Error.NO_PLAYER_WITH_THAT_NAME);
                            }
                        }
                        try {
                            data = Minecraft.getProfileMojangServer(uuid);
                        }
                        catch (IOException e) {
                            return new FetchResult(FetchResult.Error.NO_CONNECTION_TO_MOJANG);
                        }
                        catch (IllegalStateException e) {
                            return new FetchResult(FetchResult.Error.NO_PLAYER_WITH_THAT_UUID);
                        }
                        Minecraft skin = new Minecraft(data);
                        if (skin.getAvatarFile().exists()) {
                            skin.getAvatarFile().delete();
                        }
                        skin.save();
                        return new FetchResult(skin, started);
                    }
                    catch (Exception e) {
                        NPCLib.DebugManager.printError(e);
                        return new FetchResult(FetchResult.Error.UNKNOWN);
                    }
                }).completeOnTimeout(new FetchResult(FetchResult.Error.TIME_OUT), 5L, TimeUnit.SECONDS);
                return futureAsync;
            }

            public static List<String> getSuggestedSkinNames() {
                ArrayList<String> suggested = new ArrayList<String>();
                Bukkit.getOnlinePlayers().forEach(x -> suggested.add(x.getName().toLowerCase()));
                SKIN_CACHE.keySet().stream().filter(x -> !suggested.contains(x)).forEach(x -> suggested.add(SKIN_CACHE.get(x).getName().toLowerCase()));
                LOCAL_SKIN_NAMES.stream().filter(x -> !suggested.contains(x)).forEach(x -> suggested.add(x.toLowerCase()));
                if (!suggested.contains("sergiferry")) {
                    suggested.add("sergiferry");
                }
                return suggested;
            }

            public boolean isModifiedByThirdParty() {
                return this.obtainedFrom.equals((Object)ObtainedFrom.GAME_PROFILE) && !this.textures.getProfileId().equals(this.getSimplifiedUUID());
            }

            public static boolean hasSkinGameProfile(Player player) {
                EntityPlayer p = NMSCraftPlayer.getEntityPlayer(player);
                GameProfile profile = NMSEntityPlayer.getGameProfile(p);
                return profile.getProperties() != null && profile.getProperties().containsKey((Object)"textures") && !profile.getProperties().get((Object)"textures").isEmpty();
            }

            public static Optional<SignedTexture> grabSkinGameProfile(@Nullable Player player) {
                if (player == null || !player.isOnline()) {
                    return Optional.empty();
                }
                EntityPlayer p = NMSCraftPlayer.getEntityPlayer(player);
                GameProfile profile = NMSEntityPlayer.getGameProfile(p);
                if (profile.getProperties() == null || !profile.getProperties().containsKey((Object)"textures") || profile.getProperties().get((Object)"textures").isEmpty()) {
                    return Optional.empty();
                }
                Property property = (Property)profile.getProperties().get((Object)"textures").iterator().next();
                String texture = property.getValue();
                String signature = property.getSignature();
                return Optional.of(new SignedTexture(texture, signature));
            }

            private static PlayerProfileData getProfileMojangServer(String uuid) throws IOException, JsonParseException {
                URL url2 = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false");
                InputStreamReader reader2 = new InputStreamReader(url2.openStream());
                JsonObject profile = new JsonParser().parse((Reader)reader2).getAsJsonObject();
                JsonObject property = profile.get("properties").getAsJsonArray().get(0).getAsJsonObject();
                return new PlayerProfileData(profile.get("id").getAsString(), profile.get("name").getAsString(), property.get("value").getAsString(), property.get("signature").getAsString(), ObtainedFrom.MOJANG_API);
            }

            private static String getUUID(String name) throws IOException, JsonParseException {
                URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + name);
                InputStreamReader reader = new InputStreamReader(url.openStream());
                JsonObject property = new JsonParser().parse((Reader)reader).getAsJsonObject();
                return property.get("id").getAsString();
            }

            public static Minecraft getSteveSkin() {
                return STEVE;
            }

            public static Minecraft getAlexSkin() {
                return ALEX;
            }

            private static /* synthetic */ FetchResult lambda$fetchSkinAsync$2(boolean forceDownload, String possibleUUID, String playerNameLowerCase, Plugin finalPlugin, long started, String playerName) {
                SignedTexture signedTexture;
                Player player;
                if (!forceDownload && possibleUUID == null) {
                    YamlConfiguration config;
                    String lastUpdate;
                    if (SKIN_CACHE.containsKey(playerNameLowerCase)) {
                        Minecraft skin = SKIN_CACHE.get(playerNameLowerCase);
                        if (!skin.needsToUpdate(finalPlugin)) {
                            return new FetchResult(skin, started);
                        }
                        SKIN_CACHE.remove(playerNameLowerCase);
                    }
                    if (Minecraft.getDataFile(playerNameLowerCase).exists() && !Skin.needsToUpdate(lastUpdate = (config = Minecraft.loadConfig(playerNameLowerCase)).getString("lastUpdate"), finalPlugin)) {
                        if (config.contains("variant")) {
                            config.set("model", (Object)config.getString("variant"));
                        }
                        Minecraft skin = new Minecraft(config);
                        skin.lastUpdate = lastUpdate;
                        LOCAL_SKIN_NAMES.remove(playerName.toLowerCase());
                        return new FetchResult(skin, started);
                    }
                }
                Player player2 = player = possibleUUID == null ? Bukkit.getServer().getPlayerExact(playerName) : null;
                if (player != null && player.isOnline() && (signedTexture = (SignedTexture)Minecraft.grabSkinGameProfile(player).orElse(null)) != null) {
                    Minecraft skin = new Minecraft(player);
                    try {
                        skin.save();
                    }
                    catch (IOException e) {
                        NPCLib.DebugManager.printError(e);
                    }
                    if (skin.getAvatarFile().exists()) {
                        skin.getAvatarFile().delete();
                    }
                    return new FetchResult(skin, started);
                }
                return Minecraft.fetchSkinMojangAsync(playerNameLowerCase).join();
            }

            static {
                SKIN_CACHE = new HashMap();
                STEVE = new Minecraft("MHF_Steve", "c06f89064c8a49119c29ea1dbd1aab82", "ewogICJ0aW1lc3RhbXAiIDogMTY1NjUzMDcyOTgyNiwKICAicHJvZmlsZUlkIiA6ICJjMDZmODkwNjRjOGE0OTExOWMyOWVhMWRiZDFhYWI4MiIsCiAgInByb2ZpbGVOYW1lIiA6ICJNSEZfU3RldmUiLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWE0YWY3MTg0NTVkNGFhYjUyOGU3YTYxZjg2ZmEyNWU2YTM2OWQxNzY4ZGNiMTNmN2RmMzE5YTcxM2ViODEwYiIKICAgIH0KICB9Cn0=", "D5KDlE7KmMYeo+n0bY7kRjxdoZ8ondpgLC0tVcDW/wER9tRAWGlkaUyC4cUjkiYtMFANOxnPNz42iWg+gKAX/qE3lKoJpFw8LmgC587QpEDZTsIwzrIriDDiUc+RQ83VNzy9lkrzm+/llFhuPmONhWIeoVgXQYnJXFXOjTA3uiqHq6IJR4fZzD+0lSpr8jm0X1B+XAiAV7xbzMjg2woC3ur7+81Ub27MNGdAmI5eh50rqqjIHx+kRHJPPB3klbAdkTkcnF2rhDuP9jLtJbb17L+40yR8MH3G1AsRBg+N9MlGb4qF3fK9m2lDNxrGpVe+5fj4ffHnTJ680X9O8cnGxtHFyHm3I65iIhVgFY/DQQ6XSxLgPrmdyVOV98OATc7g2/fFpiI6aRzFrXvCLzXcBzmcayhv8BgG8yBlHdYmMZScjslLKjgWB9mgtOh5ZFFb3ZRkwPvdKUqCQHDPovo9K3LwyAtg9QwJ7u+HN03tpDWllXIjT3mKrtsfWMorNNQ5Bh1St0If4Dg00tpW/DUwNs+oua0PhN/DbFEe3aog2jVfzy3IAXqW2cqiZlnRSm55vMrr1CI45PgjP2LS1c9OYJJ3k+ov4IdvBpDTiG9PfsPWcwtqm8ujxy/TqIWfSajL/RP+TFDoN/F8j8HhHU8wwA9JXJekmvUExEOxPWwisLA=", ObtainedFrom.MINECRAFT_ORIGINAL);
                SKIN_CACHE.put(Minecraft.STEVE.playerName.toLowerCase(), STEVE);
                ALEX = new Minecraft("MHF_Alex", "6ab4317889fd490597f60f67d9d76fd9", "ewogICJ0aW1lc3RhbXAiIDogMTY1NjU3Nzg5MTQ2NywKICAicHJvZmlsZUlkIiA6ICI2YWI0MzE3ODg5ZmQ0OTA1OTdmNjBmNjdkOWQ3NmZkOSIsCiAgInByb2ZpbGVOYW1lIiA6ICJNSEZfQWxleCIsCiAgInNpZ25hdHVyZVJlcXVpcmVkIiA6IHRydWUsCiAgInRleHR1cmVzIiA6IHsKICAgICJTS0lOIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS84M2NlZTVjYTZhZmNkYjE3MTI4NWFhMDBlODA0OWMyOTdiMmRiZWJhMGVmYjhmZjk3MGE1Njc3YTFiNjQ0MDMyIiwKICAgICAgIm1ldGFkYXRhIiA6IHsKICAgICAgICAibW9kZWwiIDogInNsaW0iCiAgICAgIH0KICAgIH0KICB9Cn0=", "d2dYqFQpP2ZjeUROSm23WTdWhWnuaW68v8Biw4towx04vJMRls95W/gmIFGa2Tq171yXHlE8kpP2KFe3jAC7qukkXjDiXSRdCSOYZPA7N91Uw6amyt7x5IKZ90QK8BxE1mCjV7KJNGZ28u8klbf1QUOB4fE27gEfQYGyEcSrkPa4e/QzmOGYbnyiIt36np/qBtWHf87brRdVeKRNfO/ExCJkKbwpKfyGf06luCAfUW9wuHkFURux9naU+ilk2ZHUsPVBdkmfOXZrdxxdpDE19W5VkFryMbtVP5XNEBVC7SAsllHXrf8nskgk+m57bCPMP6RF8k+h+mXIJMuQd7yd7azOAnyLlOoufyY1hs1Po+EGDOSQUUHQKTi7AEYp2C71DpkqpGuPCbL/DkxchblYW5iuIek+BmO3wXbmBPv+0gWkiP/c1n605X0g+h4oO5yQqyI8Fki9F2Hb8T5QeHmC3+yzVVf7gOQ6MB7bBt+uX9wcl5yYBDHbmYGZtbNko7dq584FZKRRWeVhxdcDUXfdfzKmNR73BUIEqzeyOh2hUrk47VHK5d5FajKzgi9j5U8D0EJKjVMPZiulcF0J/ZQ4EOxUkOTNPuphiu43j1C7NXZ4RaPFrSrg7QMsObitqLUP5Pmq15Edg7vpvYME8Fe5Ia8sXLbNDHd3AWuXnfpeAUE=", ObtainedFrom.MINECRAFT_ORIGINAL);
                SKIN_CACHE.put(Minecraft.ALEX.playerName.toLowerCase(), ALEX);
                LOCAL_SKIN_NAMES = new ArrayList<String>();
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)PlayerNPCPlugin.getInstance(), () -> {
                    File folder = new File(Skin.getSkinsFolderPath(Type.MINECRAFT));
                    if (!folder.exists() || !folder.isDirectory()) {
                        return;
                    }
                    for (File skin : folder.listFiles()) {
                        if (!skin.isDirectory()) continue;
                        LOCAL_SKIN_NAMES.add(skin.getName());
                    }
                });
            }

            public static enum ObtainedFrom {
                MOJANG_API("\u00a7aMojang API"),
                GAME_PROFILE("\u00a7aGame Profile"),
                MINECRAFT_ORIGINAL("\u00a7aMinecraft Original"),
                NONE("\u00a7cUnknown");

                private String title;

                private ObtainedFrom(String title) {
                    this.title = title;
                }

                public String getTitle() {
                    return this.title;
                }
            }

            private record PlayerProfileData(String id, String name, String texture, String signature, ObtainedFrom obtainedFrom) {
            }

            public static class FetchResult
            extends dev.sergiferry.playernpc.api.NPC$Skin$FetchResult<Minecraft, Error> {
                protected FetchResult(@Nullable Minecraft skin, long started) {
                    this.started = started;
                    this.skin = Optional.ofNullable(skin);
                    this.error = super.grabSkin().isPresent() ? Optional.empty() : Optional.of(Error.UNKNOWN);
                }

                protected FetchResult(@Nullable Error error) {
                    this.skin = Optional.empty();
                    this.error = Optional.of(error != null ? error : Error.UNKNOWN);
                }

                public static enum Error implements dev.sergiferry.playernpc.api.NPC$Skin$FetchResult$Error
                {
                    UNKNOWN("There was an error trying to fetch that skin."),
                    NO_PLAYER_WITH_THAT_NAME("No player with that name has been found."),
                    NO_PLAYER_WITH_THAT_UUID("No player with that UUID has been found."),
                    NO_CONNECTION_TO_MOJANG("Failed to establish connection to Mojang servers."),
                    TIME_OUT("Mojang server has exceeded the maximum response time.");

                    private String message;

                    private Error(String message) {
                        this.message = message;
                    }

                    @Override
                    @Nonnull
                    public String getMessage() {
                        return this.message != null ? this.message : Error.UNKNOWN.message;
                    }

                    @Override
                    public String toString() {
                        return this.getMessage();
                    }
                }
            }
        }

        public static class Custom
        extends Skin
        implements NPCLib.Registry.Identified {
            protected static final NPCLib.Registry<Custom> SKIN_CACHE = new NPCLib.Registry(NPCLib.Registry.ID.playerNPC("customSkins"));
            private final String skinName;
            private final Plugin plugin;
            private NPCLib.Registry.ID id;

            protected static void onUnregisterPlugin(Plugin plugin) {
                HashSet remove = new HashSet();
                SKIN_CACHE.entrySet().stream().filter(x -> ((Custom)x.getValue()).getPluginInfo().getName().equals(plugin.getDescription().getName())).forEach(x -> {
                    File folder;
                    if (((Custom)x.getValue()).getName() != null && (folder = new File(((Custom)x.getValue()).getSkinFolderPath() + "/")).exists() && !((Custom)x.getValue()).getDataFile().exists()) {
                        try {
                            NMSFileUtils.deleteDirectory(folder);
                        }
                        catch (Exception e) {
                            NPCLib.DebugManager.printError(e);
                        }
                    }
                    remove.add(NPCLib.Registry.ID.of((String)x.getKey()));
                });
                remove.forEach(x -> SKIN_CACHE.remove((NPCLib.Registry.ID)x));
            }

            private Custom(@Nonnull Plugin plugin, @Nullable String skinName, @Nonnull String texture, @Nonnull String signature) {
                super(Type.CUSTOM, texture, signature);
                Validate.notNull((Object)plugin, (String)"Plugin cannot be null.");
                this.plugin = plugin;
                this.skinName = skinName;
                if (skinName == null) {
                    return;
                }
                this.id = NPCLib.Registry.ID.of(plugin, skinName);
                Validate.isTrue((!SKIN_CACHE.contains(this.id) ? 1 : 0) != 0, (String)"Custom texture skin with this name already exists.");
                SKIN_CACHE.set(this.id, this);
            }

            private Custom(Plugin plugin, String texture, String signature) {
                this(plugin, null, texture, signature);
            }

            @Override
            @Nullable
            public String getName() {
                return this.skinName;
            }

            @Override
            @Nullable
            public NPCLib.Registry.ID getID() {
                return this.id;
            }

            public boolean hasID() {
                return this.id != null;
            }

            @Nonnull
            public PluginDescriptionFile getPluginInfo() {
                return this.plugin.getDescription();
            }

            public void changeTexture(Plugin plugin, String texture, String signature) {
                Validate.isTrue((boolean)plugin.equals(this.plugin), (String)"This plugin is not the owner of this custom skin.");
                this.textures = new Textures(texture, signature);
                if (this.getAvatarFile().exists()) {
                    this.getAvatarFile().delete();
                }
                if (this.getTextureFile().exists()) {
                    this.getTextureFile().delete();
                }
                try {
                    this.save();
                }
                catch (Exception e) {
                    NPCLib.DebugManager.printError(e);
                }
            }

            public static CompletableFuture<FetchResult> fetchCustomSkinAsync(@Nonnull Plugin skinPlugin, @Nonnull String skinName) {
                return Custom.fetchCustomSkinAsync(NPCLib.Registry.ID.of(skinPlugin, skinName));
            }

            public static CompletableFuture<FetchResult> fetchCustomSkinAsync(@Nonnull String fullID) {
                return Custom.fetchCustomSkinAsync(NPCLib.Registry.ID.of(fullID));
            }

            public static CompletableFuture<FetchResult> fetchCustomSkinAsync(@Nonnull NPCLib.Registry.ID id) {
                Validate.notNull((Object)id, (String)"ID cannot be null");
                long started = System.currentTimeMillis();
                CompletableFuture<FetchResult> futureSkin = CompletableFuture.supplyAsync(() -> {
                    if (!SKIN_CACHE.contains(id)) {
                        return new FetchResult(FetchResult.Error.NO_SKIN_WITH_THAT_NAME);
                    }
                    return new FetchResult(SKIN_CACHE.grab(id).get(), started);
                }).completeOnTimeout(new FetchResult(FetchResult.Error.TIME_OUT), 5L, TimeUnit.SECONDS);
                return futureSkin;
            }

            @Deprecated
            public static boolean isLoadedSkin(String fullID) {
                return Custom.isLoadedSkin(NPCLib.Registry.ID.of(fullID));
            }

            public static boolean isLoadedSkin(Plugin plugin, String skinName) {
                return Custom.isLoadedSkin(NPCLib.Registry.ID.of(plugin, skinName));
            }

            public static boolean isLoadedSkin(NPCLib.Registry.ID id) {
                return SKIN_CACHE.contains(id);
            }

            @Deprecated
            public static Optional<Custom> getLoadedSkin(String skinCode) {
                return Custom.getLoadedSkin(NPCLib.Registry.ID.of(skinCode));
            }

            public static Optional<Custom> getLoadedSkin(Plugin plugin, String skinName) {
                return Custom.getLoadedSkin(NPCLib.Registry.ID.of(plugin, skinName));
            }

            public static Optional<Custom> getLoadedSkin(NPCLib.Registry.ID id) {
                return Optional.ofNullable(SKIN_CACHE.grab(id).orElse(null));
            }

            public static Custom createCustomSkin(@Nonnull Plugin plugin, @Nonnull String skinName, @Nonnull String texture, @Nonnull String signature) {
                Validate.isTrue((!SKIN_CACHE.contains(NPCLib.Registry.ID.of(plugin, skinName)) ? 1 : 0) != 0, (String)"Custom texture skin with this name already exists.");
                return new Custom(plugin, skinName, texture, signature);
            }

            public static Custom createCustomSkin(@Nonnull Plugin plugin, @Nonnull String texture, @Nonnull String signature) {
                return new Custom(plugin, null, texture, signature);
            }

            public static Custom createCustomSkin(@Nonnull Plugin plugin, @Nonnull String skinName, @Nonnull SignedTexture signedTexture) {
                return Custom.createCustomSkin(plugin, skinName, signedTexture.texture(), signedTexture.signature());
            }

            public static Custom createCustomSkin(@Nonnull Plugin plugin, @Nonnull SignedTexture signedTexture) {
                return Custom.createCustomSkin(plugin, signedTexture.texture(), signedTexture.signature());
            }

            public static List<String> getSuggestedSkinNames() {
                return SKIN_CACHE.getKeys().stream().collect(Collectors.toList());
            }

            @Override
            protected void save() throws IOException {
                if (!this.hasID()) {
                    return;
                }
                File file = this.getDataFile();
                boolean exist = file.exists();
                if (!exist) {
                    try {
                        file.createNewFile();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                config.set("name", (Object)this.skinName);
                config.set("plugin", (Object)this.plugin.getName());
                config.set("texture.value", (Object)this.textures.getEncodedTexture());
                config.set("texture.signature", (Object)this.textures.getSignature());
                NMSFileConfiguration.setComments((FileConfiguration)config, "texture", Arrays.asList("Minecraft skin texture: " + this.textures.getSkinUrl()));
                config.set("lastUpdate", (Object)this.resetLastUpdate());
                config.save(file);
                this.downloadImages();
            }

            @Override
            public void delete() {
                File folder;
                if (!this.hasID()) {
                    return;
                }
                if (SKIN_CACHE.contains(this.id)) {
                    SKIN_CACHE.remove(this.id);
                }
                if (!(folder = new File(Custom.getSkinFolderPath(this.plugin, this.skinName) + "/")).exists()) {
                    return;
                }
                try {
                    NMSFileUtils.deleteDirectory(folder);
                }
                catch (Exception e) {
                    NPCLib.DebugManager.printError(e);
                }
            }

            @Override
            public String getInformation() {
                Integer lastUpdateSeconds = this.getTimeFromLastUpdate(TimeUnit.SECONDS);
                String lastUpdateString = lastUpdateSeconds > 5 ? TimerUtils.getCRCounterSimple(lastUpdateSeconds, true) : "moments";
                return "\u00a7e\u00a7lInformation about this skin\n\u00a78Custom skin\n\n" + (String)(this.hasID() ? "\u00a7eName: \u00a77" + this.getName() + "\n" : "") + "\u00a7ePlugin: \u00a77" + this.getPluginInfo().getName() + "\n" + (String)(this.hasID() ? "\u00a7eID: \u00a77" + this.getID().getFullID() : "\u00a7c\u00a7oThis Skin does not have identifier") + "\n\n\u00a7eModel: \u00a7a" + this.getModel().getName() + " \u00a77(" + this.getModel().getPixels() + " pixel arms)\n\u00a7eCape: " + (this.getCape() != null ? this.getCape().getName() : "\u00a7cNone") + "\n\n\u00a77\u00a7oLast updated " + lastUpdateString + " ago.";
            }

            @Override
            protected File getAvatarFile() {
                if (this.skinName == null) {
                    return null;
                }
                return Custom.getAvatarFile(this.plugin, this.skinName);
            }

            @Override
            protected File getTextureFile() {
                if (this.skinName == null) {
                    return null;
                }
                return Custom.getTextureFile(this.plugin, this.skinName);
            }

            @Override
            protected File getDataFile() {
                if (this.skinName == null) {
                    return null;
                }
                return Custom.getDataFile(this.plugin, this.skinName);
            }

            @Override
            protected String getSkinFolderPath() {
                if (this.skinName == null) {
                    return null;
                }
                return Custom.getSkinFolderPath(this.plugin, this.skinName);
            }

            private static File getAvatarFile(Plugin plugin, String skinName) {
                return new File(Custom.getSkinFolderPath(plugin, skinName) + "/avatar.png");
            }

            private static File getTextureFile(Plugin plugin, String skinName) {
                return new File(Custom.getSkinFolderPath(plugin, skinName) + "/texture.png");
            }

            private static File getDataFile(Plugin plugin, String skinName) {
                return new File(Custom.getSkinFolderPath(plugin, skinName) + "/data.yml");
            }

            private static String getSkinFolderPath(Plugin plugin, String skinName) {
                return Skin.getSkinsFolderPath(Type.CUSTOM) + plugin.getName().toLowerCase() + "/" + skinName.toLowerCase();
            }

            public static class FetchResult
            extends dev.sergiferry.playernpc.api.NPC$Skin$FetchResult<Custom, Error> {
                protected FetchResult(@Nullable Custom skin, long started) {
                    this.started = started;
                    this.skin = Optional.ofNullable(skin);
                    this.error = super.grabSkin().isPresent() ? Optional.empty() : Optional.of(Error.UNKNOWN);
                }

                protected FetchResult(@Nullable Error error) {
                    this.skin = Optional.empty();
                    this.error = Optional.of(error != null ? error : Error.UNKNOWN);
                }

                public static enum Error implements dev.sergiferry.playernpc.api.NPC$Skin$FetchResult$Error
                {
                    UNKNOWN("There was an error trying to fetch that skin."),
                    NO_SKIN_WITH_THAT_NAME("No skin with that name has been found."),
                    TIME_OUT("Server has exceeded the maximum response time.");

                    private String message;

                    private Error(String message) {
                        this.message = message;
                    }

                    @Override
                    @Nonnull
                    public String getMessage() {
                        return this.message != null ? this.message : Error.UNKNOWN.message;
                    }

                    @Override
                    public String toString() {
                        return this.getMessage();
                    }
                }
            }
        }

        public static class MineSkin
        extends Skin {
            private static final HashMap<Integer, MineSkin> SKIN_CACHE_BY_ID;
            private static final HashMap<String, MineSkin> SKIN_CACHE_BY_UUID;
            protected static final List<String> LOCAL_SKIN_NAMES;
            private static final MineskinClient MINESKIN_CLIENT;
            private String uuid;
            private Integer id;
            private ObtainedFrom obtainedFrom;

            public static List<String> getSuggestedSkinNames() {
                ArrayList<String> suggested = new ArrayList<String>();
                SKIN_CACHE_BY_ID.keySet().stream().filter(x -> !suggested.contains(x)).forEach(x -> suggested.add(SKIN_CACHE_BY_ID.get(x).getId().toString()));
                LOCAL_SKIN_NAMES.stream().filter(x -> !suggested.contains(x)).forEach(x -> suggested.add((String)x));
                return suggested;
            }

            private MineSkin(String uuid, Integer id, String texture, String signature, @Nullable ObtainedFrom obtainedFrom) {
                super(Type.MINESKIN, texture, signature);
                Validate.notNull((Object)uuid);
                Validate.notNull((Object)id);
                if (obtainedFrom == null) {
                    obtainedFrom = ObtainedFrom.NONE;
                }
                this.uuid = uuid;
                this.id = id;
                this.obtainedFrom = obtainedFrom;
                SKIN_CACHE_BY_ID.put(id, this);
                SKIN_CACHE_BY_UUID.put(uuid, this);
            }

            private MineSkin(UUID uuid, Integer id, String texture, String signature, ObtainedFrom obtainedFrom) {
                this(uuid.toString().replaceAll("-", ""), id, texture, signature, obtainedFrom);
            }

            private MineSkin(org.mineskin.data.Skin mineSkinData, ObtainedFrom obtainedFrom) {
                this(mineSkinData.data.uuid, (Integer)mineSkinData.id, mineSkinData.data.texture.value, mineSkinData.data.texture.signature, obtainedFrom);
            }

            private MineSkin(YamlConfiguration config) {
                this(config.getString("mineskin.uuid"), (Integer)config.getInt("mineskin.id"), config.getString("texture.value"), config.getString("texture.signature"), config.contains("obtainedFrom") ? ObtainedFrom.valueOf(config.getString("obtainedFrom")) : ObtainedFrom.NONE);
            }

            public static CompletableFuture<FetchResult> generateSkinFromURLAsync(@Nonnull URL url) {
                return MineSkin.generateSkinFromURLAsync(url.toString());
            }

            public static CompletableFuture<FetchResult> generateSkinFromURLAsync(@Nonnull URL url, @Nullable Model model) {
                return MineSkin.generateSkinFromURLAsync(url.toString(), model);
            }

            public static CompletableFuture<FetchResult> generateSkinFromURLAsync(@Nonnull URL url, @Nullable Variant variant) {
                return MineSkin.generateSkinFromURLAsync(url.toString(), variant);
            }

            public static CompletableFuture<FetchResult> generateSkinFromURLAsync(@Nonnull String url) {
                return MineSkin.generateSkinFromURLAsync(url, Variant.AUTO);
            }

            public static CompletableFuture<FetchResult> generateSkinFromURLAsync(@Nonnull String url, @Nullable Model model) {
                return MineSkin.generateSkinFromURLAsync(url, model != null ? model.toMineSkinVariant() : null);
            }

            public static CompletableFuture<FetchResult> generateSkinFromURLAsync(@Nonnull String url, @Nullable Variant variant) {
                Validate.notNull((Object)url, (String)"URL cannot be null");
                if (((String)url).startsWith("https://namemc.com/skin/")) {
                    url = ((String)url).replaceFirst("https://namemc.com/skin/", "https://s.namemc.com/i/") + ".png";
                }
                String finalUrl = url;
                CompletableFuture<FetchResult> futureSkin = CompletableFuture.supplyAsync(() -> {
                    org.mineskin.data.Skin skinData;
                    try {
                        skinData = MINESKIN_CLIENT.generateUrl(finalUrl, SkinOptions.create("", variant != null ? variant : Variant.AUTO, Visibility.PUBLIC)).join();
                    }
                    catch (RuntimeException exception) {
                        return new FetchResult(exception);
                    }
                    catch (Exception e) {
                        NPCLib.DebugManager.printError(e);
                        return new FetchResult(FetchResult.Error.UNKNOWN);
                    }
                    if (skinData == null) {
                        return new FetchResult(FetchResult.Error.UNKNOWN);
                    }
                    FetchResult fetchResult = MineSkin.fetchSkinAsync((Plugin)PlayerNPCPlugin.getInstance(), "" + skinData.id, false).join();
                    if (fetchResult.hasFound()) {
                        ((MineSkin)fetchResult.grabSkin().get()).obtainedFrom = ObtainedFrom.GENERATED_FROM_AN_IMAGE_URL;
                        try {
                            ((MineSkin)fetchResult.grabSkin().get()).save();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return fetchResult;
                }).completeOnTimeout(new FetchResult(FetchResult.Error.TIME_OUT), 5L, TimeUnit.SECONDS);
                return futureSkin;
            }

            private static CompletableFuture<org.mineskin.data.Skin> getMineSkinData(long id) {
                return MINESKIN_CLIENT.getId(id);
            }

            private static CompletableFuture<org.mineskin.data.Skin> getMineSkinData(UUID uuid) {
                return MINESKIN_CLIENT.getUuid(uuid);
            }

            @Deprecated
            public static CompletableFuture<FetchResult> fetchSkinAsync(URL mineSkinURL) {
                return MineSkin.fetchSkinAsync(mineSkinURL, false);
            }

            @Deprecated
            public static CompletableFuture<FetchResult> fetchSkinAsync(URL mineSkinURL, boolean forceDownload) {
                return MineSkin.fetchSkinAsync(null, mineSkinURL, forceDownload);
            }

            public static CompletableFuture<FetchResult> fetchSkinAsync(Plugin plugin, URL mineSkinURL) {
                return MineSkin.fetchSkinAsync(plugin, mineSkinURL, false);
            }

            public static CompletableFuture<FetchResult> fetchSkinAsync(Plugin plugin, URL mineSkinURL, boolean forceDownload) {
                return MineSkin.fetchSkinAsync(plugin, mineSkinURL.toString(), forceDownload);
            }

            @Deprecated
            public static CompletableFuture<FetchResult> fetchSkinAsync(UUID uuid) {
                return MineSkin.fetchSkinAsync(uuid, false);
            }

            @Deprecated
            public static CompletableFuture<FetchResult> fetchSkinAsync(UUID uuid, boolean forceDownload) {
                return MineSkin.fetchSkinAsync(null, uuid, forceDownload);
            }

            public static CompletableFuture<FetchResult> fetchSkinAsync(Plugin plugin, UUID uuid) {
                return MineSkin.fetchSkinAsync(plugin, uuid, false);
            }

            public static CompletableFuture<FetchResult> fetchSkinAsync(Plugin plugin, UUID uuid, boolean forceDownload) {
                return MineSkin.fetchSkinAsync(plugin, uuid.toString(), forceDownload);
            }

            @Deprecated
            public static CompletableFuture<FetchResult> fetchSkinAsync(Long id) {
                return MineSkin.fetchSkinAsync(id, false);
            }

            @Deprecated
            public static CompletableFuture<FetchResult> fetchSkinAsync(Long id, boolean forceDownload) {
                return MineSkin.fetchSkinAsync(null, id, forceDownload);
            }

            public static CompletableFuture<FetchResult> fetchSkinAsync(Plugin plugin, Long id) {
                return MineSkin.fetchSkinAsync(plugin, id, false);
            }

            public static CompletableFuture<FetchResult> fetchSkinAsync(Plugin plugin, Long id, boolean forceDownload) {
                return MineSkin.fetchSkinAsync(plugin, id.intValue(), forceDownload);
            }

            @Deprecated
            public static CompletableFuture<FetchResult> fetchSkinAsync(Integer id) {
                return MineSkin.fetchSkinAsync(id, false);
            }

            @Deprecated
            public static CompletableFuture<FetchResult> fetchSkinAsync(Integer id, boolean forceDownload) {
                return MineSkin.fetchSkinAsync(null, id, forceDownload);
            }

            public static CompletableFuture<FetchResult> fetchSkinAsync(Plugin plugin, Integer id) {
                return MineSkin.fetchSkinAsync(plugin, id, false);
            }

            public static CompletableFuture<FetchResult> fetchSkinAsync(Plugin plugin, Integer id, boolean forceDownload) {
                return MineSkin.fetchSkinAsync(plugin, id.toString(), forceDownload);
            }

            @Deprecated
            public static CompletableFuture<FetchResult> fetchSkinAsync(String id) {
                return MineSkin.fetchSkinAsync(id, false);
            }

            @Deprecated
            public static CompletableFuture<FetchResult> fetchSkinAsync(String id, boolean forceDownload) {
                return MineSkin.fetchSkinAsync(null, id, forceDownload);
            }

            public static CompletableFuture<FetchResult> fetchSkinAsync(Plugin plugin, String id) {
                return MineSkin.fetchSkinAsync(plugin, id, false);
            }

            public static CompletableFuture<FetchResult> fetchSkinAsync(Plugin plugin, String id, boolean forceDownload) {
                Validate.notNull((Object)plugin);
                Validate.notNull((Object)id);
                long started = System.currentTimeMillis();
                CompletableFuture<FetchResult> futureSkin = CompletableFuture.supplyAsync(() -> {
                    try {
                        Integer possibleID;
                        String actualID = id;
                        if (actualID.startsWith("https://minesk.in/")) {
                            actualID = actualID.replaceFirst("https://minesk\\.in/", "");
                        } else if (actualID.startsWith("https://mineskin.org/")) {
                            actualID = actualID.replaceFirst("https://mineskin\\.org/", "");
                        }
                        String possibleUUID = actualID.length() >= 32 ? actualID.replaceAll("-", "") : null;
                        Integer n = possibleID = MathUtils.isInteger(actualID) ? Integer.valueOf(actualID) : null;
                        if (possibleID == null && possibleUUID == null) {
                            return new FetchResult(FetchResult.Error.INCORRECT_NAME);
                        }
                        if (!forceDownload) {
                            MineSkin skin;
                            if (possibleUUID != null && SKIN_CACHE_BY_UUID.containsKey(possibleUUID)) {
                                skin = SKIN_CACHE_BY_UUID.get(possibleUUID);
                                if (!skin.needsToUpdate(plugin)) {
                                    return new FetchResult(skin, started);
                                }
                                SKIN_CACHE_BY_UUID.remove(possibleID);
                            }
                            if (possibleID != null) {
                                YamlConfiguration config;
                                String lastUpdate;
                                if (SKIN_CACHE_BY_ID.containsKey(possibleID)) {
                                    skin = SKIN_CACHE_BY_ID.get(possibleID);
                                    if (!skin.needsToUpdate(plugin)) {
                                        return new FetchResult(skin, started);
                                    }
                                    SKIN_CACHE_BY_ID.remove(possibleID);
                                }
                                if (MineSkin.getDataFile(possibleID).exists() && !Skin.needsToUpdate(lastUpdate = (config = MineSkin.loadConfig(possibleID)).getString("lastUpdate"), plugin)) {
                                    MineSkin skin2 = new MineSkin(config);
                                    skin2.lastUpdate = lastUpdate;
                                    if (LOCAL_SKIN_NAMES.contains(possibleID.toString())) {
                                        LOCAL_SKIN_NAMES.remove(possibleID.toString());
                                    }
                                    return new FetchResult(skin2, started);
                                }
                            }
                        }
                        org.mineskin.data.Skin mineSkinData = null;
                        if (possibleID != null) {
                            mineSkinData = MineSkin.getMineSkinData(possibleID.longValue()).join();
                        } else if (possibleUUID != null) {
                            mineSkinData = MineSkin.getMineSkinData(UUID.fromString(StringUtils.formatUUID(possibleUUID))).join();
                        }
                        if (mineSkinData == null) {
                            return new FetchResult(FetchResult.Error.SKIN_NOT_FOUND);
                        }
                        MineSkin mineSkin = new MineSkin(mineSkinData, ObtainedFrom.MINESKIN_GALLERY);
                        mineSkin.save();
                        return new FetchResult(mineSkin, started);
                    }
                    catch (RuntimeException exception) {
                        return new FetchResult(exception);
                    }
                    catch (Exception exception) {
                        NPCLib.DebugManager.printError(exception);
                        return new FetchResult(FetchResult.Error.UNKNOWN);
                    }
                }).completeOnTimeout(new FetchResult(FetchResult.Error.TIME_OUT), 5L, TimeUnit.SECONDS);
                return futureSkin;
            }

            private static YamlConfiguration loadConfig(Integer id) {
                File file = MineSkin.getDataFile(id);
                boolean exist = file.exists();
                if (!exist) {
                    try {
                        file.createNewFile();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                return config;
            }

            public String getUUID() {
                return this.uuid;
            }

            public Integer getId() {
                return this.id;
            }

            @Override
            public String getName() {
                return this.id.toString();
            }

            public String getMineSkinURL() {
                return "https://minesk.in/" + this.uuid;
            }

            @Nonnull
            public ObtainedFrom getObtainedFrom() {
                return this.obtainedFrom;
            }

            public Custom convertToCustomSkin(Plugin plugin, String skinName) {
                return Custom.createCustomSkin(plugin, skinName, this.textures.getEncodedTexture(), this.textures.getSignature());
            }

            public Custom convertToCustomSkin(Plugin plugin) {
                return Custom.createCustomSkin(plugin, this.textures.getEncodedTexture(), this.textures.getSignature());
            }

            @Override
            protected void save() throws IOException {
                File file = this.getDataFile();
                boolean exist = file.exists();
                if (!exist) {
                    try {
                        file.createNewFile();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                NMSFileConfiguration.setHeader((FileConfiguration)config, Arrays.asList(this.getMineSkinURL()));
                config.set("mineskin.id", (Object)this.id);
                config.set("mineskin.uuid", (Object)this.uuid);
                config.set("texture.value", (Object)this.getTexture());
                config.set("texture.signature", (Object)this.getSignature());
                ArrayList<String> comments = new ArrayList<String>();
                comments.add("Minecraft skin texture: " + this.textures.getSkinUrl());
                if (this.hasCape()) {
                    comments.add("Cape texture: " + this.textures.getCapeUrl());
                }
                NMSFileConfiguration.setComments((FileConfiguration)config, "texture", comments);
                config.set("obtainedFrom", (Object)this.obtainedFrom.name());
                config.set("lastUpdate", (Object)this.resetLastUpdate());
                config.save(file);
                this.downloadImages();
            }

            @Override
            public void delete() {
                File folder;
                if (SKIN_CACHE_BY_UUID.containsKey(this.uuid)) {
                    SKIN_CACHE_BY_UUID.remove(this.uuid);
                }
                if (SKIN_CACHE_BY_ID.containsKey(this.id)) {
                    SKIN_CACHE_BY_ID.remove(this.id);
                }
                if (LOCAL_SKIN_NAMES.contains(this.id.toString())) {
                    LOCAL_SKIN_NAMES.remove(this.id.toString());
                }
                if (!(folder = new File(MineSkin.getSkinFolderPath(this.id) + "/")).exists()) {
                    return;
                }
                try {
                    NMSFileUtils.deleteDirectory(folder);
                }
                catch (Exception e) {
                    NPCLib.DebugManager.printError(e);
                }
            }

            @Override
            protected File getAvatarFile() {
                return MineSkin.getAvatarFile(this.id);
            }

            @Override
            protected File getTextureFile() {
                return MineSkin.getTextureFile(this.id);
            }

            @Override
            protected File getDataFile() {
                return MineSkin.getDataFile(this.id);
            }

            @Override
            protected String getSkinFolderPath() {
                return MineSkin.getSkinFolderPath(this.id);
            }

            @Override
            public String getInformation() {
                Integer lastUpdateSeconds = this.getTimeFromLastUpdate(TimeUnit.SECONDS);
                String lastUpdateString = lastUpdateSeconds > 5 ? TimerUtils.getCRCounterSimple(lastUpdateSeconds, true) : "moments";
                return "\u00a7e\u00a7lInformation about this skin\n\u00a78MineSkin skin\n\n\u00a7eMineSkin ID: \u00a77" + this.getId() + "\n\u00a7eUUID: \u00a77" + this.getUUID() + "\n\n\u00a7eModel: \u00a7a" + this.getModel().getName() + " \u00a77(" + this.getModel().getPixels() + " pixel arms)\n\u00a7eCape: \u00a7c\u00a7oMineSkins don't have cape\n\n\u00a7eObtained from: " + this.getObtainedFrom().getTitle() + "\n\u00a77\u00a7oLast updated " + lastUpdateString + " ago.";
            }

            private static File getAvatarFile(Integer id) {
                return new File(MineSkin.getSkinFolderPath(id) + "/avatar.png");
            }

            private static File getTextureFile(Integer id) {
                return new File(MineSkin.getSkinFolderPath(id) + "/texture.png");
            }

            private static File getDataFile(Integer id) {
                return new File(MineSkin.getSkinFolderPath(id) + "/data.yml");
            }

            private static String getSkinFolderPath(Integer id) {
                return Skin.getSkinsFolderPath(Type.MINESKIN) + id.toString();
            }

            static {
                MINESKIN_CLIENT = new MineskinClient();
                SKIN_CACHE_BY_ID = new HashMap();
                SKIN_CACHE_BY_UUID = new HashMap();
                LOCAL_SKIN_NAMES = new ArrayList<String>();
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)PlayerNPCPlugin.getInstance(), () -> {
                    File folder = new File(Skin.getSkinsFolderPath(Type.MINESKIN));
                    if (!folder.exists() || !folder.isDirectory()) {
                        return;
                    }
                    for (File skin : folder.listFiles()) {
                        if (!skin.isDirectory()) continue;
                        LOCAL_SKIN_NAMES.add(skin.getName());
                    }
                });
            }

            public static enum ObtainedFrom {
                MINESKIN_GALLERY("\u00a7aMineSkin Gallery"),
                GENERATED_FROM_AN_IMAGE_URL("\u00a7aGenerated from an Image URL"),
                NONE("\u00a7cUnknown");

                private String title;

                private ObtainedFrom(String title) {
                    this.title = title;
                }

                public String getTitle() {
                    return this.title;
                }
            }

            public static class FetchResult
            extends dev.sergiferry.playernpc.api.NPC$Skin$FetchResult<MineSkin, Error> {
                private Optional<RuntimeException> mineskinException;

                protected FetchResult(@Nullable MineSkin skin, long started) {
                    this.started = started;
                    this.skin = Optional.ofNullable(skin);
                    this.error = super.grabSkin().isPresent() ? Optional.empty() : Optional.of(Error.UNKNOWN);
                    this.mineskinException = Optional.empty();
                }

                protected FetchResult(@Nullable Error error) {
                    this.skin = Optional.empty();
                    this.error = Optional.of(error != null ? error : Error.UNKNOWN);
                    this.mineskinException = Optional.empty();
                }

                public FetchResult(@Nonnull RuntimeException exception) {
                    this.skin = Optional.empty();
                    if (exception == null) {
                        this.error = Optional.of(Error.UNKNOWN);
                        return;
                    }
                    this.mineskinException = Optional.of(exception);
                    this.error = Optional.of(Error.MINESKIN_EXCEPTION);
                }

                public String getErrorMessage() {
                    if (!super.hasError()) {
                        return null;
                    }
                    if (((Error)super.grabError().get()).equals(Error.MINESKIN_EXCEPTION)) {
                        return "There was an error: \u00a7c" + this.getMineSkinErrorMessage();
                    }
                    return ((Error)super.grabError().get()).getMessage();
                }

                private Optional<RuntimeException> getMineSkinException() {
                    return this.mineskinException;
                }

                @Nonnull
                private String getMineSkinErrorMessage() {
                    return this.mineskinException.isPresent() ? this.mineskinException.get().getMessage().split(":", 3)[2].replaceFirst(" ", "") : "Unknown";
                }

                public static enum Error implements dev.sergiferry.playernpc.api.NPC$Skin$FetchResult$Error
                {
                    UNKNOWN("There was an error trying to fetch that skin."),
                    TIME_OUT("MineSkin server has exceeded the maximum response time."),
                    SKIN_NOT_FOUND("No skin with that identifier has been found."),
                    INCORRECT_NAME("Incorrect name. Use MineSkin ID, UUID, or Direct Link."),
                    NO_CONNECTION_TO_MINESKIN("Failed to establish connection to MineSkin servers."),
                    MINESKIN_EXCEPTION;

                    private String message;

                    private Error(String message) {
                        this.message = message;
                    }

                    private Error() {
                        this(null);
                    }

                    @Override
                    @Nonnull
                    public String getMessage() {
                        return this.message != null ? this.message : Error.UNKNOWN.message;
                    }

                    @Override
                    public String toString() {
                        return this.getMessage();
                    }
                }
            }
        }

        public static class VisibleLayers
        implements Cloneable {
            private HashMap<Layer, Boolean> visibleLayers = new HashMap();

            protected VisibleLayers() {
                this.enableAll();
            }

            public void enableAll() {
                Arrays.stream(Layer.values()).forEach(x -> this.visibleLayers.put((Layer)x, true));
            }

            public void disableAll() {
                Arrays.stream(Layer.values()).forEach(x -> this.visibleLayers.put((Layer)x, false));
            }

            public List<Layer> getVisibleLayers() {
                return Arrays.stream(Layer.values()).filter(x -> this.isVisible((Layer)x)).collect(Collectors.toList());
            }

            public List<Layer> getInvisibleLayers() {
                return Arrays.stream(Layer.values()).filter(x -> !this.isVisible((Layer)x)).collect(Collectors.toList());
            }

            public Updatable.Type setVisibility(Layer layer, boolean visible) {
                this.visibleLayers.put(layer, visible);
                return Updatable.Type.SIMPLE_UPDATE;
            }

            public boolean isVisible(Layer layer) {
                return this.visibleLayers.get(layer);
            }

            public boolean isCape() {
                return this.isVisible(Layer.CAPE);
            }

            public Updatable.Type setCape(boolean cape) {
                return this.setVisibility(Layer.CAPE, cape);
            }

            public boolean isJacket() {
                return this.isVisible(Layer.JACKET);
            }

            public Updatable.Type setJacket(boolean jacket) {
                return this.setVisibility(Layer.JACKET, jacket);
            }

            public boolean isLeftSleeve() {
                return this.visibleLayers.get(Layer.LEFT_SLEEVE);
            }

            public Updatable.Type setLeftSleeve(boolean leftSleeve) {
                return this.setVisibility(Layer.LEFT_SLEEVE, leftSleeve);
            }

            public boolean isRightSleeve() {
                return this.isVisible(Layer.RIGHT_SLEEVE);
            }

            public Updatable.Type setRightSleeve(boolean rightSleeve) {
                return this.setVisibility(Layer.RIGHT_SLEEVE, rightSleeve);
            }

            public boolean isLeftPants() {
                return this.isVisible(Layer.LEFT_PANTS);
            }

            public Updatable.Type setLeftPants(boolean leftPants) {
                return this.setVisibility(Layer.LEFT_PANTS, leftPants);
            }

            public boolean isRightPants() {
                return this.isVisible(Layer.RIGHT_PANTS);
            }

            public Updatable.Type setRightPants(boolean rightPants) {
                return this.setVisibility(Layer.RIGHT_PANTS, rightPants);
            }

            public boolean isHat() {
                return this.isVisible(Layer.HAT);
            }

            public Updatable.Type setHat(boolean hat) {
                return this.setVisibility(Layer.HAT, hat);
            }

            public VisibleLayers clone() {
                VisibleLayers visibleLayers = new VisibleLayers();
                Arrays.stream(Layer.values()).forEach(x -> visibleLayers.setVisibility((Layer)x, this.isVisible((Layer)x)));
                return visibleLayers;
            }
        }

        public static enum Layer implements EnumUtils.GetName
        {
            CAPE(1),
            JACKET(2),
            LEFT_SLEEVE(4),
            RIGHT_SLEEVE(8),
            LEFT_PANTS(16),
            RIGHT_PANTS(32),
            HAT(64);

            private byte mask;

            private Layer(byte mask) {
                this.mask = mask;
            }

            protected byte getMask() {
                return this.mask;
            }

            @Nullable
            public static Layer fromName(String name) {
                return Arrays.stream(Layer.values()).filter(x -> x.name().equalsIgnoreCase(name)).findFirst().orElse(null);
            }
        }

        public static abstract class FetchResult<S extends Skin, E extends Error> {
            private Long started;
            private final Long finished = System.currentTimeMillis();
            private Optional<S> skin;
            private Optional<E> error;

            public Optional<S> grabSkin() {
                return this.skin;
            }

            public Optional<Long> grabResponseTime() {
                return this.started == null ? Optional.empty() : Optional.of(this.finished - this.started);
            }

            public Optional<E> grabError() {
                return this.error;
            }

            public boolean hasFound() {
                return this.skin != null;
            }

            public boolean hasError() {
                return !this.hasFound();
            }

            protected static interface Error {
                @Nonnull
                public String getMessage();

                public String toString();
            }
        }
    }

    public static enum Pose implements EnumUtils.GetName
    {
        STANDING(EntityPose.a, "STANDING"),
        GLIDING(EntityPose.b, "FALL_FLYING"),
        SLEEPING(EntityPose.c, "SLEEPING"),
        SWIMMING(EntityPose.d, "SWIMMING"),
        SPIN_ATTACK(EntityPose.e, "SPIN_ATTACK"),
        CROUCHING(EntityPose.f, ServerVersion.getServerVersion().isOlderThanOrEqual(ServerVersion.VERSION_1_18_2) ? "SNEAKING" : "CROAKING"),
        LONG_JUMPING(EntityPose.g, "LONG_JUMPING"),
        DYING(EntityPose.h, "DYING");

        private EntityPose minecraftEntityPose;
        private org.bukkit.entity.Pose bukkitPose;

        private Pose(EntityPose minecraftEntityPose, String bukkitPoseName) {
            this.minecraftEntityPose = minecraftEntityPose;
            this.bukkitPose = EnumUtils.getEnumConstant(org.bukkit.entity.Pose.class, bukkitPoseName);
        }

        protected EntityPose asMinecraftEntityPose() {
            return this.minecraftEntityPose;
        }

        public org.bukkit.entity.Pose asBukkitPose() {
            return this.bukkitPose;
        }

        public boolean isDeprecated() {
            return EnumUtils.isDeprecated(this);
        }

        public static Optional<Pose> fromName(String name) {
            return Arrays.stream(Pose.values()).filter(x -> x.name().equalsIgnoreCase(name)).findFirst();
        }

        public static Optional<Pose> of(org.bukkit.entity.Pose bukkitPose) {
            return Arrays.stream(Pose.values()).filter(x -> x.bukkitPose.equals((Object)bukkitPose)).findFirst();
        }

        protected static Optional<Pose> of(EntityPose minecraftEntityPose) {
            return Arrays.stream(Pose.values()).filter(x -> x.minecraftEntityPose.equals((Object)minecraftEntityPose)).findFirst();
        }
    }

    public static class Hologram {
        private final Personal npc;
        private final Player player;
        private Location location;
        private HashMap<Integer, List<EntityArmorStand>> lines;
        private EntityItem item;
        private boolean shownToClient;

        protected Hologram(Personal npc, Player player) {
            this.npc = npc;
            this.player = player;
            this.shownToClient = false;
            this.create();
        }

        private void create() {
            this.lines = new HashMap();
            this.location = new Location(this.npc.getWorld(), this.npc.getX().doubleValue(), this.npc.getY().doubleValue(), this.npc.getZ().doubleValue()).add(this.npc.getTextAlignment());
            WorldServer world = null;
            try {
                world = (WorldServer)NMSCraftWorld.getCraftWorldGetHandle().invoke(NMSCraftWorld.getCraftWorldClass().cast(this.location.getWorld()), new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (world == null) {
                return;
            }
            for (int i = 1; i <= this.getText().size(); ++i) {
                this.createLine(world);
            }
            if (this.npc.getTextItem() != null && !this.npc.getTextItem().getType().isAir()) {
                this.item = new EntityItem((net.minecraft.world.level.World)world, this.location.getX(), this.location.getY() + this.npc.getTextLineSpacing() * (double)(this.getText().size() + 1), this.location.getZ(), NMSCraftItemStack.asNMSCopy(this.npc.getTextItem()));
                NMSEntity.setNoGravity((net.minecraft.world.entity.Entity)this.item, true);
            }
        }

        protected void createLine(WorldServer world) {
            int line = 1;
            while (this.lines.containsKey(line)) {
                ++line;
            }
            Opacity textOpacity = this.getLinesOpacity().getOrDefault(line, this.npc.getTextOpacity());
            ArrayList<EntityArmorStand> armorStands = new ArrayList<EntityArmorStand>();
            for (int i = 1; i <= textOpacity.getTimes(); ++i) {
                EntityArmorStand armor = new EntityArmorStand((net.minecraft.world.level.World)world, this.location.getX(), this.location.getY() + this.npc.getTextLineSpacing() * (double)(this.getText().size() - line), this.location.getZ());
                NMSEntity.setCustomNameVisible((net.minecraft.world.entity.Entity)armor, true);
                NMSEntity.setNoGravity((net.minecraft.world.entity.Entity)armor, true);
                NMSEntity.setCustomName((net.minecraft.world.entity.Entity)armor, "\u00a7f");
                NMSEntityArmorStand.setInvisible(armor, true);
                NMSEntityArmorStand.setMarker(armor, true);
                armorStands.add(armor);
            }
            this.lines.put(line, armorStands);
        }

        protected void setLine(int line, @ColorUtils.Colorable(colored=false) @Placeholders.Replaceable(replaced=false) String text) {
            if (!this.lines.containsKey(line)) {
                return;
            }
            String replacedText = Placeholders.replace(this.npc, this.player, text);
            replacedText = ColorUtils.formatColor(replacedText);
            for (EntityArmorStand as : this.lines.get(line)) {
                NMSEntity.setNoGravity((net.minecraft.world.entity.Entity)as, true);
                NMSEntityArmorStand.setInvisible(as, true);
                NMSEntity.setCustomName((net.minecraft.world.entity.Entity)as, NMSCraftChatMessage.fromString(replacedText));
                NMSEntity.setCustomNameVisible((net.minecraft.world.entity.Entity)as, replacedText.length() > 0);
            }
        }

        protected String getLine(int line) {
            if (!this.lines.containsKey(line)) {
                return "";
            }
            return NMSEntity.getCustomName((net.minecraft.world.entity.Entity)this.lines.get(line).get(0)).getString();
        }

        protected boolean hasLine(int line) {
            return this.lines.containsKey(line);
        }

        protected void show() {
            if (this.shownToClient) {
                return;
            }
            if (this.npc.isHiddenText()) {
                return;
            }
            if (!this.npc.isInRange()) {
                return;
            }
            if (!this.npc.isShownOnClient()) {
                return;
            }
            for (Integer line : this.lines.keySet()) {
                this.setLine(line, this.getText().get(line - 1));
                for (EntityArmorStand armor : this.lines.get(line)) {
                    NMSPacketPlayOutSpawnEntity.sendPacketEntityLiving(this.player, (EntityLiving)armor);
                    NMSCraftPlayer.sendPacket(this.player, (Packet)NMSPacketPlayOutEntityMetadata.getPacket((net.minecraft.world.entity.Entity)armor, NMSEntity.getDataWatcher((net.minecraft.world.entity.Entity)armor)));
                }
            }
            if (this.item != null) {
                if (this.npc.getTextItem() != null && !this.npc.getTextItem().getType().isAir()) {
                    NMSEntityItem.setItem(this.item, this.npc.getTextItem());
                    NMSEntity.setGlowingTag((net.minecraft.world.entity.Entity)this.item, this.npc.isTextItemGlowing());
                    this.updateScoreboard();
                    NMSPacketPlayOutSpawnEntity.sendPacketEntity(this.player, (net.minecraft.world.entity.Entity)this.item);
                    NMSCraftPlayer.sendPacket(this.player, (Packet)NMSPacketPlayOutEntityMetadata.getPacket((net.minecraft.world.entity.Entity)this.item, NMSEntity.getDataWatcher((net.minecraft.world.entity.Entity)this.item)));
                } else {
                    NMSPacketPlayOutEntityDestroy.destroyEntity(this.getPlayer(), (net.minecraft.world.entity.Entity)this.item);
                }
            }
            this.shownToClient = true;
        }

        protected void hide() {
            if (!this.shownToClient) {
                return;
            }
            for (Integer in : this.lines.keySet()) {
                try {
                    NMSPacketPlayOutEntityDestroy.destroyEntities(this.player, (Collection<? extends net.minecraft.world.entity.Entity>)this.lines.get(in));
                }
                catch (Exception e) {
                    NPCLib.DebugManager.printError(e);
                }
            }
            if (this.item != null) {
                NMSPacketPlayOutEntityDestroy.destroyEntity(this.player, (net.minecraft.world.entity.Entity)this.item);
            }
            this.shownToClient = false;
        }

        protected void move(Vector vector) {
            this.location.add(vector);
            PlayerConnection playerConnection = NMSCraftPlayer.getPlayerConnection(this.getPlayer());
            ArrayList<EntityItem> entities = new ArrayList<EntityItem>();
            this.lines.values().forEach(x -> entities.addAll((Collection<EntityItem>)x));
            if (this.item != null) {
                entities.add(this.item);
            }
            for (net.minecraft.world.entity.Entity entity : entities) {
                double fx = NMSEntity.getX(entity) + vector.getX();
                double fy = NMSEntity.getY(entity) + vector.getY();
                double fz = NMSEntity.getZ(entity) + vector.getZ();
                NMSEntity.move(entity, fx, fy, fz);
                NMSCraftPlayer.sendPacket(playerConnection, (Packet)new PacketPlayOutEntityTeleport(entity));
            }
        }

        protected void simpleUpdate() {
            this.hide();
            this.show();
        }

        protected void forceUpdate() {
            this.hide();
            this.create();
            this.show();
        }

        protected void removeHologram() {
            this.hide();
            this.lines.clear();
            this.item = null;
        }

        protected void updateScoreboard() {
            if (!this.npc.getNPCLib().isUsingPacketScoreboards()) {
                this.updateBukkitScoreboard();
                return;
            }
            Scoreboard scoreboard = NMSCraftScoreboard.getScoreboard(this.player);
            String entityUUID = NMSEntity.getEntityUUID((net.minecraft.world.entity.Entity)this.item).toString();
            String teamName = this.npc.getScoreboardTeamName("tI");
            boolean existsTeam = NMSScoreboard.getTeam(scoreboard, teamName) != null;
            ScoreboardTeam scoreboardTeam = existsTeam ? NMSScoreboard.getTeam(scoreboard, teamName) : new ScoreboardTeam(scoreboard, teamName);
            NMSScoreboard.setTeamColor(scoreboardTeam, this.npc.getTextItemGlowingColor().asMinecraftEnumChatFormat());
            NMSScoreboard.setPlayerTeam(scoreboard, entityUUID, scoreboardTeam);
            NMSCraftPlayer.sendPacket(this.player, (Packet)PacketPlayOutScoreboardTeam.a((ScoreboardTeam)scoreboardTeam, (!existsTeam ? 1 : 0) != 0));
        }

        protected void updateBukkitScoreboard() {
            org.bukkit.scoreboard.Scoreboard scoreboard = this.player.getScoreboard();
            if (scoreboard.equals(Bukkit.getScoreboardManager().getMainScoreboard())) {
                return;
            }
            String entityUUID = NMSEntity.getEntityUUID((net.minecraft.world.entity.Entity)this.item).toString();
            String teamName = this.npc.getScoreboardTeamName("tI");
            boolean existsTeam = scoreboard.getTeam(teamName) != null;
            Team scoreboardTeam = existsTeam ? scoreboard.getTeam(teamName) : scoreboard.registerNewTeam(teamName);
            scoreboardTeam.setColor(this.npc.getTextItemGlowingColor().asBukkitChatColor());
            scoreboardTeam.addEntry(entityUUID);
        }

        protected boolean isCreatedLine(Integer line) {
            return this.lines.containsKey(line);
        }

        protected boolean isShownToClient() {
            return this.shownToClient;
        }

        protected Player getPlayer() {
            return this.player;
        }

        protected List<String> getText() {
            return this.npc.getText();
        }

        protected HashMap<Integer, Opacity> getLinesOpacity() {
            return this.npc.getLinesOpacity();
        }

        protected NPC getNPC() {
            return this.npc;
        }

        public static enum Opacity implements EnumUtils.GetName
        {
            LOWEST(1),
            LOW(2),
            MEDIUM(3),
            HARD(4),
            HARDER(6),
            FULL(10);

            private int times;

            private Opacity(int times) {
                this.times = times;
            }

            protected int getTimes() {
                return this.times;
            }

            public static Opacity fromName(String name) {
                return Arrays.stream(Opacity.values()).filter(x -> x.name().equalsIgnoreCase(name)).findAny().orElse(null);
            }
        }
    }

    public static enum Color implements EnumUtils.GetName
    {
        BLACK(org.bukkit.ChatColor.BLACK, org.bukkit.Color.BLACK, DyeColor.BLACK),
        DARK_BLUE(org.bukkit.ChatColor.DARK_BLUE, org.bukkit.Color.BLUE, DyeColor.BLUE),
        DARK_GREEN(org.bukkit.ChatColor.DARK_GREEN, org.bukkit.Color.GREEN, DyeColor.GREEN),
        DARK_AQUA(org.bukkit.ChatColor.DARK_AQUA, org.bukkit.Color.TEAL, DyeColor.CYAN),
        DARK_RED(org.bukkit.ChatColor.DARK_RED, org.bukkit.Color.MAROON, DyeColor.RED),
        DARK_PURPLE(org.bukkit.ChatColor.DARK_PURPLE, org.bukkit.Color.PURPLE, DyeColor.PURPLE),
        GOLD(org.bukkit.ChatColor.GOLD, org.bukkit.Color.ORANGE, DyeColor.ORANGE),
        GRAY(org.bukkit.ChatColor.GRAY, org.bukkit.Color.SILVER, DyeColor.LIGHT_GRAY),
        DARK_GRAY(org.bukkit.ChatColor.DARK_GRAY, org.bukkit.Color.GRAY, DyeColor.GRAY),
        BLUE(org.bukkit.ChatColor.BLUE, org.bukkit.Color.NAVY, DyeColor.BLUE),
        GREEN(org.bukkit.ChatColor.GREEN, org.bukkit.Color.LIME, DyeColor.LIME),
        AQUA(org.bukkit.ChatColor.AQUA, org.bukkit.Color.AQUA, DyeColor.LIGHT_BLUE),
        RED(org.bukkit.ChatColor.RED, org.bukkit.Color.RED, DyeColor.RED),
        LIGHT_PURPLE(org.bukkit.ChatColor.LIGHT_PURPLE, org.bukkit.Color.FUCHSIA, DyeColor.MAGENTA),
        YELLOW(org.bukkit.ChatColor.YELLOW, org.bukkit.Color.YELLOW, DyeColor.YELLOW),
        WHITE(org.bukkit.ChatColor.WHITE, org.bukkit.Color.WHITE, DyeColor.WHITE);

        private org.bukkit.ChatColor bukkitChatColor;
        private ChatColor bungeeChatColor;
        private EnumChatFormat minecraftEnumChatFormat;
        private java.awt.Color javaColor;
        private org.bukkit.Color bukkitColor;
        private DyeColor bukkitDyeColor;

        private Color(org.bukkit.ChatColor bukkitChatColor, org.bukkit.Color bukkitColor, DyeColor bukkitDyeColor) {
            this.bukkitChatColor = bukkitChatColor;
            this.bungeeChatColor = bukkitChatColor.asBungee();
            this.minecraftEnumChatFormat = EnumUtils.getEnumConstant(EnumChatFormat.class, this.name());
            this.javaColor = this.bungeeChatColor.getColor();
            this.bukkitColor = bukkitColor;
            this.bukkitDyeColor = bukkitDyeColor;
        }

        @Override
        @Nonnull
        public String getName(EnumUtils.NameFormat nameFormat) {
            return this.getName(nameFormat, false);
        }

        @Nonnull
        public String getName(EnumUtils.NameFormat nameFormat, boolean colored) {
            return (colored ? this.bukkitChatColor.toString() : "") + nameFormat.format(this);
        }

        @Nonnull
        public org.bukkit.ChatColor asBukkitChatColor() {
            return this.bukkitChatColor;
        }

        @Nonnull
        public ChatColor asBungeeChatColor() {
            return this.bungeeChatColor;
        }

        @Nonnull
        public java.awt.Color asJavaColor() {
            return this.javaColor;
        }

        @Nonnull
        public org.bukkit.Color asBukkitColor() {
            return this.bukkitColor;
        }

        @Nonnull
        public DyeColor asBukkitDyeColor() {
            return this.bukkitDyeColor;
        }

        @Nonnull
        protected EnumChatFormat asMinecraftEnumChatFormat() {
            return this.minecraftEnumChatFormat;
        }

        @Nonnull
        public Material getBukkitMaterial(@Nonnull MaterialType type) {
            return Material.valueOf((String)(this.bukkitDyeColor.name() + "_" + type.name()));
        }

        public static Optional<Color> fromName(@Nonnull String name) {
            return Arrays.stream(Color.values()).filter(x -> x.name().equalsIgnoreCase(name)).findFirst();
        }

        public static Optional<Color> of(@Nonnull org.bukkit.ChatColor color) {
            return Arrays.stream(Color.values()).filter(x -> x.bukkitChatColor.equals((Object)color)).findFirst();
        }

        public static Optional<Color> of(@Nonnull ChatColor color) {
            return Arrays.stream(Color.values()).filter(x -> x.bungeeChatColor.equals((Object)color)).findFirst();
        }

        public static Optional<Color> of(@Nonnull java.awt.Color color) {
            return Arrays.stream(Color.values()).filter(x -> x.javaColor.equals(color)).findFirst();
        }

        public static Optional<Color> of(@Nonnull org.bukkit.Color color) {
            return Arrays.stream(Color.values()).filter(x -> x.bukkitColor.equals((Object)color)).findFirst();
        }

        public static Optional<Color> of(@Nonnull DyeColor color) {
            return Arrays.stream(Color.values()).filter(x -> x.bukkitDyeColor.equals((Object)color)).findFirst();
        }

        public static Optional<Color> of(@Nonnull Material material) {
            if (material == null || material.isAir()) {
                return Optional.empty();
            }
            Optional<MaterialType> materialType = Arrays.stream(MaterialType.values()).filter(x -> material.name().endsWith("_" + x.name())).findFirst();
            if (materialType.isEmpty()) {
                return Optional.empty();
            }
            return Arrays.stream(Color.values()).filter(x -> x.getBukkitMaterial((MaterialType)((Object)((Object)materialType.get()))).equals((Object)material)).findFirst();
        }

        protected static Optional<Color> of(@Nonnull EnumChatFormat color) {
            return Arrays.stream(Color.values()).filter(x -> x.minecraftEnumChatFormat.equals((Object)color)).findFirst();
        }

        public static enum MaterialType {
            BANNER,
            BED,
            CANDLE,
            CARPET,
            CANDLE_CAKE,
            CONCRETE,
            CONCRETE_POWDER,
            DYE,
            GLAZED_TERRACOTTA,
            SHULKER_BOX,
            STAINED_GLASS,
            STAINED_GLASS_PANE,
            TERRACOTTA,
            WALL_BANNER,
            WOOL;

        }
    }

    public static enum PotionParticlesType implements EnumUtils.GetName
    {
        DISABLED(false),
        NORMAL(false),
        AMBIENT(true);

        protected final Boolean metadata;

        private PotionParticlesType(Boolean metadata) {
            this.metadata = metadata;
        }

        @Nullable
        public static PotionParticlesType fromName(String name) {
            return Arrays.stream(PotionParticlesType.values()).filter(x -> x.name().equalsIgnoreCase(name)).findFirst().orElse(null);
        }
    }

    public static enum GazeTrackingType implements EnumUtils.GetName
    {
        NONE,
        PLAYER,
        NEAREST_PLAYER,
        NEAREST_ENTITY;


        public static Optional<GazeTrackingType> fromName(String name) {
            return Arrays.stream(GazeTrackingType.values()).filter(x -> x.name().equalsIgnoreCase(name)).findFirst();
        }
    }

    public static class Interact {
        private Interact() {
        }

        private static void test(ClickAction clickAction, Player player) {
            clickAction.execute(player);
        }

        public static abstract class ClickAction {
            protected final NPC npc;
            protected final Actions.Type actionType;
            protected final HashMap<Player, Long> lastTimeExecuted;
            protected boolean enabled;
            protected ClickType clickType;
            protected BiConsumer<NPC, Player> action;
            protected Long delayTicks;
            protected Long cooldownMilliseconds;
            protected BukkitTask executingTask;
            protected List<Conditions.Condition> conditions;

            protected ClickAction(NPC npc, Actions.Type actionType, ClickType clickType) {
                this.npc = npc;
                this.actionType = actionType;
                if (clickType == null) {
                    clickType = ClickType.EITHER;
                }
                this.clickType = clickType;
                this.delayTicks = 0L;
                this.enabled = true;
                this.cooldownMilliseconds = npc.getInteractCooldown();
                this.lastTimeExecuted = new HashMap();
                this.conditions = new ArrayList<Conditions.Condition>();
            }

            @Placeholders.Replaceable(replaced=true)
            public String getReplacedString(Player player, String s) {
                return Placeholders.replace(this.npc, player, s);
            }

            public NPC getNPC() {
                return this.npc;
            }

            public Actions.Type getActionType() {
                return this.actionType;
            }

            public ClickType getClickType() {
                if (this.clickType == null) {
                    return ClickType.EITHER;
                }
                return this.clickType;
            }

            protected void execute(Player player) {
                if (!this.enabled) {
                    return;
                }
                if (this.executingTask != null) {
                    return;
                }
                if (this.delayTicks >= 1L) {
                    this.executingTask = Bukkit.getScheduler().runTaskLater(this.npc.getPlugin(), () -> this.executeAction(player), this.delayTicks.longValue());
                } else {
                    this.executeAction(player);
                }
            }

            private void executeAction(Player player) {
                if (this.lastTimeExecuted.containsKey(player) && System.currentTimeMillis() - this.lastTimeExecuted.get(player) < this.cooldownMilliseconds) {
                    return;
                }
                for (Conditions.Condition condition : this.conditions) {
                    if (condition.test(this.npc, player)) continue;
                    return;
                }
                this.action.accept(this.npc, player);
                this.lastTimeExecuted.put(player, System.currentTimeMillis());
                this.clearExecutingTask();
            }

            private void clearExecutingTask() {
                if (this.executingTask != null && !this.executingTask.isCancelled()) {
                    this.executingTask.cancel();
                }
                this.executingTask = null;
            }

            public Long getDelayTicks() {
                return this.delayTicks;
            }

            public void setDelayTicks(Long delayTicks) {
                if (delayTicks < 0L) {
                    delayTicks = 0L;
                }
                this.delayTicks = delayTicks;
            }

            public Long getCooldownMilliseconds() {
                return this.cooldownMilliseconds;
            }

            public void setCooldownMilliseconds(Long cooldownMilliseconds) {
                if (cooldownMilliseconds < this.npc.getInteractCooldown()) {
                    cooldownMilliseconds = this.npc.getInteractCooldown();
                }
                this.cooldownMilliseconds = cooldownMilliseconds;
            }

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            public void setClickType(@Nonnull ClickType clickType) {
                Validate.notNull((Object)((Object)clickType));
                this.clickType = clickType;
            }

            public List<Conditions.Condition> getConditions() {
                return this.conditions;
            }

            public void addCondition(Conditions.Condition condition) {
                this.conditions.add(condition);
            }
        }

        public static enum ClickType {
            RIGHT_CLICK,
            LEFT_CLICK,
            EITHER;


            public boolean isRightClick() {
                return this.equals((Object)RIGHT_CLICK);
            }

            public boolean isLeftClick() {
                return this.equals((Object)LEFT_CLICK);
            }

            public ClickType getInvert() {
                if (this.equals((Object)RIGHT_CLICK)) {
                    return LEFT_CLICK;
                }
                if (this.equals((Object)LEFT_CLICK)) {
                    return RIGHT_CLICK;
                }
                return null;
            }
        }

        public static class Actions {
            private Actions() {
            }

            public static abstract class Money
            extends ClickAction {
                protected Double balance;

                protected Money(NPC npc, Type actionType, ClickType clickType, Double balance) {
                    super(npc, actionType, clickType);
                    this.balance = balance;
                }

                public Double getBalance() {
                    return this.balance;
                }
            }

            public static abstract class Command
            extends ClickAction {
                private final String command;

                protected Command(NPC npc, Type actionType, ClickType clickType, String command) {
                    super(npc, actionType, clickType);
                    this.command = command;
                }

                public String getCommand() {
                    return this.command;
                }
            }

            public static class Console {
                private Console() {
                }

                public static class PerformCommand
                extends Command {
                    protected PerformCommand(NPC npc, ClickType clickType, String command) {
                        super(npc, Type.CONSOLE_PERFORM_COMMAND, clickType, command);
                        this.action = (npc1, player) -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), this.getReplacedString((org.bukkit.entity.Player)player, super.getCommand()));
                    }
                }
            }

            public static class Player {
                private Player() {
                }

                public static class WithdrawMoney
                extends Money {
                    public WithdrawMoney(NPC npc, ClickType clickType, Double balance) {
                        super(npc, Type.PLAYER_WITHDRAW_MONEY, clickType, balance);
                        this.action = (npc1, player) -> {
                            if (!IntegrationsManager.isUsingVault() || !IntegrationsManager.getVault().isUsingEconomy()) {
                                return;
                            }
                            IntegrationsManager.getVault().getEconomyManager().withdrawBalance((org.bukkit.entity.Player)player, Math.min(IntegrationsManager.getVault().getEconomyManager().getBalance((org.bukkit.entity.Player)player), this.getBalance()));
                        };
                    }
                }

                public static class GiveMoney
                extends Money {
                    public GiveMoney(NPC npc, ClickType clickType, Double balance) {
                        super(npc, Type.PLAYER_GIVE_MONEY, clickType, balance);
                        this.balance = balance;
                        this.action = (npc1, player) -> {
                            if (!IntegrationsManager.isUsingVault() || !IntegrationsManager.getVault().isUsingEconomy()) {
                                return;
                            }
                            IntegrationsManager.getVault().getEconomyManager().addBalance((org.bukkit.entity.Player)player, this.getBalance());
                        };
                    }
                }

                public static class OpenBook
                extends ClickAction {
                    protected org.bukkit.inventory.ItemStack book;

                    protected OpenBook(NPC npc, ClickType clickType, org.bukkit.inventory.ItemStack book) {
                        super(npc, Type.PLAYER_OPEN_BOOK, clickType);
                        this.book = book;
                        this.action = (npc1, player) -> player.openBook(this.getBook());
                    }

                    public org.bukkit.inventory.ItemStack getBook() {
                        return this.book;
                    }
                }

                @Deprecated
                public static class OpenEnchanting
                extends ClickAction {
                    protected OpenEnchanting(NPC npc, ClickType clickType) {
                        super(npc, Type.PLAYER_OPEN_ENCHANTING, clickType);
                        this.action = (npc1, player) -> player.openEnchanting(player.getLocation(), true);
                    }
                }

                public static class OpenWorkbench
                extends ClickAction {
                    protected OpenWorkbench(NPC npc, ClickType clickType) {
                        super(npc, Type.PLAYER_OPEN_WORKBENCH, clickType);
                        this.action = (npc1, player) -> player.openWorkbench(player.getLocation(), true);
                    }
                }

                public static class GiveKit
                extends ClickAction {
                    private final Inventory.Kit kit;

                    protected GiveKit(NPC npc, ClickType clickType, Inventory.Kit kit) {
                        super(npc, Type.PLAYER_GIVE_KIT, clickType);
                        this.kit = kit;
                        this.action = (npc1, player) -> this.getKit().giveKit((org.bukkit.entity.Player)player);
                    }

                    public Inventory.Kit getKit() {
                        return this.kit;
                    }
                }

                public static class GiveItem
                extends ClickAction {
                    private final org.bukkit.inventory.ItemStack itemStack;
                    private GiveType giveType;

                    protected GiveItem(NPC npc, ClickType clickType, org.bukkit.inventory.ItemStack itemStack) {
                        super(npc, Type.PLAYER_GIVE_ITEM, clickType);
                        this.itemStack = itemStack;
                        this.setGiveType(GiveType.ADD_ITEM);
                    }

                    public void setGiveType(GiveType giveType) {
                        if (giveType.equals((Object)GiveType.ADD_ITEM)) {
                            this.action = (npc1, player) -> player.getInventory().addItem(new org.bukkit.inventory.ItemStack[]{this.getItemStack()});
                        }
                        if (giveType.equals((Object)GiveType.SET_ITEM_MAIN_HAND)) {
                            this.action = (npc1, player) -> player.getInventory().setItemInMainHand(this.getItemStack());
                        }
                        if (giveType.equals((Object)GiveType.SET_ITEM_OFF_HAND)) {
                            this.action = (npc1, player) -> player.getInventory().setItemInOffHand(this.getItemStack());
                        }
                        if (giveType.equals((Object)GiveType.SET_EQUIPMENT)) {
                            this.action = (npc1, player) -> {
                                if (this.getItemStack().getType().name().contains("_HELMET")) {
                                    player.getInventory().setHelmet(this.getItemStack());
                                }
                                if (this.getItemStack().getType().name().contains("_CHESTPLATE")) {
                                    player.getInventory().setChestplate(this.getItemStack());
                                }
                                if (this.getItemStack().getType().name().contains("_LEGGINGS")) {
                                    player.getInventory().setLeggings(this.getItemStack());
                                }
                                if (this.getItemStack().getType().name().contains("_BOOTS")) {
                                    player.getInventory().setBoots(this.getItemStack());
                                }
                            };
                        }
                        this.giveType = giveType;
                    }

                    public org.bukkit.inventory.ItemStack getItemStack() {
                        return this.itemStack;
                    }

                    public GiveType getGiveType() {
                        return this.giveType;
                    }

                    public static enum GiveType {
                        ADD_ITEM,
                        SET_ITEM_MAIN_HAND,
                        SET_ITEM_OFF_HAND,
                        SET_EQUIPMENT;

                    }
                }

                public static class TeleportToLocation
                extends ClickAction {
                    private final Location location;

                    protected TeleportToLocation(NPC npc, ClickType clickType, Location location) {
                        super(npc, Type.PLAYER_TELEPORT_TO_LOCATION, clickType);
                        this.location = location;
                        this.action = (npc1, player) -> player.teleport(this.getLocation());
                    }

                    public Location getLocation() {
                        return this.location;
                    }
                }

                public static class ConnectBungeeServer
                extends ClickAction {
                    @Placeholders.Replaceable(replaced=false)
                    private String server;

                    protected ConnectBungeeServer(NPC npc, ClickType clickType, String server) {
                        super(npc, Type.PLAYER_CONNECT_BUNGEE_SERVER, clickType);
                        this.server = server;
                        this.action = (npc1, player) -> IntegrationsManager.getBungeeCord().subChannelConnect().connect((org.bukkit.entity.Player)player, this.getReplacedString((org.bukkit.entity.Player)player, this.getServer()));
                    }

                    @Placeholders.Replaceable(replaced=false)
                    public String getServer() {
                        return this.server;
                    }

                    public void setServer(@Placeholders.Replaceable(replaced=false) String server) {
                        this.server = server;
                    }
                }

                public static class SendActionBarMessage
                extends ClickAction {
                    @ColorUtils.Colorable(colored=false)
                    @Placeholders.Replaceable(replaced=false)
                    private final String message;

                    protected SendActionBarMessage(NPC npc, ClickType clickType, String message) {
                        super(npc, Type.PLAYER_SEND_ACTIONBAR_MESSAGE, clickType);
                        this.message = message;
                        this.action = (npc1, player) -> player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)ColorUtils.formatColor(this.getReplacedString((org.bukkit.entity.Player)player, this.getMessage()))));
                    }

                    @ColorUtils.Colorable(colored=false)
                    @Placeholders.Replaceable(replaced=false)
                    public String getMessage() {
                        return this.message;
                    }
                }

                public static class SendTitleMessage
                extends ClickAction {
                    @ColorUtils.Colorable(colored=false)
                    @Placeholders.Replaceable(replaced=false)
                    private String title;
                    @ColorUtils.Colorable(colored=false)
                    @Placeholders.Replaceable(replaced=false)
                    private String subtitle;
                    @TimerUtils.Measured(measure=TimerUtils.Measure.TICKS)
                    private Integer fadeIn;
                    @TimerUtils.Measured(measure=TimerUtils.Measure.TICKS)
                    private Integer stay;
                    @TimerUtils.Measured(measure=TimerUtils.Measure.TICKS)
                    private Integer fadeOut;

                    protected SendTitleMessage(NPC npc, ClickType clickType, String title, String subtitle, Integer fadeIn, Integer stay, Integer fadeOut) {
                        super(npc, Type.PLAYER_SEND_TITLE_MESSAGE, clickType);
                        this.title = title;
                        this.subtitle = subtitle;
                        this.fadeIn = fadeIn;
                        this.stay = stay;
                        this.fadeOut = fadeOut;
                        this.action = (npc1, player) -> player.sendTitle("\u00a7f" + ColorUtils.formatColor(this.getReplacedString((org.bukkit.entity.Player)player, this.getTitle())), ColorUtils.formatColor(this.getReplacedString((org.bukkit.entity.Player)player, this.getSubtitle())), this.getFadeIn().intValue(), this.getStay().intValue(), this.getFadeOut().intValue());
                    }

                    @ColorUtils.Colorable(colored=false)
                    @Placeholders.Replaceable(replaced=false)
                    public String getTitle() {
                        return this.title;
                    }

                    @ColorUtils.Colorable(colored=false)
                    @Placeholders.Replaceable(replaced=false)
                    public String getSubtitle() {
                        return this.subtitle;
                    }

                    public void setTitle(@ColorUtils.Colorable(colored=false) @Placeholders.Replaceable(replaced=false) String title) {
                        this.title = title;
                    }

                    public void setSubtitle(@ColorUtils.Colorable(colored=false) @Placeholders.Replaceable(replaced=false) String subtitle) {
                        this.subtitle = subtitle;
                    }

                    @TimerUtils.Measured(measure=TimerUtils.Measure.TICKS)
                    public Integer getFadeIn() {
                        return this.fadeIn;
                    }

                    @TimerUtils.Measured(measure=TimerUtils.Measure.TICKS)
                    public Integer getStay() {
                        return this.stay;
                    }

                    @TimerUtils.Measured(measure=TimerUtils.Measure.TICKS)
                    public Integer getFadeOut() {
                        return this.fadeOut;
                    }

                    public void setFadeIn(@TimerUtils.Measured(measure=TimerUtils.Measure.TICKS) Integer fadeIn) {
                        this.fadeIn = fadeIn;
                    }

                    public void setStay(@TimerUtils.Measured(measure=TimerUtils.Measure.TICKS) Integer stay) {
                        this.stay = stay;
                    }

                    public void setFadeOut(@TimerUtils.Measured(measure=TimerUtils.Measure.TICKS) Integer fadeOut) {
                        this.fadeOut = fadeOut;
                    }
                }

                public static class PerformCommand
                extends Command {
                    protected PerformCommand(NPC npc, ClickType clickType, String command) {
                        super(npc, Type.PLAYER_PERFORM_COMMAND, clickType, command);
                        this.action = (npc1, player) -> player.chat("/" + this.getReplacedString((org.bukkit.entity.Player)player, super.getCommand()));
                    }
                }

                public static class SendChatMessage
                extends ClickAction {
                    @ColorUtils.Colorable(colored=false)
                    @Placeholders.Replaceable(replaced=false)
                    private String[] messages;

                    protected SendChatMessage(NPC npc, ClickType clickType, String ... message) {
                        super(npc, Type.PLAYER_SEND_CHAT_MESSAGE, clickType);
                        this.setMessage(message);
                        this.action = (npc1, player) -> Arrays.stream(this.getMessages()).toList().forEach(x -> player.sendMessage(ColorUtils.formatColor(this.getReplacedString((org.bukkit.entity.Player)player, (String)x))));
                    }

                    @ColorUtils.Colorable(colored=false)
                    @Placeholders.Replaceable(replaced=false)
                    public String[] getMessages() {
                        return this.messages;
                    }

                    public void setMessage(String ... messages) {
                        this.messages = messages;
                    }
                }

                public static class PlaySound
                extends ClickAction {
                    private Sound sound;
                    private float volume;
                    private float pitch;

                    protected PlaySound(NPC npc, ClickType clickType, Sound sound) {
                        super(npc, Type.PLAYER_PLAY_SOUND, clickType);
                        this.sound = sound;
                        this.action = (npc1, player) -> player.playSound(npc1.getLocation(), this.getSound(), this.getVolume(), this.getPitch());
                    }

                    public Sound getSound() {
                        return this.sound;
                    }

                    public float getVolume() {
                        return this.volume;
                    }

                    public float getPitch() {
                        return this.pitch;
                    }

                    public void setVolume(Float soundVolume) {
                        if ((double)soundVolume.floatValue() <= 0.1) {
                            soundVolume = Float.valueOf(0.1f);
                        }
                        if ((double)soundVolume.floatValue() >= 1.0) {
                            soundVolume = Float.valueOf(1.0f);
                        }
                        this.volume = (float)((double)Math.round((double)soundVolume.floatValue() * 10.0) / 10.0);
                    }

                    public void setPitch(Float soundPitch) {
                        if ((double)soundPitch.floatValue() <= 0.5) {
                            soundPitch = Float.valueOf(0.5f);
                        }
                        if ((double)soundPitch.floatValue() >= 2.0) {
                            soundPitch = Float.valueOf(2.0f);
                        }
                        this.pitch = (float)((double)Math.round((double)soundPitch.floatValue() * 10.0) / 10.0);
                    }
                }
            }

            public static class PlayAnimation
            extends ClickAction {
                private Animation animation;

                protected PlayAnimation(NPC npc, ClickType clickType, Animation animation) {
                    super(npc, Type.NPC_PLAY_ANIMATION, clickType);
                    this.setAnimation(animation);
                    this.action = (npc1, player) -> npc1.playAnimation(this.getAnimation());
                }

                public Animation getAnimation() {
                    return this.animation;
                }

                public void setAnimation(Animation animation) {
                    this.animation = animation;
                }
            }

            public static class SetCustomData
            extends ClickAction {
                private final Plugin pluginKey;
                private final String simpleKey;
                private final String value;
                private boolean checkIfSame;

                protected SetCustomData(NPC npc, ClickType clickType, Plugin pluginKey, String simpleKey, String value) {
                    super(npc, Type.NPC_SET_CUSTOM_DATA, clickType);
                    this.pluginKey = pluginKey;
                    this.simpleKey = simpleKey;
                    this.value = value;
                    this.checkIfSame = false;
                    this.action = (npc1, player) -> {
                        String replacedKey = this.getReplacedString((org.bukkit.entity.Player)player, this.getSimpleKey());
                        String replacedValue = this.getReplacedString((org.bukkit.entity.Player)player, this.getValue());
                        NPCLib.Registry.ID id = NPCLib.Registry.ID.of(this.getPluginKey(), replacedKey);
                        if (this.checkIfSame && npc1.hasCustomData(id) && npc1.grabCustomData(id).get().equals(replacedValue)) {
                            return;
                        }
                        npc1.setCustomData(id, replacedValue);
                    };
                }

                public boolean isCheckIfSame() {
                    return this.checkIfSame;
                }

                public void setCheckIfSame(boolean checkIfSame) {
                    this.checkIfSame = checkIfSame;
                }

                public Plugin getPluginKey() {
                    return this.pluginKey;
                }

                public String getSimpleKey() {
                    return this.simpleKey;
                }

                public String getValue() {
                    return this.value;
                }
            }

            public static class CustomAction
            extends ClickAction {
                protected CustomAction(NPC npc, ClickType clickType, BiConsumer<NPC, org.bukkit.entity.Player> customAction) {
                    super(npc, Type.CUSTOM_ACTION, clickType);
                    this.action = customAction;
                }
            }

            @Deprecated
            protected static enum LegacyType {
                CONNECT_BUNGEE_SERVER(Type.PLAYER_CONNECT_BUNGEE_SERVER),
                CUSTOM_ACTION(Type.CUSTOM_ACTION),
                GIVE_PLAYER_ITEM(Type.PLAYER_GIVE_ITEM),
                RUN_CONSOLE_COMMAND(Type.CONSOLE_PERFORM_COMMAND),
                RUN_PLAYER_COMMAND(Type.PLAYER_PERFORM_COMMAND),
                SEND_ACTIONBAR_MESSAGE(Type.PLAYER_SEND_ACTIONBAR_MESSAGE),
                SEND_CHAT_MESSAGE(Type.PLAYER_SEND_CHAT_MESSAGE),
                SEND_TITLE_MESSAGE(Type.PLAYER_SEND_TITLE_MESSAGE),
                SET_CUSTOM_DATA(Type.NPC_SET_CUSTOM_DATA),
                TELEPORT_PLAYER_TO_LOCATION(Type.PLAYER_TELEPORT_TO_LOCATION),
                OPEN_BOOK(Type.PLAYER_OPEN_BOOK);

                protected final Type type;

                private LegacyType(Type type) {
                    this.type = type;
                }
            }

            public static enum Type implements EnumUtils.GetName
            {
                CONSOLE_PERFORM_COMMAND,
                CUSTOM_ACTION,
                NPC_PLAY_ANIMATION,
                NPC_SET_CUSTOM_DATA,
                PLAYER_CLEAR_POTION_EFFECT,
                PLAYER_CONNECT_BUNGEE_SERVER(Integration.Type.BUNGEECORD, "BungeeCord", () -> IntegrationsManager.getBungeeCord().isDisconnected()),
                PLAYER_GIVE_ITEM,
                PLAYER_GIVE_KIT,
                PLAYER_GIVE_MONEY(Integration.Type.VAULT, "Vault Economy", () -> !IntegrationsManager.isUsingVault() || !IntegrationsManager.getVault().isUsingEconomy()),
                PLAYER_GIVE_POTION_EFFECT,
                PLAYER_OPEN_BOOK,
                PLAYER_OPEN_ENCHANTING,
                PLAYER_OPEN_WORKBENCH,
                PLAYER_PERFORM_COMMAND,
                PLAYER_PLAY_SOUND,
                PLAYER_SEND_ACTIONBAR_MESSAGE,
                PLAYER_SEND_CHAT_MESSAGE,
                PLAYER_SEND_TITLE_MESSAGE,
                PLAYER_TELEPORT_TO_LOCATION,
                PLAYER_WITHDRAW_MONEY(Integration.Type.VAULT, "Vault Economy", () -> !IntegrationsManager.isUsingVault() || !IntegrationsManager.getVault().isUsingEconomy());

                @Nullable
                private Integration.Type dependency;
                @Nullable
                private String dependencyTitle;
                @Nullable
                private Supplier<Boolean> notActive;

                private Type() {
                }

                private Type(@Nullable Integration.Type dependency, String dependencyTitle, Supplier<Boolean> notActive) {
                    this.dependency = dependency;
                    this.dependencyTitle = dependencyTitle;
                    this.notActive = notActive;
                }

                @Override
                public String getName(EnumUtils.NameFormat nameFormat) {
                    return nameFormat.format(this.name()).replaceAll("Npc", "NPC");
                }

                public boolean isDeprecated() {
                    return EnumUtils.isDeprecated(this);
                }

                @Nullable
                public Integration.Type getDependency() {
                    return this.dependency;
                }

                public Optional<String> getRequiredDependency() {
                    if (this.notActive == null) {
                        return Optional.empty();
                    }
                    return Optional.ofNullable(this.notActive.get() != false ? this.dependencyTitle : null);
                }
            }
        }
    }

    public static enum Animation implements EnumUtils.GetName
    {
        SWING_MAIN_ARM(0),
        TAKE_DAMAGE(1),
        LEAVE_BED(2),
        SWING_OFF_HAND(3),
        CRITICAL_EFFECT(4),
        MAGICAL_CRITICAL_EFFECT(5);

        private final int id;

        private Animation(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        protected PacketPlayOutAnimation createPacket(net.minecraft.world.entity.Entity minecraftEntity) {
            return Animation.createPacket(minecraftEntity, this);
        }

        protected static PacketPlayOutAnimation createPacket(net.minecraft.world.entity.Entity minecraftEntity, Animation animation) {
            return new PacketPlayOutAnimation(minecraftEntity, animation.getId());
        }

        public boolean isDeprecated() {
            return EnumUtils.isDeprecated(this);
        }

        public static Optional<Animation> fromName(String name) {
            return Arrays.stream(Animation.values()).filter(x -> x.name().equalsIgnoreCase(name)).findFirst();
        }

        public static Optional<Animation> fromID(int id) {
            return Arrays.stream(Animation.values()).filter(x -> x.getId() == id).findFirst();
        }
    }

    public static enum TabListVisibility implements EnumUtils.GetName
    {
        ALWAYS,
        SAME_WORLD,
        NEAR,
        NEVER;


        public static Optional<TabListVisibility> fromName(String name) {
            return Arrays.stream(TabListVisibility.values()).filter(x -> x.name().equalsIgnoreCase(name)).findFirst();
        }
    }

    public static class NameTag
    implements Cloneable {
        @Nullable
        @ColorUtils.Colorable(colored=false)
        private String prefix;
        @Nonnull
        @ColorUtils.Colorable(colored=false)
        @Replaceable(replaced=false)
        private String name;
        @Nullable
        @ColorUtils.Colorable(colored=false)
        private String suffix;

        public NameTag(@Nullable @ColorUtils.Colorable(colored=false) String prefix, @Nullable @ColorUtils.Colorable(colored=false) String name, @Nullable @ColorUtils.Colorable(colored=false) String suffix) {
            this.setPrefix(prefix);
            this.setName(name);
            this.setSuffix(suffix);
        }

        public NameTag(@Nullable String name) {
            this(null, name, null);
        }

        public Updatable.Type setPrefix(@Nullable @ColorUtils.Colorable(colored=false) String prefix) {
            if (this.prefix != null && this.prefix.equals(prefix)) {
                return Updatable.Type.NONE;
            }
            this.prefix = prefix;
            return Updatable.Type.SIMPLE_UPDATE;
        }

        public Updatable.Type setName(@Nullable @ColorUtils.Colorable(colored=false) @Replaceable(replaced=false) String name) {
            if (this.name != null && this.name.equals(name)) {
                return Updatable.Type.NONE;
            }
            this.name = name != null ? name : "{id}";
            return Updatable.Type.FORCE_UPDATE;
        }

        public Updatable.Type setSuffix(@Nullable @ColorUtils.Colorable(colored=false) String suffix) {
            if (this.suffix != null && this.suffix.equals(suffix)) {
                return Updatable.Type.NONE;
            }
            this.suffix = suffix;
            return Updatable.Type.SIMPLE_UPDATE;
        }

        @ColorUtils.Colorable(colored=false)
        public Optional<String> grabPrefix() {
            return Optional.ofNullable(this.prefix);
        }

        @ColorUtils.Colorable(colored=false)
        @Replaceable(replaced=false)
        public String getName() {
            return this.name;
        }

        @ColorUtils.Colorable(colored=false)
        public Optional<String> grabSuffix() {
            return Optional.ofNullable(this.suffix);
        }

        @ColorUtils.Colorable(colored=true)
        @Replaceable(replaced=true)
        public String toString() {
            return this.grabPrefix().map(x -> ColorUtils.formatColor(x) + org.bukkit.ChatColor.RESET).orElse("") + ColorUtils.formatColor(this.name) + this.grabSuffix().map(x -> org.bukkit.ChatColor.RESET + ColorUtils.formatColor(x)).orElse("");
        }

        protected NameTag clone() {
            return new NameTag(this.prefix, this.name, this.suffix);
        }

        public static @interface Replaceable {
            public boolean replaced();
        }
    }

    public static class Placeholders {
        private static final HashMap<String, Simple> simplePlaceholders = new HashMap();
        private static final HashMap<String, Advanced> advancedPlaceholders = new HashMap();
        private static final Pattern placeholderNamePattern = Pattern.compile("([^\\s{}]+)");
        private static final Pattern placeholderPattern = Pattern.compile("[{]" + placeholderNamePattern.pattern() + "}");

        private Placeholders() {
        }

        private static NPC asGlobalIfPossible(NPC npc) {
            Personal personal;
            if (npc instanceof Personal && (personal = (Personal)npc).hasGlobal()) {
                return personal.getGlobal();
            }
            return npc;
        }

        private static NPC asPersonalIfPossible(NPC npc, Player player) {
            Global global;
            if (npc instanceof Global && (global = (Global)npc).hasPlayer(player)) {
                return global.getPersonal(player);
            }
            return npc;
        }

        public static String formatBrackets(String placeholder) {
            return "{" + placeholder + "}";
        }

        public static String formatBrackets(String placeholder, String secondary) {
            return "{" + placeholder + ":" + secondary + "}";
        }

        public static Set<String> getSuggestedPlaceholders() {
            HashSet<String> list = new HashSet<String>();
            list.addAll(simplePlaceholders.keySet());
            advancedPlaceholders.entrySet().stream().forEach(entry -> list.add(((Advanced)entry.getValue()).getPlaceholder() + ":<" + ((Advanced)entry.getValue()).getSecondary() + ">"));
            return list;
        }

        public static List<String> getTabCompleter(@Nullable NPC npc, @Nullable Player player, @Nonnull String lastArgument) {
            ArrayList<String> list = new ArrayList<String>();
            if (lastArgument == null) {
                return list;
            }
            if (!lastArgument.contains("{")) {
                return list;
            }
            String placeholder = lastArgument.substring(lastArgument.lastIndexOf(123));
            if (!placeholder.contains("}")) {
                list.addAll(Placeholders.getSuggestedPlaceholders().stream().map(x -> Placeholders.formatBrackets(x)).filter(x -> x.startsWith(placeholder)).collect(Collectors.toList()));
                if (placeholder.contains(":")) {
                    String advancedPlaceholder = placeholder.split(":", 2)[0];
                    Placeholders.grabAdvancedPlaceholder(advancedPlaceholder.substring(1)).ifPresent(a -> {
                        String advancedKeys = "{" + a.getPlaceholder() + ":<" + a.getSecondary() + ">}";
                        List<String> sg = a.getSuggestedFunction().apply(Optional.ofNullable(npc), Optional.ofNullable(player));
                        if (sg != null && !sg.isEmpty()) {
                            list.addAll(sg.stream().map(secondary -> secondary.startsWith("\u00a7") ? secondary : "{" + a.getPlaceholder() + ":" + secondary + "}").filter(x -> x.startsWith(placeholder) || x.startsWith("\u00a7")).collect(Collectors.toList()));
                        }
                        if (!list.contains(advancedKeys)) {
                            list.add(advancedKeys);
                        }
                    });
                }
            }
            if (placeholder.length() == 1 && !IntegrationsManager.isUsingPlaceholderAPI()) {
                list.add("\u00a7eYou can also use placeholders from PlaceholderAPI");
            }
            return list;
        }

        public static Simple addSimplePlaceholder(@Nonnull String placeholder, @Nonnull BiFunction<NPC, Player, String> replacement, @Nullable String defaultValue) {
            if (Placeholders.existsSimplePlaceholder(placeholder)) {
                return null;
            }
            return new Simple(placeholder, replacement, defaultValue);
        }

        public static Advanced addAdvancedPlaceholder(@Nonnull String placeholder, @Nonnull String secondary, @Nonnull TriFunction<NPC, Player, String, String> replacement, @Nullable String defaultValue, @Nonnull BiFunction<Optional<NPC>, Optional<Player>, List<String>> suggested) {
            if (Placeholders.existsAdvancedPlaceholder(placeholder)) {
                return null;
            }
            return new Advanced(placeholder, secondary, replacement, defaultValue, suggested);
        }

        public static boolean existsSimplePlaceholder(@Nullable String placeholder) {
            return placeholder == null ? false : simplePlaceholders.containsKey(placeholder);
        }

        public static boolean existsAdvancedPlaceholder(@Nullable String placeholder) {
            return placeholder == null ? false : advancedPlaceholders.containsKey(placeholder);
        }

        public static Optional<Simple> grabSimplePlaceholder(@Nullable String placeholder) {
            return Optional.ofNullable(!Placeholders.existsSimplePlaceholder(placeholder) ? null : (Simple)simplePlaceholders.getOrDefault(placeholder, null));
        }

        public static Optional<Advanced> grabAdvancedPlaceholder(@Nullable String placeholder) {
            return Optional.ofNullable(!Placeholders.existsAdvancedPlaceholder(placeholder) ? null : (Advanced)advancedPlaceholders.getOrDefault(placeholder, null));
        }

        public static boolean containsPlaceholder(@Nullable @Replaceable(replaced=false) List<String> text) {
            for (String string : text) {
                if (!Placeholders.containsPlaceholder(string)) continue;
                return true;
            }
            return false;
        }

        public static boolean containsPlaceholder(@Nullable @Replaceable(replaced=false) String string) {
            return string != null ? placeholderPattern.matcher(string).find() : false;
        }

        @Replaceable(replaced=true)
        public static String replace(@Nonnull NPC npc, @Nonnull Player player, @Nullable @Replaceable(replaced=false) String string) {
            return Placeholders.replace(npc, player, string, 0);
        }

        @Replaceable(replaced=true)
        private static String replace(@Nonnull NPC npc, @Nonnull Player player, @Nullable @Replaceable(replaced=false) String string, int tries) {
            Validate.notNull((Object)npc, (String)"NPC cannot be null.");
            Validate.notNull((Object)player, (String)"Player cannot be null.");
            if (string == null) {
                return "";
            }
            if (tries > 4) {
                return string;
            }
            Matcher matcher = placeholderPattern.matcher(string);
            while (matcher.find()) {
                String placeholderWithoutBrackets;
                String placeholderWithBrackets = matcher.group();
                String primary = placeholderWithoutBrackets = placeholderWithBrackets.substring(1, placeholderWithBrackets.length() - 1);
                Optional<String> customDefaultValue = Optional.empty();
                if (placeholderWithoutBrackets.contains(";")) {
                    String customDefaultNotReplaced = placeholderWithoutBrackets.split(";", 2)[1];
                    customDefaultValue = Optional.of(customDefaultNotReplaced.replaceAll("_", " "));
                    primary = placeholderWithoutBrackets.replaceFirst(";" + customDefaultNotReplaced, "");
                }
                Optional<Object> secondaryValue = Optional.empty();
                if (primary.contains(":")) {
                    secondaryValue = Optional.of(primary.split(":", 2));
                }
                if (secondaryValue.isPresent()) {
                    primary = ((String[])secondaryValue.get())[0];
                    String secondary = ((String[])secondaryValue.get())[1];
                    if (secondary.contains("{") && secondary.contains("}") && string.indexOf("{") < string.lastIndexOf("}")) {
                        secondary = Placeholders.replace(npc, player, secondary);
                    }
                    if (advancedPlaceholders.containsKey(primary)) {
                        Advanced advanced = advancedPlaceholders.get(primary);
                        string = Placeholders.r(string, placeholderWithoutBrackets, advanced.replace(npc, player, secondary), customDefaultValue.isPresent() ? customDefaultValue : Optional.ofNullable(advanced.getDefaultValue()));
                        continue;
                    }
                    string = Placeholders.r(string, placeholderWithoutBrackets, null, customDefaultValue);
                    continue;
                }
                if (simplePlaceholders.containsKey(primary)) {
                    Simple simple = simplePlaceholders.get(primary);
                    string = Placeholders.r(string, placeholderWithoutBrackets, simple.replace(npc, player), customDefaultValue.isPresent() ? customDefaultValue : Optional.ofNullable(simple.getDefaultValue()));
                    continue;
                }
                string = Placeholders.r(string, placeholderWithoutBrackets, null, customDefaultValue);
            }
            if (IntegrationsManager.isUsingPlaceholderAPI()) {
                string = IntegrationsManager.getPlaceholderAPI().replace(player, string);
            }
            ++tries;
            if (string.contains("{") && string.contains("}") && string.indexOf("{") < string.lastIndexOf("}")) {
                return Placeholders.replace(npc, player, string, tries);
            }
            return string;
        }

        @Replaceable(replaced=true)
        private static String r(@Nonnull @Replaceable(replaced=false) String string, @Nonnull String placeHolder, @Nullable String value, Optional<String> defaultValue) {
            return string.replaceFirst("\\{" + placeHolder + "\\}", value != null ? value : (defaultValue.isPresent() ? defaultValue.get() : "N/A"));
        }

        static {
            Placeholders.addSimplePlaceholder("playerName", (npc, player) -> player.getName(), null);
            Placeholders.addSimplePlaceholder("playerDisplayName", (npc, player) -> player.getDisplayName(), null);
            Placeholders.addSimplePlaceholder("playerUUID", (npc, player) -> player.getUniqueId().toString(), null);
            Placeholders.addSimplePlaceholder("playerVersion", (npc, player) -> ((Personal)Placeholders.asPersonalIfPossible(npc, player)).getClientVersion().getMinecraftVersion(), null);
            Placeholders.addSimplePlaceholder("playerWorld", (npc, player) -> player.getWorld().getName(), null);
            Placeholders.addSimplePlaceholder("playerKillerName", (npc, player) -> player.getKiller() != null ? player.getKiller().getName() : null, null);
            Placeholders.addSimplePlaceholder("playerKillerDisplayName", (npc, player) -> player.getKiller() != null ? player.getKiller().getDisplayName() : null, null);
            Placeholders.addSimplePlaceholder("playerHealth", (npc, player) -> String.valueOf(player.getHealth()), null);
            Placeholders.addSimplePlaceholder("playerHealthScale", (npc, player) -> String.valueOf(player.getHealthScale()), null);
            Placeholders.addSimplePlaceholder("playerLocationX", (npc, player) -> String.valueOf(player.getLocation().getX()), null);
            Placeholders.addSimplePlaceholder("playerLocationY", (npc, player) -> String.valueOf(player.getLocation().getY()), null);
            Placeholders.addSimplePlaceholder("playerLocationZ", (npc, player) -> String.valueOf(player.getLocation().getZ()), null);
            Placeholders.addSimplePlaceholder("playerLocationYaw", (npc, player) -> String.valueOf(player.getLocation().getYaw()), null);
            Placeholders.addSimplePlaceholder("playerLocationPitch", (npc, player) -> String.valueOf(player.getLocation().getPitch()), null);
            Placeholders.addSimplePlaceholder("playerLocale", (npc, player) -> player.getLocale(), null);
            Placeholders.addSimplePlaceholder("playerDistanceToNPC", (npc, player) -> {
                if (!npc.getWorld().equals(player.getWorld())) {
                    return "";
                }
                Double a = player.getLocation().distance(npc.getLocation());
                String color = "\u00a7a";
                if (a > 10.0) {
                    color = "\u00a7e";
                }
                if (a > 25.0) {
                    color = "\u00a7c";
                }
                return color + MathUtils.getFormat(a, 2);
            }, null);
            Placeholders.addAdvancedPlaceholder("playerLookingAtNPC", "fov", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, player, secondary) -> String.valueOf(((Personal)Placeholders.asPersonalIfPossible(npc, player)).isInView(Double.valueOf(secondary)))), null, (npc, player) -> List.of("60"));
            Placeholders.addSimplePlaceholder("serverOnlinePlayers", (npc, player) -> "" + npc.getPlugin().getServer().getOnlinePlayers().size(), null);
            Placeholders.addSimplePlaceholder("serverMaxPlayers", (npc, player) -> "" + npc.getPlugin().getServer().getMaxPlayers(), null);
            Placeholders.addSimplePlaceholder("serverVersion", (npc, player) -> ((Personal)Placeholders.asPersonalIfPossible(npc, player)).getServerVersion().getMinecraftVersion(), null);
            Placeholders.addSimplePlaceholder("npcID", (npc, player) -> Placeholders.asGlobalIfPossible(npc).getFullID(), null);
            Placeholders.addSimplePlaceholder("npcSimpleID", (npc, player) -> Placeholders.asGlobalIfPossible(npc).getSimpleID(), null);
            Placeholders.addSimplePlaceholder("npcPersonalID", (npc, player) -> npc.getID().getFullID(), null);
            Placeholders.addSimplePlaceholder("npcPersonalSimpleID", (npc, player) -> npc.getID().getSimpleID(), null);
            Placeholders.addSimplePlaceholder("npcWorld", (npc, player) -> npc.getWorld().getName(), null);
            Placeholders.addSimplePlaceholder("npcTabListName", (npc, player) -> npc.getTabListName().replaceAll("\\{id}", ((Personal)Placeholders.asPersonalIfPossible(npc, player)).getGameProfile().getName()), null);
            Placeholders.addSimplePlaceholder("npcNameTag", (npc, player) -> npc.getNameTag().toString().replaceAll("\\{id}", ((Personal)Placeholders.asPersonalIfPossible(npc, player)).getGameProfile().getName()), null);
            Placeholders.addSimplePlaceholder("npcPluginName", (npc, player) -> npc.getPlugin().getDescription().getName(), null);
            Placeholders.addSimplePlaceholder("npcPluginVersion", (npc, player) -> npc.getPlugin().getDescription().getVersion(), null);
            Placeholders.addAdvancedPlaceholder("npcCustomData", "key", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, player, key) -> Placeholders.asGlobalIfPossible(npc).grabCustomData((String)key).orElse(null)), "", (npc, player) -> npc.isPresent() ? Placeholders.asGlobalIfPossible((NPC)npc.get()).getCustomDataKeys().stream().toList() : null);
            Placeholders.addAdvancedPlaceholder("npcPersonalCustomData", "key", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, player, key) -> Placeholders.asPersonalIfPossible(npc, player).grabCustomData((String)key).orElse(null)), "", (npc, player) -> npc.isPresent() && player.isPresent() ? Placeholders.asPersonalIfPossible((NPC)npc.get(), (Player)player.get()).getCustomDataKeys().stream().toList() : null);
            Placeholders.addAdvancedPlaceholder("rgbColor", "red,green,blue", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, player, key) -> {
                String[] rgb = key.split(",", 3);
                Integer r = Integer.valueOf(rgb[0]);
                Integer g = Integer.valueOf(rgb[1]);
                Integer b = Integer.valueOf(rgb[2]);
                java.awt.Color color = new java.awt.Color(r, g, b);
                return "&#" + Integer.toHexString(color.getRGB()).substring(2);
            }), "&f", (npc, player) -> List.of("0,0,0", "255,255,255", "\u00a7bReturns the color with the values of red, green, and blue."));
            Placeholders.addAdvancedPlaceholder("stripColor", "input", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, palyer, secondary) -> org.bukkit.ChatColor.stripColor((String)secondary)), null, (npc, player) -> List.of("\u00a7bReturns the input without any color."));
            Placeholders.addAdvancedPlaceholder("randomOf", "values", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, player, values) -> {
                String[] value = values.split(",");
                return value[ThreadLocalRandom.current().nextInt(0, value.length)];
            }), null, (npc, player) -> List.of("a,b,c,d,e", "1,2,3", "\u00a7bRandomly returns one of the values."));
            Placeholders.addAdvancedPlaceholder("randomRange", "start,end", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, player, range) -> {
                String[] ranges = range.split(",", 2);
                String start = ranges[0];
                String end = ranges[1];
                if (MathUtils.isInteger(start) && MathUtils.isInteger(end)) {
                    return String.valueOf(ThreadLocalRandom.current().nextInt(Integer.valueOf(start), Integer.valueOf(end) + 1));
                }
                if (MathUtils.isDouble(start) && MathUtils.isDouble(end)) {
                    return String.valueOf(ThreadLocalRandom.current().nextDouble(Double.valueOf(start), Double.valueOf(end)));
                }
                if (start.length() == 1 && end.length() == 1) {
                    return String.valueOf((char)ThreadLocalRandom.current().nextInt(start.charAt(0), end.charAt(0) + '\u0001'));
                }
                return null;
            }), null, (npc, player) -> List.of("0,100", "a,z", "\u00a7bRandomly returns a value within the range from start to end."));
            Placeholders.addAdvancedPlaceholder("logicEquals", "first,second", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, player, secondary) -> {
                String[] values = secondary.split(",", 2);
                return String.valueOf(values[0].equalsIgnoreCase(values[1]));
            }), "false", (npc, player) -> List.of("{playerVersion},{serverVersion}", "\u00a7bReturns if first and second are equals (not case sensitive)."));
            Placeholders.addAdvancedPlaceholder("logicOr", "first,second", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, player, secondary) -> {
                String[] values = secondary.split(",", 2);
                return String.valueOf(Boolean.valueOf(values[0]) != false || Boolean.valueOf(values[1]) != false);
            }), "false", (npc, player) -> List.of("\u00a7bReturns true if either first or second is true."));
            Placeholders.addAdvancedPlaceholder("logicAnd", "first,second", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, player, secondary) -> {
                String[] values = secondary.split(",", 2);
                return String.valueOf(Boolean.valueOf(values[0]) != false && Boolean.valueOf(values[1]) != false);
            }), "false", (npc, player) -> List.of("\u00a7bReturns true if either first or second is true."));
            Placeholders.addAdvancedPlaceholder("logicInvert", "boolean", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, player, secondary) -> String.valueOf(Boolean.valueOf(secondary) == false)), null, (npc, player) -> List.of("\u00a7bReturns the inverted value of the boolean."));
            Placeholders.addAdvancedPlaceholder("formatBoolean", "boolean,true,false", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, player, secondary) -> {
                String[] values;
                return values[Boolean.valueOf((values = secondary.split(",", 3))[0]) != false ? 1 : 2].replaceAll("_", " ");
            }), null, (npc, player) -> List.of("{equals:{npcWorld},world},&aSame_world,&cNot_same_world", "\u00a7bReturns the value assigned to true, or false, depending on the value of the boolean."));
            Placeholders.addAdvancedPlaceholder("formatDouble", "double,decimals", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, player, secondary) -> {
                String[] values = secondary.split(",", 2);
                return MathUtils.getSimpleFormat(Double.valueOf(values[0]), Integer.valueOf(values[1]));
            }), null, (npc, player) -> List.of("\u00a7bReturns the double with the specified limit of decimal places."));
            Placeholders.addAdvancedPlaceholder("progressBar", "double,maximum,length,character,color,color", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, player, secondary) -> {
                int in;
                String[] values = secondary.split(",", 6);
                StringBuilder output = new StringBuilder("");
                Double por = Double.valueOf(values[0]) * 100.0 / Double.valueOf(values[1]);
                Integer total = Integer.valueOf(values[2]);
                Integer por5 = por.intValue() / (100 / total);
                for (in = 0; in < por5; ++in) {
                    output.append(values[4] + values[3]);
                }
                for (in = 0; in < total - por5; ++in) {
                    output.append(values[5] + values[3]);
                }
                return output.toString();
            }), null, (npc, player) -> List.of("0.25,1,10,\u25ac,&a,&8", "25,100,10,\u25b0,&6,&7", "50,100,10,\u25cf,&a,&8", "\u00a7bReturns a progress bar consisting of the character and colored with the first color up to the percentage of the total."));
            Placeholders.addAdvancedPlaceholder("mathAdd", "amount,amount", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, player, secondary) -> {
                String[] values = secondary.split(",", 2);
                return String.valueOf(Double.valueOf(values[0]) + Double.valueOf(values[1]));
            }), null, (npc, player) -> List.of());
            Placeholders.addAdvancedPlaceholder("mathSubtract", "minuend,subtrahend", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, player, secondary) -> {
                String[] values = secondary.split(",", 2);
                return String.valueOf(Double.valueOf(values[0]) - Double.valueOf(values[1]));
            }), null, (npc, player) -> List.of());
            Placeholders.addAdvancedPlaceholder("mathMultiply", "factor,factor", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, player, secondary) -> {
                String[] values = secondary.split(",", 2);
                return String.valueOf(Double.valueOf(values[0]) * Double.valueOf(values[1]));
            }), null, (npc, player) -> List.of());
            Placeholders.addAdvancedPlaceholder("mathDivide", "dividend,divider", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, player, secondary) -> {
                String[] values = secondary.split(",", 2);
                return String.valueOf(Double.valueOf(values[0]) / Double.valueOf(values[1]));
            }), null, (npc, player) -> List.of());
            Placeholders.addAdvancedPlaceholder("mathRest", "dividend,divider", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, player, secondary) -> {
                String[] values = secondary.split(",", 2);
                return String.valueOf(Double.valueOf(values[0]) % Double.valueOf(values[1]));
            }), null, (npc, player) -> List.of());
            Placeholders.addAdvancedPlaceholder("mathPower", "base,exponent", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, player, secondary) -> {
                String[] values = secondary.split(",", 2);
                return String.valueOf(Math.pow(Double.valueOf(values[0]), Double.valueOf(values[1])));
            }), null, (npc, player) -> List.of());
            Placeholders.addAdvancedPlaceholder("mathMin", "value,value", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, player, secondary) -> {
                String[] values = secondary.split(",", 2);
                return String.valueOf(Math.min(Double.valueOf(values[0]), Double.valueOf(values[1])));
            }), null, (npc, player) -> List.of());
            Placeholders.addAdvancedPlaceholder("mathMax", "value,value", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, player, secondary) -> {
                String[] values = secondary.split(",", 2);
                return String.valueOf(Math.max(Double.valueOf(values[0]), Double.valueOf(values[1])));
            }), null, (npc, player) -> List.of());
            Placeholders.addAdvancedPlaceholder("mathAbs", "value", (TriFunction<NPC, Player, String, String>)((TriFunction)(npc, player, secondary) -> String.valueOf(Math.abs(Double.valueOf(secondary)))), null, (npc, player) -> List.of());
        }

        public static class Simple
        extends Placeholder {
            private final BiFunction<NPC, Player, String> replacement;

            protected Simple(@Nonnull String placeholder, @Nonnull BiFunction<NPC, Player, String> replacement, @Nullable String defaultValue) {
                super(placeholder, defaultValue);
                Validate.notNull(replacement, (String)"Replacement cannot be null.");
                Validate.isTrue((!simplePlaceholders.containsKey(placeholder) ? 1 : 0) != 0, (String)("Simple Placeholder {" + placeholder + "} settled previously"));
                this.replacement = replacement;
                simplePlaceholders.put(placeholder, this);
            }

            public BiFunction<NPC, Player, String> getReplacementFunction() {
                return this.replacement;
            }

            @Nullable
            @Replaceable(replaced=true)
            public String replace(NPC npc, Player player) {
                String replacement = this.getDefaultValue();
                try {
                    replacement = this.getReplacementFunction().apply(npc, player);
                }
                catch (Exception e) {
                    NPCLib.DebugManager.printError(e);
                }
                return replacement;
            }
        }

        public static class Advanced
        extends Placeholder {
            private final String secondary;
            private final TriFunction<NPC, Player, String, String> replacement;
            private final BiFunction<Optional<NPC>, Optional<Player>, List<String>> suggested;

            public Advanced(@Nonnull String placeholder, @Nonnull String secondary, @Nonnull TriFunction<NPC, Player, String, String> replacement, @Nullable String defaultValue, @Nonnull BiFunction<Optional<NPC>, Optional<Player>, List<String>> suggested) {
                super(placeholder, defaultValue);
                Validate.notNull(replacement, (String)"Replacement cannot be null.");
                Validate.notNull(suggested, (String)"Suggested cannot be null.");
                Validate.isTrue((!advancedPlaceholders.containsKey(placeholder) ? 1 : 0) != 0, (String)("Advanced Placeholder {" + placeholder + ":<" + (advancedPlaceholders.containsKey(placeholder) ? advancedPlaceholders.get(placeholder).getSecondary() : "secondary") + ">} settled previously"));
                this.secondary = secondary;
                this.replacement = replacement;
                this.suggested = suggested;
                advancedPlaceholders.put(placeholder, this);
            }

            public String getSecondary() {
                return this.secondary;
            }

            public TriFunction<NPC, Player, String, String> getReplacementFunction() {
                return this.replacement;
            }

            public BiFunction<Optional<NPC>, Optional<Player>, List<String>> getSuggestedFunction() {
                return this.suggested;
            }

            @Nullable
            @Replaceable(replaced=true)
            public String replace(NPC npc, Player player, String secondary) {
                try {
                    return (String)this.getReplacementFunction().apply((Object)npc, (Object)player, (Object)secondary);
                }
                catch (Exception e) {
                    NPCLib.DebugManager.printError(e);
                    return null;
                }
            }
        }

        public static @interface Replaceable {
            public boolean replaced();
        }

        protected static abstract class Placeholder {
            @Nonnull
            private final String placeholder;
            @Nullable
            private final String defaultValue;

            protected Placeholder(@Nonnull String placeholder, @Nullable String defaultValue) {
                Validate.notNull((Object)placeholder, (String)"Placeholder cannot be null");
                Validate.isTrue((boolean)placeholderNamePattern.matcher(placeholder).matches(), (String)("Invalid placeholder name. Correct pattern " + placeholderNamePattern.pattern()));
                this.placeholder = placeholder;
                this.defaultValue = defaultValue;
            }

            @Nonnull
            public String getPlaceholder() {
                return this.placeholder;
            }

            @Nullable
            public String getDefaultValue() {
                return this.defaultValue;
            }
        }
    }

    public static class Conditions {

        public static class ErrorResponse {
            private ChatMessageType chatMessageType = ChatMessageType.CHAT;
            private String errorMessage = null;
            private Boolean playRedAnimation = false;
            private Sound sound = null;
            private Float soundVolume = Float.valueOf(1.0f);
            private Float soundPitch = Float.valueOf(1.0f);

            protected void play(NPC npc, org.bukkit.entity.Player player) {
                if (this.errorMessage != null) {
                    player.spigot().sendMessage(this.chatMessageType, (BaseComponent)new TextComponent(Placeholders.replace(npc, player, this.errorMessage)));
                }
                if (this.playRedAnimation.booleanValue()) {
                    if (npc instanceof Global) {
                        ((Global)npc).playAnimation(player, Animation.TAKE_DAMAGE);
                    } else {
                        npc.playAnimation(Animation.TAKE_DAMAGE);
                    }
                }
                if (this.sound != null) {
                    player.playSound(npc.getLocation(), this.sound, this.soundVolume.floatValue(), this.soundPitch.floatValue());
                }
            }

            public void setMessage(String errorMessage) {
                this.errorMessage = errorMessage;
            }

            public void setChatMessageType(ChatMessageType chatMessageType) {
                this.chatMessageType = chatMessageType;
            }

            public void setMessage(ChatMessageType chatMessageType, String errorMessage) {
                this.chatMessageType = chatMessageType;
                this.errorMessage = errorMessage;
            }

            public void setSound(Sound sound) {
                this.sound = sound;
            }

            public void setSound(Sound sound, Float volume, Float pitch) {
                this.sound = sound;
                this.setSoundVolume(volume);
                this.setSoundPitch(pitch);
            }

            public void setSoundVolume(Float soundVolume) {
                if ((double)soundVolume.floatValue() <= 0.1) {
                    soundVolume = Float.valueOf(0.1f);
                }
                if ((double)soundVolume.floatValue() >= 1.0) {
                    soundVolume = Float.valueOf(1.0f);
                }
                this.soundVolume = Float.valueOf((float)((double)Math.round((double)soundVolume.floatValue() * 10.0) / 10.0));
            }

            public void setSoundPitch(Float soundPitch) {
                if ((double)soundPitch.floatValue() <= 0.5) {
                    soundPitch = Float.valueOf(0.5f);
                }
                if ((double)soundPitch.floatValue() >= 2.0) {
                    soundPitch = Float.valueOf(2.0f);
                }
                this.soundPitch = Float.valueOf((float)((double)Math.round((double)soundPitch.floatValue() * 10.0) / 10.0));
            }

            public void setPlayRedAnimation(Boolean playRedAnimation) {
                this.playRedAnimation = playRedAnimation;
            }

            public ChatMessageType getChatMessageType() {
                return this.chatMessageType;
            }

            public String getErrorMessage() {
                return this.errorMessage;
            }

            public Boolean getPlayRedAnimation() {
                return this.playRedAnimation;
            }

            public Sound getSound() {
                return this.sound;
            }

            public Float getSoundVolume() {
                return this.soundVolume;
            }

            public Float getSoundPitch() {
                return this.soundPitch;
            }
        }

        public static class Player {
            private Player() {
            }

            public static class Balance
            extends Condition {
                private Double balance;

                public Balance(Double balance) {
                    super(Type.PLAYER_HAS_BALANCE);
                    this.condition = (npc, player) -> {
                        if (!IntegrationsManager.isUsingVault() || !IntegrationsManager.getVault().isUsingEconomy()) {
                            return true;
                        }
                        return IntegrationsManager.getVault().getEconomyManager().hasBalance((org.bukkit.entity.Player)player, balance);
                    };
                    this.balance = balance;
                }

                public void setBalance(@Nonnull Double balance) {
                    Validate.notNull((Object)balance);
                    this.balance = balance;
                }

                public Double getBalance() {
                    return this.balance;
                }

                public Map<String, Object> serialize() {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("balance", this.getBalance());
                    data.putAll(this.generalSerialization());
                    return data;
                }

                public static Balance deserialize(Map<String, Object> map) {
                    Balance balance = new Balance((Double)map.get("balance"));
                    Balance.generalDeserialization(map, balance);
                    return balance;
                }
            }

            public static class Permission
            extends Condition {
                private String permission;

                public Permission(String permission) {
                    super(Type.PLAYER_HAS_PERMISSION);
                    this.condition = (npc, player) -> player.hasPermission(Placeholders.replace(npc, player, this.getPermission())) || player.isOp();
                    this.permission = permission;
                }

                public String getPermission() {
                    return this.permission;
                }

                public void setPermission(@Nonnull String permission) {
                    Validate.notNull((Object)permission);
                    this.permission = permission;
                }

                public Map<String, Object> serialize() {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("permission", this.getPermission());
                    data.putAll(this.generalSerialization());
                    return data;
                }

                public static Permission deserialize(Map<String, Object> map) {
                    Permission permission = new Permission((String)map.get("permission"));
                    Permission.generalDeserialization(map, permission);
                    return permission;
                }
            }
        }

        public static class Comparator {

            public static class Sentence
            extends Condition {
                private String first = "";
                private String second = "";
                private Logic logic = Logic.EQUALS;

                public Sentence() {
                    super(Type.COMPARATOR_SENTENCE);
                    this.condition = (npc, player) -> {
                        if (this.getFirst() == null || this.getSecond() == null || this.getLogic() == null) {
                            return true;
                        }
                        String firstSentence = Placeholders.replace(npc, player, this.getFirst());
                        String secondSentence = Placeholders.replace(npc, player, this.getSecond());
                        return this.getLogic().comparatorFunction.apply(firstSentence, secondSentence);
                    };
                }

                @Nonnull
                public String getFirst() {
                    return this.first;
                }

                @Nonnull
                public String getSecond() {
                    return this.second;
                }

                @Nonnull
                public Logic getLogic() {
                    return this.logic;
                }

                public void setFirst(@Nonnull String first) {
                    Validate.notNull((Object)first);
                    this.first = first;
                }

                public void setSecond(@Nonnull String second) {
                    Validate.notNull((Object)second);
                    this.second = second;
                }

                public void setLogic(@Nonnull Logic logic) {
                    Validate.notNull((Object)((Object)logic));
                    this.logic = logic;
                }

                public Map<String, Object> serialize() {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("first", this.getFirst());
                    data.put("second", this.getSecond());
                    data.put("logic", this.getLogic().name());
                    data.putAll(this.generalSerialization());
                    return data;
                }

                public static Sentence deserialize(Map<String, Object> map) {
                    Sentence condition = new Sentence();
                    if (map.containsKey("first")) {
                        condition.first = (String)map.get("first");
                    }
                    if (map.containsKey("second")) {
                        condition.second = (String)map.get("second");
                    }
                    if (map.containsKey("logic")) {
                        condition.logic = Logic.valueOf((String)map.get("logic"));
                    }
                    Sentence.generalDeserialization(map, condition);
                    return condition;
                }

                public static enum Logic {
                    EQUALS((f, s) -> f.equals(s)),
                    EQUALS_IGNORE_CASE((f, s) -> f.equalsIgnoreCase((String)s)),
                    CONTAINS((f, s) -> f.contains((CharSequence)s)),
                    CONTAINS_IGNORE_CASE((f, s) -> f.toLowerCase().contains(s.toLowerCase())),
                    STARTS_WITH((f, s) -> f.startsWith((String)s)),
                    STARTS_WITH_IGNORE_CASE((f, s) -> f.toLowerCase().startsWith(s.toLowerCase())),
                    ENDS_WITH((f, s) -> f.endsWith((String)s)),
                    ENDS_WITH_IGNORE_CASE((f, s) -> f.toLowerCase().endsWith(s.toLowerCase()));

                    protected BiFunction<String, String, Boolean> comparatorFunction;

                    private Logic(BiFunction<String, String, Boolean> comparatorFunction) {
                        this.comparatorFunction = comparatorFunction;
                    }
                }
            }
        }

        public static abstract class Condition
        implements ConfigurationSerializable {
            protected final Type type;
            protected BiFunction<NPC, org.bukkit.entity.Player, Boolean> condition;
            protected Boolean logicNegative;
            protected Boolean enabled;
            protected ErrorResponse errorResponse;

            protected Condition(Type type) {
                this.type = type;
                this.logicNegative = false;
                this.errorResponse = new ErrorResponse();
                this.condition = null;
                this.enabled = true;
            }

            public boolean test(NPC npc, org.bukkit.entity.Player player) {
                boolean result = this.testSilent(npc, player);
                if (!result && this.errorResponse != null) {
                    this.errorResponse.play(npc, player);
                }
                return result;
            }

            public boolean testSilent(NPC npc, org.bukkit.entity.Player player) {
                if (!this.enabled.booleanValue()) {
                    return true;
                }
                boolean result = this.condition.apply(npc, player);
                if (this.logicNegative.booleanValue()) {
                    result = !result;
                }
                return result;
            }

            public ErrorResponse getErrorResponse() {
                return this.errorResponse;
            }

            protected void setErrorResponse(ErrorResponse errorResponse) {
                this.errorResponse = errorResponse;
            }

            public Boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(Boolean enabled) {
                if (enabled == null) {
                    enabled = true;
                }
                this.enabled = enabled;
            }

            public Type getType() {
                return this.type;
            }

            public Boolean isLogicNegative() {
                return this.logicNegative;
            }

            public void setLogicNegative(@Nonnull Boolean logicNegative) {
                Validate.notNull((Object)logicNegative);
                this.logicNegative = logicNegative;
            }

            protected Map<String, Object> generalSerialization() {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("enabled", this.isEnabled());
                data.put("logicNegative", this.isLogicNegative());
                if (this.errorResponse.getErrorMessage() == null) {
                    data.put("errorResponse.message", "");
                } else {
                    data.put("errorResponse.message", this.getErrorResponse().getErrorMessage().replaceAll("\u00a7", "&"));
                }
                data.put("errorResponse.messageType", this.getErrorResponse().getChatMessageType().name());
                data.put("errorResponse.redAnimation", this.getErrorResponse().getPlayRedAnimation());
                data.put("errorResponse.sound", this.getErrorResponse().getSound() != null ? this.getErrorResponse().getSound().name() : "none");
                data.put("errorResponse.soundVolume", this.getErrorResponse().getSoundVolume().doubleValue());
                data.put("errorResponse.soundPitch", this.getErrorResponse().getSoundPitch().doubleValue());
                return data;
            }

            protected static void generalDeserialization(Map<String, Object> map, Condition condition) {
                if (map.containsKey("enabled")) {
                    condition.setEnabled((Boolean)map.get("enabled"));
                }
                if (map.containsKey("logicNegative")) {
                    condition.setLogicNegative((Boolean)map.get("logicNegative"));
                }
                ErrorResponse errorResponse = condition.getErrorResponse();
                if (map.containsKey("errorResponse.message")) {
                    String as = (String)map.get("errorResponse.message");
                    if (as.equals("")) {
                        errorResponse.setMessage(null);
                    } else {
                        errorResponse.setMessage(as.replaceAll("&", "\u00a7"));
                    }
                }
                if (map.containsKey("errorResponse.messageType")) {
                    errorResponse.setChatMessageType(ChatMessageType.valueOf((String)((String)map.get("errorResponse.messageType"))));
                }
                if (map.containsKey("errorResponse.redAnimation")) {
                    errorResponse.setPlayRedAnimation((Boolean)map.get("errorResponse.redAnimation"));
                }
                if (map.containsKey("errorResponse.sound")) {
                    errorResponse.sound = map.get("errorResponse.sound").equals("none") ? null : Sound.valueOf((String)((String)map.get("errorResponse.sound")));
                }
                if (map.containsKey("errorResponse.soundVolume")) {
                    errorResponse.soundVolume = Float.valueOf(((Double)map.get("errorResponse.soundVolume")).floatValue());
                }
                if (map.containsKey("errorResponse.soundPitch")) {
                    errorResponse.soundPitch = Float.valueOf(((Double)map.get("errorResponse.soundPitch")).floatValue());
                }
            }
        }

        public static enum Type implements EnumUtils.GetName
        {
            COMPARATOR_NUMBER,
            COMPARATOR_SENTENCE,
            PLAYER_HAS_BALANCE,
            PLAYER_HAS_PERMISSION;


            public boolean isDeprecated() {
                return EnumUtils.isDeprecated(this);
            }

            public boolean requiresVaultEconomy() {
                return Arrays.asList(PLAYER_HAS_BALANCE).contains(this);
            }

            public String getRequiredDependency() {
                String requiredDependency = null;
                if (!(!this.requiresVaultEconomy() || IntegrationsManager.isUsingVault() && IntegrationsManager.getVault().isUsingEconomy())) {
                    requiredDependency = "Vault Economy";
                }
                return requiredDependency;
            }
        }
    }

    public static class Inventory {
        private Inventory() {
        }

        public static class Kit
        implements ConfigurationSerializable {
            private HashMap<Integer, org.bukkit.inventory.ItemStack> items = new HashMap();

            public Kit() {
            }

            public Kit(@Nonnull PlayerInventory playerInventory) {
                this();
                for (int i = 0; i < 36; ++i) {
                    org.bukkit.inventory.ItemStack itemStack = playerInventory.getItem(i);
                    if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) continue;
                    this.items.put(i, playerInventory.getItem(i));
                }
                this.items.put(36, playerInventory.getItemInOffHand());
                this.items.put(37, playerInventory.getHelmet());
                this.items.put(38, playerInventory.getChestplate());
                this.items.put(39, playerInventory.getLeggings());
                this.items.put(40, playerInventory.getBoots());
            }

            public Kit(@Nonnull Player player) {
                this(player.getInventory());
            }

            public void setItem(Integer slot, org.bukkit.inventory.ItemStack itemStack) {
                if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
                    return;
                }
                this.items.put(slot, itemStack);
            }

            public void giveKit(Player player) {
                for (int i = 0; i < 36; ++i) {
                    org.bukkit.inventory.ItemStack itemStack = this.items.get(i);
                    if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) continue;
                    player.getInventory().setItem(i, itemStack);
                }
            }

            public static void giveKit(Kit kit, Player player) {
                kit.giveKit(player);
            }

            public Map<String, Object> serialize() {
                return null;
            }
        }
    }

    public static class Events {
        private Events() {
        }

        public static class StartMove
        extends Event
        implements Cancellable {
            private final Location start;
            private final Location end;
            private final int taskID;
            private boolean isCancelled;

            protected StartMove(NPC npc, Location start, Location end, int taskID) {
                super(npc);
                this.start = start;
                this.end = end;
                this.taskID = taskID;
                this.isCancelled = false;
                Bukkit.getPluginManager().callEvent((org.bukkit.event.Event)this);
            }

            public Location getStart() {
                return this.start;
            }

            public Location getEnd() {
                return this.end;
            }

            public int getTaskID() {
                return this.taskID;
            }

            public boolean isCancelled() {
                return this.isCancelled;
            }

            public void setCancelled(boolean arg) {
                this.isCancelled = arg;
            }
        }

        public static class Teleport
        extends Event
        implements Cancellable {
            private final Location to;
            private boolean isCancelled;

            protected Teleport(NPC npc, Location to) {
                super(npc);
                this.to = to;
                this.isCancelled = false;
                Bukkit.getPluginManager().callEvent((org.bukkit.event.Event)this);
            }

            public Location getFrom() {
                return this.getNPC().getLocation();
            }

            public Location getTo() {
                return this.to;
            }

            public boolean isCancelled() {
                return this.isCancelled;
            }

            public void setCancelled(boolean arg) {
                this.isCancelled = arg;
            }
        }

        public static class Show
        extends Event.Player
        implements Cancellable {
            private boolean isCancelled = false;

            protected Show(Player player, Personal npc) {
                super(player, npc);
                Bukkit.getPluginManager().callEvent((org.bukkit.event.Event)this);
            }

            public boolean isCancelled() {
                return this.isCancelled;
            }

            public void setCancelled(boolean arg) {
                this.isCancelled = arg;
            }
        }

        public static class Move
        extends Event
        implements Cancellable {
            private final Location to;
            private boolean isCancelled;

            protected Move(NPC npc, Location to) {
                super(npc);
                this.to = to;
                this.isCancelled = false;
                Bukkit.getPluginManager().callEvent((org.bukkit.event.Event)this);
            }

            public Location getFrom() {
                return this.getNPC().getLocation();
            }

            public Location getTo() {
                return this.to;
            }

            public boolean isCancelled() {
                return this.isCancelled;
            }

            public void setCancelled(boolean arg) {
                this.isCancelled = arg;
            }
        }

        public static class Interact
        extends Event.Player
        implements Cancellable {
            private final Interact.ClickType clickType;
            private boolean isCancelled;

            protected Interact(Player player, Personal npc, Interact.ClickType clickType) {
                super(player, npc);
                this.clickType = clickType;
                this.isCancelled = false;
                Bukkit.getPluginManager().callEvent((org.bukkit.event.Event)this);
            }

            public Interact.ClickType getClickType() {
                return this.clickType;
            }

            public boolean isRightClick() {
                return this.clickType.equals((Object)Interact.ClickType.RIGHT_CLICK);
            }

            public boolean isLeftClick() {
                return this.clickType.equals((Object)Interact.ClickType.LEFT_CLICK);
            }

            public boolean isCancelled() {
                return this.isCancelled;
            }

            public void setCancelled(boolean arg) {
                this.isCancelled = arg;
            }
        }

        public static class Hide
        extends Event.Player
        implements Cancellable {
            private boolean isCancelled = false;

            protected Hide(Player player, Personal npc) {
                super(player, npc);
                Bukkit.getPluginManager().callEvent((org.bukkit.event.Event)this);
            }

            public boolean isCancelled() {
                return this.isCancelled;
            }

            public void setCancelled(boolean arg) {
                this.isCancelled = arg;
            }
        }

        public static class FinishMove
        extends Event {
            private final Location start;
            private final Location end;
            private final int taskID;
            private final Move.Task.CancelCause cancelCause;

            protected FinishMove(NPC npc, Location start, Location end, int taskID, Move.Task.CancelCause cancelCause) {
                super(npc);
                this.start = start;
                this.end = end;
                this.taskID = taskID;
                this.cancelCause = cancelCause;
                Bukkit.getPluginManager().callEvent((org.bukkit.event.Event)this);
            }

            public Location getStart() {
                return this.start;
            }

            public Location getEnd() {
                return this.end;
            }

            public int getTaskID() {
                return this.taskID;
            }

            public Move.Task.CancelCause getCancelCause() {
                return this.cancelCause;
            }
        }

        protected static abstract class Event
        extends org.bukkit.event.Event {
            private static final HandlerList HANDLERS_LIST = new HandlerList();
            private final NPC npc;

            protected Event(NPC npc) {
                this.npc = npc;
            }

            public NPC getNPC() {
                return this.npc;
            }

            public HandlerList getHandlers() {
                return HANDLERS_LIST;
            }

            public static HandlerList getHandlerList() {
                return HANDLERS_LIST;
            }

            protected static abstract class Player
            extends Event {
                private final org.bukkit.entity.Player player;

                protected Player(org.bukkit.entity.Player player, Personal npc) {
                    super(npc);
                    this.player = player;
                }

                @Override
                public Personal getNPC() {
                    return (Personal)super.getNPC();
                }

                public org.bukkit.entity.Player getPlayer() {
                    return this.player;
                }
            }
        }
    }

    public static class Global
    extends NPC {
        private static final Integer LOOK_TICKS = 2;
        protected final HashMap<Player, Personal> players;
        private final HashMap<UUID, Attributes> customAttributes;
        private Visibility visibility;
        private Predicate<Player> visibilityRequirement;
        private Entity nearestEntity;
        private Entity nearestPlayer;
        private Long lastNearestEntityUpdate;
        private Long lastNearestPlayerUpdate;
        private boolean autoCreate;
        private boolean autoShow;
        private boolean ownPlayerSkin;
        private boolean resetCustomAttributes;
        private List<String> selectedPlayers;
        protected boolean persistent;
        protected PersistentManager persistentManager;

        protected Global(@Nonnull NPCLib.PluginManager pluginManager, @Nonnull NPCLib.Registry.ID id, @Nonnull Visibility visibility, @Nullable Predicate<Player> visibilityRequirement, @Nonnull World world, double x, double y, double z, float yaw, float pitch) {
            super(pluginManager, id, world, x, y, z, yaw, pitch);
            Validate.notNull((Object)((Object)visibility), (String)"Cannot generate Global NPC instance, Visibility cannot be null.");
            this.players = new HashMap();
            this.customAttributes = new HashMap();
            this.visibility = visibility;
            this.visibilityRequirement = visibilityRequirement;
            this.autoCreate = true;
            this.autoShow = true;
            this.resetCustomAttributes = false;
            this.persistent = false;
            this.selectedPlayers = new ArrayList<String>();
            this.np(null);
            this.ne(null);
            this.checkVisiblePlayers();
            this.getNPCLib().globalNPCs.set(id, this);
        }

        protected Global(@Nonnull NPCLib.PluginManager pluginManager, @Nonnull NPCLib.Registry.ID id, @Nonnull Visibility visibility, @Nullable Predicate<Player> visibilityRequirement, @Nonnull Location location) {
            this(pluginManager, id, visibility, visibilityRequirement, location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        }

        public void setVisibility(Visibility visibility) {
            if (this.visibility.equals((Object)visibility)) {
                return;
            }
            this.visibility = visibility;
            this.checkVisiblePlayers();
        }

        public void setVisibilityRequirement(Predicate<Player> visibilityRequirement) {
            this.visibilityRequirement = visibilityRequirement;
            this.checkVisiblePlayers();
        }

        private void checkVisiblePlayers() {
            HashSet<Player> playerSet = new HashSet<Player>();
            playerSet.addAll(this.players.keySet());
            playerSet.stream().filter(x -> !this.meetsVisibilityRequirement((Player)x)).forEach(x -> this.removePlayer((Player)x));
            if (this.visibility.equals((Object)Visibility.EVERYONE)) {
                this.addPlayers(Bukkit.getOnlinePlayers());
            } else if (this.visibility.equals((Object)Visibility.SELECTED_PLAYERS)) {
                Bukkit.getOnlinePlayers().stream().filter(x -> !this.players.containsKey(x) && this.selectedPlayers.contains(x.getName())).forEach(x -> this.addPlayer((Player)x));
            }
        }

        public Visibility getVisibility() {
            return this.visibility;
        }

        public boolean meetsVisibilityRequirement(@Nonnull Player player) {
            Validate.notNull((Object)player, (String)"Cannot verify a null Player");
            if (this.visibilityRequirement == null) {
                return true;
            }
            return this.visibilityRequirement.test(player);
        }

        public void addPlayers(@Nonnull Collection<Player> players) {
            this.addPlayers(players, false);
        }

        public void addPlayers(@Nonnull Collection<Player> players, boolean ignoreVisibilityRequirement) {
            Validate.notNull(players, (String)"Cannot add a null collection of Players");
            players.forEach(x -> this.addPlayer((Player)x, ignoreVisibilityRequirement));
        }

        public void addPlayer(@Nonnull Player player) {
            this.addPlayer(player, false);
        }

        public void addPlayer(@Nonnull Player player, boolean ignoreVisibilityRequirement) {
            Validate.notNull((Object)player, (String)"Cannot add a null Player");
            if (this.players.containsKey(player)) {
                return;
            }
            if (!ignoreVisibilityRequirement && !this.meetsVisibilityRequirement(player)) {
                return;
            }
            Personal personal = this.pluginManager.generatePlayerPersonalNPC(player, NPCLib.Registry.ID.of(this.getPlugin(), "global_" + this.getID().getSimpleID()), this.getLocation());
            personal.global = this;
            personal.globalPendingUpdates = new Updatable.PendingUpdates<Global>(this);
            this.players.put(player, personal);
            if (!this.selectedPlayers.contains(player.getName())) {
                this.selectedPlayers.add(player.getName());
            }
            if (!this.customAttributes.containsKey(player.getUniqueId())) {
                this.customAttributes.put(player.getUniqueId(), new Attributes());
            }
            this.synchronizeGlobalAttributes(player);
            if (this.autoCreate) {
                personal.create();
            }
            if (this.autoCreate && this.autoShow) {
                personal.show();
            }
        }

        public void removePlayers(@Nonnull Collection<Player> players) {
            Validate.notNull(players, (String)"Cannot remove a null collection of Players");
            players.forEach(x -> this.removePlayer((Player)x));
        }

        public PersistentManager getPersistentManager() {
            return this.persistentManager;
        }

        public void removePlayer(@Nonnull Player player) {
            Validate.notNull((Object)player, (String)"Cannot remove a null Player");
            if (!this.players.containsKey(player)) {
                return;
            }
            Personal personal = this.getPersonal(player);
            if (this.resetCustomAttributes) {
                this.customAttributes.remove(player.getUniqueId());
            }
            if (this.selectedPlayers.contains(player.getName())) {
                this.selectedPlayers.remove(player.getName());
            }
            this.players.remove(player);
            this.getNPCLib().removePersonalNPC(personal);
        }

        protected void forEachActivePlayer(BiConsumer<Player, Personal> action) {
            for (Map.Entry<Player, Personal> entry : this.players.entrySet()) {
                if (!this.isActive(entry.getKey())) continue;
                action.accept(entry.getKey(), entry.getValue());
            }
        }

        public boolean hasPlayer(@Nonnull Player player) {
            Validate.notNull((Object)player, (String)"Cannot verify a null Player");
            return this.players.containsKey(player);
        }

        public List<String> getSelectedPlayers() {
            return this.selectedPlayers;
        }

        public void addSelectedPlayer(String playerName) {
            if (!StringUtils.containsIgnoreCase(this.selectedPlayers, playerName)) {
                this.selectedPlayers.add(playerName);
            }
        }

        public void removeSelectedPlayer(String playerName) {
            if (StringUtils.containsIgnoreCase(this.selectedPlayers, playerName)) {
                this.selectedPlayers.remove(playerName);
            }
        }

        public boolean hasSelectedPlayer(String playerName) {
            return StringUtils.containsIgnoreCase(this.selectedPlayers, playerName);
        }

        public boolean hasPendingUpdates(Player player) {
            if (!this.hasPlayer(player)) {
                return false;
            }
            return this.getPersonal((Player)player).globalPendingUpdates.hasPending();
        }

        public void update(Player player) {
            if (!this.hasPlayer(player)) {
                return;
            }
            this.getPersonal((Player)player).globalPendingUpdates.update();
        }

        public Set<Player> getPlayers() {
            return this.players.keySet();
        }

        public Predicate<Player> getVisibilityRequirement() {
            return this.visibilityRequirement;
        }

        public boolean hasVisibilityRequirement() {
            return this.visibilityRequirement != null;
        }

        protected boolean isActive(Player player) {
            if (!player.isOnline()) {
                return false;
            }
            if (!this.hasPlayer(player)) {
                return false;
            }
            Personal personal = this.getPersonal(player);
            return personal.isCreated();
        }

        public void create(@Nonnull Player player) {
            Validate.notNull((Object)player, (String)"Player cannot be null");
            this.synchronizeGlobalAttributes(player);
            this.getPersonal(player).create();
        }

        public void show(@Nonnull Player player) {
            Validate.notNull((Object)player, (String)"Player cannot be null");
            this.getPersonal(player).show();
        }

        public void hide(@Nonnull Player player) {
            Validate.notNull((Object)player, (String)"Player cannot be null");
            this.getPersonal(player).hide();
        }

        public void simpleUpdate(@Nonnull Player player) {
            Validate.notNull((Object)player, (String)"Player cannot be null");
            this.synchronizeGlobalAttributes(player);
            this.getPersonal(player).simpleUpdate();
        }

        public void forceUpdate(@Nonnull Player player) {
            Validate.notNull((Object)player, (String)"Player cannot be null");
            this.synchronizeGlobalAttributes(player);
            this.getPersonal(player).forceUpdate();
        }

        public void simpleUpdateText(@Nonnull Player player) {
            Validate.notNull((Object)player, (String)"Player cannot be null");
            this.synchronizeGlobalAttributes(player);
            this.getPersonal(player).simpleUpdateText();
        }

        public void forceUpdateText(@Nonnull Player player) {
            Validate.notNull((Object)player, (String)"Player cannot be null");
            this.synchronizeGlobalAttributes(player);
            this.getPersonal(player).forceUpdateText();
        }

        protected Updatable needUpdate(Player player, Updatable.Type type) {
            return switch (type) {
                case Updatable.Type.NONE -> this.noNeedUpdate(player);
                case Updatable.Type.SIMPLE_UPDATE -> this.needSimpleUpdate(player);
                case Updatable.Type.FORCE_UPDATE -> this.needForceUpdate(player);
                case Updatable.Type.SIMPLE_UPDATE_TEXT -> this.needSimpleUpdateText(player);
                case Updatable.Type.FORCE_UPDATE_TEXT -> this.needForceUpdateText(player);
                case Updatable.Type.SYNCHRONIZE_GLOBAL_ATTRIBUTES -> this.needSynchronizeGlobalAttributes(player);
                default -> throw new IncompatibleClassChangeError();
            };
        }

        protected Updatable noNeedUpdate(Player player) {
            return new Updatable.PerPlayer();
        }

        protected Updatable needSimpleUpdate(Player player) {
            return new Updatable.PerPlayer(this, Updatable.Type.SIMPLE_UPDATE, player);
        }

        protected Updatable needForceUpdate(Player player) {
            return new Updatable.PerPlayer(this, Updatable.Type.FORCE_UPDATE, player);
        }

        protected Updatable needSimpleUpdateText(Player player) {
            return new Updatable.PerPlayer(this, Updatable.Type.SIMPLE_UPDATE_TEXT, player);
        }

        protected Updatable needForceUpdateText(Player player) {
            return new Updatable.PerPlayer(this, Updatable.Type.FORCE_UPDATE_TEXT, player);
        }

        protected Updatable needSimpleUpdateOrForce(Player player, boolean forceUpdate) {
            return forceUpdate ? this.needForceUpdate(player) : this.needSimpleUpdate(player);
        }

        protected Updatable needSimpleUpdateTextOrForce(Player player, boolean forceUpdate) {
            return forceUpdate ? this.needForceUpdateText(player) : this.needSimpleUpdateText(player);
        }

        protected Updatable needSynchronizeGlobalAttributes(Player player) {
            return new Updatable.PerPlayer(this, Updatable.Type.SYNCHRONIZE_GLOBAL_ATTRIBUTES, player);
        }

        public void destroy(@Nonnull Player player) {
            Validate.notNull((Object)player, (String)"Player cannot be null");
            this.getPersonal(player).destroy();
        }

        public boolean isAutoCreate() {
            return this.autoCreate;
        }

        public void setAutoCreate(boolean autoCreate) {
            this.autoCreate = autoCreate;
        }

        public boolean isAutoShow() {
            return this.autoShow;
        }

        public void setAutoShow(boolean autoShow) {
            this.autoShow = autoShow;
        }

        public boolean isPersistent() {
            return this.persistent;
        }

        public boolean canBePersistent() {
            return this.getPlugin().equals((Object)PlayerNPCPlugin.getInstance());
        }

        public void setPersistent(boolean persistent) {
            Validate.isTrue((boolean)this.canBePersistent(), (String)"This NPC cannot be persistent because is not created by PlayerNPC plugin.");
            if (persistent == this.persistent) {
                return;
            }
            this.persistent = persistent;
            if (persistent) {
                this.persistentManager = PersistentManager.getPersistent(this.getPlugin(), this.getID().getSimpleID());
                PersistentManager.getPersistent(this.getPlugin(), this.getID().getSimpleID()).save();
            } else {
                PersistentManager.getPersistent(this.getPlugin(), this.getID().getSimpleID()).remove();
            }
        }

        public List<String> getCustomText(Player player) {
            return this.getCustomAttributes(player).getText();
        }

        public boolean hasCustomText(Player player) {
            return this.getCustomAttributes((Player)player).text != null;
        }

        public Updatable setCustomText(Player player, List<String> lines) {
            Attributes customAttributes = this.getCustomAttributes(player);
            List<String> previous = customAttributes.text != null ? customAttributes.getText() : this.attributes.getText();
            customAttributes.setText(lines);
            return this.needSimpleUpdateTextOrForce(player, previous.size() != customAttributes.getText().size());
        }

        public Updatable resetCustomText(Player player) {
            Attributes customAttributes = this.getCustomAttributes(player);
            List<String> previous = customAttributes.text != null ? customAttributes.getText() : this.attributes.getText();
            customAttributes.text = null;
            return this.needSimpleUpdateTextOrForce(player, previous.size() != customAttributes.getText().size());
        }

        public org.bukkit.inventory.ItemStack getCustomTextItem(Player player) {
            return this.getCustomAttributes(player).getTextItem();
        }

        public boolean hasCustomTextItem(Player player) {
            return this.getCustomAttributes((Player)player).textItem != null;
        }

        public Updatable setCustomTextItem(Player player, org.bukkit.inventory.ItemStack item) {
            return this.needUpdate(player, this.getCustomAttributes(player).setTextItem(item));
        }

        public Updatable resetCustomTextItem(Player player) {
            this.getCustomAttributes((Player)player).textItem = null;
            return this.needForceUpdateText(player);
        }

        public boolean isCustomTextItemGlowing(Player player) {
            return this.getCustomAttributes(player).isTextItemGlowing();
        }

        public boolean hasCustomTextItemGlowing(Player player) {
            return this.getCustomAttributes((Player)player).textItemGlowing != null;
        }

        public Updatable setCustomTextItemGlowing(Player player, boolean glowing) {
            return this.needUpdate(player, this.getCustomAttributes(player).setTextItemGlowing(glowing));
        }

        public Updatable resetCustomTextItemGlowing(Player player) {
            this.getCustomAttributes((Player)player).textItemGlowing = null;
            return this.needSimpleUpdateText(player);
        }

        public Updatable setCustomTextItemGlowingColor(Player player, Color color) {
            return this.needUpdate(player, this.getCustomAttributes(player).setTextItemGlowingColor(color));
        }

        public Updatable resetCustomTextItemGlowingColor(Player player) {
            this.getCustomAttributes((Player)player).textItemGlowingColor = null;
            return this.needSimpleUpdateText(player);
        }

        public Updatable setCustomSkin(Player player, Skin skin) {
            return this.needUpdate(player, this.getCustomAttributes(player).setSkin(skin));
        }

        public Updatable resetCustomSkin(Player player) {
            this.getCustomAttributes((Player)player).skin = null;
            return this.needForceUpdate(player);
        }

        public Updatable setCustomCollidable(Player player, boolean collidable) {
            return this.needUpdate(player, this.getCustomAttributes(player).setCollidable(collidable));
        }

        public Updatable resetCustomCollidable(Player player) {
            this.getCustomAttributes((Player)player).collidable = null;
            return this.needSimpleUpdate(player);
        }

        public Updatable setCustomHideDistance(Player player, double hideDistance) {
            this.getCustomAttributes(player).setHideDistance(hideDistance);
            return this.needSynchronizeGlobalAttributes(player);
        }

        public Updatable resetCustomHideDistance(Player player) {
            this.getCustomAttributes((Player)player).hideDistance = null;
            return this.needSynchronizeGlobalAttributes(player);
        }

        public Updatable setCustomGlowing(Player player, boolean glowing) {
            return this.needUpdate(player, this.getCustomAttributes(player).setGlowing(glowing));
        }

        public Updatable resetCustomGlowing(Player player) {
            this.getCustomAttributes((Player)player).glowing = null;
            return this.needSimpleUpdate(player);
        }

        public Updatable setCustomGlowingColor(Player player, Color color) {
            return this.needUpdate(player, this.getCustomAttributes(player).setGlowingColor(color));
        }

        public Updatable resetCustomGlowingColor(Player player) {
            this.getCustomAttributes((Player)player).glowingColor = null;
            return this.needSimpleUpdate(player);
        }

        public Updatable setCustomGazeTrackingType(Player player, GazeTrackingType followLookType) {
            this.getCustomAttributes(player).setGazeTrackingType(followLookType);
            return this.needSynchronizeGlobalAttributes(player);
        }

        public Updatable resetCustomGazeTrackingType(Player player) {
            this.getCustomAttributes((Player)player).gazeTrackingType = null;
            return this.needSynchronizeGlobalAttributes(player);
        }

        public Updatable setCustomNameTag(Player player, NameTag nameTag) {
            return this.needUpdate(player, this.getCustomAttributes(player).setNameTag(nameTag));
        }

        public Updatable resetCustomNameTag(Player player) {
            this.getCustomAttributes((Player)player).nameTag = null;
            return this.needForceUpdate(player);
        }

        public Updatable setCustomTabListVisibility(Player player, TabListVisibility tabListVisibility) {
            return this.needUpdate(player, this.getCustomAttributes(player).setTabListVisibility(tabListVisibility));
        }

        public Updatable resetCustomTabListVisibility(Player player) {
            this.getCustomAttributes((Player)player).tabListVisibility = null;
            return this.needForceUpdate(player);
        }

        public Updatable setCustomPose(Player player, Pose pose) {
            return this.needUpdate(player, this.getCustomAttributes(player).setPose(pose));
        }

        public Updatable resetCustomPose(Player player) {
            this.getCustomAttributes((Player)player).pose = null;
            return this.needSimpleUpdate(player);
        }

        public Updatable setCustomLineSpacing(Player player, double lineSpacing) {
            return this.needUpdate(player, this.getCustomAttributes(player).setTextLineSpacing(lineSpacing));
        }

        public Updatable resetCustomLineSpacing(Player player) {
            this.getCustomAttributes((Player)player).textLineSpacing = null;
            return this.needForceUpdateText(player);
        }

        public Updatable setCustomTextAlignment(Player player, Vector alignment) {
            return this.needUpdate(player, this.getCustomAttributes(player).setTextAlignment(alignment.clone()));
        }

        public Updatable resetCustomTextAlignment(Player player) {
            this.getCustomAttributes((Player)player).textAlignment = null;
            return this.needForceUpdateText(player);
        }

        public Updatable setCustomInteractCooldown(Player player, long millis) {
            this.getCustomAttributes(player).setInteractCooldown(millis);
            return this.needSynchronizeGlobalAttributes(player);
        }

        public Updatable resetCustomInteractCooldown(Player player) {
            this.getCustomAttributes((Player)player).interactCooldown = null;
            return this.needSynchronizeGlobalAttributes(player);
        }

        public Updatable setCustomTextOpacity(Player player, Hologram.Opacity opacity) {
            return this.needUpdate(player, this.getCustomAttributes(player).setTextOpacity(opacity));
        }

        public Updatable resetCustomTextOpacity(Player player) {
            this.getCustomAttributes((Player)player).textOpacity = null;
            return this.needForceUpdateText();
        }

        public Updatable setCustomMoveSpeed(Player player, double moveSpeed) {
            this.getCustomAttributes(player).setMoveSpeed(moveSpeed);
            return this.needSynchronizeGlobalAttributes(player);
        }

        public Updatable resetCustomMoveSpeed(Player player) {
            this.getCustomAttributes((Player)player).moveSpeed = null;
            return this.needSynchronizeGlobalAttributes(player);
        }

        public Updatable setCustomOnFire(Player player, boolean onFire) {
            return this.needUpdate(player, this.getCustomAttributes(player).setOnFire(onFire));
        }

        public Updatable resetCustomOnFire(Player player) {
            this.getCustomAttributes((Player)player).onFire = null;
            return this.needSimpleUpdate(player);
        }

        public Updatable setCustomPotionParticlesColor(Player player, java.awt.Color color) {
            this.getCustomAttributes(player).setPotionParticlesColor(color);
            return this.needSimpleUpdate(player);
        }

        public Updatable resetCustomPotionParticlesColor(Player player) {
            this.getCustomAttributes((Player)player).potionParticlesColor = null;
            return this.needSimpleUpdate(player);
        }

        public Updatable setCustomPotionParticlesType(Player player, PotionParticlesType type) {
            this.getCustomAttributes(player).setPotionParticlesType(type);
            return this.needSimpleUpdate(player);
        }

        public Updatable resetCustomPotionParticlesType(Player player) {
            this.getCustomAttributes((Player)player).potionParticlesType = null;
            return this.needSimpleUpdate(player);
        }

        public Updatable setCustomGroundParticles(Player player, boolean groundParticles) {
            this.getCustomAttributes(player).setGroundParticles(groundParticles);
            return this.needSimpleUpdate(player);
        }

        public Updatable resetCustomGroundParticles(Player player) {
            this.getCustomAttributes((Player)player).groundParticles = null;
            return this.needSimpleUpdate(player);
        }

        public Updatable setCustomInvisible(Player player, boolean invisible) {
            this.getCustomAttributes(player).setInvisible(invisible);
            return this.needSimpleUpdate(player);
        }

        public Updatable resetCustomInvisible(Player player) {
            this.getCustomAttributes((Player)player).invisible = null;
            return this.needSimpleUpdate(player);
        }

        public Updatable resetAllCustomAttributes(Player player) {
            this.customAttributes.put(player.getUniqueId(), new Attributes());
            return this.needForceUpdate(player);
        }

        public boolean isResetCustomAttributesWhenRemovePlayer() {
            return this.resetCustomAttributes;
        }

        public void setResetCustomAttributesWhenRemovePlayer(boolean resetCustomAttributes) {
            this.resetCustomAttributes = resetCustomAttributes;
        }

        private void syncrhonizeGlobalAttributes() {
            this.forEachActivePlayer((player, personal) -> this.synchronizeGlobalAttributes((Player)player));
        }

        private void synchronizeGlobalAttributes(Player player) {
            Personal personal = this.getPersonal(player);
            Attributes A = this.getAttributes();
            Attributes cA = this.getCustomAttributes(player);
            personal.updateGlobalLocation();
            if (this.ownPlayerSkin) {
                Skin.SignedTexture playerSignedTexture = Skin.Minecraft.grabSkinGameProfile(player).orElse(Skin.Minecraft.getSteveSkin().getSignedTexture());
                Skin.SignedTexture npcSignedTexture = personal.getSkin().getTextureData().getSignedTexture();
                if (npcSignedTexture == null || !playerSignedTexture.equals(npcSignedTexture)) {
                    personal.setSkin(playerSignedTexture);
                }
            } else {
                personal.setSkin(cA.skin != null ? cA.skin : A.skin);
            }
            personal.setSkinVisibleLayers(cA.skinVisibleLayers != null ? cA.skinVisibleLayers : A.skinVisibleLayers);
            personal.setTabListName(cA.tabListName != null ? cA.tabListName : A.tabListName);
            personal.setNameTag(cA.nameTag != null ? cA.nameTag : A.nameTag.clone());
            personal.setTabListVisibility(cA.tabListVisibility != null ? cA.tabListVisibility : A.tabListVisibility);
            personal.setShowNameTag(cA.showNameTag != null ? cA.showNameTag : A.showNameTag);
            personal.setText(cA.text != null ? cA.text : A.text);
            personal.setTextHideDistance(cA.textHideDistance != null ? cA.textHideDistance : A.textHideDistance);
            personal.setTextLineSpacing(cA.textLineSpacing != null ? cA.textLineSpacing : A.textLineSpacing);
            personal.setTextAlignment((cA.textAlignment != null ? cA.textAlignment : A.textAlignment).clone());
            personal.setTextOpacity(cA.textOpacity != null ? cA.textOpacity : A.textOpacity);
            personal.setTextLinesOpacity((HashMap)(cA.textLinesOpacity != null ? cA.textLinesOpacity : A.textLinesOpacity).clone());
            personal.setTextItem((cA.textItem != null ? cA.textItem : A.textItem).clone());
            personal.setTextItemGlowing(cA.textItemGlowing != null ? cA.textItemGlowing : A.textItemGlowing);
            personal.setTextItemGlowingColor(cA.textItemGlowingColor != null ? cA.textItemGlowingColor : A.textItemGlowingColor);
            personal.setEquipment((HashMap)(cA.equipment != null ? cA.equipment : A.equipment).clone());
            personal.setCollidable(cA.collidable != null ? cA.collidable : A.collidable);
            personal.setHideDistance(cA.hideDistance != null ? cA.hideDistance : A.hideDistance);
            personal.setGazeTrackingType(cA.gazeTrackingType != null ? cA.gazeTrackingType : A.gazeTrackingType);
            personal.setGlowing(cA.glowing != null ? cA.glowing : A.glowing);
            personal.setGlowingColor(cA.glowingColor != null ? cA.glowingColor : A.glowingColor);
            personal.setPose(cA.pose != null ? cA.pose : A.pose);
            personal.setOnFire(cA.onFire != null ? cA.onFire : A.onFire);
            personal.setGroundParticles(cA.groundParticles != null ? cA.groundParticles : A.groundParticles);
            personal.setPotionParticlesColor(cA.potionParticlesColor != null ? cA.potionParticlesColor : A.potionParticlesColor);
            personal.setPotionParticlesType(cA.potionParticlesType != null ? cA.potionParticlesType : A.potionParticlesType);
            personal.setArrowsInBody(cA.arrowsInBody != null ? cA.arrowsInBody : A.arrowsInBody);
            personal.setBeeStingersInBody(cA.beeStingersInBody != null ? cA.beeStingersInBody : A.beeStingersInBody);
            personal.setShaking(cA.shaking != null ? cA.shaking : A.shaking);
            personal.setInvisible(cA.invisible != null ? cA.invisible : A.invisible);
            personal.setInteractCooldown(cA.interactCooldown != null ? cA.interactCooldown : A.interactCooldown);
            personal.setMoveSpeed(cA.moveSpeed != null ? cA.moveSpeed : A.moveSpeed);
            personal.globalPendingUpdates.onExecute(Updatable.Type.SYNCHRONIZE_GLOBAL_ATTRIBUTES);
        }

        public void createAllPlayers() {
            this.players.forEach((player, npc) -> {
                if (!npc.isCreated()) {
                    this.create((Player)player);
                }
            });
        }

        public void show() {
            this.forEachActivePlayer((player, npc) -> this.show((Player)player));
        }

        public void hide() {
            this.forEachActivePlayer((player, npc) -> this.hide((Player)player));
        }

        @Override
        public void simpleUpdate() {
            this.forEachActivePlayer((player, npc) -> this.simpleUpdate((Player)player));
            this.pendingUpdates.onExecute(Updatable.Type.SIMPLE_UPDATE);
        }

        @Override
        public void forceUpdate() {
            this.forEachActivePlayer((player, npc) -> this.forceUpdate((Player)player));
            this.pendingUpdates.onExecute(Updatable.Type.FORCE_UPDATE);
        }

        @Override
        public void simpleUpdateText() {
            this.forEachActivePlayer((player, npc) -> this.simpleUpdateText((Player)player));
            this.pendingUpdates.onExecute(Updatable.Type.SIMPLE_UPDATE_TEXT);
        }

        @Override
        public void forceUpdateText() {
            this.forEachActivePlayer((player, npc) -> this.forceUpdateText((Player)player));
            this.pendingUpdates.onExecute(Updatable.Type.FORCE_UPDATE_TEXT);
        }

        @Override
        public void destroy() {
            HashSet<Player> playerSet = new HashSet<Player>();
            playerSet.addAll(this.players.keySet());
            playerSet.forEach(player -> this.getNPCLib().removePersonalNPC(this.getPersonal((Player)player)));
        }

        @Override
        public void teleport(World world, double x, double y, double z, float yaw, float pitch) {
            Events.Teleport npcTeleportEvent = new Events.Teleport(this, new Location(world, x, y, z, yaw, pitch));
            if (npcTeleportEvent.isCancelled()) {
                return;
            }
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = Float.valueOf(yaw);
            this.pitch = Float.valueOf(pitch);
            this.forEachActivePlayer((player, npc) -> npc.teleport(world, x, y, z, yaw, pitch));
        }

        @Override
        public Updatable lookAt(float yaw, float pitch) {
            this.yaw = Float.valueOf(yaw);
            this.pitch = Float.valueOf(pitch);
            this.forEachActivePlayer((player, npc) -> npc.lookAt(yaw, pitch));
            return this.needSimpleUpdate();
        }

        @Override
        public void playAnimation(Animation animation) {
            this.forEachActivePlayer((player, npc) -> this.playAnimation((Player)player, animation));
        }

        @Override
        public <T> void playParticle(Particle particle, Vector regarding, Vector offset, int count, double speed, @Nullable T data) {
            this.forEachActivePlayer((player, npc) -> this.playParticle(particle, regarding, offset, count, speed, data));
        }

        public <T> void playParticle(Player player, Particle particle, Vector regarding, Vector offset, int count, double speed, @Nullable T data) {
            this.getPersonal(player).playParticle(particle, regarding, offset, count, speed, data);
        }

        public void playParticle(Player player, Particle particle, Vector regarding, Vector offset, int count, double speed) {
            this.playParticle(player, particle, regarding, offset, count, speed, null);
        }

        public void playAnimation(Player player, Animation animation) {
            this.getPersonal(player).playAnimation(animation);
        }

        @Override
        public void hit() {
            this.playAnimation(Animation.TAKE_DAMAGE);
            this.forEachActivePlayer((player, npc) -> player.playSound(this.getLocation(), Sound.ENTITY_PLAYER_ATTACK_WEAK, 1.0f, 1.0f));
        }

        @Override
        protected void move(double moveX, double moveY, double moveZ) {
            Validate.isTrue((Math.abs(moveX) < 8.0 && Math.abs(moveY) < 8.0 && Math.abs(moveZ) < 8.0 ? 1 : 0) != 0, (String)"NPC cannot move 8 blocks or more at once, use teleport instead");
            Events.Move npcMoveEvent = new Events.Move(this, new Location(this.world, this.x + moveX, this.y + moveY, this.z + moveZ));
            if (npcMoveEvent.isCancelled()) {
                return;
            }
            this.x = this.x + moveX;
            this.y = this.y + moveY;
            this.z = this.z + moveZ;
            this.forEachActivePlayer((player, npc) -> npc.move(moveX, moveY, moveZ));
        }

        @Override
        protected void updatePlayerRotation() {
            this.forEachActivePlayer((player, npc) -> this.updatePlayerRotation((Player)player));
        }

        protected void updatePlayerRotation(Player player) {
            this.getPersonal(player).updatePlayerRotation();
        }

        @Override
        protected void updateLocation() {
            this.forEachActivePlayer((player, npc) -> npc.updateLocation());
        }

        @Override
        protected void updateMove() {
            this.forEachActivePlayer((player, npc) -> npc.updateMove());
        }

        public Item dropItem(org.bukkit.inventory.ItemStack itemStack) {
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
                return null;
            }
            return this.getWorld().dropItemNaturally(this.getLocation(), itemStack);
        }

        public Item dropItemInSlot(Slot slot) {
            org.bukkit.inventory.ItemStack itemStack = this.getEquipment(slot);
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
                return null;
            }
            this.clearEquipment(slot);
            Item item = this.dropItem(itemStack);
            this.simpleUpdate();
            return item;
        }

        public Item dropItemInHand() {
            return this.dropItemInSlot(Slot.MAINHAND);
        }

        public Updatable<Global> setOwnPlayerSkin(boolean ownPlayerSkin) {
            this.ownPlayerSkin = ownPlayerSkin;
            return this.needForceUpdate();
        }

        public Updatable<Global> setOwnPlayerSkin() {
            return this.setOwnPlayerSkin(true);
        }

        public boolean isOwnPlayerSkin() {
            return this.ownPlayerSkin;
        }

        @Deprecated
        public Personal getPersonal(Player player) {
            Validate.isTrue((boolean)this.players.containsKey(player), (String)"Player is not added to this Global NPC");
            return this.players.get(player);
        }

        public Attributes getCustomAttributes(Player player) {
            Validate.isTrue((boolean)this.customAttributes.containsKey(player.getUniqueId()), (String)"Player is not added to this Global NPC");
            return this.customAttributes.get(player.getUniqueId());
        }

        protected void np(Entity entity) {
            this.nearestPlayer = entity;
            this.lastNearestPlayerUpdate = System.currentTimeMillis();
        }

        protected Entity np() {
            if (System.currentTimeMillis() - this.lastNearestPlayerUpdate > (long)(LOOK_TICKS * 50)) {
                this.nearestPlayer = null;
            }
            return this.nearestPlayer;
        }

        protected Entity ne() {
            if (System.currentTimeMillis() - this.lastNearestEntityUpdate > (long)(LOOK_TICKS * 50)) {
                this.nearestEntity = null;
            }
            return this.nearestEntity;
        }

        protected void ne(Entity entity) {
            this.nearestEntity = entity;
            this.lastNearestEntityUpdate = System.currentTimeMillis();
        }

        public static enum Visibility {
            EVERYONE,
            SELECTED_PLAYERS;

        }

        public static class PersistentManager {
            private static HashMap<Plugin, HashMap<String, PersistentManager>> PERSISTENT_DATA = new HashMap();
            private Plugin plugin;
            private String id;
            private Global global;
            private File file;
            private FileConfiguration config;
            private LastUpdate lastUpdate;

            protected static PersistentManager getPersistent(Plugin plugin, String id) {
                PersistentManager.checkExistPlugin(plugin);
                if (PERSISTENT_DATA.get(plugin).containsKey(id)) {
                    return PERSISTENT_DATA.get(plugin).get(id);
                }
                return new PersistentManager(plugin, id);
            }

            private static void setPersistentData(Plugin plugin, String id, PersistentManager globalPersistentData) {
                PersistentManager.checkExistPlugin(plugin);
                PERSISTENT_DATA.get(plugin).put(id, globalPersistentData);
            }

            private static void checkExistPlugin(Plugin plugin) {
                if (!PERSISTENT_DATA.containsKey(plugin)) {
                    PERSISTENT_DATA.put(plugin, new HashMap());
                }
            }

            protected static void forEachGlobalPersistent(Consumer<Global> action) {
                PERSISTENT_DATA.forEach((x, y) -> PersistentManager.forEachGlobalPersistent(x, action));
            }

            protected static void forEachGlobalPersistent(Plugin plugin, Consumer<Global> action) {
                if (!PERSISTENT_DATA.containsKey(plugin)) {
                    return;
                }
                PERSISTENT_DATA.get(plugin).values().stream().filter(x -> x.global != null).forEach(x -> action.accept(x.global));
            }

            protected static void forEachPersistentManager(Consumer<PersistentManager> action) {
                PERSISTENT_DATA.forEach((x, y) -> PersistentManager.forEachPersistentManager(x, action));
            }

            protected static void forEachPersistentManager(Plugin plugin, Consumer<PersistentManager> action) {
                if (!PERSISTENT_DATA.containsKey(plugin)) {
                    return;
                }
                PERSISTENT_DATA.get(plugin).values().stream().forEach(x -> action.accept((PersistentManager)x));
            }

            protected PersistentManager(Plugin plugin, String simpleID) {
                this.plugin = plugin;
                this.id = simpleID;
                this.file = new File(this.getFilePath());
                this.lastUpdate = new LastUpdate();
                PersistentManager.setPersistentData(plugin, this.id, this);
            }

            public void load() {
                ConfigurationSection nameTagSection;
                Object lines;
                if (this.global != null) {
                    NPCLib.getInstance().removeGlobalNPC(this.global);
                }
                if (!this.file.exists()) {
                    throw new IllegalArgumentException("Persistent NPC data file doesn't exists.");
                }
                this.config = YamlConfiguration.loadConfiguration((File)this.file);
                Location location = null;
                try {
                    location = this.config.getLocation("location");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (location == null) {
                    throw new IllegalArgumentException("There was an error loading NPC location.");
                }
                Visibility visibility = Visibility.EVERYONE;
                String visibilityPermission = null;
                if (this.config.contains("visibility.type")) {
                    visibility = Visibility.valueOf(this.config.getString("visibility.type"));
                }
                if (this.config.contains("visibility.requirement")) {
                    visibilityPermission = this.config.getString("visibility.requirement");
                }
                String finalVisibilityPermission = visibilityPermission == null || visibilityPermission.equals("none") ? null : visibilityPermission;
                this.global = NPCLib.getInstance().generateGlobalNPC(this.plugin, this.id, visibility, finalVisibilityPermission != null ? player -> player.hasPermission(finalVisibilityPermission) : null, location);
                this.global.persistent = true;
                this.global.persistentManager = this;
                if (this.config.contains("skin.custom.enabled") && this.config.getBoolean("skin.custom.enabled") && this.config.contains("skin.custom.texture") && this.config.contains("skin.custom.signature")) {
                    String texture = this.config.getString("skin.custom.texture");
                    String signature = this.config.getString("skin.custom.signature");
                    Object skinName = null;
                    if (this.config.contains("skin.custom.name")) {
                        this.config.getString("skin.custom.name");
                    }
                    if (signature.length() < 684 || texture.length() == 0) {
                        texture = Skin.Minecraft.STEVE.getTexture();
                        signature = Skin.Minecraft.STEVE.getSignature();
                        skinName = null;
                    }
                    this.global.setSkin(texture, signature);
                } else if (this.config.contains("skin.player")) {
                    this.global.setSkin(this.config.getString("skin.player"), skin -> this.global.forceUpdate());
                } else if (this.config.contains("skin.mineskin")) {
                    this.global.setMineSkin(this.config.getString("skin.mineskin"), mineSkin -> this.global.forceUpdate());
                }
                if (this.config.contains("hologram.text") && (lines = this.config.getStringList("hologram.text")) != null && lines.size() > 0) {
                    this.global.setText((List<String>)lines);
                }
                if (this.config.contains("hologram.textOpacity")) {
                    this.global.setTextOpacity(Hologram.Opacity.valueOf(this.config.getString("hologram.textOpacity")));
                }
                if (this.config.getConfigurationSection("hologram.linesOpacity") != null) {
                    for (String line : this.config.getConfigurationSection("hologram.linesOpacity").getKeys(false)) {
                        this.global.setTextLineOpacity(Integer.valueOf(line), Hologram.Opacity.valueOf(this.config.getString("hologram.linesOpacity." + line)));
                    }
                }
                if (this.config.contains("visibility.selectedPlayers") && this.global.getVisibility().equals((Object)Visibility.SELECTED_PLAYERS)) {
                    this.global.selectedPlayers = this.config.getStringList("visibility.selectedPlayers");
                }
                if (this.config.contains("hologram.alignment")) {
                    this.global.setTextAlignment(this.config.getVector("hologram.alignment"));
                }
                if (this.config.contains("skin.ownPlayer")) {
                    this.global.setOwnPlayerSkin(this.config.getBoolean("skin.ownPlayer"));
                }
                Arrays.stream(Skin.Layer.values()).filter(x -> this.config.contains("skin.visibleLayers." + x.name().toLowerCase())).forEach(x -> this.global.getSkinVisibleLayers().setVisibility((Skin.Layer)x, this.config.getBoolean("skin.visibleLayers." + x.name().toLowerCase())));
                if (this.config.contains("glow.color")) {
                    this.global.setGlowingColor((Color)Color.fromName(this.config.getString("glow.color")).orElse(null));
                }
                if (this.config.contains("glow.enabled")) {
                    this.global.setGlowing(this.config.getBoolean("glow.enabled"));
                }
                if (this.config.contains("pose")) {
                    this.global.setPose(Pose.valueOf(this.config.getString("pose")));
                }
                if (this.config.contains("collidable")) {
                    this.global.setCollidable(this.config.getBoolean("collidable"));
                }
                if ((nameTagSection = this.config.getConfigurationSection("nameTag")) != null) {
                    String prefix = null;
                    String name = null;
                    String suffix = null;
                    Object tabListName = null;
                    if (nameTagSection.contains("prefix") && !nameTagSection.getString("prefix").equals("")) {
                        prefix = nameTagSection.getString("prefix");
                    }
                    if (nameTagSection.contains("name") && !nameTagSection.getString("name").equals("")) {
                        name = nameTagSection.getString("name");
                    }
                    if (nameTagSection.contains("suffix") && !nameTagSection.getString("suffix").equals("")) {
                        suffix = nameTagSection.getString("suffix");
                    }
                    this.global.setNameTag(prefix, name, suffix);
                    if (nameTagSection.contains("showAbovePlayer")) {
                        this.global.setShowNameTag(nameTagSection.getBoolean("showAbovePlayer"));
                    }
                }
                if (this.config.contains("tabList.show")) {
                    if (this.config.isBoolean("tabList.show")) {
                        this.global.setShowOnTabList(this.config.getBoolean("tabList.show"));
                    } else {
                        this.global.setTabListVisibility(TabListVisibility.fromName(this.config.getString("tabList.show")).orElse(null));
                    }
                }
                if (this.config.contains("tabList.name")) {
                    this.global.setTabListName(this.config.getString("tabList.name").equals("") ? null : org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("tabList.name")));
                }
                if (this.config.contains("onFire")) {
                    this.global.setOnFire(this.config.getBoolean("onFire"));
                }
                if (this.config.contains("invisible")) {
                    this.global.setInvisible(this.config.getBoolean("invisible"));
                }
                if (this.config.contains("body.stuck.arrows")) {
                    this.global.setArrowsInBody(this.config.getInt("body.stuck.arrows"));
                }
                if (this.config.contains("body.stuck.bee_stingers")) {
                    this.global.setBeeStingersInBody(this.config.getInt("body.stuck.bee_stingers"));
                }
                if (this.config.contains("body.shaking")) {
                    this.global.setShaking(this.config.getBoolean("body.shaking"));
                }
                if (this.config.contains("move.speed")) {
                    this.global.setMoveSpeed(this.config.getDouble("move.speed"));
                }
                if (this.config.contains("interact.cooldown")) {
                    this.global.setInteractCooldown(this.config.getLong("interact.cooldown"));
                }
                if (this.config.contains("gazeTracking.type")) {
                    this.global.setGazeTrackingType(GazeTrackingType.valueOf(this.config.getString("gazeTracking.type")));
                }
                if (this.config.contains("distance.hide")) {
                    this.global.setHideDistance(this.config.getDouble("distance.hide"));
                }
                for (Slot slot : Slot.values()) {
                    if (!this.config.contains("slots." + slot.name().toLowerCase())) continue;
                    org.bukkit.inventory.ItemStack item = null;
                    try {
                        item = this.config.getItemStack("slots." + slot.name().toLowerCase());
                    }
                    catch (Exception e) {
                        this.config.set("slots." + slot.name().toLowerCase(), null);
                    }
                    this.global.setItem(slot, item);
                }
                Arrays.stream(Slot.values()).filter(x -> this.config.contains("slots." + x.name().toLowerCase())).forEach(x -> this.global.setItem((Slot)x, this.config.getItemStack("slots." + x.name().toLowerCase())));
                if (this.config.getConfigurationSection("customData") != null) {
                    for (String keys : this.config.getConfigurationSection("customData").getKeys(false)) {
                        this.global.setCustomData(NPCLib.Registry.ID.playerNPC(keys), this.config.getString("customData." + keys));
                    }
                }
                if (this.config.getConfigurationSection("interact.actions") != null) {
                    for (String keys : this.config.getConfigurationSection("interact.actions").getKeys(false)) {
                        try {
                            Interact.ClickAction clickAction = null;
                            Interact.Actions.Type actionType = null;
                            String stringType = this.config.getString("interact.actions." + keys + ".type");
                            try {
                                actionType = Interact.Actions.Type.valueOf(stringType);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (actionType == null) {
                                try {
                                    actionType = Interact.Actions.LegacyType.valueOf((String)stringType).type;
                                    Bukkit.getConsoleSender().sendMessage("\u00a78- \u00a7eLegacy click action " + stringType + " type was found. Fixing it...");
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            if (actionType == null) {
                                throw new IllegalArgumentException(stringType + " type of action is not valid.");
                            }
                            Interact.ClickType clickType = Interact.ClickType.valueOf(this.config.getString("interact.actions." + keys + ".click"));
                            if (actionType.equals(Interact.Actions.Type.PLAYER_SEND_CHAT_MESSAGE)) {
                                message = this.config.getStringList("interact.actions." + keys + ".messages");
                                String[] messages = new String[message.size()];
                                for (int i = 0; i < message.size(); ++i) {
                                    messages[i] = (String)message.get(i);
                                }
                                clickAction = this.global.addMessageClickAction(clickType, messages);
                            } else if (actionType.equals(Interact.Actions.Type.PLAYER_SEND_ACTIONBAR_MESSAGE)) {
                                message = this.config.getString("interact.actions." + keys + ".message");
                                clickAction = this.global.addActionBarMessageClickAction(clickType, (String)message);
                            } else if (actionType.equals(Interact.Actions.Type.PLAYER_CONNECT_BUNGEE_SERVER)) {
                                String server = this.config.getString("interact.actions." + keys + ".server");
                                clickAction = this.global.addConnectBungeeServerClickAction(clickType, server);
                            } else if (actionType.equals(Interact.Actions.Type.CONSOLE_PERFORM_COMMAND)) {
                                command = this.config.getString("interact.actions." + keys + ".command");
                                clickAction = this.global.addRunConsoleCommandClickAction(clickType, command);
                            } else if (actionType.equals(Interact.Actions.Type.PLAYER_PERFORM_COMMAND)) {
                                command = this.config.getString("interact.actions." + keys + ".command");
                                clickAction = this.global.addRunPlayerCommandClickAction(clickType, command);
                            } else if (actionType.equals(Interact.Actions.Type.PLAYER_SEND_TITLE_MESSAGE)) {
                                String title = this.config.getString("interact.actions." + keys + ".title");
                                String subtitle = this.config.getString("interact.actions." + keys + ".subtitle");
                                Integer fadeIn = this.config.getInt("interact.actions." + keys + ".fadeIn");
                                Integer stay = this.config.getInt("interact.actions." + keys + ".stay");
                                Integer fadeOut = this.config.getInt("interact.actions." + keys + ".fadeOut");
                                clickAction = this.global.addTitleMessageClickAction(clickType, title, subtitle, fadeIn, stay, fadeOut);
                            } else if (actionType.equals(Interact.Actions.Type.PLAYER_TELEPORT_TO_LOCATION)) {
                                Location location1 = this.config.getLocation("interact.actions." + keys + ".location");
                                clickAction = this.global.addTeleportToLocationClickAction(clickType, location1);
                            } else if (actionType.equals(Interact.Actions.Type.PLAYER_GIVE_ITEM)) {
                                itemStack = this.config.getItemStack("interact.actions." + keys + ".item");
                                clickAction = this.global.addGivePlayerItemClickAction(clickType, itemStack);
                            } else if (actionType.equals(Interact.Actions.Type.NPC_SET_CUSTOM_DATA)) {
                                String key = this.config.getString("interact.actions." + keys + ".key");
                                String value = this.config.getString("interact.actions." + keys + ".value");
                                Boolean checkIfSame = this.config.getBoolean("interact.actions." + keys + ".checkIfSame");
                                clickAction = this.global.addSetCustomDataClickAction(clickType, (Plugin)PlayerNPCPlugin.getInstance(), key, value);
                                ((Interact.Actions.SetCustomData)clickAction).setCheckIfSame(checkIfSame);
                            } else if (actionType.equals(Interact.Actions.Type.PLAYER_OPEN_BOOK)) {
                                itemStack = this.config.getItemStack("interact.actions." + keys + ".book");
                                clickAction = this.global.addOpenBookClickAction(clickType, itemStack);
                            } else if (actionType.equals(Interact.Actions.Type.PLAYER_OPEN_WORKBENCH)) {
                                clickAction = this.global.addOpenWorkbenchClickAction(clickType);
                            } else if (actionType.equals(Interact.Actions.Type.PLAYER_OPEN_ENCHANTING)) {
                                clickAction = this.global.addOpenEnchantingClickAction(clickType);
                            } else if (actionType.equals(Interact.Actions.Type.NPC_PLAY_ANIMATION)) {
                                Animation animation = Animation.valueOf(this.config.getString("interact.actions." + keys + ".animation"));
                                clickAction = this.global.addPlayAnimationClickAction(clickType, animation);
                            } else if (actionType.name().contains("_MONEY")) {
                                Double balance = this.config.getDouble("interact.actions." + keys + ".balance");
                                if (actionType.equals(Interact.Actions.Type.PLAYER_WITHDRAW_MONEY)) {
                                    clickAction = this.global.addPlayerWithdrawMoneyClickAction(clickType, balance);
                                }
                                if (actionType.equals(Interact.Actions.Type.PLAYER_GIVE_MONEY)) {
                                    clickAction = this.global.addPlayerGiveMoneyClickAction(clickType, balance);
                                }
                            }
                            Long delayTicks = this.config.getLong("interact.actions." + keys + ".delayTicks");
                            Long cooldownMilliseconds = this.config.getLong("interact.actions." + keys + ".cooldownMilliseconds");
                            Boolean enabled = this.config.contains("interact.actions." + keys + ".enabled") ? this.config.getBoolean("interact.actions." + keys + ".enabled") : true;
                            clickAction.setEnabled(enabled);
                            clickAction.setDelayTicks(delayTicks);
                            clickAction.setCooldownMilliseconds(cooldownMilliseconds);
                            if (this.config.getConfigurationSection("interact.actions." + keys + ".condition") == null) continue;
                            for (String keysS : this.config.getConfigurationSection("interact.actions." + keys + ".condition").getKeys(false)) {
                                clickAction.addCondition((Conditions.Condition)this.config.get("interact.actions." + keys + ".condition." + keysS));
                            }
                        }
                        catch (Exception e) {
                            NPCLib.DebugManager.printError(e);
                        }
                    }
                }
                if (this.config.contains("hologram.updateTicks")) {
                    this.global.setTextUpdateTicks(this.config.getInt("hologram.updateTicks"));
                }
                this.global.forceUpdate();
                this.lastUpdate.load();
                Bukkit.getConsoleSender().sendMessage(PlayerNPCPlugin.getInstance().getPrefix() + "\u00a77Persistent Global NPC \u00a7a" + this.global.getID().getFullID() + " \u00a77has been loaded.");
            }

            public void save() {
                if (this.global == null) {
                    this.global = NPCLib.getInstance().grabGlobalNPC(this.plugin, this.id).orElse(null);
                }
                if (this.global == null || !this.global.isPersistent()) {
                    return;
                }
                try {
                    this.checkFileExists();
                    if (this.config == null) {
                        this.config = YamlConfiguration.loadConfiguration((File)this.file);
                    }
                    if (this.config.contains("disableSaving") && this.config.getBoolean("disableSaving")) {
                        return;
                    }
                    NMSFileConfiguration.setHeader(this.config, Arrays.asList("Persistent Global NPC " + this.global.getID().getFullID()));
                    this.config.set("location", (Object)this.global.getLocation());
                    this.config.set("visibility.type", (Object)this.global.getVisibility().name());
                    NPCLib.Registry.ID visibilityRequirementKey = NPCLib.Registry.ID.playerNPC("visibilityrequirementpermission");
                    this.config.set("visibility.requirement", (Object)(this.global.getVisibilityRequirement() != null && this.global.getCustomDataKeysID().contains(visibilityRequirementKey) ? this.global.grabCustomData(visibilityRequirementKey).get() : "none"));
                    if (this.global.getVisibility().equals((Object)Visibility.SELECTED_PLAYERS)) {
                        this.config.set("visibility.selectedPlayers", this.global.selectedPlayers);
                    } else {
                        this.config.set("visibility.selectedPlayers", null);
                    }
                    this.config.set("skin.player", this.global.getSkin().getType().equals(Skin.Type.MINECRAFT) ? this.global.getSkin().getName() : null);
                    this.config.set("skin.mineskin", this.global.getSkin().getType().equals(Skin.Type.MINESKIN) ? ((Skin.MineSkin)this.global.getSkin()).getId() : null);
                    NMSFileConfiguration.setComments(this.config, "skin.mineskin", Arrays.asList(this.global.getSkin().getType().equals(Skin.Type.MINESKIN) ? this.global.getSkin().castMineSkin().getMineSkinURL() : null));
                    if (!this.config.contains("skin.custom")) {
                        this.config.set("skin.custom.enabled", (Object)false);
                        this.config.set("skin.custom.texture", (Object)"");
                        this.config.set("skin.custom.signature", (Object)"");
                        this.config.set("skin.custom.name", (Object)"");
                    }
                    if (this.global.getSkin().getType().equals(Skin.Type.CUSTOM)) {
                        Skin.Custom custom = this.global.getSkin().castCustomSkin();
                        this.config.set("skin.custom.enabled", (Object)true);
                        this.config.set("skin.custom.texture", (Object)custom.getTexture());
                        this.config.set("skin.custom.signature", (Object)custom.getSignature());
                        this.config.set("skin.custom.name", (Object)custom.getName());
                    } else {
                        this.config.set("skin.custom.enabled", (Object)false);
                    }
                    NMSFileConfiguration.setComments(this.config, "skin.custom.enabled", Arrays.asList("If you want to use a custom texture, set enabled as true, if not, it will use the player name skin.", "To easily get texture and signature use '/npclib getskininfo (type) (name)' or https://mineskin.org/"));
                    this.config.set("skin.ownPlayer", (Object)this.global.isOwnPlayerSkin());
                    Arrays.stream(Skin.Layer.values()).forEach(x -> this.config.set("skin.visibleLayers." + x.name().toLowerCase(), (Object)this.global.getSkinVisibleLayers().isVisible((Skin.Layer)x)));
                    this.config.set("customData", null);
                    for (NPCLib.Registry.ID keys : this.global.getCustomDataKeysID()) {
                        if (!keys.getPluginName().equals(PlayerNPCPlugin.getInstance().getName().toLowerCase())) continue;
                        this.config.set("customData." + keys.getSimpleID(), (Object)this.global.grabCustomData(keys).get());
                    }
                    List<String> lines = this.global.getText();
                    if (lines != null && lines.size() > 0) {
                        ArrayList coloredLines = new ArrayList();
                        lines.forEach(x -> coloredLines.add(x.replaceAll("\u00a7", "&")));
                        this.config.set("hologram.text", coloredLines);
                    } else {
                        this.config.set("hologram.text", lines);
                    }
                    this.config.set("hologram.lineSpacing", (Object)this.global.getTextLineSpacing());
                    this.config.set("hologram.textOpacity", (Object)this.global.getTextOpacity().name());
                    this.config.set("hologram.linesOpacity", null);
                    for (Integer line : this.global.getLinesOpacity().keySet()) {
                        this.config.set("hologram.linesOpacity." + line, (Object)this.global.getLineOpacity(line).name());
                    }
                    this.config.set("hologram.alignment", (Object)this.global.getTextAlignment());
                    this.config.set("hologram.updateTicks", (Object)this.global.getTextUpdateTicks());
                    this.config.set("gazeTracking.type", (Object)this.global.getGazeTrackingType().name());
                    this.config.set("pose", (Object)this.global.getPose().name());
                    this.config.set("collidable", (Object)this.global.isCollidable());
                    this.config.set("distance.hide", (Object)this.global.getHideDistance());
                    this.config.set("glow.enabled", (Object)this.global.isGlowing());
                    this.config.set("glow.color", (Object)this.global.getGlowingColor().name());
                    ConfigurationSection nameTagSection = this.config.getConfigurationSection("nameTag") != null ? this.config.getConfigurationSection("nameTag") : this.config.createSection("nameTag");
                    NameTag nameTag = this.global.getNameTag();
                    if (nameTag.grabPrefix().isPresent()) {
                        nameTagSection.set("prefix", (Object)this.global.getNameTag().grabPrefix().get().replaceAll("\u00a7", "&"));
                    } else {
                        nameTagSection.set("prefix", (Object)"");
                    }
                    nameTagSection.set("name", (Object)this.global.getNameTag().getName().replaceAll("\u00a7", "&"));
                    if (nameTag.grabSuffix().isPresent()) {
                        nameTagSection.set("suffix", (Object)this.global.getNameTag().grabSuffix().get().replaceAll("\u00a7", "&"));
                    } else {
                        nameTagSection.set("suffix", (Object)"");
                    }
                    nameTagSection.set("showAbovePlayer", (Object)this.global.isShowNameTag());
                    this.config.set("tabList.show", (Object)this.global.getTabListVisibility().name());
                    this.config.set("tabList.name", (Object)(this.global.getTabListName() != null ? this.global.getTabListName().replaceAll("\u00a7", "&") : ""));
                    this.config.set("move.speed", (Object)this.global.getMoveSpeed());
                    Arrays.stream(Slot.values()).forEach(x -> this.config.set("slots." + x.name().toLowerCase(), this.global.getEquipment((Slot)x) != null && !this.global.getEquipment((Slot)x).getType().isAir() ? this.global.getEquipment((Slot)x) : null));
                    this.config.set("onFire", (Object)this.global.isOnFire());
                    this.config.set("invisible", (Object)this.global.isInvisible());
                    this.config.set("body.stuck.arrows", (Object)this.global.getArrowsInBody());
                    this.config.set("body.stuck.bee_stingers", (Object)this.global.getBeeStingersInBody());
                    this.config.set("body.shaking", (Object)this.global.isShaking());
                    this.config.set("interact.cooldown", (Object)this.global.getInteractCooldown());
                    this.config.set("interact.actions", null);
                    int clickActionID = 0;
                    for (Interact.ClickAction clickAction : this.global.getClickActions()) {
                        if (clickAction.getActionType().equals(Interact.Actions.Type.CUSTOM_ACTION)) continue;
                        this.config.set("interact.actions." + ++clickActionID + ".type", (Object)clickAction.actionType.name());
                        this.config.set("interact.actions." + clickActionID + ".click", (Object)clickAction.clickType.name());
                        this.config.set("interact.actions." + clickActionID + ".enabled", (Object)clickAction.isEnabled());
                        this.config.set("interact.actions." + clickActionID + ".delayTicks", (Object)clickAction.delayTicks);
                        this.config.set("interact.actions." + clickActionID + ".cooldownMilliseconds", (Object)clickAction.cooldownMilliseconds);
                        if (clickAction instanceof Interact.Actions.Player.SendChatMessage) {
                            Interact.Actions.Player.SendChatMessage castAction = (Interact.Actions.Player.SendChatMessage)clickAction;
                            String[] messages = new String[castAction.getMessages().length];
                            for (int i = 0; i < castAction.getMessages().length; ++i) {
                                messages[i] = castAction.getMessages()[i].replaceAll("\u00a7", "&");
                            }
                            this.config.set("interact.actions." + clickActionID + ".messages", (Object)messages);
                        } else if (clickAction instanceof Interact.Actions.Player.SendActionBarMessage) {
                            Interact.Actions.Player.SendActionBarMessage castAction = (Interact.Actions.Player.SendActionBarMessage)clickAction;
                            this.config.set("interact.actions." + clickActionID + ".message", (Object)castAction.getMessage().replaceAll("\u00a7", "&"));
                        } else if (clickAction instanceof Interact.Actions.Player.ConnectBungeeServer) {
                            Interact.Actions.Player.ConnectBungeeServer castAction = (Interact.Actions.Player.ConnectBungeeServer)clickAction;
                            this.config.set("interact.actions." + clickActionID + ".server", (Object)castAction.getServer());
                        } else if (clickAction instanceof Interact.Actions.Console.PerformCommand) {
                            Interact.Actions.Console.PerformCommand castAction = (Interact.Actions.Console.PerformCommand)clickAction;
                            this.config.set("interact.actions." + clickActionID + ".command", (Object)castAction.getCommand());
                        } else if (clickAction instanceof Interact.Actions.Player.PerformCommand) {
                            Interact.Actions.Player.PerformCommand castAction = (Interact.Actions.Player.PerformCommand)clickAction;
                            this.config.set("interact.actions." + clickActionID + ".command", (Object)castAction.getCommand());
                        } else if (clickAction instanceof Interact.Actions.Player.SendTitleMessage) {
                            Interact.Actions.Player.SendTitleMessage castAction = (Interact.Actions.Player.SendTitleMessage)clickAction;
                            this.config.set("interact.actions." + clickActionID + ".title", (Object)castAction.getTitle().replaceAll("\u00a7", "&"));
                            this.config.set("interact.actions." + clickActionID + ".subtitle", (Object)castAction.getSubtitle().replaceAll("\u00a7", "&"));
                            this.config.set("interact.actions." + clickActionID + ".fadeIn", (Object)castAction.getFadeIn());
                            this.config.set("interact.actions." + clickActionID + ".stay", (Object)castAction.getStay());
                            this.config.set("interact.actions." + clickActionID + ".fadeOut", (Object)castAction.getFadeOut());
                        } else if (clickAction instanceof Interact.Actions.Player.TeleportToLocation) {
                            Interact.Actions.Player.TeleportToLocation castAction = (Interact.Actions.Player.TeleportToLocation)clickAction;
                            this.config.set("interact.actions." + clickActionID + ".location", (Object)castAction.getLocation());
                        } else if (clickAction instanceof Interact.Actions.Player.GiveItem) {
                            Interact.Actions.Player.GiveItem castAction = (Interact.Actions.Player.GiveItem)clickAction;
                            this.config.set("interact.actions." + clickActionID + ".item", (Object)castAction.getItemStack());
                        } else if (clickAction instanceof Interact.Actions.Player.GiveKit) {
                            Interact.Actions.Player.GiveKit castAction = (Interact.Actions.Player.GiveKit)clickAction;
                            this.config.set("interact.actions." + clickActionID + ".kit", (Object)castAction.getKit());
                        } else if (clickAction instanceof Interact.Actions.SetCustomData) {
                            Interact.Actions.SetCustomData castAction = (Interact.Actions.SetCustomData)clickAction;
                            this.config.set("interact.actions." + clickActionID + ".key", (Object)castAction.getSimpleKey());
                            this.config.set("interact.actions." + clickActionID + ".value", (Object)castAction.getValue());
                            this.config.set("interact.actions." + clickActionID + ".checkIfSame", (Object)castAction.isCheckIfSame());
                        } else if (clickAction instanceof Interact.Actions.Player.OpenBook) {
                            Interact.Actions.Player.OpenBook castAction = (Interact.Actions.Player.OpenBook)clickAction;
                            this.config.set("interact.actions." + clickActionID + ".book", (Object)castAction.getBook());
                        } else if (clickAction instanceof Interact.Actions.PlayAnimation) {
                            Interact.Actions.PlayAnimation castAction = (Interact.Actions.PlayAnimation)clickAction;
                            this.config.set("interact.actions." + clickActionID + ".animation", (Object)castAction.getAnimation().name());
                        } else if (clickAction instanceof Interact.Actions.Money) {
                            Interact.Actions.Money castAction = (Interact.Actions.Money)clickAction;
                            this.config.set("interact.actions." + clickActionID + ".balance", (Object)castAction.getBalance());
                        }
                        for (int i = 0; i < clickAction.getConditions().size(); ++i) {
                            this.config.set("interact.actions." + clickActionID + ".condition." + (i + 1), (Object)clickAction.getConditions().get(i));
                        }
                    }
                    if (!this.config.contains("disableSaving")) {
                        this.config.set("disableSaving", (Object)false);
                    }
                    this.config.save(this.file);
                    this.lastUpdate.save();
                    PlayerNPCPlugin.sendConsoleMessage("\u00a77Persistent Global NPC \u00a7a" + this.global.getID().getFullID() + " \u00a77has been saved.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    PlayerNPCPlugin.sendConsoleMessage("\u00a77There was an error while saving Persistent Global NPC \u00a7c" + this.global.getID().getFullID());
                }
            }

            private void checkFileExists() {
                boolean exist = this.file.exists();
                if (!exist) {
                    try {
                        this.file.createNewFile();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            protected void remove() {
                File folder;
                this.config = null;
                if (this.file.exists()) {
                    this.file.delete();
                }
                if ((folder = new File(this.getFolderPath())).exists()) {
                    folder.delete();
                }
                this.global = null;
            }

            public void setDisableSaving(boolean b) {
                this.checkFileExists();
                if (this.config == null) {
                    this.config = YamlConfiguration.loadConfiguration((File)this.file);
                }
                this.config.set("disableSaving", (Object)b);
                try {
                    this.config.save(this.file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public boolean isDisableSaving() {
                return (Boolean)this.get("disableSaving");
            }

            protected String getFilePath() {
                return this.getFolderPath() + "/data.yml";
            }

            protected String getFolderPath() {
                return "plugins/PlayerNPC/persistent/global/" + this.plugin.getName().toLowerCase() + "/" + this.id;
            }

            public Global getGlobal() {
                return this.global;
            }

            protected void setGlobal(Global global) {
                this.global = global;
            }

            public boolean isLoaded() {
                return this.config != null;
            }

            protected Object get(String s) {
                return this.containsKey(s) ? this.config.get(s) : null;
            }

            protected boolean containsKey(String s) {
                return this.config != null && s != null ? this.config.contains(s) : false;
            }

            protected FileConfiguration getConfig() {
                return this.config;
            }

            protected void set(String s, Object o) {
                if (this.config == null) {
                    return;
                }
                this.config.set(s, o);
            }

            public LastUpdate getLastUpdate() {
                return this.lastUpdate;
            }

            public class LastUpdate {
                private Type type;
                private String time;

                private LastUpdate() {
                }

                protected void load() {
                    this.type = Type.LOAD;
                    this.time();
                }

                protected void save() {
                    this.type = Type.SAVE;
                    this.time();
                }

                private void time() {
                    this.time = TimerUtils.getCurrentDate();
                }

                public Type getType() {
                    return this.type;
                }

                public String getTime() {
                    return this.time;
                }

                public static enum Type {
                    SAVE,
                    LOAD;

                }
            }
        }
    }

    public static class Personal
    extends NPC {
        private final Player player;
        private UUID gameProfileID;
        private EntityPlayer entityPlayer;
        private Hologram npcHologram;
        private boolean shownOnServer;
        private boolean hiddenText;
        private boolean hiddenToClient;
        private boolean shownOnTabList;
        private Global global;
        private Updatable.PendingUpdates<Global> globalPendingUpdates;

        protected Personal(@Nonnull NPCLib.PluginManager pluginManager, @Nonnull NPCLib.Registry.ID id, @Nonnull Player player, @Nonnull World world, double x, double y, double z, float yaw, float pitch) {
            super(pluginManager, id, world, x, y, z, yaw, pitch);
            Validate.notNull((Object)player, (String)"Cannot generate NPC instance, Player cannot be null.");
            this.player = player;
            this.gameProfileID = UUID.randomUUID();
            this.shownOnServer = false;
            this.npcHologram = null;
            this.shownOnTabList = false;
            this.hiddenToClient = true;
            this.hiddenText = false;
            this.global = null;
            this.globalPendingUpdates = null;
            this.getNPCLib().getNPCPlayerManager(player).getPersonalNPCs().set(id, this);
        }

        protected Personal(@Nonnull NPCLib.PluginManager pluginManager, @Nonnull NPCLib.Registry.ID id, @Nonnull Player player, @Nonnull Location location) {
            this(pluginManager, id, player, location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        }

        public void create() {
            Validate.notNull((Object)this.attributes.skin, (String)"Failed to create the NPC. The NPC.Skin has not been configured.");
            Validate.isTrue((this.entityPlayer == null ? 1 : 0) != 0, (String)"Failed to create the NPC. This NPC has already been created before.");
            MinecraftServer server = NMSCraftServer.getMinecraftServer();
            WorldServer worldServer = NMSCraftWorld.getWorldServer(this.world);
            try {
                GameProfile gameProfile = new GameProfile(this.gameProfileID, this.getReplacedNameTag());
                this.entityPlayer = NMSEntityPlayer.newEntityPlayer(server, worldServer, gameProfile);
            }
            catch (Exception e) {
                String noColored = org.bukkit.ChatColor.stripColor((String)this.getReplacedNameTag()).replaceAll("\u00a7", "");
                GameProfile gameProfile = new GameProfile(this.gameProfileID, noColored);
                try {
                    this.entityPlayer = NMSEntityPlayer.newEntityPlayer(server, worldServer, gameProfile);
                }
                catch (Exception ex) {
                    NPCLib.DebugManager.printError(ex);
                }
            }
            Validate.notNull((Object)this.entityPlayer, (String)"Error at NMSEntityPlayer");
            NMSEntity.setLocation((net.minecraft.world.entity.Entity)this.entityPlayer, this.x, this.y, this.z, this.yaw.floatValue(), this.pitch.floatValue());
            this.updateSkin();
            this.updatePose();
            this.updateScoreboard();
            if (this.getTabListVisibility().equals(TabListVisibility.ALWAYS) || this.getTabListVisibility().equals(TabListVisibility.SAME_WORLD) && this.getWorld().getName().equals(this.player.getWorld().getName())) {
                this.addTabList(true);
            }
            this.updateTabList();
            this.npcHologram = new Hologram(this, this.player);
        }

        @Override
        public void simpleUpdate() {
            Validate.notNull((Object)this.entityPlayer, (String)"Failed to update the NPC. The NPC has not been created yet.");
            if (!this.shownOnServer) {
                return;
            }
            if (!this.hiddenToClient && !this.isInRange()) {
                this.hideToClient();
                return;
            }
            if (this.hiddenToClient && this.isInRange() && this.canBeShownInView()) {
                this.showToClient();
                return;
            }
            this.updatePose();
            this.updateLook();
            this.updateSkin();
            this.updatePlayerRotation();
            this.updateEquipment();
            this.updateMetadata();
            this.updateScoreboard();
            this.updateTabList();
            this.onExecuteUpdate(Updatable.Type.SIMPLE_UPDATE);
        }

        @Override
        public void forceUpdate() {
            Validate.notNull((Object)this.entityPlayer, (String)"Failed to force update the NPC. The NPC has not been created yet.");
            this.reCreate();
            this.simpleUpdate();
            this.forceUpdateText();
            this.onExecuteUpdate(Updatable.Type.FORCE_UPDATE);
        }

        @Override
        public void teleport(World world, double x, double y, double z, float yaw, float pitch) {
            Validate.notNull((Object)this.entityPlayer, (String)"Failed to move the NPC. The NPC has not been created yet.");
            Events.Teleport npcTeleportEvent = new Events.Teleport(this, new Location(world, x, y, z, yaw, pitch));
            if (npcTeleportEvent.isCancelled()) {
                return;
            }
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = Float.valueOf(yaw);
            this.pitch = Float.valueOf(pitch);
            if (!this.world.equals(world)) {
                this.changeWorld(world);
            }
            boolean show = this.shownOnServer;
            if (this.npcHologram != null) {
                this.npcHologram.hide();
            }
            this.reCreate();
            if (this.npcHologram != null) {
                this.forceUpdateText();
            }
            if (show) {
                this.show();
            } else if (this.npcHologram != null) {
                this.hideText();
            }
        }

        @Override
        public void simpleUpdateText() {
            if (this.npcHologram == null) {
                return;
            }
            this.npcHologram.simpleUpdate();
            this.onExecuteUpdate(Updatable.Type.SIMPLE_UPDATE_TEXT);
        }

        @Override
        public void forceUpdateText() {
            if (this.npcHologram == null) {
                return;
            }
            if (!this.npcHologram.isShownToClient()) {
                return;
            }
            this.npcHologram.forceUpdate();
            this.onExecuteUpdate(Updatable.Type.FORCE_UPDATE_TEXT);
        }

        @Override
        public void destroy() {
            this.cancelMove();
            if (this.entityPlayer != null) {
                if (this.shownOnServer) {
                    this.hide();
                }
                this.entityPlayer = null;
            }
            if (this.npcHologram != null) {
                this.npcHologram.removeHologram();
            }
        }

        public void show() {
            this.show(10);
        }

        protected void show(int ticksToAppear) {
            Validate.notNull((Object)this.entityPlayer, (String)"Failed to show NPC. The NPC has not been created yet.");
            if (this.shownOnServer) {
                return;
            }
            Events.Show npcShowEvent = new Events.Show(this.getPlayer(), this);
            if (npcShowEvent.isCancelled()) {
                return;
            }
            this.shownOnServer = true;
            if (!this.isInRange() || !this.canBeShownInView()) {
                this.hiddenToClient = true;
                return;
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask(this.getPlugin(), () -> this.showToClient(), Math.max(this.getPlayerManager().ticksToAppear(), (long)ticksToAppear));
        }

        public void hide() {
            Validate.notNull((Object)this.entityPlayer, (String)"Failed to hide the NPC. The NPC has not been created yet.");
            if (!this.shownOnServer) {
                return;
            }
            Events.Hide npcHideEvent = new Events.Hide(this.getPlayer(), this);
            if (npcHideEvent.isCancelled()) {
                return;
            }
            this.hideToClient();
            if (this.shownOnTabList) {
                this.removeTabList();
            }
            this.shownOnServer = false;
        }

        public void setHideText(boolean hide) {
            if (this.hiddenText == hide) {
                return;
            }
            this.hiddenText = hide;
            if (this.npcHologram == null) {
                return;
            }
            if (hide) {
                this.hideText();
            } else {
                this.showText();
            }
        }

        private void onExecuteUpdate(Updatable.Type type) {
            this.pendingUpdates.onExecute(type);
            if (this.globalPendingUpdates != null) {
                this.globalPendingUpdates.onExecute(type);
            }
        }

        public Move.Behaviour followPlayer() {
            return this.moveBehaviour.setFollowPlayer();
        }

        public Move.Behaviour followPlayer(double min, double max) {
            return this.moveBehaviour.setFollowPlayer(min, max);
        }

        @Override
        public void playAnimation(@Nonnull Animation animation) {
            Validate.notNull((Object)animation, (String)"Cannot play a null animation.");
            if (!this.isCreated()) {
                return;
            }
            if (animation.isDeprecated() && !this.getNPCLib().isDebug()) {
                return;
            }
            if (animation.equals(Animation.TAKE_DAMAGE) && this.getClientVersion().isNewerThanOrEqual(ServerVersion.VERSION_1_19_4) && this.getServerVersion().isNewerThanOrEqual(ServerVersion.VERSION_1_19_4)) {
                NMSCraftPlayer.sendPacket(this.player, NMSPacketPlayOutAnimation.getHurtAnimationPacket((EntityLiving)this.entityPlayer));
                return;
            }
            NMSCraftPlayer.sendPacket(this.player, (Packet)animation.createPacket((net.minecraft.world.entity.Entity)this.entityPlayer));
        }

        @Override
        public <T> void playParticle(Particle particle, Vector regarding, Vector offset, int count, double speed, @Nullable T data) {
            this.player.spawnParticle(particle, this.getLocation().add(regarding), count, offset != null ? offset.getX() : 0.0, offset != null ? offset.getY() : 0.0, offset != null ? offset.getZ() : 0.0, speed, data);
        }

        @Override
        public void hit() {
            if (!this.isCreated()) {
                return;
            }
            this.player.playSound(this.getLocation(), Sound.ENTITY_PLAYER_ATTACK_STRONG, 1.0f, 1.0f);
            this.playAnimation(Animation.TAKE_DAMAGE);
        }

        @Override
        public Updatable lookAt(float yaw, float pitch) {
            Validate.notNull((Object)this.entityPlayer, (String)"Failed to set look direction. The NPC has not been created yet.");
            float a = Math.abs(yaw - this.yaw.floatValue());
            this.yaw = Float.valueOf(yaw);
            this.pitch = Float.valueOf(pitch);
            NMSEntity.setYRot((net.minecraft.world.entity.Entity)this.entityPlayer, yaw);
            NMSEntity.setXRot((net.minecraft.world.entity.Entity)this.entityPlayer, pitch);
            return this.needUpdateOrForce(a > 45.0f);
        }

        public Updatable setInGameSkin() {
            return this.setInGameSkinOf(this.player);
        }

        protected void reCreate() {
            Validate.notNull((Object)this.entityPlayer, (String)"Failed to re-create the NPC. The NPC has not been created yet.");
            boolean show = this.shownOnServer;
            this.hide();
            this.entityPlayer = null;
            this.create();
            if (show) {
                this.show(0);
            }
        }

        protected void interact(@Nonnull Player player, @Nonnull Interact.ClickType clickType) {
            Events.Interact npcInteractEvent = new Events.Interact(player, this, clickType);
            if (npcInteractEvent.isCancelled()) {
                return;
            }
            if (this.hasGlobal()) {
                this.getGlobal().getClickActions(clickType).forEach(x -> x.execute(player));
                this.getGlobal().getClickActions(Interact.ClickType.EITHER).forEach(x -> x.execute(player));
            }
            this.getClickActions(clickType).forEach(x -> x.execute(player));
            this.getClickActions(Interact.ClickType.EITHER).forEach(x -> x.execute(player));
        }

        protected void updateGlobalLocation() {
            if (!this.hasGlobal()) {
                return;
            }
            this.x = this.global.getX();
            this.y = this.global.getY();
            this.z = this.global.getZ();
            if (!this.getGazeTrackingType().equals(GazeTrackingType.NONE)) {
                return;
            }
            this.yaw = this.global.getYaw();
            this.pitch = this.global.getPitch();
        }

        @Override
        protected void updateMove() {
            if (this.player == null) {
                return;
            }
            if (this.entityPlayer == null) {
                return;
            }
            if (!this.shownOnServer) {
                return;
            }
            if (!this.hiddenToClient && !this.isInRange()) {
                this.hideToClient();
                return;
            }
            if (this.hiddenToClient && this.isInRange() && this.canBeShownInView()) {
                this.showToClient();
                return;
            }
            this.updateLook();
            this.updatePlayerRotation();
        }

        private void updateLook() {
            Validate.notNull((Object)this.entityPlayer, (String)"Failed to update look the NPC. The NPC has not been created yet.");
            if (!this.player.getWorld().getName().equals(this.getWorld().getName())) {
                return;
            }
            if (this.getGazeTrackingType().equals(GazeTrackingType.PLAYER)) {
                this.lookAt((Entity)this.player);
            } else if (this.getGazeTrackingType().equals(GazeTrackingType.NEAREST_PLAYER) || this.getGazeTrackingType().equals(GazeTrackingType.NEAREST_ENTITY)) {
                Entity near;
                boolean var3 = this.getGazeTrackingType().equals(GazeTrackingType.NEAREST_PLAYER);
                if (this.hasGlobal() && (near = var3 ? this.getGlobal().np() : this.getGlobal().ne()) != null) {
                    this.lookAt(near);
                    return;
                }
                Bukkit.getScheduler().scheduleSyncDelayedTask(this.getNPCLib().getPlugin(), () -> {
                    Entity near = null;
                    double var0 = this.getHideDistance();
                    Location npcLocation = this.getLocation();
                    for (Entity entities : this.world.getNearbyEntities(npcLocation, this.getHideDistance().doubleValue(), this.getHideDistance().doubleValue(), this.getHideDistance().doubleValue())) {
                        double var1;
                        if (var3 && !(entities instanceof Player) || (var1 = entities.getLocation().distance(npcLocation)) > var0) continue;
                        near = entities;
                        var0 = var1;
                    }
                    if (near == null) {
                        return;
                    }
                    this.lookAt(near);
                    if (this.hasGlobal()) {
                        if (var3) {
                            this.getGlobal().np(near);
                        } else {
                            this.getGlobal().ne(near);
                        }
                    }
                });
            }
        }

        @Override
        protected void updateLocation() {
            if (this.entityPlayer == null) {
                return;
            }
            NMSCraftPlayer.sendPacket(this.player, (Packet)new PacketPlayOutEntityTeleport((net.minecraft.world.entity.Entity)this.entityPlayer));
        }

        protected void updateScoreboard() {
            String teamName;
            if (!this.getNPCLib().isUsingPacketScoreboards()) {
                this.updateBukkitScoreboard();
                return;
            }
            Scoreboard scoreboard = NMSCraftScoreboard.getScoreboard(this.player);
            boolean existsTeam = NMSScoreboard.getTeam(scoreboard, teamName = this.getScoreboardTeamName("npc")) != null;
            ScoreboardTeam scoreboardTeam = existsTeam ? NMSScoreboard.getTeam(scoreboard, teamName) : new ScoreboardTeam(scoreboard, teamName);
            NMSScoreboard.setNameTagVisibility(scoreboardTeam, this.isShowNameTag() ? NMSScoreboard.nameTagVisibility_ALWAYS : NMSScoreboard.nameTagVisibility_NEVER);
            NMSScoreboard.setTeamColor(scoreboardTeam, this.getGlowingColor().asMinecraftEnumChatFormat());
            NMSScoreboard.setTeamPush(scoreboardTeam, this.isCollidable() ? NMSScoreboard.teamPush_ALWAYS : NMSScoreboard.teamPush_NEVER);
            NMSScoreboard.setPlayerTeam(scoreboard, this.getGameProfile().getName(), scoreboardTeam);
            NMSScoreboard.setPrefix(scoreboardTeam, NMSCraftChatMessage.fromString(this.getNameTag().grabPrefix().map(x -> ColorUtils.formatColor(x)).orElse(null)));
            NMSScoreboard.setSuffix(scoreboardTeam, NMSCraftChatMessage.fromString(this.getNameTag().grabSuffix().map(x -> ColorUtils.formatColor(x)).orElse(null)));
            NMSCraftPlayer.sendPacket(this.player, (Packet)PacketPlayOutScoreboardTeam.a((ScoreboardTeam)scoreboardTeam, (!existsTeam ? 1 : 0) != 0));
        }

        protected void updateBukkitScoreboard() {
            String teamName;
            org.bukkit.scoreboard.Scoreboard scoreboard;
            if (this.player.getScoreboard().equals(Bukkit.getServer().getScoreboardManager().getMainScoreboard())) {
                this.player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
            }
            boolean existsTeam = (scoreboard = this.player.getScoreboard()).getTeam(teamName = this.getScoreboardTeamName("npc")) != null;
            Team scoreboardTeam = existsTeam ? scoreboard.getTeam(teamName) : scoreboard.registerNewTeam(teamName);
            scoreboardTeam.setColor(this.getGlowingColor().asBukkitChatColor());
            scoreboardTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, this.isShowNameTag() ? Team.OptionStatus.ALWAYS : Team.OptionStatus.NEVER);
            scoreboardTeam.setOption(Team.Option.COLLISION_RULE, this.isCollidable() ? Team.OptionStatus.ALWAYS : Team.OptionStatus.NEVER);
            if (!scoreboardTeam.hasEntry(this.getGameProfile().getName())) {
                scoreboardTeam.addEntry(this.getGameProfile().getName());
            }
            scoreboardTeam.setPrefix(this.getNameTag().grabPrefix().map(x -> ColorUtils.formatColor(x)).orElse(""));
            scoreboardTeam.setSuffix(this.getNameTag().grabSuffix().map(x -> ColorUtils.formatColor(x)).orElse(""));
        }

        protected void updateTabList() {
            if (!this.isCreated()) {
                return;
            }
            if (this.getTabListName() != null) {
                String string = ColorUtils.formatColor(this.getTabListName().replaceAll("\\{id\\}", this.getGameProfile().getName()));
                if (!this.getNPCLib().isDebug() || this.player.isOp()) {
                    // empty if block
                }
                v1 = NMSCraftChatMessage.fromString(string + "");
            } else {
                v1 = this.entityPlayer.listName = null;
            }
            if (this.shownOnTabList) {
                NMSPacketPlayOutPlayerInfo.refreshPlayerTabList(this.player, this.entityPlayer);
            }
        }

        protected void addTabList(boolean permanent) {
            if (this.shownOnTabList) {
                return;
            }
            boolean effectiveShownOnTabList = permanent || this.pluginManager.getTicksUntilTabListHide() > 0 || this.getServerVersion().isOlderThanOrEqual(ServerVersion.VERSION_1_19_2) || this.getClientVersion().isOlderThanOrEqual(ServerVersion.VERSION_1_19_2);
            NMSPacketPlayOutPlayerInfo.addPlayer(this.player, this.entityPlayer, effectiveShownOnTabList);
            if (!effectiveShownOnTabList) {
                return;
            }
            this.shownOnTabList = true;
            this.updateTabList();
            if (this.getTabListVisibility().equals(TabListVisibility.ALWAYS) || this.getTabListVisibility().equals(TabListVisibility.NEAR) && !this.hiddenToClient || this.getTabListVisibility().equals(TabListVisibility.SAME_WORLD) && this.player.getWorld().getName().equals(this.getWorld().getName())) {
                return;
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask(this.getNPCLib().getPlugin(), () -> this.removeTabList(), (long)Math.max(1, this.pluginManager.getTicksUntilTabListHide()));
        }

        protected void removeTabList() {
            if (!this.shownOnTabList) {
                return;
            }
            NMSPacketPlayOutPlayerInfo.removePlayer(this.player, this.entityPlayer);
            this.shownOnTabList = false;
        }

        @Override
        protected void updatePlayerRotation() {
            if (this.entityPlayer == null) {
                return;
            }
            NMSCraftPlayer.sendPacket(this.player, (Packet)new PacketPlayOutEntity.PacketPlayOutEntityLook(NMSEntity.getEntityID((net.minecraft.world.entity.Entity)this.entityPlayer).intValue(), (byte)(this.yaw.floatValue() * 256.0f / 360.0f), (byte)(this.pitch.floatValue() * 256.0f / 360.0f), false));
            NMSCraftPlayer.sendPacket(this.player, (Packet)new PacketPlayOutEntityHeadRotation((net.minecraft.world.entity.Entity)this.entityPlayer, (byte)(this.yaw.floatValue() * 256.0f / 360.0f)));
        }

        protected void updateSkin() {
            if (this.entityPlayer == null) {
                return;
            }
            GameProfile gameProfile = NMSEntityPlayer.getGameProfile(this.entityPlayer);
            gameProfile.getProperties().get((Object)"textures").clear();
            if (this.getSkin() == null) {
                return;
            }
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", this.attributes.skin.getTexture(), this.attributes.skin.getSignature()));
        }

        protected void updatePose() {
            Validate.notNull((Object)this.entityPlayer, (String)"Failed to update pose the NPC. The NPC has not been created yet.");
            if (this.getPose().equals(Pose.SLEEPING)) {
                NMSEntityLiving.setSetSleepingPos((EntityLiving)this.entityPlayer, this.x.intValue(), this.y.intValue(), this.z.intValue());
            }
            NMSEntity.setPose((net.minecraft.world.entity.Entity)this.entityPlayer, this.getPose().asMinecraftEntityPose());
        }

        @Override
        protected void move(double x, double y, double z) {
            Validate.isTrue((x < 8.0 && y < 8.0 && z < 8.0 ? 1 : 0) != 0, (String)"NPC cannot move 8 blocks or more at once, use teleport instead");
            Events.Move npcMoveEvent = new Events.Move(this, new Location(this.world, this.x + x, this.y + y, this.z + z));
            if (npcMoveEvent.isCancelled()) {
                return;
            }
            this.x = this.x + x;
            this.y = this.y + y;
            this.z = this.z + z;
            NMSEntity.move((net.minecraft.world.entity.Entity)this.entityPlayer, this.x, this.y, this.z);
            if (this.npcHologram != null) {
                this.npcHologram.move(new Vector(x, y, z));
            }
            this.movePacket(x, y, z);
        }

        protected void movePacket(double x, double y, double z) {
            Validate.isTrue((x < 8.0 ? 1 : 0) != 0);
            Validate.isTrue((y < 8.0 ? 1 : 0) != 0);
            Validate.isTrue((z < 8.0 ? 1 : 0) != 0);
            NMSCraftPlayer.sendPacket(this.player, (Packet)new PacketPlayOutEntity.PacketPlayOutRelEntityMove(NMSEntity.getEntityID((net.minecraft.world.entity.Entity)this.entityPlayer).intValue(), (short)(x * 4096.0), (short)(y * 4096.0), (short)(z * 4096.0), true));
        }

        protected void updateMetadata() {
            DataWatcher dataWatcher = NMSEntity.getDataWatcher((net.minecraft.world.entity.Entity)this.entityPlayer);
            if (dataWatcher == null) {
                return;
            }
            NMSEntity.setGlowingTag((net.minecraft.world.entity.Entity)this.entityPlayer, this.isGlowing());
            Map<Integer, DataWatcher.Item<?>> map = NMSDataWatcher.getMapOfDataWatcherItems(dataWatcher);
            if (map == null) {
                return;
            }
            byte b = 0;
            DataWatcher.Item<?> item = map.get(0);
            b = 0;
            boolean bit0 = this.isOnFire();
            boolean bit1 = this.getPose().equals(Pose.CROUCHING);
            boolean bit2 = true;
            boolean bit3 = this.isGroundParticles();
            boolean bit4 = this.getPose().equals(Pose.SWIMMING);
            boolean bit5 = this.isInvisible();
            boolean bit6 = this.isGlowing();
            boolean bit7 = this.getPose().equals(Pose.GLIDING);
            b = (byte)((bit0 ? 1 : 0) | (bit1 ? 2 : 0) | (bit2 ? 4 : 0) | (bit3 ? 8 : 0) | (bit4 ? 16 : 0) | (bit5 ? 32 : 0) | (bit6 ? 64 : 0) | (bit7 ? 128 : 0));
            NMSDataWatcher.set(dataWatcher, NMSDataWatcher.getDataWatcherSerializerByte().a(0), b);
            NMSDataWatcher.set(dataWatcher, NMSDataWatcher.getDataWatcherSerializerInteger().a(7), this.isShaking() != false ? 140 : 0);
            item = map.get(8);
            b = (Byte)item.b();
            b = (byte)(this.getPose().equals(Pose.SPIN_ATTACK) ? b | 4 : b & 4);
            NMSDataWatcher.set(dataWatcher, DataWatcherRegistry.a.a(8), b);
            boolean noColor = this.getPotionParticlesType().equals(PotionParticlesType.DISABLED);
            int rgb = (this.getPotionParticlesColor().getRed() & 0xFF) << 16 | (this.getPotionParticlesColor().getGreen() & 0xFF) << 8 | this.getPotionParticlesColor().getBlue() & 0xFF;
            NMSDataWatcher.set(dataWatcher, NMSDataWatcher.getDataWatcherSerializerInteger().a(10), noColor ? 0 : rgb);
            NMSDataWatcher.set(dataWatcher, NMSDataWatcher.getDataWatcherSerializerBoolean().a(11), this.getPotionParticlesType().metadata);
            NMSDataWatcher.set(dataWatcher, NMSDataWatcher.getDataWatcherSerializerInteger().a(12), this.getArrowsInBody());
            NMSDataWatcher.set(dataWatcher, NMSDataWatcher.getDataWatcherSerializerInteger().a(13), this.getBeeStingersInBody());
            b = 0;
            Skin.VisibleLayers visibleLayers = this.getSkinVisibleLayers();
            for (Skin.Layer layer : visibleLayers.getVisibleLayers()) {
                b = (byte)(b | layer.getMask());
            }
            NMSDataWatcher.set(dataWatcher, NMSDataWatcher.getDataWatcherSerializerByte().a(17), b);
            NMSCraftPlayer.sendPacket(this.player, (Packet)NMSPacketPlayOutEntityMetadata.getPacket((net.minecraft.world.entity.Entity)this.entityPlayer, dataWatcher));
        }

        protected void updateEquipment() {
            ArrayList<Pair> equipment = new ArrayList<Pair>();
            for (Slot slot : Slot.values()) {
                if (!this.getSlots().containsKey(slot)) {
                    this.getSlots().put(slot, new org.bukkit.inventory.ItemStack(Material.AIR));
                }
                org.bukkit.inventory.ItemStack item = this.getSlots().get(slot);
                ItemStack minecraftItem = null;
                try {
                    minecraftItem = (ItemStack)NMSCraftItemStack.getCraftItemStackAsNMSCopy().invoke(null, item);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Validate.notNull(minecraftItem, (String)"Error at NMSCraftItemStack");
                equipment.add(new Pair((Object)slot.asMinecraftEnumItemSlot(), (Object)minecraftItem));
            }
            PacketPlayOutEntityEquipment packet = new PacketPlayOutEntityEquipment(NMSEntity.getEntityID((net.minecraft.world.entity.Entity)this.entityPlayer).intValue(), equipment);
            NMSCraftPlayer.sendPacket(this.player, (Packet)packet);
        }

        protected void showToClient() {
            if (this.player == null || !this.player.isOnline()) {
                return;
            }
            if (this.entityPlayer == null) {
                return;
            }
            if (!this.hiddenToClient) {
                return;
            }
            this.hiddenToClient = false;
            this.addTabList(!this.getTabListVisibility().equals(TabListVisibility.NEVER));
            NMSCraftPlayer.sendPacket(this.player, (Packet)new PacketPlayOutNamedEntitySpawn((EntityHuman)this.entityPlayer));
            this.updatePlayerRotation();
            if (this.getText().size() > 0) {
                this.simpleUpdateText();
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask(this.getNPCLib().getPlugin(), () -> {
                if (this.isCreated()) {
                    this.simpleUpdate();
                }
            }, 1L);
        }

        protected void hideToClient() {
            if (this.hiddenToClient) {
                return;
            }
            if (this.shownOnTabList && (this.getTabListVisibility().equals(TabListVisibility.NEAR) || this.getTabListVisibility().equals(TabListVisibility.SAME_WORLD) && !this.player.getWorld().getName().equals(this.getWorld().getName()))) {
                this.removeTabList();
            }
            if (!this.getNPCLib().isUsingPacketScoreboards()) {
                Team team = this.player.getScoreboard().getTeam(this.getScoreboardTeamName("npc"));
                if (team != null) {
                    team.unregister();
                }
            } else {
                Scoreboard scoreboard = NMSScoreboard.getScoreboard(this.player);
                ScoreboardTeam scoreboardTeam = NMSScoreboard.getTeam(scoreboard, this.getScoreboardTeamName("npc"));
                if (scoreboardTeam != null) {
                    NMSCraftPlayer.sendPacket(this.player, (Packet)PacketPlayOutScoreboardTeam.a((ScoreboardTeam)scoreboardTeam));
                }
            }
            NMSCraftPlayer.sendPacket(this.player, (Packet)NMSPacketPlayOutEntityDestroy.createPacket(NMSEntity.getEntityID((net.minecraft.world.entity.Entity)this.entityPlayer)));
            if (this.npcHologram != null) {
                this.npcHologram.hide();
            }
            this.pendingUpdates.clear();
            this.hiddenToClient = true;
        }

        private void hideText() {
            Validate.notNull((Object)this.npcHologram, (String)"Failed to update NPC text. The NPCHologram has not been created yet.");
            this.npcHologram.hide();
            this.hiddenText = true;
        }

        private void showText() {
            Validate.notNull((Object)this.npcHologram, (String)"Failed to update NPC text. The NPCHologram has not been created yet.");
            if (this.hiddenText) {
                return;
            }
            this.npcHologram.show();
            this.hiddenText = false;
        }

        protected void changeWorld(World world) {
            super.getPluginManager().getNPCLib().getNPCPlayerManager(this.player).changeWorld(this, this.world, world);
            this.world = world;
        }

        public EntityPlayer getEntity() {
            return this.entityPlayer;
        }

        public boolean isCreated() {
            return this.entityPlayer != null;
        }

        public GameProfile getGameProfile() {
            Validate.notNull((Object)this.entityPlayer, (String)"Cannot get GameProfile because NPC is not created yet.");
            return NMSEntityPlayer.getGameProfile(this.entityPlayer);
        }

        protected String getShortUUID() {
            return this.gameProfileID.toString().substring(0, 5);
        }

        private String getScoreboardTeamName(String id) {
            boolean limited16 = this.getClientVersion().isOlderThan(ServerVersion.VERSION_1_18) || this.getServerVersion().isOlderThan(ServerVersion.VERSION_1_18) || IntegrationsManager.isUsingViaVersion() && IntegrationsManager.getViaVersion().isSupportedVersionLowerThanOrEqual(ServerVersion.VERSION_1_16_5.getProtocolVersion());
            String npcid = limited16 ? this.getShortUUID() : this.getID().getFullID();
            String name = npcid + "/" + id;
            return limited16 && name.length() > 16 ? name.substring(0, 15) : name;
        }

        protected String getReplacedNameTag() {
            return this.getReplacedNameTag(this.attributes.getNameTag().getName());
        }

        protected String getReplacedNameTag(String name) {
            if (name.contains("{id}")) {
                name = name.replaceAll("\\{id\\}", this.getShortUUID());
            }
            return (name = ColorUtils.formatColor(name)).length() > 16 ? name.substring(0, 15) : name;
        }

        private boolean canBeShownInView() {
            if (this.getClientVersion().isNewerThanOrEqual(ServerVersion.VERSION_1_19_3)) {
                return true;
            }
            return this.isInView();
        }

        public boolean isInView() {
            return this.isInView(60.0);
        }

        public boolean isInView(double fov) {
            if (!this.getWorld().getName().equals(this.player.getWorld().getName())) {
                return false;
            }
            Vector dir = this.getEyeLocation().toVector().subtract(this.player.getEyeLocation().toVector()).normalize();
            return dir.dot(this.player.getEyeLocation().getDirection()) >= Math.cos(Math.toRadians(fov));
        }

        public boolean isInRange() {
            if (!this.getWorld().getName().equals(this.player.getWorld().getName())) {
                return false;
            }
            return this.getLocation().distance(this.player.getLocation()) < this.getHideDistance();
        }

        public Player getPlayer() {
            return this.player;
        }

        protected NPCLib.PlayerManager getPlayerManager() {
            return this.getNPCLib().getNPCPlayerManager(this.player);
        }

        protected ServerVersion getClientVersion() {
            return this.getPlayerManager().getClientVersion();
        }

        protected ServerVersion getServerVersion() {
            return ServerVersion.getServerVersion();
        }

        public boolean isShown() {
            return this.shownOnServer;
        }

        public boolean isShownOnClient() {
            return this.shownOnServer && !this.hiddenToClient;
        }

        public boolean isShownOnClientTabList() {
            return this.shownOnTabList;
        }

        public boolean isHiddenText() {
            return this.hiddenText;
        }

        public boolean canBeCreated() {
            return this.entityPlayer == null;
        }

        protected Hologram getHologram() {
            return this.npcHologram;
        }

        public boolean hasGlobal() {
            return this.global != null;
        }

        public Global getGlobal() {
            return this.global;
        }
    }
}

