/*
 * Decompiled with CFR 0.152.
 */
package me.arace863.epicitems.Events.ItemAbilities;

import me.arace863.epicitems.EpicItems;
import me.arace863.epicitems.Utils.Cooldown;
import me.arace863.epicitems.Utils.Managers.ParticleManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class RocketLauncherEvent
implements Listener {
    EpicItems plugin;
    FileConfiguration config;

    public RocketLauncherEvent(EpicItems plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
    }

    @EventHandler
    public void onClick(PlayerInteractEvent event) {
        int damage = 70;
        if (this.config.getBoolean("RocketLauncher", true) && (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) || event.getAction().equals((Object)Action.RIGHT_CLICK_AIR)) && event.getPlayer().getInventory().getItemInMainHand().getItemMeta() != null && event.getPlayer().getInventory().getItemInMainHand().getItemMeta().getLore() != null && event.getPlayer().getInventory().getItemInMainHand().getItemMeta().getLore().contains("\u00a76Item Ability: Ricochet Rocket \u00a7e\u00a7lRIGHT CLICK")) {
            final Player player = event.getPlayer();
            if (Cooldown.checkCooldown(event.getPlayer())) {
                try {
                    Location eye = player.getEyeLocation();
                    final Firework firework = (Firework)eye.getWorld().spawnEntity(eye, EntityType.FIREWORK);
                    FireworkMeta meta = firework.getFireworkMeta();
                    meta.setPower(2);
                    firework.setFireworkMeta(meta);
                    firework.setShotAtAngle(true);
                    firework.setRotation(player.getLocation().getYaw(), player.getLocation().getPitch());
                    firework.setVelocity(eye.getDirection().normalize().multiply(2));
                    firework.setBounce(true);
                    firework.setCustomName(String.valueOf(damage));
                    firework.setShooter((ProjectileSource)player);
                    Cooldown.setCooldown(event.getPlayer(), this.config.getInt("RocketLauncherCooldown"));
                    new BukkitRunnable(){

                        public void run() {
                            if (firework.isDead()) {
                                ParticleManager particleManager = new ParticleManager(RocketLauncherEvent.this.plugin);
                                firework.getWorld().spawnParticle(Particle.EXPLOSION_HUGE, firework.getLocation(), 10);
                                particleManager.fireSpiral((Entity)firework);
                                firework.getWorld().playSound(firework.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 5.0f, 5.0f);
                                for (Entity entity : firework.getNearbyEntities(5.0, 5.0, 5.0)) {
                                    LivingEntity livingEntity;
                                    if (!(entity instanceof LivingEntity) || (livingEntity = (LivingEntity)entity).equals(player) || livingEntity.equals(firework)) continue;
                                    livingEntity.damage((double)Integer.parseInt(firework.getCustomName()));
                                }
                                this.cancel();
                            }
                        }
                    }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
                    event.setCancelled(true);
                }
                catch (NullPointerException exception) {
                    Bukkit.getConsoleSender().sendMessage(ChatColor.AQUA + "[EpicItems] " + ChatColor.RED + "An error occured, please report this here with a screenshot of the error: " + ChatColor.BLUE + "https://dsc.gg/arace863");
                    exception.printStackTrace();
                }
            } else {
                player.sendMessage(ChatColor.RED + "This is on cooldown for " + Math.round((Cooldown.cooldowns.get(player.getUniqueId()) - (double)System.currentTimeMillis()) / 1000.0) + "s.");
            }
        }
    }

    @EventHandler
    public void onHit(ProjectileHitEvent event) {
        if (this.config.getBoolean("RocketLauncher", true) && event.getEntity() instanceof Firework && event.getEntity().getCustomName() != null) {
            Firework firework = (Firework)event.getEntity();
            firework.getWorld().spawnParticle(Particle.EXPLOSION_LARGE, firework.getLocation(), 10);
            firework.getWorld().playSound(firework.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 5.0f, 5.0f);
            firework.setVelocity(new Vector(firework.getFacing().getModX(), firework.getFacing().getModY(), firework.getFacing().getModZ()));
            for (Entity entity : firework.getNearbyEntities(5.0, 5.0, 5.0)) {
                LivingEntity livingEntity;
                if (!(entity instanceof LivingEntity) || (livingEntity = (LivingEntity)entity).equals(firework.getShooter()) || livingEntity.equals(firework)) continue;
                livingEntity.damage(this.config.getDouble("bonemerangDamage"), (Entity)livingEntity);
            }
        }
    }
}

