/*
 * Decompiled with CFR 0.152.
 */
package me.arace863.epicitems.Events.ItemAbilities;

import me.arace863.epicitems.EpicItems;
import me.arace863.epicitems.Items.ItemManager;
import me.arace863.epicitems.Utils.Cooldown;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class EndermanBowEvent
implements Listener {
    FileConfiguration config;

    public EndermanBowEvent(EpicItems plugin) {
        this.config = plugin.getConfig();
    }

    @EventHandler
    public void onShoot(EntityShootBowEvent event) {
        if (event.getEntity() instanceof Player && event.getBow() != null && event.getBow().getItemMeta() != null && event.getBow().getItemMeta().getLore() != null && event.getBow().getItemMeta().getLore().contains(ItemManager.EndermanBow.getItemMeta().getLore().get(0)) && event.getProjectile() instanceof Arrow) {
            Arrow arrow = (Arrow)event.getProjectile();
            arrow.setCustomName("Enderman Bow");
        }
    }

    @EventHandler
    public void onBowShoot(ProjectileHitEvent event) {
        if (event.getEntity() instanceof Arrow) {
            Player player;
            Arrow arrow = (Arrow)event.getEntity();
            Projectile entity = event.getEntity();
            if (entity instanceof Player && (player = (Player)entity).getInventory().getItemInMainHand().getItemMeta().hasLore() && player.getInventory().getItemInMainHand().getItemMeta().getLore().contains("\u00a78EpicItem-EndermanBow")) {
                if (Cooldown.checkCooldown(player)) {
                    Location location = event.getEntity().getLocation();
                    event.getEntity().remove();
                    location.setYaw(player.getLocation().getYaw());
                    location.setPitch(player.getLocation().getPitch());
                    player.teleport(location);
                    player.playSound(location, Sound.ENTITY_ENDERMAN_TELEPORT, 10.0f, 1.0f);
                    player.sendMessage(ChatColor.DARK_GRAY + "\u00a7lSwoosh!");
                    Cooldown.setCooldown(player, this.config.getInt("EndermanBowCooldown"));
                } else {
                    player.sendMessage(ChatColor.RED + "This is on cooldown for " + Math.round((Cooldown.cooldowns.get(player.getUniqueId()) - (double)System.currentTimeMillis()) / 1000.0) + "s.");
                }
            }
        }
    }

    @EventHandler
    public void onClick(PlayerInteractEvent event) {
        if (this.config.getBoolean("ExplosiveBow", true)) {
            Player player = event.getPlayer();
            if (this.config.getBoolean("EndermanBowQuiver", true) && event.getItem() != null && event.getItem().getItemMeta().equals(ItemManager.ExplosiveBow.getItemMeta())) {
                player.getInventory().setItemInOffHand(ItemManager.Quiver);
            }
        }
    }
}

