/*
 * Decompiled with CFR 0.152.
 */
package me.arace863.epicitems.Events.ItemAbilities;

import me.arace863.epicitems.EpicItems;
import me.arace863.epicitems.Items.ItemManager;
import me.arace863.epicitems.Utils.Cooldown;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class BonemerangEvent
implements Listener {
    EpicItems plugin;
    FileConfiguration config;

    public BonemerangEvent(EpicItems plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        final Player player = event.getPlayer();
        if (this.config.getBoolean("Bonemerang", true) && event.getItem() != null && event.getItem().getItemMeta().hasLore() && event.getItem() != null && event.getItem().getItemMeta().getLore().contains("\u00a78EpicItem-Bonemerang")) {
            if (Cooldown.checkCooldown(event.getPlayer())) {
                try {
                    final ArmorStand as = (ArmorStand)player.getWorld().spawnEntity(player.getLocation(), EntityType.ARMOR_STAND);
                    Location destination = player.getLocation().add(player.getLocation().getDirection().multiply(10));
                    player.playSound(player.getLocation(), Sound.ENTITY_ZOMBIE_INFECT, 10.0f, 5.0f);
                    as.setArms(true);
                    as.setGravity(false);
                    as.setVisible(false);
                    as.setItemInHand(new ItemStack(Material.BONE));
                    as.setRightArmPose(new EulerAngle(Math.toRadians(0.0), Math.toRadians(120.0), Math.toRadians(0.0)));
                    player.getInventory().removeItem(new ItemStack[]{ItemManager.Bonemerang});
                    final Vector vector = destination.subtract(player.getLocation()).toVector();
                    Cooldown.setCooldown(event.getPlayer(), this.config.getInt("BonemerangCooldown"));
                    new BukkitRunnable(){
                        int distance = 60;
                        int i = 0;

                        public void run() {
                            EulerAngle rotation = as.getRightArmPose();
                            EulerAngle newrotation = rotation.add(0.0, 20.0, 0.0);
                            as.setRightArmPose(newrotation);
                            if (this.i >= this.distance) {
                                as.teleport(as.getLocation().subtract(vector.normalize()));
                                if (this.i >= this.distance * 2) {
                                    as.remove();
                                    player.getInventory().addItem(new ItemStack[]{ItemManager.Bonemerang});
                                    this.cancel();
                                }
                            } else {
                                as.teleport(as.getLocation().add(vector.normalize()));
                                as.setArms(as.hasArms());
                            }
                            ++this.i;
                            for (Entity entity : as.getLocation().getChunk().getEntities()) {
                                if (!(as.getLocation().distanceSquared(entity.getLocation()) < 1.0) || entity == player) continue;
                                LivingEntity livingEntity = (LivingEntity)entity;
                                livingEntity.damage(BonemerangEvent.this.config.getDouble("bonemerangDamage"), (Entity)player);
                            }
                        }
                    }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
                    event.setCancelled(true);
                }
                catch (NullPointerException exception) {
                    Bukkit.getConsoleSender().sendMessage(ChatColor.AQUA + "[EpicItems] " + ChatColor.RED + "An error occured, please report this here with a screenshot of the error: " + ChatColor.BLUE + "https://dsc.gg/arace863");
                    exception.printStackTrace();
                }
            } else {
                player.sendMessage(ChatColor.RED + "This is on cooldown for " + Math.round((Cooldown.cooldowns.get(player.getUniqueId()) - (double)System.currentTimeMillis()) / 1000.0) + "s.");
            }
        }
    }

    @EventHandler
    public void onEntity(PlayerInteractAtEntityEvent event) {
        ArmorStand as;
        if (this.config.getBoolean("Bonemerang", true) && event.getRightClicked() instanceof ArmorStand && (as = (ArmorStand)event.getRightClicked()).getItemInHand().getType().equals((Object)Material.BONE)) {
            event.setCancelled(true);
        }
    }
}

