/*
 * Decompiled with CFR 0.152.
 */
package me.genplew.plugins.cclogger;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import me.genplew.plugins.cclogger.CCLogger;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class LoginLogger
implements Listener {
    private CCLogger plugin;

    public LoginLogger(CCLogger plugins) {
        plugins.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugins);
        this.plugin = plugins;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) throws IOException {
        Player player = event.getPlayer();
        String name = player.getName();
        String ipAddress = player.getAddress().getAddress().getHostAddress();
        String date = this.getDate();
        this.processInformationJoin(name, date, ipAddress);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerQuit(PlayerQuitEvent event) throws IOException {
        Player player = event.getPlayer();
        String name = player.getName();
        String ipAddress = player.getAddress().getAddress().getHostAddress();
        String date = this.getDate();
        this.processInformationQuit(name, date, ipAddress);
    }

    public String getDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:MM:ss");
        Date date = new Date();
        return dateFormat.format(date);
    }

    public void processInformationJoin(String playerName, String date, String ipAddress) {
        File chatFile = new File(this.plugin.getDataFolder(), "login.log");
        String[] log = new String[]{"[" + ipAddress + "]" + "[" + date + "] " + playerName + " connected."};
        this.plugin.writer.writeFile(log, chatFile);
    }

    public void processInformationQuit(String playerName, String date, String ipAddress) {
        File chatFile = new File(this.plugin.getDataFolder(), "login.log");
        String[] log = new String[]{"[" + ipAddress + "]" + "[" + date + "] " + playerName + " disconnected."};
        this.plugin.writer.writeFile(log, chatFile);
    }
}

