/*
 * Decompiled with CFR 0.152.
 */
package me.genplew.plugins.cclogger;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import me.genplew.plugins.cclogger.CCLogger;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ChatLogger
implements Listener {
    private CCLogger plugin;

    public ChatLogger(CCLogger plugins) {
        plugins.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugins);
        this.plugin = plugins;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) throws IOException {
        Player player = event.getPlayer();
        String name = player.getName();
        String message = event.getMessage();
        Location location = player.getLocation();
        int xLocation = (int)location.getX();
        int yLocation = (int)location.getY();
        int zLocation = (int)location.getZ();
        World world = location.getWorld();
        String ipAddress = player.getAddress().getAddress().getHostAddress();
        String worldName = world.getName();
        String date = this.getDate();
        this.processInformation(player, name, message, xLocation, yLocation, zLocation, worldName, date, ipAddress);
    }

    public void processInformation(Player player, String playerName, String content, int x, int y, int z, String worldName, String date, String ipAddress) {
        File chatFile = new File(this.plugin.getDataFolder(), "chat.log");
        this.plugin.writer.writeFile(this.formatLog(playerName, content, x, y, z, worldName, date, ipAddress), chatFile);
    }

    public String[] formatLog(String playerName, String command, int x, int y, int z, String worldName, String date, String ipAddress) {
        String log = "[%ip][%date (%world: %x,%y,%z)] %name: %content";
        log = log.replaceAll("%ip", ipAddress);
        log = log.replaceAll("%date", date);
        log = log.replaceAll("%world", worldName);
        log = log.replaceAll("%x", Integer.toString(x));
        log = log.replaceAll("%y", Integer.toString(y));
        log = log.replaceAll("%z", Integer.toString(z));
        log = log.replaceAll("%name", playerName);
        log = log.replaceAll("%content", Matcher.quoteReplacement(command));
        String[] logArray = new String[]{log};
        return logArray;
    }

    public String getDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:MM:ss");
        Date date = new Date();
        return dateFormat.format(date);
    }
}

