/*
 * Decompiled with CFR 0.152.
 */
package me.akagiant.simplejoin.Commands;

import java.util.ArrayList;
import me.akagiant.simplejoin.SimpleJoin;
import net.md_5.bungee.api.ChatColor;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SimpleJoinCMD
implements CommandExecutor {
    SimpleJoin plugin;
    public boolean hasPapi;

    public SimpleJoinCMD(SimpleJoin instance) {
        this.plugin = instance;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, String cmdName, String[] args) {
        boolean bl = this.hasPapi = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
        if (cmdName.equalsIgnoreCase("SimpleJoin")) {
            if (!(sender instanceof Player)) {
                for (String msg : SimpleJoin.dConfig.getConfig().getStringList("console-response")) {
                    sender.sendMessage(msg);
                }
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("simplejoin.reload")) {
                for (String msg : SimpleJoin.dConfig.getConfig().getStringList("no-permission")) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
                }
                return true;
            }
            if (args.length == 0) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&cUsage: /simplejoin reload"));
                return true;
            }
            switch (args[0].toLowerCase()) {
                case "reload": {
                    SimpleJoin.formatMsg(player, "reload-message", false, this.hasPapi);
                    SimpleJoin.dConfig.reloadConfig();
                    break;
                }
                case "join": {
                    if (!player.hasPermission("simplejoin.forceJoin")) {
                        SimpleJoin.formatMsg(player, "no-permission", false, this.hasPapi);
                        return true;
                    }
                    if (args.length < 2) break;
                    SimpleJoin.formatMsg(player, "joinLeaveGroups." + args[1] + ".joinMessage", false, this.hasPapi);
                    break;
                }
                case "leave": {
                    if (!player.hasPermission("simplejoin.forceJoin")) {
                        SimpleJoin.formatMsg(player, "no-permission", false, this.hasPapi);
                        return true;
                    }
                    if (args.length < 2) break;
                    SimpleJoin.formatMsg(player, "joinLeaveGroups." + args[1] + ".leaveMessage", false, this.hasPapi);
                    break;
                }
                case "firstjoin": {
                    if (!player.hasPermission("simplejoin.forceFirstJoin")) {
                        SimpleJoin.formatMsg(player, "no-permission", false, this.hasPapi);
                        return true;
                    }
                    SimpleJoin.formatMsg(player, "joinLeaveSettings.firstJoin.message", false, this.hasPapi);
                    break;
                }
                default: {
                    ArrayList<String> arguments = new ArrayList<String>();
                    arguments.add("reload");
                    arguments.add("join");
                    arguments.add("leave");
                    arguments.add("firstJoin");
                    String message = StringUtils.join(arguments, (String)"/");
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&cUsage: /simplejoin <" + message + ">")));
                }
            }
            return true;
        }
        return false;
    }
}

