/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.world;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;

public enum WorldType {
    NORMAL(World.Environment.NORMAL, true),
    FLAT(World.Environment.CUSTOM, true),
    END(World.Environment.THE_END, false),
    NETHER(World.Environment.NETHER, false),
    VOID(World.Environment.CUSTOM, true);

    private final World.Environment environment;
    private final boolean overWorld;

    private WorldType(World.Environment environment, boolean overWorld) {
        this.environment = environment;
        this.overWorld = overWorld;
    }

    public static WorldType getByEnvironment(World.Environment environment) {
        switch (environment) {
            case NETHER: {
                return NETHER;
            }
            case THE_END: {
                return END;
            }
        }
        return NORMAL;
    }

    public static List<String> toStringList() {
        ArrayList constants = Lists.newArrayList();
        for (WorldType type : WorldType.values()) {
            constants.add(type.name());
        }
        return constants;
    }

    public World.Environment getEnvironment() {
        return this.environment;
    }

    public boolean isOverWorld() {
        return this.overWorld;
    }
}

