/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.world;

import com.dev7ex.common.bukkit.plugin.service.PluginService;
import com.dev7ex.multiworld.MultiWorldConfiguration;
import com.dev7ex.multiworld.world.WorldConfiguration;
import com.dev7ex.multiworld.world.WorldManager;
import com.dev7ex.multiworld.world.WorldProperties;
import com.dev7ex.multiworld.world.WorldType;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public final class WorldService
implements PluginService {
    private final WorldConfiguration worldConfiguration;
    private final WorldManager worldManager;
    private final MultiWorldConfiguration configuration;

    public WorldService(WorldManager worldManager, WorldConfiguration worldConfiguration) {
        this.worldManager = worldManager;
        this.worldConfiguration = worldConfiguration;
        this.configuration = worldManager.getConfiguration();
    }

    @Override
    public void onEnable() {
        for (World world : Bukkit.getWorlds()) {
            if (this.worldConfiguration.isWorldRegistered(world.getName())) continue;
            this.worldManager.importWorld((CommandSender)Bukkit.getConsoleSender(), world.getName(), WorldType.getByEnvironment(world.getEnvironment()));
        }
        for (String string : this.configuration.getAutoLoadableWorlds()) {
            if (!this.worldConfiguration.isWorldRegistered(string)) {
                Bukkit.getConsoleSender().sendMessage(this.configuration.getWorldMessage("loading.not-registered").replaceAll("%world%", string));
                continue;
            }
            this.worldManager.loadWorld((CommandSender)Bukkit.getConsoleSender(), string);
        }
        for (String string : this.worldConfiguration.getWorlds()) {
            WorldProperties worldProperties = this.worldConfiguration.getWorldProperties(string);
            if (Bukkit.getWorld((String)string) != null) {
                World currentWorld = Bukkit.getWorld((String)string);
                currentWorld.setDifficulty(this.worldConfiguration.getWorldProperties(string).getDifficulty());
                worldProperties.setLoaded(true);
            }
            this.worldManager.getWorldProperties().put(string, worldProperties);
        }
    }

    @Override
    public void onDisable() {
        this.worldManager.getWorldProperties().clear();
    }
}

