/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.world;

import com.dev7ex.multiworld.world.WorldOption;
import com.dev7ex.multiworld.world.WorldType;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;

public final class WorldProperties {
    private final String worldName;
    private String worldCreator;
    private long creationTime;
    private long lastWorldInteraction;
    private boolean loaded;
    private WorldType worldType;
    private GameMode gameMode;
    private Difficulty difficulty;
    private boolean pvpEnabled;
    private boolean spawnAnimals;
    private boolean spawnMonsters;

    public WorldProperties(String worldName, String worldCreator, long creationTime, long lastWorldInteraction, WorldType worldType, Difficulty difficulty, GameMode gameMode, boolean pvpEnabled, boolean spawnAnimals, boolean spawnMonsters) {
        this.worldName = worldName;
        this.worldCreator = worldCreator;
        this.creationTime = creationTime;
        this.lastWorldInteraction = lastWorldInteraction;
        this.worldType = worldType;
        this.difficulty = difficulty;
        this.gameMode = gameMode;
        this.pvpEnabled = pvpEnabled;
    }

    public void updateWorldOption(WorldOption worldOption, String value) {
        switch (worldOption) {
            case PVP: {
                this.pvpEnabled = Boolean.parseBoolean(value);
                break;
            }
            case GAME_MODE: {
                this.gameMode = GameMode.valueOf((String)String.valueOf(value));
                break;
            }
            case DIFFICULTY: {
                this.difficulty = Difficulty.valueOf((String)String.valueOf(value));
                if (!this.loaded) break;
                Objects.requireNonNull(Bukkit.getWorld((String)this.worldName)).setDifficulty(this.difficulty);
                break;
            }
            case SPAWN_ANIMALS: {
                this.spawnAnimals = Boolean.parseBoolean(value);
                if (!this.loaded) break;
                Objects.requireNonNull(Bukkit.getWorld((String)this.worldName)).setSpawnFlags(this.spawnMonsters, this.spawnAnimals);
                break;
            }
            case SPAWN_MONSTERS: {
                this.spawnMonsters = Boolean.parseBoolean(value);
                if (!this.loaded) break;
                Objects.requireNonNull(Bukkit.getWorld((String)this.worldName)).setSpawnFlags(this.spawnMonsters, this.spawnAnimals);
                break;
            }
            case WORLD_TYPE: {
                this.worldType = WorldType.valueOf(String.valueOf(value));
            }
        }
    }

    public String formatCreationDate(long value) {
        return new SimpleDateFormat("dd.MM.yyyy").format(new Date(value));
    }

    public String getWorldName() {
        return this.worldName;
    }

    public String getWorldCreator() {
        return this.worldCreator;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastWorldInteraction() {
        return this.lastWorldInteraction;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public WorldType getWorldType() {
        return this.worldType;
    }

    public GameMode getGameMode() {
        return this.gameMode;
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public boolean isPvpEnabled() {
        return this.pvpEnabled;
    }

    public boolean isSpawnAnimals() {
        return this.spawnAnimals;
    }

    public boolean isSpawnMonsters() {
        return this.spawnMonsters;
    }

    public void setWorldCreator(String worldCreator) {
        this.worldCreator = worldCreator;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public void setLastWorldInteraction(long lastWorldInteraction) {
        this.lastWorldInteraction = lastWorldInteraction;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public void setWorldType(WorldType worldType) {
        this.worldType = worldType;
    }

    public void setGameMode(GameMode gameMode) {
        this.gameMode = gameMode;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    public void setPvpEnabled(boolean pvpEnabled) {
        this.pvpEnabled = pvpEnabled;
    }

    public void setSpawnAnimals(boolean spawnAnimals) {
        this.spawnAnimals = spawnAnimals;
    }

    public void setSpawnMonsters(boolean spawnMonsters) {
        this.spawnMonsters = spawnMonsters;
    }
}

