/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.world;

import com.dev7ex.multiworld.world.WorldType;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public enum WorldOption {
    SPAWN_MONSTERS("spawn-monsters", Lists.newArrayList((Object[])new String[]{"false", "true"})),
    SPAWN_ANIMALS("spawn-animals", Lists.newArrayList((Object[])new String[]{"false", "true"})),
    GAME_MODE("game-mode", Lists.newArrayList((Object[])new String[]{"ADVENTURE", "CREATIVE", "SURVIVAL", "SPECTATOR"})),
    PVP("pvp-enabled", Lists.newArrayList((Object[])new String[]{"false", "true"})),
    DIFFICULTY("difficulty", Lists.newArrayList((Object[])new String[]{"EASY", "HARD", "NORMAL", "PEACEFUL"})),
    WORLD_TYPE("world-type", WorldType.toStringList());

    private final String configEntry;
    private final List<String> values;

    private WorldOption(String configEntry, List<String> values) {
        this.configEntry = configEntry;
        this.values = values;
    }

    public static List<String> toStringList() {
        ArrayList constants = Lists.newArrayList();
        for (WorldOption option : WorldOption.values()) {
            constants.add(option.name());
        }
        return constants;
    }

    public String getConfigEntry() {
        return this.configEntry;
    }

    public List<String> getValues() {
        return this.values;
    }
}

