/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.world;

import com.dev7ex.multiworld.MultiWorldConfiguration;
import com.dev7ex.multiworld.MultiWorldPlugin;
import com.dev7ex.multiworld.generator.FlatChunkGenerator;
import com.dev7ex.multiworld.generator.VoidChunkGenerator;
import com.dev7ex.multiworld.user.WorldUser;
import com.dev7ex.multiworld.user.WorldUserProperties;
import com.dev7ex.multiworld.user.WorldUserService;
import com.dev7ex.multiworld.world.WorldConfiguration;
import com.dev7ex.multiworld.world.WorldProperties;
import com.dev7ex.multiworld.world.WorldType;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.generator.ChunkGenerator;

public final class WorldManager {
    private boolean serverCreatingWorld = false;
    private boolean serverDeletingWorld = false;
    private final Map<String, WorldProperties> worldProperties = Maps.newHashMap();
    private final WorldConfiguration worldConfiguration;
    private final WorldUserService worldUserService;
    private final MultiWorldConfiguration configuration;

    public WorldManager(MultiWorldConfiguration configuration, WorldConfiguration worldConfiguration, WorldUserService worldUserService) {
        this.configuration = configuration;
        this.worldConfiguration = worldConfiguration;
        this.worldUserService = worldUserService;
    }

    public void createWorld(CommandSender commandSender, String worldName, WorldType worldType) {
        WorldCreator worldCreator = new WorldCreator(worldName);
        switch (worldType) {
            case FLAT: {
                worldCreator.generator((ChunkGenerator)new FlatChunkGenerator());
                break;
            }
            case NETHER: {
                worldCreator.environment(World.Environment.NETHER);
                break;
            }
            case END: {
                worldCreator.environment(World.Environment.THE_END);
                break;
            }
            case VOID: {
                worldCreator.generator((ChunkGenerator)new VoidChunkGenerator());
                break;
            }
            default: {
                worldCreator.type(org.bukkit.WorldType.NORMAL);
            }
        }
        this.serverCreatingWorld = true;
        commandSender.sendMessage(this.configuration.getWorldMessage("create.starting").replaceAll("%world%", worldName));
        WorldProperties worldProperties = new WorldProperties(worldName, commandSender.getName(), System.currentTimeMillis(), System.currentTimeMillis(), worldType, Difficulty.valueOf((String)this.configuration.getValues().getString("defaults.difficulty")), GameMode.valueOf((String)this.configuration.getValues().getString("defaults.gameMode")), this.configuration.getValues().getBoolean("defaults.pvp-enabled"), this.configuration.getValues().getBoolean("defaults.spawn-animals", false), this.configuration.getValues().getBoolean("defaults.spawn-monsters", false));
        World world = worldCreator.createWorld();
        commandSender.sendMessage(this.configuration.getWorldMessage("create.finished").replaceAll("%world%", worldName));
        worldProperties.setLoaded(true);
        world.setDifficulty(worldProperties.getDifficulty());
        this.worldConfiguration.registerWorld(worldName, worldProperties);
        this.worldProperties.put(worldName, worldProperties);
        this.serverCreatingWorld = false;
    }

    public void unloadWorld(CommandSender commandSender, String worldName) {
        World world = Bukkit.getWorld((String)worldName);
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getWorld().getName().equalsIgnoreCase(worldName)) continue;
            player.sendMessage(this.configuration.getWorldMessage("unloading.chunk-teleport").replaceAll("%world%", worldName));
            player.teleport(Bukkit.getWorld((String)MultiWorldPlugin.getInstance().getConfiguration().getDefaultWorldName()).getSpawnLocation());
        }
        commandSender.sendMessage(this.configuration.getWorldMessage("unloading.chunk-starting").replaceAll("%world%", worldName));
        Arrays.stream(world.getLoadedChunks()).forEach(Chunk::unload);
        commandSender.sendMessage(this.configuration.getWorldMessage("unloading.chunk-finished").replaceAll("%world%", worldName));
        commandSender.sendMessage(this.configuration.getWorldMessage("unloading.starting").replaceAll("%world%", worldName));
        Bukkit.unloadWorld((String)world.getName(), (boolean)true);
        commandSender.sendMessage(this.configuration.getWorldMessage("unloading.finished").replaceAll("%world%", worldName));
        this.worldProperties.get(worldName).setLoaded(false);
    }

    public void deleteWorld(CommandSender commandSender, String worldName) {
        this.serverDeletingWorld = true;
        commandSender.sendMessage(this.configuration.getWorldMessage("delete.starting").replaceAll("%world%", worldName));
        if (Bukkit.getWorld((String)worldName) != null) {
            this.unloadWorld(commandSender, worldName);
        }
        try {
            FileUtils.deleteDirectory(new File(Bukkit.getWorldContainer() + File.separator + worldName));
        }
        catch (IOException exception) {
            commandSender.sendMessage("\u00a7cAn error has occurred. View the logs");
            exception.printStackTrace();
            return;
        }
        this.worldConfiguration.unregisterWorld(worldName);
        this.worldProperties.remove(worldName);
        commandSender.sendMessage(this.configuration.getWorldMessage("delete.finished").replaceAll("%world%", worldName));
        this.serverDeletingWorld = false;
    }

    public void loadWorld(CommandSender commandSender, String worldName) {
        WorldProperties worldProperties = this.worldConfiguration.getWorldProperties(worldName);
        WorldCreator worldCreator = new WorldCreator(worldName);
        commandSender.sendMessage(this.configuration.getWorldMessage("loading.starting").replaceAll("%world%", worldName));
        if (!worldProperties.getWorldType().isOverWorld()) {
            worldCreator.environment(worldProperties.getWorldType().getEnvironment());
        }
        switch (worldProperties.getWorldType()) {
            case VOID: {
                worldCreator.generator((ChunkGenerator)new VoidChunkGenerator());
                break;
            }
            case FLAT: {
                worldCreator.generator((ChunkGenerator)new FlatChunkGenerator());
            }
        }
        World world = Bukkit.createWorld((WorldCreator)worldCreator);
        world.setDifficulty(worldProperties.getDifficulty());
        commandSender.sendMessage(this.configuration.getWorldMessage("loading.finished").replaceAll("%world%", worldName));
        worldProperties.setLoaded(true);
        this.worldProperties.put(worldName, worldProperties);
    }

    public void importWorld(CommandSender commandSender, String worldName, WorldType worldType) {
        commandSender.sendMessage(this.configuration.getWorldMessage("import.starting").replaceAll("%world%", worldName));
        WorldProperties worldProperties = new WorldProperties(worldName, commandSender.getName(), System.currentTimeMillis(), System.currentTimeMillis(), worldType, Difficulty.valueOf((String)this.configuration.getValues().getString("defaults.difficulty")), GameMode.valueOf((String)this.configuration.getValues().getString("defaults.gameMode")), this.configuration.getValues().getBoolean("defaults.pvp-enabled"), this.configuration.getValues().getBoolean("defaults.spawn-animals", false), this.configuration.getValues().getBoolean("defaults.spawn-monsters", false));
        this.worldConfiguration.registerWorld(worldName, worldProperties);
        this.worldProperties.put(worldName, worldProperties);
        commandSender.sendMessage(this.configuration.getWorldMessage("import.finished").replaceAll("%world%", worldName));
    }

    public void teleportWorld(CommandSender commandSender, Player target, Location teleportLocation) {
        WorldUser worldUser = this.worldUserService.getUsers().get(target.getUniqueId());
        WorldUserProperties userProperties = worldUser.getProperties();
        WorldProperties worldProperties = this.worldProperties.get(teleportLocation.getWorld().getName());
        userProperties.setLastWorld(target.getWorld().getName());
        userProperties.setLastWorldLocation(target.getLocation());
        target.teleport(teleportLocation);
        commandSender.sendMessage(this.configuration.getWorldMessage("teleport.message").replaceAll("%player%", target.getName()).replaceAll("%world%", teleportLocation.getWorld().getName()));
        worldProperties.setLastWorldInteraction(System.currentTimeMillis());
        this.worldConfiguration.updateLastWorldInteraction(worldProperties);
    }

    public void teleportWorld(Player target, Location teleportLocation) {
        WorldUser worldUser = this.worldUserService.getUsers().get(target.getUniqueId());
        WorldUserProperties userProperties = worldUser.getProperties();
        WorldProperties worldProperties = this.worldProperties.get(teleportLocation.getWorld().getName());
        userProperties.setLastWorld(target.getWorld().getName());
        userProperties.setLastWorldLocation(target.getLocation());
        target.teleport(teleportLocation);
        worldProperties.setLastWorldInteraction(System.currentTimeMillis());
        this.worldConfiguration.updateLastWorldInteraction(this.worldProperties.get(teleportLocation.getWorld().getName()));
    }

    public boolean isServerCreatingWorld() {
        return this.serverCreatingWorld;
    }

    public boolean isServerDeletingWorld() {
        return this.serverDeletingWorld;
    }

    public Map<String, WorldProperties> getWorldProperties() {
        return this.worldProperties;
    }

    public WorldConfiguration getWorldConfiguration() {
        return this.worldConfiguration;
    }

    public WorldUserService getWorldUserService() {
        return this.worldUserService;
    }

    public MultiWorldConfiguration getConfiguration() {
        return this.configuration;
    }
}

