/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.multiworld.world;

import com.dev7ex.common.bukkit.configuration.ConfigurationBase;
import com.dev7ex.common.bukkit.configuration.ConfigurationProperties;
import com.dev7ex.common.java.io.FileExtension;
import com.dev7ex.multiworld.world.WorldOption;
import com.dev7ex.multiworld.world.WorldProperties;
import com.dev7ex.multiworld.world.WorldType;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

@ConfigurationProperties(fileName="worlds", fileExtension=FileExtension.YAML)
public final class WorldConfiguration
extends ConfigurationBase {
    public WorldConfiguration(Plugin plugin) {
        super(plugin);
    }

    public void registerWorld(String worldName, WorldProperties worldProperties) {
        this.yamlConfiguration.set(worldName + ".creator", (Object)worldProperties.getWorldCreator());
        this.yamlConfiguration.set(worldName + ".creation-time", (Object)worldProperties.getCreationTime());
        this.yamlConfiguration.set(worldName + ".last-world-interaction", (Object)worldProperties.getLastWorldInteraction());
        this.yamlConfiguration.set(worldName + ".world-type", (Object)worldProperties.getWorldType().toString());
        this.yamlConfiguration.set(worldName + ".difficulty", (Object)worldProperties.getDifficulty().toString());
        this.yamlConfiguration.set(worldName + ".gameMode", (Object)worldProperties.getGameMode().toString());
        this.yamlConfiguration.set(worldName + ".pvp-enabled", (Object)worldProperties.isPvpEnabled());
        super.saveFile();
    }

    public void unregisterWorld(String worldName) {
        this.yamlConfiguration.set(worldName, null);
        super.saveFile();
    }

    public boolean isWorldRegistered(String worldName) {
        return this.yamlConfiguration.contains(worldName);
    }

    public WorldProperties getWorldProperties(String worldName) {
        String creator = this.yamlConfiguration.getString(worldName + ".creator");
        long creationTime = this.yamlConfiguration.getLong(worldName + ".creation-time");
        long lastWorldInteraction = this.yamlConfiguration.getLong(worldName + ".last-world-interaction");
        WorldType worldType = WorldType.valueOf(this.yamlConfiguration.getString(worldName + ".world-type"));
        Difficulty difficulty = Difficulty.valueOf((String)this.yamlConfiguration.getString(worldName + ".difficulty"));
        GameMode gameMode = GameMode.valueOf((String)this.yamlConfiguration.getString(worldName + ".gameMode"));
        boolean pvpEnabled = this.yamlConfiguration.getBoolean(worldName + ".pvp-enabled");
        boolean spawnAnimals = this.yamlConfiguration.getBoolean(worldName + "spawn-animals", false);
        boolean spawnMonsters = this.yamlConfiguration.getBoolean(worldName + "spawn-monsters", false);
        return new WorldProperties(worldName, creator, creationTime, lastWorldInteraction, worldType, difficulty, gameMode, pvpEnabled, spawnAnimals, spawnMonsters);
    }

    public void updateWorldOption(String worldName, WorldOption worldOption, String value) {
        this.yamlConfiguration.set(worldName + "." + worldOption.getConfigEntry(), (Object)value);
        super.saveFile();
    }

    public void updateLastWorldInteraction(WorldProperties worldProperties) {
        this.yamlConfiguration.set(worldProperties.getWorldName() + ".last-world-interaction", (Object)worldProperties.getLastWorldInteraction());
        super.saveFile();
    }

    public Map<String, WorldProperties> getWorldProperties() {
        HashMap worlds = Maps.newHashMap();
        for (String world : this.yamlConfiguration.getKeys(false)) {
            ConfigurationSection section = this.yamlConfiguration.getConfigurationSection(world);
            String creator = section.getString("creator");
            long creationTime = section.getLong("creation-time");
            long lastWorldInteraction = section.getLong("last-world-interaction");
            WorldType worldType = WorldType.valueOf(section.getString("world-type"));
            Difficulty difficulty = Difficulty.valueOf((String)section.getString("difficulty"));
            GameMode gameMode = GameMode.valueOf((String)section.getString("gameMode"));
            boolean pvpEnabled = section.getBoolean("pvp-enabled");
            boolean spawnAnimals = section.getBoolean("spawn-animals", false);
            boolean spawnMonsters = section.getBoolean("spawn-monsters", false);
            worlds.put(world, new WorldProperties(world, creator, creationTime, lastWorldInteraction, worldType, difficulty, gameMode, pvpEnabled, spawnAnimals, spawnMonsters));
        }
        return worlds;
    }

    public Set<String> getWorlds() {
        return this.yamlConfiguration.getKeys(false);
    }
}

